unit rtfparse;

{ version 1.1
  (c) Pavel Zampach, 2004
  source text for Turbo Pascal compiler
}

interface

var
  startGroup  : procedure (Level : integer);
  endGroup    : procedure (Level : integer);
  controlWord : procedure (CW, CWP : string);
  textChar    : procedure (c : char);
  specChar    : procedure (c : char);
  errorHandle : procedure (msg : string);

procedure parse (FName : string);
procedure skipGroup;

{******************************************************************}

implementation

var
  MarkStack, SIndex  : integer;
  Status : (StBasic, StBackslash, StCtrlWord, StCWParam, StSkipGroup);

{------------------------------------------------------------------}

function hex2num (cc : char) : byte;

begin
  if cc in ['0' .. '9'] then hex2num := ord (cc) - 48;
  if cc in ['a' .. 'f'] then hex2num := ord (cc) - 87;
  if cc in ['A' .. 'F'] then hex2num := ord (cc) - 55;
end;

{------------------------------------------------------------------}

procedure parse (FName : string);

const
  BUFSIZE = 1024; 

var
  IFile   : file;
  CW, CWP : string;
  c       : char;
  Buffer  : array [1 .. BUFSIZE] of char; 
  Idx, Result : integer;
  ReadAllowed, ReadLoop : boolean;

{---------------------------}

function readChar : char;
begin
  if Idx >= Result then begin
    blockRead (IFile, Buffer, BUFSIZE, Result);
    if Result = 0 then
      errorHandle ('Unexpected end of RTF file');
    Idx := 0;
  end;
  inc (Idx);
  readChar := Buffer [Idx];
end; 

{---------------------------}

begin  {procedure parse}
  ReadAllowed := true;
  ReadLoop    := true;
  Status      := StBasic;
  SIndex      := 0;
  Idx         := 0;
  Result      := 0;
  
  assign (IFile, FName);
{$I-}
  reset (IFile, 1);
{$I+}
  if IOResult <> 0 then
    errorHandle (FName + ' can''t be open!');

  while ReadLoop do begin
    if ReadAllowed then c := readChar
                   else ReadAllowed := true;
  
    case Status of

      StBasic :         { reading char }
      case c of 
        '{' : begin
          inc (SIndex);
          startGroup (SIndex);
        end;
        '}' : begin
          dec (SIndex);
          endGroup (SIndex);
          ReadLoop := (SIndex > 0);
        end;
        '\' : Status := StBackSlash;
        #$09 : controlWord ('tab', '');
        #$20 .. #$FF : textChar (c);
      end;
      
      StBackSlash :     { "\" was read }
      begin
        Status := StBasic;
        case c of
          '{', '}', '\'                : textChar (c);
          '|', '~', '-', '_', ':', '*' : specChar (c);
          #$0A, #$0D                   : controlWord ('par', '');
          '''' : textChar (chr (hex2num (readChar) + $10 * hex2num (readChar)));
          'a' .. 'z' : begin
            Status := StCtrlWord;
            CW     := c;
            CWP    := '';
          end;
        end; {case c}
      end;

      StCtrlWord :      { control word reading }
      case c of
        'a' .. 'z'      : CW := CW + c;
        '-', '0' .. '9' : begin
          Status := StCWParam;
          CWP := c;
        end
        else begin
          Status := StBasic;  
          ReadAllowed := (c = ' ');
          controlWord (CW, CWP);
        end;
      end;

      StCWParam :       { control word parameter reading }
      if c in ['0' .. '9'] then
        CWP := CWP + c
      else begin
        Status := StBasic;  
        ReadAllowed := (c = ' ');
        controlWord (CW, CWP);
      end;

      StSkipGroup :     { unprocess group, skip all } 
      begin
        if c = '{' then
          inc (SIndex);
        if c = '}' then begin
          dec (SIndex);
          if SIndex = MarkStack then begin
            Status := StBasic;
            endGroup (SIndex);
          end;  
        end;
      end;

    end; {case}

  end; {while}

  close (IFile);

end; {proc parse}

{------------------------------------------------------------------}

procedure skipGroup;

begin
  MarkStack := SIndex - 1;
  Status := StSkipGroup;
end;

{------------------------------------------------------------------}

procedure nop1 (Level : integer); far;
begin
end;

procedure nop2 (CW, CWP : string); far;
begin
end;

procedure nop3 (c : char); far;
begin
end;

procedure nop4 (msg : string); far;
begin
end;

{------------------------------------------------------------------}

begin  
  startGroup    := nop1;
  endGroup      := nop1;
  controlWord   := nop2;
  textChar      := nop3;
  specChar      := nop3;
  errorHandle   := nop4;
end.