/* I don't know if it's a correct way to write code as I have done in
   this header file. But it works fine! In order to get a Hourglass in
   your EXM applications, #include "hourglas.h" and when you need to
   switch on the Hourglass, you just call "HourGlassOn();" and switch
   it off "HourGlassOff();" (without quotes) from within your source 
   code. This code assume that we always want to place the Hourglass
   in the center of the screen. If you want to change that, please
   do it further down in this code. */

#include <dos.h>

void far GetImg(int x1, int y1, int x2, int y2);
void far PutImg(int xpos, int ypos, int rule, UCHAR *buf);
void far HourGlassOn(void);
void far HourGlassOff(void);

#define SCREENWIDTH     640
#define SCREENHIGHT     200
#define HOURGLASSWIDTH   24
#define HOURGLASSHIGHT   27

/* rules for graphic write pixel */
#define G_FORCE    0
#define G_AND      1
#define G_OR       2
#define G_XOR      3
#define G_NOTFORCE 4
#define G_NOTAND   5
#define G_NOTOR    6
#define G_NOTXOR   7

UCHAR CapBitmap[] = { /* Empty field for the captured bitmap-
                         can do this since the size is known. */
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

UCHAR HOURGLASS[] = { /* The icon of the Hourglass. */
 0x01,0x00,0x01,0x00,0x19,0x00,0x1c,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x3f,0xff,0xfe,0x00,0x3f,0xff,0xfe,0x00,
 0x10,0x00,0x04,0x00,0x10,0x00,0x04,0x00,0x10,0x00,0x04,0x00,
 0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x05,0xff,0xd0,0x00,
 0x02,0x7f,0x20,0x00,0x01,0x9c,0xc0,0x00,0x00,0x6b,0x00,0x00,
 0x00,0x14,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x63,0x00,0x00,
 0x01,0x88,0xc0,0x00,0x02,0x08,0x20,0x00,0x04,0x08,0x10,0x00,
 0x08,0x1c,0x08,0x00,0x08,0x7f,0x08,0x00,0x11,0xff,0xc4,0x00,
 0x13,0xff,0xe4,0x00,0x10,0x00,0x04,0x00,0x3f,0xff,0xfe,0x00,
 0x3f,0xff,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

UCHAR HOURGLASSMASK[] = { /* The icon of a mask to the Hourglass. */
 0x01,0x00,0x01,0x00,0x19,0x00,0x1c,0x00,0xff,0xff,0xff,0x80,
 0xff,0xff,0xff,0x80,0xff,0xff,0xff,0x80,0xff,0xff,0xff,0x80,
 0xff,0xff,0xff,0x80,0xff,0xff,0xff,0x80,0x7f,0xff,0xff,0x00,
 0x7f,0xff,0xff,0x00,0x7f,0xff,0xff,0x00,0x3f,0xff,0xfe,0x00,
 0x3f,0xff,0xfe,0x00,0x1f,0xff,0xfc,0x00,0x0f,0xff,0xf8,0x00,
 0x07,0xff,0xf0,0x00,0x07,0xff,0xf0,0x00,0x0f,0xff,0xf8,0x00,
 0x1f,0xff,0xfc,0x00,0x3f,0xff,0xfe,0x00,0x3f,0xff,0xfe,0x00,
 0x7f,0xff,0xff,0x00,0x7f,0xff,0xff,0x00,0x7f,0xff,0xff,0x00,
 0xff,0xff,0xff,0x80,0xff,0xff,0xff,0x80,0xff,0xff,0xff,0x80,
 0xff,0xff,0xff,0x80,0xff,0xff,0xff,0x80,0xff,0xff,0xff,0x80,
};


/* ======================================
   GetImg Function- Capture a part of the
   screen as an image- UCHAR *CapBitmap;
   ====================================== */
void far GetImg(int x1, int y1, int x2, int y2)
{
/* The concept of GetImg is comming from PAL's GetImg-
   Thank you Harry Konstas/Gilles Kohl/Thomas Krug! */
 
 #define PARAM(ptr) (*((WORD *)((BYTE *)(ptr)+1)))
 void (far *Vector)(void);

 static BYTE get_asm[] = {
        0x06,
        0x60,
        0xB9, 0x00, 0x00,
        0xBA, 0x00, 0x00,
        0xBE, 0x00, 0x00,
        0xBD, 0x00, 0x00,
        0xBF, 0x00, 0x00,
        0xB8, 0x00, 0x00,
        0x8E, 0xC0,
        0xB8, 0x00, 0x0d,
        0xCD, 0x5F,
        0x61,
        0x07,
        0xCB
       };

 PARAM(get_asm + 2) = x1;
 PARAM(get_asm + 5) = y1;
 PARAM(get_asm + 8) = x2;
 PARAM(get_asm +11) = y2;
 PARAM(get_asm +14) = FP_OFF(CapBitmap);
 PARAM(get_asm +17) = FP_SEG(CapBitmap);

 Vector = (void (far *)(void))get_asm;
 (*Vector)();
}


/* ======================================
   PutImg Function- Puts an image on the
   screen.
   ====================================== */
void far PutImg(int xpos, int ypos, int rule, UCHAR *buf)
{
 struct REGPACK regs;

 regs.r_ax=0x0E00+rule;
 regs.r_cx=xpos;
 regs.r_dx=ypos;
 regs.r_di=(UINT)buf;
 regs.r_es=_DS;
 intr(0x5f, &regs);
}


/* ======================================
   Put the Hour Glass on the screen.
   ====================================== */
void far HourGlassOn(void)
{
 int x, y;

 /* This will put the icon in the middle of the screen: */
 x = (SCREENWIDTH / 2) - (HOURGLASSWIDTH / 2); 
 y = (SCREENHIGHT / 2) - (HOURGLASSHIGHT / 2);

 /* First we capture the current area where the Hourglass
    will be displayed. This so we can restore it later
    when we want to remove the Hourglass: */
 GetImg(x, y, x + HOURGLASSWIDTH, y + HOURGLASSHIGHT);

 /* With this method, we get a nice Hourglass even 
    over existing text/graphics- following the shape
    of the hourglass, but with an extra small margin-
    easier to see over text/graphics: */ 
 PutImg(x, y, G_NOTAND, HOURGLASSMASK);
 PutImg(x, y, G_XOR   , HOURGLASS);
}

/* ======================================
   Remove the Hour Glass on the screen.
   ====================================== */
void far HourGlassOff(void)
{
 int x, y;

 /* This will put Captured Bitmap in the middle of the screen: */
 x = (SCREENWIDTH / 2) - (HOURGLASSWIDTH / 2); 
 y = (SCREENHIGHT / 2) - (HOURGLASSHIGHT / 2);

 PutImg(x, y, G_FORCE , CapBitmap);
}


