/******* Third party interface sample program for WordPerfect 6.0 *******

TABS EVERY 4 SPACES
*************************************************************************/

#include <dos.h>
#include <process.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "tpi60.h"			/* contains defines */
#include "intr60.h"			/* used to interface with intr60.asm */

/* global variables */
unsigned int C_stkseg;		/* stack segment of C routines */
unsigned int C_stkptr;		/* stack pointer of C routines */
unsigned int WP_SSreg;      /* WP's Stack segment */
unsigned int WP_SPreg;      /* WP's Stack pointer */
unsigned char far *thrd_param_buf;/* used to return a third party parameter
							buffer to WP */
unsigned char record_flg = 0;/* used to toggle the recorder on and off */

/* macros to run from the TP interface */
char macro_font[]="font";  	/* font macro name */
char macro_print[]="print"; /* print macro name */
char macro_pres[]="altm";	/* goto presentations test macro */
char macro_fileopen[]="fileopen";/* retrieve macro name */
char macro_tpi[]="tpimac"; /* tpimac macro name */

int	userflg = 0;			/* UserFunction flag for font macro */
unsigned char third_buffer[BUF_SIZE]; /* third party buffer mem */


/* TPI string variables to set */
char MergeVar[]="tpivar";	/* tpi variable to get or set */
char MergeVarStr[]="tpistr";/* tpi variable to set for fileopen macro */	
char MergeVarRettkn[]="rettkn"; /* tpi variable to set for fileopen macro */

/* character string to save as the contents of "tpistr" merge var */
char szTpiStrtxt[]=" - TPI Trapped Token #: ";

int iFirstFlg = 0;	// used for sending back for null token.
int iFlgCntr = 0;
unsigned char szTypeTpiVarBuf[BUF_SIZE] = {
			0x01, _t_, 0x00, _y_, 0x00, _p_, 0x00, _e_, 0x00, _Lt_Paren, 
			0x00, _Rt_Paren, 0x00, _Space, 0x00, _f_, 0x00, _r_, 0x00, _o_, 
			0x00, _m_, 0x00, _Space, 0x00, _T_, 0x00, _P_, 0x00, _I_, 0x00, 
			0x00, 0x00};

int iTypetpibuflen = 33;

/* These are global variables for getting system variables and for getting and 
setting merge vars.  These variables need to have the same segment address 
for the routine WPCall (in intr60.asm) to work correctly. */
unsigned char WPServ;				/* WP service to use */
unsigned int  WPSysvar;				/* WP system variable to get */
unsigned char WPRetBuf[RET_BUFSIZ]; /* 8 byte return buffer for retrieving data
						from system and merge variables from WP.  this is also 
						used to save data to a merge variable.*/
unsigned int  WPMrgvar[BUF_SIZE];	/* buffer to merge variable name.  This is
						used for getting and setting a specific merge variable 
						name */
unsigned char WPValType;		/* data type to send to or receive from WP
								variables */
unsigned int WPStrToRet[BUF_SIZE]; /* buffer used to save a word string to 
						to a WP merge variable */

/*************************************************************************
name: main
in:	none
out:	none
ret:	none
*************************************************************************/
void main()
{
	init_3rd();
	run_wp();
	rest_3rd();

}/* end of main() */

/*************************************************************************
name:	Ckey_handler()
in:	ax = keystroke or 0
out: ax = keystroke or 0
ret: none
NOTES: this routine is called by WP6.0 while in a dialog
*************************************************************************/

void far Ckey_handler(unsigned int far *ax_reg)
{
unsigned char szVarBuf[RET_BUFSIZ];	/* return buffer for variable*/
unsigned char cValType;
unsigned int SysVarNum;

//	if(*ax_reg == 57504){
			SysVarNum = 46;		/* get ?printprogress */
			GetSysVar(SysVarNum, szVarBuf, &cValType);
//	}/* end of if() statement */

}/* end of Ckey_handler() routine */

/*************************************************************************
name:	Crecord_handler
purpose: to see what token WP6.0 just finished processing.
in:	ax = token
	es:bx -> buffer or bx = -1
out: NONE (tokens can't be modified from this handler)
ret: none
NOTES: this routine is a monitor routine to find out what WP6.0 actually
did.  For example, after WP6.0 processes the "type('test')" token
then this routine will be called to let you know what was done.  In this case
*ax_reg would equal dec 170, and *WP_parambuf = 01, "t", null, "e", null, "s",
null, "t", null, null, null.

When returning from this routine ALL registers MUST be restored, and data must
be unmodified.  This is NOT the routine to modify data.  If you need to modify
a token the the Ctkn_handler must be used.
*************************************************************************/

void far Crec_handler(unsigned int far *ax_reg,
					unsigned int far *bx_reg,
					unsigned char far *WP_parambuf)
{

}/* end of Crec_handler() routine */

/*************************************************************************
name:	run_wp()
purpose: execute WP6.0.
in:	ax = keystroke or 0
out: ax = keystroke or 0
ret: none
NOTES: this routine is called by WP6.0 while in a dialog
*************************************************************************/
void run_wp(void)
{
	int result;
	result = spawnl(P_WAIT, "wp.exe", 0);
	if(result == -1)
		perror("Error From spawnl");

}/* end of run_wp() routine */


/*************************************************************************
name:	Ctkn_handler()
purpose: Main high level token handler for WP6.0.  This routine allows third
	partys to view and change tokens created by WP6.0.
in:	ax_reg = token value
	bx_reg = 0xFFFF if token has no parameters
	cx_reg = only used when returning a 3rd party token.  Then this equals
			the length of the third party token parameter buffer.
	*wp_param_buf = pointer to WP token parameter buffer
out:
	ax_reg = token to return to WP
	bx_reg = no meaning
	cx_reg = length of third party parameter buffer IF returning a buffer
	*wp_param_buf = pointer to WP parameter buffer
	*thrd_param_buf = pointer to 3rd party param buffer if exists, otherwise
				this should be NULL.
global variables:
	*thrd_param_buf = used to return third party parameter buffer; is NULL if
					 not returning a third party buffer
ret: none
NOTES: DON'T modify the WP parameter buffer.  es:bx must be changed to equal a
different address than WP_buf.  To return a 3rd party
parameter buffer, setup *thrd_param_buf to point to the parameter buffer. 
Then set *bx_reg to the offset of thrd_param_buf and *ex_reg to the segment of
thrd_param_buf.  Set *cx_reg to equal the length of the parameter buffer to
return.
*************************************************************************/

void far Ctkn_handler(	unsigned int far *ax_reg,
				unsigned int far *bx_reg,
				unsigned int far *cx_reg,
				unsigned int far *es_reg,
				unsigned char far *WP_buf)
{

unsigned int far *i3rd_bufptr;   	/* word pointer */
unsigned int *iIntptr;			/* word pointer */
unsigned int iIntStrBuf[BUF_SIZE];  /* word string */
unsigned char far *b3rd_bufptr;		/* byte pointer */
unsigned char szVarBuf[RET_BUFSIZ];	/* return buffer for variable*/
unsigned char cValType;
unsigned int SysVarNum;
int idx,idx2;
struct SREGS sr;		/* structure for getting segment registers */

/* this is for test the request routine calls in WP */
		SysVarNum = 46;		/* get ?printprogress */
		GetSysVar(SysVarNum, szVarBuf, &cValType);
/* end of code to test request routine calls within WP */


	switch(*ax_reg){
		case TYPECHAR:
			break;	/* just to look at typechar token */

		case RETRIEVE: /* shift-F10 */
			/* make word string for tpistr variable contents */
			MkIntStr(WPStrToRet, szTpiStrtxt); 
			/* make word string for "tpistr" variable name */
			MkIntStr(iIntStrBuf, MergeVarStr); 
			
			/* if to try to get a merge variable that doesn't exist then
			cValType will be 0 (zero) on return from the call to GetMrgVar */
			GetMrgVar(iIntStrBuf, szVarBuf, &cValType);
			
			if(cValType > 0){ /* if merge var exists */
				/* this line can't be executed in graphics mode. */
				/*printf("MergeVar 'tpistr' exists.  It will be over written.
				");*/
			}/* end of if() statment */
			
			/* set szVarBuf to point to WPStrToRet int szVarBuf[0] is segment
			int szVarBuf[1] is offset */
			segread(&sr);
			iIntptr = (unsigned int *) szVarBuf;
			iIntptr[0] = sr.ds;
			iIntptr[1] = (unsigned int) WPStrToRet;
			
			cValType = WPSTRING;	/* var type to return is WPSTRING */
			
			/* set "tpistr" merge variable equal to the random number */
			SetMrgVar(iIntStrBuf, szVarBuf, &cValType);
			
			/* make word string for "rettkn" variable name to set */
			MkIntStr(iIntStrBuf, MergeVarRettkn); 
			
			/* setup return buffer equal to trapped token number */
			iIntptr[0] = RETRIEVE;
			cValType = WPINT;	/* var type to return is WPINT */
			SetMrgVar(iIntStrBuf, szVarBuf, &cValType);
						
			*ax_reg = PLAYMACRO;
			*es_reg = sr.ds;
			*bx_reg = (unsigned int) &macro_fileopen;
			*cx_reg = strlen(macro_fileopen) +1; /* add one to include null */

			break;

		case CTRL_F:
			segread(&sr);
			*ax_reg = PLAYMACRO;
			*es_reg = sr.ds;
			*bx_reg = (unsigned int) &macro_font;
			*cx_reg = strlen(macro_font) +1; /* add one to include null*/
			userflg = 1;
			break;

		case CTRL_P:
			segread(&sr);
			*ax_reg = PLAYMACRO;
			*es_reg = sr.ds;
			*bx_reg = (unsigned int) &macro_print;
			*cx_reg = strlen(macro_print) +1; /* add one to include null*/
			break;

		case CTRL_R:
			*ax_reg = 0;
			SysVarNum = 5;		/* get random number */
			GetSysVar(SysVarNum, szVarBuf, &cValType);
			MkIntStr(iIntStrBuf, MergeVar);
			
			/* set "tpivar" merge variable equal to the random number */
			SetMrgVar(iIntStrBuf, szVarBuf, &cValType);

			segread(&sr);
			*ax_reg = PLAYMACRO;
			*es_reg = sr.ds;
			*bx_reg = (unsigned int) &macro_tpi;
			*cx_reg = strlen(macro_tpi) +1; /* add one to include null */
			return; 	
			
		case CTRL_T:
			*ax_reg = TYPECHAR;
			b3rd_bufptr = szTypeTpiVarBuf;
			*es_reg = FP_SEG(b3rd_bufptr);
			*bx_reg = FP_OFF(b3rd_bufptr);	
			*cx_reg = iTypetpibuflen;
			return;

		case CTRL_Y:
			SysVarNum = 2;
			GetSysVar(SysVarNum, szVarBuf, &cValType);
			break;

	}/* end of switch(*ax_reg) statement */

	/* The font.wpm macro generates a UserFunction(fontname) token.  The
	following code processes the UserFunction token and creates a font token
	(555). */
	if(userflg && *ax_reg == USER_FUNCTION){
		userflg = 0;
		*ax_reg = BASE_FONT;

		i3rd_bufptr = (unsigned int far *) third_buffer;

		for(idx=0; WP_buf[idx] > 0; idx++){
			i3rd_bufptr[idx] = (unsigned int) WP_buf[idx];
		}/* end of FOR() loop */

		i3rd_bufptr[idx++] = 0;	/* NULL terminate string */

		b3rd_bufptr = (unsigned char far *) &i3rd_bufptr[idx];

		idx = (idx*2)+6;	/* multiply by 2 for byte length add 6 for
							optional font parameters */
		for(idx2=0; idx2 < 6; idx2++)
			b3rd_bufptr[idx2]=0;/* specify last five parameters don't exist*/

		*cx_reg = idx;              /* save size font param buffer */
		//thrd_param_buf = (unsigned char far *) third_buffer;

		segread(&sr);
		*es_reg = sr.ds;
		//*es_reg = FP_SEG(thrd_param_buf);
		*bx_reg = (unsigned int) &third_buffer;
		//*bx_reg = FP_OFF(thrd_param_buf);

	}/* end of IF(userflg..) routine */

}/* end of Ctkn_handler() routine */

/*************************************************************************
name: GetRetStr(unsigned int *, unsigned int *)
purpose: Get a string from the 8 return buffer.  When you get a merge variable
	containing string, the return buffer contains the far address of the
	string.  This routine takes the return buffer and copies the appropriate
	address to *String.
in: *String = ptr of string to copy to
	*RetBuf = ptr to WP return buffer containing string address
out: *String contains WP string in word format
return: none
**************************************************************************/
void GetRetStr(unsigned int *String, unsigned char *RetBuf)
{
unsigned int far *szptString;
unsigned int *iIntptr;
unsigned long ltemp;
int i;

	iIntptr = (unsigned int *) RetBuf;
	ltemp = iIntptr[0];	/* save segment of buffer */
	ltemp = ltemp << 8; /* '' */
	ltemp = ltemp + (long) iIntptr[1]; /* save offset */
	szptString = (unsigned char far *) ltemp;/* save to far pointer */
	
	for (i=0; szptString[i] > 0; i++){
		String[i] = szptString[i];
	}/* end of for() loop */
	//iStrCpy(String, szptString);
	

}/* end of GetRetStr() routine */
/*************************************************************************
name: MkIntStr(unsigned int *, unsigned char *)
purpose: To convert a bytes string to a word string 
in: *CharStr = byte string to copy to word format
	*IntStr = word string to copy byte string to
out: *IntStr = string in word per char format
return: none 
**************************************************************************/
void MkIntStr(unsigned int *IntStr, unsigned char *CharStr)
{
	int iIdx;
	
	for(iIdx=0; CharStr[iIdx] != 0; iIdx++){
		IntStr[iIdx] = CharStr[iIdx];
	}/* end of for() loop */
	IntStr[iIdx] = 0;

}/* end of MkIntStr() routine */

/*************************************************************************
name: iStrCpy(unsigned int *, unsigned int *)
purpose: copy word string1 to word string2
in: *IntStr1 = word String to copy
	*IntStr2 = word String to copy too
out: *IntStr2 = contains same string as *IntStr1
return: none
**************************************************************************/
void iStrCpy(unsigned int *IntStr2, unsigned int *IntStr1)
{
	int iIdx;
	
	for(iIdx=0; IntStr1[iIdx] != 0; iIdx++){
		IntStr2[iIdx] = IntStr1[iIdx];
	}/* end of for() loop */
	IntStr2[iIdx] = 0;

}/* end of MkIntStr() routine */
/*************************************************************************
name: MkCharStr(unsigned char *, unsigned int *)
purpose: convert a word string to a byte string 
in: *IntStr = word string to convert to byte format
	*CharStr = byte string to copy to
out: *CharStr = updated to contain string in byte format
return: none
**************************************************************************/
void MkCharStr(unsigned int *CharStr, unsigned char *IntStr)
{
	int iIdx;
	
	for(iIdx=0; IntStr[iIdx] != 0; iIdx++){
		CharStr[iIdx] = IntStr[iIdx];
	}/* end of for() loop */
	CharStr[iIdx] = 0;

}/* end of MkIntStr() routine */

/*************************************************************************
name: GetSysVar()
purpose: Get a WP6.0 system variable by number
in: SysVar = System variable number to get
	*RetBuf = ptr to 8 byte routine buffer
	*Type = ptr to type variable
		** variable types **
		VAR_NOTASSIGNED (0) = variable is not assigned any data
		WPBOOL (1) = Boolean type, 0 or 1 in 1st word of retbuf
		WPINT(3) = signed integer saved in 1st word of retbuf
		WPFLOAT (4) = floating point value (8 byte IEEE format) in retbuf
		WPSTRING (5) = word string type.  Far address contained in 1st four
					bytes of retbuf (1st word is seg, 2nd word is off) seg:off
		WPWPU(7) = signed integer saved in 1st word of retbuf
out: *Type = value type returned
     *RetBuf = value Buffer returned
return: none
**************************************************************************/
void GetSysVar(unsigned int SysVar, 
			unsigned char *RetBuf, 
			unsigned char *Type)
{
 int iIdx;
 WPServ = 0;
 WPSysvar = SysVar;
 
 /* don't pass WPsysvar as an address for this call!  The WPCall assembly
 routine places WPsysvar in BX reg.  For this service routine BX must be equal
 to the system variable number to get.  If you pass the address it will not
 work. */
 WPCallSys(WPServ, WPSysvar, (unsigned char far *) WPRetBuf, &WPValType);

 for(iIdx=0; iIdx < RET_BUFSIZ; iIdx++){ /* copy buffer value */
 	RetBuf[iIdx] = WPRetBuf[iIdx];
 }/* end of for() loop */
 
 *Type = WPValType;
 

}/* end of GetSysVar() routine */

/*************************************************************************
name: GetMrgVar()
purpose: Get a WP6.0 Merge variable by variable name
in: *Varname = pointer to variable name to get data from
	*RetBuf = ptr to 8 byte routine buffer
	*Type = ptr to type variable
		** variable types **
		VAR_NOTASSIGNED (0) = variable is not assigned any data
		WPBOOL (1) = Boolean type, 0 or 1 in 1st word of retbuf
		WPINT(3) = signed integer saved in 1st word of retbuf
		WPFLOAT (4) = floating point value (8 byte IEEE format) in retbuf
		WPSTRING (5) = word string type.  Far address contained in 1st four
					bytes of retbuf (1st word is seg, 2nd word is off) seg:off
		WPWPU(7) = signed integer saved in 1st word of retbuf
out: *Type = updated to reflect the variable type
	*RetBuf = updated to contain the variable contents (or an address in the
				case of a WPSTRING type)
return: none 

**************************************************************************/
void GetMrgVar(unsigned int *Varname, 
			unsigned char *RetBuf, 
			unsigned char *Type)
{
 int iIdx;
 WPServ = 1;			/* WPServ = 1 for Get Merge variable */
 iStrCpy(WPMrgvar, Varname);	/* copy word string */
 WPValType = 0;			/* initialize value type */
 WPCall(WPServ, &WPMrgvar[0], (unsigned char far *) WPRetBuf, &WPValType);

 for(iIdx=0; iIdx < RET_BUFSIZ; iIdx++){ /* copy buffer value */
 	RetBuf[iIdx] = WPRetBuf[iIdx];
 }/* end of for() loop */
 
 *Type = WPValType;

}/* end of GetMrgVar() routine */

/*************************************************************************
name: SetMrgVar()
purpose: Set a Merge variable by variable name
in: *Varname = variable name word string to save data too.
	*RetBuf = ptr to 8 byte buffer.  Contains data save to variable.
	*Type = ptr to type variable
		** variable types **
		VAR_NOTASSIGNED (0) = variable is not assigned any data
		WPBOOL (1) = Boolean type, 0 or 1 in 1st word of retbuf
		WPINT(3) = signed integer saved in 1st word of retbuf
		WPFLOAT (4) = floating point value (8 byte IEEE format) in retbuf
		WPSTRING (5) = word string type.  Far address contained in 1st four
					bytes of retbuf (1st word is seg, 2nd word is off) seg:off
		WPWPU(7) = signed integer saved in 1st word of retbuf
out: none
return: 
**************************************************************************/
void SetMrgVar(unsigned int *Varname, 
			unsigned char *RetBuf,
			unsigned char *Type)
{
 int iIdx; 
 WPServ = 2;			/* WPServ = 2 for Set Merge variable */
 iStrCpy(WPMrgvar, Varname);	/* copy word string */
 WPValType = *Type;		/* save value type */
 
 for(iIdx=0; iIdx < RET_BUFSIZ; iIdx++){ /* copy buffer value */
 	WPRetBuf[iIdx] = RetBuf[iIdx];
 }/* end of for() loop */
 
 WPCall(WPServ, &WPMrgvar[0], (unsigned char far *) WPRetBuf, &WPValType);

}/* end of SetMrgVar() routine */


		/********************************
				END OF SOURCE CODE 
		*********************************/