;name	lcdef.inc
;title	Launcher specific equates & defines
;
;Copyright (C) 1992, 1993 WordPerfect Corp., All Rights Reserved
;-----------------------------------------------------------------
;
;Separated it into two sections:
;  1)	Launcher specific stuff
;  2)	Data for use by all programs that are Launcher Aware.
;**************************************************************************
;***			Launcher internal Equates			***
;**************************************************************************

;***	Type of card in the system
tp_ega	equ	1		; ega, vga
tp_hrc	equ	2		; hercules
tp_mon	equ	4		; mono
tp_cga	equ	8		; cga

;***	Data Variable & table entry sizes
fnptlen	equ 80			;length of path\filenames
minltp	equ 7			;minimum number of user programs to track
defmaxp	equ 10			;default number of user programs to track
maxltp	equ 40			;maximum number of user programs to track
ctlbksz	equ 7			;size in words of ctlbrk table
PS2Rtry	equ 5			;Number of retries for a PS/2 function call

;***	Miscellaneous Equates
wspc	equ 20h

;ORGFLGS equates
?of_blk	equ 1h			;Original state of the Blink bit
?of_ndp	equ 2h			;Set if "PROMPT=" not defined in environment
?of_ntm	equ 4h			;Set if need to restore Novell Task Mode


;***	bit flags for SWP_FLG variable
?sfemm	equ 1h		;Can use EMM for swapping
?sfxms	equ 2h		;Can use XMS for swapping
?sfdsk	equ 4h		;Can use DSK for swapping
?sfswin	equ 8h		;program is being swapped IN to conventional memory
?sfemml	equ 10h		;Limit is specified for EMM swapping
?sfxmsl	equ 20h		;Limit is specified for XMS swapping
?sfps2m	equ 40h		;PS/2 mouse is available - save it's data
?sfcksw	equ 80h		;flag just checking swap - don't allocate

;***	DOS Int 21h (AH=4Bh) Exec Parameter block structure
execpbk	struc
ep_envs	dw ?
ep_cmdl	dd ?
ep_fcb1	dw ?		;2 words (instead of dd) so assembler can init them
	dw ?
ep_fcb2	dw ?
	dw ?
execpbk	ends

.int16	macro				;; BIOS INT 16 (NO SHELL MACROS)
	pushf
	call	cs:orgi16
	endm
	
;**************************************************************************
;***			Launcher Synchronized programs			***
;**************************************************************************

;***	Launcher Tracking Packet structure: one for each program being tracked
ltppak	struc
flags	dw	0		;flags (explained below) 
memfree	dw	0		;# paragraphs free RAM when program was exec'd
memused	dw	0		;# paragraphs used by program under DOS
memswap	dw	0		;amount of memory needed to swap
mhandle	dw	0		;handle for EMM swapping
callprg	db	0		;calling program (one that loaded this one)
mcretst	db	0		;macro return state
umenid	dw	0		;Unique ID of program in THE menu
hotkey	dw	0		;assigned Hot key for this program
ltppak	ends

ltplen	equ type ltppak		;size of tracking structure in bytes

;***	bit flags for the FLAGS word in LTP structure above
?lt_alc	equ	1h	;This packet allocated
?lt_reg	equ	2h	;Program has registered	
?lt_emm	equ	4h	;swapped out to Expanded Memory
?lt_xms	equ	8h	;swapped to XMS Extended memory
?lt_dsk	equ	10h	;swapped out to Disk
?lt_scr	equ	20h	;non-standard screen mode - must use external driver
?lt_prv	equ	40h	;this program was privately loaded program
?lt_xcl	equ	80h	;this program has an exclusive launch active
?lt_sda	equ	100h	;swapping while INDOS - save larger SDA
?lt_srs	equ	200h	;This program was requested to "Start Resident"
?lt_dps	equ	400h	;do NOT allow preemptive swapping
?lt_pas	equ	800h	;Pause after termination
?lt_dpu	equ	1000h	;Disallow ALL pre-emptive swapping
?lt_bat	equ	2000h	;There is a Batch file to be deleted
?lt_nsc	equ	4000h	;ELD wants screen of source program untouched

vsw_pak	struc		;Virtual swap path descriptor packet
vs_drv	db 0			;drive where virtual swap files created 
vs_lim	db 0			;#0: limit specified
vs_free	dw 0,0			;paragraphs free on disk
vs_chr	dw 0			;pointer to char to replace w/menu char
vs_max	dw 0,0			;maximum to use on this drive - in paragraphs
vs_nam	db 80 dup(0)		;path and file name of virtual files
vsw_pak	ends

;***	bit flags for ELD_FLG variable
?ed_scs	equ 1h		;set if ELD Screen swapper available
?ed_clp	equ 2h		;set if ELD clipboard available
?ed_3rd	equ 4h		;set if Third Party ELD's loaded
?ed_mac	equ 8h		;set if Macro Engine available
?ed_hid	equ 10h		;set if File ID was HASHED

;***	flags set in LC_KYST below, only ahk should be touched for now
?ky_mac	equ 1		;macro running flag
?ky_def	equ 2		;macro define flag
?ky_dio	equ 4		;Direct IO on
?ky_ahk	equ 8		;Alternate Hot Key combo pressed (ALT-CTL)
?ky_amc	equ 10h		;Alternate Macro Key combo pressed (ALT-SHFT)
?ky_cmc	equ 20h		;flag to check keystroke macro file header
?ky_dah	equ 40h		;Alternate hotkey support (set = disabled)
?ky_dis	equ 80h		;flag that DOS Task Switcher API disabled
;**************************************************************************
;***			Launcher Aware Program Constants		***
;**************************************************************************

;***	Reserved UMID's
INVumid	equ 0		;Invalid - flag External Drivers to Exit
PoCumid	equ 1		;Program of Choice
SCSumid	equ 2		;Screen Saver
CLPumid	equ 3		;Clipboard
DOSumid	equ 4		;Macros
Opnumid	equ 5		;First Open reserved UMID
Maxumid	equ 20		;Last reserved UMID
;5 .. 20		;reserved for future use

;***	File type for use in .KBM macro prefix
pfshkbm	equ 4

;***	Clipboard Formats
cf_NATV	equ 1		;Machine Native format - usually ASCII
cf_BNRY	equ 2		;Binary (universal) format - no conversion
cf_WP42	equ 3		;WordPerfect 4.2 format text
cf_WP5X	equ 4		;WordPerfect 5.X format - file w/prefix
cf_WP60	equ 5		;WordPerfect 6.0 format - file w/prefix
cf_last	equ cf_WP60	;Always equal to the last defined clipboard format

;***	Launcher Command Equates
		;Basic launcher interaction
lc_res	equ 0		;Check if Launcher is resident
lc_ckin	equ 1		;register with Launcher and get a PID
lc_load	equ 2		;Load a program (or switch to it if already resident)
lc_reqx	equ 3		;Request permission to exit
lc_swap	equ 4		;Check on swappable status of current program
lc_xall	equ 5		;Set Launchers EXIT ALL flag - tell all progs to exit
lc_clsr	equ 6		;Clear the start resident timer
;open	    7h..0Fh
		;Program of Choice related functions
lc_setm	equ 10h		;Set the Menu file being used
lc_getm	equ 11h		;Get the Menu file being used
lc_setp	equ 12h		;Set the "Program of Choice" Description
lc_getp	equ 13h		;Get the "Program of Choice" Description
;open	    14h..1Fh
		;Keyboard/Macro related functions
lc_defm	equ 20h		;Begin recording keystrokes (macro define)
lc_exem	equ 21h		;Begin playing keystrokes (macro execute)
lc_defs	equ 22h		;Stop recording keystrokes
lc_dio	equ 23h		;Force/Reset Direct IO (enable/disable macro IO)
lc_hksw	equ 24h		;Disable/Enable Hot Key SWapping
lc_hksu	equ 25h		;Disable/Enable Hot Key Swapping to User programs
lc_kstf	equ 26h		;Stuff one or two keystrokes into the keyboard buffer
lc_kalt	equ 27h		;Disable/Enable Alternate Hotkey swapping support
;open	    28h..2Fh
		;Program tracking information
lc_resp	equ 30h		;Get list of UID's for resident programs
lc_lact	equ 31h		;Return last active program (where swapped from)
lc_path	equ 32h		;Return pointer to Launchers Executed path
lc_npid	equ 33h		;Return PID of next program loaded
lc_reld	equ 34h		;Get list of UID's for resident ELD's
;open	    34h..3Fh
		;Clipboard Interaction functions
lc_cbwr	equ 40h		;Write to current Clipboard (overwrite existing data)
lc_cbap	equ 41h		;Append to current Clipboard (maintain current format)
lc_cbrd	equ 42h		;Read from the current Clipboard (convert if needed)
lc_cbfm	equ 43h		;Check the format of current Clipboard
lc_cbrn	equ 44h		;Read active clipboard name/number
lc_cbsn	equ 45h		;Set new active clipboard name/number
;open	    46h..F0h

		;Hot Key Changing function
lc_nhky	equ 0F1h	;Change the hot key of a resident program
;open	    F2h..FFh

;***	Command block structure definitions
cmd_hdr	struc		;Every command has this header
lc_func	dw ?		;Function number being requested
lc_pid	dw ?		;Program specific PID returned by Launcher
lc_err	dw ?		;Error code (if any: non-zero)
cmd_hdr	ends

cmd_reg	struc			;used for registration call
rg_hdr	db size cmd_hdr dup(?)
rg_stat	dd ?			;state routine - same as for Shell
rg_flag	dw ?			;flags set for various info
rg_umid	dw ?			;current programs UMID
cmd_reg	ends

;***	RG_FLAG bit values on return
?rg_scs	equ ?ed_scs	;(1h)	set if ELD Screen swapper available
?rg_clp	equ ?ed_clp	;(2h)	set if ELD clipboard available
?rg_3rd	equ ?ed_3rd	;(4h)	set if ELD Screen Blanker available
?rg_mac	equ ?ed_mac	;(8h)	set if Advanced Macro Engine available
?rg_hid	equ ?ed_hid	;(10h)	set if File ID was generated with a HASH
?rg_res	equ 8000h		;set if program is supposed to start resident

cmd_load struc
ld_hdr	db size cmd_hdr dup(?)
ld_path	dd ?			;ptr to full path\name of program to launch
ld_parm	dd ?			;pointer to command line parameters
ld_ddir	dd ?			;pointer to default directory
ld_macd	dd ?			;pointer to Program's Macro directory
ld_eolm	dd ?			;pointer to Program's EOL Macro name
ld_gosh	dd ?			;pointer to Program's Go Shell Macro name
ld_rtsh	dd ?			;pointer to Program's Return from Shell Macro
ld_umid	dw ?			;unique program menu number identifier
ld_flag	dw ?			;flags to set and pass in
ld_hotk	dw ?			;Hot key to assign this program
cmd_load ends

loadsz	equ size cmd_load	;size of load structure

;CMD_LOAD FLAGS
?ld_prv	equ ?lt_prv		;this is a private invocation
?ld_xcl	equ ?lt_xcl		;exclusive incovation - only valid w/ private
?ld_res	equ ?lt_srs		;Start this program resident
?ld_dps	equ ?lt_dps		;DISALLOW preemptive swapping
?ld_pas	equ ?lt_pas		;PAUSE after program termination
?ld_bat	equ ?lt_bat		;Batch file needs to be deleted

;This structure MUST exactly match the network info stored in LCMAIN.lnchid
;currently it also matches the old Shell 3.X format, but may change if we
;get 5 character file ids
lc_net	struc
ln_id	db 8 dup(?)		;"WPLAUNCH" id string
	db 0			;null terminator
ln_vnmj	db ?			;Version number - Major
ln_vnmn	db ?			;Version number - Minor
ln_isnt	db ?			; = "N" if a network was detected
ln_ntyp	db ?			;the network type number
ln_fid	db 5 dup(?)		;Initials to use (File ID), null terminated
	db 0			;null terminator
ln_nuid	db 32 dup(?)
	db 0			;null terminator
lc_net	ends

;***	Application GETSTAT routine functions
gs_stat	equ 0		;request for program state
gs_mnrm	equ 1 		;macro termination status (normal)
gs_mcan	equ 2		;macro termination status (cancel)
gs_merr	equ 3		;macro termination status (error)
gs_mntf	equ 4		;macro termination status (not found)
gs_sysv	equ 5		;evaluate a SYSTEM variable
gs_don	equ 6		;turn display ON
gs_doff	equ 7		;turn display OFF
gs_swot	equ 8		;Notify program swapping out
gs_swin	equ 9		;Notify program swapping back in

cmd_strz struc			;used for Get/Set menu/pocd * RESP
st_hdr	db size cmd_hdr dup(?)
st_strz	dd ?			;ptr to null terminated string/buffer
st_cnt	dw ?			;used by some functions
st_wrd2	dw ?			;used by some functions
st_wrd3	dw ?			;used by some functions
cmd_strz ends

cm_clpb	struc			;used by clipboard functions
cb_hdr	db size cmd_hdr dup(?)
cb_frmt	dw 0			;clipboard format (input & output)
cb_flnm	dd ?			;pointer to clipboard filename (returned)
cm_clpb	ends

;values sent in by EXIT ALL function
xa_off	equ 0			;Nothing special - NOT exiting
xa_nosv	equ 1			;Exit WITHOUT saving changes
xa_save	equ 2			;Exit SAVING changes

;Currently Active Programs entry structure
cap_ent	struc
ce_umid	dw ?
ce_size	dw ?
ce_swap	dw ?
cap_ent	ends

?ce_emm	equ ?lt_emm		;program swapped to Expanded Memory
?ce_xms	equ ?lt_xms		;program swapped to eXtended Memory
?ce_dsk	equ ?lt_dsk		;program swapped to Disk

;Flags set in flags word passed in with the LC_NHKY command (ELD INFO)
?ei_nsc	equ 1			;Flag to NOT modify screen before swapping

;***	Error returns from Launcher
lce_invalid_PID	equ -1			;Invalid PID - not in range
lce_invalid_CMD	equ -2			;Invalid command - unsupported
lce_too_many	equ -3			;too many programs have registered
lce_menu	equ -4			;THE menu has NOT been set yet
lce_NOT_PoC	equ -5			;program requesting is NOT PoC
lce_no_exit	equ -6			;can't exit, child programs resident
lce_file	equ -7			;File IO Error
lce_macro_exe	equ -8			;Macro execution is/not already going
lce_invalid_UMID equ -9			;invalid UMID specified
lce_no_clip	equ -10			;Clipboard ELD not loaded
lce_macro_def	equ -11			;Macro definition was/not on
lce_noswap_left	equ -12			;No swap area left (XMS/EMS/DSK gone)
lce_bad_clp_fmt	equ -13			;Invalid Format conversion request

;***	Scan codes for standard hot keys
S_0	equ	8100h
S_1	equ	7800h
S_2	equ	7900h
S_3	equ	7A00h
S_4	equ	7B00h
S_5	equ	7C00h
S_6	equ	7D00h
S_7	equ	7E00h
S_8	equ	7F00h
S_9	equ	8000h
S_A	equ	1E00h
S_B	equ	3000h
S_C	equ	2E00h
S_D	equ	2000h
S_E	equ	1200h
S_F	equ	2100h
S_G	equ	2200h
S_H	equ	2300h
S_I	equ	1700h
S_J	equ	2400h
S_K	equ	2500h
S_L	equ	2600h
S_M	equ	4200h
S_N	equ	4100h
S_O	equ	1800h
S_P	equ	1900h
S_Q	equ	1000h
S_R	equ	1300h
S_S	equ	1F00h
S_T	equ	1400h
S_U	equ	1600h
S_V	equ	3F00h
S_W	equ	1100h
S_X	equ	2D00h
S_Y	equ	1500h
S_Z	equ	2C00h
S_F1	equ	6800h
S_F2	equ	6900h
S_F3	equ	6A00h
S_F4	equ	6B00h
S_F5	equ	6C00h
S_F6	equ	6D00h
S_F7	equ	6E00h
S_F8	equ	6F00h
S_F9	equ	7000h
S_F10	equ	7100h
S_F11	equ	8B00h
S_F12	equ	8C00h

;***	Scan codes for alternate hot keys
A_0	equ	0B30h
A_1	equ	0231h
A_2	equ	0332h
A_3	equ	0433h
A_4	equ	0534h
A_5	equ	0635h
A_6	equ	0736h
A_7	equ	0837h
A_8	equ	0938h
A_9	equ	0A39h
A_A	equ	1E41h
A_B	equ	3042h
A_C	equ	2E43h
A_D	equ	2044h
A_E	equ	1245h
A_F	equ	2146h
A_G	equ	2247h
A_H	equ	2348h
A_I	equ	1749h
A_J	equ	244Ah
A_K	equ	254Bh
A_L	equ	264Ch
A_M	equ	424Dh
A_N	equ	414Eh
A_O	equ	184Fh
A_P	equ	1950h
A_Q	equ	1051h
A_R	equ	1352h
A_S	equ	1F53h
A_T	equ	1454h
A_U	equ	1655h
A_V	equ	3F56h
A_W	equ	1157h
A_X	equ	2D58h
A_Y	equ	1559h
A_Z	equ	2C5Ah
A_F1	equ	3B00h
A_F2	equ	3C00h
A_F3	equ	3D00h
A_F4	equ	3E00h
A_F5	equ	3F00h
A_F6	equ	4000h
A_F7	equ	4100h
A_F8	equ	4200h
A_F9	equ	4300h
A_F10	equ	4400h
A_F11	equ	8500h
A_F12	equ	8600h
