/*C_SOURCE_FILE********************************************* 
File	qckfind.c
Title	Sample retrieval mainline using QuickFinder calls
Tabs	Standard 4,3

		  Copyright (C) 1994 WordPerfect Corp., All Rights Reserved
		  COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
-----------------------------------------------------------
Calls the high level QuickFinder API set to test it

*END*********************************************************/

/* syntax of this test file

	qckfind file.idx word1 word2						-- look up word1 & word2
	qckfind file.idx /author Mark /typist Alan 	-- document summary searches
																(wpdos6.0a level syntax)
	qckfind file.idx word1 | word2*					-- or and wildcard examples
	qckfind file.idx word1 ! word2					-- not example

*/

/* standard "C" library include files */
#include		<stdio.h>
#include		<stdlib.h>
#include		<string.h>
#include		<ctype.h>
#include		<io.h>
#include		<conio.h>
#include		<dos.h>

/* include the QuickFinder retriever export file */
#include		"qckfind.h"


/*************************************************************************
	Function: QFFileHitCallBack_Func
	Description: Callback function called by QFSearchIndex() when a hit
			for a query is found inside a file.
	In: 	FilePath - File name and path where the hit was found.
			ParmArea - Additional parameters that can be sent through
			QFSearchIndex() to you call back function.
			HitNumber - The number of the hit for a file.
	Return:	Return 0 in the call back function if no problems occurred,
			else return a negative value.  The negative value will be seen
			as a QF_ESCAPE_PRESSED return value for the QFSearchIndex()
			calling function.
*************************************************************************/


int far QFFileHitCallBack_Func(char far * filepath, void far * parmarea,
										unsigned long hitnumber)
{
	int CharacterCheck;

	printf("#%ld %s Parameter: %s\n", hitnumber, filepath,
				parmarea);

	if (kbhit()) {								/* check for an escape */
		CharacterCheck = getch();
		if (CharacterCheck == 0x1b) return -1;
	}

	return 0;

}


/*************************************************************************
	Function: QFWithinHitCallBack_Func
	Description: Callback function called by QFSearchIndex() each time a hit
			for a query is found inside the same file.
	In: 	FilePath - File name and path where the hit was found.
			ParmArea - Additional parameters that can be sent through
			QFSearchIndex() to you call back function.
			HitNumber - The number of the hit for a file.
			FileByteOffset - The Byte offset inside the file where the hit
			was found.
	Return:	Return 0 in the call back function if no problems occurred,
			else return a negative value.  The negative value will be seen
			as a QF_ESCAPE_PRESSED return value for the QFSearchIndex()
			calling function.
*************************************************************************/

int far QFWithinHitCallBack_Func(char far * filepath, void far * parmarea,
						unsigned long hitnumber, unsigned long filebyteoffset)
{
	int CharacterCheck;

	printf("#%ld (offset = %ld) %s Parameter: %s\n", hitnumber,
				filebyteoffset, filepath, parmarea);

	if (kbhit()) {								/* check for an escape */
		CharacterCheck = getch();
		if (CharacterCheck == 0x1b) return -1;
	}

	return 0;

}

/*************************************************************************
		MAIN
		Description:   Searches for a word(s) or phrase(s) in an index file
		In:  File name of the index file, and word(s) to look up.
		Out:  Index file information, and the number of hits.
		Return:   Error if a file can't be opened or has problem.

		Syntax:
		qckfind file.idx word1 word2 ...

*************************************************************************/


void cdecl main(argumentcnt, argumentval)

int		argumentcnt;
unsigned char 	far * far * argumentval;

{
	unsigned char far * wordtoget;				/* word to retrieve */
	unsigned char 	indexfile[100];
	unsigned char	queryline[200];				/* query words -- syntax */
	void far * 		memptrparm;							/* parameter memory area */

	int				cntargs = 0,
						documentlevelflag,
						i,
						lenquery,
						numwords,
						status;

	int				IndexLevel,
						IndexLenLongName,
						IndexScope;

	unsigned long	IndexTotalBytesIdx,
						IndexTotalBytesIncAndIdx,
						NumberUniqueWordsIdx,
						NumberUniqueWordsInc;

	long				lNumberOfHits;

	char 				IndexLongName[200];


	printf("\n");

	/* set number of words that are in the arguments */
	numwords = argumentcnt - 2;

	/* get the index file name (2nd paramer*/
	++argumentval;
	cntargs++;
	strcpy(indexfile, *argumentval);

	/* create a query line from the arguments */
	queryline[0] = 0;
	for (i = 0; i < numwords; i++) {
		++argumentval;
		cntargs++;
		wordtoget = *argumentval;				/* word to retrieve */
		strlwr(wordtoget);						/* to lower case */
		strcat(queryline, wordtoget);			/* put in command line */
		strcat(queryline, " ");					/* add a space */
	} /* end of for loop */

	/* eliminate last space and replace with a null */
	lenquery = strlen(queryline);
	queryline[lenquery-1] = 0;
	lenquery--;

	/* information call first */
	status = QFIndexInfo(indexfile, &IndexLevel,
		&IndexScope, &NumberUniqueWordsIdx, &NumberUniqueWordsInc,
		&IndexTotalBytesIdx, &IndexTotalBytesIncAndIdx,
		IndexLongName, &IndexLenLongName);

	printf("IndexFile = %s\n IndexScope = %x,\n",
			indexfile, IndexScope);
	printf("   UniqueWords Idx = %ld; Inc = %ld\n",
			NumberUniqueWordsIdx, NumberUniqueWordsInc);
	printf("   TotalBytes Idx = %ld; Inc+Idx = %ld\n",
			IndexTotalBytesIdx, IndexTotalBytesIncAndIdx);
	printf("   IndexLongName = %s, len = %d\n",
			IndexLongName, IndexLenLongName);

	/* set documentlevel flag */
	documentlevelflag = QF_DOCUMENT_LEVEL_HITS;
	if (IndexLevel != 8) documentlevelflag = QF_ALL_LEVEL_HITS;

	memptrparm = (char far *) calloc(1, sizeof(int));  /* allocate parmeter area */
	strcpy(memptrparm, "TRUE");

	lNumberOfHits = QFSearchIndex(indexfile, queryline, documentlevelflag,
										memptrparm, 1024l, QFFileHitCallBack_Func,
										QFWithinHitCallBack_Func);

	if (lNumberOfHits > 0) {
		printf("\nNumber of Hits = %ld\n", lNumberOfHits);
	} else {
		printf("\nError Condition = %ld\n", lNumberOfHits);
	}

	/* free up parameter memory */
	free(memptrparm);

	if (status == 1) status = 1;  				/* warning avoider */

} /* end main */
