;name: sft.asm
;title: WordPerfect Scalable font technology driver skeleton source code
;
;  Copyright (C) 1987,1992 WordPerfect Corp., All Rights Reserved
;------------------------------------------------------------


;INCLUDE files
include wpsft.inc


_TEXT	segment	byte public 'CODE'
DGROUP	group	_TEXT
assume	cs:_TEXT,ds:_TEXT,ss:_TEXT


	jmp	sftinit

dmajv	db	0		;major version of driver
dminv	db	0		;minor version of driver

	db	0		;(byte) byte is vailable

;WP to driver
wpparam	dw	0		;(word) parameter data block entry 1
	dw	0		;(word) parameter data block entry 2
	dw	0		;(word) parameter data block entry 3
	dw	0		;(word) parameter data block entry 4
	dw	0		;(word) parameter data block entry 5
	dw	0		;(word) parameter data block entry 6
	dw	0		;(word) parameter data block entry 7
	dw	0		;(word) parameter data block entry 8
	dw	0		;(word) parameter data block entry 9
	dw	0		;(word) parameter data block entry 10

;Driver to WP
drparam	dw	0		;(word) parameter data block entry 1
	dw	0		;(word) parameter data block entry 2
	dw	0		;(word) parameter data block entry 3
	dw	0		;(word) parameter data block entry 4
	dw	0		;(word) parameter data block entry 5

;driver stack
	db	stksz dup ("S") ; stack
	
; stack registers SS:SP
	dw	0		;SS
	dw	0		;SP
	
; graphic context buffer area
	db	gcsiz	dup (0)	

drtowps	dw	-1		;driver to WP jump table segment
drtowpo	dw	-1		;driver to WP jump table offset
;sftinit
;in:	[WP_drvr1_param] = Segment of font data file name
;	[WP_drvr2_param] = Offset of font data file name within segment of WP_drvr1_param
;	[WP_drvr3_param] = WP to Driver jump table segment
;	[WP_drvr4_param] = WP to Driver jump table offset
;	[WP_drvr5_param] = Driver to WP jump table segment
;	[WP_drvr6_param] = Driver to WP jump table offset
;	[WP_drvr7_param] = SFT driver version number(high byte=MJV,low byte=MNV)
;out:	[WP_drvr10_param] = 0 if no error, else error code
;ret:	none
;notes:	Possible error codes:
;	er_fnam - Invalid font data file name
;	er_notf - Font data file not found
;	er_accd - Access denied to font data file
;	er_drive - Invalid drive/path specification for font data file
;	er_fhan - No available file handles
;	er_nomem - Memory error
;	er_invdt - Invalid font data file data format (includes encryption)
;	er_inver - Invalid SFT driver version
;	-1 = generic unrecoverable driver error
sftinit	proc	near
	push	ax	; save registers
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	push	es
	push	ds
;Set all registers to point to driver
	push	cs
	pop	ds
	push	ds
	pop	es

;setup driver stack
	mov	es:[oldss],ss	;save SS:SP
	mov	es:[oldsp],sp
	push	ds			;ss:sp -> driver stack
	pop	ss
	mov	sp,tostk

;correct driver version number?
	mov	word ptr es:[WP_drvr10_param],er_inver ;assume invalid version
	mov	ax,es:[WP_drvr7_param]	;get version number
	cmp	ah,es:[dmajv]		;major version number ok?
	 jne	sini15			; no
	cmp	al,es:[dminv]		;minor version number ok?
	 je	sini20			; yes
sini15:	jmp	sini70			; no, version error

;setup "WPtoDriver" driver routines jump table
sini20:	mov	ax,es:[WP_drvr3_param]	;get segment of WPtoDriver jump table
	mov	bx,es:[WP_drvr4_param]	;get offset of WPtoDriver jump table
	mov	ds,ax			;ds:bx -> WPtoDriver jump table
	mov	ds:[bx],offset sftnewfont	;offset to SFTNewFont
	mov	ds:[bx+2],offset sftbitsiz	;offset to SFTBitSiz
	mov	ds:[bx+4],offset sftmkchr	;offset to SFTMkChr
	mov	ds:[bx+6],offset sftdinit	;offset to SFTDInit
	mov	ds:[bx+8],offset sftwidth	;offset to SFTwidth
	mov	ds:[bx+10],offset sftotype	;offset to SFTOType

;save location of "DrivertoWP" driver routines jump table
	mov	ax,es:[WP_drvr5_param]	;get segment of DrivertoWP jump table
	mov	bx,es:[WP_drvr6_param]	;get offset of DrivertoWP jump table
	mov	cs:drtowps,ax		;driver to WP jump table segment
	mov	cs:drtowpo,bx		;driver to WP jump table offset

;/*****************************************************************/
;/*************** code to initialize driver goes here *************/
;/*****************************************************************/

;/*** jump to here if a memory error occures ***/
sini65:	mov	word ptr es:[WP_drvr10_param],er_nomem ;memory error return


sini70:	;/*** jump to here to switch from driver stack to WP stack ***/
;Restore application's stack
	mov	ss,es:[oldss]	;restore SS:SP
	mov	sp,es:[oldsp]
	pop	ax		; restore registers
	pop	bx
	pop	cx
	pop	dx
	pop	di
	pop	si
	pop	es
	pop	ds
	db	0cbh			;FAR RETURN
sftinit	endp

;sftnewfont
;in:	WP_drvr1_param		;packet id for font definition segment
;	WP_drvr2_param		;offset font definition within packet of WP_drvr1_param
;	WP_drvr3_param		;segment for font data filename
;	WP_drvr4_param		;offset font data filename within packet of WP_drvr3_param
;	WP_drvr5_param		;segment graphic context
;	WP_drvr6_param		;offset graphic context
;	WP_drvr7_param		;segment character map variable data block
;	WP_drvr8_param		;offset character map variable data block
;out:	WP_drvr10_param = 0 if no error, else error code
;ret:	none
;notes:	Possible error codes:
;	er_fnam - Invalid font data file name
;	er_notf - Font data file not found
;	er_accd - Access denied to font data file
;	er_drive - Invalid drive/path specification for font data file
;	er_fhan - No available file handles
;	er_nomem - Memory error
;	er_invdt - Invalid font data file data format (includes encryption)
;	-1 = generic unrecoverable driver error
;
sftnewfont	proc	near

;Set all registers to point to driver
	push	cs
	pop	ds
	push	ds
	pop	es

;setup driver stack
	mov	es:[oldss],ss	;save SS:SP
	mov	es:[oldsp],sp
	push	ds			;ss:sp -> driver stack
	pop	ss
	mov	sp,tostk		; set sp = top of driver stack

	mov	word ptr es:[WP_drvr10_param],0		;no error yet

;/**********************************************************************/
;/**************** Code to setup for new font goes here ****************/
;/**********************************************************************/

;/* if a memory error occurs, jump to here */
snf065:	mov	word ptr es:[WP_drvr10_param],er_nomem	;memory error


;Restore application's stack
	mov	ss,es:[oldss]		;restore SS:SP
	mov	sp,es:[oldsp]
	db	0cbh				;FAR RETURN
sftnewfont	endp
sftbitsiz	proc	near
	db	0cbh			;FAR RETURN
sftbitsiz	endp
;sftmkchr
;in:	WP_drvr1_param = segment character map variable data block
;	WP_drvr2_param = offset character map variable data block
;out:	WP_drvr1_param = -> start of bitmap within cache packet
;	WP_drvr2_param = -> start of WP formap bitmap header within cache packet
;	WP_drvr3_param = -> segment of bitmap (ALPCK'ed packet id)
;	WP_drvr10_param = 0 if no error, else error code
;ret:	none
;notes:	Possible error codes:
;	er_nomem - Memory error
;	er_invdt - Invalid font data file data format
;	-1 = generic unrecoverable driver error
;	
sftmkchr	proc	near

;Set all registers to point to driver
	push	cs
	pop	ds
	push	ds
	pop	es

;setup driver stack
	mov	es:[oldss],ss
	mov	es:[oldsp],sp
	push	ds
	pop	ss
	mov	sp,tostk

	mov	word ptr es:[WP_drvr10_param],?wpok	;assume good return
	
;/*****************************************************************/
;/************ code for to make the character goes here ***********/
;/*****************************************************************/

;Restore application's stack
	mov	ss,es:[oldss]
	mov	sp,es:[oldsp]

	db	0cbh			;FAR RETURN
sftmkchr	endp

;sftdinit
;desc:	De-initialize a third party font driver
;in:	none
;ret:	none
;notes:	No possible error returns
;
public	sftdinit
sftdinit	proc	near

;Set all registers to point to driver
	push	cs
	pop	ds
	push	ds
	pop	es

;setup driver stack
	mov	es:[oldss],ss	;save SS:SP
	mov	es:[oldsp],sp
	push	ds
	pop	ss
	mov	sp,tostk

;/*****************************************************************/
;/************* code to deinitial your driver goes here ***********/
;/*****************************************************************/

;Restore application's stack
	mov	ss,es:[oldss]	;restore SS:SP
	mov	sp,es:[oldsp]

	db	0cbh			;FAR RETURN
sftdinit	endp
;sftwidth
;in:	WP_drvr1_param = segment character map variable data block
;	WP_drvr2_param = offset character map variable data block
;	WP_drvr3_param = segment graphic context
;	WP_drvr4_param = offset graphic context
;out:	WP_drvr5_param = Character width in user units
;	WP_drvr10_param = 0 if no error, else error code
;ret:	none
;notes:	Possible error returns:
;	er_invdt - Invalid font data file data format
;	-1 = generic unrecoverable driver error

sftwidth	proc	near
	db	0cbh			;FAR RETURN
sftwidth	endp
;SFTOType
;desc:	Tell the application what output modes are supported
;in:	none
;out:	WP_drvr1_param = output mode type definition word
;		bit 0 - WP format bitmap
;		bit 1 - WP format Vectors (Lines and PolyLines, No Curves)
;		bit 2 - WP format Bez Curves/Vectors (Curves, PolyCurves, Lines, Polylines)
;ret:	none
;notes:	No possible error codes
;
public	SFTOType
SFTOType	proc	near
	push	cs
	pop	es
	
	; supports are font all font types
	mov	word ptr es:[WP_drvr1_param],WPBitmap+WPVec+WPBez 
							
	db	0cbh			;FAR RETURN
SFTOType	endp
public	_main
_main	proc	near
_main	endp

_TEXT	ends  ; End of source code
	end
	
