.model tiny
Code segment

assume cs:code	; We compile to .com, so only a code-segment available
Org 100h

; Here we go -----------------------------------[EIP]----------------------------------
start:

; --- Parse commandline
	xor ch, ch
	mov cl, es:[80h]	; Get command line length
	mov si, 81h		; Parse command line string
	lea di, BUFFER		; ..into buffer
blank1:
	lodsb
	cmp al,' '
	loope blank1		; Skip first blanks
	jz usage		; No parameters = Error
	test cx, cx
	jz eocl
argv1:
	stosb
	lodsb
	cmp al,' '
	loopne argv1		; Skip to second parameter or end of cmdline
	jz usage		; Second parameter is not allowed
eocl:
	stosb
	xor al,al
	stosb			; NULL-Terminate filename

; --- Read file to buffer
	mov ax, 3D00h		; Open file
	mov dx, offset BUFFER
	xor cx, cx
	int 21h
	jb  fileerr
        mov bx, ax
        mov cx, 01000H
        lea dx, BUFFER
	mov ah, 3Fh		; Load file to buffer
	int 21h
	Mov ah, 3Eh		; Close file
	jb readerr
	Int 21h
	jmp readok

; --- Error handling (near)
readerr:
	int 21h
	Mov dx, offset RERROR
	jmp showerr
fileerr:
	mov dx, offset FERROR
	jmp showerr
usage:
	mov dx, offset TXTUSG
showerr:
	mov ah, 09h
	int 21h
	mov ax, 4C01h
	int 21h

readok:
	; For unknown reason this is needed to make switch work??
        mov ah,0Fh
        int 10h

; --- Map VGA Font area for writing
	cli
	mov dx, 03C4h		; VGA Sequence Register
	mov ax, 0402h		; Enable writing to Color Plane 2
	out dx, ax
	mov ax, 0704h		; Enable sequential memory access and extended mem
	out dx, ax
	mov dl, 0CEh		; Graphics controller address Register
	mov ax, 0005h		; Direct write
	out dx, ax
	mov ax, 0406h		; Plane 2 color don't care
	out dx, ax
	mov ax, 0204h		; Select read Plane 2
	out dx, ax
	sti

; --- Copy character map from buffer to mapped area
	mov ax, 0A000h		; Character data at A000:0000
	mov es, ax
	xor di, di
	lea si, BUFFER		; Copy from buffer
	mov cx, 256		; 256 caracters
	cld			; copy 16 bytes to bitmap
@b:	movsw
	movsw
	movsw
	movsw
	movsw
	movsw
	movsw
	movsw
	add di, 16		; skip another 16 bytes
	loop @b

; --- Unmap memory area with font, commit changes
	cli
	mov dx, 03C4h		; VGA Sequence Register
	mov ax, 0302h		; Plane 0+1 write enable
	out dx, ax
	mov ax, 0304h		; Enable extended memory mode
	out dx, ax
	mov dl, 0CEh		; Graphics controller address Register
	mov ax, 1005h		; Odd/even mode
	out dx, ax
	mov ax, 0004h		; Unselect planes for reading
	out dx, ax
        mov ah, 0Fh		; Get current video mode
        int 10h			; BIOS-call
        cmp al, 7		; Monochrome mode 7 is different!
        jne @skip
        mov ax, 0A06h		; Odd/even (text mode) @ B000h (Monochrome area)
	jmp @cont
@skip:	mov ax,0E06h		; Odd/even (text mode) @ B800h
@cont:  out dx,ax
	sti

; --- Exit gracefully
	mov ax, 4C00h
	int 21h

TXTUSG 	db 'VGA Font loader V1.0 (c) DI(FH) Ludwig Ertl 2015',13,10,13,10
	db 'Usage: loadfont <Filename>',13,10,13,10
	db '<Filename> - Name of font file previously dumped with savefont',13,10,'$'
FERROR	db "File not found error!$"
RERROR	db "Error reading file$"
BUFFER  db 4096 dup(?)

Code ends
End start
