name   womdrv
title  Resident mouse driver code (mouse.com, mouse.sys)
;
;------------------------------------------------------------
;  Copyright (C) 1987 WordPerfect Corp., All Rights Reserved
;------------------------------------------------------------


include       macros.inc
include wpmouse.inc
include wpmirs.inc

.list                ;Restore listing.
.cref                ;Restore cross reference.
                            
CSEG1         SEGMENT       PUBLIC         PARA          'CODE'  
                             
                             
;************************ 
;      FILE HEADER 
; 
;************************ 
       dw     vers          ;ptr to version string
       dw     'MM'          ;MM for mouse driver
       dw     mmi           ;ptr to main menu index
       dw     (emmi-mmi)/2          ;# main menu entries
       dw     scode         ;start of code
       dw     lcode         ;length of code
       dw     0
       dw     0
;***
;  Version string
;      Asciz format.  Unrestricted length.
;      NOTE! Must follow file header.
;***
vers   db     'Standard Driver (Mouse.Com, Mouse.Sys) 1.0',0 
                             
;******************** 
; MAIN MENU INDEX TABLE 
;******************** 
mmi    dw     m1e1          ;menu 1 entry 1
emmi   equ    $

;******************* 
;      MAIN MENU 
;      Text or Graphic main menu strings and 2nd menu ptr lists 
;      NOTE! All asciz strings must not exceed 40 bytes in length (including 
;             null). 
;******************* 
m1e1   dw     m2e1          ;ptr to string
       dw     NEITHER               ;type
       dw     scode
       dw     lcode

m2e1   db     'Mouse Driver (MOUSE.COM)',0 
scode  equ    $ 
CSEG1         ENDS 
                             
CSEG2         SEGMENT PARA PUBLIC 'CODE' 
ASSUME        cs:cseg2;ds:cseg2 
ORG    0
       DW     Install_DRV   ;Install Driver
       dw     0             ;because far routines
       DW     Remove_DRV            ;Remove Driver
       dw     0
wpparm        dw     0              ;pointer in WP dataseg to parameter block 
Mse_Port db   0
DataSeg       dw     0

;Install_DRV
;desc: Installs mouse handler for mouse.com type mouse driver.
;in:   ds:di -- WP Mouse Param Block
;      al -- MSE_Port 
;out:  nothing
;ret:  nothing
;notes:       
;
public Install_DRV
Install_DRV   proc   far

       .save  ax,bx,es              ; Save registers
       mov    Mse_Port,al
       mov    ax,ds
       mov    dataseg,ax
       mov    wpparm,di
       call   dword ptr [di.DetectDriver] ; Is a resident driver available?
        jc    Ind999                       ; No, indicate no mouse installed.
;----- Install our code for mouse action.
       mov    ax,cs                 ; Set Interrupt Subroutine Call Mask
       mov    es,ax                 ;   and Address. es:dx = address
       mov    dx,ofs Drv_Int               ; Point to driver interrupt code.
       mov    ax,12                 ;    /
       mov    cx,AllEvents          ; Interrupt on button or cursor
       int    33h                   ;    activity.
       clc                          ; Clear error return flag.
Ind999:       .ret                         ; Restore registers and return

Install_DRV   endp


;Remove_DRV
;desc:
;in:   nothing
;out:  nothing
;ret:  nothing
;notes:       Assumes that the driver is known to be installed in memory.
;
public Remove_DRV
Remove_DRV           proc   far

       .save  ax,cx,dx,es           ; Save registers
       xor    cx,cx                 ; Clear event mask (no interrupts).
       mov    ax,cs                 ; es = codeseg
       mov    es,ax                 ;   /
       mov    dx,ofs Drv_Int               ; Point to driver interrupt code.
       mov    ax,12                 ; Install user defined subroutine.
       int    33h                   ; Tell mouse driver.
       .ret                         ; Restore registers and return

Remove_DRV           endp

;Drv_Int
;desc: Queues data bytes from resident type of mouse driver.
;in:   Call from mouse driver.
;      ax = status (bits indicate reason for the call)
;      bx = button status
;      cx = absolute x coordinate
;      dx = absolute y coordinate
;      si = relative x displacement
;      di = relative y displacement
;      Unfortunately, si and di are not reset after the call, so we
;      call function 11 of int 33h to get the relative x and y.  This
;      call returns the motion in cx (x) and dx (y).  It is these values
;      that we use for the motion.
;out:  PckSize data bytes on the queue.
;ret:  none
;notes:       This is a far procedure which is called whenever a mouse event occurs.
;      It acts much like an interrupt handler, but is not one.   Even so, the
;      name carrys the _Int ending to indicate that this happens like an
;      interrupt with a mouse event.
;
;      Data bytes are queued as follows:
;             Byte Number
;             0      Event status
;             1      Button status or'ed with Driver Frame Mask
;             2      low byte relative x mouse motion
;             3      low byte relative y mouse motion
;             4      high byte relative x mouse motion
;             5      high byte relative y mouse motion
;             6      high byte bios time ticks
;             7      low byte bios time ticks
;
.public Drv_Int
Drv_Int       proc   far

       .savebp       ax,bx,cx,dx,si,di,ds,es,0 ; Save registers.
       test   al,Bit0                      ; Was there cursor movement?
       mov    ax,dataseg            ; Make sure we are in the proper
       mov    ds,ax                 ;   segments.
       mov    es,ax                 ;   /
        jz    dri200                ; No, skip.
       mov    ax,11                 ; Yes, Read Mouse Motion Counters.
       int    33h                   ; Call driver. (cx=x dx=y)
       neg    dx                    ; Positive motion is up.
       .jmps  dri300                ; Continue.
dri200:       xor    cx,cx                 ; Zero out motion registers.
       xor    dx,dx                 ;   /
dri300:
;++    sar    cx,1                  ; Already accelerated, so slow it down.
;++    sar    dx,1                  ;   /
       mov    di,wpparm
       mov    al,.bl                ; Get original status.
       call   dword ptr [di.MsEvtSt]       ; set current mouse event status
;      mov    al,.al                ; Get original status.
;      mov    bl,.bl                ; Get original button state.
       call   dword ptr [di.MsEvt]         ; Put the bytes in the queue.
       .ret                         ; Restore registers and return.

Drv_Int       endp

lcode  equ    $  
cseg2  ends
       end
