/* ------------------------------------------------------------------------ *
 * 2FAX.C			29-jun-1994			Hans Harder
 *
 *
 *
 *		Convert ascii/pcx files to fax files (ZyXEL formatted)
 *		Based on makefax.pas  written by B.J. Guillot.
 *
 *
 *	NOT INCLUDED the /HDR switch !!!!
 *
 * Compiler : 	Turbo C 2.0   (small memory model)
 *
 * Date:	Changes:					     Version:
 * ---------	---------------------------------------------------  --------
 * 26-sep-94	2 lowres font include files deffont0.c & deffont1.c    1.63
 *		Default font defined at compile time #define DEFFONT
 *		Adapted usage of highres font in lowres mode
 *		BGFAX skipped oddlines & 2FAX even lines (corrected)
 *
 * 20-sep-94	Default font defined in include file : DEFFONT.C       1.62
 *		suggestion of Rudi Peterzen
 *
 * 28-aug-94	Better use of a highres font when scaling in	       1.61
 *		multiples of 2 in lowres faxmode
 *
 * 22-aug-94	Overall speedup of 30% !  			       1.60
 *		Removed pcx_buf and used imageline direct.
 *		PCX repeatrates could be max 63 and could spawn
 *		    more than 2 scanlines ! (bug in old version)
 *		Use of multiple PCXfiles at the same time
 *		use 2 buildlines (with or without pcx) for speed
 *		In lowres mode with scaley=2 with highres font
 *		   use highres font info (huh?, it looks a lot better)
 *		Bug : pagelen incorrect when in highres mode
 *
 * 16-aug-94	Removed break in forloop  for inputfiles,               1.52
 *		left there while debugging
 *		Added some comments to C source
 *		Source code included in ZIP file
 *              INVALIDSWITCH & INPFILEFOUND error added
 *
 *  8-aug-94	Bug removed from readfont                               1.51
 *		PCX speed up
 *
 *  5-aug-94	Use always flexible textline with lots of speedups      1.50
 *		is twice as fast !!!!  (integrated cvtscanline)
 *		Added config file 2fax.cnf
 *
 *  3-aug-94	Use only flexible textline mapping when needed	        1.41
 *		speeds things up
 *
 *  2-aug-94	Flexible textline mapping (sorry, convert gets slower)  1.40
 *		Neccessary in case of prop fonts and fixed fonts
 *		with different dimensions (12x16 - 132ch/line,
 *				                20x16 - 80ch/line)
 *		Also needed it for scaling (large letters)
 *		Added scaling and underlining
 *		Who knows anything more ?
 *		Added /F<fntno> in cmdline
 *		Added command .SC:   scale  (1,2,3,4...)
 *		Added command .SX:   scalex (1,2,3,4...)
 *		Added command .SY:   scalex (1,2,3,4...)
 *		Added command <ESC>U   start underlining
 *		Added command <ESC>u   end   underlining
 *
 *  1-aug-94	Own FONT file.					        1.30
 *		Fontfile with id and headers for each font.
 *		Converted BGFAX.FNT to new layout.
 *		Option for Proportionel fonts included (no fonts
 *		                                       yet available)
 *		In case of a prop.font the FH must be followed by
 *		a specification of the width off each character
 *
 * 31-jul-94	Revision J of BGFAX has a different BGFAX.FNT	        1.20
 *		Support for font F0 and F1, NOT for F2
 *		Added /F0 and /F1 in cmdline
 *		Added command .FN:
 *		Future version will have flexible fonts (ex 12x16)
 *
 * 28-jul-94	/Q quiet switch  					1.11
 *
 *  3-jul-94	Multiple input files from cmdline			1.10
 *		Use of commands in asciifiles :
 *		   .INCLUDE:<lm>,<file>        (pcx and ascii files)
 *		   .OVERLAY:<lm>,<pcxfile>      (signature,logo,map)
 *		   .LM:<lm>		    (set lm for ascii files)
 *		   .PL:<nolines>                (set new pagelength)
 *		   .SP:                          (enable shortpages)
 *		   .F<no>                              (font select)
 *		   .FN:[<no>,]<fontnm>                 (font select)
 *		An overlay combines text and pcx on one line
 *		The <lm> in include and overlay are only used for PCX,
 *		if  <lm> = 0 then the leftmargin is taken.
 *
 *  2-jul-94	Extensions: switches LM (leftmargin), PS (pagesize)	1.03
 *		Tab expansion in ascii files
 *
 *  1-jul-94    Included pcx files					1.02
 *
 * 29-jun-94	Copy of makefax.pas  to C (only ascii files)		1.00
 *		Lot of trouble with those arrays (0-based  1-based)
 *		My pascal isn't that good anymore.
 * ------------------------------------------------------------------------ */
#include <stdio.h>

				/* define which font default at compile time */
				/* nodefines means font must be loaded from  */
				/* 2fax.fnt. Both fonts are lowres !         */
#define		DEFFONT0		            /* font0 default loaded  */
/*#define	  DEFFONT1		            /* font1 default loaded  */

#define 	VERSION		"1.63"
#define 	FALSE		0
#define		TRUE		1

#define		FILENOTFOUND	1			/* errors codes */
#define		LINELENGTH	2
#define 	FNTFILE         3
#define 	FNTNOTFOUND	4
#define	        FNTTOLARGE	5
#define 	PCXFILE         6
#define 	PCXFILETYPE     7
#define 	PCXCOLOR        8
#define 	PCXSIZE         9
#define 	INVALIDSWITCH  	10
#define 	INPFILENOTFOUND 11


/* this arrays are used for CREATING fax images  ORIGINAL MAKEFAX.PAS*/

int	whitea[106][2] = {
    {8,172},{6,56},{4,14},{4,1},{4,13},{4,3},{4,7},{4,15},{5,25},{5,5},{5,28},
    {5,2},{6,4},{6,48},{6,11},{6,43},{6,21},{6,53},{7,114},{7,24},{7,8},
    {7,116},{7,96},{7,16},{7,10},{7,106},{7,100},{7,18},{7,12},{8,64},{8,192},
    {8,88},{8,216},{8,72},{8,200},{8,40},{8,168},{8,104},{8,232},{8,20},
    {8,148},{8,84},{8,212},{8,52},{8,180},{8,32},{8,160},{8,80},{8,208},{8,74},
    {8,202},{8,42},{8,170},{8,36},{8,164},{8,26},{8,154},{8,90},{8,218},{8,82},
    {8,210},{8,76},{8,204},{8,44},{5,27},{5,9},{6,58},{7,118},{8,108},{8,236},
    {8,38},{8,166},{8,22},{8,230},{9,102},{9,358},{9,150},{9,406},{9,86},
    {9,342},{9,214},{9,470},{9,54},{9,310},{9,182},{9,438},{9,50},{9,306},
    {9,178},{6,6},{9,434},{11,128},{11,384},{11,1408},{12,1152},{12,3200},
    {12,640},{12,2688},{12,1664},{12,3712},{12,896},{12,2944},{12,1920},
    {12,3968},{12,2048} };

int	blacka[106][2] = {
    {10,944},{3,2},{2,3},{2,1},{3,6},{4,12},{4,4},{5,24},{6,40},{6,8},{7,16},
    {7,80},{7,112},{8,32},{8,224},{9,48},{10,928},{10,96},{10,64},{11,1840},
    {11,176},{11,432},{11,1888},{11,160},{11,1856},{11,192},{12,1328},
    {12,3376},{12,816},{12,2864},{12,352},{12,2400},{12,1376},{12,3424},
    {12,1200},{12,3248},{12,688},{12,2736},{12,1712},{12,3760},{12,864},
    {12,2912},{12,1456},{12,3504},{12,672},{12,2720},{12,1696},{12,3744},
    {12,608},{12,2656},{12,1184},{12,3232},{12,576},{12,3776},{12,448},
    {12,3648},{12,320},{12,416},{12,2464},{12,3392},{12,832},{12,1440},
    {12,1632},{12,3680},{10,960},{12,304},{12,2352},{12,3488},{12,3264},
    {12,704},{12,2752},{13,1728},{13,5824},{13,2624},{13,6720},{13,1600},
    {13,5696},{13,2496},{13,6592},{13,1472},{13,5568},{13,3520},{13,7616},
    {13,2368},{13,6464},{13,1344},{13,5440},{13,2880},{13,6976},{13,1216},
    {13,5312},{11,128},{11,384},{11,1408},{12,1152},{12,3200},{12,640},
    {12,2688},{12,1664},{12,3712},{12,896},{12,2944},{12,1920},{12,3968},
    {12,2048} };


/* ----------------------------------------------- Settings ------------- */
int		secure	    = FALSE;		/* nooutput if error      */
int		highres     = FALSE;		/* highres mode           */
int		mrcoding    = FALSE;
int		shortpages  = FALSE;            /* do not fillout pages   */
int		parsecmd    = TRUE;		/* parse include commands */
int		pagelen     = 1078;		/* default 11" pagelen    */
int		pageinches  = 11;		/* size of page in inches */
int		pagelines   = 0;                /* size of page in lines  */
int		leftmargin  = 0;                /* default leftmargin     */
int		quiet       = FALSE;            /* suppress output        */


int		errorno	    = 0;		/* return errorcode       */

char		faxpath[68];			/* default path BGFAX env */
char		infn[61];			/* input filename         */
char		outfn[61];                      /* output filename        */
FILE		*outfile;                       /* outfile ptr            */



/* -------------------------------------------------- FONT DATA ------- */
/* Default font in memory BGFAX_FONT_0 / 2FAX_font_0   16x16            */

char		fontnm[41] = "2FAX.FNT";
#if defined(DEFFONT0)
#include "deffont0.c"
  int		fontread = TRUE;       /* sw if font has been read      */
  int		fontno   = 0; 	       /* default font BGFAX_F0 16x16   */
#elif defined(DEFFONT1)
#include "deffont1.c"
  int		fontread = TRUE;       /* sw if font has been read      */
  int		fontno   = 1; 	       /* default font BGFAX_F1 16x16   */
#else
  unsigned char	font[24600];           /* font definitions              */
  int		fontread = FALSE;      /* sw if font has been read      */
  int		fontno   = 0;
#endif
char		fonttype = 'F';	       /* 'F'ixed or 'P'roportionel     */
char		fontres  = 'L';	       /* 'L'ow or 'H'ighres font       */
char		fontbw   = 2;	       /* fontwidth in bytes            */
char		fontw    = 16;         /* fontwidth in pixels           */
char		fontd    = 16;         /* fontdepth in pixels           */
				       /* chars always the same depth   */
unsigned char	chbw[256];             /* each char width in bytes      */
unsigned char	chw[256];              /* each char width in pixels     */

unsigned char	*chp[256];             /* pointer to char definition    */
				       /* offset to font definition     */

int		underline = 0;	       /* underline active or not       */
int		bold      = 0;	       /* not used, don't know how yet  */
int		scalex    = 1;	       /* xscale factor                 */
int		scaley    = 1;         /* yscale factor                 */


struct {
 unsigned	bitmapsize;
 char   	name[16];
 char		type;
 char		res;
 char		baseline;
 char		undwidth;
 char		width;
 char		depth;
 unsigned char	start;
 unsigned char  end;
} FH;				       /* FONTHEADER */


int		tlines;		       /* current textlineno of page */
int		slen;   	       /* cur width of sarray        */
unsigned char	sarray[208];	       /* textregel                  */

int		lines;		       /* immageline no              */
unsigned char	imagebuf[216];	       /* 1 scanline = 1728 pixels   */

				       /* buffer the output by 8k blocks */
#define		MAXOUTBUF	8192
int		outbufbyte, outbufbit; /* position in outbuf         */
unsigned char	outbuf[MAXOUTBUF];     /* 1..maxoutbuf               */

typedef struct {
   FILE 		*fp;		/* pcx file pointer */
   int			pos;            /* position         */
   int			bytes;          /* width in bytes   */
   int			rep;            /* repetitions left */
   unsigned char	val;            /* rep. value       */
} Tpcxd;
Tpcxd		pcxd[10];		/* max of 10 simult. pcxfiles */

int		pcx_no = 0;		/* no of open pcxfiles */
int		pcx_lm;			/* temporary needed */

struct {			        /* PCX file header */
  char		zsoft;
  char		version;
  char		encoding;
  char		bitpix;
  int		dimens0;
  int		dimens1;
  int		pixw;
  int		pixd;
  int		hres;
  int		vres;
  char		palette[48];
  char  	reserved;
  char  	planes;
  int		byteline;
  int		paltype;
  int		xssize;
  int		yssize;
  char		filler[54];
} pcx;


struct {			       /* Zyxel fax header */
  char  	header[5];
  char  	offset;
  int   	version;
  int   	reserved;
  int   	pgwidth;
  int   	pgcount;
  int		coding;
} zfax;




main(int argc, char *argv[])
{
  int	i, nofiles;

  printf("2FAX %-4s                           BGFAX PCX/ASCII to FAX converter utility.\n",VERSION);
  printf("Written by Hans Harder              Based on MAKEFAX.PAS from B.J. Guillot.\n\n");

  Readconfig();					/* Read defaults */
  nofiles = checkcmdline(argc,argv);

  FAXinit();
  FAXheader(outfile);

  for (i=1; i<nofiles; i++)  {
     if (i!=1) makeendofpage(TRUE); 	                     /* end of page */
     insertlines(8);		  /* make 8 blank scan lines for top margin */
     getparamfn(i,argv,infn);	                 /* get next inputfile name */
     Readfile(infn);                                   /* convert inputfile */
  }
  while (pcx_no) {	                             /* while pcxfiles open */
     buildpcxline();
     cvtscanline();
  }
  makeendofpage(TRUE); 	                                    /* end of page */
  FAXexit();
  exit(errorno);		              /* return errorno  0=success */
}


int     DEFFONTinit()				      /* default font build */
{
  int		i;
  unsigned char	*pos;

  pos = &font[0];
  for (i=0; i<=255; i++) {
      chbw[i] = fontbw;
      chw[i]  = fontw;
      chp[i]  = pos;
      pos += fontbw*fontd;
  }
}

int	FAXinit()
{
  DEFFONTinit();			/* version 1.62 */
  lines=tlines=0;			/* init vars  & open output file */
  outbufbit=9;
  outbufbyte=0;
  outfile = fopen(outfn,"wb");
}


int FAXexit()
{
  fwrite(outbuf,outbufbyte,1,outfile);			/* flush remaining */
  fclose(outfile);
  headerupdate();					/* save pageno     */
}


int	seterror(int err)		/* error encoutered          */
{
   if (!errorno) errorno = err;         /* save only the first error */
   if (secure) {                        /* if no errors allowed      */
       FAXexit();                       /* close output file         */
       unlink(outfn);		        /* remove outputfile         */
       exit(errorno);			/* exit with errorno         */
   }
}



int	showsyntax()
{
  printf("Syntax   : 2FAX <infile1> ... <infilen> <outfile> [<switches> ....]\n");
  printf("Switches : /SP   = shortpage         /PL:66 = nolines on a page\n");
  printf("           /LM:8 = leftmargin        /PI:11 = pagelength in inches\n");
  printf("           /HR   = highresolution    /MR    = mrcoding\n");
  printf("           /Q    = quiet mode        /SEC   = stop on error\n");
  printf("           /SX:2 = scalex factor     /SY:2  = scaley factor\n");
  printf("           /SC:2 = scale factor      /F1    = fontno\n");
  printf("           /FN:0,courier.fnt  = fontnr & font filename\n");
  printf("\nDefault switches can be set in the file 2FAX.CNF\n");
  exit(1);
}


/* -------------------------------- get the <no> file from the commandline */
int	getparamfn(int no, char *argv[], char *fn)
{
  int 	i, n;

  n=0;
  for (i=1; n<no; i++) {
      if (*argv[i]!='/') {				/* a filename */
	  n++;
	  if (n==no) strcpy(fn,argv[i]);
      }
  } /*for*/
}

/* ----------- set cmdline switches, the HR and 2d only allowed from cmdline */
int	setswitches(char *sw, int cmdline)
{
  char	*sws[] = {"hr","2d","sp","sec","nc","pl:","pi:",
		  "q","lm:","fn:","f","sc:","sx:","sy:", 0};
  int	i,ok;

  ok=1;
  for (i=0; sws[i]!=0; i++) if (strnicmp(sws[i],sw,strlen(sws[i]))==0)  break;

  switch (i) {
    case 0  : if (cmdline) highres=TRUE;  break;
    case 1  : if (cmdline) mrcoding=TRUE; break;
    case 2  : shortpages=TRUE;	          break;
    case 3  : secure=TRUE;                break;
    case 4  : parsecmd=FALSE;	          break;
    case 5  : pagelines=atoi(&sw[3]);
	      pagelen=(pagelines*16) + 8;
	      shortpages=FALSE;
              break;
    case 6  : pageinches=atoi(&sw[3]);
	      pagelen=pageinches*98;   		      /* resolution 98 lpi */
	      shortpages=FALSE;
	      break;
    case 7  : quiet=TRUE;		  break;
    case 8  : leftmargin=atoi(&sw[3]);    break;
    case 9  : if (strchr(&sw[3],',')!=0) {	    /* if fontno specified */
		  sscanf(&sw[3],"%d,%s",&fontno,fontnm);
		  Readfont();
	      } else
		  strcpy(fontnm,&sw[3]);
	      break;
    case 10 : fontno = atoi(&sw[1]);
	      Readfont();
	      break;
    case 11 : scalex = scaley = atoi(&sw[3]);   break;
    case 12 : scalex = atoi(&sw[3]);            break;
    case 13 : scaley = atoi(&sw[3]);            break;
    default : seterror(INVALIDSWITCH);
              ok=0;
  }
  return(ok);
}



/* -------------------------------------- READ config file and set switches */
int 	Readconfig()
{
  FILE	*fp;
  int	i;
  char	str[133];

  sprintf(str,"%s\\2fax.cnf",faxpath);
  if (access("2fax.cnf",0)==0)		     /* try to open local file first */
      fp=fopen("2fax.cnf","r");
  else if (access(str,0) == 0)		     /* try to open in BGFAX env */
      fp=fopen(str, "r");
  else
      return;				     /* NO 2fax.cnf file found */
  while ((fgets(str,132,fp))!=0) {
     stripline(str);			     /* remove trailing chars <= ' ' */
     if (*str!='#') {
	 for (i=0; (str[i]!=0 && str[i]!= ' '); i++);
	 str[i]=0;
	 setswitches(str,1);
     }
  }
  fclose(fp);
}


/* ----------------------------------------------------- Parse commandline */
int	checkcmdline(int argc, char *argv[])
{
  int	i, no;

  if (argc<3) showsyntax();

  strcpy(faxpath,getenv("BGFAX"));
  if (*faxpath==0)  strcpy(faxpath,".");    	      /* current directory */

  no=0;
  for (i=1; i<argc; i++) {
      if (*argv[i]=='/') {			               /* switches */
	  setswitches(&argv[i][1],1);
      } else 				    /* source and destination file */
	  strcpy( (no++)?(outfn):(infn), argv[i]);
  } /*for*/

  if (no<2) showsyntax();		             /* minimum of 2 files */
  return(no);
}



/* ------------------------------------------- Check if file is ASCII or PCX */
int checkfile(char *fn)
{
  FILE *fp;
  char	ch;

  if ( (fp=fopen(fn,"rb"))==0)  {		  /* check file exists       */
	seterror(FILENOTFOUND);
	printf("File %s not found !\n",fn);
	return(0);
  }
  fread(&ch,1,1,fp);				  /* determine if PCX file   */
  fclose(fp);
  return( (ch==10)?(1):(2));	           /* return filetype 1=PCX  2=ASCII */
}


int 	Readfont()
{
  FILE	*fp;
  int	i, size, noch, fntno;
  char	idstr[8],nofonts;
  unsigned char	*pos;
  char	fn[81];

  fntno = fontno + 1;
  if ( (fp=fopen(fn,"rb"))==NULL) {		/* first try if local */
      sprintf(fn,"%s\\%s",faxpath,fontnm);	/* try with BGFAX env */
      fp=fopen(fontnm,"rb");
  }
  if (fp) {					                /* if found */
      if (!fontread) fontread=TRUE;
      fread(idstr,1,7,fp);			       /* Read '2FAXFNT' id */
      if (strncmp(idstr,"2FAXFNT",7)==0) {
        fread(&nofonts   ,1,1,fp);
	if (fntno<=nofonts) {
	  do {
	    fntno--;
	    fread(&FH,sizeof(FH),1,fp);		         /* read fontheader */
	    noch = FH.end - FH.start + 1;
	    if (fntno) {			   /* if not requested font */
	       size = FH.bitmapsize;
	       if (FH.type=='P')  size += noch;	           /* add prop info */
	       fseek(fp,size,SEEK_CUR);	        /* point to next fontheader */
	    }
	} while (fntno);
	if (FH.bitmapsize>24600) {
	    seterror(FNTTOLARGE);
	    return;
	}
	fonttype= FH.type;
	fontres = FH.res;
	fontbw  =(FH.width+7)/8;
	fontw   = FH.width;
	fontd   = FH.depth;
	if (fonttype=='P')			      /* read char. widths */
	   fread(&chw[FH.start],1,noch,fp);
	else
	   memset(&chw[FH.start],fontw,noch);
	memset(&chp[0],0,256);			      /* clear ch pointers */
	pos = &font[0];
	for (i=FH.start; i<=FH.end; i++) {
	   if (fonttype=='P') fontbw = (chw[i]+7)/8;
	   chbw[i] = fontbw;
	   fread(pos,fontbw,fontd,fp);		      /* load char data */
	   chp[i] = pos;
	   pos += fontbw*fontd;
	}
      } else {
	printf("Requested fontno %d not in fontfile\n",fntno);
	seterror(FNTNOTFOUND);
      }
    } else {
      printf("This is not a 2FAX font file\n");
      seterror(FNTFILE);
    }
    fclose(fp);
  } else {
      printf("Font file [%s] not found !\n",fn);
      seterror(FNTFILE);
  }
}


int	Readfile(char *fn)
{
  switch (checkfile(fn)) {
    case  1 : Readpcx(fn);    break;
    case  2 : Readascii(fn);  break;
    default : return(0);
  }
  return(1);
}


int	stripline(unsigned char *str)	/* remove trailing chars less than ' ' */
{
  int i;
  for (i=strlen(str)-1; (i>=0 && str[i]<32); i--)  str[i]=0;
}


int	expandtabs(char *str)			/* simple tab expansion */
{
  int	i,no;

  for (i=0; str[i]!=0; i++) {
      if (str[i]=='\t') {
	  no=8-(i%8);			      /* calc no of spaces to insert */
	  str[i]=' ';			      /* replace TAB value           */
					/* can be done in 1 memmove & memset */
	  while (--no) {
	      i++;
	      memmove(&str[i+1],&str[i], 1);               /* insert a space */
	      str[i]=' ';
	  } /*while*/
      }
  } /*for*/
}


int	CHECKcmd(char *str)		        /* check for cmd's in line */
{
 int	cmd;

 cmd=0;
 if (parsecmd && *str=='.') {			          /* check for cmd's */
     if ((strnicmp(str,".INCLUDE:",9)==0 || strnicmp(str,".OVERLAY:",9)==0)
	    &&  strchr(&str[9],',')!=0) {
	 cmd=1;
	 sscanf(&str[9],"%d,%s",&pcx_lm,infn);
	 if (pcx_lm==0)  pcx_lm = leftmargin;
	 pcx_lm*=2;
	 if (str[1]=='I' || str[1]=='i')
	     Readfile(infn);
	 else {
/*	     if (pcx_fp) fclose(pcx_fp);               /* only when not busy */
	     Openpcx(infn);
	 }
     } else
	 cmd = setswitches(&str[1],0);
  }
  return (cmd);				             /* return 0 if no cmd's */
}


int	Readascii(char *fn)			         /* Read ASCII file */
{
  FILE 		*fp;
  char		str[256];
  int		ff;

  if (!fontread) {  Readfont();  fontread=TRUE; }
  if (!quiet) printf("Reading %s...\n",fn);
  slen = 0;
  if ((fp=fopen(fn,"r"))==NULL) {
       seterror(INPFILENOTFOUND);
       return;
  }
  while (fgets(str,255,fp)!=0) {			/* read one line */
     if (*str==12) {				          /* if formfeed */
	 makeendofpage(FALSE);
	 insertlines(8);
     } else {
	 ff=0;
	 if (strchr(str,12)!=0) ff=1;	   /* formfeed somewhere in line */
	 stripline(str);
	 if (CHECKcmd(str)==0) {	                   /* no cmdline */
	    expandtabs(str);
	    slen = strlen(str);
	    if (slen>200) {
		slen=200;			          /* set nowrap */
		seterror(LINELENGTH);
	    }
	    strncpy(sarray,str,slen);
	    processtextline();
	 }
	 if (ff) {
	     makeendofpage(FALSE);
	     insertlines(8);
	 }
     }
  } /*while*/
  fclose(fp);
}


int	Openpcx(char *fn)
{
  int	ok, i;

  for (i=0; (i<10 && pcxd[i].fp!=0); i++);
  if (i==10) {					/* more than 10 ?? */
       printf("Too many open PCXfiles\n");
       seterror(PCXFILE);
       return(0);
  }
  pcxd[i].rep = 0;
  if ((pcxd[i].fp=fopen(fn,"rb"))==0)  {
       printf("Unable to open PCXfile %s\n",fn);
       seterror(PCXFILE);
       return(0);
  }
  fread(&pcx,sizeof(pcx), 1, pcxd[i].fp);			/* Read PCX header */
  if (pcx.zsoft!=10) {
      printf("This is not a PCX file [%s]\n",fn);
      seterror(PCXFILETYPE);
      fclose(pcxd[i].fp);
      pcxd[i].fp=0;
      return(0);
  }
  if (pcx.bitpix!=1 ||  pcx.planes!=1) {
      printf("Only 2-color PCX files can be converted\n");
      seterror(PCXCOLOR);
      fclose(pcxd[i].fp);
      pcxd[i].fp=0;
      return(0);
  }
  if (pcx.pixw > 1727) {
      printf("Page width must be 1728 bits or shorter\n");
      seterror(PCXSIZE);
      fclose(pcxd[i].fp);
      pcxd[i].fp=0;
      return(0);
  }

  while (pcx_lm && (pcx_lm+pcx.byteline) > 200)     	/* check leftmargin if ok */
	pcx_lm--;

  pcxd[i].pos   = pcx_lm;
  pcxd[i].bytes = pcx.byteline;
  pcx_no++;

  if (!quiet) printf("Reading %s... [%d width,  %d lines]\n",
		       fn,pcx.pixw,pcx.pixd);
  return(i+1);						     /* return 1-10 */
}



int	Readpcx(char *fn)
{
  int no;

  if ((no=Openpcx(fn))!=0 ) {
      no--;				   /* returned 1-10, array 0 based */
      while (pcxd[no].fp!=0) {			          /* while pcxdata */
	  buildpcxline();
	  cvtscanline();
      }
  }
}


/* ------------------------------------------------------------------------ *
 * Only in highresolution mode take every scanline of the PCX file
 * in normalresolution take every other scanline to keep proportions !
 * ------------------------------------------------------------------------ */
int	makepcxline(Tpcxd *p)
{
  unsigned char	*ptr, v;
  int		no, i, r, rp, showline;

  ptr = &imagebuf[p->pos];			           /* point to dest */
  no  = p->bytes;  		                      /* get width in bytes */
  r   = p->rep;				                   /* rep rate left */
  v   = p->val;                                               /* last value */
  showline = (highres)?(1):(0);	            /* when in low, skip first line */
						     /* to keep proportions */
  while (no) {
      if (r==0) {
	  if (fread(&v,1,1,p->fp)==0) {
	      fclose(p->fp);
	      pcx_no--;				         /* 1 less pcx file */
	      p->fp=0;			                     /* make vacant */
	      return(0);   			          /* end of pcxfile */
	  }
	  if ((v&192)==192)  {     		 /* repetition  bit 8&7 set */
	      r = v ^ 192;  			          /* get count 0-63 */
	      fread(&v,1,1,p->fp);
	  } else
	      r = 1;                                   /* just 1 byte value */
      }
      if (r==1) {
	  no--;
	  r=0;
	  if (showline) *ptr++ &= v;
      } else {
	  rp = (r>no)?(no):(r);
	  no-=rp;
	  r -=rp;
	  p->val = v;			        /* save value for next line */
	  if (showline) while (rp--)  *ptr++ &= v;
      }
      if (no==0 && !showline) {
	  no = p->bytes;		                    /* do next line */
	  showline=1;
      }
  } /*while*/
  p->rep = r;					           /* rep rate left */
  return(1);
}

int	buildpcxline()
{
  int	i;
  setmem(imagebuf, sizeof(imagebuf),255);
  for (i=0; i<10; i++)   if (pcxd[i].fp!=0)  makepcxline(&pcxd[i]);
}

int  FAXheader(FILE *fp)		               /* write a faxheader */
{
   memset(&zfax,sizeof(zfax),0);
   strcpy(zfax.header,"ZyXEL");
   zfax.offset  = 0;
   zfax.version = 2;
   zfax.reserved= 0;
   zfax.pgwidth = 1728;
   zfax.pgcount = 0;
   zfax.coding  = 0;     		                     /* 1d-low res */
   if (highres)  zfax.coding++;
   if (mrcoding) zfax.coding+=2;
   memmove(outbuf, &zfax, sizeof(zfax));
   outbuf[sizeof(zfax)] = 0;
   if (mrcoding)
      outbuf[sizeof(zfax)+1] = 192;  	              /* eol+mh coding bit */
   else
      outbuf[sizeof(zfax)+1] = 128;  	   /* dummy EOL to start fax image */
   fwrite(outbuf,sizeof(zfax)+2,1,fp);
   setmem(outbuf,sizeof(zfax)+2,0);	                 /* cleanup outbuf */
}


int	headerupdate()                                /* update page count */
{
  outfile = fopen(outfn,"rb+");
  fwrite(&zfax,sizeof(zfax),1,outfile);
  fclose(outfile);
  printf("Total %d page(s).\n",zfax.pgcount);
}


/* -------------------------------------------------------- Buffered output */
void pascal	putoutbit(int b)		/* pascal for speed ? */
{

  if (outbufbit>=7) {
      outbufbyte++;
      outbufbit=0;
      if (outbufbyte > MAXOUTBUF) {
	  fwrite(outbuf,MAXOUTBUF,1,outfile);
	  memset(outbuf, 0, MAXOUTBUF);
	  outbufbyte = 1;
      }
  } else
      outbufbit++;
  if (b) outbuf[outbufbyte-1] ^= 1<<outbufbit;
}


void pascal 	addtostream(int token, int color)
{
  int	i,v,m,n;

  if (color) {
     m = whitea[token][0];
     n = whitea[token][1];
  } else {
     m = blacka[token][0];
     n = blacka[token][1];
  }

  for (v=i=1; i<=m; i++)  {  putoutbit(n&v); v<<=1; }
}


int	addeol()
{
  int	k;

					/* was k = (mrcoding)?(3):(4); */
  k = (mrcoding)?(2):(3);  		/* now 0-based */
  while (outbufbit!=k)  putoutbit(0);   /* FILL so that EOL's are byte aligned */
  addtostream(104, TRUE);    		/* eol token */
  if (mrcoding)         putoutbit(1);  	/* next line will be mh-coding */
}

/* -------------------------------------------- Insert num of blank lines */
int	insertlines(int num)
{
  int	i;

  lines+=num;
  for (i=1; i<=num; i++) {
       addtostream(90, TRUE);   		/* white 1728 makeup code */
       addtostream(0 , TRUE);   		/* white 0 final code     */
       addeol();
  }
}


int	makeendofpage(int endoffax)
{
  int	i, j, no, size;

  if (!shortpages)  {			                  /* fill out page */
      size = pagelen;
      if (highres) size*=2;
      insertlines(size-lines);
  }

  no = (endoffax)?(6):(7);
  zfax.pgcount++;
  for (i=1; i<=no; i++) {
       for (j=1; j<=11; j++)  putoutbit(0);
       putoutbit(1);
       if (mrcoding)   putoutbit(1);
  }
  tlines=lines=0;				        /* reset counters */
}


int	countmh(int count, int totalcount, int *color, int endofline)
{
  totalcount+=count;
  if (endofline && totalcount!=1728) {
      count+=1728-totalcount;
      totalcount=1728;
  }
  if (count > 63) {
      addtostream((count / 64)+63, *color);      	/* makeup code*/
      addtostream( count % 64    , *color); 		/* final code */
  } else
      addtostream(count, *color);

  if (endofline)    addeol();
  *color = (*color)?(0):(1);
  return(totalcount);
}


/* ---------------------------------------------- still used for PCX files */
int	cvtscanline()
{
  int	        repeatbits, tcount, color, width;
  unsigned char *pp, *lastpp, pb, bit, lastbit;

  for (width=sizeof(imagebuf)-1; (width>0 && imagebuf[width]==255); width--);
  lastpp = &imagebuf[width];
  pp = imagebuf;
  pb = 128;

  lines++;
  tcount     = 0;
  color      = TRUE;
  lastbit    = 1;
  repeatbits = 64;

  while (pp<=lastpp) {
	bit = (*pp&pb)?(1):(0);
	if (bit == lastbit)
	    repeatbits++;
	else {
	    tcount = countmh(repeatbits, tcount, &color, FALSE);
	    repeatbits = 1;
	    lastbit    = bit;
	}
	if (pb==1) {   				           /* next bit/byte */
	    pb=128; pp++;
	    while (*pp==(lastbit)?(0xff):(0) && pp<=lastpp) {	/* speed up */
	       repeatbits+=8;
	       pp++;
	    }
	} else pb >>= 1;
  } /*while*/
  tcount = countmh(repeatbits, tcount, &color, lastbit);
  if (lastbit==0)             		            /* make last pixel blank */
      tcount = countmh(1, tcount, &color, TRUE);
}


int buildpcxascii(int len, unsigned char *str, char scanline, char swunder)
{
  unsigned char *p, *pp, *lastpp, pb, chno;
  char		w;
  int		i, j, b;
  int	        fbit, bit, lastbit, repeatbits, tcount, color;

  lines++;
  buildpcxline();		                     /* overlay pcxscanfilea */

  for (i=sizeof(imagebuf)-1; (i>0 && imagebuf[i]==255); i--);
  lastpp = &imagebuf[i];		/* last byte with info */

  tcount     = 0;
  color      = TRUE;
  lastbit    = 1;
  repeatbits = 64 + (leftmargin*16);

  pp = &imagebuf[leftmargin*2];
  pb = 128;
  while (len--) {				       /* for each character */
     chno = *str++;					         /* get char */
     if (chno==27) {			      /* check escape sequences */
       underline=(*str++=='U')?(1):(0);
       len--;
     } else {
       if (chp[chno]==0) chno=32;	   /* if not in charset take a space */
       if (chp[chno]!=0) {	        /* if char exists in font definition */
					    /* point to char scanline bitmap */
	   p = chp[chno] + (scanline * chbw[chno]);
	   w = chw[chno];		                  /* get pixel width */
	   b = 128;					        /* bit 7 set */
	   if (swunder && underline) {		   /* speed up for underline */
	       if (lastbit==0)
		   repeatbits+=w*scalex;
	       else {
		   tcount     = countmh(repeatbits, tcount, &color, FALSE);
		   repeatbits = w*scalex;
		   lastbit    = 0;
	       }
	       for (i=w*scalex; i>0; i--) {		/* skip pcx bits */
		   if (pb==1) { pb=128; pp++; }
		   else pb >>= 1;
	       }
	       w=0;				/* simple way to skip remain */
	   }
	   for (i=0; i<w; i++) {		     /* for each bit in char */
	     fbit = ((*p&b)==0)?(1):(0);	          /* is it on or off */
	     for (j=0; j<scalex; j++) {
	       if (fbit  ||  (*pp&pb)==0)
		    bit = 0;
	       else
		    bit = 1;
	       if (bit == lastbit)		       /* cvtscanline() func */
		   repeatbits++;
	       else {
		   tcount = countmh(repeatbits, tcount, &color, FALSE);
		   repeatbits = 1;
		   lastbit    = bit;
	       }
	       if (pb==1) { pb=128; pp++; }		/* next bit/byte */
	       else pb >>= 1;
	     } /*for*/
	     if (b==1)  { b=128;  p++; }
	     else b >>= 1;				    /* next char bit */
	   } /*for*/
       }
     } /*else*/
  }
  while (pp<=lastpp) {
	bit = (*pp&pb)?(1):(0);
	if (bit == lastbit)
	    repeatbits++;
	else {
	    tcount = countmh(repeatbits, tcount, &color, FALSE);
	    repeatbits = 1;
	    lastbit    = bit;
	}
	if (pb==1) {					   /* next bit/byte */
	    pb=128; pp++;
	    while (*pp==(lastbit)?(0xff):(0) && pp<=lastpp) {	/* speed up */
	       repeatbits+=8;
	       pp++;
	    }
	} else pb >>= 1;
  }
  tcount = countmh(repeatbits, tcount, &color, lastbit);
  if (lastbit==0)             		            /* make last pixel blank */
      tcount = countmh(1, tcount, &color, TRUE);
}


int buildascii(int len, unsigned char *str, char scanline, char swunder)
{
  unsigned char *p;
  char		w;
  int		chno;
  register	i, j, b;
  int	        bit, lastbit, repeatbits, tcount, color;

  lines++;
  tcount     = 0;
  color      = TRUE;
  lastbit    = 1;
  repeatbits = 64 + (leftmargin*16);

  while (len--) {				       /* for each character */
     chno = *str++;					         /* get char */
     if (chno==27) {			      /* check escape sequences */
       underline=(*str++=='U')?(1):(0);
       len--;
     } else {
       if (chp[chno]==0) chno=32;	   /* if not in charset take a space */
       if (chp[chno]!=0) {	        /* if char exists in font definition */
					    /* point to char scanline bitmap */
	   p = chp[chno] + (scanline * chbw[chno]);
	   w = chw[chno];		                  /* get pixel width */
	   b = 128;					        /* bit 7 set */
	   if (swunder && underline) {		   /* speed up for underline */
	       if (lastbit==0)
		   repeatbits+=w*scalex;
	       else {
		   tcount     = countmh(repeatbits, tcount, &color, FALSE);
		   repeatbits = w*scalex;
		   lastbit    = 0;
	       }
	       w=0;				/* simple way to skip remain */
	   }
					     /* speed up for blank scanlines */
	   while (lastbit && *p==0xff && w>0) {
		  p++;
		  repeatbits+=((w>=8)?(8):(w))*scalex;
		  w-=8;
	   } /* while*/
	   for (i=0; i<w; i++) {		     /* for each bit in char */
	     bit = ((*p&b)==0)?(0):(1);                   /* is it on or off */
	     if (bit == lastbit)		       /* cvtscanline() func */
		   repeatbits+=scalex;
	     else {
		   tcount = countmh(repeatbits, tcount, &color, FALSE);
		   repeatbits = scalex;
		   lastbit    = bit;
	     }
	     if (b==1)  { b=128;  p++; }
	     else b >>= 1;				    /* next char bit */
	   } /*for*/
       }
     } /*else*/
  }
  tcount = countmh(repeatbits, tcount, &color, lastbit);
  if (lastbit==0)             		            /* make last pixel blank */
      tcount = countmh(1, tcount, &color, TRUE);
}




/* ------------------------------------------------------------------------ *
 * Translate characters in pixels on a scanline
 * Different fontmatrixes
 * ------------------------------------------------------------------------ */
int	processtextline()
{
  int	i, j, kj, len, w, swunder1, swunder2;
  int	step, dbl, scy;

  if (lines > (pagelen<<highres)) {
      makeendofpage(FALSE);
      insertlines(8);		                /* keep room for header ?? */
  }
  tlines++;
  if (!quiet && (tlines%10)==0)
      printf("{page%d, line %d}\r",zfax.pgcount+1,tlines);

  if (scalex==0) scalex=1;		/* make sure correct scale factors */
  if (scaley==0) scalex=1;

  w=leftmargin*16;
  for (i=0; i<slen; i++) {		          /* calculate pixel width */
       w += chw[sarray[i]] * scalex;
       if (w>1600) { 			  		  /* line to large */
	   slen=i;
	   seterror(LINELENGTH);
       }
  }

  step=1;
  scy=scaley;
  if (!highres && fontres=='H')  step=2;       /* Highres font in normal res */
  if ( highres && fontres=='L')  scy*=2;          /* Lowres font in high res */
  if (step==2 && scy>1 && (scy%2)==0) {
      step=1;
      scy/=2;
  }

  swunder1 = FH.baseline+2;		  /* calc valid underline scanlines */
  swunder2 = swunder1 + FH.undwidth - 1;
  sarray[slen]=0;


  if (pcx_no) {
      for (i=0; i<fontd; i++) {			      /* for each scanline */
	for (j=0; j<scy; j++)
	  buildpcxascii(slen,sarray,i, (i>=swunder1 && i<=swunder2)?(1):(0));
	if (step==2) i++;
      }
  } else {
      for (i=0; i<fontd; i++) {			      /* for each scanline */
	if (step==2) i++;
	for (j=0; j<scy; j++)
	   buildascii(slen,sarray,i, (i>=swunder1 && i<=swunder2)?(1):(0));
      }
  }
}

