/* text.c Written by Andrew Punch 31/3/98 */
/* Performs text conversion. See dox.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dox.h"

#define MAX_LINE_LEN 80

void text_readword(FILE *instream, char *word);


void text_convert(state_type *state)
{
char word[81];

default_style(state, TRUE);
update_style(state);

while (!feof(state->in))
        {
        text_readword(state->in, word);
        if (word[0]=='\n')
                {
                state->new[st_break]++;
                update_style(state);
                }
        else
                output(state, word);
        }
}


void text_output(state_type *state, char *word)
{
state->cur_line_len = state->cur_line_len + strlen(word);

if (state->cur_line_len > MAX_LINE_LEN)
        {
        fprintf(state->out, "\n");
        state->cur_line_len = strlen(word);
        }

fprintf(state->out, "%s", word);
}


void text_update_style(state_type *state)
{
for (;state->new[st_break]>0;state->new[st_break]--)
        {
        fprintf(state->out, "\n");
        state->cur_line_len = 0;
        }
}

void text_readword(FILE *instream, char *word)
{
unsigned c;
unsigned count=0;
unsigned done=FALSE;

while ((count<80)&&(!done)&&(!feof(instream)))
	{
        word[count] = fgetc(instream);
        done=(strrchr("\r\n\t ", word[count])!=NULL);
	count++;

	c = nextchar(instream);
        done=((strrchr("\r\n\t ",c)!=NULL)||done);
	}

word[count]='\0';
}

