//		Dosdisk.h
//	Include file for makeems project
//	Definitions for Drive Parameter Block
#ifndef _DOSDISK_H
#define _DOSDISK_H

#ifndef _STDIO_H
#include <stdio.h>
#endif

typedef unsigned int  WORD;
typedef unsigned char BYTE;

typedef struct _tdpb
{
	BYTE  driveNo;
	BYTE  unitNo;
	WORD  bytesPerSector;
	BYTE  sectorsPerCluster;
	BYTE  shift;
	WORD  bootSectors;
	BYTE  copiesFAT;
	WORD  maxRootDir;
	WORD  firstDataSector;
	WORD  highestClst;
	WORD  sectorsPerFAT;
	WORD  firstDirSector;
	WORD  far *deviceDriver;
	BYTE  mediaDescriptor;
	BYTE  accessFlag;
	struct _tdpb far *pNext;
} T_DPB;

typedef T_DPB *P_DPB;
typedef T_DPB far *FP_DPB;

typedef struct _olddpb
{
	char driveNo;
	char unitNo;
	WORD bytesPerSect;
	char sectorsPerClst;
	char shift;
	WORD bootSectors;
	char copiesFAT;
	char maxRootDir;
	WORD firstDataSect;
	WORD highestClst;
	char sectorsPerFAT;
	WORD firstDirSect;
	WORD far *DeviceDriver;
	char mediaDescriptor;
	char accessFlag;
	struct _olddpb far *pNext;
} T_OldDPB;

typedef T_OldDPB *P_OldDPB;
typedef T_OldDPB far *FP_OldDPB;

#define FILENAME_LEN 11
typedef struct
	{
	char	cpName[FILENAME_LEN];
	char	cAttr;
	char	cpReserved[10];
	long	lTime;
	WORD	wTopClst;
	long	lSize;
	} DIRENT;

typedef DIRENT * P_DIRENT;
typedef WORD * P_FAT;

// function prototypes
int getDPB (int idDrive, FP_DPB *pfpDPB);
void flushDiskBuffers (void);
int printDPB (FILE *f, FP_DPB fpDPB);

#endif
