/***************************************************************************/
#include	<lxapi.h>
#include	<string.h>
#include	<stddef.h>
#include	<dos.h>
#include	<ctype.h>

/***************************************************************************/
#define	LISTCOLUMNS	30
#define LISTLINES	14
#define	CMDLEN		256

char cfgPath[32]="c:\\_dat\\launcher.cfg";
char keysign[6]="$key,";
typedef struct{
	unsigned int	hotKey;
	char			sign[6];
	char			envPath[24];
	long			offset;
}PIMInfo;
PIMInfo	pimInfo[]={
			{0xb000,	"$adb,",	"c:\\_dat\\apptbk.env"	,0},
			{0xb400,	"$pdb,",	"c:\\_dat\\phone.env"	,0},
			{0xba00,	"$gdb,",	"c:\\_dat\\db.env"		,0},
			{0xbe00,	"$ndb,",	"c:\\_dat\\note.env"	,0},
		};

char far	*strAppName		="Pocket Launcher";
char far	*strHelpBtn		="Help";
char far	*strLaunchBtn	="Launch";
char far	*strQuitBtn		="Quit";
char far	*strAboutText	="Pocket Launcher ver.1.02\r\n"
							"\r\n"
							"Created by TONTATA(爤D)\r\n"
							"Copyright (c) 1995 by TONTATA\r\n"
							"All rights reserved.\r\n";
char far	**strAboutPtr	=&strAboutText;
char far	**strTable[]={
	&strAppName,
	&strHelpBtn,
	&strLaunchBtn,
	&strQuitBtn,
	&strAboutText,
	(char far **)&strAboutPtr,
};

/***************************************************************************/
BOOL		done=FALSE;
LHAPIBLOCK	capData;
EVENT		app_event;
EXEC_STRUCT	st_exec;
char far	*sysMgrPtrs[16];

/***************************************************************************/
#if defined(TURBOC)
#define GetDataSeg()	_DS
#endif
#if defined(LSIC)
int _asm_(char *);
#define GetDataSeg()	_asm_(" mov ax,ds\n")
#endif

void
FixupFarPtrs(void)
{
int i,dataseg;
#if defined(MSC)
	_asm {
		mov	ax,ds;
		mov	dataseg,ax;
		}
#else
	dataseg=GetDataSeg();
#endif
	for(i=0;i<countof(strTable);i++){
		*(((int *)(strTable[i]))+1)=dataseg;
	}
}

/***************************************************************************/
typedef struct{
	char	*title;
	char	*launchTo;
}LaunchData;
typedef struct{
	char	*key;
	char	*macro;
}MacroData;
typedef enum{
	LAUNCH_NONE,LAUNCH_DOS,LAUNCH_KEY,
	LAUNCH_PIM
}LaunchFlag;

int			launchDataCount;
int			macroDataCount;
LaunchData	*launchData=NULL;
MacroData	*macroData=NULL;
char		*strData=NULL;
char		**listData=NULL;
char		launchTo[CMDLEN];
char		macroBuf[CMDLEN+3];
LaunchFlag	launchFlag;

/***************************************************************************/
int far 		AboutDlgHandler(PLHWINDOW pWnd,WORD message,WORD data,WORD extra,...);
int far 		PushBtnHandler(PLHWINDOW pWnd,WORD message,WORD data,WORD extra,...);
int far 		ListBoxHandler(PLHWINDOW pWnd,WORD message,WORD data,WORD extra,...);
int far 		MainDlgHandler(PLHWINDOW pWnd,WORD message,WORD data,WORD extra,...);
int				LoadLaunchData(void);
LaunchFlag		ExtractMacro(void);
void			DoLaunchKey(void);
void			DoLaunchDOS(void);
void			DoLaunchPIM(int type);
void			PushKeys(int far *pKeyCode,int len);
unsigned int	GetMyHotKey(void);
unsigned int	GetTaskId(unsigned int hotKey);
int				strncmpnocase(char *p0,char *p1,int len);
void			CopyToCB(char *p);

/***************************************************************************/
LHWINDOW	aboutDItem[]={
				{
					MessageBox,150,70,340,55,
					NULL,(PLHDATA)&strAboutPtr,1,
					MSG_CENTER_LINES|STYLE_NOFOCUS|STYLE_NOBORDER|STYLE_NOSHADOW,
					NULL,PARENT_FKEYS,NO_MENU,NO_HELP
				},
			};

LHWINDOW	aboutDlg={
				(PLHCLASS)AboutDlgHandler,140,55,360,85,
				NULL,(PLHDATA)aboutDItem,countof(aboutDItem),0,
				NULL,NO_FKEYS,NO_MENU,NO_HELP
			};

int
far
AboutDlgHandler(PLHWINDOW pWnd,WORD message,WORD data,WORD extra,...)
{
	if(message==KEYSTROKE){
		return(SendMsg(&aboutDlg,COMMAND,CMD_ESC,0));
	}
	return(SubclassMsg(DialogBox,pWnd,message,data,extra));
}

/***************************************************************************/
LHFKEY		mainFkeys[]={
				{(PLHRES)&strHelpBtn,(PLHFUNC)&aboutDlg,1,FKEY_CREATEWND},
				{(PLHRES)&strQuitBtn,(PLHFUNC)CMD_ESC,9,FKEY_SENDMSG},
				{(PLHRES)&strLaunchBtn,(PLHFUNC)CMD_DONE,10+FKEY_LAST,FKEY_SENDMSG},
			};

enum{
	MAINDLIST=0,
	MAINDLAUNCHBTN,
	MAINDCANCELBTN,
};
LHWINDOW	mainDItem[]={
				{
					(PLHCLASS)ListBoxHandler,120,19,LISTCOLUMNS,LISTLINES,
					NULL,(PLHDATA)0,0,STYLE_WHCHAR,
					NULL,PARENT_FKEYS,NO_MENU,NO_HELP
				},
				{
					(PLHCLASS)PushBtnHandler,434,124,80,20,
					(PLHRES)&strLaunchBtn,(PLHDATA)CMD_DONE,0,PUSHB_SENDMSG|STYLE_PUSHBUTTON,
					NULL,PARENT_FKEYS,NO_MENU,NO_HELP
				},
				{
					(PLHCLASS)PushBtnHandler,434,154,80,20,
					(PLHRES)&strQuitBtn,(PLHDATA)CMD_ESC,0,PUSHB_SENDMSG|STYLE_PUSHBUTTON,
					NULL,PARENT_FKEYS,NO_MENU,NO_HELP
				},
			};

LHWINDOW	mainDlg={
				(PLHCLASS)MainDlgHandler,110,1,420,188,
				(PLHRES)&strAppName,(PLHDATA)mainDItem,countof(mainDItem),0,
				NULL,mainFkeys,NO_MENU,NO_HELP
			};

/***************************************************************************/
int
far
PushBtnHandler(PLHWINDOW pWnd,WORD message,WORD data,WORD extra,...)
{
	switch(message){
		case DRAW:
			if(launchFlag) return(0);
			break;
	}
	return(SubclassMsg(PushButton,pWnd,message,data,extra));
}

/***************************************************************************/
int
far
ListBoxHandler(PLHWINDOW pWnd,WORD message,WORD data,WORD extra,...)
{
	int			i;
	int			res;
	int			btnStatus;
	static int	lastBtnStatus=-1;
	
	switch(message){
		case KEYSTROKE:
			switch(data){
				case 0x0d:
					return(SendMsg(&mainDlg,COMMAND,CMD_DONE,0));
				case LEFTKEY:
					i=mainDItem[MAINDLIST].Selection;
					for(i--;i>=0;i--){
						if(launchData[i].launchTo[0]!=0){
							for(;i>=0;i--){
								if(launchData[i].launchTo[0]==0){
									i++;
									goto scrollTo;
								}
							}
						}
					}
					i=0;
					goto scrollTo;
				case RIGHTKEY:
					i=mainDItem[MAINDLIST].Selection;
					for(;i<launchDataCount;i++){
						if(launchData[i].launchTo[0]==0){
							for(;i<launchDataCount;i++){
								if(launchData[i].launchTo[0]!=0){
									goto scrollTo;
								}
							}
						}
					}
					i=launchDataCount-1;
scrollTo:
					mainDItem[MAINDLIST].Selection=i;
					if(i+LISTLINES>launchDataCount){
						i=launchDataCount-LISTLINES;
						if(i<0) i=0;
					}
					mainDItem[MAINDLIST].WindowTop=i;
					return SendMsg(&mainDItem[MAINDLIST],DRAW,DRAW_CLIENT,0);
			}
			break;
		case DRAW:
			if(launchFlag) return(0);
			break;
	}
	res=SubclassMsg(ListBox,pWnd,message,data,extra);
	btnStatus=(launchData[mainDItem[MAINDLIST].Selection].launchTo[0]!=0);
	if(lastBtnStatus!=btnStatus){
		lastBtnStatus=btnStatus;
		if(btnStatus){
			mainDItem[MAINDLAUNCHBTN].Style&=~(STYLE_GRAY|STYLE_NOFOCUS);
		}
		else{
			mainDItem[MAINDLAUNCHBTN].Style|=(STYLE_GRAY|STYLE_NOFOCUS);
		}
		SendMsg(&mainDItem[MAINDLAUNCHBTN],DRAW,DRAW_ALL,0);
	}
	return(res);
}

/***************************************************************************/
int
far
MainDlgHandler(PLHWINDOW pWnd,WORD message,WORD data,WORD extra,...)
{
	int			i;
	LaunchFlag	flag;
	
	switch(message){
		case CREATE:
			LoadLaunchData();
			if(launchDataCount){
				listData=m_alloc(sizeof(char near*)*launchDataCount);
				for(i=0;i<launchDataCount;i++){
					listData[i]=launchData[i].title;
				}
				mainDItem[MAINDLIST].Data=(PLHDATA)listData;
				mainDItem[MAINDLIST].LogicalSize=launchDataCount;
			}
			break;
		case DESTROY:
			done=TRUE;
			break;
		case COMMAND:
			switch(data){
				case CMD_DONE:
					if(mainDItem[MAINDLIST].Selection<0) return(0);
					if(mainDItem[MAINDLIST].Selection>=launchDataCount) return(0);
					if(launchData[mainDItem[MAINDLIST].Selection].launchTo[0]==0) return(0);
					strncpy(launchTo,launchData[mainDItem[MAINDLIST].Selection].launchTo,countof(launchTo));
					flag=ExtractMacro();
					if(flag==LAUNCH_NONE) return(0);
					SendMsg(&mainDItem[MAINDLAUNCHBTN],SETFOCUS,SETFOCUS_NORMAL,0);
					launchFlag=flag;
					if(launchFlag==LAUNCH_KEY){
						DoLaunchKey();
						return(0);
					}
					else if(launchFlag>=LAUNCH_PIM){
						DoLaunchPIM(launchFlag-LAUNCH_PIM);
					}
					else if(launchFlag==LAUNCH_DOS){
						DoLaunchDOS();
					}
					done=TRUE;
					return(0);
			}
			break;
		case DRAW:
			if(launchFlag) return(0);
			break;
	}
	return(SubclassMsg(DialogBox,pWnd,message,data,extra));
}

/***************************************************************************/
void
main(void)
{
	m_init_app(SYSTEM_MANAGER_VERSION);
	InitializeLHAPI(&capData);
	m_reg_far(&sysMgrPtrs[0],countof(sysMgrPtrs),4);
	SetDefaultFont(FONT_NORMAL);
	SetMenuFont(FONT_NORMAL);
	m_reg_app_name(strAppName);
	listData=NULL;
	launchData=NULL;
	macroData=NULL;
	strData=NULL;
	launchFlag=LAUNCH_NONE;
	launchTo[0]=0;
	done=FALSE;
	SendMsg(&mainDlg,CREATE,CREATE_FOCUS,0);
	while(!done){
		app_event.norm.do_event=DO_EVENT;
		m_action(&app_event);
		switch(app_event.norm.kind){
			case E_ACTIV:
			case E_REFRESH:
				if(launchFlag==LAUNCH_KEY){
					done=TRUE;
					break;
				}
				FixupFarPtrs();
				ReactivateLHAPI(&capData);
				break;
			case E_DEACT:
				DeactivateLHAPI();
				break;
			case E_TERM:
			case E_BREAK:
				FixupFarPtrs();
				done=TRUE;
				break;
			case E_KEY:
				SendMsg(GetFocus(),KEYSTROKE,app_event.norm.data,app_event.norm.scan);
				break;
		}
	}
	if(listData) m_free(listData);
	if(launchData) m_free(launchData);
	if(macroData) m_free(macroData);
	if(strData) m_free(strData);
	m_fini();
}

/***************************************************************************/
int
LoadLaunchData(void)
{
	NBFILE			fp;
	unsigned char	buff[64],*ptr;
	unsigned char	c;
	int				len;
	char			*p;
	int				l,m,i;
	int				flag;
	
	listData=0;
	launchData=0;
	macroData=0;
	strData=0;
	launchDataCount=0;
	macroDataCount=0;
	cfgPath[0]='c';
	if(m_openro(&fp,cfgPath,strlen(cfgPath),0,1)!=0){
		cfgPath[0]='a';
		if(m_openro(&fp,cfgPath,strlen(cfgPath),0,1)!=0){
			return(-1);
		}
	}
	len=0;
	l=0;
	m=0;
	i=0;
	flag=0;
	while(1){
		if(len<=0){
			m_read(&fp,buff,sizeof(buff),&len);
			if(len<=0) break;
			ptr=buff;
		}
		c=*(ptr++);
		len--;
		if(flag==0){
			if(c==';'){
				flag=-1;
			}
			else if(c=='#'){
				flag=3;
			}
			else if(c>0x20){
				flag=1;
				goto setbuffer0;
			}
		}
		else{
setbuffer0:
			if(c==0x0d){
				if(flag==1 || flag==2){
					i++;
					l++;
				}
				if(flag==3 || flag==4){
					i++;
					m++;
				}
				flag=0;
			}
			else if(c==0x09){
				if(flag==1){
					flag=2;
					i++;
				}
				else if(flag==3){
					flag=4;
					i+=2;
				}
			}
			else if(c>=0x20){
				if(flag>0){
					i++;
				}
			}
		}
	}
	m_close(&fp);
	if(launchDataCount=l){
		launchData=(LaunchData*)m_alloc(sizeof(LaunchData)*launchDataCount);
		if(launchData==0) return(-1);
	}
	if(macroDataCount=m){
		macroData=(MacroData*)m_alloc(sizeof(MacroData)*macroDataCount);
		if(macroData==0) return(-1);
	}
	if(i){
		strData=(char*)m_alloc(i);
		if(strData==0) return(-1);
	}
	if(m_openro(&fp,cfgPath,strlen(cfgPath),0,1)!=0) return(-1);
	len=0;
	l=0;
	m=0;
	p=strData;
	flag=0;
	while(1){
		if(len<=0){
			m_read(&fp,buff,sizeof(buff),&len);
			if(len<=0) break;
			ptr=buff;
		}
		c=*(ptr++);
		len--;
		if(flag==0){
			if(c==';'){
				flag=-1;
			}
			else if(c=='#'){
				if(m>=macroDataCount) flag=-1;
				else{
					flag=3;
					macroData[m].key=p;
				}
			}
			else if(c>0x20){
				if(l>=launchDataCount) flag=-1;
				else{
					flag=1;
					launchData[l].title=p;
					goto setbuffer1;
				}
			}
		}
		else{
setbuffer1:
			if(c==0x0d){
				if(flag==1 || flag==2){
					if(flag==1) launchData[l].launchTo=p;
					*(p++)=0;
					l++;
				}
				if(flag==3 || flag==4){
					if(flag==3) macroData[m].macro=p;
					*(p++)=0;
					m++;
				}
				flag=0;
			}
			else if(c==0x09){
				if(flag==1){
					flag=2;
					*(p++)=0;
					launchData[l].launchTo=p;
				}
				else if(flag==3){
					flag=4;
					*(p++)=',';
					*(p++)=0;
					macroData[m].macro=p;
				}
			}
			else if(c>=0x20){
				if(flag>0){
					*(p++)=c;
				}
			}
		}
	}
	m_close(&fp);
	return(0);
}

/***************************************************************************/
LaunchFlag
ExtractMacro(void)
{
	int		i,len;
	char	*p0,*p1;
	
extractMacroEntry:
	if(strncmpnocase(launchTo,keysign,strlen(keysign))==0) return(LAUNCH_KEY);
	for(i=0;i<countof(pimInfo);i++){
		if(strncmpnocase(launchTo,pimInfo[i].sign,strlen(pimInfo[i].sign))==0){
			return((LaunchFlag)(LAUNCH_PIM+i));
		}
	}
	if(macroData && macroDataCount){
		for(i=0;i<macroDataCount;i++){
			if(strncmpnocase(launchTo,macroData[i].key,strlen(macroData[i].key))==0){
				len=0;
				p0=macroData[i].macro;
				if(launchTo[0]=='%'){
					CopyToCB(launchTo+strlen(macroData[i].key));
				}
				while(*p0){
					if(*p0=='%'){
						p1=launchTo+strlen(macroData[i].key);
						while(*p1){
							if(len>=countof(macroBuf)-1) return(LAUNCH_NONE);
							macroBuf[len++]=*p1;
							p1++;
						}
					}
					else{
						if(len>=countof(macroBuf)-1) return(LAUNCH_NONE);
						macroBuf[len++]=*p0;
					}
					p0++;
				}
				macroBuf[len++]=0;
				strcpy(launchTo,macroBuf);
				goto extractMacroEntry;
			}
		}
	}
	return(LAUNCH_DOS);
}

/***************************************************************************/
void
DoLaunchDOS(void)
{
	int		mem;
	char	*p;
	
	mem=0;
	p=launchTo;
	while(*p){
		if((*p)>='0' && (*p)<='9'){
			mem=mem*10+(*p)-'0';
		}
		else break;
		p++;
	}
	if((*p)==',' && p!=launchTo){
		p++;
	}
	else{
		p=launchTo;
		mem=0xffff;
	}
	if(*p){
		strcpy(macroBuf,"/C ");
		strcat(macroBuf,p);
		st_exec.ex_file_spec="d:\\dos\\command.com";
		st_exec.ex_command_line=macroBuf;
		st_exec.ex_DOSsizek=mem;
		st_exec.ex_pause=0;
		st_exec.ex_lock=0;
		app_event.execf.exec_struc_ptr=&st_exec;
		app_event.norm.do_event=DO_EXEC_FULL;
		DeactivateLHAPI();
		m_action(&app_event);
		FixupFarPtrs();
		ReactivateLHAPI(&capData);
	}
}

/***************************************************************************/
typedef struct{
			char	*pStr;
			int		scanCode[5];/*norm,shift,ctrl,alt,fn*/
		}ScanCode;
char	*modifiers[]={
			"Shift+",
			"Ctrl+",
			"Alt+",
			"Fn+"
		};
ScanCode	nameToScan[]={
				{"F1",		{0x3b00,0x5400,0x5e00,0x6800,0xdb00}},
				{"F2",		{0x3c00,0x5500,0x5f00,0x6900,0xdc00}},
				{"F3",		{0x3d00,0x5600,0x6000,0x6a00,0xdd00}},
				{"F4",		{0x3e00,0x5700,0x6100,0x6b00,0xde00}},
				{"F5",		{0x3f00,0x5800,0x6200,0x6c00,0xdf00}},
				{"F6",		{0x4000,0x5900,0x6300,0x6d00,0xe000}},
				{"F7",		{0x4100,0x5a00,0x6400,0x6e00,0xe100}},
				{"F8",		{0x4200,0x5b00,0x6500,0x6f00,0xe200}},
				{"F9",		{0x4300,0x5c00,0x6600,0x7000,0xe300}},
				{"F10",		{0x4400,0x5d00,0x6700,0x7100,0xe400}},
				
				{"Q",		{0x1071,0x1051,0x1011,0x1000,0x10a6}},
				{"W",		{0x1177,0x1157,0x1117,0x1100,0x11a7}},
				{"E",		{0x1265,0x1245,0x1205,0x1200,0x128a}},
				{"R",		{0x1372,0x1352,0x1312,0x1300,0x0000}},
				{"T",		{0x1474,0x1454,0x1414,0x1400,0x0000}},
				{"Y",		{0x1579,0x1559,0x1519,0x1500,0x0000}},
				{"U",		{0x1675,0x1655,0x1615,0x1600,0x0000}},
				{"I",		{0x1769,0x1749,0x1709,0x1700,0x0000}},
				{"O",		{0x186f,0x184f,0x180f,0x1800,0x189b}},
				{"P",		{0x1970,0x1950,0x1910,0x1900,0x19e7}},
				{"A",		{0x1e61,0x1e41,0x1e01,0x1e00,0x1e85}},
				{"S",		{0x1f73,0x1f53,0x1f13,0x1f00,0x1fe1}},
				{"D",		{0x2064,0x2044,0x2004,0x2000,0x20d0}},
				{"F",		{0x2166,0x2146,0x2106,0x2100,0x219f}},
				{"G",		{0x2267,0x2247,0x2207,0x2200,0x22cf}},
				{"H",		{0x2368,0x2348,0x2308,0x2300,0x23be}},
				{"J",		{0x246a,0x244a,0x240a,0x2400,0x2497}},
				{"K",		{0x256b,0x254b,0x250b,0x2500,0x2591}},
				{"L",		{0x266c,0x264c,0x260c,0x2600,0x266c}},
				{"Z",		{0x2c7a,0x2c5a,0x2c1a,0x2c00,0x2cf4}},
				{"X",		{0x2d78,0x2d58,0x2d18,0x2d00,0x2df8}},
				{"C",		{0x2e63,0x2e43,0x2e03,0x2e00,0x2e87}},
				{"V",		{0x2f76,0x2f56,0x2f16,0x2f00,0x2ff5}},
				{"B",		{0x3062,0x3042,0x3002,0x3000,0x30fe}},
				{"N",		{0x316e,0x314e,0x310e,0x3100,0x31a4}},
				{"M",		{0x326d,0x324d,0x320d,0x3200,0x32e6}},
				
				{"0",		{0x0b30,0x0000,0x0000,0x8100,0xd400}},
				{"1",		{0x0231,0x333c,0x0000,0x7800,0x0000}},
				{"2",		{0x0332,0x343e,0x0300,0x7900,0x0000}},
				{"3",		{0x0433,0x353f,0x0000,0x7a00,0x04a8}},
				{"4",		{0x0534,0x273b,0x0000,0x7b00,0x0594}},
				{"5",		{0x0635,0x273a,0x0000,0x7c00,0x0684}},
				{"6",		{0x0736,0x2827,0x071e,0x7d00,0x07ac}},
				{"7",		{0x0837,0x1a5b,0x0000,0x7e00,0x0886}},
				{"8",		{0x0938,0x1b5d,0x0000,0x7f00,0x09ab}},
				{"9",		{0x0a39,0x1a7b,0x0000,0x8000,0x0af3}},
				
				{".",		{0x342e,0x2960,0x0000,0x3400,0xd400}},
				{"=",		{0x0d3d,0x297e,0x0000,0x8300,0xd500}},
				{"+",		{0x0d2b,0x0625,0x0000,0x8300,0xd600}},
				{"-",		{0x0c2d,0x0c5f,0x0c1f,0x8200,0x0cf1}},
				{"*",		{0x092a,0x2822,0x0000,0x7f00,0x099e}},
				{"`",		{0x352f,0x1b7d,0x0000,0x3500,0x35f6}},
				
				{"Esc",		{0x011b,0x011b,0x011b,0x0100,0x011b}},
				{"\\",		{0x2b5c,0x2b7c,0x2b1c,0x0000,0x2b5c}},
				{"Tab",		{0x0f09,0x0f00,0x0000,0x0000,0x0f09}},
				{"Enter",	{0x1c0d,0x1c0d,0x1c0a,0x1c00,0x1c0d}},
				{"Space",	{0x3920,0x3920,0x3920,0x3920,0xd000}},
				{",",		{0x332c,0x332c,0x0000,0x0000,0xd100}},
				{".",		{0x342e,0x342e,0x0000,0x0000,0xd200}},
				{"Menu",	{0xc800,0xc900,0x0000,0xcb00,0x0000}},
				
				{"Up",		{0x4800,0x4838,0x0000,0x0008,0x4900}},
				{"Down",	{0x5000,0x5032,0x0000,0x0002,0x5100}},
				{"Left",	{0x4b00,0x4b34,0x7300,0x0004,0x4700}},
				{"Right",	{0x4d00,0x4d36,0x7400,0x0006,0x4f00}},
				{"Del",		{0x5300,0x532e,0x0000,0x0000,0x5200}},
				{"BackSp",	{0x0e08,0x0e08,0x0e7f,0x0e00,0x7e10}},
				
				{"PageUp",	{0x4900,0x4939,0x8400,0x7e86,0x0000}},
				{"PageDown",{0x5100,0x5133,0x7600,0x7e85,0x0000}},
				{"Home",	{0x4700,0x4737,0x7700,0x7e84,0x0000}},
				{"End",		{0x4f00,0x4f31,0x7500,0x7e87,0x0000}},
				{"Ins",		{0x5200,0x5230,0x9200,0x0000,0x0000}},
				
				{"Filer",	{0xa800,0x0221,0xae00,0xab00,0x03ad}},
				{"Appt",	{0xb000,0x0340,0xb600,0xb300,0x05f9}},
				{"Phone",	{0xb400,0x0423,0xba00,0xb700,0x069c}},
				{"Memo",	{0xb800,0x0524,0xbe00,0xbb00,0x07bd}},
				{"Quicken",	{0xac00,0x075e,0xb200,0xaf00,0x04b8}},
				{"123",		{0xbc00,0x0826,0xc200,0xbf00,0x08a9}},
				{"Calc",	{0xc000,0x0a28,0xc600,0xc300,0x09ae}},
				{"More",	{0xa400,0x0b29,0xaa00,0xa700,0x02af}},
				
				{"Setup",		{0xae00}},
				{"Stopwatch",	{0xb600}},
				{"Database",	{0xba00}},
				{"NoteTaker",	{0xbe00}},
				{"Comm",		{0xb200}},
				{"DOS",			{0xc200}},
				{"WorldTime",	{0xc600}},
				{"Macros",		{0xaa00}},
				{"LapLink RA",	{0xab00}},
				{"cc:Mail",		{0xbf00}},
				{"Zoom",		{0xd000}},
				{"Date",		{0xd100}},
				{"Time",		{0xd200}},
				{"PrtSc",		{0xfe83}},
				{"Cut",			{0xd400}},
				{"Copy",		{0xd500}},
				{"Paste",		{0xd600}},
				{"PrtSc",		{0xfe83}},
				{"Scrl",		{0x7e10}},
			};
int	asciiToScan[]={
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x3920,0x0221,0x2822,0x0423,0x0524,0x0625,0x0826,0x2827,
		0x0a28,0x0b29,0x372a,0x4e2b,0x332c,0x0c2d,0x342e,0x352f,
		0x0b30,0x0231,0x0332,0x0433,0x0534,0x0635,0x0736,0x0837,
		0x0938,0x0a39,0x273a,0x273b,0x333c,0x0d3d,0x343e,0x353f,
		
		0x0340,0x1e41,0x3042,0x2e43,0x2044,0x1245,0x2146,0x2247,
		0x2348,0x1749,0x244a,0x254b,0x264c,0x324d,0x314e,0x184f,
		0x1950,0x1051,0x1352,0x1f53,0x1454,0x1655,0x2f56,0x1157,
		0x2d58,0x1559,0x2c5a,0x1a5b,0x2b5c,0x1b5d,0x075e,0x0c5f,
		
		0x2960,0x1e61,0x3062,0x2e63,0x2064,0x1265,0x2166,0x2267,
		0x2368,0x1769,0x246a,0x256b,0x266c,0x326d,0x316e,0x186f,
		0x1970,0x1071,0x1372,0x1f73,0x1474,0x1675,0x2f76,0x1177,
		0x2d78,0x1579,0x2c7a,0x1a7b,0x2b7c,0x1b7d,0x297e,0x007f,
	};
#define	tohex(x)	(long)((((x)>='0'&&(x)<='9')?(x)-'0'+0x00:\
					       (((x)>='a'&&(x)<='f')?(x)-'a'+0x0a:\
					        ((x)>='A'&&(x)<='F')?(x)-'A'+0x0a:-1)))

void
DoLaunchKey(void)
{
	int				keySeq[CMDLEN];
	int				i,len,keyLen,modify;
	ScanCode		*pTbl;
	unsigned char	*p;
	long			key;
	
	len=0;
	p=launchTo+strlen(keysign);
	while(*p){
		if(*p=='{'){
			p++;
			key= (tohex(p[0])<<12);
			key|=(tohex(p[1])<<8);
			key|=(tohex(p[2])<<4);
			key|=(tohex(p[3]));
			if(key>=0 && p[4]=='}'){
				p+=5;
				keySeq[len++]=key;
				continue;
			}
			modify=0;
			for(i=0;i<countof(modifiers);i++){
				if(strncmpnocase(p,modifiers[i],strlen(modifiers[i]))==0){
					p+=strlen(modifiers[i]);
					modify=i+1;
					break;
				}
			}
			pTbl=nameToScan;
			for(i=0;i<countof(nameToScan);i++,pTbl++){
				keyLen=strlen(pTbl->pStr);
				if(strncmpnocase(p,pTbl->pStr,keyLen)==0 && p[keyLen]=='}'){
					p+=keyLen+1;
					if(pTbl->scanCode[modify]){
						keySeq[len++]=pTbl->scanCode[modify];
					}
					break;
				}
			}
		}
		else{
			keySeq[len++]=((*p)&0x80)?(*p):asciiToScan[*p];
			p++;
		}
	}
	keySeq[len++]=GetMyHotKey();
	PushKeys((int far*)keySeq,len);
}


/***************************************************************************/
void
DoLaunchPIM(int type)
{
	unsigned int	taskId;
	unsigned char	*p;
	NBFILE			fp;
	unsigned int	myHotKey;
	
	taskId=GetTaskId(pimInfo[type].hotKey);
	app_event.norm.do_event=DO_CLOSE_APP;
	app_event.l.e_launch_task=taskId;
	m_action(&app_event);
	FixupFarPtrs();
	
	p=launchTo+strlen(pimInfo[type].sign);
	if(strlen(p)){
		if(m_open(&fp,pimInfo[type].envPath,strlen(pimInfo[type].envPath),0,1)==0){
			m_seek(&fp,0,pimInfo[type].offset);
			m_write(&fp,p,strlen(p)+1);
			m_close(&fp);
		}
	}
	
	myHotKey=GetMyHotKey();
	PushKeys((int far*)&myHotKey,1);
	
	app_event.norm.do_event=DO_LAUNCH;
	app_event.l.e_launch_task=taskId;
	app_event.l.e_launch_type=1;
	DeactivateLHAPI();
	m_action(&app_event);
	FixupFarPtrs();
	ReactivateLHAPI(&capData);
}

/***************************************************************************/
void
PushKeys(int far *pKeyCode,int len)
{
	union REGS	reg;
	
	reg.x.dx=((long)pKeyCode)>>16;
	reg.x.bx=((long)pKeyCode)&0xffff;
	reg.x.cx=len;
	reg.x.ax=0xffff;
	int86(0x16,&reg,&reg);
}

/***************************************************************************/
typedef struct task{
	unsigned int	t_sp;
	unsigned int	t_ss;
	unsigned int	t_off_image;
	unsigned int	t_seg_image;
	unsigned int	t_ds;
	unsigned int	t_memseg;
	unsigned int	t_hotkey;
	int				dummy[7];
	char			state;
	char			dummy2[1];
	int				dummy3[2];
	char			t_extname[12];
	int				dummy4[2];
	unsigned int	t_far_size;
	unsigned int	t_far_off;
	unsigned int	t_far_rsvrd;
	int				dummy5[3];
}TCB;

unsigned int
GetMyHotKey(void)
{
	TCB far	*tcb;
	
	tcb=(TCB far*)m_get_TCB();
	return(tcb[m_current_task()].t_hotkey);
}

unsigned int
GetTaskId(unsigned int hotKey)
{
	TCB	far			*tcb;
	unsigned int	tNum;
	unsigned int	i;
	
	tcb=(TCB far*)m_get_TCB();
	tNum=(unsigned int)m_get_TCB_size();
	for(i=0;i<tNum;i++){
		if(tcb[i].t_hotkey==hotKey) return(i);
	}
	return(0);
}

/***************************************************************************/
int
strncmpnocase(char *p0,char *p1,int len)
{
	int	i;
	
	for(i=0;i<len;i++,p0++,p1++){
		if(toupper(*p0)<toupper(*p1)) return(-1);
		if(toupper(*p0)>toupper(*p1)) return(1);
		if(*p0==0) break;
	}
	return(0);
}

/***************************************************************************/
void
CopyToCB(char *p)
{
	m_lock();
	if(m_open_cb()==0){
		m_reset_cb("MemUtil");
		m_new_rep("TEXT");
		m_cb_write(p,strlen(p));
		m_fini_rep();
		m_close_cb();
	}
	m_unlock();
}

