\ Library for generating pseudo-random numbers.
\ This file should be included before the application.
\ *
\ Pavel Zampach (zampach@volny.cz), 2002

VARIABLE rseed

HEX
: RANDOMIZE
\ ( -- )
\ initialize the seed for random numbers
  0 046C @L rseed !
;

DECIMAL
1 1 IN/OUT
: RND
\ ( n -- rnd )
\ par n border of range
\ par rnd pseudo-random number
\ returns pseudo-random number from range (0, n-1)
  rseed @ 0       \ rseed                        |DP
  1 0 D+          \ rseed+1                      |DP
  75 1 M*/        \ 75*(rseed+1)                 |DP
  2DUP U< IF
    0 ROT 1+ 1
  ELSE
    0 ROT 0
  THEN
  2SWAP D-        \ (75*(rseed+1)) MOD 65537     |DP
  1 0 D- DROP     \ ((75*(rseed+1)) MOD 65537)-1 |SP
  DUP rseed !
  0 ROT UM/MOD DROP
;
