1 REM
2 REM  This program was originally developed on an IBM 3090 Mainframe
3 REM  using PL/I.  Since most owners of the HP200LX do not have a
4 REM  3090 in their den, and ILGRadio data is copyrighted material,
5 REM  I ported the functions to the PC so virtually anyone could
6 REM  download the data from ILGRadio, and then use this program to
7 REM  prepare the ILGRadio Language files for use on their HP200LX.
8 REM
9 REM  This BASIC code is nowhere near as elegant as the original
10 REM PL/I source, but it gets the job done.
11 REM
12 REM      Gary Jacek  VE7GGJ  November 25, 2003
13 REM
14 REM Program updated for Jan 2004 changes to ILG data structures
15 REM      Gary Jacek  VE7GGJ  February 6, 2004
16 REM
20 CLEAR
21 CLS
24 DIM frequency$(200)
25 DIM preset$(200)
26 DIM page$(200)
27 pindex = 0
28 PMAX = 200
30 PRINT "SWLX - Prepare ILGRadio Language Files for GDBLOAD into .GDB Database"
40 PRINT "V1.4 Revision Date 06Feb2004"
41 PRINT " "
42 PRINT "Obtain ILGRadio Data from www.ilgradio.com"
43 PRINT ""
50 PRINT "SWLX is free for non-commercial use"
60 PRINT ""
70 PRINT ""
80 PRINT " ": INPUT "Input File? (default ilgsteng.txt in current directory) ", F$
90 IF F$ = "" THEN F$ = "ilgsteng.txt"
100 OPEN F$ FOR INPUT AS #1
110 OPEN "SWLXTMP.OUT" FOR OUTPUT AS #2
111 OPEN "PRESETS.TXT" FOR INPUT AS #3
112 INPUT #3, p$
113 IF EOF(3) THEN GOTO 122
114 IF MID$(p$, 1, 1) = ";" THEN p$ = "": GOTO 112
115 IF LEN(p$) < 11 THEN p$ = " " + p$: GOTO 115
116 pindex = pindex + 1
117 IF pindex > PMAX THEN PRINT "*** More than 200 presets - Aborting ***": STOP
118 frequency$(pindex) = MID$(p$, 1, 7)
119 preset$(pindex) = MID$(p$, 9, 1)
120 page$(pindex) = MID$(p$, 11, 1)
121 p$ = "": GOTO 112
122 PMAX = pindex
123 REM write headers
130 Q$ = CHR$(34)
140 s$ = CHR$(92)
150 m$ = CHR$(44)
160 GOSUB 6000
200 REM process records
210 z$ = "": a$ = "": B$ = "": c$ = "": d$ = "": E$ = "": F$ = "": G$ = "": h$ = "": i$ = "": j$ = ""
250 Q$ = CHR$(34)
260 s$ = CHR$(92)
270 m$ = CHR$(44)
280 IF EOF(1) THEN GOTO 990
300 INPUT #1, z$
400 REM detect and adjust for short records due to frequency
410 IF MID$(z$, 1, 1) = "." THEN z$ = "     " + z$
420 IF MID$(z$, 2, 1) = "." THEN z$ = "    " + z$
430 IF MID$(z$, 3, 1) = "." THEN z$ = "   " + z$
440 IF MID$(z$, 4, 1) = "." THEN z$ = "  " + z$
450 IF MID$(z$, 5, 1) = "." THEN z$ = " " + z$
460 REM detect short records due to embedded commas
480 l = LEN(z$): IF l < 280 THEN INPUT #1, y$: z$ = z$ + " " + y$: GOTO 480
500 REM change embedded double quotes to single quotes
510 l = LEN(z$)
520 FOR i = 1 TO l
530 IF MID$(z$, i, 1) = Q$ THEN z$ = MID$(z$, 1, i - 1) + "'" + MID$(z$, i + 1, l - i - 1)
540 NEXT i
550 REM change embedded \ to hyphen
560 l = LEN(z$)
570 FOR i = 1 TO l
580 IF MID$(z$, i, 1) = s$ THEN z$ = MID$(z$, 1, i - 1) + "-" + MID$(z$, i + 1, l - i - 1)
590 NEXT i
600 REM go parse the input record and build output record
700 GOSUB 2000
800 GOTO 210
990 CLOSE #1
1000 CLOSE #2
1100 END
2000 REM parse the input record into fields and build output record
2100 a$ = MID$(z$, 1, 7):REM FREQ 
2200 B$ = MID$(z$, 8, 22):REM STATION
2300 c$ = MID$(z$, 30, 9):REM UTC 
2400 d$ = MID$(z$, 39, 7):REM DAYS
2500 E$ = MID$(z$, 46, 17):REM LANGUAGE
2501 REM Column 63 is an unused byte between LANGUAGE and GRAPHIC 
2510 o$ = Q$ + a$ + Q$ + m$ + Q$ + B$ + Q$ + m$ + Q$ + c$ + Q$ + m$ + Q$ + d$ + Q$: o$ = o$ + m$ + Q$ + MID$(E$, 1, 12) + s$
2520 PRINT #2, o$
2550 a$ = E$
2600 B$ = MID$(z$, 64, 48):REM GRAPHIC
2700 c$ = MID$(z$, 112, 8):REM TARGET
2800 d$ = MID$(z$, 120, 25):REM LOCATION
2810 o$ = MID$(a$, 13, 5) + Q$ + m$ + Q$ + B$ + Q$ + m$ + Q$ + c$ + Q$ + m$ + Q$: o$ = o$ + MID$(d$, 1, 1) + s$
2820 PRINT #2, o$
2840 a$ = d$
2900 B$ = MID$(z$, 145, 7):REM POWER
3000 c$ = MID$(z$, 152, 3):REM AZI
3100 d$ = MID$(z$, 155, 15):REM REMARKS
3200 E$ = MID$(z$, 297, 1):REM STATUS
3300 F$ = MID$(z$,170,1):REM MOD
3400 G$ = MID$(z$, 171, 2):REM NA
3500 h$ = MID$(z$, 173, 2):REM CA
3510 o$ = MID$(a$, 2, 19) + Q$ + m$ + Q$ + B$ + Q$ + m$ + Q$ + c$ + Q$ + m$ + Q$ + d$ + Q$: o$ = o$ + m$ + Q$: o$ = o$ + E$ + Q$ + m$ + Q$ + F$ + Q$ + m$ + Q$ + G$ + Q$ + m$ + Q$ + h$ + s$
3520 PRINT #2, o$
3600 a$ = MID$(z$, 175, 2):REM SA
3610 B$ = MID$(z$, 177, 2):REM EU
3620 c$ = MID$(z$, 179, 2):REM AF
3630 d$ = MID$(z$, 181, 2):REM ME
3640 E$ = MID$(z$, 183, 2):REM AS
3650 F$ = MID$(z$, 185, 2):REM AU
3660 G$ = MID$(z$, 187, 2):REM PA
3670 h$ = MID$(z$, 189, 30):REM CIRAFZONES
3690 o$ = Q$ + m$ + Q$ + a$ + Q$ + m$ + Q$ + B$ + Q$ + m$ + Q$ + c$ + Q$ + m$ + Q$
3700 o$ = o$ + d$ + Q$ + m$ + Q$ + E$ + Q$ + m$ + Q$: o$ = o$ + F$ + Q$ + m$ + Q$ + G$ + Q$ + m$ + Q$
3710 o$ = o$ + h$ + Q$ + m$ + Q$ + s$
3720 PRINT #2, o$
3800 a$ = MID$(z$, 224, 3):REM ADM
3810 B$ = MID$(z$, 227, 18):REM COUNTRY
3820 c$ = MID$(z$, 245, 6):REM LONGI
3830 d$ = MID$(z$, 251, 5):REM LATI
3840 E$ = "":REM LC was 253,2 and no longer in data structure so it is dropped from V1.4
3850 F$ = MID$(z$, 256, 20):REM REGION
3890 o$ = a$ + Q$ + m$ + Q$ + B$ + Q$ + m$ + Q$ + c$ + Q$ + m$ + Q$
3900 o$ = o$ + d$ + Q$ + m$ + Q$: o$ = o$ + F$ + Q$ + m$ + s$:REM Note that E$ representing LC is removed from V1.4
3910 PRINT #2, o$
4000 a$ = MID$(z$, 219, 5):REM STN
4010 B$ = MID$(z$, 276, 1):REM P
4020 c$ = MID$(z$, 277, 20):REM PROGRAMME
4030 REM pad last field of input file
4040 j = 20 - LEN(c$)
4050 IF j = 0 THEN GOTO 5000
4060 FOR i = 1 TO j
4070 c$ = c$ + " "
4990 NEXT i
5000 o$ = Q$ + a$ + Q$ + m$ + Q$ + B$ + Q$ + m$ + Q$ + c$ + Q$
5010 REM add Preset and Page as Blanks OR Fill them in from PRESET.TXT table
5020 GOSUB 8000
5030 REM add Broadcasts by Hour (Isolate and use Graphic) and QSL
5040 G$ = MID$(z$, 64, 48):REM GRAPHIC
5050 REM change embedded Periods and Exclamation Marks to Spaces
5060 FOR i = 1 TO 48
5070 IF MID$(G$, i, 1) = "." THEN G$ = MID$(G$, 1, i - 1) + " " + MID$(G$, i + 1, l - i - 1)
5080 IF MID$(G$, i, 1) = "!" THEN G$ = MID$(G$, 1, i - 1) + " " + MID$(G$, i + 1, l - i - 1)
5090 NEXT i
5100 IF MID$(G$, 1, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5110 o$ = o$ + m$ + Q$ + a$ + Q$
5120 IF MID$(G$, 3, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5130 o$ = o$ + m$ + Q$ + a$ + Q$
5140 IF MID$(G$, 5, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5150 o$ = o$ + m$ + Q$ + a$ + Q$
5160 IF MID$(G$, 7, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5170 o$ = o$ + m$ + Q$ + a$ + Q$
5180 IF MID$(G$, 9, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5190 o$ = o$ + m$ + Q$ + a$ + Q$
5200 IF MID$(G$, 11, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5210 o$ = o$ + m$ + Q$ + a$ + Q$
5220 IF MID$(G$, 13, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5230 o$ = o$ + m$ + Q$ + a$ + s$
5240 PRINT #2, o$
5260 IF MID$(G$, 15, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5270 o$ = Q$ + m$ + Q$ + a$ + Q$
5280 IF MID$(G$, 17, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5290 o$ = o$ + m$ + Q$ + a$ + Q$
5300 IF MID$(G$, 19, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5310 o$ = o$ + m$ + Q$ + a$ + Q$
5320 IF MID$(G$, 21, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5330 o$ = o$ + m$ + Q$ + a$ + Q$
5340 IF MID$(G$, 23, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5350 o$ = o$ + m$ + Q$ + a$ + Q$
5360 IF MID$(G$, 25, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5370 o$ = o$ + m$ + Q$ + a$ + Q$
5380 IF MID$(G$, 27, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5390 o$ = o$ + m$ + Q$ + a$ + Q$
5400 IF MID$(G$, 29, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5410 o$ = o$ + m$ + Q$ + a$ + Q$
5420 IF MID$(G$, 31, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5430 o$ = o$ + m$ + Q$ + a$ + Q$
5440 IF MID$(G$, 33, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5450 o$ = o$ + m$ + Q$ + a$ + Q$
5460 IF MID$(G$, 35, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5470 o$ = o$ + m$ + Q$ + a$ + Q$
5480 IF MID$(G$, 37, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5490 o$ = o$ + m$ + Q$ + a$ + Q$
5500 IF MID$(G$, 39, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5510 o$ = o$ + m$ + Q$ + a$ + Q$
5520 IF MID$(G$, 41, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5530 o$ = o$ + m$ + Q$ + a$ + Q$
5540 IF MID$(G$, 43, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5550 o$ = o$ + m$ + Q$ + a$ + Q$
5560 IF MID$(G$, 45, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5570 o$ = o$ + m$ + Q$ + a$ + Q$
5580 IF MID$(G$, 47, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5590 o$ = o$ + m$ + Q$ + a$ + Q$ + m$ + Q$ + s$
5600 PRINT #2, o$
5610 IF MID$(G$, 1, 2) = "  " THEN a$ = "0" ELSE a$ = "1"
5630 REM Determine Meter Band using Frequency
5640 B$ = MID$(z$, 1, 7):REM FREQ was 1,8
5650 c$ = ""
5699 IF B$ >= " 1800.0" AND B$ <= " 2000.0" THEN c$ = "160"
5700 IF B$ >= " 2300.0" AND B$ <= " 2495.0" THEN c$ = "120"
5710 IF B$ >= " 3200.0" AND B$ <= " 3400.0" THEN c$ = "90"
5715 IF B$ >= " 3500.0" AND B$ <= " 4000.0" THEN c$ = "80"
5720 IF B$ >= " 3900.0" AND B$ <= " 4000.0" THEN c$ = "75"
5730 IF B$ >= " 4750.0" AND B$ <= " 5060.0" THEN c$ = "60"
5740 IF B$ >= " 5950.0" AND B$ <= " 6200.0" THEN c$ = "49"
5750 IF B$ >= " 7100.0" AND B$ <= " 7300.0" THEN c$ = "41"
5755 IF B$ >= " 7000.0" AND B$ <= " 7300.0" THEN c$ = "40"
5760 IF B$ >= " 9500.0" AND B$ <= " 9900.0" THEN c$ = "31"
5770 IF B$ >= "10100.0" AND B$ <= "10150.0" THEN c$ = "30"
5775 IF B$ >= "11650.0" AND B$ <= "12050.0" THEN c$ = "25"
5780 IF B$ >= "13600.0" AND B$ <= "13800.0" THEN c$ = "21"
5785 IF B$ >= "14000.0" AND B$ <= "14235.0" THEN c$ = "20"
5790 IF B$ >= "15100.0" AND B$ <= "15600.0" THEN c$ = "19"
5795 IF B$ >= "18068.0" AND B$ <= "18168.0" THEN c$ = "17"
5800 IF B$ >= "17550.0" AND B$ <= "17900.0" THEN c$ = "16"
5805 IF B$ >= "21000.0" AND B$ <= "21450.0" THEN c$ = "15"
5810 IF B$ >= "21450.0" AND B$ <= "21850.0" THEN c$ = "13"
5815 IF B$ >= "24890.0" AND B$ <= "24990.0" THEN c$ = "12"
5820 IF B$ >= "25670.0" AND B$ <= "26100.0" THEN c$ = "11"
5825 IF B$ >= "28000.0" AND B$ <= "29700.0" THEN c$ = "10"
5830 REM
5960 REM Assemble the last output record for this input record
5970 o$ = a$ + Q$ + m$ + Q$ + c$ + Q$ + m$ + Q$ + "0" + Q$
5980 PRINT #2, o$
5990 RETURN
6000 o$ = Q$ + "FREQ" + Q$ + m$ + Q$ + "STATION" + Q$ + m$ + Q$
6010 o$ = o$ + "UTC" + Q$ + m$ + Q$ + "DAYS" + Q$ + m$ + Q$
6020 o$ = o$ + "LANGUAGE" + Q$ + m$ + Q$ + "GRAPHIC" + Q$ + m$ + Q$
6030 o$ = o$ + "TARGET" + Q$ + m$ + Q$ + "LOCATION" + Q$ + m$ + s$
6040 PRINT #2, o$
6100 o$ = Q$ + "POWER" + Q$ + m$ + Q$ + "AZI" + Q$ + m$ + Q$
6110 o$ = o$ + "REMARKS" + Q$ + m$ + Q$ + "STATUS" + Q$ + m$ + Q$
6120 o$ = o$ + "MOD" + Q$ + m$ + Q$ + "NA" + Q$ + m$ + Q$
6130 o$ = o$ + "CA" + Q$ + m$ + Q$ + "SA" + Q$ + m$ + Q$
6140 o$ = o$ + "EU" + Q$ + m$ + Q$ + "AF" + Q$ + m$ + Q$
6150 o$ = o$ + "ME" + Q$ + m$ + Q$ + "A" + s$
6160 PRINT #2, o$
6200 o$ = "S" + Q$ + m$ + Q$ + "AU" + Q$ + m$ + Q$
6210 o$ = o$ + "PA" + Q$ + m$ + Q$ + "CIRAF" + Q$ + m$ + Q$
6220 o$ = o$ + "ADM" + Q$ + m$ + Q$ + "COUNTRY" + Q$ + m$ + Q$
6230 o$ = o$ + "LONGI" + Q$ + m$ + Q$ + "LATI" + Q$ + m$ + Q$
6240 o$ = o$ + "REGION" + Q$ + m$ + Q$:REM Note LC no longer in data structure and removed from V1.4
6250 o$ = o$ + "STN" + Q$ + s$
6260 PRINT #2, o$
6300 o$ = m$ + Q$ + "P" + Q$ + m$ + Q$ + "PROGRAMME" + Q$ + m$ + Q$
6310 o$ = o$ + "PRESET" + Q$ + m$ + Q$ + "PAGE" + Q$
6320 o$ = o$ + m$ + Q$ + "HR 00" + Q$
6330 o$ = o$ + m$ + Q$ + "HR 01" + Q$
6340 o$ = o$ + m$ + Q$ + "HR 02" + Q$
6350 o$ = o$ + m$ + Q$ + "HR 03" + Q$
6360 o$ = o$ + m$ + Q$ + "HR 04" + s$
6370 PRINT #2, o$
6390 o$ = Q$ + m$ + Q$ + "HR 05" + Q$
6400 o$ = o$ + m$ + Q$ + "HR 06" + Q$
6410 o$ = o$ + m$ + Q$ + "HR 07" + Q$
6420 o$ = o$ + m$ + Q$ + "HR 08" + Q$
6430 o$ = o$ + m$ + Q$ + "HR 09" + Q$
6440 o$ = o$ + m$ + Q$ + "HR 10" + Q$
6450 o$ = o$ + m$ + Q$ + "HR 11" + Q$
6460 o$ = o$ + m$ + Q$ + "HR 12" + Q$
6470 o$ = o$ + m$ + Q$ + "HR 1" + s$
6480 PRINT #2, o$
6500 o$ = "3" + Q$ + m$ + Q$ + "HR 14" + Q$
6510 o$ = o$ + m$ + Q$ + "HR 15" + Q$
6520 o$ = o$ + m$ + Q$ + "HR 16" + Q$
6530 o$ = o$ + m$ + Q$ + "HR 17" + Q$
6540 o$ = o$ + m$ + Q$ + "HR 18" + Q$
6550 o$ = o$ + m$ + Q$ + "HR 19" + Q$
6560 o$ = o$ + m$ + Q$ + "HR 20" + Q$
6570 o$ = o$ + m$ + Q$ + "HR 21" + Q$
6580 o$ = o$ + m$ + Q$ + "HR " + s$
6590 PRINT #2, o$
6610 o$ = "22" + Q$ + m$ + Q$ + "HR 23" + Q$
6620 o$ = o$ + m$ + Q$ + "HR 24" + Q$ + m$ + Q$ + "METER BAND" + Q$ + m$ + Q$ + "QSL" + Q$
6630 PRINT #2, o$
7000 RETURN
8000 REM Prepare Preset and Page data using Frequency
8004 REM NO Presets Loaded?
8005 IF PMAX = 0 THEN GOTO 8900
8006 REM Got Some Presets, so look up the Frequency
8010 B$ = MID$(z$, 1, 7):REM FREQ
8020 FOR pindex = 1 TO PMAX
8030 IF B$ = frequency$(pindex) THEN o$ = o$ + m$ + Q$ + preset$(pindex) + Q$ + m$ + Q$ + page$(pindex) + Q$: RETURN
8050 NEXT pindex
8900 o$ = o$ + m$ + Q$ + "  " + Q$ + m$ + Q$ + "  " + Q$
8999 RETURN
9999 END

