Program VDE2RTF;
{ version 1.31
  (c) Pavel Zampach, 2004
  source text for Turbo Pascal compiler
}

Uses
  DOS, TrLate;

Const
  HeaderName = 'VDE2RTFH.TXT';

  BUnder  : boolean = false;
  BBold   : boolean = false;
  BItal   : boolean = false;
  BSuper  : boolean = false;
  BSub    : boolean = false;
  BUser   : boolean = false;
  BStrike : boolean = false;
  BDouble : boolean = false;
  UserDef : array [1..6] of string[63] = ('', '', '', '', '', '');

Var
  Vstup, Vystup : text;
  Line : string;
  c    : char;
  i    : integer;

Procedure error (Msg : string);
begin
  writeln;
  writeln (Msg);
  Halt (1);
end;


Function num2hex (b : byte) : char;
begin
  if b in [0..9]   then num2hex := chr (b + 48);
  if b in [10..16] then num2hex := chr (b + 87);
end;

Procedure copyHeader;

Var
  FDir  : DirStr;
  FName : NameStr;
  FExt  : ExtStr;
  i     : integer;

begin
  fSplit (paramStr (0), FDir, FName, FExt);
  assign (Vstup, FDir + HeaderName);
{$I-}
  reset (Vstup);
{$I+}
  if IOResult <> 0 then
    error (HeaderName + ' can''t be open');

  i := 0;
  while not eof (Vstup) do begin
    readln (Vstup, Line);
    if i = 0 then
      if Line <> '' then
        writeln (Vystup, Line)
      else
        i := 1
    else
      if i <= 6 then begin
        UserDef[i] := Line;
        inc (i);
      end;
  end; { while }

  Close (Vstup);
end; { Proc CopyHeader}

begin
  if paramCount < 2 THEN
    error ('USAGE: InFile OutFile [Table]');

  if paramCount = 3 then
    loadTrTable (ParamStr (3));

  assign (Vystup, ParamStr (2));
{$I-}
  rewrite (Vystup);
{$I+}
  if IOResult <> 0 then
    error ('Output file can''t be open');
  copyHeader;

  assign (Vstup, ParamStr (1));
{$I-}
  reset (Vstup);
{$I+}
  if IOResult <> 0 then
    Error ('Input file can''t be open');


  while not eof (Vstup) do begin
    readln (Vstup, Line);
    c := #0;

    for i := 1 to length (Line) do begin
      c := trChar (Line [i]);
      case c of
        #$02 : begin
          if BBold then write (Vystup, '\b0 ')
                   else write (Vystup, '\b ');
          BBold := not BBold;
        end;
         #$13 : begin
          if BUnder then write (Vystup, '\ul0 ')
                    else write (Vystup, '\ul ');
          BUnder := not BUnder;
        end;
        #$19 : begin
          if BItal then write (Vystup, '\i0 ')
                   else write (Vystup, '\i ');
          BItal := not BItal;
        end;
        #$14 : begin
          if BSuper then write (Vystup, '\nosupersub ')
                    else write (Vystup, '\super ');
          BSuper := not BSuper;
        end;
        #$16 : begin
          if BSub  then write (Vystup, '\nosupersub ')
                   else write (Vystup, '\sub ');
          BSub := not BSub;
        end;
        #$15 : begin
          if BUser then write (Vystup, UserDef[6])
                   else write (Vystup, UserDef[5]);
          BUser := not BUser;
        end;
        #$18 : begin
          if BStrike then write (Vystup, '\strike0 ')
                     else write (Vystup, '\strike ');
          BStrike := not BStrike;
        end;
        #$04 : BDouble := not BDouble;
        #$0C : write (Vystup, '\page ');
        #$1C : write (Vystup, '\-');
        #$01 : write (Vystup, '\f2 ');
        #$0E : write (Vystup, '\f1 ');
        #$09 : write (Vystup, '\tab ');
        #$1B : write (Vystup, '\');
        #$11 : write (Vystup, UserDef[1]);
        #$17 : write (Vystup, UserDef[2]);
        #$05 : write (Vystup, UserDef[3]);
        #$12 : write (Vystup, UserDef[4]);
        '{'  : write (Vystup, '\{');
        '}'  : write (Vystup, '\}');
        '\'  : write (Vystup, '\\');
        #$80 .. #$FF :
        begin
          write (Vystup, '\''', num2hex (ord (c) div 16), num2hex (ord (c) mod 16));
          if BDouble then write (Vystup, '\~');
        end;
        #$20 .. #$7E :
        begin
          write (Vystup, c);
          if BDouble then write (Vystup, '\~');
        end;
      end; { case }

    end;   { for }

    if (c <> ' ') and (c <> #$0C) then
      write (Vystup, '\par');

    writeln (Vystup);
  end;

{ close unclosed toggles }
  if BUser  then write (Vystup, UserDef[6]);

  writeln (Vystup, '}');
  Close (Vstup);
  Close (Vystup);

end.