/* CHESS FUNCTION(S): COMPILE.CHS -- standalone Chess program file
/*              DATE: 3/1/93
/*            AUTHOR: C. Schanck
/*
/*       DESCRIPTION: This program file contains a main body
/* which offers some compile choices (Reconfigure to your
/* tastes).  Compile choices rely on the function
/* 'compile_review' which executes the given command line and, if
/* the error file name is not blank, calls the function
/* 'parse_errs' to parse any errors associated with it.
/* 
/* attach this to a key via
/*    f1    run("c:\edit\bingo\compile.chs);
/* or bring it into the bingo.cfg directly
{           
   char temp[80];
   char buf[80];
   int i;
   i=box_pick("Which Compile Choice?",3,0,"1. Make","2. Compile Current File");
   if(i==0)
      return(compile_review("make > errs","errs."));
   if(i==1)
   {             
      ask("file_path",temp);
      ask("file_name",temp+strlen(temp));
      sformat(buf,"tcc %s > errs",temp);
      return(compile_review(buf,"errs."));
   }
   return(0);
}
compile_review       /* this runs a command, then if the errname
char cmd[0]          /* is not empty, parses the error file
char errname[0]
{       
   int ret;
              
   if(cmd[0]==0)
      return(0);
      
   if(Modify_save_all())
   {         
      str(cmd);
      key("return");
      key("return");
      ret=Swap_execute(); /* compile it 
      if(errname[0]!=0)
         ret=parse_errs(errname);
   }         
   return(ret);
}
parse_errs        /* this parses the error file passed in
char errname[0];
{  
   int i;                                       
   set_display(0);
   
   Window_one();                    /* one window
   Window_split();                  /* split window 
   Load_file(errname,"\\r");                 /* load file 
   Window_previous();
   Window_max();
   
   key("up_arrow");
   key("up_arrow");
   key("return");
   Window_resize();
   Setup_err_parse(errname,"\\r");

   set_display(1);
   update_display();

   return(Next_error());
}