
     BUILDERlite (TM)

                                              by:  Douglas Amaral

                                        created by:  Tom Campbell

                                        document by:  Chris Basom
                                                 BUILDERlite (TM)

Information in this document is subject to change without notice.

    Copyright (c) 1989, 1990, 1991, 1992, 1993 hyperkinetix, inc.
                                             All rights reserved.


hyperkinetix and BUILDERlite are trademarks of hyperkinetix, inc.

Chapter 1.  Welcome to BUILDERlite



     Revised January 11, 1994.

     Welcome to the shareware world of BUILDERlite.  We
     appreciate the vote of confidence you give when you part
     with a piece of your software budget.

     BUILDERlite is a "lighter" version of the world famous
     BUILDER, batch file compiler and language extender.  Since
     the first release of BUILDER in January of 1990 (and,
     honestly since the release of its predecessor, SonofaBatch,
     in October of 1989) we have been working with BUILDER users
     to create an easy to learn, easy to use, powerful compiled
     language.  We are very pleased to bring you the culmination
     of many years hard work in BUILDERlite.  We hope that it
     does as much for you as you have done for us, again, thanks.

What BUILDERlite does

     BUILDERlite gives you a quick and easy way to:

            1. Create slick, efficient menu front-ends.
            2. Build beautiful, user-proof, installation
               programs.
            3. Write and distribute utilities of all sorts that
               make the daily use of a PC easier and faster.

     BUILDERlite can also import .BAT files and convert them into
     true compiled .EXE programs.  Along the way it gives you
     language extensions for screen control, and program flow, to
     make your batch files run faster and look better.

     You may distribute your compiled programs in any way you see
     fit, with no royalty to hyperkinetix, inc.

What you should know before starting

     Here's how to slide by without reading every word.

            1) Take the time to read Chapter 2.  Learning to Use
               BUILDERlite!  It will show you how to access the
               environment, code, compile, edit, and compile
               again.
            2) If you are going to compile .BAT files, read the
               IMPORT appendix.
            3) At least review Chapter 3.  Language Reference and
               Runtime Issues.

     NOTE:  A BUILDERlite created .EXE file stays resident in
     memory while it's running and is unloaded only upon
     termination.  Any menu program you create using BUILDERlite
     will remain in memory when you instruct it to call another
     executable program.  We do not recommend that you load
     memory-resident programs such as Sidekick from a BUILDERlite
     created .EXE file unless you're willing to give up the
     memory occupied by the calling .EXE file.

How to get help

     If you encounter difficulties in operating BUILDERlite or
     compiling your source code, please thoroughly review the
     Command Reference and other related parts of the manual.  If
     you need help from hyperkinetix, there are several ways to
     get it:

               1.   Write us at:

               hyperkinetix, inc.
               18001 Irvine Blvd., Suite H
               Tustin, CA 92680
               Attn: Technical support

               2.   Contact us via CompuServe user ID 75300,2010,
               or post a general message in hyperkinetix' PCVEND.

               3.   If you're not on CompuServe, use BUILDERlites
               ONLINE ACCESS (and your modem) to call our BBS at
               714/573-3993.  We support up to 14400 baud.  If
               you are not using BUILDERlites ONLINE ACCESS, be
               sure to set the following parameters on your
               communication software before calling:  Parity=N,
               data bits=8, stop bits=1.

               4.   FAX us at 714/573-2297.

               5.   Call our technical support line at 714/573-
               2260.

Installing BUILDERlite

     Installing BUILDERlite is simple:

        o  Copy all files into a directory of your choice

        o  Include the above directory in your PATH statement

        o  Set a BLHELP environment variable to point to where
           the BUILDERlite help system is located

     Thats it!

     For example, assuming BUILDERlite is installed in the
     C:\BLDRLITE Directory:

     Path=%Path%;C:\BLDRLITE;
     Set BLHELP=C:\BLDRLITE;

Running BUILDERlite

     To run BUILDERlite in command-line mode (and compile a
     source file) type:

       BLDLITE <FILENAME>

     at the DOS command line while in the BUILDERlite directory.

     NOTE:  If the source file has a .BAT extension, BUILDERlite
     will create a .BLD file before compiling.  Any further
     editing and compiling must be done with this .BLD file.

     For instance, a script named GETKEY.BLD script would be
     compiled by typing:

       BLDLITE GetKey

     at the DOS prompt.

     Upon a successful compile, the BUILDERlite linker, MLINK,
     will be executed.  This produces an .EXE file (GETKEY.EXE in
     the above example) that is a true compiled program you can
     run on any DOS PC.

Owner's Registration

     Print out and complete the REG.DOC file found in the
     BUILDERlite directory.  Send it to us (with the appropriate
     payment) to register your ownership.  By return mail you
     will receive verification of your registration, and a
     diskette containing any update to the BUILDERlite program
     files or documents.  Registration will allow you to receive
     technical support, and it will also ensure that you are kept
     informed of all updates, upgrades, and maintenance releases
     of BUILDERlite

     (Without proper registration we are unable to support your
     use of BUILDERlite in any manner.)

License Agreement

     hyperkinetix, inc. authorizes you to make archive copies of
     BUILDERlite for the sole purpose of protecting your
     investment in BUILDERlite.  You may run BUILDERlite on one
     machine at a time, regardless of location, but you may never
     run it simultaneously on two machines.  You are bound by
     this agreement to ensure that no unauthorized copies of
     BUILDERlite are distributed, installed, or used in any
     manner.  "One disk, one user."

Liability Disclaimer

     Because we have no idea how you will use BUILDERlite (I am
     reminded of the guys who attempted to use a lawn mower to
     trim their hedge), we cannot be held responsible for any
     damage caused by any part of our product.  This includes,
     but is not limited to:  paper cuts from the manual, putting
     out an eye by tossing a diskette, kicked-in monitors by
     frustrated programmers, system re-formats, military coups,
     damage to the ozone, or core meltdown.

Acknowledgements

     BLDLITE, BUILDERlite, EDITLITE, and MLINK, are trademarks of
     hyperkinetix, inc.  MSLink is a trademark of Microsoft, Inc.
     TLink is a trademark of Borland International, Inc.  Plink
     is the noise made by striking the right-most-key on your
     piano.

     Acknowledgements wouldn't be complete without thanking the
     following people by name:  Michael Devore for reworking
     MLINK, Ray Beaudoin for keeping us in the game, and Sharon
     Amaral for loving Doug.

     The entire staff at hyperkinetix, inc. would also like to
     take this time to thank our beta testers, shareholders, and
     each of our customers for their support, help and good
     karma.

Chapter 2.  Learning to Use BUILDERlite



     This chapter will familiarize you with the operation of
     BUILDERlite.  By the end of the chapter you'll understand
     what a compiler is, how it works, and why BUILDERlite
     programs are better than batch files.  Then we'll run
     through the steps of firing up the environment, loading a
     script, compiling, and running that newly created program.
     Finally we'll look at compiling a script from the command
     line.

     Chapter 3 will give you a much more detailed look at
     developing in BUILDERlite; this chapter's purpose is
     mirrored in its title:  Learning to Use BUILDERlite.


What's a compiler?


     In case you're not quite sure what a compiler is and how
     BUILDERlite differs from the batch language, here's a brief
     explanation.

How DOS works

     First, it might help for you to know how the DOS batch
     interpreter works.  It all starts with a program called
     COMMAND.COM.  It is a program like any other, with the
     exception that it's always run first when your computer
     starts.  COMMAND.COM  then stays in memory when other
     programs, such as your word processor or database, are
     executed.  COMMAND.COM sits in a continual loop, waits for
     you to type in a command, then tries to execute that
     command.

     There's a special meaning to the term command.  DOS was
     designed to be extensible.  That means that programs ending
     in .COM or .EXE are literally treated by COMMAND.COM as
     extensions of the operating system itself, and are therefore
     quite often called commands.  That's why there's little
     distinction in the MS-DOS documentation between the nature
     of COPY, which is built into COMMAND.COM, and XCOPY.EXE,
     which is a separate program file.  As far as the operating
     system is concerned, CLS and CHKDSK.COM are both valid
     command names.  For that matter, so is WP.EXE, or whatever
     the name of your word processor.

     Commands like CLS and DIR are called intrinsic commands;
     because they're built into COMMAND.COM and there's no
     separate program file for either of them.  They're simply
     subroutines in, or components of COMMAND.COM, although they
     could just as easily be discreet programs called CLS.COM and
     DIR.EXE.  For example, there's no particular reason that
     XCOPY couldn't be built into COMMAND.COM.  The reverse is
     also true:  because it's simply an executable file,
     COMMAND.COM itself can be replaced.

How COMMAND works

     COMMAND.COM treats three file extensions specially:  .COM,
     .EXE, and .BAT.  Any filename ending in those letters is
     considered a program.  For example, when you enter CHKDSK at
     the DOS prompt DOS runs through these steps:

            1. Checks to see if CHKDSK is an intrinsic command
               such as DIR or CLS.  If it is, COMMAND.COM itself
               contains the code for the command and executes it,
               then skips the rest of the steps here.
            2. If it isn't, COMMAND.COM looks for CHKDSK.COM in
               the current directory.  If such a file is found,
               it executes and puts up the DOS prompt again.
            3. If it isn't, COMMAND.COM looks for CHKDSK.EXE in
               the current directory.   If such a file is found,
               it executes and puts up the DOS prompt again.
            4. If it isn't, COMMAND.COM looks for CHKDSK.BAT in
               the current directory.  If it's found, COMMAND.COM
               reads each line of the batch file one at a time
               and executes the instructions in the file.
               COMMAND.COM treats the lines of a batch file as if
               you had typed them at the DOS prompt.  This means
               it never knows if there's an error on a line--even
               if it has executed that line before.  Because
               there's an immense amount of error checking, batch
               files execute relatively slowly compared to .COM
               or .EXE files, which the operating system assumes
               are error-free.
            5. If CHKDSK.COM, CHKDSK.EXE, and CHKDSK.BAT are not
               found in the current directory, DOS repeats steps
               2-4 for each directory on the path.
            6. If the file is never found, then the familiar Bad
               command or filename message appears.

     By use of its priority checking system, COMMAND.COM creates
     some interesting twists.  If you have three programs in the
     current directory named PROGRAM.EXE, PROGRAM.BAT, and
     PROGRAM.COM, DOS will always execute PROGRAM.COM, even if
     you specify one of the other extensions explicitly!  The
     order that DOS uses to search for an executable file is
     .COM, .EXE, and .BAT.

     Because COMMAND.COM will always execute in the order of
     .COM, .EXE, then .BAT, BUILDERlite leaves your original .BAT
     file undisturbed.  As soon as you've created an .EXE file
     (by compiling), COMMAND.COM will ignore your .BAT file in
     lieu of the .EXE file.

Inside DOS

     DOS itself has no knowledge of batch files, only .COM and
     .EXE files.  DOS treats COMMAND.COM as any other program,
     and gives it the full responsibility of interpreting batch
     files.  Therefore, BUILDERlite needs COMMAND.COM, or some
     program compatible with it, to execute a DOS command or a
     batch file.

     BUILDERlite uses DOS to execute .COM and .EXE files, but
     when it finds a .BAT file, it transfers responsibility to
     COMMAND.COM by secretly running it and passing it the name
     of the batch file.  This should never disturb your normal
     working patterns since the process is transparent, but keep
     in mind that an extra 3K of RAM is temporarily consumed
     while COMMAND operates, and that COMMAND must be on the path
     to run a batch file from within a BUILDERlite-generated .EXE
     file.

How BUILDERlite works

     A batch file is different from an .EXE file in that its
     English-like instructions (ECHO, GOTO, PAUSE and so on) must
     be decoded by COMMAND.COM before they can be executed.
     Because COMMAND.COM never knows what's going to come next in
     a batch file (be it an intrinsic command, a program file, or
     a word that means nothing because it's misspelled or the
     program's not on the path) a lot of time is consumed while
     each line of the program is decoded.

     An .EXE file, on the other hand, is in the computer's native
     language and looks nothing like English.  Since you can do
     just about anything you want in an .EXE file, it seems like
     a good idea to convert .BAT files to .EXE files.  And that's
     just what BUILDERlite does.

     BUILDERlite simulates the batch commands by translating them
     into machine code.  When it sees CLS, for example, it
     translates that into instructions to fill the screen with
     spaces at such a high speed it looks like the screen is
     cleared.  When it sees ECHO, it knows that the text
     following ECHO should be displayed as is.  When it sees
     PAUSE, it knows to print any text following the PAUSE and to
     wait for a key.

     Because BUILDERlite knows what these commands mean, it
     dispenses with the English language portion and replaces it
     with machine instructions. That's why you can't tell what's
     going on in a compiled BUILDERlite script by using the TYPE
     command on it.

Differences from batch files

     BUILDERlite needs to know a few things in advance that the
     batch interpreter has the luxury of ignoring.  For example,
     BUILDERlite statements must all start with a known word.
     All seven batch commands are supported:  ECHO, FOR, GOTO,
     IF, PAUSE, REM, and SHIFT.  Some commands, such as IF and
     FOR, are altered slightly to avoid ambiguities.  BUILDERlite
     converts all .BAT files automatically to .BLD files,
     altering the syntax of those commands it needs to see
     differently.  It also inserts a RUN before anything it
     doesn't recognize as a BUILDERlite keyword or command, such
     as DIR, WORD, DBASE, or CHKDSK.

     NOTE:  Please refer to the Import appendix for more detailed
     information on the Import procedure.

     You need to keep all of this in mind when you edit a .BLD
     file.  The Command Reference tells you how the new language
     syntax works.  It also provides a reference for each batch
     keyword.

Making batch better

     By altering the batch language COMMAND.COM understands,
     BUILDERlite adds to the language in a way that COMMAND.COM
     can't hope to emulate.  For example, BUILDERlite scripts can
     act on particular keystrokes, display text with different
     attributes (such as boldface or color), and make intelligent
     decisions while the script is running. They also make it
     impossible for users to tamper with the script file, since
     the English-like syntax of the language is lost on
     translation to an .EXE file.

Compiling and linking

     Compiling; is the process of taking the English-like
     commands of BUILDERlite and creating a new file, ending in
     .OBJ, with translations of those commands into native
     machine code.  The .OBJ file is only an intermediate step.
     It can't run by itself; MLINK must turn it into an
     executable file.  BUILDERlite runs MLINK automatically at
     the end of the compile process.

     MLINK.EXE is an MS DOS compatible linker and could be
     replaced with any of a number of similar linkers.  It was
     developed by hyperkinetix to work with BUILDERlite, and
     we're proud to supply it to you for your use.

     Why not just create an executable .EXE file directly?  Not a
     bad idea, but it turns out that the compile-link step allows
     you greater development flexibility.

Fire it up, Scotty

     Here's an overview of the operation of BUILDERlite:

            1. From the DOS prompt while in the BUILDERlite
               directory, fire up the Integrated Development
               Environment (IDE) by typing "BUILDER".
            2. To load a file into the IDE press {F3}, and type
               "SUBDIRECTORY\FILENAME.EXTENSION" in the space
               provided.
            3. Compile the file by pressing {F9}.

     Congratulations!  You have successfully compiled a program
     using BUILDERlite.  Take a second to enjoy the moment...
     Now let's run the program you compiled:

            4. Press {Alt-C} to select Compile menu that will
               allow you to run your program from within the IDE.
            5. Now press {R} to run your program.  (You could
               have accomplished this same effect by pressing
               {Ctrl-F9} from anywhere within the IDE).

     That's all there is to it.  The process is simple.  You
     enter the environment, load (or code) a file, and then
     compile it.  If an error window appears during compilation,
     fix the problems noted and repeat step 3 above.  If no
     errors occur then you receive the "Compilation Successful"
     message.

     With that done, let's exit BUILDERlite altogether and start
     again from step one above.

            6. Quit BUILDERlite by pressing {Alt-X} or by
               pressing {Alt-F}, then {Q}.

Compiling a .BAT file

     If you need to compile an existing .BAT file, just load it
     into the IDE the way you did above.  BUILDERlite will import
     and convert it automatically.  You must specify a .BAT
     extension when you load the file, otherwise the Import
     utility will leave the file alone, believing it to be in
     BUILDERlite syntax already.  Here's an example, using the
     imaginairy TUTORBAT.BAT file.  From within the IDE:

            1. Press {F3} to load, and type "TUTORBAT.BAT."
               (the file has been converted to BUILDERlite syntax
               and is ready to compile)
            2. Press {F9} to compile.
     BUILDERlite compiles TUTORBAT.BLD, not TUTORBAT.BAT.  It's
     good to compare the two; you'll get a feel for how
     BUILDERlite translates from .BAT to .BLD.  You can view them
     with the DOS TYPE command.

From the command line

     When you compile from within the IDE you are actually
     issuing a command that is passed to a separate program,
     BLDLITE.EXE;, which does the work of translating the .BLD
     script into an object, or .OBJ, file, and MLINK, which finally
     converts the .OBJ into an .EXE file.  You can, in fact,
     bypass the IDE by compiling from the command line.  It's a
     little faster to run the compiler and linker this way,
     instead of from the IDE.  It also allows you to stop the
     compile process at the object level.  This results in an
     .OBJ file that you can link with others to create a program
     (more on this later).

     For our purposes here, the command line syntax is:

       BLDLITE  <FILENAME>

     Let's use the files we know about as examples.  First we'll
     compile a .BLD file, then a .BAT file.  From the DOS prompt
     while resident in the BUILDERlite directory, type:

       BLDLITE  TUTOR

     The .BLD extension is assumed, so BLDLITE first looks for a file
     called TUTOR.BLD.  If found, TUTOR.BLD is compiled.  If not,
     BLDLITE looks for TUTOR.BAT.  If found, Import automatically
     creates an .BLD file from the .BAT and compiles that.
     Remember that BUILDERlite never actually compiles a batch
     file.

     NOTE:  If you use an explicit file extension (other than
     .BAT), for example, .TXT or .SRC, BUILDERlite assumes the
     file has already been imported, and again assumes that the
     new syntax has been used.

Directory searches

     BLDLITE.EXE;, MLINK.EXE;, and the runtime library BLDLITE.LIB; can
     be anywhere on the path.  They need not be in the same
     directory either:  BLDLITE.EXE can be in your \UTILS directory,
     MLINK.EXE in your \BIN directory, and BLDLITE.LIB in your \LIB
     directory, as long as they're all on the path.

     Our installation program places all of the compiler
     components into a BUILDERlite directory.  We have assumed
     throughout this chapter that you are operating from that
     directory.

Linking

     The activities resulting from your typing:

       BLDLITE  TUTOR

     don't stop with the operation of BLDLITE.EXE, and the creation
     of TUTOR.OBJ.  The final step in the compilation cycle is
     linking.  BLDLITE.EXE calls MLINK.EXE to convert the .OBJ file
     into the final .EXE file that you will operate on your PC.
     Using the command line compiler, BLDLITE.EXE, it is possible to
     halt the process at the creation of an .OBJ file, and link
     independently later.  This is the way to bring other .OBJ
     modules (and other languages) into your final program.

     To compile without linking, use the -c option, which means
     "compile only".  For example:

       BLDLITE  -c  TUTOR

     This creates the file TUTOR.OBJ but doesn't run MLINK.
     Therefore TUTOR.EXE is never created.

     NOTE:  The -c option is only valid using the command line
     version of BUILDERlite.

Linking independently with MLINK

     Let's get acquainted with the idea of linking independently,
     and get a feel for the linking process.

     The following is assumed:

            1. BLDLITE.EXE is on the path.
            2. MLINK.EXE is on the path.
            3. BLDLITE.LIB is in the current directory.
            4. TUTOR.BLD is in the current directory.

     First, make sure no extraneous files are present.  Execute
     these lines at the DOS prompt:

       del TUTOR.OBJ

       del TUTOR.EXE

     Compile TUTOR1.BLD using the "compile only" switch.  Type:

       BLDLITE  -c  TUTOR

     Verify that only TUTOR1.OBJ has been created, and that
     there's no TUTOR1.EXE yet:

       dir  TUTOR.*

     Let's see what command line options MLINK provides.  To find
     out, enter MLINK by itself at the command line.

     The following information is presented:

       MLINK 2.00a Copyright 1989-91 by Michael Devore and
       hyperkinetix, inc.
       All rights reserved
       SYNTAX:  MLINK [options]
       object_files[,[program_file][,[map_file][,[library_files]]
       ]][;]
                (items in brackets are optional)
                or
                MLINK @response_file

       OPTIONS:
       /as:<size>   maximum program Allocation space in
       paragraphs
       /b      Beep the speaker upon exit
       /i      display link process Information
       /m      create MAP file
       /s      symbol names are case sensitive
       /st:<size>   program STack size in bytes
       /tf:<name>   Temporary File name
       /W0          Warnings generate an exit code of 0, instead
       of 1
       /wn          Warnings are Not displayed

     Bracketed items are optional.  Everything else you need must
     be typed in literally, as shown.  If you omit items with
     commas between them, you must supply the commas themselves
     as placeholders.

     MLINK is an MS-DOS linker that creates .EXE files directly.

     MLINK assumes that the program file will be the same name as
     the .OBJ file.  You can generate a different .EXE file name
     using the program_file option.

     Map files are helpful for advanced debugging.  For our
     discussion here, suffice it to say that BUILDERlite can
     create them using the command line option /m.

     We want to create a .EXE file, but that's the preset action.
     The last bracketed item, [library_files], is only
     technically an option:  in real use you'll always need the
     runtime library.  So linking TUTOR would require you to type
     this at the command line:

       mlink TUTOR,,,bldlite

What the linker command line means

     This means that the .OBJ file to use is TUTOR.  The library
     file to use is BLDLITE.LIB.  The items in the middle will use
     preset options:  no program_file need be specified because
     MLINK creates TUTOR.EXE automatically.  If you wanted the
     program name to be something else, for example, TRYIT.EXE,
     your command line would be this:

       mlink TUTOR,TRYIT,,bldlite

     MLINK doesn't normally create a map file.  You can create
     one using the /m option:

       mlink /m  TUTOR,,,bldlite

     This creates the file TUTOR.MAP.  It's a text file you can
     TYPE to the screen or view with the BUILDERlite editor.

     That's all there is to using a stand alone linker.  Using
     MLINK in this way will allow you to marry .OBJ files
     together to create more powerful and useful applications.

     A complete discussion of linking BUILDERlite .OBJs with ASM
     is held in the chapter Language Reference and Runtime
     Issues.

Chapter 3.  Language Reference and Runtime Issues



About this chapter

     This chapter gives an overview of the BUILDERlite language
     and a thorough explanation of what takes place when a
     BUILDERlite-generated .EXE file runs:  memory consumption,
     environment usage, ERRORLEVEL handling, and so on.


BUILDERlite programs


     A BUILDERlite program consists of variable declarations,
     statements, and subroutines.

     They should appear in that order:  variable declarations
     should appear before statements, and statements should
     precede subroutines.

Variable declarations

     Here are some examples of variable declarations:

       File InFile, OutFile, HoldFile
       Integer Int1, Size2, Num3
       Longint Longint1, Bignum2, DFree
       String DiskName, NextLine, UserLog
       StringArray SA1, StrArray2, FilesArray3

     A variable declaration contains two parts, and looks like
     this:

       Integer Int1

     The first element in a variable declaration is the TYPE of
     variable being declared (Integer, String, etc.).  The next
     elements are the name(s) of the variable that will be used
     in the program.  In the example above, the program will be
     using an Integer variable called Int1.  Multiple
     declarations of the same variable type are allowed on a
     single line as long as the variables being declared are
     separated by commas.  Variable names cannot be the same as
     BUILDERlite commands or reserved keywords.  Reserved words
     are listed in an appendix of this manual.

Sub declarations

     A Sub declaration isn't itself executable.  Sub declarations
     only describe what will happen when the sub name is used to
     invoke, or execute, the sub.  For example, this program does
     nothing:

       Sub DoBeep
         Beep
         Beep
       End

     To invoke the sub, just use its name:

       DoBeep

       ' Program ends here.  Execution stops at the first SUB
       declaration.

       Sub DoBeep
         Beep
         Beep
       End

     Note that, unlike C or Pascal, BUILDERlite doesn't want to
     see the Sub declared before it's used.  BUILDERlite is a
     two-pass compiler, and uses the first pass to determine the
     names of subs.

Statements

     A BUILDERlite statement consists of an assignment, a
     subroutine invocation, or any of the built-in statements
     described in The BUILDERlite Command Reference.

     An assignment is the replacement of the contents of a
     variable with an expression.  Line 2 of this example is an
     assignment:

       String Value
       Value := "Little " + "Neutrino"

     (We will dissect expressions later.)

     Here are some example of statements:

       ' 1. While statement
       While not EOF InFile
         ReadLine NextLine from InFile
       End ' While



       ' 2. Say statement
       Say "hello, world"



       ' 3. IF statement
       IF DOSErrorLevel is 1
         say "Error!"
         Beep
       End



       ' 4. Built-in statements
       Goto Top
       GetYN

     Note that the While and If statements each span several
     lines and may themselves contain other statements, yet each
     group is itself considered a statement.

Subrountines

     A Subroutine is an executable piece of code that resides at
     the end of your source file, but is executed in a program
     statement (as described above).  Subroutines don't, in and
     of themselves, do anything.  They only perform if called by
     a program statement.  Here's an example of a subroutine that
     beeps the PC speaker twice:
       Sub DoBeep
         Beep
         Beep
       End

     To use this subroutine it must be called or invoked.  To
     invoke the sub, just use its name:

       DoBeep

       ' Program ends here.  Execution stops at the first SUB
       declaration.

       Sub DoBeep
         Beep
         Beep
       End

     Note that, unlike C or Pascal, BUILDERlite doesn't want to
     see the Sub declared before it's used.  BUILDERlite is a
     two-pass compiler, and uses the first pass to determine the
     names of subs.




Expressions


     An expression consists of a constant, a variable, or some
     combination of the two with the appropriate operator.
     BUILDERlite constants consist of integers (whole numbers in
     the range -32,768 to 32,767.), longints (whole numbers in
     the range -2,147,483,648 to 2,147,483,647), and string
     constants (anything between pairs of quote marks).

     Examples of valid integer constants are -3, 300, and 30,000.
     Examples of malformed integer constants are 3.5 (not a whole
     number) and 300,000 (too big).

     Examples of valid longint constants are -300,000, -3,300,000
     and 33,330,000.  Examples of malformed longint constants are
     3.5 (not a whole number) and 300,000,000,000,000 (too big).

Hex, K, and binary constants

     For convenience, numeric constants may end with the letter
     "H", "K", or "B" (upper- or lowercase).  The designation "H"
     means the number is presented in hex.  "K" means the number
     is presented in kilobytes.  "B" means the number is
     presendted in binary.  Examples of valid hex constants
     include 10H and 0FFh.  Hex numbers must start with a decimal
     digit; otherwise they look like variable names.  For that
     reason FFh is not a valid hex number, but 0FFh is.  Numbers
     ending in K are multiplied by 1,024, therefore 2K is
     equivalent to decimal 2048.  Examples of valid binary
     numbers include 100b and 1111111100000001b.

     String constants are between quotation marks:

       "Go, Speed Racer!"
       "A"
Operators

     BUILDERlite supports simple arithmetic operators, logical
     operators, and a few string operators.

Arithmetic operators

     BUILDERlite supports the math functions of multiplication
     (*), division (/), addition (+), and subtraction (-).  All
     apply to integer and longint expressions.  Here are some
     valid BUILDERlite expressions using math operators:

       Integer A, B
       Longint C, D
       A := A + 1
       Put A - 1 into B
       C := A * 2
       C := C / D

Relational operators

     The relational operators apply to integers, longints, and
     strings equally.  The result of a relational operation
     evaluates either to 0 (false) or a nonzero value (true).
     The relational operators are these:

            Relational operator    Means

            ==, is            Equal to

            <                 Less than

            >                 Greater than

            <=                Less than or equal to

            >=                Greater than or equal to

            <>                Not equal to

            NOT               Reverses a condition


     Listed below are some operators at work and the results they
     evaluate to:

            Operation         Results in

            1 == 1            1

            1 is 69           0

            1 < 3             1

            3 < 1             0

            3 <= 3            1

            "Kitty" == "Kitty"          1

            "Boris" == "BORIS"          0

            "Boris" == "Natasha"   0

            1 <> 1            0

            1 <> 2            1


String operators

     In addition to the relational operators, strings have the
     concatenation (+) and Contains operators.  Concatenation
     attaches one string to the other.  Contains returns a
     nonzero value if one string is within another (case
     sensitive), or zero if not.  Here are some examples of
     string operations and their results.

            Operation              Results in

            "Brown" + " for President!"      "Brown for
            President!"

            "Bill and Ted" Contains "Bill"        1

            "Bill" Contains "Bill and Ted"        0

            "Bill and Ted" Contains "bill"        0



BUILDERlite runtime issues


     ERRORLEVEL and SYSTEM
     The SYSTEM command allows you to pass a string constant or
     variable to the DOS command line.  Because this means a
     secondary copy of COMMAND.COM is executed, the program's
     ERRORLEVEL is lost.

     Hiding the output of programs
     Sometimes you need to hide the messages a program or DOS
     command displays while it's running.  A common example is
     that of the COPY command, where you wish to hide the message
     1 File(s) copied.   You can hide the output of programs that
     use DOS services to display text by redirecting to NUL.
     Let's take a look.  Put a floppy diskette in drive A and
     copy a file to it; for example:

       C:\BUILDER>copy c:\config.sys a:

               1 File(s) copied

     To suppress the status message for any such command line,
     append > NUL to it.  For example:

       C:\BUILDER>copy c:\config.sys a: > nul

     This works for most command line programs and all DOS
     commands.  Another example is DIR; try a DIR with the same
     redirection applied:

       C:\BUILDER>dir > NUL

     It will appear that nothing happened.  In fact, something
     did--output went to a special device called NUL which DOS
     treats as a do-nothing device driver.  Its purpose is for
     such occasions as this.


Valid filenames


     Legal characters are:

       A-Z  a-z  0-9  $  %  '  @  {  }  ~  !  #  (  )  &


Mouse


     BUILDERlite supports the mouse automatically in menu
     statements:  DropDown, LightBar, and PopUp.  There are mouse
     statements in the language that allow you to check for the
     installation of a mouse, hide its cursor or show its cursor.
     If a Microsoft-compatible mouse is present, BUILDERlite
     programs will use it unless otherwise instructed.  In the
     case of your having disabled a mouse, keyboard equivalents
     will be recognized by BUILDERlite and acted upon.


The DOS environment


     The DOS environment is an area of RAM set aside for any
     program to use.  Any executing program has access to the
     entire DOS environment.  If you enter SET at the DOS command
     line you can see the current contents of the environment:  a
     set of text strings, such as these:

       PATH=C:\BIN;C:\BUILDER
       COMSPEC=C:\COMMAND.COM
       PROMPT $P$G

     Each string has these characteristics:

            1. The strings are in printable ASCII form.
            2. The environment variable;, which is the value on
               the left of the = sign.
            3. The value the variable is set to, which is on the
               right of the = sign.
            4. The = sign itself, which separates the environment
               variable from its value.

Creating or changing an environment variable

     You can change the value of a variable, or display it, using
     the SET command with parameters.  The syntax is this:
       SET <variable>=<value>

     At the DOS command line, the items in angle brackets don't
     need quotes around them, however in BUILDERlite they are
     required.  It is very good practice to avoid spaces on
     either side of the equals sign when using this statement at
     the DOS level, although it is fine to do so in BUILDERlite
     syntax.  Surrounding spaces are significant in the DOS
     version of SET and can cause no end of suffering when you
     try to track down unusual problems regarding environment
     variables.

     For example, to create an environment variable from the DOS
     command line, exit to DOS and enter this line:

       C:\BUILDER>set TMP=C:\BUILDER

     Now view it using the SET command without parameters:

       C:\BUILDER>set

     You will see, among the other values:

       TMP=C:\BUILDER

Changing the environment with the BUILDERlite SET

     As you've seen, the DOS SET command looks like this:

       SET <variable>=<value>

     The BUILDERlite SET has a slightly different syntax:

       SET "<variable>" = "<value>"

     In BUILDERlite remember that:

            1. Items on each side of the equals sign are
               surrounded by quotes (when you're using string
               literals).
            2. Spaces on either side of the equals sign don't
               matter.
            3. You can use string variables or expressions with
               the SET command.  For example:

       String EnvVar
       EnvVar := "C:\BIN"
       SET "VALUE" = EnvVar

Removing an environment variable

     To eliminate an environment variable use the format SET
     <variable>=, leaving the right side blank.  This will not
     create the string (in this example) TMP= in the environment.
     Instead, it will erase the variable and its value
     completely.  Try it:

       C:\BUILDER>set TMP=

     Now view the environment by entering SET by itself at the
     command line.  The environment variable TMP and it's value
     will no longer be present in the environment.

       C:\BUILDER>set
       PATH=C:\BIN;C:\BUILDER
       COMSPEC=C:\COMMAND.COM
       PROMPT $P$G

Changing the size of the DOS environment

     From time to time you will see the terse message "Out of
     environment space".  It happens when an environment variable
     is created or modified and the amount of space required by
     the variable name, equals sign, and its value all exceed the
     space DOS allocates for the environment.

     The DOS environment normally occupies 160 bytes of RAM.
     Some users maintain a larger environment via the SHELL
     directive, normally found in CONFIG.SYS.  It can also be
     effectively enlarged by running a secondary copy of
     COMMAND.COM.  Here's how these methods work.

     COMMAND.COM is a program like any other.  But it's a
     particularly important one, and it translates commands like
     DIR and RENAME into calls to DOS (the operating system).
     COMMAND.COM isn't technically a part of DOS at all.  Infact,
     you as a user never interact with DOS directly.  You
     interact with COMMAND.COM, and it interacts with DOS.
     COMMAND.COM is nothing more than a set of canned procedures,
     operating at a detailed level, to handle disk, screen,
     printer, and keyboard management.  COMMAND.COM's useful
     ability to take English-like commands such as RENAME and
     convert them to the appropriate system calls earns it the
     title of shell or command processor:  a program that runs on
     top of another program, providing a different level of
     abstraction.  In fact, you can replace COMMAND.COM with
     another command processor entirely:  many shells exist to
     make DOS look like the UNIX operating system.

     You can run another copy of COMMAND.COM simply by entering
     "COMMAND" at the DOS prompt from your root directory (or
     anywhere if COMMAND.COM is on the path).  Using the MEM
     utility provided in the examples subdirectory, or the
     venerable CHKDSK.COM, you'll notice that about 3K of memory
     has been subtracted from DOS to accommodate it.  You quit
     that copy of COMMAND.COM by typing "EXIT" at the DOS prompt
     and pressing {Enter}.  Run MEM again and you will notice
     that the memory has returned.

     Loading another COMMAND.COM this way is normally called
     loading a secondary copy.

     Any changes to the environment of a secondary copy of
     COMMAND.COM will last only until you type EXIT.  That's
     because the secondary copy inherited its environment by
     copying the current one, and its copy disappears when the
     secondary COMMAND.COM is unloaded via the EXIT.

     COMMAND.COM, like many programs, has command-line switches.
     One of them is the /E switch, which lets you change the size
     of the environment.  The bottom (and default) figure is 160
     bytes.  The format is this:

       COMMAND /E:[<size>]

     Where the square braces indicate optional input, <size> is
     replaced by a number from 160 to 32,767.  This works only
     for COMMAND.COM in versions of DOS starting with 3.2.
     Versions 3.0-3.2 offered /E as an undocumented feature, but
     the <size> parameter must be divisible by 16.  Versions of
     DOS before 3.0 don't support /E at all.  This allows you to
     create a new command processor with a copy of the current
     environment (and room for plenty more).  The following
     example uses /E to create a 2,000 byte environment.

       COMMAND /E:2000

     The SHELL directive allows you to change the environment
     size in another way.  On startup, DOS looks in CONFIG.SYS
     for the SHELL directive.  SHELL lets DOS choose a program
     other than COMMAND.COM as its command processor.  It also
     lets you reset the default environment size.

     You can also use the /P option to rerun AUTOEXEC.BAT.  This
     example runs COMMAND.COM with an environment of 1,000 bytes
     and then runs AUTOEXEC:

       SHELL=COMMAND.COM /E:1000 /P

Changing the environment size with RUN and SYSTEM

     You can forever eliminate the "Out of environment space"
     message by preceding a RUN or SYSTEM statement with COMMAND
     and a new environment size.  Use /C to load a secondary
     COMMAND.COM and create the new environment.  Bear in mind
     that the 3K for a new COMMAND.COM and whatever size you
     choose for the environment will be subtracted from DOS's
     free memory.  Here are a few examples.

       Run Command /E:1000 /C progname

       system "Command /E:1000 /C progname"

Side effects of RUN and SYSTEM

     A .COM or .EXE program is passed a copy of the DOS
     environment at file execution time.  The copy comes from the
     program that ran that .COM or .EXE, typically COMMAND.COM.
     The called program can alter its copy, but once that .COM or
     .EXE program stops execution, the original environment is
     restored.  We'll call the environment owned by whatever ran
     the .COM or .EXE the master environment.

     Note that batch files allow you to change the environment,
     but the original environment can't be changed by a .COM or
     .EXE.  Because BUILDERlite is upwardly batch compatible,
     when you change the environment in a BUILDERlite created
     .EXE file, the master environment is also changed.  On a
     less-than 100%-compatible system this may pose a problem.

Batch files and the environment

     Batch files (those with an extension of .BAT and that
     weren't compiled) must be interpreted by COMMAND.COM.
     BUILDERlite-created .EXE programs can run batch files, but
     they do so by running a copy of COMMAND.COM, which in turn
     interprets the batch file.  When such programs use the SET
     command to change the environment, they change only the copy
     of the environment owned by the copy of COMMAND.COM running
     them.  (When control passes back to the BUILDERlite created
     .EXE program its original environment is restored, and it
     erases any changes to the environment made by the batch
     file.)

SUBROUTINE value passing


     BUILDERlite 2.0 allows values to be passed to and returned
     from Subroutines.  Let's look at an example that passes a
     string for FOO1 to display:

       ' FOO.BLD
       EXTERNAL SUB SAYHELLO
            CLS
            SayHello "Hello from foo1"
            Say "here we are back in foo"

       ' FOO1.BLD
            SUB SayHello string str1
                 Say str1
            end

     Compile FOO.BLD and FOO1.BLD from the commandline using the
     -c switch.

       BLDLITE -c FOO
       BLDLITE -c FOO1

     Link them.

       MLINK FOO+FOO1,,,BLDLITE.LIB

     Run FOO.EXE by typing FOO at the commandline.  Your screen
     should clear and then the following should be displayed:

       Hello from foo1
       here we are back in foo

     The example above demonstrated passing a value to a
     subroutine.  Let's return a value from a subroutine.  Using
     the FOO files from above make these changes:

       ' latest new improved FOO.BLD
       EXTERNAL SUB SAYHELLO
       Integer int1
       CLS
       int1 := SayHello "Hello from foo1"
       Say "here we are back in foo"
       Say "the returned value was ";int1

       ' latest new improved FOO1.BLD
       SUB SayHello string str1
       Say str1
       Return 45
       end

     Compile and link these files as you have before.  Running
     FOO.EXE should now clear your screen and display:

       Hello from foo1
       here we are back in foo
       the returned value was 45

     That does it for passing values to and from subroutines.
     This feature can benefit your applications dramatically, but
     requires you to adhere strictly to the syntax and formats
     that have been presented.



Linking with ASM


     Builderlite offers a great framework to link external
     assembly language modules into.  Builderlite gives the high
     level framework and logic that would otherwise require
     extensive assembly language programming.  There are only a
     few simple rules to follow use assembly language from
     Builderlite.

General rules when linking assembly language into Builderlite

            1. Builderlite .OBJs are LARGE model.  LARGE model
               means that all data and code addresses are 32-bit
               far addresses.  Compile your ASM modules into the
               LARGE model as well.
            2. Make sure that the registers ES,DS,SI,DI,BP,SP,SS
               are preserved when control is passed back to the
               BUILDERlite program from the Assembly routines.

Parameter passing

     Builderlite adheres to the C parameter passing convention
     for all externally linked modules.  This means that items
     are pushed on the stack in the reverse order of their
     listing.  For example if the function call CutTree 2,3 were
     issued, the 3 then the 2 would get pushed on to the stack.
     The particulars of each data type are as follows.

     Variable:
     Segment:Offset of variable is passed on the stack.

     Integer Constant:
     Value is passed on the stack.

     Longint Constant:
     The High then the Low word are pushed on the stack.

     String Constant:
     The Segment:Offset of the text string.

     The rules change if USE ENCRYPTION has been issued prior to
     the function call.   Strings are the only data types
     affected, but the differences are significant.  The address
     passed for strings under the USE ENCRYPTION condition is
     actually an address to a temporary variable.

Return Values

     Builderlite can handle direct return values of integers and
     longints only.  This is done by loading AX with the value in
     the case of a integer return value, or by loading DX with
     the High word and AX with the Low word in the case of the
     longint return value.

     String Variables can be accessed directly by their passed
     address.  To assign a string variable a new value via a
     function call, simply pass the string variable as a
     parameter and write the new value directly to the passed
     Segment:Offset position.  One special note about strings in
     Builder, they must be NULL terminated (ASCII value 0).

     Caution must be used when using USE ENCRYPTION with string
     variables.  A string variable segment:offset that is passed
     with USE ENCRYPTION on is only a temporary value, therefore
     the real variable cannot be directly accessed, only a copy
     of the string is available.

Example:

     The following example will call an Assembly Language module
     that does nothing more than return an integer value of 8.

     Builder Code:  BLDCODE.BLD

            Integer Int1
            External Sub Asm1
            Int1:=Asm1
            Say Int1

     Assembly language code: ASM1.ASM

       .MODEL LARGE
       .CODE
       PUBLIC ASM1
       ASM1 Proc
         mov ax,8     ;Mov 8 into ax and return
         ret
       ASM1 ENDP
         END

     Now compile each element:

       TASM ASM1.ASM
       BLDLITE -c BLDCODE

     Two files were created, BLDCODE.OBJ by BUILDERlite and
     ASM1.OBJ by TASM.  Because we are linking in external
     modules we have to invoke MLINK from the commandline.  We
     link these OBJs together with the following commandline:

       MLINK BLDCODE ASM1,,,BLDLITE.LIB

     A file called BLDCODE.EXE is created and when it is executed
     it displays the number 8 on the screen.  Link away!

Chapter 4.  Command Reference



How to use this chapter

     This chapter lists all BUILDERlite declarations, statements,
     functions, and variables in alphabetical order.

     NOTE:  Like interpreted batch, BUILDERlite keywords are case
     insensitive.

Importing batch files

     The first thing you should understand is that when the
     BUILDERlite IDE or compiler is asked to work on a .BAT file,
     the Import utility automatically modifies it and creates a
     separate .BLD file.  This happens without any prompting or
     participation by you.  The compiler then compiles the .BLD
     file.  Using the compiler requires that you understand the
     conversion process.  Remember that editing a .BLD file will
     require you to conform your coding style to BUILDERlite
     specs, not .BAT specs, or the compiler will encounter syntax
     errors and be unable to recompile the file.

     NOTE:  Please see the appendix about Import, for more
     detailed information on the import utility.

Commands defined

     Each command or system variable is discussed in detail using
     the subheadings Format, What it does, What it's for,
     Returns, See also, and Example.  Sometimes additional
     information unique to that item is also presented.  Here is
     what the subheadings mean:

     Format
     This is the command's syntax.  This listing shows you, using
     generic defines, the order of elements in a line of code
     using this command.  For specific use, refer to the examples
     shown under the Example subheading.

     The construction is specific, here's how to use it.  You
     type the item in exactly as shown unless the item is
     surrounded by angle brackets ( <> ) or square brackets ( []
     ).  The Reboot statement, for example, appears like this in
     the Format listing:

               Reboot

     Since there are no square or angle brackets involved, you
     just type the word Reboot in your script.

     Items in angle brackets are required components of that
     syntax.  The angle brackets themselves are not required.
     Replace the text inside of angle brackets with the
     instructed element.  For example, one of the Box entries
     looks like this:

       SingleBox<row>,<col>,<width>,<height><Foreground
       color>On<Background color>

     The text explains that <row> and <col> are the box's upper
     left coordinates, that <width> is the number of characters
     wide you want to make the box, <height> is its height in
     lines, and so forth.  An example of this format in real life
     would be:

       Single Box 10, 20, 30, 15 blue on white

     Note that the angle brackets aren't used in your script.
     (The only case in which angle brackets are used is with
     metacharacters in the Say statement; see the listing under
     Say for more details.)

     Items in square brackets are optional.  For example, the
     Exit command, which quits the script and returns to control
     to DOS, can be used by itself (in which case the script
     exits with a code of 0), or with an error code.  So the
     format for Exit looks like this:

       Exit [<error code>]

     The text explains that <error code> is a number from 0 to
     255 inclusive.  Working from the inside out, you replace
     <error code> with a number from 0 to 255.  Since the text
     <error code> is itself in square brackets, and square
     brackets mean an item is optional, the error code itself is
     optional.  So legal constructs could be any of the
     following:

       Exit
       Exit 200
       Exit 0 (same as Exit by itself)

     The example below is not legal, because two error codes are
     given and only one error code is allowed.

       Exit 4 5

     For future reference: IntVar, LongIntVar, StrVar, FileVar,
     represent variables in the command syntax.  While
     IntExp,LongIntExp, NumExp (Int or LongInt), StrExp, FileExp,
     represent expression in the command syntax.  The use of an
     Operand element refers to any variable or expression.

     Variables are assigned values used in your program, while
     Expressions could be an assigned value or a literal string.
     Expressions that are not allowed to be assigned variables
     will be represented in quotation marks.  Therefore "BUILDER"
     could not be an assigned value, but would only work with a
     literal string of characters.

     What it does
     This section describes what happens when the statement is
     executed and notes any necessary limitations or
     preconditions.  It does not, however, explain why you might
     wish to use the statement.

     What it's for
     This is the flip side of What it does:  it gives you a feel
     for real-life applications of the statement.

     Returns
     If the statement returns a logical value then they will be
     defined in the Returns section.  If there are no returns for
     a statement, then this section will not appear.

     See also
     This section points you to other references that may help
     you.  For example, Say and ECHO do some of the same things,
     so the entry for ECHO points to Say, and vice versa.

     Example
     This is a program listing showing a script using the
     statement in context.  An example is included with every
     statement.  Many more example files are located on our BBS
     for your download and use.

     Variables in the Example code are: Str1 is a String
     Variable, Int1 is an Integer Variable, LongInt1 is a LongInt
     Variable, File1 is a File Variable.  All variables have been
     previously declared.  (In BUILDERlite you must declare all
     variables at the top of the script.)  The Examples are
     pieces of code, in some cases sub-routines, but are not
     intended to be stand alone programs.





'

Format

       ' <any text>

What it does

     ' statements don't execute.  They're ignored when the script
     is compiled.

     The <any text> is any typed text.

     NOTE:  A ' statement cannot appear immediately above an Item
     portion of a DropDown, LightBar, or PopUp statement.

What it's for

     ' lets you add notes to yourself so that you'll know what
     happens in a script.  This can be used exactly like a REM
     statement.

See also

     REM

Example

       REM This isn't compiled.
       '   Neither is this, and it's easier to type!



+

Format

       <Operand1> + <Operand2>

What it does

     When <Operand1> + <Operand2> are integer or longint
     expressions, adds them.

     When <Operand1> + <Operand2> are string expressions,
     concatenates (that is, appends) <Operand2> to <Operand1>.
What it's for

     Performing addition functions.

See also

     -, *, /

Example

       ' Integer addition:  Displays 15
       Say 6 + 9

       ' String concatenation:  Displays 69
       Say "6" + "9"



-

Format

       <Operand1> - <Operand2>

What it does

     Subtracts <Operand2> from  <Operand1>.  Both must be numeric
     expressions.

What it's for

     Performing subtraction functions.

See also

     +, *, /

Example

       ' Integer subtraction:  Displays -3
       Say 6 - 9



*

Format

       <Operand1>  *  <Operand2>

What it does

     Multiplies <Operand1> by <Operand2>.

     <Operand1> and <Operand2> can be integers, longints, or
     direct numeric values.

What it's for

     Performing multiplication functions.

See also

     +, -, /
Example

       say "The value of 4 times 22 is: ";4*22

       say "Now give me a number to multiply: ";
       input Str1
       Int1 := StrToNum Str1
       say "Now give me a number to multiply it by: ";
       input Str2
       Int2 := StrToNum Str2
       say "The value of ";Int1;" times ";Int2;" is ";Int1*Int2



/

Format

       <Operand1> / <Operand2>

What it does

     Divides <Operand1> by <Operand2>.

     <Operand1> and <Operand2> can be integers, longints, or
     direct numeric values.

What it's for

     Performing division functions.

Note

     It is impossible to divide by zero.  Any attempt to do so
     will create a run time error and halt operation of your
     program.  Therefore, you should always check that the value
     of <Operand2> is not equal to zero prior to performing the
     division operation.

See also

     +, -, *

Example

       say "The value of 4 divided by 2 is: ";4/2

       say "Now give me a number to divide: ";
       input Str1
       Int1 := StrToNum Str1
       say "Now give me a number to divide into the first: ";
       input Str2
       Int2 := StrToNum Str2
       if Int2 == 0
         say "Hey, good try, but you can't divide by zero."
       end else
         say "The value of ";Int1;" divided by ";Int2;" is
       ";Int1/Int2
       end



:=

Format

       <variable> := <expression>
What it does

     Evaluates <expression> and copies the value into <variable>.
     <expression> and <variable> must be of the same type
     (Integer, Longint, or String).  Multiple assignments of the
     same <variable> will overwrite the previous contents.

     If <variable> is a string and <expression> evaluates to
     either Integer or Longint, a fatal error will occur during
     compilation:  strings and numeric values are not compatible.
     The reverse is also true:  you can't assign a string
     expression to a numeric variable.

What it's for

     Performing evaluation functions.

See also

     Integer, Longint, Put, String

Note

     The Put/into statement and the := operator do exactly the
     same thing:  assign the value of an expression to a
     variable.  Put/into is more English-like; := is used in
     programming languages.

Example

       Int1 := DiskReady "A"
       If Int1 is 1
         Say "Drive A is ready."
       end else
         Say "Drive A isn't ready."
       End



<

Format

       <Operand1> < <Operand2>

What it does

     When <Operand1> and <Operand2> are integer or longint
     expressions, if <Operand1> is less than <Operand2> the If
     statement evaluates to true, otherwise it is false.

     When <Operand1> and <Operand2> are string expressions, if
     <Operand1> is less than <Operand2> based on case-sensitive
     lexical ordering, the If statement evaluates to true,
     otherwise it is false.

What it's for

     Performing evaluation functions.

See also

     ==, >, <=, >=, <>
Example

       Say @5,5"Let's compare some numbers."
       Say @7,8"Enter a number between 1 and 100:           ";
       Input Str1
       Say @8,8"Enter another number between 1 and 100:     ";
       Input Str2
       Int1:=StrToNum Str1
       Int2:=StrToNum Str2
       If Int1 > Int2 Say @11,8"Your first entry was larger than
       your second."
       If Int1 < Int2 Say @11,8"Your second entry was larger than
       your first."
       If Int1 == Int2 Say @11,8"You entered the same number
       twice, is that fair?"



<=

Format

       <Operand1> <= <Operand2>

What it does

     When <Operand1> and <Operand2> are integer or longint
     expressions, if <Operand1> is less than or equal to
     <Operand2> the If statement evaluates to true, else it is
     false.

     When <Operand1> and <Operand2> are string expressions, if
     <Operand1> is less than or equal to <Operand2> based on
     case-sensitive lexical ordering, the If statement evaluates
     to true, else it is false.

What it's for

     Performing evaluation functions.

See also

     ==, >, <, >=, <>

Example

     See example for < operator.



<>

Format

       <Operand1> <> <Operand2>

What it does

     When <Operand1> and <Operand2> are integer or longint
     expressions, returns false if they are equivalent, or a true
     value if not.

     When <Operand1> and <Operand2> are string expressions,
     returns false if they are equivalent based on case-
     insensitive lexical sort order, or a true value if not.
What it's for

     Performing evaluation functions.

See also

     ==, <, <=, >, >=

Example

       ' Integer equivalence:  Prints "True"
       If 6 <> 9 say "True"

       ' String equivalence:  Prints "True"
       if "lowercase" <> "LowerCase"
         Say "True"
       end else
         Say "False"
       end



==

Format

       <Operand1> == <Operand2>

What it does

     When <Operand1> and <Operand2> are integer or longint
     expressions, returns a true value if they are equivalent, or
     false if not.

     When <Operand1> and <Operand2> are string expressions,
     returns a true value if they are equivalent based on case-
     insensitive lexical sort order, or false if not.

What it's for

     Performing evaluation functions.

See also

     <>, <, <=, >, >=

Example

     See example for < operator.



>

Format

       <Operand1> > <Operand2>

What it does

     When <Operand1> and <Operand2> are integer or longint
     expressions, if <Operand1> is greater than <Operand2>, the
     If statement evaluates to true, else it is false.

     When <Operand1> and <Operand2> are string expressions, if
     <Operand1> is greater than <Operand2> based on case-
     sensitive lexical ordering, the If statement evaluates to
     true, else it is false.
What it's for

     Performing evaluation functions.

See also

     ==, >=, <, <=, <>

Example

     See example for < operator.



>=

Format

       <Operand1> >= <Operand2>

What it does

     When <Operand1> and <Operand2> are integer or longint
     expressions, if <Operand1> is greater than or equal to
     <Operand1>, the If statement evaluates to true, else it is
     false.

     When <Operand1> and <Operand2> are string expressions, if
     <Operand1> is greater than or equal to <Operand2> based on
     case-sensitive lexical ordering, the If statement evaluates
     to true, else it is false.

What it's for

     Performing evaluation functions.

See also

     ==, >, <, <=, <>

Example

     See example for < operator.



Adaptor

Format

       <string variable> := Adaptor

What it does

     Evaluates adaptor type and places it in string variable.

What it's for

     Assuring the user has the right video adaptor.  You'll know
     how to adjust your use of metacharacters in SAY statements,
     box colors, and menu colors with ADAPTOR.

Returns

     Returns the type of the display adaptor as a string.  Values
     are:
            Return value Means

            "CGA"        Color Graphics Adaptor
            "EGA"        Enhanced Graphics Adaptor
            "MCGA"       Multi-Color Graphics Array
            "Mono"       Monochrome MDA or Hercules
            "VGA"        Video Graphics Array


See also

     Videomode

Example

       ' This sub-routine displays blinking text if it detects
       ' a monochrome monitor, or red text if it doesn't.
       Sub PrintError
          ' Determine the video type.
          Put Adaptor into Str1
          ' If not color-capable, use the blink attribute.
          if Str1 is "Mono"
               say @ 24, 1 "<blink>Error"
          end else
               say @ 24, 1 "<red>Error"
          end ' if
       end 'Sub



Beep

Format

       Beep

What it does

     Beeps.

What it's for

     Beeping.

Example

       Beep
       echo Are you sure you want to delete all files in drive C?
       GetYN



Box

Format

       Single Box <row>, <col>, <width>, <height> <LineColor> On
       <Boxcolor>

       Double Box <row>, <col>, <width>, <height> <LineColor> On
       <Boxcolor>

What it does

     Draws boxes of the specified size, placement, color and
     border thickness.  <row>, <col>, <width>, <height> are
     numeric constants.  <LineColor> is the color of the single
     or double lines.  It may be any of the standard colors and

     any of the bright colors.  <Boxcolor> may be any of the
     standard colors.  It is the color of the box interior.

What it's for

     The Box commands are great for putting up menus, or focusing
     attention on a particular part of the screen.

Possible colors

     These are the available standard colors.  They can be used
     for the foreground or line color:

     Standard colors
     Black, Blue, Brown, Cyan, Green, Magenta, Red, White

See also

     Appendix on colors.

Technical Notes

     The minimum value for width and height is 3.  (Anything less
     would not be a box!)  And a box that ends in the 80th column
     after the 25th row will cause the screen to scroll up by one
     row.

Example 1

       cls
       ' Make a 30x5 box @ row10, col25 in the center of an 80x25
       screen.
       Double Box 10, 25, 30, 5 bright red on black
       say @ 12, 28 "<blink>Sure you want to Reboot?";
       GetYN
       if errorlevel 1 reboot

Example 2

       cls
       ' Make a 70x15 box at row 5, column 5.
       Double box 5,5,70,15 bright white on black
       GetKey
       ' Put a 30 X 15 box at row 10, column 20.
       Single box 10, 20, 30, 15 blue on white



CALL

Format

       CALL <filename>

What it does

     CALL runs a batch file, then returns to the script.

What it's for

     CALL is provided for compatibility with the interpreted
     batch language.  An interpreted batch file loses control to
     another batch file; that is, if you run one batch file from
     within another without CALL, the second batch file does not
     return to the first one upon completion.  Versions 3.3 and
     later of MS-DOS supplied the CALL command to circumvent this
     behavior.  Note that a compiled script will run fine under
     versions of DOS earlier than 3.3, since BUILDERlite
     simulates the CALL command itself.

     The CALL command is obsolete because it's implied in
     BUILDERlite, even if you don't use one in the original .BAT
     file.  That is, if BUILDERlite doesn't recognize the first
     characters on a line, it drops the line through to DOS and
     assumes it's a program, then returns to the calling program.

Notes

     This points out an incompatibility between standard batch
     and BUILDERlite.  While there are rare cases in which you
     would want a batch file called by another batch file to
     seize program control and not return it to the caller, most
     users prefer what seems to be a more natural solution:
     Batch files, like other programs, return to their starting
     point.

See also

     Run, System

Example

       CALL ProgramName



Canceled

Format

       IF Canceled <statement>
       IF not Canceled <statement>

What it does

     Canceled is a built-in variable that returns 1 if the last
     keyboard input was canceled, and 0 if not.  At the start of
     any BUILDERlite script it is 0, meaning input has not been
     canceled.

What it's for

     This lets you tell the difference, in an INPUT statement,
     between empty input and the user pressing {Esc}.

Note

     The spelling "Cancelled" is also acceptable.  Upon calling
     the Canceled command, the canceled flag will be set until
     the next Input or GetKey call is made.

See also

     Input, GetKey

Example

       ' Notice that there is no explicit check for LastKey ==
       {Esc}.
       ' That's because the {Esc} key sets a BUILDERlite system
       global integer called
       ' CANCELED to 1 when user presses {Esc} during keyboard
       input.  All other
       ' values entered at the keyboard clear the CANCELED global
       to 0.
       While not canceled
         Say "Please type something and press {Enter}, or press
       {Esc} to quit. ";
         Input Str1
         Say    ' Prints a blank line.
         If Str1 is ""
           say "Nothing was entered."
         end else
           say "You entered: "; Str1
         end
       End ' While not canceled
       say "You pressed {Esc}".



Case

Format

       Select <expression> from
       [  [case <test item>:
               <statements>] ... ]
       End

What it does

     Tests each <test item> against <expression>.  Expressions
     may be numeric, either Integer or LongInt format, or
     strings.  If a <test item> evaluates to TRUE, then all
     statements up to but not including the next <test item> are
     executed, then control passes to the next line after the End
     keyword.

What it's for

     Performing several tests on a variable and running parts of
     the script accordingly.  Case eliminates awkward If chains.

Technical note

     Although the test item can be a variable, the Case cannot
     evaluate arithmetic operators.  Example- Case Str1 + Str2 is
     illegal, but Case Str1 is legal.  Remember the test item
     must be the same data type.

See also

     For, Repeat, While

Example

       'This test program will loop through the case statement
       five times
       'printing a different line each time.
       cls
       Int1 := 0
       :top
       if Int1>5 exit 0
        select Int1 from
         case 1:
           echo This is the first pass through
         case 2:
           echo This is the second pass through
         case 3:
           echo This is the third pass through
         case 4:
           echo This is the fourth pass through
         case 5:
           echo This is the fifth pass through
         end
       Int1 := Int1+1
       goto top



CharToNum

Format

       IntVar := CharToNum StrExp

What it does

     Returns the ASCII value of the first character of <string
     expression>.

What it's for

     Parsing strings character by character.

See also

     NumToChar, StrToNum

Example

       Int1 := CharToNum "A"
       ' Prints 65
       Say Int1



CLS

Format

       CLS

What it does

     Clears the screen and positions the cursor at the upper left
     corner of the screen (a.k.a the origin, whose coordinates
     are 1, 1).

What it's for

     Clearing the screen!

See also

     CLS On

Example

       ' Put up a message and await a keystroke.
       pause Now you see it...
       ' Erase everything on the screen.
       cls
       ' Go back to the upper left corner and print another
       message.
       pause And now you don't!



CLS On

Format

       CLS <foreground color> On <background color>

What it does

     Clears the screen to the specified color and sets the
     foreground color.  Both <foreground color> and <background
     color> may be color constants, such as WHITE or BLUE, or
     they may be integer expressions.

     Text color changes to the specified foreground and
     background attributes.  For example, if you issue a CLS
     Yellow on White, a Say "hello, world." statement will
     display the text in yellow letters on a white background.

What it's for

     Changing the screen color and allowing colors to be used in
     Say statements without zillions of metacharacters.

Permissible colors

     These are the available colors.  They can be used for either
     the text color or the background color:

     Standard colors
     Black, Blue, Brown, Cyan, Green, Magenta, Red, White

     The following colors can be used for text colors only:

     Bright colors
     Bright Blue, Yellow, Bright Cyan, Bright Magenta, Bright
     Red, Bright White

     Color/integer equivalents
     0    Black               8    Gray
     1    Blue           9    Bright Blue
     2    Green               10   Bright Green
     3    Cyan           11   Bright Cyan
     4    Red            12   Bright Red
     5    Magenta        13   Bright Magenta
     6    Brown               14   Yellow
     7    White               15   Bright White

See also

     CLS, Say, Text On.

Note

     See the Colors appendix for expanded discussions of text and
     background colors.

Example

       CLS Bright White On Blue
       ' This is the same thing, but using integers:
       CLS 15 On 1
       ' This prints in bright white on a blue background.
       say "hello, world."



CPU

Format

       IntVar := CPU

What it does

     Places the CPU type into an integer variable for evaluation.

What it's for

     Use in installation programs and system diagnostic routines.
     Some people don't know what CPU type is on their systems,
     and that information may be important.  This command gives
     you access to that info, and allows you to act on it.

Returns

     Returns one of the following values depending on CPU type:


            CPU Type     Value Returned

            8086/8088    86
            80186        186
            80286        286
            80386        386
            80486        486


See also

     Adaptor, VideoMode

Example

       Int1 := CPU
       Say "Your CPU is: "; Int1



CurrentDir

Format

       StrVar :=  CurrentDir

What it does

     Copies the current directory name into StrVar.

What it's for

     Useful for saving the directory a BUILDERlite script started
     from so that it can return to it at completion, leaving the
     user's environment just as it was on startup.

See also

     CurrentDrive

Example

       'This subroutine tests the CurrentDir function and changes
       directories.
       Str1 := CurrentDir
       Say "The current Directory is ";Str1
       Run D:
       Str2 := CurrentDir
       Say "Now the current directory is ";Str2
       Run C:
       Say "We're back where we started, at ";Str1



CurrentDrive

Format

       StrVar :=  CurrentDrive

What it does

     Assigns the current drive to a string variable.

What it's for

     Ideal in a BUILDERlite script that moves from drive to
     drive.  This allows you to store the current drive as a
     marker, and to get back to it after moving around your
     system.

See also

     CurrentDir

Example 1

       Str1 := CurrentDrive
       say "Current drive is "; Str1

Example 2

       Str1 := CurrentDrive
       ' Ask if user wants to install from this one.
       Say "Install from drive "; Str1; "?";
       GetYN
       If DOSErrorLevel is 0
         Say " Install from which drive? ";
         Input Str1
         Put DiskReady Str1 into Int1
           If not Int1
             say "Can't make drive "; Str1; " the current drive."
           end else
             Say "Ready to install from drive "; Str1
           End
       End



DirExists

Format

       IntVar := DirExists StrExp
What it does

     Evaluates the existence of directory StrExp, and places
     return value in IntVar.

What it's for

     DirExists allows you to check for the existence of a
     directory.  Handy for installation scripts to avoid screen
     writes that would confuse the user.  If you try to create a
     directory that already exists, DOS will display the message
     "Unable to create directory."  That message is displayed to
     the standard error device, and not the standard output
     device, so it can't be redirected.

Returns

     Returns a nonzero value if the directory specified in StrExp
     exists, and 0 if it does not.

See also

     BLDMkDir, BLDChDir

Example

       say "Directory to search for: ";
       input Str1
       Int1 := DirExists Str1
       if Int1 is 0
          say "Can't find the directory "; Str1; "."
       end else
          say "The directory "; Str1; " exists."
       end



DiskFree

Format

       LongIntVar := DiskFree StrExp

     StrExp, representing a particular drive, may contain a drive
     letter ("C"), or the drive letter followed by a colon
     ("C:").

What it does

     DiskFree returns the amount of unused space, in bytes, on
     the specified drive.  You must designate the StrVar to
     check; there is no default drive designated.

What it's for

     Useful in installation scripts to assure that there is
     enough disk space available for all required files.

See also

     DiskSize, DiskLabel, CurrentDrive, CurrentDir

Example

     This example verifies that there is enough disk space
     available for the software to be installed.
       Say "Install to which drive? ";
       Input Str1
       If Str1 is ""
           Say "Sorry, dude.  You need to enter a drive letter."
           exit 1
       End ' If Str1
       Int1 := DiskReady Str1
       If Int1 is 1
         Put DiskFree Str1 into LongInt1
         If LongInt1 < 1000K
           Say "Need at least 1 megabyte of disk space to
       install."
           Exit 1
         end else
           Say "Plenty of disk space to install."
         End
       end else
         Say "Drive "; Str1; " isn't ready."
       End



DiskLabel

Format

       StrVar := DiskLabel StrExp

     StrExp, representing a particular drive, may contain a drive
     letter ("C"), or the drive letter followed by a colon
     ("C:").

What it does

     Evaluates the disk label of a disk in a specified drive.

What it's for

     Useful for verifying the label of a resident disk(ette).

     Note that the string comparison in identifying a disk is
     case-sensitive.  That is, if the label of a disk is "DISK 1"
     and you compare it to the value "Disk 1", the comparison
     will fail.  As a rule, force any value you compare to a disk
     label to uppercase.

Returns

     Returns the volume label of the specified drive in a string
     variable.  If the drive is a floppy disk drive the volume of
     the diskette in the drive will be captured.

See also

     CurrentDrive

Example

       '  This example file will demonstrate the use of DiskReady
       and DiskLabel

       Int1 := DiskReady "A:"
       If Int1 == 1
         Say@5,5"A: Drive is ready for installation."
         Str1 := DiskLabel "A:"
         Str1 := UpperCase Str1
         If Str1 == "DISK 1"
           Say@8,5"Now copying contents of DISK 1 to target
       directory."
         end else
           Say@8,5"You don't have DISK 1 in Drive A:"
         end
       end else
         Say@5,5"You must prepare DISK A: for use before
       installation."
       end



DiskReady

Format

       IntVar := DiskReady StrExp

     StrExp, representing a particular drive, may contain a drive
     letter ("C"), or the drive letter followed by a colon
     ("C:").

What it does

     Evaluates the readiness of a disk drive.

What it's for

     Ensuring that it's safe to change the current drive, or that
     the drive door is closed.  A good way to avoid being
     interrupted by one of our favorite DOS messages:

       Not ready error reading drive x
       Abort, Retry, Fail?

Technical note

     If you do a DiskReady on Drive B: of a single floppy drive
     system you will get the DOS error message:

       Place disk in Drive B: and press any key

     This will happen because DOS allows you to call the floppy
     drive of a single floppy drive system Drive A: or Drive B:,
     and switches you between them itself.

Returns

     Returns the value 1 if the drive named in <Drive> is ready,
     0 if not.

See also

     DiskFree, DiskLabel, DiskSize

Example

     See the example for DiskLabel



DiskSize

Format

       LongIntVar := DiskSize StrExp
     StrExp, representing a particular drive, may contain a drive
     letter ("C"), or the drive letter followed by a colon
     ("C:").

What it does

     Evaluates the size of the disk designated in StrExp.

What it's for

     Useful in determining the gross size of a disk.  Note that
     DiskFree will evaluate the amount of free space on a
     designated disk.

Returns

     Returns the total size of the disk specified in StrExp and
     copies the value into LongIntVar.  Total size means the sum
     of the used and unused parts of the disk.

See also

     DiskFree

Example

       LongInt1 := DiskSize "C"
       Say "Total capacity of drive C: "; LongInt1; " bytes."



DOSErrorLevel

Format

       IntVar := DOSErrorLevel

What it does

     Mirrors the value of ERRORLEVEL so that it can be used in
     true expressions.  Provides more flexibility to the DOS
     ErrorLevel by allowing you to assign ErrorLevel to an
     integer variable.

What it's for

     Using the value of the system ERRORLEVEL in expressions.

     This is legal:

       Integer Flag
       Flag := DOSErrorLevel

     But this is illegal:

       Integer Flag
       Flag := ErrorLevel

Technical note

     DOSErrorLevel is used as a read only variable, you cannot
     assign a value to it.

See also

     Exit, If
Example

       run chkdsk
       Int1 := DOSErrorLevel
       say "Error level is: "; Int1



DOSInstalled

Format

       LongIntVar := DOSInstalled

What it does

     Writes the amount of installed memory directly available to
     DOS into LongIntVar.  This evaluation does not include EMS,
     or XMS memory.

What it's for

     Sometimes an installation script will find that the amount
     of installed memory is too low for the application being
     installed to operate properly.  This statement allows the
     programmer to evaluate this and notify the user.

See also

     DOSRAM, EMSInstalled

Example

       LongInt1 := DOSRAM
       say "     DOS RAM available:  "; LongInt1; " bytes."

       ' Get total DOS memory.
       LongInt1 := DOSInstalled
       say "     DOS RAM installed:  "; LongInt1; " bytes."

       ' Check for EMS memory
       Int1 := EMSInstalled
       if not Int1
         say "     No EMS memory installed."
       end else
         say "     EMS RAM available:  "; EMSAvail
         say "     Total EMS memory installed:  "; EMSTotal
       end



DOSRAM

Format

       LongIntVar := DOSRAM

What it does

     Writes the amount of memory directly available to DOS to
     LongIntVar.  This does not include EMS, or XMS memory.

What it's for

     A means of determining free memory without user input, or
     resorting to methods such as running CHDKSK.
See also

     DOSInstalled, EMSAvail

Example

       LongInt1 := DOSRAM
       If LongInt1 <= 500000 Say@10,5"I guess this didn't matter,
       you have less than 500K of RAM."
       If LongInt1 >  500000 Say@10,5"You've got over 500K of
       RAM!"



DropDown

Format

       DropDown StrExp1 [@ <Row>, <Col>]
          Item StrExp2, [{KeyStrokeConstant}]

               <statement>
          Item StrExp3
               <statement>
          Item StrExp4
               <statement>
       End

What it does

     Creates a dropdown menu called StrExp1, at the optional
     location given after the @ sign.  Each ITEM is followed by
     StrExp2, 3, and 4, which will be used as the selectable
     items for the menu.  If that item is selected all <program
     statements> until the next ITEM (or END, if it's the last
     ITEM) are executed.

     The optional {KeystrokeConstant} shown above allows for
     assignment of a hotkey to activate that menu item.

     An ITEM that evaluates to a null string (that is, "") will
     not appear on the menu, nor will its hotkey activate
     anything.

     The optional [@ <Row>, <Col>] positions the menu at the row
     and column specified.  If omitted the menu appears at
     position (1, 1), the top of the screen.

     NOTE:  You cannot place a comment line (one starting with
     REM or ') immediately above an ITEM line.

To select items

     To select a menu item, move the highlight to it and press
     {Enter}.  To move the highlight use any of these methods:

     1. Arrow keys
     2. {Tab} to go to the next item, {Shift-Tab} to the previous
     item.
     3. {Home} to go to the first item, {End} to go to the last
     item.
     4. If a Microsoft-compatible mouse is installed, click any
     item to activate it.
     5. Press {Esc} to quit the menu without selecting any items.
     The system variable Canceled is set.
     Pressing the first letter (hot key) of an ITEM may also
     select it, depending on the set up of the menu.  If there is
     more than one ITEM with the same first letter, the menu will
     cycle through those choices as long as you press the trigger
     letter.  The {&}, in conjunction with the appropriate Menu
     Style setting, may be used to alter the hot key in any menu
     item.

Limits

     There may be up to 40 ITEMs in a menu.  You can nest menus
     only in a LightBar statement by using the NestedItem
     command.

What it's for

     A fast and easy way to create Macintosh style menus that act
     like CASE statements.

See also

     Canceled, LightBar, Menu Style, PopUp

Example

       Str1 := Adaptor
       if s is "MONO"
         ' Force 80 x 25 mono.
         run mode mono
         Put 0 into IsColor
         Menu Style White,Black,BrightWhite,
       Black,Black,White,White,Black,0,1,2,1
       end else
         ' Force 80 x 25 color
         run mode co80
         Put 1 into IsColor
         Menu Style Blue,White,Red,White, White,
       Black,Black,White,0,1,1,1
       end
       Cls black on cyan
       While not cancelled
         Main
       End
       sub Main
         Dropdown "  Ray;'s Menu  " @ 7,30
           Item "Item 1"
             Say @ 7 + 6, 30 "Item 1 chosen"
           Item "Item 2"
             Say @ 7 + 6, 30 "Item 2 chosen"
           Item "Quit"
             Say @ 7 + 6, 30 "Item Quit chosen"
             exit 0
         end
       end



ECHO

Format

       ECHO <Any text>

What it does

     Displays text, including DOS variables such as %1 or %path%,
     to the standard output device (usually the screen).
What it's for

     ECHO is implemented for compatibility with the interpreted
     batch language.  Use Say instead:  it offers a great deal
     more flexibility.

     ECHO is a little easier than Say if you want to use double
     quotes, since you don't have to precede them with a tilde
     (~).

Technical notes

     ECHO ON and ECHO OFF are accepted as valid statements by
     BUILDERlite, but they're ignored.  Note that BUILDERlite
     files cannot echo lines before they execute, the way batch
     files do when ECHO is left on, and that a file therefore
     begins with the equivalent of @ECHO OFF when execution
     starts.

     If a period appears by itself as the DOS text, it's replaced
     by a blank line (to remain compatible with some versions of
     DOS).

See also

     Say

Example

       ' Display a simple message
       echo Ban the title "Code Blaster!".

       ' Display a message and the current path:
       echo The path is %path%

       ' Display two first command line parameters and the path:
       echo %1%2%path%



EMSAvail

Format

       LongIntVar := EMSAvail

What it does

     Evaluates the available amount of EMS memory.

Note

     You should use EMSInstalled first and avoid EMSAvail if EMS
     isn't installed.  Otherwise, you can't tell the difference
     between a system with EMS installed with 0K free, or a
     system with no EMS at all.

What it's for

     Making an intelligent choice in an installation script or
     menu program:  you can issue a preemptive error if a script
     won't be able to get enough EMS when it runs.

Returns

     Returns the amount of unused EMS memory, or 0 if none is
     installed.
See also

     EMSInstalled, EMSMajor, EMSMinor, EMSTotal, EMSVersion

Example

       Int1 := EMSInstalled
       if not Int1 exit 1
       LongInt2 := EMSAvail
       if LongInt2 < 256K pause Be careful--EMS is low.
       say "EMS left: "; LongInt2



EMSInstalled

Format

       IntVar := EMSInstalled

What it does

     Determine whether or not any EMS memory has been installed.

What it's for

     Before checking the amount of EMS memory using EMSAvail or
     EMSTotal, you need to ensure that the system has EMS at all.

Returns

     Returns 1 if there's any EMS memory installed, or 0 if not.

See also

     EMSAvail, EMSMajor, EMSMinor, EMSTotal, EMSVersion

Example

       Int1 := EMSInstalled
       IF Not Int1 NOEMS
       Int2 := EMSMajor
       Int3 := EMSMinor
       say "EMS version is: "; Int2; Int3
       Sub NOEMS
         Say "NO EMS is installed"
         'Exit with an errorlevel of 1
         Exit 1
       end



EMSMajor

Format

       IntVar := EMSMajor

What it does

     Evaluate the Major version number of the EMS driver that is
     installed.

What it's for

     Determining what EMS version is installed.  Most EMS systems
     are either version 3.2 or version 4; many applications
     support EMS version 4 but don't support 3.2.
Returns

     Returns the major version number of the EMS driver if EMS is
     installed, or 0 if not.

See also

     EMSAvail, EMSInstalled, EMSMinor, EMSTotal, EMSVersion

Example

       Int1 := EMSInstalled
       IF Not Int1 exit 1
       Int2 := EMSMajor
       IF Int2 < 4 say "May not support all EMS functions."



EMSMinor

Format

       IntVar := EMSMinor

What it does

     Evaluate the Minor version number of the EMS driver that is
     installed.

What it's for

     Since BUILDERlite does not support floating point numbers,
     the EMS version has to be broken up into two pieces: the
     major and minor versions.

     Determining the installed EMS version.  Most EMS is either
     version 4 or version 3.2; many applications support EMS
     version 4 but don't support 3.2.

Returns

     Returns the minor version number of the EMS driver if EMS is
     installed, or 0 if not.

See also

     EMSAvail, EMSInstalled, EMSMajor, EMSTotal, EMSVersion

Example

       Int1 := EMSInstalled
       IF Not Int1 exit 1
       Int2 := EMSMajor
       Int3 := EMSMinor
       ' Display version.
       say "EMS version is: "; Int2; Int3



EMSTotal

Format

       LongIntVar := EMSTotal
What it does

     Determines and allows for the reporting of the total EMS
     memory that is installed.

What it's for

     Checking the amount of total EMS memory that the system has
     installed.  Can be used in conjunction with other EMS
     Statements in order to determine the availablility of EMS
     memory, etc.

Returns

     Returns the total installed EMS memory.  This includes both
     allocated and free EMS.

See also

     EMSAvail, EMSInstalled, EMSMinor, EMSMajor, EMSVersion

Example

       LongInt1 := EMSTotal
       ' Quit if less than 256K installed.
       IF LongInt1 < 256K exit 1

       End



EMSVersion

Format

       StrVar := EMSVersion

What it does

     Evaluates and returns the EMS driver version number that is
     installed.

What it's for

     Determining the EMS version for program execution.

Returns

     Returns the version number of the EMS version, if installed.
     If it is not installed, the string "(EMS not installed)" is
     put into Str1.

See also

     EMSAvail, EMSInstalled, EMSMinor, EMSMajor, EMSTotal

Example

       Str1 := EMSVersion
       say "EMS version "; Str1; " is installed."



ENVTotal

Format

       IntVar := EnvTotal
What it does

     Determines the total environment space that has been
     allocated to Command.COM at boot up.

What it's for

     The DOS environment size on many machines is simply too
     small.   Use this function to warn the user to use the /e
     option in the SHELL= line of a CONFIG.SYS (which increases
     the environment allocated to COMMAND.COM on bootup).

     By default, DOS 3.3 allocates 160 bytes for the environment.

Returns

     Returns the total size of the environment.

See also

     EnvAvail

Example

       Int1 := EnvTotal
       IF Int1 is 160
         say "You're using the default environment."
         say "You should add a SHELL= line in CONFIG.SYS"
         say "and use the /e option to increase it."
       end else
         say "You have a total environment space of ";Int1;"
       bytes"
       end



Exit

Format

       Exit [<error code>]

What it does

     Quits the script and exits to DOS.  If the optional error
     code is omitted, it sets ERRORLEVEL to 0.  If the error code
     (a number from 0-255 inclusive) is included, ERRORLEVEL is
     set to that value.

What it's for

     It is often more convenient to leave a script immediately
     than to GOTO a label at the bottom of the script.  It's also
     handy to leave a script from within a sub-routine because
     you can't GOTO a label outside of the sub.

     An exit code of 0 (inserted automatically if you use Exit by
     itself) usually means the script quits without errors.
     Anything above zero usually means an error took place while
     the script was running; batch files can then act on that
     information to re-route the script's control flow.

See also

     DOSErrorlevel, IF, While
Example

       cls
       Double Box 10, 25, 30, 5 bright red on black
       say @ 12, 28 "<blink>Sure you want to quit? ";
       GetYN
       ' If the response was Y for Yes, exit to DOS.
       if errorlevel 1 exit 1
       ' The response was no, so...
       say "Thanks for not quitting.  You're a real trooper."



External

Format

       External <Variable Type> Operand

     Since this is the declaration of a variable, Variable Type
     could be any of the BUILDERlite allowable variables.  The
     Operand following the Variable Type must be compatible with
     the Variable Type being declared.

What it does

     Allows the use of sub-routines and variables from other .OBJ
     files.  The second element in the format declares literally
     if the External being designated is a String, Integer,
     LongInt, File, or Sub.  The Operand at the end of the
     statement is the name of the external variable being called.

What it's for

     The call to External is used to access Strings, Subs,
     Integers, etc. that reside or are defined in other .OBJs of
     the compiled program.

Technical notes

     Because it is a variable type, Externals must be declared at
     the top of your BUILDERlite script, just as you would
     declare any other variable there.  Multiple Externals of the
     same type can be declared on the same line by using commas
     to seperate the Operands.  Note that sub-routine Externals
     must be declared individually, one per line.

See also

     File, Integer, LongInt, String

Example

       'These are the contents of EXT1.BLD
       External Sub Greeting
       Greeting
       Exit 0

       'These are the contents of EXT2.BLD
       Sub Greeting
          Say "Hey, you called me from another .OBJ!"
       End

       ' This is the command line used to link
       Mlink EXT1+EXT2,,,BLDLITE.LIB


FileChangedDateToLong

Format

       LongIntVar := FileChangedDateToLong StrExp

What it does

     Places the date that file StrExp was last altered in to
     LongIntVar converting it to a long integer.

What it's for

     Obtaining the last update date of a file.  Very useful for
     version control, ensuring that newer files are not
     overwritten with older files, etc.

See also

     FileChangedTimeToLong, SysDateToLong, LongToDateStr

Example

       LongInt1 := FileChangedDatetoLong "c:\autoexec.bat"
       Str1 := LongtoDateStr LongInt1
       LongInt2 := SysDateToLong
       Str2 := LongToDateStr LongInt2

       Say@10,10"Your autoexec was last changed on ";Str1
       Say@12,10"Your system date is ";Str2
       say
       If LongInt1 <> LongInt2 say@15,10"Your autoexec wasn't
       changed today."
       If LongInt1 == LongInt2 say@15,10"Your autoexec was
       changed today."



FileChangedTimeToLong

Format

       LongIntVar := FileChangedTimeToLong StrExp

What it does

     Returns the time that file StrExp was last altered,
     converting the time to a long integer.

What it's for

     Obtaining the last update time of a file.  Very useful for
     version control, ensuring that newer files are not
     overwritten with older files, etc.

See also

     FileChangedDateToLong, SysTimeToLong, LongToTimeStr

Example

       LongInt1 := FileChangedTimetoLong "c:\autoexec.bat"
       Str1 := LongtoTimeStr LongInt1
       LongInt2 := SysTimeToLong
       Str2 := LongToTimeStr LongInt2

       Say@10,10"Your autoexec was last changed at ";Str1
       Say@12,10"Your system time is ";Str2
       say
       If LongInt1 <> LongInt2 say@15,10"Your autoexec wasn't
       changed just then."
       If LongInt1 == LongInt2 say@15,10"Your autoexec was
       changed just then."



FileSize

Format

       LongIntVar := FileSize StrExp

What it does

     Places the size in bytes of file StrExp in LongIntVar.  This
     command works on a single file or in conjunction with
     wildcard specifications, for use with many files at once.
     If StrExp does not include a drive and subdirectory
     designation, the current drive / directory is assumed.

What it's for

     This can be helpful, when used in conjunction with the
     DiskFree command, in determining if a particular file is too
     large to fit on a particular volume.

     Also useful for creating a utility-type script to show the
     user the size of some critical files.

See also

     LongInt, DiskFree

Example

       LongInt1 := FileSize "Manual.DOC"
       say "Manual.DOC is "; LongInt1; " total bytes."



FOR

Format

       FOR %%<character> IN "<set>" DO <command>

     Note:  BUILDERlite uses the double quote character instead
     of DOS's parenthesis character to delimit the file set.

What it does

     The <character> variable is assigned to each file matching
     the list given in <set>, and <command> is performed for each
     file.  If the <character> variable appears in <command>, it
     <command> is performed on the file <character> replaces.
     <character> can't be a digit from 0-9.  Wildcards are
     allowed in <set>.

     Like DOS, BUILDERlite doesn't allow you to nest FORs.
What it's for

     Running a BUILDERlite program statement or DOS command on
     each of several files.

Technical Note

     The FOR statement in interpreted batch uses parentheses to
     delimit the files listed in <set>, whereas BUILDERlite uses
     quotation marks.  And if <command> is not an interpreted
     batch command, such as GOTO, a Run is inserted before it.

     If the input file ends in .BAT, however, Import creates a
     new file ending in .BLD with the conversion performed
     automatically.  The conversion process replaces the
     enclosing parentheses with quotes, and replaces quotes that
     would appeared within the parentheses with the caret
     character(^).  Following are pairs of FOR statements shown
     before and after importing:

       ' Before importing:
       for %%f in (*.c) do  tcc %%f
       ' After importing
       for %%f in "*.c" do run tcc %%f

       ' Before importing:
       for %%c in (Beat me with a stick) do goto Check
       ' After importing
       for %%c in "Beat me with a stick" do goto Check

     See appendix on Import, for a summary.

See also

     Case, Repeat, While

Example

       ' EZDEL.BLD
       '
       ' EZDel lets you delete files selectively, yet still using
       wildcards.
       '
       ' To use it, enter this at the DOS command line:
       '
       '    ezdel <filespec>
       '
       ' Where <filespec> is a filename or wildcard
       specification.
       '
       ' Examples:
       '
       '    ezdel *.bak
       '    ezdel *.obj foo.bak tmp.1 *.err
       '
       ' For each file matching the specification, you'll be
       asked if it should
       ' be deleted.  If you want to delete it, just press "Y".
       Otherwise,
       ' press "N".
       for %%c in "%1 %2 %3 %4 %5 %6 %7 %8 %9" do EZDEL
       sub EZDel
         ' Print a blank line.
         say
         ' Ask if the next file in the FOR list should be
       deleted.
         say "Delete %%c? ";
         ' Await a {Y} or {N} keystroke.  Accept no others.  Set
       ERRORLEVEL
         ' to 1 if {Y} is pressed, or 0 if {N} is pressed.
         GetYN
         if ErrorLevel 1 run del %%c
       end



For (Loop Structure)

Format

       For IntVar = IntExp1 to IntExp2
          <statement>
       end

What it does

     Allows for BASIC style loops.  Gives variable use and
     greater flexibility than the Repeat command.

What it's for

     Repeating the execution of a group of statements with
     variable assignment, and greater flexibility.

See also

     FOR, Repeat, While

Example

       ' Watch how Int1 changes value from 1 - 10 during the For
       loop execution
       For Int1 = 1 to 10
          say Int1
       end



GetKey

Format

       GetKey

What it does

     Awaits a keystroke.  When the key is pressed, its value does
     not appear on the screen.  Its value is copied into LastKey,
     allowing you to test with If.

     If {Esc} is pressed, the system variable Canceled is set to
     1.  Otherwise, Canceled is cleared to 0.

Technical note

     Unlike other programming languages, BUILDERlite treats keys
     with extended codes such as {F1} and {Ctrl-PgDn} as a single
     keystroke.  This is much simpler than with other languages,
     which require checking for a return code of 0, then an
     extended code.
What it's for

     GetKey's most useful application is in the creation of menus
     when not using Menu Style or one of BUILDERlite's built-in
     menu types.  Because it doesn't echo the keystroke when the
     key is pressed, the screen remains clean.

     When you test for the previous keystroke using LastKey, IF
     LastKey == is satisfied only with an exact match, it is case
     sensitive.

Notes

     When you test for a value, it is recommended to use
     keystroke constants such as {F1} or {Q} instead of ASCII
     values.  For a complete list of keystroke constants, see
     "Keystroke Constants".  Keystroke constants make your script
     easier to read.

See also

     GetYN, IF, LastKey, appendix on Keystroke Constants.

Example

       Cls
       Say@11,20"Press any key to invoke the system menu."
       getkey
       Int1 := LastKey
       Str1 := NumToChar Int1
       Say@12,20"You pressed the ";Str1;" key to invoke the
       menu."
       Wait 90

       While not Canceled
         Cls
         Double box 8,10,60,12 bright green on black
         Text Bright blue on black
         Say@9,12"                 (This is a simple menu)"
         Say@11,12"          Select an Item using its first
       letter"
         Text yellow on black
         Say@14,12"                     FrameWork III"
         Say@15,12"                       Lotus 123"
         Say@16,12"                        Pac Man"
         Say@17,12"                      Exit to DOS"
         GetKey
         If Lastkey is {F} Run FW
         If LastKey is {f} Run FW
         If Lastkey is {L} Run 123
         If LastKey is {l} Run 123
         If Lastkey is {P} Run PacMan
         If LastKey is {p} Run PacMan
         If Lastkey is {E} Exit
         If LastKey is {e} Exit
       End



GetYN

Format

       GetYN
What it does

     Awaits a keystroke.  Only two keys are accepted:  Y or N.
     The letter is displayed if either value is typed; otherwise,
     nothing happens and GetYN continues to wait for one of those
     two keys.  If Y is pressed, ERRORLEVEL is set to 1.  If N is
     pressed, it's set to 0.

Technical note

     Because of the comparison of errorlevel codes, it is more
     consistently safe to check for an errorlevel of 1, rather
     than that of 0.

What it's for

     GetYN is useful when you require a Yes or No response.  You
     could simulate it using GetKey, but GetYN is easier to use.
     It also displays the letter pressed (unlike GetKey), so the
     user can verify that the right key was pressed.

See also

     GetKey, IF

Example

     The following sub-routine contains an example script using
     GetYN, among other things.

       Sub CheckPrinter
         ' Assume printer isn't ready.
         Int1 := 0
       :CheckIt
         Say "Is LPT1 loaded with paper? ";
           GetYN
           Say       ' Go to the next line.
         ' If user pressed {N} it wasn't ready, so wait.
         If ErrorLevel 0 pause Press a key when it's loaded.
         ' Check LPT1 to see if it's usable.
         Int1 := PrinterReady 1
         ' If Int1 is 0, the printer isn't ready.
         If Int1 is 0
           ' See if user wants to keep trying.
           Say "Printer isn't ready yet.  Try again? ";
           GetYN
           ' If {Y}es, go back and try again.
           If ErrorLevel 1 goto CheckIt
           ' Otherwise, exit.
         End
       End ' Sub



GOTO

Format

       GOTO <label>

     Note:  <label> is one or more letters, numbers, and
     underscore (_) characters.  It must start with a letter.
     You can have spaces and tabs after the GOTO and before the
     label, but the label itself may not contain spaces or tabs.

     The label may not be a command line parameter (%0-%9) or an
     environment variable (for example, %label%)
What it does

     Reroutes the execution of the program.

     GOTOs are permitted within sub-routines, but a GOTO inside a
     sub-routine should never direct program flow to a target
     label outside the sub.

What it's for

     GOTO is critical for any script that makes decisions.  It's
     used in conjunction with IF to perform different functions
     according to program input.

Example

     The GetYN command accepts only Y or N as input.  This script
     fragment simulates GetYN but also allows {ESC} for the No
     response.  If an unacceptable key is pressed, the bell
     sounds and the script uses GOTO to return to the point at
     which it checks for a keystroke.

       :GetYNEsc
       GetKey

       IF LastKey is {Esc} goto NoAnswer

       IF LastKey is {n} goto NoAnswer
       IF LastKey is {N} goto NoAnswer
       IF LastKey is {y} goto YesAnswer
       IF LastKey is {Y} goto YesAnswer

       ' If it's not any of the other keystrokes, keep checking.
       GOTO GetYNEsc

       :NoAnswer
       say "Well, then do you have a sister?"
       :YesAnswer
       say "You _do_ want to get married? Great!"



GoToXY

Format

       GoToXY <column>, <row>

What it does

     Sets the location of the cursor on the screen.  The origin
     of the cursor column 1, row 1 (the upper left corner).  The
     column represents horizontal positioning and the row
     represents vertical positioning.

What it's for

     Full screen control.  GoToXY operates identically to RowCol,
     but the row coordinate comes first in RowCol.  Note that Say
     @ <row>, <col> does the same thing more effectively, since
     you normally want to display text.

Technical note

     The GoToXY statement is not supported if the Use DOS
     statement has been called.
See also

     RowCol, Say

Example

       CLS
       Say "This program runs until you press {N}.  Notice how
       GetYN is used, "
       Say "but the prompt normally left is erased.  That's
       because GoToXY"
       Say "is used to position the cursor over the last space in
       the message."
       Say
       :Top
       ' Ask a question, leaving the cursor at row 12, column 59.
       say @ 12, 30 "Would you like to continue?  "
       ' Reposition the cursor at row 12, column 58--over the
       last space in the
       ' prompt.
       GoToXY 58, 12
       GetYN
       ' If {Y} is pressed, GetYN will leave it onscreen but it
       will immediately
       ' be covered over by the final space.
       if Errorlevel 1 goto Top



IF

Format

            If <qualifier> <statement>

     or

            If <qualifier>
               <statement1>
               [...<statement n>]
            end [else
               <statement1>
               [...<statement n>]
            end]

Qualifiers Defined

     The possible <qualifier> input recognized in this command
     are listed below.  Syntax errors will occur if these formats
     are not followed.

       [Not] Errorlevel <integer expression>

       [Not] Exist <string expression>

       [Not] Lastkey <relational operator> <{keystroke
       constant}>|<integer expression>

       [Not] <expression> <relational operator> <expression>

What it does

     Determines whether a command will be executed, based on
     these tests:

     IF ERRORLEVEL checks the DOS internal error code after a
     program has been run, and executes statements if the
     errorlevel is <integer expression> or greater.

     IF EXIST executes statements if <string expression> is a
     file on disk.

     IF LastKey executes statements if the value of the global
     variable LastKey (set by a prior GetKey) matches the
     keystroke constant or integer in <keystroke
     constant>|<integer expression>.  Note that, unlike
     ERRORLEVEL, the condition is satisfied only on an exact
     match, not equivalence or greater.

     A NOT reverses the condition satisfying the rule.  IF EXIST
     "BOYHOWDY.TXT" is true if there is a file named
     "BOYHOWDY.TXT" in the current directory.  IF NOT EXIST
     "BOYHOWDY.TXT" becomes true if the file BOYHOWDY.TXT is not
     in the current directory.

NOT notes

     There's a trick to the use of NOT when comparing two items:
     always use parentheses.  That's because without them the NOT
     is applied to a string as a unary operator, which is totally
     meaningless:

       ' Wrong:
       If NOT "%1" is "/C" say "Okay"

     The obvious choice, but not the best one, is to add
     parentheses to defeat the order of precedence:

       ' Better:
       If NOT ("%1" is "/C") say "Okay"

     The best solution is to use the not equals operator:

       ' Best:
       If "%1" <> "/C" say "Okay"

What it's for

     Changing the behavior of a script based on a decision made
     at runtime.

Example

       '  This example demonstrates the If command in its many
       forms.  They
       '  can be mixed and matched throughout a script.
       Cls
       Text Bright green on Black
       Say @5,5"Do you enjoy programming?";
       GetYN
       If Errorlevel 1
         Say @6,15"Then keep on coding."
       end else
         Say @6,15"You might consider podiatry instead."
       end
       Wait 54

       Text Bright Cyan on Black
       Say @10,5"Let's check to see if Bldlite.EXE is in the current
       directory."
       If Exist "Bldlite.EXE" Say@11,15"I found Bldlite.EXE."
       If not Exist "Bldlite.EXE" Say@11,15"I don't see Bldlite.EXE in
       this directory."
       Wait 54

       Text yellow on Black
       Say @14,5"Please press the {F1} key."
       GetKey
       If LastKey is {F1}
         Say @15,15"Congratulations!"
       End else
         Say @15,15"You didn't press the {F1} key, but we'll go
       on anyway."
       End
       Wait 54



Input

Format

       Input StrVar [, StrExp]

What it does

     Accepts a line of text from the keyboard.  Writes it to
     StrVar.  You cannot use Input directly on Integer, Longint,
     File, IntegerArray, or LongIntArray variables.  Use of
     StrExp places a default into StrVar and displays it on the
     screen.  The StrExp is accepted by pressing {Enter}, edited
     with {BackSpace}, or overwritten with any other keystroke.
     StrExp and additional keystrokes are displayed at current
     cursor position.

     If you press {Esc} during input, the string variable is set
     to null and the system variable Canceled is set to 1.
     Otherwise, it's cleared to 0.

What it's for

     Acting on more than single-keystroke input.  You should
     normally place a Say by itself after the Input statement to
     print a blank line to the screen after the user input.

See also

     Canceled, Input @, String

Example

       say "Please enter a new path: ";
       input Str1
       say
       set "%path%" = Str1



Integer

Format

       Integer IntVar1 [, IntVar2...]

What it does

     Allocates an integer variable for use in calculations and
     with other BUILDERlite commands.  You can declare several
     integers in a list by separating their names with commas.
     Value range for an Integer variable is -32,768 to 32,767.

What it's for

     Allocating space for storing and retrieving numbers which
     are required in your scripts.  When BUILDERlite displays an
     Integer, it formats the integer with commas.  A preceding
     minus sign is used for negative numbers.

Notes

     Some key items to note concerning declaring variables:

            1. All variable declaration statements (File,
               Integer, LongInt, and String) must be at the start
               of your BUILDERlite script.
            2. The variable can't be the same as a BUILDERlite
               reserved word, such as Run, String, or ECHO.  (See
               the Reserved word appendix for a complete list of
               BUILDERlite reserved words.)
            3. The variable name must start with a letter.  The
               following characters may be either numbers,
               letter, or an underscore.
            4. There can be more than one variable listed after
               the type, and they must be separated with commas.
            5. The variable name can be no longer than 32
               characters.  It can be as short as one character.

     Variable names are case-insensitive, so integer1 and
     INTEGER1 are considered equivalent names.  You may override
     the use of commas by a displayed integer with the Don't Use
     Commas command.

See also

     File, LongInt, String

Technical Notes

     Use the Integer format for numeric calculations when
     possible.  Integers provide the fastest execution time.

     You can use integers in mathematical expressions for
     addition and subtraction.  For example, the statements:

       a := 1 + 1

       a := b - c

     are both valid (providing that all variables have been
     properly declared).

Example

       ' See if drive A is ready.
       Say "Checking drive A..."
       ' Copy the ready status into the integer variable Int1.
       Int1 := DiskReady "A"
       ' Display results of query.
       If Int1 is 1
         Say "Drive A is ready.  Status in variable Int1 is: ";
       Int1
       end else
         Say "Drive A isn't ready.  Status in variable Int1 is:
       "; Int1
       end



IntToStr

Format

       StrVar := IntToStr IntExp

What it does

     Converts IntExp to a string and copies the result to StrVar.

What it's for

     Displaying an integer as a string or writing an integer out
     to a file.

See also

     LongToStr, StrToNum

Example

     See example program INT1.BLD.



Item

Format

       Item StrExp, [{KeystrokeConstant}]

What it does

     In a menu type, Item displays a StrExp as a selectable menu
     choice.  The keystroke constant allows for a hotkey
     assignment.  If the keystroke constant is omitted, then a
     hotkey can be assigned by use of & preceeding a character in
     StrExp.

What it's for

     For use in menus that allow multiple item selections.  The
     item is followed by program statements that would execute if
     the item was selected.  The keycode allows for hotkeys other
     than displayable characters.  Ex.:  {Alt-X}.

See also

     DropDown, LightBar, NestedItem

Example

       LightBar
          Item "Lotus", {Alt-L}
            Run Lotus
          Item "Word5", {Alt-W}
            Run Word
          Item "Quit", {Alt-Q}
            Exit
       End


Keypressed

Format

       If Keypressed <statement>

What it does

     Allows <statement> execution at the striking of any key.
     Unlike other key board functions, KeyPressed can be used in
     an expression without its value first being assigned to a
     variable.

What it's for

     Lets you perform other actions while awaiting a keystroke,
     unlike GetKey, which stops everything until a key is
     pressed.

Returns

     Returns a nonzero value if a key has been pressed, or 0 if
     no key has been pressed.  Once it returns nonzero, it will
     continue to do so until you use GetKey.

See also

     GetKey

Example

       ' This program displays "No key pressed" until a key
       ' is pressed, at which time its ordinal value is printed
       ' and the program exits.
       :Top
       if keypressed
          a := LastKey
          say a
          exit
       end
       say "No key pressed."
       goto Top



LastKey

Format

       IF LastKey is {KeystrokeConstant} <statement>
       IF not LastKey is {KeystrokeConstant} <statement>

     See Keystroke Constants for a list of valid key names.

What it does

     Executes <statement> based on results of KeystrokeConstant
     evaluation.  Used in conjunction with GetKey.

What it's for

     Controlling the flow of a program by accepting user input.
Technical Note

     LastKey is unusual in it's comparison abilities in that it
     may not be used with AND / OR statements.

See also

     GetKey, IF, Keystroke Constants

Example

       Say "Well, is it yes or no (Y/N)? ";
       GetReply
       Say
       If Int1 is 0
         Say "The answer was no."
       end else
         Say "The answer was yes."
       end

       Sub GetReply
           Int1 := 1000   'sets Int1 to an incorrect value
         ' Do this as long as Int1 is 1,000.
         While Int1 is 1000
           GetKey
           If LastKey is {y} Int1 := 1
           If LastKey is {Y} Int1 := 1
           If LastKey is {n} Int1 := 0
           If LastKey is {N} Int1 := 0
           If LastKey is {Esc} Int1 := 0
         End ' While Int1
       End ' Sub GetReply



Length

Format

       IntVar :=Length StrExp

What it does

     Copies the length of StrExp into IntVar.

What it's for

     Very useful for verifying a user's input.  For example, you
     can use Length to make sure that the length of a
     subdirectory is eight characters or less.  Also useful when
     trying to center text on the screen.

Example

       CLS
       ' Ask the user for input.
       Say "Please type in a fake error message. ";
       Input Str1
       ErrMsg
       Sub ErrMsg
         Don't use cursor
         ' Place length of Str1 into Int1.
         Int1 := Length Str1
         ' Account for word "<bold>Problem: "
         Int1 := Int1 + 10
         ' Make sure it's wide enough for the "Press" message.
         If Int1 < 26 Put 26 into Int1
         Int1 := Int1 + 4
         Double Box 2, 2, Int1, 5 White on Black
         Text Bright White on Black
         Say @ 3, 4  "<bold>Problem: ";
         Say Str1;
         Say @ 5, 4  "<bold>Press {Enter} to continue.";
         GetKey
         ' Redraw over the box.
         Double Box 2, 2, Int1, 7 Black on Black
         ' Enable hardware text cursor.
         Use cursor
       End ' Sub ErrMsg



LightBar

Format

       LightBar [@ <Row>, <Col>]
          Item <StrExp1>
               NestedItem <StrExp2>
                    <statements...>
          Item <StrExp3>
               <statements...>
          ...
          Item <StrExp4>
               <statements...>
       End

What it does

     Creates a lightbar menu at the optional location <row> <col>
     given after the @ sign.  If no location is given, the
     LightBar menu will begin at 1,1.  Each ITEM is followed by
     text which will be used as the text for the menu item.  If
     that item is selected all <statements...> until the next
     ITEM (or END, if it's the last ITEM) are executed.

     An ITEM that evaluates to a null string (that is, "") will
     not appear on the menu.

To select items

     To select a menu item, move the highlight to it and press
     {Enter}.  To move the highlight use any of these methods:

            1. Arrow keys
            2. {Tab} to go to the next item, {Shift-Tab} to the
               previous item.
            3. {Home} to go to the first item, {End} to go to the
               last item.
            4. If a Microsoft-compatible mouse is installed, move
               the mouse cursor to any item and click the mouse
               to activate it.
            5. Press {Esc} to quit the menu without selecting any
               items.  The system variable Canceled is set to 0.

     Pressing the first letter of an ITEM also selects it.  If
     there is more than one ITEM with the same first letter, the
     menu will cycle through those choices as long as you press
     that letter.
Limits

     There may be up to 40 ITEMs in a menu.  See NestedItem for
     an example of nesting a DropDown menu below a lightbar.  You
     can also put the menu you wish to call from a LightBar in a
     subroutine and call that sub instead.

     You may not place a comment line (one starting with REM or
     ') immediately above an ITEM line.

What it's for

     A fast way to create menus that act like CASE statements.

Note

     Only available after a LightBar menu has been executed.

See also

     Canceled, DropDown, Menu Style, NestedItem, PopUp

Example

       While not Canceled
         Say@5,14"Welcome to your PC.  Enjoy yourself!"
         Menu Style
       Cyan,Black,Red,White,Bright,Cyan,White,White,Black,0,1,1,1
         Lightbar@11,20
           Item "Word5    "
             Word
           Item "Quatro   "
             Quatro
           Item "BUILDER  "
             Run BUILDER
           Item "Exit     "
             Exit
         End
       End
       sub Word
         Double box 15,5,70,3 Bright cyan on black
         Say@16,6"If it was loaded on your machine, you could
       drop to WORD now."
         Wait 90
       End
       sub Quatro
         Double box 15,5,70,3 Bright cyan on black
         Say@16,6"If it was loaded on your machine, you could
       drop to QUATRO now."
         Wait 90
       End



LongInt

Format

       LongInt LongIntVar1 [, <LongIntVar2>...]

What it does

     Allocates a long integer variable for use in calculations
     and with other BUILDERlite commands.  Long integers are used
     when you need to store numbers larger than 32,768 (positive
     or negative), up to 2,147,483,648 (positive or negative).
     You can declare several long integers in a list by
     separating their names with commas.

What it's for

     Allocating space for storing and retrieving numbers which
     are required in your scripts.

Notes

     Some key items to note concerning declaring variables:

               1.   All variable declaration statements (File,
               Integer, LongInt, and String) must be at the start
               of your BUILDERlite script.
            2. There can be more than one variable listed after
               the type, and they must be separated with commas.
            3. When BUILDERlite displays a LongInt, it is
               formatted with commas.  This can be overridden
               with the Don't Use Commas command.
            4. A preceding minus sign is used for negative
               numbers.

See also

     Integer

Technical Notes

     Use the Integer format for numeric calculations when
     possible.  Integers provide the fastest execution time.
     LongInt is necessary for calculations requiring numbers over
     32,767.

     You can use long integers in mathematical expressions for
     addition and subtraction.  For example, the statements:

       a := 1 + 1

       a := b - c

     are both valid (providing that all variables have been
     properly declared).

Example

       Dont Use Commas
       LongInt1 := DiskFree "C"
       say "You have "; LongInt1; " bytes available on your C:
       drive."
       Use Commas



LongToDateStr

Format

       StrVar := LongToDateStr LongIntExp

What it does

     Converts a long integer expression, into a string variable
     in the MM-DD-YYYY format.
     Where MM is the month (from 01 to 12), DD is the day of the
     month (from 01 to 31), and YYYY is the four digit year.

What it's for

     Converting a long integer into a date string that can be
     displayed in a recognizable format.

See also

     LongToTimeStr

Example

       'Will tell us the system time and date.
       LongInt1 := SysDateToLong
       Str1 := LongtoDateStr LongInt1
       Say "Today's date is "; Str1
       LongInt2 := SysTimeToLong
       Str2 := LongToTimeStr LongInt2
       Say "At the tone the time will be ";Str2
       Beep
       Pause



LongToStr

Format

       StrVar := LongToStr LongIntExp

What it does

     Converts a longint expression to a string variable.

What it's for

     Displaying an integer or writing an integer out to a file.

See also

     IntToStr, StrToNum

Example

       ' LONGSTR1.BLD
       ' Demonstrates LONGINT, LONGTOSTR, STRTONUM, and how to
       write a number to a
       ' file.
       Say "Checking drive A..."
       LongInt1 := DiskReady "A"
       ' Print results of query.
       If LongInt1 is 1
         Say "Drive A is ready.  Status in variable LongInt1 is:
       "; LongInt1
       end else
         Say "Drive A isn't ready.  Status in variable LongInt1
       is: "; LongInt1
       end
       Say "Let's write a number to a file. Enter a number up to
       2 billion."
       Input Str1
       LongInt1 := StrToNum Str1
       Say "Adding 1 to it."
       LongInt1 := LongInt1 + 1  'add to it
       Str1 := LongToStr LongInt1  'convert it back
       Open "File1.$$$" For Writing as File1
         WriteLine Str1 to File1
         Close File1
       ' Report progress and show evidence of the file that was
       created.
       Say "Created the file File1.$$$.  Look:"
       Run dir File1.$$$
       Say "Here are the contents of the file File1.$$$:"
       Run type File1.$$$
       Pause Press any key to delete the file.
       Run del File1.$$$



LongToTimeStr

Format

       StrVar := LongToTimeStr LongIntExp

What it does

     Converts a longint expression into a string variable, in the
     HH:MM:SS format.

     Where HH is hours (from 01 to 24), MM is the minutes (from
     01 to 60), and SS is seconds (from 01 to 60).

What it's for

     Converting a long integer into a time string that can be
     displayed in a recognizable format.  The format used is
     commonly known as military time.

See also

     LongToDateStr

Example

       'Will tell us the system time and date.
       LongInt1 := SysDateToLong
       Str1 := LongtoDateStr LongInt1
       Say "Today's date is ";Str1
       LongInt2 := SysTimeToLong
       Str2 := LongToTimeStr LongInt2
       Say "At the tone the time will be ";Str2
       Beep
       Pause



LowerCase

Format

       StrVar := LowerCase StrExp

What it does

     Forces the characters in a string expression to lowercase
     and copies them to a string variable.

What it's for

     Makes string comparisons easier.
See also

     UpperCase

Example

       say "Please enter a string in upper and lower case. ";
       input Str1
       say "The string you entered was ";Str1
       Str1 := UpperCase Str1
       say "The string looks like this in uppercase: "; Str1
       Str1 := LowerCase Str1
       say "The string looks like this in lowercase: "; Str1



LTrim

Format

       StrVar := LTrim StrExp

What it does

     Removes leading spaces and tabs from a string expression,
     and copies the result into a string variable.

What it's for

     Ensuring consistency of user input.  New line characters are
     also removed, although BUILDERlite does not allow you to
     embed them in a string.

See also

     MidStr, RTrim, Trim

Example

       ' This file shows LTrim, RTrim, and Trim in action.
       say "Enter a string with leading and trailing blanks: ";
       input Str1
       ' Remove leading spaces and tabs:
       Int1 := LTrim Str1
       say "After LTrim, the string is: '"; Int1; "'."
       ' Remove trailing spaces and tabs:
       Int2 := RTrim Str1
       say "After RTrim, the string is: '"; Int2; "'."
       ' Remove both leading and trailing blanks:
       Int3 := Trim Str1
       say "After Trim, the string is: '"; Int3; "'."



MaxCols

Format

       IntVar := MaxCols

What it does

     Returns the current width of the screen in characters.
What it's for

     Lets you determine the screen size dynamically so that BOX
     statements or hand-coded graphics routines will fill the
     screen in any text mode.

See also

     MaxRows

Example

       ' Displays the current height and width of the screen
       Int1 := MaxCols
       Int2 := MaxRows

       ' Display the values.
       say "Screen width is currently: "; Int1
       say "And the height is: "; Int2



MaxRows

Format

       IntVar := MaxRows

What it does

     Returns the current height of the screen in characters.

What it's for

     Lets you determine the screen size dynamically so that BOX
     statements or hand-coded graphics routines will fill the
     screen in any text mode.

See also

     MaxCols

Example

     See the example under MaxCols



Menu Style

Format

       Menu Style
          <Item text color>,  <Item background color>,
          <Hotkey text color>,     <Hotkey background color>,
          <Highlight text color>,  <Highlight background color>,
          <Box color>,        <Box background color>,
          <Immediate trigger>,     <Use first key>,
          <Box style>,        <Use shadow>

What it does

     Controls every aspect of menu appearance and behavior (the
     term "menu" includes DropDown, LightBar, and PopUp, although
     only DropDown uses every parameter).  All 12 parameters must
     appear on one line, contrary to the format diagram above.
     The first eight parameters may be color names such as White
     or Cyan, or their equivalent integer values.  Background
     items are limited to the basic eight colors if the Usec
     BrightColors command has not been invoked.  The last four
     paramaters are integer expressions.

            *  <Item text color> is the text color used in menu
               items.  Default:  white.
            *  <Item background color> is the background color
               used in menu items.  Default:  black.
            *  <Hotkey text color> is the color of the designated
               "hotkey."  Default:  white.
            *  <Hotkey background color> is the background color
               for the designated hotkey.  Default:  black.
            *  <Highlight text color> is the text color used for
               selected menu items.  Default:  black.
            *  <Highlight background color> is the background
               color used for selected menu items.  Default:
               white.
            *  <Box color> is used only by DropDown and sets the
               color used for the box surrounding a DropDown
               menu.  Default:  white.
            *  <Box background color> is the color used for the
               menu's background.  Default:  black.
            *  <Immediate trigger> is either 1 or 0.  If 1, it
               means that pressing an item's hotkey triggers that
               item--that is, both selects the item and executes
               it, just as if you pressed {Enter}.  If 0,
               pressing a hotkey will move the highlight to that
               item, but you must press {Enter} manually to
               execute the highlighted choice.  Default:  0.
            *  <Use first key> is either 1 or 0.  If 1, the menu
               will automatically display the first letter of
               each menu item in the <Hotkey text color> and
               <Hotkey background color>.  If 0, the user must
               specify which character will be used as a hotkey
               by preceding it with an ampersand (&), or by
               specifying a hoykey with a {keycode} at the Item
               title.  The ampersand itself will not appear in
               the menu.  Default:  0.
            *  <Box style> is either 1, for a single-border box,
               or 2, for a double-border box.  <Box style> is
               only available for DropDown.  Default:  1.
            *  <Use shadow> is either 1 or 0.  If 1, the menu
               casts a shadow.  If 0, there's no shadow.  <Use
               shadow> affects DropDown and PopUp, but not
               LightBar.  Default:  0.

What it's for

     Fine-tuning menu presentation and performance.

See also

     DropDown, Item, LightBar, NestedItem, PopUp, appendix on
     colors.

Example

       ' MSTYLE1.BLD
       '
       ' Demonstrates how MENU STYLE affects the look and feel of
       a menu.
       ' Menu item text is black and background color of items is
       white.
       ' Hotkey text is white on a black background.
       Menu Style Black, White, White, Black, White, Black,
       Black, White, 1,0,2,1
       '          |      |      |      |      |      |      |
       |
       '          |      |      |      |      |      |      |
       Box background
       '          |      |      |      |      |      |      Box
       text
       '          |      |      |      |      |      Highlight
       background
       '          |      |      |      |      Highlight text
       '          |      |      |      Hotkey background
       '          |      |      Hotkey text
       '          |      Item background
       '          Item text

       ' The 1, 0, 2, 1 means:
       '     |  |  |  |
       '     |  |  |  1=Use shadow, 0=No shadow
       '     |  |  2=double box style, 1=single box
       '     |  1=Use first key, 0=& required
       '     1=Immediate trigger, 0=wait for {Enter}
       '
       While Not Canceled
         cls white on black
         DropDown "" @ 10, 30
           Item "Stat&us"
             say @ 24, 30 "Program status:  <reverse>Test mode"
             GetKey
           Item "Directory &listing"
             RowCol 10, 1
             run Dir *.txt
           Item "&Quit"
             exit 0
         end
       End



MidStr

Format

       StrVar := MidStr StrExp, IntExp1, IntExp2

     Where IntExp1 is the starting point and IntExp2 is the
     length of the string to be copied from StrExp to a string
     variable.

What it does

     Copies the IntExp2 characters appearing from IntExp1 of the
     StrExp into a string variable.

     The first character is position 1, not position 0.  If
     IntExp1 is 0 or greater than the length of the string,
     MidStr returns an empty string.  If IntExp2 is greater than
     the length of string variable, then IntExp2 is actually
     treated as the length of the string variable.

What it's for

     Parsing string expressions to give full string manipulation
     power to BUILDERlite programmers.
See also

     LTrim, RTrim, Trim

Example

       'This will test midstring by parsing a variety of strings

       String Str1,Str2
       Integer Int1,Int2
       cls
       Str1 := "abcdefghijklmnopqrstu"
       Int1 := Length Str1
       while Int1>0
        Str2:=Midstr Str1,1,Int1
        say Str2
        Int1 := Int1-1
       end
       say "Press a key to go the other way"
       getkey
       cls
       Int1 := Length Str1
       Int2 := 1
       while Int2<Int1+1
        Str2 := Midstr Str1,1,Int2
        say Str2
        Int2 := Int2+1
       end



MouseHideCursor

Format

       MouseHideCursor

What it does

     Hides the mouse cursor.  Disables BUILDERlite's automatic
     hiding/redisplay of mouse cursor when menus are used.

What it's for

     Overriding BUILDERlite's use of the mouse, which by default
     automatically displays the mouse cursor when a menu appears,
     and hides it when the menu disappears.

See also

     MouseInstalled, MouseShowCursor

Example

       ' Hide the mouse cursor in the DropDown.
       ' Display the mouse cursor if user chooses
       ' that item from the menu.
       MouseHideCursor
       DropDown "NoMouse"
         item "Show mouse"
         MouseShowCursor
       end


MouseInstalled

Format

       IntVar := MouseInstalled

What it does

     Detects the installation of a MicroSoft compatible mouse
     driver.

What it's for

     Letting your BUILDERlite script know whether the user has a
     mouse installed.

Returns

     Returns a nonzero value if a mouse driver is active, 0 if
     not.

See also

     MouseHideCursor, MouseShowCursor

Example

       Int1 := MouseInstalled
       if Int1
         say "There's a mouse."
       end else
         say "No mouse.  Quitting."
         exit 1
       end



MouseShowCursor

Format

       MouseShowCursor

What it does

     Enables BUILDERlite's hiding/redisplay of mouse cursor when
     menus are used.  When not in menus, the mouse cursor will
     disappear.

What it's for

     Activating BUILDERlite's use of the mouse, which displays
     the mouse cursor when a menu appears, and hides it when the
     menu disappears.  BUILDERlite automatically uses a mouse if
     one is present; this command is required only if the
     MouseHideCursor was used, and you wish to re-activate the
     mouse cursor.

See also

     MouseInstalled, MouseHideCursor

Example

     See the example for MouseHideCursor


Move

Format

       [IntVar :=] Move StrExp1 StrExp2

What it does

     Changes the directory location of StrExp1 by renaming it
     across directories.  If only a drive specification is given
     in StrExp2, or there's insufficient disk space on the
     destination volume, or if network access is denied, the file
     will not be renamed.  Gives an optional return value to
     verify success.

What it's for

     Moving a file from one place to another with one command.
     Using MS-DOS Copy and Del statements will do the same thing,
     but requires more commands.

Returns

     0 upon failure, 1 upon success.

Note

     The files named in the source and destination positions must
     include drive specifications and file extensions.

Example

       say "Name of file to move? ";
       input Str1
       say "Name of destination file?";
       input Str2
       move Str1 Str2



NOT

Format

       Not <expression>

What it does

     NOT is a unary operator that reverses the meaning of the
     expression it modifies.  It can also perform a bitwise NOT
     when used with expressions that evaluate to integers or
     longints.

What it's for

     In batch statements, NOT reverses the meaning of the batch
     expression.  Batch expressions are inconsistent, however;
     see the description of the IF command earlier in this
     chapter.

     Not has a similar effect in BUILDERlite, but must be used on
     a logical expression.  A logical expression is one that
     evaluates to zero (false) or one (true).
Notes

     Not and strings:  Because Not is a unary operator, you'll
     need to use parentheses around the expression most of the
     time--especially in string expressions.  For example, the
     following expression evaluates to 0, or false:

       "/c" == "/C"

     This expression evaluates to 1, or true:

       "/C" == "/C"

     So far, so good.  But wait!  Since Not modifies the Operand
     immediately following it, and since that Operand must be a
     numeric expression, the following will not work because "%1"
     isn't a numeric expression:

       If not "%1" == "/c"

     This works, however, because the expression "%1" == "/c" is
     a logical expression--one that evaluates to either 1 or 0.

       If not ("%1" == "/c")

     The best solution for string expressions in this case is to
     use the inequality operator:

       If "%1" <> "/c"

     Not and numbers:  Since Not operates on the item immediately
     following it, you may get what seem like odd results with
     integer expressions.  The same rules as above apply:  use
     parentheses when you're not sure.  For example, the Not in
     this case is applied to the integer variable Len, not the
     expression Len < 9:

       Integer Len
       ' The NOT is applied to Len here, not "Len < 9":
       If not Len < 9

     Because Len is a numeric expression all by itself, Not Len
     will evaluate to either 0 or 1.  Surround the offending
     expression in parentheses where necessary:

       Integer Len
       ' The NOT is applied to "Len < 9" in this example:
       If not (Len < 9)



NumToChar

Format

       StrVar := NumToChar NumExp

What it does

     Converts NumExp to a string variable based on its ASCII
     character value.

What it's for

     Handling character constants that aren't easily dealt with
     in strings.  For example, the ASCII values of characters.
Returns

     Returns the ASCII character representation of NumExp.

See also

     CharToNum, StrToNum

Notes

     This is similar to CHR$() in BASIC.

Example

       '  Using NumToChar, this example will convert a number to
       its
       '  text numeric equivalent.
       '  First it will print the alphabet in lowercase on line
       10,
       '  and then it will print alphabet in uppercase on line
       20.
       Int1 := 97
       gotoxy 1,10
       while Int1<123
        Str1 := NumtoChar Int1
        say Str1;
        Int1:=Int1+1
       end
       gotoxy 1,20
       Int1:=65
       while Int1<91
        Str1 :=NumtoChar Int1
        say Str1;
        Int1:=Int1+1
       end



OnPath

Format

       IntVar := OnPath StrExp

     StrExp represents a particular filename.

What it does

     Evaluates the existance of a file on the PATH.  This command
     only allows the designation of a single file; wildcard
     specifications are not allowed.

What it's for

     Most useful in installation scripts in which the use of
     certain programs is required, but it's unknown whether
     they're available.

Returns

     Returns the value 1 if the file specified in StrExp is on
     the path, 0 if not.

See also

     Integer
Example

       ' In this section of your menu, you are going to branch to
       the Lotus 1-2-3
       ' application program.  But first you should be sure it is
       ' on the current path.
       Int1 := OnPath "123.EXE"
       If Int1 is 0 goto LotusNotAvail
       ' The file 123.EXE was found, so let's execute lotus.
       Run C:
       Run CD 123
       Run 123
       ' After leaving 1-2-3, we want to exit this program
       altogether
       goto OutaHere

       :LotusNotAvail
       say "Uh-oh.  You have chosen Lotus 1-2-3 from our menu but
       it"
       say "is not available on the current path."
       say "Please be sure that the software is loaded on your
       system."
       say "Then modify your path to include the Lotus
       subdirectory and reboot."

       :OutaHere
       exit



OSMajor

Format

       IntVar := OSMajor

What it does

     Places the DOS major version number into an integer
     variable.

What it's for

     Ensuring the DOS in the system is up-to-date.  Versions of
     DOS can range typically range from 2.X to 5.X; many
     applications require version 3 and above to run.

Returns

     Returns the major version number of DOS.

See also

     OSMinor, OSVersion

Example

       ' Check the major version
       Int1 := OSMajor
       ' Warn if it's an early version.
       IF Int1 < 3
         say "DOS 3 required"
         ' Quit w/error code.
         exit 1
       end


OSMinor

Format

       IntVar := OSMinor

What it does

     Places the DOS minor version number into an integer
     variable.

What it's for

     Ensuring the DOS in the system is up-to-date.  Versions of
     DOS can range typically range from 2.X to 5.X; many
     applications require version 3 and above to run.

Returns

     Returns the minor version number of DOS.

See also

     OSMajor, OSVersion

Example

       ' Check the major version
       Int1 := OSMajor

       ' Warn if it's an early version.
       IF Int1 < 3
         say "DOS 3.3 or later required"
         ' Quit w/error code.
         exit 1
       end

       Int2 := OSMinor

       IF Int2 < 3
         say "DOS 3.3 or later required"
         ' Quit w/error code.
         exit 1
       end

       say "You are running with DOS 3.3 or above; please
       continue."



OSVersion

Format

       StrVar := OSVersion

What it does

     Evaluating the OS version installed on the machine and
     placing it into a string variable for display, etc.

What it's for

     Displaying to the user the current version of DOS which is
     running.  Similar to the DOS VER command, except that it is
     retained in a string variable for further use.
Returns

     Returns the version of DOS which is currently running in a
     string variable.

See also

     OSMajor, OSMinor

Example

       string Str1
       Str1 := OSVersion
       if Str1 < "4.0" say "DOS version 4.0 or greater required."



ParamCount

Format

       IF ParamCount is|== <statement>
       IF not ParamCount is|== <statement>

What it does

     Evaluates the number of parameters in a commandline.  Note
     that the equivalence test (the == operator will also work)
     is an exact-match test.  Unlike IF ERRORLEVEL, testing
     ParamCount for a number results in true for that number
     only--not that number or above.

What it's for

     A much more convenient way to test for the correct number of
     command-line arguments before proceeding with your program.

     Note that ParamCount starts at 1 for the name of your
     program.  Here's what ParamCount would be in the following
     command lines for a program called PARAM:

       Command line:                    ParamCount:
       C:\BUILDER\> PARAM                    1
       C:\BUILDER\> PARAM  CHECK             2
       C:\BUILDER\> PARAM  BEAT  ME  WITH  A  STICK    6

Returns

     Returns the number of arguments on the command line.

See also

     IF

Example

       ' Quit if the command line didn't contain three
       parameters.
       IF NOT ParamCount is 3 GOTO MissingParams
       say "ParamCount is equal to 3--Good job!"
       exit
       :MissingParams
       say "<reverse>Error! <normal> The correct format is:  "
       say "   PARAM  <param1>  <param2>"


Password

Format

       Password StrExp

What it does

     Lets the user enter text from the keyboard.  The characters
     are not displayed.  If the text matches the designated
     string, ERRORLEVEL is set to 0.  If the text doesn't match
     the string, ERRORLEVEL is set to 1.

What it's for

     Allowing your program to control access to other programs.
     It makes sense as part of a menu program.

See also

     IF

Example

       ' Get a password from the user, continue only if it's
       correct.
       say "Please enter your password: ";
       Password "IT'S OK"
       ' If password entered is correct ERRORLEVEL is set to 0.
       IF ERRORLEVEL 1 Goto Next
       ' If password is incorrect beep.
       Beep
       say "You did it!"
       exit
       :Next
       say "You goofed--bye bye!"



Pause

Format

       PAUSE [<StrExp>]

What it does

     Halts program operation, displays optional StrExp on the
     screen, if any, and awaits any keystroke before continuing.
     If StrExp is employed it is followed by a new line.

What it's for

     Allowing the user to exit a program by pressing {Ctrl-C}, or
     for the program to wait for an external event such as a disk
     change.

     GetKey, which sets the global variable LastKey, and GetYN,
     which constrains input to either the Y or the N key, offer
     better program control.  PAUSE is included only for
     compatibility with interpreted batch programs.
Technical note

     The BUILDERlite implementation of PAUSE omits the "Strike a
     key to continue" message that interpreted batch files append
     to the DOS PAUSE statement.

See also

     GetKey, GetYN

Example

       ' Displays the following text and waits for a keypress.
       PAUSE Press {Ctrl-C} to quit the program, or any other key
       to continue.
       ' Waits for a keypress without printing anything.
       PAUSE



PopUp

Format

       PopUp
          Highlight <row>, <column>, <length>
          Item <string expression>
               <program statements>
          Highlight <row>, <column>, <length>
          Item <string expression>
               <program statements>
       End

What it does

     Each ITEM is a string that appears at <row>, <column>.  When
     selected, a highlight appears <length> characters wide.
     <row>, <column>, and <length> are integer expressions.  If
     that item is selected all <program statements> until the
     next ITEM (or END, if it's the last ITEM) are executed.

     An ITEM that evaluates to a null string (that is, "") will
     not appear on the menu.

     You may not place a comment line (one starting with REM or
     ') immediately above an ITEM line.

To select items

     To select a menu item, move the highlight to it and press
     {Enter}.  To move the highlight use any of these methods:

            1. Arrow keys
            2. {Tab} to go to the next item, {Shift-Tab} to the
               previous item.
            3. {Home} to go to the first item, {End} to go to the
               last item.
            4. If a Microsoft-compatible mouse is installed, move
               the mouse cursor to any item and click the mouse
               to activate it.
            5. Press {Esc} to quit the menu without selecting any
               items.  The system variable Canceled is set.

     Pressing the first letter of an ITEM also selects it.  If
     there is more than one ITEM with the same first letter, the
     menu will cycle through those choices as long as you press
     that letter.
Limits

     There may be up to a total of 40 Items and NestedItems in a
     menu.  See NestedItem for the ability to nest menus from a
     LightBar.

What it's for

     Freeform menus, typically a matrix of menu items.

See also

     Canceled, DropDown, LightBar, Menu Style

Example

       cls
       say "Message? ";
       input Str1
       Msg
       say @ 23, 1 "<reverse>"; Str1; " selected."

       Sub Msg
         Text bright white on blue
         ' Draw a box in the center of the screen to hold the
       dialog.
         double box 6,    20,    40,    10 bright white on blue
         '          Row   Col    Width  Height

         double box 12, 28, 6, 3 bright white on blue
         single box 12, 39, 11, 3 bright white on blue
         ' Display the dialog box message
         Say @  8, 25 DMessage;

         Popup
           Highlight @ 13,   29,   4
           item " OK "
             ' Return this value:
             Str1 := "OK"
           Highlight @ 13,   40,   9
           item " Cancel "
             ' Return this value:
             DMessage := "Cancel"
         End ' PopUp
       End ' Sub



PrinterReady

Format

       IntVar := PrinterReady IntExp

What it does

     Quiries the designated printer port IntExp to test for its
     state of readiness.  Ports start at 1 for LPT1:, 2 for
     LPT2:, etc.

What it's for

     Trying to print to a printer that's not available is a
     common problem with any PC application.  This is provides a
     way of avoiding this situation.
Returns

     Returns nonzero if LPT port IntExp is ready and 0 if not.

Note

     Works only on parallel ports, not serial.

Example

       Int1 := 1
       While Int1 < 4
          Int2 := PrinterReady Int1
          if Int2
               say "Printer "; Int1; " is ready."
          end else
               say "Printer "; Int1; " isn't ready."
          end ' If
       ' Look at next printer.
          Int1 := Int1 + 1
       End ' While



Reboot

Format

       Reboot

What it does

     Resets the computer, doing a warm boot (as if the user had
     pressed {Ctrl-Alt-Del}).

What it's for

     To reset the user's system.  For example, if your program
     alters CONFIG.SYS or AUTOEXEC.BAT, and you want to ensure
     those changes take effect immediately.

Example

       ' Contains a subroutine that confirms a reboot request.
       AskForReboot
       ' If user pressed N control returned from the subroutine.
       say "Thank heavens.  You would have lost 3 hours worth of
       work!"

       sub AskForReboot
          Double Box 10, 25, 30, 5 bright red on black
          say @ 12, 28 "<blink>Sure you want to Reboot? ";
          GetYN
          ' Reboot if user pressed Y.
          if errorlevel 1 reboot
       end



REM

Format

       REM <anything>
What it does

     Compatibility;REM statements don't execute.  They're thrown
     out before the program is compiled.  The <anything> is any
     typed text.

     BUILDERlite never displays the contents of REM statements.
     You may not place a comment line (one starting with REM or
     ') immediately above a menu statement or Item line in a menu
     statement.

What it's for

     REM lets you add notes to yourself so that you'll know what
     happens in a program.  BUILDERlite implements the apostrophe
     as a remark character, and it's the preferred method.

See also

     '

Example

       REM This isn't compiled.
       '   Neither is this, and it's two less characters to type!



RenSub

Format

       [IntVar :=] RenSub StrExp1 StrExp2

What it does

     Renames a current subdirectory StrExp1 to a new subdirectory
     StrExp2.

What it's for

     "Moving" all files and subordinate directories from one
     directory to another.  Useful in installation scripts as a
     backup utility for maintaining different versions of
     software.

Technical Note

     Works only on DOS versions 3.0 or greater.  StrExp2 cannot
     be the name of an existing subdirectory.

Example

       '  This program will help you easily rename sub-
       directories.

       Say @8,10"What sub-directory would you like to rename? ";
       Input Str1

       Say @ 11,10 "What would you like its new name to be? ";
       Input Str2

       Say @ 13,10 "Strike any key to continue, or {Esc} to
       cancel."

       Getkey
       If Lastkey is {Esc}
         Exit
       End else
         RenSub Str1 Str2
         Say @16,10"Sub-directory ";Str1;" is now sub-directory
       ";Str2;
       End



Repeat

Format

       Repeat IntExp
          <statement>
       end

     <statement> can represent any valid BUILDERlite commands,
     including DOS and Batch commands and external program
     commands preceded by Run.

What it does

     Repeats a command or series of commands a specified number
     of times.

What it's for

     Executing the same command for a specified number of times.
     Repeat resembles the For loop.

See also

     Case, For, Integer, While

Example

       ' Demonstrates REPEAT and BOX by displaying two animated
       ' columns of boxes.
       cls
       ' Starting at the top of the screen,
       Int1 := 1
       Repeat 10
        Single box Int2, 30, 20, 10 White on Black
        Int2 := Int2 + 1
       End
       ' Now, at the bottom of the screen,
       Int2 := 16
       ' Display 8 boxes,
       Repeat 8
         Single box Int2, 30, 20, 10 White on Black
         Int2 := Int2 - 1
       End
       '
       ' Put something in the middle of the box.
       say @ 14, 36 "<reverse>BUILDER!";



Return

Format

       Return [IntExp]
What it does

     Terminates subroutine execution if a Return is encountered,
     and returns to the original subroutine call with an optional
     IntExp.

What it's for

     Allows conditional checking within a subroutine, and easy
     termination.  Use of the optional IntExp allows for a return
     value for more conditional checking.

See also

     Sub

Example

       Int1 := OpenFile
       If Int1 == 1
          Say "File opened successfully!"
       End else
          Say "Unable to open file."
       End

       Sub OpenFile
         Int2:= Open "TEST.TXT" for reading as File1
         If Int2 == 0 Return 0   'File was not opened, return
       with error.
         Rewind File1
         Return 1  'Everything is fine, return with out error.
       End



RowCol

Format

       RowCol <row>, <column>

What it does

     Sets the location of the cursor on the screen.  The origin
     of the screen is the upper left corner.  Its coordinates are
     1, 1.  The row represents the top to bottom position, and
     the column represents the left to right position.

What it's for

     Full screen control.  RowCol lets you paint the screen in a
     way that interpreted batch files, even those relying on
     ANSI.SYS can't.  Eliminates unsightly keystroke results from
     the screen.

     Note that Say @ <row>, <col> positions the cursor and allows
     you to display text at that position.  GoToXY operates
     similar to RowCol, but the column coordinate precedes the
     row coordinate; the reverse of RowCol.

Technical notes

     RowCol is not supported while the Use DOS statement is
     active.
See also

     GoToXY, Say

Example

       CLS
       Say "This program runs until you press {N}.  Notice how
       GetYN is used, "
       Say "but the prompt it normally leaves is erased.  That's
       because GoToXY"
       Say "is used to position the cursor over the last space in
       the message."
       Say
       :Top
       say @ 12, 30 "Would you like to continue?  "
       ' Reposition the cursor over the last space in the prompt.
       RowCol 12, 58
       ' Await either a {Y} or {N} keypress.
       GetYN
       ' If {Y} is pressed, GetYN will leave it onscreen but it
       will immediately
       ' be covered over by the final space.
       if Errorlevel 1 goto Top



RTrim

Format

       StrVar := RTrim StrExp

What it does

     Removes trailing spaces and tabs from a string expression
     and copies the results into a string variable.

What it's for

     Ensuring consistency of user input.

Note

     New line characters are also removed.

See also

     LTrim, MidStr, Trim

Example

     See the example for LTrim.



Run

Format

       Run <DOS text>

What it does

     Drops <DOS text> through to DOS and runs it as a program or
     DOS command, then returns control to your program.
What it's for

     Run tells BUILDERlite that the next text is either a DOS
     command or an external program to execute.  When BUILDERlite
     Imports your .BAT files, or compiles them from the command
     line, it creates a .BLD equivalent, and many lines will
     start with Run.

     The reason for this is that BUILDERlite must know the
     difference between a DOS command and a BUILDERlite language
     extension.  The interpreted batch language simply passes
     this command (and all unknown commands) to DOS, because
     there are only seven accepted batch commands.

     BUILDERlite can't do that, however, because there are now
     three choices:

            1. The line can be a batch command, such as ECHO, or
            2. The line can be a program name or non-batch
               command such as CD \, or
            3. The line can be a BUILDERlite extension to the
               batch language, such as GoToXY or GetYN.

     In order to know the differences among these three,
     BUILDERlite requires that you insert RUN before anything
     that isn't a batch or BUILDERlite language element.  That
     way if you're using, for example, a program called GETYN.COM
     and don't want to use the BUILDERlite GetYN command, all you
     have to do is change the line to RUN GETYN and BUILDERlite
     will pass the GETYN through to DOS.

     For more information see appendix on import.

Technical notes

     Memory-resident programs:  We don't reccommend running
     memory-resident programs such as Sidekick or PRINT.COM from
     within a BUILDERlite compiled menu or program.  They'll
     work, but memory occupied by the compiled BUILDERlite
     program will not be available to DOS when it finishes
     execution and exits back to DOS.

     Run by itself runs COMMAND.COM and stays there until the
     user types EXIT at the DOS prompt and presses {Enter}.

See also

     System,

Example

       '  This example illustrates Run and System.
       String Dir,Str1,Str2
       Integer Int1,Int2
       Cls
       Say @5,1"When you press a key, the line <bright cyan>Run
       Dir";
       Say "<normal> will be executed."
       Pause Press any key
       Run Dir
       Pause Press any key
       Cls
       Say@7,1"Wasn't that something?"

       Say@9,1"When you press a key, the <bright cyan>DOS Chkdsk
       will be";
       Say " placed in Dir<normal>, and System"
       Say@10,1"will execute the String Dir.  You will see
       <bright cyan>Chkdsk";
       Say " <normal>run as a result."
       Dir := "Chkdsk"
       Pause Press any key
       System Dir
       Pause Press any key
       Cls
       Say@11,1"This is getting interesting!"

       Say@13,1"When you press a key, the line <bright cyan>Run
       Dir";
       Say " <normal> will be executed."
       Pause Press any key
       Run Dir
       Pause Press any key
       Cls
       Say@14,1"It worked, Run executed the <bright cyan>Dir
       <normal>command,";
       Say " not the <bright cyan>String Dir<normal>."



Say

Format

       Say [[@ <row>, <col>] <string expression>[;]]

Technical notes

     Say displays a list of string expressions or numeric
     expressions by separating them with semicolons.  The
     semicolon means that the next string expression will print
     next to the previous one; without the semicolon, a new line
     is displayed after it.  String constants may include
     metacharacters, which control text attributes.  Text is
     displayed using the BIOS; to make it redirectable, you must
     precede the Say statement with a Use DOS statement.

     You can use the optional @ sign immediately after the Say to
     position the cursor and text.  Say on a line by itself
     prints a blank line.

String constants

     To display any character literally precede it with a tilde
     (~) character.

     To display characters you would normally have trouble
     inserting into a string, for example, a carriage return, use
     a tilde (~) character followed by the ASCII character code
     in decimal format.  The first nondigit following the tilde
     ends the number.  Characters like this are sometimes called
     escape codes.

     Metacharacters;Metacharacters are string literals within
     angle brackets that let you change foreground text
     attributes such as color, blinking, underline, and bold.
     For example, say "<blink>Error!" causes the word Error to
     blink.

     Say uses the current foreground and background text colors,
     and metacharacters apply only to the Say statement in which
     they appear.
     Here are the allowable choices:

            Colors                      Attributes
            <black>      <blue>         <blink>
            <bright blue>               <bright cyan>  <bold>
            <bright green>              <bright magenta>    <high
            light>
            <bright red> <bright white> <normal>
            <brown>      <cyan>         <reverse>
            <gray>       <green>        <underline>
            <magenta>    <red>
            <white>      <yellow>

Color control

     Metacharacters only let you change the foreground color.
     Use the Text statement or CLS On to change both the
     foreground and background colors.

What it does

     Displays text.  Say has a lot of variations:  you can use it
     to position the cursor, display text in different colors,
     display environment and command line variables, and to print
     without starting a new line after.

What it's for

     Better control over screen output than ECHO.

Technical Note

     Metacharacters are limited by the PC video hardware, so some
     choices won't work.  The metacharacter <underline> won't
     work on color monitors, and some combinations of attributes
     won't work.

     Strings without metacharacters in them will display DOS
     variables such as %1 or %path% correctly (that is, the
     variables are expanded to their values).  Strings with
     metacharacters in them will print the text literally.

     Say prints a carriage return (starts a new line) after the
     string unless a semicolon follows it.  Note that when you do
     a Say @ to position the cursor, you should usually follow
     the text with a semicolon--you normally won't want the new
     line printed if you've positioned the cursor.  A BIOS quirk
     causes the entire screen to scroll up one line if there is a
     character in the last column of the bottom line of the
     screen, even if you use a semicolon after it.  Say @ will
     not position the cursor if USE DOS is active.

See also

     CLS On, Text On, appendix on colors

Example

       ' Prints the phrase "John; slept here."
       say "John "; "slept "; "here."

       ' Prints a blank line.
       say
       ' Prints the first command line parameter.
       say "%1"
       ' Prints literally due to tilde.

       say "~<blink>This won't blink.  ~"This is quoted.~""
       ' Prints in color.
       say "<bright blue>Hey, dude!"
       ' Prints message and path right next to it.
       say "<bold>Your path is:"; "%path%"



Set

Format

       SET StrExp1 = StrExp2

What it does

     Alters or creates an environment variable.

What it's for

     Many programs change or check environment variables.  While
     SET is technically not a batch statement, it's included for
     the sake of compatibility.

     BUILDERlite extends the concept by allowing you to replace
     the normal string constants used by the batch language with
     BUILDERlite string variables; you can use them with Input,
     for example.

Technical Note

     The SET statement in interpreted batch doesn't require
     quotes for string constants, but BUILDERlite does.  If the
     input file ends in .BAT, Importing or compiling at the
     command line creates a new file ending in .BLD with the
     conversion performed automatically.  See appendix on import,
     for more detailed information.

     Your BUILDERlite will issue an "Out of Environment Space"
     message if there isn't enough memory left in the environment
     for the new value.  DOS will force StrExp1 to uppercase but
     StrExp will remain unchanged.

See also

     EnvAvail, IF, Say

Example

       '  Illustrates the Set command.
       Cls
       Say@7,5"Can I add a SONNY; environment variable to your
       system (y/n)?"
       GetYN
       If Errorlevel 1 SONNY
       If Errorlevel 0 Exit

       Sub SONNY
         Str1 := "SONNY"
         Str2 := "temp"
         Set Str1 = Str2
         SET
       end


SHIFT

Format

       SHIFT

What it does

     Bumps all command line parameters by one:  %1 becomes the
     second command line parameter, %2 becomes the third, and so
     on.

What it's for

     Allowing %0-%9 to stand in for more than 10 command line
     parameters.

See also

     UnShift

Example

       '  Demonstrates the Shift and Unshift commands.

       Cls
       Text Bright blue on Black
       Say @5,1"These command line parameters appeared in this
       order at the"
       Say @6,1"execution of this program: ";
       Echo %1 %2 %3
       Wait 54

       Text Bright red on Black
       Say @8,1"Now we'll bump them down one using the Shift
       command."
       Shift
       Say @9,1"They now appear: ";
       Echo %1 %2 %3
       Wait 54

       Text Bright yellow on Black
       Say @11,1"Now we'll bump them down one more using the
       Shift command."
       Shift
       Say @12,1"We're down to the last one: ";
       Echo %1 %2 %3
       Wait 54

       Text Bright blue on Black
       Say @14,1"Lets put them back in order with two Unshift
       commands."
       Unshift
       Unshift
       Say @15,1"They're back to: ";
       Echo %1 %2 %3 just like before!."



Sleep

Format

       Sleep NumExp
What it does

     Suspends all activity for the number of clock ticks
     designated by NumExp, or until a key is pressed.

What it's for

     Suspending the execution of your BUILDERlite script for a
     specific period of time.  Sleep differs from Wait in that
     Sleep can be interrupted by a keystroke.

Technical Note

     There are 64K (65,536) ticks in one hour, so one second is
     equal to 18.204 ticks.

See also

     Wait, SleepUntil, WaitUntil

Example

       ' Suspend all activity for 10 seconds
       Sleep 182



StrDateToLong

Format

       LongIntVar := StrDateToLong StrExp

What it does

     Converts a string expression, a date, to a packed long
     integer value and copies that value to a longint variable.

What it's for

     Converting dates, in readable string formats, to long
     integers for comparisons.

Note

     Granularity for conversion of a date string expression is 1
     day.

See also

     StrTimeToLong, SysDateToLong

Example

       'Example for StrTimeToLong, StrDateToLong and conversion
       features.
       LongInt1 := StrTimeToLong "11:01:02"
       Str1 := LongtoTimeStr LongInt1
       Say Str1
       LongInt2 := StrDateToLong "12-31-1990"
       Str2 := LongToDateStr LongInt2
       Say Str2
       getkey


String

Format

       String StrVar [, StrVar...]

What it does

     Declares string variables for later use with other
     BUILDERlite commands.  You can declare several string
     variables in a list by separating their names with commas.

What it's for

     Allocating space for storing and retrieving string variables
     which are required or desired in BUILDERlite scripts.

Notes

     Some key items to note concerning declaring variables:

            1. All variable declaration statements (File,
               Integer, LongInt, and String) must be at the start
               of your BUILDERlite script.
            2. The variable can't be the same as a BUILDERlite
               reserved word, such as Run, String, or ECHO.  (See
               the reserved word appendix for a complete list of
               BUILDERlite reserved words.)
            3. The variable name must start with a letter.  The
               following characters may be either numbers,
               letter, or an underscore.
            4. There can be more than one variable listed after
               the type, and they must be separated with commas.
            5. The variable name can be no longer than 32
               characters.  It can be as short as one character.

     Variable names are case-insensitive, so string1 and STRING1
     are considered equivalent names.

See also

     File, Integer, LongInt

Example

       '  This example shows the use of String variables.
       Cls
       Say @5,5"Please enter your name      ";
       Input Str1
       Str1 := UpperCase Str1
       Say @7,5"You said your name is:      ";Str1
       Wait 54

       Str2 := "Howdy "
       Say @ 9,5 "By adding two strings together I can say
       hello."
       Str3 := Str2+Str1
       Say @11,35 Str3`
       Wait 54

       Say @14,5"We can even check to see if a string contains
       certain elements."
       If Str3 Contains Str1 Say @16,30"Hey, ";Str1;" is part of
       ";Str3
       If not (Str3 contains Str1) Say @16,25"Hey, something went
       wrong in this example."
       Sleep 54



StrTimeToLong

Format

       LongIntVar := StrTimeToLong StrExp

What it does

     Converts a string expression, a time, to a packed long
     integer value and copies that value to a longint variable.

What it's for

     Converting times, in readable string formats, to long
     integers for comparison as needed.

See also

     StrDateToLong, SysTimeToLong

Example

     See the example for StrDateToLong



StrToNum

Format

       NumVar := StrToNum StrExp

What it does

     Converts a string expression to an integer or long integer
     value and stores the result in an integer or longint
     variable.  The number may contain a unary plus or minus sign
     and embedded commas.

What it's for

     Converting character strings to numeric strings.  Also
     allows numeric data entry, since BUILDERlite doesn't support
     INTEGER or LONGINT variables using the INPUT statement, they
     can be entered as strings and converted.

See also

     CharToNum, IntToStr, LongToStr

Example

       Say "Please enter a number (less than 32,767)
       ";
       Input Str1
       say "Please enter a great big number (less than
       2,147,483,648) ";
       Input Str2
       ' Convert first string to a number.
       Int1 := StrToNum Str1
       say "The number you entered was: "; Int1
       ' Convert seconfd string to a number.
       LongInt1 := StrToNum Str2
       say "The great big number you entered was: ";LongInt1



Stuff

Format

       Stuff StrExp

What it does

     Writes a string expression to the computer's keyboard
     buffer.  Limited to 15 characters (the DOS keyboard buffer
     maximum).

What it's for

     Starting a program without user interaction, or faking
     command line parameters for programs that otherwise don't
     accept them.

See also

     Appendix on Keystroke Constants

Example

       '  This will run a directory of drive C:
       Stuff "C:\"
       Run Dir



Sub

Format

       Sub <sub name>
         <statement>
       End

     <sub name> consists of at least one letter followed by one
     or more letters and numbers (no other characters, especially
     spaces, are allowed).  The maximum length of an identifier
     is 32 characters.

What it does

     A Sub, or sub-routine, allows you to extend the language by
     collecting groups of frequently used statements into an
     executable routine and calling them by name.

What it's for

     Saving code space and making your programs more readable,
     and more powerful.

Notes

               1.   To use a Sub in the program, put the
               subroutine name on a line by itself.
            2. Sub definitions must come after all other program
               code.  The following is illegal:
       sub Way
         say "This is subroutine Way"
       end

       say "This code will never execute."

               3.   Subs may not be nested:  constructs like this
               are illegal:

       Sub <identifier>
         <statements>
           Sub <identifier>
           End
       End

               4.   It's considered good form to create a uniform
               comment listing consisting of  A) The subroutine
               name,  B) a description of its purpose,  C) a
               listing of all global variables it requires and
               their types, in alphabetical order, and D) a
               listing of all other Subs this Sub uses, also in
               alphabetical order.

Example

       say "About to run SUB Continue."
       Continue
       say "Going to run it again."
       Continue
       ' Program exits here if user didn't press Y either time.
       '============================================
       ' SUB Continue
       '
       ' What it does:
       ' Puts up a dialog allowing the user to interrupt the
       program.
       ' Globals affected:
       '   None
       ' Other routines called:
       '   None
       '============================================

       sub Continue
          Double Box 10, 20, 40, 5 bright red on black
          say @ 12, 22 "<blink>Would you like to exit the
       program? ";
          GetYN
          ' Since it's a premature exit, set ERRORLEVEL to 1
          if errorlevel 1 exit 1
       end ' Sub Continue



SysDateToLong

Format

       LongIntVar := SysDateToLong

What it does

     Converts the system date; to a packed long integer value and
     copies it to a longint variable.
What it's for

     Obtaining the current system date for use in your
     BUILDERlite scripts.  Useful in timing routines and
     comparisons as needed.

Note

     Granularity of system date comparison is one day.

See also

     LongToDateStr, SysTimeToLong

Example

     See the example for LongToDateStr



System

Format

       System StrExp

What it does

     Passes StrExp to COMMAND.COM as a command line.  StrExp can
     be either a string variable or a quoted string constant.

What it's for

     System allows you to execute a program contained within a
     string.  It's of great use with a string variable; you can
     request the name of a program from a user, or create a
     command line on the fly.

     System doesn't allow you to check the ERRORLEVEL returned by
     the program run.  That's because System runs a secondary
     copy of COMMAND.COM and that copy consumes the ERRORLEVEL,
     then returns an ERRORLEVEL for COMMAND.COM, not the program
     run.

Notes

     System differs from Run in that Run treats the rest of the
     line as literal text, whereas System treats the entire line
     as a string expression.  In the second example shown below,
     DIR is a string variable.  It will first execute a directory
     when used with RUN, then will stand in place of "CHKDSK".

     System executes a string expression, which means that the
     string expression must conform to the syntax of an
     expression.  In other words, this is legal:

       system "Dir " + "*.bak"

     But this is not:

       system DIR *.BAK

See also

     Run
Example

     See the example for RUN



SysTimeToLong

Format

       LongIntVar := SysTimeToLong

What it does

     Converts the system time; to a packed long integer value and
     copies it to a longint variable.

What it's for

     Obtaining the current system time for use in your
     BUILDERlite scripts.  Useful in timing routines and
     comparisons as needed.

Note

     Granularity for comparison of the system time is 1 second.

See also

     LongToTimeStr, SysDateToLong

Example

     See the example for LongToTimeStr



Text On

Format

       TEXT <text color> On <background color>

What it does

     Sets the standard foreground and background colors.  Both
     <text color> and <background color> may be color constants,
     such as WHITE or BLUE, or they may be integer expressions.

     After each SAY statement, text attributes are reset to these
     values, not the default white-on-black color scheme
     BUILDERlite uses when the TEXT statement is not used.

What it's for

     Most commonly, putting text in colored boxes. Metacharacters
     such as "<black>" or "<bright blue>" only affect the text
     (foreground) color, not the background color.

Permissible colors

     These are the available colors.  They can be used for either
     the text color or the background color:

     Standard colors
     Black, Blue, Brown, Cyan, Green, Magenta, Red, White
     The following colors can also be used for the text color
     (but not the background color):

     Bright Blue, Yellow, Bright Cyan, Bright Magenta, Bright
     Red, Bright White

     Color/integer equivalents
     0    Black               8    Gray
     1    Blue           9    Bright Blue
     2    Green               10   Bright Green
     3    Cyan           11   Bright Cyan
     4    Red            12   Bright Red
     5    Magenta        13   Bright Magenta
     6    Brown               14   Yellow
     7    White               15   Bright White

See also

     CLS On, Say

Example

       '  This demonstrates the use of literal colors and their
       '  integer equivalents.  Notice that changes to colors are
       '  made within a Say statement, and then reset.
       Cls
       Text blue on green
       Say@5,5"We now see blue text on a green background."
       Text red on black
       Say@10,10"But this is red on black."
       Text 15 on 6
       Say@15,5"This looks odd, but is bright white on brown."
       Text 0 on 1
       Say@20,10"You can barely <white>read <normal>this black on
       blue."



Trim

Format

       StrVar := Trim StrExp

What it does

     Removes leading and trailing spaces and tabs from a string
     expression, and copies the result into a string variable.

What it's for

     Ensuring consistency of user input.

Note

     New line characters are also removed, although BUILDERlite
     does not allow you to embed them in a string.

See also

     LTrim, MidStr, RTrim

Example

     See the example for LTrim


Unshift

Format

       UNSHIFT

What it does

     Ratchets all command line parameters back by one:  %3
     becomes the second command line parameter, %4 becomes the
     third, and so on.

What it's for

     Reversing the effect of a Shift.

See also

     Shift

Example

     See the example for Shift



UpperCase

Format

       StrVar := UpperCase StrExp

What it does

     Forces the characters in a string expression to uppercase,
     and copies them to a string variable.

What it's for

     Makes string comparisons easier.

See also

     LowerCase

Example

     See the example for LowerCase



Use BIOS

Format

       Use BIOS

     (the default is Use BIOS)

What it does

     Use BIOS selects BIOS services for text output.

What it's for

     Using BIOS allows you to speed the screen output of compiled
     programs.  It's doesn't allow redirection of screen output.
See also

     Use DOS

Example

       Use BIOS



Use Commas

Format

       Use|Dont Use Commas

     (default is USE Commas)

What it does

     BUILDERlite formats integers and long integers with commas.
     You can disable this feature with Don't use commas, and
     enable it with Use Commas.

What it's for

     Allows you to output numbers with or without commas.
     Reading the amount of free disk space is easier with commas;
     integer and long integer expression comparisons may be
     easier without commas.

Note

     The default choice is Use Commas.

Example

       say "This will print 9,999,999: ";
       Say 9999999
       say

       say "This will print 9999999: ";
       Don't use commas
       Say 9999999
       say

       say "This will print 9,999,999: ";
       Use commas
       Say 9999999



Use Cursor

Format

       Use|Dont Use Cursor

What it does

     Turns the cursor on, or off.

What it's for

     Gives you the ability to eliminate the DOS cursor that
     blinks on the screen.  Masking the DOS cursor will enhance
     the look of your BUILDERlite menu programs.
Note

     The default choice is Use Cursor.

See also

     MouseHideCursor, MouseShowCursor

Example

       '  This example will demonstrate the Use/Dont Text Bright
       white on Black
       Cls

       Use Cursor
       Single Box 6,10,60,5 Blue on Black
       Say@8,12"This example shows a blinking cursor.  Annoying,
       eh Denise;?"

       Say@12,10"Strike any key to continue."
       Pause

       Dont Use Cursor
       Single Box 15,10,60,5 Green on Black
       Say@17,12"This example doesn't show the cursor.  Much
       better, huh Denise!"



Use DOS

Format

       Use DOS

What it does

     Use DOS selects DOS services for text output.  The default
     is Use BIOS.

What it's for

     Using DOS allows you to redirect the output of compiled
     programs to a disk file.  It's a bit slower, however, than
     BIOS text output (which doesn't allow redirection).

Technical Note

     DOS services have two disadvantages from BIOS and Direct.
     Screen positioning (via GoToXY, RowCol, etc.), and colors
     are not supported.

See also

     Use BIOS

Example

       Use DOS



Use Encryption

Format

       Use|Dont Use Encryption
What it does

     Encrypts text information in a BUILDERlite compiled file.

What it's for

     Making text strings unreadable to anyone trying to view the
     contents of a BUILDERlite created .EXE file.  Allows you to
     "hide" passwords or program file names, etc. inside of your
     compiled BUILDERlite programs.

Note

     When the USE Encryption command is issued, all text that
     follows will be stored in the .EXE file in an encrypted
     format.  If the file is viewed by either listing the file
     with the DOS TYPE command or with a file editor, the text
     that was encrypted becomes unreadable.  This means that your
     users cannot read passwords or any other encrypted text
     stored in your compiled BUILDERlite program.

     Placement of Use Encryption is crucial.  Any variable
     assignments (via the := or Put commands) that occur before a
     Use Encryption command will not be encrypted in the .EXE
     file; users will be able to see the value of these
     variables.  We reccommend that files requiring encryption
     make a call to the command immediately after your variable
     declarations.

     When Use Encryption is invoked, compiled code size will be
     increased slightly because of the overhead required to
     decrypt each encrypted string at runtime.

See also

     Password

Example

       Use Encryption
          Password "Paul;'s Little Monkey"
          If errorlevel 1 Say"Right - you win the parlay."
          If errorlevel 0 Say"Wrong - No money for a room
       tonite."
       Dont Use Encryption



VideoMode

Format

       IntVar := VideoMode

What it does

     Queries the system for the BIOS videomode currently in use.

What it's for

     Exact determination of video mode according to BIOS.

Returns

     Returns the video mode as an integer value.
                              Text/
            Resolution   Clrs Graphics            Returns

            40 X 25      16   Text           0
                 (no color burst)
            40 X 25      16   Text           1
            80 X 25      16   Text           2
                 (no color burst)
            80 X 25      16   Text           3
            320 X 200    4    Graphics       4
            320 X 200    4    Graphics       5
                 (no color burst)
            640 X 200    2    Graphics       6
            80 X 25      2    Text           7
            160 X 200    16   Graphics       8
            320 X 200    16   Graphics       9
            640 X 200    4    Graphics       10
            320 X 200    16   Graphics       13
            640 X 200    16   Graphics       14
            640 X 350    2    Graphics       15
            640 X 350    4/16 Graphics       16
            640 X 480    2    Graphics       17
            640 X 480    16   Graphics       18
            320 X 200    256  Graphics       19


See also

     Adaptor

Example

       Int1 := VideoMode
       say "VideoMode is ";Int1
       If Int1 == 3
         say"You are running in 80 x 25 mode, please continue."
       end else
         say"You are not running in 80 x 25 mode, please
       terminate this session."
       end



Wait

Format

       Wait NumExp

What it does

     Suspends all activity for the designated NumExp of clock
     ticks.

What it's for

     Suspending the execution of your BUILDERlite script for a
     specific period of time.  Wait differs from Sleep in that
     Wait cannot be interrupted by a keystroke.

Technical notes

     There are 64K (65,536) ticks in one hour, so one second is
     equal to 18.204 ticks.  BUILDERlite does not support
     decimals.

See also

     Sleep, Pause, SleepUntil, WaitUntil

Example

       say@10,10"<bright blue>We will now wait 3 seconds."
       wait 55
       Say@12,10"<bright green>Take a moment to think about
       deleting all those files..."
       wait 55
       Say@14,10"<bright red>Please remove Disk One from Drive A"
       wait 55



WhereX

Format

       IntVar := WhereX

What it does

     Locates the cursor and reports on its screen row position.

What it's for

     To store the current location of the cursor for possibly
     restoring its position after moving it around the screen.
     Used most often with WhereY, which returns the row number,
     to get the exact current cursor position.

Returns

     Returns the column number in which the cursor is located.

See also

     Integer, WhereY, GoToXY, RowCol

Example

       say @20,20 "Please Make a Selection:  ";
       Int1 := WhereX
       Int2 := WhereY

       :TestInput
       GetKey
       if LastKey is {B} goto BUILDERlite
       if LastKey is {b} goto BUILDERlite
       if LastKey is {L} goto Lotus
       if LastKey is {l} goto Lotus
       if LastKey is {W} goto Word
       if LastKey is {w} goto Word
       if LastKey is {Esc} exit
       Beep
       say @21,21 "Please make the appropriate choice."
       GotoXY WhereX,WhereY
       Goto TestInput



WhereY

Format

       IntVar := WhereY
What it does

     Locates the cursor and reports on its screen column
     position.

What it's for

     To store the current location of the cursor for possibly
     restoring its position after moving it around the screen.

     Used most often with WhereX, which returns the current
     column number, to get the exact current cursor position.

Returns

     Returns the row number in which the cursor is located.

See also

     Integer, WhereX, GoToXY, RowCol

Example

     See the example for WhereX



While

Format

       While Comparison
          <statement>
       End

     <statement> can represent any valid BUILDERlite commands,
     including DOS and Batch commands and external program
     commands preceded by Run.

What it does

     Tests Comparison.  If and only if it evaluates to zero,
     control passes to the statement following the end statement.
     If nonzero, <statement> are executed and the test is
     performed again.

What it's for

     Executing the same command over and over again until the
     Comparison is no longer true.

     Comparison doesn't have to consist of numbers.  Any
     relational or equality test will suffice.  For example,
     these are all good While statements:

       While "%1" <> "%2"

       While LastName < "Conrad;"

       While A is 0

       While x <> 1

     Note that if NOT is used, the expression following should be
     surrounded with parentheses, unless you want to apply NOT to
     the first value as a unary operator:
       While not (StrA is "Denielle;")

       While not (X - Z == 999)

See also

     Case, For, Repeat

Example

     This is a simple test which will ensure that an unauthorized
     user (defined as someone who does not know the password)
     cannot execute this program.

       ' Accepts input from user and displays it until the user
       '  enters "quit" in all lowercase.
       Str1:= ""

         ' Continue doing this until the user enters "quit" in
         ' lowercase.
         While STR1 <> "quit"
           ' Ask for some input. Wait for the user to type something and
           ' press {Enter}.
           Say "What's your ID? ({Esc} quits) ";
           ' Copy the user's input into STR1.
           Input STR1
           ' Print a blank line.
           Say
           ' Quit if user canceled input with {Esc}.
           If Canceled exit 0
           ' Unless the user wants to quit, print "Hi, " followed by
           ' the user's input.
           If STR1 <> "quit"
             Say "Hi, "; STR1
            ' Go back up to the While
           end else
             ' Return to DOS.
             Exit 0
           End
         End

Glossary:



     activate:  See select

     background color:  the foreground color is the color of the
     text itself in a character cell; the background color is
     color of the field it's displayed on.

     blank:  A common programming term meaning either a space
     character, a tab character, or any combination of the two
     together.  Sometimes blank lines are included in this group,
     but not by BUILDERlite.

     block:  The BUILDERlite editor has a number of commands that
     operate on a previously marked block, which consists of any
     number of contiguous characters selected via the {Ctrl K-B}
     combo or the {Shift} and arrow key combination.

     ClipBoard:  The ClipBoard is an invisible area of memory
     that holds a copy of the last text deleted or duplicated
     using the block delete or duplicate commands.

     code:  One or more lines of a program.  May also be used as
     a verb; to code means to program.

     .COM:  An executable file.  One segment contains all of the
     code, data, and stack used by the program.  It does not
     contain special header information that all .EXE files must
     have, so DOS does not release memory the .COM file doesn't
     use.

     command line parameters:  What you type after the program
     name when you invoke the program from the command line.  %1
     is the first parameter, %2 is the second, and so on up to
     %9.

     compound statement:  Any control structure or other
     statement requiring an End.  Compound statements include
     Case, DropDown, If, LightBar, PopUp, Repeat, Select, Sub,
     and While.  Compound statements are so called because they
     contain other statements.

     concatenate:  Appending one string to another.  This is done
     in BUILDERlite using the "+" operator (SAY "Pica" + "dilly"
     will print Picadilly) or using DOS variables:  The line SET
     "PATH" = "%PATH%;C:\BUILDER" will append C:\BUILDER to your
     current path.

     conditional statement:  Statements that make decisions:  If,
     Case, While, Repeat, DropDown, LightBar, PopUp.  They're
     called conditionals because the branch taken by the program
     isn't known until the program runs.

     control structure:  a program statement in which some sort
     of decision is made while the program is running.
     BUILDERlite control structures include DropDown, If, Select
     Case, While, etc.

     current item:  A menu item is said to be the current item
     when it's highlighted.

     declaration:  a program statement that sets aside memory for
     a value.  For example, STRING Filename sets aside the
     standard 256 bytes for a filename.
     DOS variable:  A term used in this manual to encompass both
     command line parameters and environment variables.  See
     command line parameter, environment variable

     DropDown menu:  a menu with all menu items in a single
     column and a box surrounding them.  The box has an optional,
     nonselectable title.  See also LightBar menu, menu, and
     popup menu

     environment:  The DOS environment is an area of RAM set
     aside for programs.  It's arranged as text in the form
     <environment variable>=<value>, where <environment variable>
     and <value> are any text strings.  See also master
     environment

     .EXE:  An executable file that can run up to a megabyte in
     size.  .EXE files contain separate segments for code, data,
     and stack, and supports multiple segments for each.  .EXE
     files contain special header information at the front of the
     file that allows DOS to make intelligent use of the memory
     occupied by the .EXE file, and to deallocate memory the file
     doesn't need.  BUILDERlite supports the .EXE format for some
     networks, which need relocatable program files.  See also
     executable, segment.

     executable:  The term BUILDERlite executable in this manual
     means any .EXE file created by BUILDERlite.

     false:  in BUILDERlite, a condition is thought to be false
     if it evaluates to zero, and true if it evaluates to a
     nonzero value.

     flag:  a variable that "toggles" between only two possible
     values; it's normally a zero vs. nonzero, or false vs. true,
     set of values.

     foreground color:  the color of the text itself in a
     character cell; the background color is color of the field
     it's displayed on.

     function:  a routine that returns a value.  While the
     BUILDERlite language does not currently allow you to write
     functions, it has many functions built in.  For example, the
     DiskFree function executes a routine to check the amount of
     available disk space, then returns that value as a Longint.
     Returning a value means to copy that value into a variable
     of the user's choice.

     hotkey:  The shortcut key used to activate a menu item when
     the <immediate trigger> parameter of Menu Style is 1.  When
     it's 0, the hotkey moves the highlight to the menu item but
     does not activate it.  The hotkey is normally displayed in a
     different color from the other letters in the menu item.

     identifier:  The name of something.  For example, if you use
     a subroutine called CountRecords, that's its identifier.
     Identifiers are usually for variable names, subroutine
     names, and the targets of GOTO labels.

     initialize:  To set something to a known value.

     insert state:  You do not replace text to the left of the
     cursor as you type.  Instead, it's pushed to the left.

     integer:  In BUILDERlite and most computer languages, an
     integer is treated slightly differently from classical
     mathematics.  Integers are always whole numbers (they have
     no fractional or decimal part), but on computers their
     ranges are limited.  A BUILDERlite integer has a limited
     range
     (-32,768 to 32,767 for integers, and -2,147,483,648 to
     2,147,483,647 for longints).

     item:  Words or phrases on a menu that can be highlighted
     with the arrow keys or mouse.  See also:  current item,
     NestedItem.

     LightBar menu:  a menu with all menu items in a single row,
     resembling a Lotus 1-2-3 Menu.  See also DropDown menu,
     menu, and popup menu

     link:  To knit the .OBJ output from a compiler or assembler
     together into an executable program.

     logical expression:  an expression that must evaluate to
     zero (for FALSE) or one (for TRUE).

     master environment:  the environment of a program (typically
     COMMAND.COM) that calls another program.  DOS doesn't
     normally allow the called program to change the master
     environment, but BUILDERlite programs do so.

     menu:  A series of selectable text strings (menu items) that
     allow the user to choose an action by moving the cursor
     among them and selecting one.  Only one item may be
     selected, and only one item selected at a time.  BUILDERlite
     menus are integrated into the language as CASE-like control
     structures, so that program control mirrors the menu
     placement in the program.  Colors and behavior of menus are
     controlled with the Menu Style statement.  There are three
     kinds of BUILDERlite menus and unless otherwise stated the
     term menu applies equally to each:  DropDown menus, which
     list menu items in a box; LightBar menus, which operate like
     1-2-3 menus; and popup menus, which have no preset
     configuration and are customized by the programmer.  All
     menus use either the keyboard or a Microsoft-compatible
     mouse automatically.  See also DropDown menu, LightBar menu,
     and popup menu

     .OBJ:  An .OBJ file includes most of the information needed
     to create an executable file, except for unresolved
     addresses. Unresolved addresses are those not known at link
     time; for example, if your program has a routine called
     SortRecords, you can include references to SortRecords even
     when it's not written, as long as one of the .OBJ or .LIB
     files that make up the final link phase contains that
     routine.  It differs slightly from an executable file (or
     program) in that it contains extra information not needed by
     a program and, more important, can be set aside (as an .OBJ
     file) once that part of the program is debugged and not
     touched again until final linking. The advantage here is
     that large programs need not be completely recompiled;
     instead, they can be broken up into .OBJ files that act as
     "precompiled" program modules.

     origin:  the position and coordinate values on screen where
     horizontal and vertical measurements begin.  In BUILDERlite
     that value is (1, 1) and it's located at the upper left
     corner of the screen.  Other languages put  it in the same
     place but employ the less intuitive coordinates of (0, 0).
     overtype state:  In the editor, any text to the left of the
     cursor is replaced as you type in overtype state.

     PopUp menu:  a freeform menu with programmer-determined
     locations for each item.  PopUps have the same fundamental
     characteristics as DropDown and LightBar menus, but allow
     irregular placement of menu items for complete
     customization.  See also DropDown menu, LightBar menu, and
     menu

     program:  A compiled .BLD script, or any .COM or .EXE file.
     See also script.

     Replaceable parameters:  See command line parameters.

     runtime:  the period during which a program executes.  For
     example, if the user doesn't type in the correct command
     line parameters and your program fails because of it, a
     runtime error is said to have occurred.  But if you try to
     compile a program with the line Say Say a compiler error
     will occur, making it impossible to create an executable
     file.  This is said to be a compile-time error.

     script:  The source text for a BUILDERlite program.

     scroll:  To move all of the lines of text on screen (or in a
     window) up in unison.

     select:  To activate a menu item a menu item by moving the
     highlight to it and pressing {Enter} or the left mouse
     button.  If the <immediate trigger> parameter of Menu Style
     is 1 you can activate a menu item by pressing its hotkey.

     string:  A string is anything you can put between quotes.
     The quotes aren't thought to be part of the string; they
     merely delimit it.  Also called a string constant or string
     literal.

     true:  in BUILDERlite, a condition is thought to be true if
     it evaluates to a nonzero value, and false if it evaluates
     to zero.  See false

     variable:  A variable is a place set aside to hold
     information that can change when a program is running.
     There are string variables, integer variables (for whole
     numbers between -32768 and +32767), and longint variables
     (for whole numbers between -2,147,483,648 and
     +2,147,483,647).  BUILDERlite doesn't support numbers with
     decimals or fractions.  See also declaration, flag

Appendixes



About these appendixes

     This section contains the following appendixes:

     A. Colors:  Complete reference to the color capabilities and
     limitations of BUILDERlite.

     B. Commandline options:  Discussion of the commandline
     options of BLDLITE.EXE, the BUILDERlite compiler engine.

     C. Compatibility:  Discussion of compatibility between .BAT
     files / commands and BUILDERlite files / commands.

     D. Keystroke constants:  Listing of all keystroke constants
     supported by BUILDERlite.

     E. Keywords:  Listing of all Keywords and Reserved words.
     These words cannot be used as variable names in BUILDERlite
     scripts.

     F. Import:  Discussion of the BUILDERlite Import process
     that converts existing .BAT files to .BLD files for
     compiling.

     G. Limitations:  Explains maximum editor file size, line
     length, etc.

A.   Colors



     This section explains how BUILDERlite uses colors.  The
     following statements are affected:

            * Box (Single and Double)
            * CLS ON
            * DropDown
            * LightBar
            * Menu Style
            * PopUp
            * Say
            * Text

How colors are used

     First, let's get some terminology straight.  All characters
     on the screen are thought to have two colors or attributes:
     foreground and background.  On the IBM PC the terms color
     and attribute are often used interchangeably because a
     monochrome screen has only two colors, and instead uses
     characteristics such as underlining and boldface to stand in
     for colors.  This manual treats the terms as equivalent.

     The foreground color is the color of the text itself in a
     character cell; the background color is the color of the
     field it's displayed on.

Color limits

     The IBM PC was originally limited to 16 colors for the
     foreground and 8 of those 16 for the background.  Because of
     this, BUILDERlite adheres to those limits and doesn't
     currently take advantage of extended text modes in the EGA
     and VGA adaptors.

     We'll refer to the 8 colors that can be used on both
     foreground and background as the standard colors.  Here they
     are.

     Standard colors
     Black, Blue, Brown, Cyan, Green, Magenta, Red, White

     The following colors can also be used for the foreground
     colors only:

     Bright colors
     Bright Blue, Yellow, Bright Cyan, Bright Magenta, Bright
     Red, Bright White

How BUILDERlite scripts specify color

     To use colors in a BUILDERlite script, you normally just
     supply the name of the color, like this:

       ' Clear the screen to blue.  Make text bright white.
       CLS Bright white on Blue

     The Box, CLS On, Menu Style, and Text On statements all use
     this method of specifying colors.

     The Say statement is an exception.  Inside quotes you insert
     the name of the foreground text color in angle brackets,
     like this:
       Say "<bright red>Error!"

     This displays the word Error! in bright red text on a black
     background (unless the CLS On or Text On statements have
     been used).

     These color names, called metacharacters, only apply to the
     foreground colors.  You can't change the background color of
     Say using metacharacters;; you must instead use CLS On or
     Text On.  Since those statements reset the text foreground
     and background color until explicitly changed, you can use
     them instead.  For example, the following will print "hello,
     world." on a blue background.  The first line will appear in
     white letters, the second line will appear in yellow
     letters.

       ' Shows in white on a black background.
       Say "hello, world."
       Text yellow on blue
       ' Shows in yellow on a blue background.
       Say "hello, world."
       ' Shows in cyan on a blue background.
       Say "<cyan>hello, world."

Color by number

     BUILDERlite also allows you to specify colors using their
     integer equivalents (not with metacharacters in a Say
     statement, however).  For historical and hardware reasons
     they are:

     Color/integer equivalents
     0    Black               8    Gray
     1    Blue           9    Bright Blue
     2    Green               10   Bright Green
     3    Cyan           11   Bright Cyan
     4    Red            12   Bright Red
     5    Magenta        13   Bright Magenta
     6    Brown               14   Yellow
     7    White               15   Bright White

     Therefore the following statements are equivalent:

       CLS Bright white on blue
       CLS 15 on 1

     The advantage to using numbers is that you can change colors
     dramatically using a REPEAT loop.  However, BUILDERlite
     can't stop you from using illegal values, such as those over
     15 for the foreground or over 7 for the background.  The
     results of using illegal values aren't predictable.

     The advantage to using color names, such as Bright White or
     Cyan, is that they're much easier to understand, and because
     BUILDERlite can ensure the colors are valid ones at compile
     time.

Metacharacters and menus

     BUILDERlite's Say statement lets you embed colors using
     metacharacters.  They won't work on menu items, however.
     Menu items employ the color set shown in the Menu Style.  An
     item that looks like this:
       LightBar
         Item "<cyan>Colored item"
       End

     Will not appear in the color specified by the metacharacter
     (cyan, in this case).  Instead, the menu items are all
     displayed uniformly in the Menu Style colors.  This insures
     the consistency of menus.

B.   Commandline Options



     This section explains command line options for BLDLITE.EXE, the
     BUILDERlite compiler, and BUILDER.EXE, the BUILDERlite
     integrated environment.


BLDLITE.EXE:  The commandline compiler


     Here's a summary of the BUILDERlite commandline compiler
     options:

            Option       Purpose

            -?           Show command line help

            -c           Compile to .OBJ only; do not link

            -h           Show command line help


     Here's what those options are for.

-? and -h

     The online help options simply print a few lines describing
     each of the command line options and shows a few examples of
     those options at work.

-c

     The -c option means create an .OBJ file.  This is for those
     times when you'll want to use a different linker, or link
     your code into other language applications, or link multiple
     .OBJ modules.  This switch will stop the compile step at the
     creation of an .OBJ file.


C.   Compatibility;



About this appendix

     This appendix discusses how BUILDERlite deals with DOS
     compatibility issues.

General notes

     Memory-resident programs;:  You shouldn't run memory-
     resident programs such as Sidekick or PRINT.COM from within
     a compiled program.  They'll work, but memory occupied by
     the compiled program will not be reclaimed when it exits
     back to DOS.  If the TSR's are unloaded before exiting the
     compiled programs the memory will be released.

     Program size;:  Unlike .BAT files, while the program is
     running it takes up code space.  If your batch file is 7K
     long and it runs a program, none of that memory is taken up
     (COMMAND.COM only uses a line at a time, and saves the line
     number when it runs a program).  However, every byte of the
     15K file such a program might compile to is taken up for the
     duration of the program.  So if you run a word processor
     from within the file, you will have all of DOS's free
     memory, minus the amount taken by the compiled program, to
     work with.

@

     The "don't echo this line" character is implied in
     BUILDERlite, so you don't need to include it in your
     programs (Import just strips it out).

%0

     BUILDERlite can't find %0 on DOS version 2.x, or any
     previous version.

CALL

     BUILDERlite always returns when a batch file is executed, so
     the CALL statement is superfluous.

ECHO .

     ECHO .  prints a blank line, in emulation of some versions
     of the interpreted batch language.

ECHO ON/OFF

     Ignored by BUILDERlite.

FOR

     Parentheses in the FOR statement must be replaced by double
     quotes, and any non-batch command, or non-BUILDERlite
     command, after it must be preceded by a Run.  Import does
     this automatically.  This line from a batch file:

       ' .BAT file:
       FOR %%c IN (*.asm *.txt) DO DIR %%c

     is automatically converted to:
       ' .BLD file after auto conversion:
       FOR %%c IN "*.asm *.txt" DO run DIR %%c

     Although Import does this automatically when it converts
     .BAT files to .BLD files, you'll need to make these changes
     yourself when adding new FOR statements to your .BLD
     programs.

     See Appendix on import, for details.

GOTO

     The target label of a GOTO may not contain spaces or tabs,
     or be a BUILDERlite reserved word.

GOTO %

     GOTOs to a label created while an interpreted batch file is
     running, such as GOTO %1, won't work.  BUILDERlite must know
     at compile time where the label is.

IF

     IF <string> == <string> statements must use double quotes
     surrounding each string, and spaces must surround the ==
     operator (Import does this automatically).  In other words,
     this line

       ' .BAT file:
       IF %env%%1==ENVARPARAM1

     is automatically converted to:

       ' .BLD file after auto conversion:
       IF "%env%%1" == "ENVARPARAM1"

     Import alters IF <string> == <string> statements by
     enclosing the strings in double quotes.  Any quotes inside
     those quotes are replaced with the caret character (^).
     Although Import does this automatically when it converts
     .BAT files to .BLD files, you'll need to make these changes
     yourself when adding new IF <string> == <string> statements
     to your programs.

     Likewise, the subject of an IF EXIST must be quoted:  IF
     EXIST %1 becomes IF EXIST "%1".

     See appendix on import, for details.

Labels

     DOS GOTO labels are significant to only eight characters.
     BUILDERlite labels are significant up to 32 characters.  You
     may not use a BUILDERlite reserved word as a label.

NOT <string> = <string>

     An IF NOT <string> == <string> gets converted to IF NOT
     (<string> == <string>) because NOT is a unary operator in
     BUILDERlite.

PAUSE

     The PAUSE does not display the "Strike a key when ready..."
     message.
REM

     Interpreted batch files display REM statements just like it
     does ECHO statements.  BUILDERlite never displays REM
     statements.

D.   Import



About this appendix

     This appendix discusses the Import feature of Builderlite.

     When Builderlite works with a .BAT file, Import
     automatically converts it from .BAT syntax to .BLD syntax
     and assigns a .BLD file extension.  Builderlite only
     compiles .BLD files.  Working with your .BAT files in
     Builderlite requires that you understand the conversion
     process and do any additional editing to the .BLD file using
     Builder syntax conventions before compiling it.

            1. Any non-batch or non-Builderlite statement must be
               preceded by Run, whereas interpreted batch files
               simply drop those statements to DOS.  So the line
               CD \ would change to Run CD \.
            2. IF <string> == <string> tests must use quotes
               around the strings.  Embedded quotes must be
               changed to caret (^) characters.
            3. IF EXIST <string> must be quoted:  the filespec to
               be tested is surrounded by double quotes.  So
               this:

       IF EXIST %TMP%%1 DEL %TMP%%1

     Becomes this:

       IF EXIST "%TMP%%1" RUN DEL %TMP%%1

            4. The parentheses; in a FOR; statement must be
               replaced by double quotes.  So the line FOR %%f in
               (*.doc) DO DIR %%f is replaced by FOR %%f in
               "*.doc" DO Run DIR %%f.

     Multiple blanks between parts of an IF or FOR statement are
     replaced by a single space, so this:

       IF    EXIST    %TMP%%1     DEL %TMP%%1

     Becomes this:

       IF EXIST "%TMP%%1" RUN DEL %TMP%%1

            5. Items on either side of the equals sign in a SET
               statement must be quoted.  For example, this line:

       SET LIB=C:\BIN

     Becomes:

       SET "LIB"="C:\BIN"

            6. IF NOT <string> == <string> becomes IF NOT
               (<string> == <string>), since NOT is a unary
               operator in Builder and applying it to a string
               makes no sense.

E.   Keystroke Constants



Format

       {key name}    (A key name in curly braces)

What they are

     BUILDERlite treats any key, whether it's standard ASCII such
     as a letter or punctuation mark or an extended return value
     such as {F1} or {PgDn}, as a single keypress.  Extended keys
     return 256 times their extended value.  So, for example,
     {F1}, which has an extended value of 59, is treated by
     BUILDERlite as 59*256, or 15104.  You can use that value in
     an IF LastKey test, but keystroke constants are a much
     better solution.  They substitute for integer constants when
     using IF LastKey for tests.

What they're for

     Keystroke constants make your programs quite a bit easier to
     understand.  You can use names instead of numbers when
     designing menu systems.  Instead of using the code fragment:

       IF LastKey is 15104

     in a program, you can use this instead:

       IF LastKey is {F1}

Legal key names

     ASCII keys
     Any single printable character may appear in curly braces in
     place of its ASCII value:  {A}, {z}, etc..  Note that the
     value is case sensitive:  {a} and {A} are different values
     (ASCII 97 and 65, respectively).  Also, the {Alt} and {Ctrl}
     keys can be used in combination with the alphabetic keys,
     and {Alt} can be used in combination with numeric keys.

     Extended keys
     Here's a list of permissible keystroke constant names for
     extended keys:

     Function Keys:

       {F1}         {F2}      {F3}      {F4}      {F5}
       {F6}         {F7}      {F8}      {F9}      {F10}

       {Alt-F1}          {Alt-F2}       {Alt-F3}       {Alt-F4}
       {Alt-F5}          {Alt-F6}       {Alt-F7}       {Alt-F8}
       {Alt-F9}          {Alt-F10}

       {Shift-F1}        {Shift-F2}     {Shift-F3}     {Shift-F4}
       {Shift-F5}        {Shift-F6}     {Shift-F7}     {Shift-F8}
       {Shift-F9}        {Shift-F10}

       {Ctrl-F1}         {Ctrl-F2} {Ctrl-F3} {Ctrl-F4}
       {Ctrl-F5}         {Ctrl-F6} {Ctrl-F7} {Ctrl-F8}
       {Ctrl-F9}         {Ctrl-F10}

     Cursor Keys:
       {Home}       {End}          {Up}      {Down}
       {Left}       {Right}        {PgUp}         {PgDn}

       {Ctrl-Home}       {Ctrl-End}     {Ctrl-Left}    {Ctrl-
       Right}
       {Ctrl-PgUp}       {Ctrl-PgDn}

     Other Keys:

       {Esc}        {Insert}       {Delete}
       {Ins}        {Del}          {Enter}

F.   Reserved words



About this appendix

     This appendix lists all of the BUILDERlite reserved words.
     Use of these reserved words as label names, subroutine
     names, or variable names in your BUILDERlite scripts will
     result in fatal syntax errors.

       Adaptor
       And
       an
       answer
       array
       as
       ask
       at

       background
       Beep
       BCFAdd
       BCFCopy
       BCFDel
       binary
       bios
       black
       BLDAttrib
       BLDChDir
       BLDCopy
       BLDDel
       BLDMkDir
       blue
       Box
       break
       bright
       brown
       byte

       CALL
       Canceled
       Cancelled
       Case
       CapsLockOff
       CapsLockOn
       CapsLockStatus
       CharToNum
       class
       ClearLineTo
       Clock
       ClockOff
       Close
       CloseAllFiles
       CLS
       cold
       collapse
       colormode
       commas
       Contains
       CoproccessorInstalled
       CPU
       CRTcols
       CRTrows
       ctrlc
       cursor
       CurrentDir
       CurrentDrive
       cyan

       date
       DayoftheWeek
       default
       dialog
       directoryexists
       DiskFree
       DiskLabel
       DiskReady
       DiskSize
       do
       Dont
       Don't
       DOS
       DOSErrorLevel
       DOSInstalled
       DOSRAM
       double
       drawbox
       DropDown

       ECHO
       Else
       EMSAvail
       EMSInstalled
       EMSMajor
       EMSMinor
       EMSTotal
       EMSVersion
       Encryption
       End
       Env
       EnvAvail
       EnvTotal
       EOF
       errorcode
       errorcount
       ERRORLEVEL
       escape
       exist
       Exit
       External
       exttotal

       File
       FileChangedDateToLong
       FileChangedTimeToLong
       filecount
       FileSize
       FillArea
       float
       FOR
       freemem
       from

       GetFilePos
       GetKey
       getmem
       getvideoinfo
       GetYN
       global
       GOTO
       GoToXY
       gray
       green
       group
       gumby

       HasExtension
       help
       hex
       hide
       highlight

       IF
       in
       Input
       Integer
       IntegerArray
       into
       IntToStr
       is
       it
       item

       Keypressed
       keystroke

       LastKey
       leftstr
       Length
       LightBar
       Location
       lock
       LongInt
       LongIntArray
       LongToDateStr
       LongToStr
       LongToTimeStr
       lookandfeel
       loop
       LowerCase
       LTrim

       magenta
       mark
       MaxCols
       MaxRows
       Menu
       message
       MidStr
       mod
       module
       monomode
       mouse
       MouseHideCursor
       MouseInstalled
       MouseShowCursor
       Move

       NestedItem
       Not
       notready
       NumLockOff
       NumLockOn
       NumLockStatus
       NumofDrives
       NumToChar
       numtostr

       object
       octal
       of
       off
       on
       only
       OnPath
       Open
       Or
       OSMajor
       OSMinor
       OSVersion
       otherwise

       ParamCount
       parse
       Password
       paste
       PAUSE
       PickFile
       Picklist
       pointer
       PopUp
       printscreen
       PrinterReady
       private
       program
       protect
       public
       Put

       Read
       ReadLine
       ReadScrLine
       ready
       Reboot
       red
       release
       REM
       RenSub
       Repeat
       replaceextension
       RestoreScreen
       Return
       Rewind
       rightstr
       RowCol
       RTrim
       Run
       RunString
       RunSwap
       safety
       SaveFile
       SaveScreen
       Say
       ScreenBlank
       ScrollLockOff
       ScrollLockOn
       ScrollLockStatusselect
       SET
       SetFilePos
       shell
       SHIFT
       show
       single
       Sleep
       SleepUntil
       snowcheck
       stack
       StrDateToLong
       String
       StrinArray
       StrTimeToLong
       StrToNum
       Stuff
       Style
       Sub
       SysDateToLong
       System
       SysTimeToLong

       talk
       Text
       the
       thours
       time
       timer
       tminutes
       to
       Trim
       tseconds
       ttime

       unhide
       unlock
       unprotect
       UnShift
       UpperCase
       Use
       using

       VideoMode
       virtual

       Wait
       WaitUntil
       warm
       WhereX
       WhereY
       While
       white
       window
       Write
       WriteLine
       writing

       XMSAvail
       XMSInstalled
       XMSMajor
       XMSMinor
       XMSTotal
       XMSVersion
       xor

       yellow

G.   Limitations

About this appendix

     This appendix covers various issues regarding maximum
     identifier lengths, and so on.


     Menu Limitations
     ----------------
     BUILDERlite is limited to 40 nested menu items per program.


     Array Limitations
     -----------------
     All arrays are limited to a total of 500 elements.


     Line length
     -----------
     The maximum length of a source file line is 128 characters,
     just as it is in DOS.  Watch out for long path names.  Note
     that this includes the length of DOS variables such as %1
     and %PATH% after they've been expanded.


     Subroutine names
     ----------------
     The maximum length of a subroutine name is 32 characters.


     Strings
     -------
     The maximum length of a string is 127 characters.


     Network limitations
     -------------------
     On some Novell networks there is a problem with periods in the PATH
     that effects the RUN command and causes either the command not to
     be executed or the system to hang.

     The following work-arounds are available at this time.

         1.)   Use the SYSTEM command as this command does not seem to be
               affected.

         2.)   In your program script, change to the directory
               containing the program to bu RUN'ed and then execute the RUN
               command making sure to include a FULL path to the executed
               program.


     "%" and "~" considerations
     --------------------------
     In BUILDERlite, the % and ~ characters have special meanings that can
     cause the unaware programmer problems.

     The % character is used to retreive command line parameters as well
     as the contents of enviroment variables as in the following:

        Option1 := "%1"        <--- Get first Command Line option.
        DOSpath := "%PATHC%"   <--- Get the contents of PATH statement.

     The tilde (~), or literal, character is used to signal BUILDERlite
     that the following character is not to be acted on but is to be
     left alone.  This feature can be used to stop BUILDERlite from
     acting on the % and " characters.  For example:

        Say @ 10,10 "~"Take off all of your clothes~", he said longingly."
        Say @ 11,10 "We are 99.9~% sure of our results."

     If a file contains either of these characters and is then read by
     BUILDERlite, BUILDERlite will automatically attemp to perform the
     above conversion.  This can have disastorus results if the file you
     are atempting to read contains these characters.

     The following work-arounds are available at this time.

     The only work-around to this problem is to copy the file in
     question to a temp file character by character and while doing so
     convert all tildes and percents to some other character.  Once the
     file has been processed, reverse the above procedure.


     Later versions of DOS
     ---------------------
     If you are converting a batch file from a later version of DOS,
     be aware that any new DOS commands may not be supported internally
     by BUILDERlite.  Use the RUN or SYSTEM function with these commands.