'/* FINDALL.BAS  Find text in current directory and below */
'/*              By: Dale Thorn                           */
'/*              Rev. 18.05.2000                          */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'

ccmd = rtrim$(command$)                'get trimmed command parameters (if any)
if ccmd = "" then                              'a command line was NOT supplied
   cls                                                'clear the display screen
   cmsg = "Usage:  FINDALL  filespec  text1,  text2, ...     " 'set 1st message
   ipos1 = len(cmsg) - 3                   'display position for '/' parameters
   ctmp = space$(4)                        'initialize the messages left margin
   locate 1, 1, 1                         'move display cursor to screen row #1
   print ctmp; cmsg                                'display first usage message
   mid$(cmsg, ipos1) = "/C  "                   'add '/C' spec to usage message
   print ctmp; cmsg                               'display second usage message
   mid$(cmsg, ipos1) = "/D  "                   'add '/D' spec to usage message
   print ctmp; cmsg                                'display third usage message
   mid$(cmsg, ipos1) = "/Exx"                   'add '/E' spec to usage message
   print ctmp; cmsg                               'display fourth usage message
   mid$(cmsg, ipos1) = "/L  "                   'add '/L' spec to usage message
   print ctmp; cmsg                                'display fifth usage message
   mid$(cmsg, ipos1) = "/N  "                   'add '/N' spec to usage message
   print ctmp; cmsg                                'display sixth usage message
   mid$(cmsg, ipos1) = "/O  "                   'add '/O' spec to usage message
   print ctmp; cmsg                              'display seventh usage message
   mid$(cmsg, ipos1) = "/Pnn"                   'add '/P' spec to usage message
   print ctmp; cmsg                               'display eighth usage message
   mid$(cmsg, ipos1) = "/Q  "                   'add '/Q' spec to usage message
   print ctmp; cmsg                                'display ninth usage message
   mid$(cmsg, ipos1) = "/S  "                   'add '/S' spec to usage message
   print ctmp; cmsg                                'display tenth usage message
   mid$(cmsg, ipos1) = "/W  "                   'add '/S' spec to usage message
   print ctmp; cmsg                             'display eleventh usage message
   mid$(cmsg, ipos1) = "/1  "                   'add '/1' spec to usage message
   print ctmp; cmsg                             'display twelveth usage message
   print                                           'blank line between messages
   print ctmp; "If '/C' specified, set search method to case sensitive"
   print ctmp; "If '/D' specified, write search results to output file"
   print ctmp; "If '/E' specified, exclude char(s) 'xx' in '/N' search"
   print ctmp; "If '/L' specified, show line numbers in search results"
   print ctmp; "If '/N' specified, skip over characters if <= ASCII 32"
   print ctmp; "If '/O' specified, show file offsets in search results"
   print ctmp; "If '/P' specified, show result text from -nn positions"
   print ctmp; "If '/Q' specified, remove quotes around text to search"
   print ctmp; "If '/S' specified, set search to literal (string) mode"
   print ctmp; "If '/W' specified, set search to match whole word only"
   print ctmp; "If '/1' specified, show one (1) search result per file";
   close                              'close all files in case not closed above
   system                                   'return control to operating system
end if

ipos0 = instr(ccmd, " ")         'position following filespec in parameter list
if ipos0 = 0 then                'no separator in params - something is missing
   i = ifn.msgs("Error: filespec or searchtext missing", 5, 24, 79, 1, 1)
end if                                  'display error message [above] and exit
cfsp = left$(ccmd, ipos0 - 1)         'user-entered filespec (*.bas, *.*, etc.)
ccmd = ltrim$(mid$(ccmd, ipos0 + 1))  'remove filespec from remainder of params

ipos0 = instr(ccmd, " ")          'position following searchstring(s) in params
ipos1 = instr(ccmd, "/")          'position following searchstring(s) in params
if ipos1 > 0 and ipos1 < ipos0 then       '/' occurs before any space separator
   ipos0 = ipos1                        'set separator position to '/' position
elseif ipos0 = 0 then                  'neither '/' nor ' ' separator was found
   ipos0 = len(ccmd) + 1               'set separator position to end of params
end if

ctxt = left$(ccmd, ipos0 - 1)             'all search strings on parameter line
cprm = ltrim$(mid$(ccmd, ipos0))          'command line switches (/W, /S, etc.)
if instr(lcase$(cprm), "/d") = 0 then       '/d' switch was not entered by user
   cprm = cprm + "/d"                        'add the '/d' switch to the params
end if
ccmd = cfsp + " " + ctxt + " " + cprm  'reset params to pass to child processes

cls                            'clear screen before calling first child process
locate 5, 1, 1                'locate cursor before calling first child process

ifil = freefile                          'next available DOS file number/handle
i = ifn.kill(ifil, "tfnd.tmp")            'kill any preexisting 'tfnd.tmp' file
shell "tfndall " + ccmd                     'process files in current directory
shell "copy tfnd.out tfnd.tmp > nul"       'accumulate finds to 'tfnd.tmp' file
shell "dir /ad /b /s > findall.dir"        'subdirectories of current directory
open "findall.dir" for input as ifil         'open list of subdirectories found

do while not eof(ifil)                  'loop until subdirectory list processed
   line input #ifil, clin               'input next line from subdirectory list
   shell "tfndall " + rtrim$(clin) + "\" + ccmd   'do search in child directory
   shell "copy /a tfnd.tmp+tfnd.out tfnd.tmp > nul"  'accum.finds to 'tfnd.tmp'
   if inkey$ = char(27) then               'user pressed ESC; terminate program
      i = ifn.msgs("Abort selected - Program terminated", 5, 24, 79, 0, 1)
   end if                               'display abort message [above] and exit
loop
close ifil                                    'close the subdirectory list file
shell "brow tfnd.tmp"                        'browse the accumulated finds list

close                                 'close all files in case not closed above
system                                  'return control to the operating system
