;
;	CXCTL -- A HP1000CX (and probably 100LX/200LX) Control Program
;	Copyright (C) 1999 Nils M Holm  <nmh@dialup.nacamar.de>
;
;	CXCTL is FREE SOFTWARE and coes with NO WARRANTY.
;
;	The program provides command line access to HP1000CX featues
;	which are normally accessible only through the built-in SETUP
;	program. It may be used to
;
;		o  adjust the display contrast
;		o  adjust the beeper volume
;		o  set the video mode and zoom mode
;		o  set the power off timeout
;		o  enable/disable the COM port
;		o  query the battery capacity
;		o  etc...
;
;	The user interface is simple (and subject to countless
;	improvements). Help may be requested by typing CXCTL ?
;	on the DOS prompt.
;
;	The program has been designed to run on a HP1000CX, but it
;	should work fine with the 100LX and 200LX models, too.
;
;	This program has been written using S86, but converting it
;	to MASM/TASM format should be trivial.
;

.text
	call	main
	mov	ax,$4C00
	int	$21

.data
progname:	db	"CXCTL: ", 0
err_cmd:	db	"unrecognized command", $0D, $0A, 0
err_num:	db	"numeric parameter missing", 13, 10, 0
buffer:		db	0*32
beep:		db	7, 0
batt_main:	db	"Main battery: ..... ", 0
batt_backup:	db	"Backup battery: ... ", 0
batt_mv:	db	" mV "
crlf:		db	$0D, $0A, 0

usage:	db	"Try CXCTL ? for help", $0D, $0A, 0

longusage:
	db	13,10
	db	"CXCTL -- HP1000CX (and 100,200LX) Control Program", 13,10
	db	"Copyright (C) 1999 Nils M Holm "
	db	"<nmh@dialup.nacamar.de>", 13,10,10
	db	"USAGE: CXCTL command ...", 13,10,10
	db	"Z mode", 9, "set zoom mode", 13,10
	db	9,"mono:  2=80x25  128=64x18  130=40x25  132=40x16",13,10
	db	9,"color: 3=80x25  129=64x18  131=40x25  133=40x16",13,10
	db	"T sec", 9, "set power off timeout", 13,10
	db	"C n", 9, "set contrast (0=bright, 15=dark)", 13,10
	db	"V n", 9, "set beeper volume (0=off, 3=loud)", 13,10
	db	"S IOW", 9, "setup serial port (I=IR, W=wire, O=off)", 13,10
	db	"A", 9, "adjust system time using RTC", 13, 10
	db	"I LR", 9, "set indicator position (L=left, R=right)", 13, 10
	db	"D CK", 9, "set display flags (C=set +C, K=set +K)", 13, 10
	db	9, "Not specifying a flag clears it. (DK sets -C +K)", 13, 10
	db	9, "WHAT the hell is this, BTW??", 13,10
	db	9, "Send answers to the address above. Thanks!", 13, 10
	db	"P Tx", 9, "Set battery type to x (A=alkaline, N=NiCd)", 13,10
	db	9, "NC enables recharging", 13, 10
	db	9, "(USE ONLY WITH RECHARGABLE NiCd BATTERIES!)", 13,10
	db	"P Q", 9, "Query power status", 13, 10
	db	13,10,0

.text
print:	push	si
	cld
prlen:	lodsb
	or	al,al
	jnz	prlen
	pop	dx
	sub	si,dx
	mov	cx,si
	dec	cx
	mov	bx,1
	mov	ax,$4000
	int	$21
	ret

printnum:
	mov	bx,ax
	push	es
	mov	ax,ds
	mov	es,ax
	mov	di,offset buffer
	add	di,31
	std
	xor	ax,ax
	stosb
	or	bx,bx
	jz	print0
prnn:	or	bx,bx
	jz	endpn
print0: mov	cx,10
	mov	ax,bx
	xor	dx,dx
	div	cx
	add	dx,'0'
	mov	bx,ax
	mov	ax,dx
	stosb
	jmp	prnn
endpn:	pop	es
	mov	si,di
	inc	si
	call	print
	ret

error:	push	si
	mov	si,offset progname
	call	print
	pop	si
	call	print
printusage:
	mov	si,offset usage
	call	print
	mov	ax,$4C01
	int	$21
	ret

ucase:	cmp	al,'a'
	jb	ucdone
	cmp	al,'z'
	ja	ucdone
	sub	al,'a'
	add	al,'A'
ucdone:
	ret

numeric:
	cmp	al,'0'
	jb	nonum
	cmp	al,'9'
	ja	nonum
	stc
	ret
nonum:	clc
	ret

skip:	eseg
	lodsb
	cmp	al,$20
	jz	skip
	cmp	al,$09
	jz	skip
	ret

scannum:
	mov	ax,-1
	push	ax
skiplb:	call	skip
	dec	si
	xor	di,di
	mov	cx,10
scnext:	eseg
	lodsb
	call	numeric
	jnc	endsc
	sub	al,'0'
	mov	bx,ax
	xor	bh,bh
	mov	ax,di
	mul	cx
	add	ax,bx
	mov	di,ax
	pop	ax
	xor	ax,ax
	push	ax
	jmp	scnext
endsc:	pop	cx
	or	cx,cx
	jz	numok
	mov	si,offset err_num
	call	error
	ret
numok:
	mov	ax,di
	dec	si
	ret

main:	mov	ax,cs
	sub	ax,$10
	mov	es,ax
	mov	si,$80
	cld
	eseg
	lodsb
	or	al,al
	jnz	main1
	jmp	printusage
main1:
next:	call	skip
	cmp	al,$0D
	jnz	eval
	ret
eval:	call	ucase
	cmp	al,'Z'
	jnz	noz
	call	set_zoom_mode
	jmp	next
noz:	cmp	al,'D'
	jnz	nod
	call	set_display_ctl
	jmp	next
nod:	cmp	al,'T'
	jnz	no_t
	call	set_timeout
	jmp	next
no_t:	cmp	al,'C'
	jnz	noc
	call	set_contrast
	jmp	next
noc:	cmp	al,'V'
	jnz	nov
	call	set_volume
	jmp	next
nov:	cmp	al,'S'
	jnz	nos
	call	setup_serial_port
	jmp	next
nos:	cmp	al,'A'
	jnz	noa
	call	adjust_time
	jmp	next
noa:	cmp	al,'P'
	jnz	no_p
	call	setup_power_sys
	jmp	next
no_p:	cmp	al,'I'
	jnz	noi
	call	set_indicator_pos
	jmp	next
noi:	cmp	al,'?'
	jnz	noqm
	mov	si,offset longusage
	call	print
	mov	ax,$4C00
	int	$21
noqm:
	mov	si,offset err_cmd
	jmp	error
	ret

set_zoom_mode:
	call	scannum
	mov	ah,$D0
	int	$10
	ret

set_display_ctl:
	call	skip
	xor	bx,bx
nextf:	eseg
	lodsb
	call	ucase
	cmp	al,'K'
	jnz	nokf
	or	bx,2
	jmp	nextf
nokf:	cmp	al,'C'
	jnz	nocf
	or	bx,2
	jmp	nextf
nocf:	mov	ax,bx
	or	ax,$45
	int	$15
	ret

set_timeout:
	call	scannum
	mov	cx,1092
	mul	cx
	mov	cx,60
	div	cx
	mov	bx,ax
	mov	ax,$4600
	int	$15
	ret

set_contrast:
	call	scannum
	mov	bx,ax
	mov	ax,$4700
	int	$15
	ret

set_volume:
	call	scannum
	and	ax,$FF
	or	ax,$4800
	int	$15
	push	si
	mov	si,offset beep
	call	print
	pop	si
	ret

setup_serial_port:
	call	skip
	call	ucase
	cmp	al,'I'
	jz	port_infrared
	cmp	al,'W'
	jz	port_wire
	cmp	al,'O'
	jz	port_off
	jmp	printusage
port_infrared:
	mov	ax,$4A01
	int	$15
	mov	ax,$4901
	int	$15
	ret
port_wire:
	mov	ax,$4A01
	int	$15
	mov	ax,$4900
	int	$15
	ret
port_off:
	mov	ax,$4A00
	int	$15
	ret

adjust_time:
	mov	ax,$4B00
	int	$15
	ret

printmv:
	mov	cx,$1B
	mul	cx
	add	ax,$622
	call	printnum
	ret

setup_power_sys:
	call	skip
	call	ucase
	cmp	al,'Q'
	jz	query_power_status
	cmp	al,'T'
	jz	set_batt_type
	jmp	printusage
set_batt_type:
	call	skip
	call	ucase
	cmp	al,'A'
	jz	slc_alkaline
	cmp	al,'N'
	jz	slc_nicad
	jmp	printusage
slc_alkaline:
	mov	ax,$6004
	xor	bx,bx
	int	$15
	mov	ax,$6003
	xor	bx,bx
	int	$15
	ret
slc_nicad:
	mov	ax,$6003
	mov	bx,1
	int	$15
	eseg
	lodsb
	call	ucase
	cmp	al,'C'
	jz	enable_charge
	dec	si
	ret
enable_charge:
	mov	ax,$6004
	mov	bx,1
	int	$15
	ret
query_power_status:
	push	si
	mov	si,offset batt_main
	call	print
	mov	ax,$6000
	int	$15
	call	printmv
	mov	si,offset batt_mv
	call	print
	mov	si,offset batt_backup
	call	print
	mov	ax,$6001
	int	$15
	call	printmv
	mov	si,offset batt_mv
	call	print
	pop	si
	ret

set_indicator_pos:
	call	skip
	call	ucase
	cmp	al,'L'
	jz	ind_left
	cmp	al,'R'
	jz	ind_right
	jmp	printusage
	ret
ind_left:
	mov	ax,$6120
	int	$15
	ret
ind_right:
	mov	ax,$6160
	int	$15
	ret
