;==============================================================
;LXCIC is a PCMCIA modem card enabler. To understand, what this
;code is doing, you have to master the PCMCIA basics. Look at:
;
; The PCMCIA Developer's Guide
; by Michael T.Mori and W.Dean Welder
; Sycard Technology, Sunnyvale, California, USA
; ISBN 0-9640342-1-2
;--------------------------------------------------------------
;To create LXCIC.COM you may either use TASM or MASM:
;
;Using turbo assembler
;---------------------
; TASM LXCIC.ASM
; TLINK /T LXCIC.OBJ
;
;Using MASM
;----------
; MASM LXCIC.ASM;
; LINK LXCIC.OBJ;
; EXE2BIN LXCIC.EXE LXCIC.COM
;--------------------------------------------------------------
;You may use a compression utility like COMPACK or DIET to
;pack the LXCIC.COM file. I recommend COMPACK from S.U.P.E.R.
;==============================================================

MODEM  EQU 1            ;include modem support
ETHER  EQU 1            ;include ethernet support
;SCSI   EQU 1            ;include scsi support
;PARAL  EQU 1            ;include parallel support

.186
cseg   segment 'code'
assume cs:cseg,ds:cseg,es:cseg
org    100h

;-CONSTANTS----------------------------------------------------

;-STEUER BITS-

RESI_P EQU 1
STAT_P EQU 2
POWO_P EQU 4
TUPL_P EQU 8
CORE_P EQU 16
REGI_P EQU 32
RSET_P EQU 64
UNRE_P EQU 128
REMO_P EQU 256
PULS_P EQU 512
POWW_P EQU 1024
PORT_P EQU 2048

;-STATUS BITS-

NOCARD EQU 1            ;0=card     1=no card
ISRESI EQU 2            ;0=not resi 1=resident
ISDISA EQU 4            ;0=enabled  1=disabled

T_BUFL EQU 46           ;tuple buffer length
N_BUFL EQU 256          ;non resident io buffer length

;BRUTE  EQU 1            ;ver 1.4 modem feature: brute force 
                        ;no longer supported 
;-DEFINITIONS--------------------------------------------------

  request struc         ;register client struc
r_leng db ?
r_func db ?
r_soff dw ?
r_sseg dw ?
  request ends

  client  struc         ;client struc
c_link dd ?
c_eoff dw ?
c_eseg dw ?
c_qptr dd ?
c_mask dw ?
c_attr dw ?
c_arte db ?
c_bptr dd ?
c_evnt dw ?
  client  ends

  rtuple  struc         ;request tuple struc
t_leng db ?
t_func db ?
t_sock dw ?
t_flag dw ?
t_loff dd ?
t_coff dd ?
t_attr db ?
t_dtup db ?
t_boff dw ?
t_bseg dw ?
t_blng dw ?
t_toff dw ?
t_bytr db ?
  rtuple  ends

  write   struc         ;read/write request packet struc
w_leng db ?
w_func db ?
w_sock db ?
w_memt db ?
w_memh dw ?
w_tlen dw ?
w_clow dw ?
w_chig dw ?
w_boff dw ?
w_bseg dw ?
  write   ends

;-CODE---------------------------------------------------------

  start:
jmp    start1

;-RESIDENT DATA------------------------------------------------

tsrstr db 'lxcic'       ;tsr search string

;--------------------------------------------------------------
;The list fids holds for every LXCIC supported function ID of a
;PCMCIA card 3 words: port, enable pointer, disable pointer.
;If you want to enhance LXCIC in order to support another type
;of card, you have to fill in these 3 values and you have to
;write the enable and disable subroutine for this card. Look
;at the existing routines as examples for what has to be done.

  fids:
dw 0,0,0                            ;fid 0: manufacturer specific
dw 0,0,0                            ;fid 1: memory
  IFDEF MODEM
dw 02f8h,enable_modem,disable_modem ;fid 2: modem/serial
  ELSE
dw 0,0,0
  ENDIF
  IFDEF PARAL
dw 0378h,enable_paral,disable_paral ;fid 3: parallel ????
  ELSE
dw 0,0,0
  ENDIF
dw 0,0,0                            ;fid 4: (flash) drive
dw 0,0,0                            ;fid 5: video
  IFDEF ETHER
dw 0300h,enable_ether,disable_ether ;fid 6: ethernet
  ELSE
dw 0,0,0
  ENDIF
dw 0,0,0                            ;fid 7: AIMS
  IFDEF SCSI
dw 0,enable_scsi,disable_scsi       ;fid 8: SCSI
  ELSE
dw 0,0,0
  ENDIF
;--------------------------------------------------------------

c_stru client  <0,CODOFF,0,0,0101h,1,0,0,0>
r_stru request <6,0,offset c_stru,0>
t_stru rtuple  <25,0,1,0,0,0,0,0,offset t_buff,0,T_BUFL,1,0>
w_stru write   <16,9,1,0,0,1,100h,0,offset o_buff,0>

t_buff db T_BUFL dup(0)
       db 13,10,'$'
o_buff db 0,0
baselo dw 100h
port   dw 0             ;fid specific port
enable dw 0             ;fid specific enable pointer
disable dw 0            ;fid specific disable pointer
steuer dw 0
status dw 0
cor    db 0
fcsr   db 0
tpcc   db 0
fid    db -1            ;default: no card
pulse  db 01000000b

CODOFF equ $

;-RESIDENT CODE------------------------------------------------

  callback:
pusha
push   ds
push   es

push   cs
pop    ds
push   cs
pop    es
cld

test   status,ISDISA    ;socket service disabled?
jne    callback_end     ;yes, skip callback
cmp    ax,40h           ;card insertion?
je     callback_new     ;yes
cmp    ax,0Bh           ;AMP resume?
je     callback_new     ;yes
cmp    ax,0Ch           ;AMP suspend?
jne    callback_end     ;no
call   addresses        ;does card need disable?
jc     callback_end     ;no
call   disable          ;disable card
jmp    short callback_end

  callback_new:
call   new_card
jc     callback_end     ;tuple or id error
call   enable

  callback_end:
pop    es
pop    ds
popa
clc                     ;carry must be cleared
db     0CBh             ;ret far instruction opcode

;-UP TUP_GET---------------------------------------------------

  tup_get:
mov    bx,offset t_stru
mov    [bx].t_func,80h  ;get first tuple
mov    [bx].t_dtup,al
jmp    short bios_req
  tup_next:
mov    bx,offset t_stru
mov    [bx].t_func,81h  ;get next tuple
jmp    short bios_req
  tup_data:
mov    bx,offset t_stru
mov    [bx].t_func,82h  ;get tuple data
  bios_req:
mov    ax,0b000h        ;card bios request
int    1ah
ret

;-UP NEW_CARD--------------------------------------------------

;configures a card for I/O

  new_card:
pusha

IFDEF BRUTE
mov    al,cor           ;cor from command line
mov    o_buff,al
test   steuer,CORE_P
jne    new_cfg          ;brute force
ENDIF

call   new_val          ;get new vals (cor etc.)
jc     new_cerr         ;cannot get vals

;write cor value to address
  new_cfg:
mov    bx,offset w_stru
mov    [bx].w_func,9    ;write
call   bios_req         ;write cor value
jc     new_cerr
test   tpcc,2           ;fcsr available?
je     new_end          ;no
mov    [bx].w_func,8    ;read
add    [bx].w_clow,1    ;from adr 101
adc    [bx].w_chig,0
call   bios_req
jc     new_cerr
or     o_buff,00101000b ;8bit IO + audio
test   steuer,POWO_P
je     new_cfg1
or     o_buff,4
  new_cfg1:
mov    al,o_buff
mov    fcsr,al
mov    [bx].w_func,9    ;write
call   bios_req
jc     new_cerr
  new_end:
clc
  new_cerr:
popa
ret

;-UP NEW_VAL---------------------------------------------------

;gets tuple information of the card but does not configure it

  new_val:
  new_id:
mov    si,offset t_buff+1 ;access data
mov    al,21h           ;funcid tuple
call   tup_get
jc     new_assume       ;funcid tuple may not be available
call   tup_data
jc     new_assume
mov    al,[si]
mov    fid,al           ;remember fid if available
jmp    short new_base

  new_assume:
mov    fid,2            ;assume modem if no fid is available
  new_base:
call   addresses        ;get addr. for this fid from list fids
jc     new_manu         ;no valid addresses found 
mov    al,1ah           ;config reg adr tuple
call   tup_get          ;get it
jc     new_manu         ;error           
call   tup_data         ;get corresponding tuple data
jc     new_manu         ;error
lodsw
mov    bl,al            ;1.byte = adr format
and    bl,3             ;mask out bit 7-3
lodsw
mov    dx,ax            ;2.word = low adr = dx
lodsw                   ;3.word = high adr= ax
mov    tpcc,al
cmp    bl,3             ;process adr format
je     new_base1        ;32 bit adr
xor    ah,ah
cmp    bl,2
je     new_base1        ;24 bit adr
xor    al,al
cmp    bl,1
je     new_base1        ;16 bit dx
xor    dh,dh            ;8 bit adr
  new_base1:
shr    ax,1             ;shift into carry
rcr    dx,1             ;take over carry
mov    bx,offset w_stru ;read/write struc
mov    [bx].w_clow,dx   ;config reg low adr
mov    [bx].w_chig,ax   ;config reg high adr
mov    baselo,dx

;find COR value to write to the configuration register

  new_cor:
mov    al,1bh
call   tup_get          ;get first 1bh tuple
jc     new_manu         ;error
  new_cor1:
call   tup_data         ;get tuple 1bh data
jc     new_manu         ;error
mov    si,offset t_buff ;access data
xor    cx,cx
lodsb
mov    cl,al            ;tuple length
lodsb                   ;get first byte from tuple buffer
and    al,3fh           ;only bit 0-5
or     al,pulse         ;set IR: level or pulse
mov    o_buff,al
mov    cor,al
  new_cor2:             ;find corresponding port in string
mov    ah,al
lodsb
mov    bx,ax
xchg   bh,bl
cmp    bx,port          ;our port found?
je     new_cor_ok       ;yes, cf=0
loop   new_cor2         ;no, keep on searching
call   tup_next         ;through all remaining 1b tuples
jnc    new_cor1
  new_manu:
mov    cor,-1           ;no port for cor found
  new_cor_ok:
mov    di,offset t_buff
mov    cx,T_BUFL
mov    al,' '
rep    stosb            ;norm tuple buffer
mov    al,15h           ;manufacturer tuple
call   tup_get          ;get it
jc     new_err          ;error           

;NOTE: Some PCMCIA cards do not allow access to the tuples
;      once they are configured. Hence LXCIC cannot display
;      the manufacturer info for some configured cards.

call   tup_data         ;get corresponding tuple data
  new_err:
cmp    cor,-1           ;no port for cor found?
je     new_cf           ;yes, error
clc                     ;port for cor found
ret
  new_cf:
stc
ret

;-UP ADDRESSES-------------------------------------------------

;this subroutine puts the values from the list fids for the
;found fid into the variables port, enable and disable.
;If any of this values is 0, the carry flag is set and no
;action is taken for this specific card.

  addresses:
pusha
xor    ax,ax
mov    al,fid
or     ax,ax
jb     addr_error       ;only fid >0 and <=8 are supported
cmp    ax,8
ja     addr_error
add    ax,ax            ;fid*2
push   ax
add    ax,ax            ;fid*4
pop    bx
add    ax,bx            ;fid*6
mov    bx,offset fids
add    bx,ax            ;offset in list fids for this fid

IFDEF BRUTE
test   steuer,PORT_P    ;use port from command line?
jne    addr_1           ;yes
ENDIF

mov    ax,[bx]
or     ax,ax
je     addr_error       ;no valid port 
mov    port,ax
  addr_1:
add    bx,2
mov    ax,[bx]
or     ax,ax
je     addr_error       ;no valid enable pointer
mov    enable,ax
add    bx,2
mov    ax,[bx]
or     ax,ax
je     addr_error       ;no valid disable pointer
mov    disable,ax
clc                     ;all values are valid
jmp    short addr_e
  addr_error:
stc
  addr_e:
popa
ret

;=FUNCTION ID SPECIFIC ENABLER/DISABLER========================

;-FID 2: MODEM supported by Stefan Peichl----------------------

IFDEF MODEM
  enable_modem:
pusha
mov    dx,0501h ;dh=attr:io + enabled  dl=wait line monitoring
mov    si,2     ;io card
mov    bp,port  ;02f8h ;com2 base adr
jmp    short config_modem

  disable_modem:
pusha
mov    dx,0101h ;dh=attr:io + disabled  dl=wait line monitoring
mov    si,1     ;memory card
xor    bp,bp    ;com2 base adr reset

  config_modem:
mov    ax,8e00h ;ah=set socket         al=adapter nr
mov    bx,8001h ;bh=enable cardDetCng  bl=socket nr
mov    cx,0111h ;ch=VCC 5 volt         cl=VPP 5 volt
push   dx
xor    dx,dx    ;dh=no socket attrib   dl=no indicator
mov    di,8003h ;di=enable IRQ3
int    1ah
pop    dx
jc     modem_e
mov    ax,8900h ;ah=set window         al=adapter nr
mov    bx,0901h ;bh=first io window    bl=socket nr
mov    cx,8     ;cx=io window size
mov    si,port  ;02F8h ;si=base adr COM2
int    1ah
jc     modem_e
push   es
xor    ax,ax
mov    es,ax
mov    es:[402h],bp ;bios data area COM2
pop    es
clc
  modem_e:
popa
ret
ENDIF

;-FID 3: PARALLEL supported by ?-------------------------------
;-the following code fragment is necessary but not sufficient
;-for the QUATECH SPP-100 Parallel Card

IFDEF PARAL
  enable_paral:
pusha
mov    dx,0501h ;dh=attr:io + enabled  dl=wait line monitoring
mov    si,2     ;io card
mov    bp,port  ;parallel base adr
jmp    short config_paral

  disable_paral:
pusha
mov    dx,0201h ;dh=attr:io + disabled  dl=wait line monitoring
mov    si,1     ;memory card
xor    bp,bp    ;bios data area parallel adr reset

  config_paral:
mov    ax,8e00h ;ah=set socket         al=adapter nr
mov    bx,8001h ;bh=enable cardDetCng  bl=socket nr
mov    cx,0111h ;ch=VCC 5 volt         cl=VPP 5 volt
push   dx
xor    dx,dx    ;dh=no socket attrib   dl=no indicator
mov    di,8007h ;8003 ???? di=enable IRQ7
int    1ah
pop    dx
jc     paral_e

mov    ax,8900h ;ah=set window         al=adapter nr
mov    bx,0901h ;bh=first io window    bl=socket nr
mov    cx,8     ;cx=io window size
mov    si,port  ;base adr parallel
int    1ah
jc     paral_e

mov    bx,0a01h ;bh=second io window   bl=socket nr
mov    cx,1     ;4    ???? cx=io window size
mov    si,077Ah ;077B ???? base adr
int    1ah
jc     paral_e

push   es
xor    ax,ax
mov    es,ax
mov    es:[408h],bp ;bios data area parallel base adr
and    byte ptr es:[411h],3fh ;mask out # of printer adapters
or     bp,bp        ;disable?
je     paral_1      ;yes
or     byte ptr es:[411h],40h ;equipment flag: one printer
  paral_1:
pop    es
clc
  paral_e:
popa
ret
ENDIF

;-FID 6: ETHERNET supported by Rod Whitby (based on work by Mack Baggette)----

IFDEF ETHER

e_buff db 10h dup(0)

   enable_ether:
pusha
mov    dx,0501h ;dh=attr:io + enabled  dl=wait line monitoring
mov    si,2     ;io card
call   config_ether
call   setup_ether
popa
ret
 
  disable_ether:
pusha
call   unset_ether
mov    dx,0101h ;dh=attr:io + disabled  dl=wait line monitoring
mov    si,1     ;memory card
call   config_ether
popa
ret

  config_ether:
mov    ax,8e00h ;ah=set socket         al=adapter nr
mov    bx,8001h ;bh=enable cardDetCng  bl=socket nr
mov    cx,0111h ;ch=VCC 5 volt         cl=VPP 5 volt
push   dx
xor    dx,dx    ;dh=no socket attrib   dl=no indicator
mov    di,8005h ;di=enable IRQ5
int    1ah
pop    dx
jc     ether_e
mov    ax,8900h ;ah=set window         al=adapter nr
mov    bx,0901h ;bh=first io window    bl=socket nr
mov    cx,20h   ;cx=io window size
mov    si,port  ;0300h ;si=base adr network
xor    di,di
int    1ah
  ether_e:
ret

  setup_ether:

; Reset the ethernet card.

mov    dx,031fh         ; NE2000 Reset Port.
in     al,dx            ; Read to initiate reset condition.
mov    cx,1600          ; Wait for 1.6ms = 1600*1.0us
  wait_ether:
in     al,61h           ; Wait for all activity to cease.
loop   wait_ether
out    dx,al            ; Write to clear the reset condition.

; Initialise Receive Configuration Register.

mov    dl,0ch           ; 8390 Receive Configuration Register.
mov    al,04h           ; Accept Broadcast.
out    dx,al       

; Place the NIC in Loopback mode 1.

inc    dx               ; 8390 Transmit Configuration Register.
mov    al,02h           ; Internal Loopback.
out    dx,al       

; Read the ethernet address from the PROM.

inc    dx               ; 8390 Data Configuration Register.
mov    al,49h           ; Word-wide burst-mode DMA transfers
out    dx,al            ; with an 8 byte FIFO buffer.

mov    al,00h           ; Start reading from address zero.
mov    dl,08h           ; 8390 Remote Start Address 0.
out    dx,al       
inc    dx               ; 8390 Remote Start Address 1.
out    dx,al       

inc    dx               ; 8390 Remote Byte Count 0.
mov    al,20h           ; Word-mode count is doubled.
out    dx,al       

inc    dx               ; 8390 Remote Byte Count 1.
mov    al,00h           ; High byte of count is zero.
out    dx,al       

mov    dl,00h           ; 8390 Command Register
mov    al,0ah           ; START, Remote Read, PAGE 0.
out    dx,al       

mov    cl,10h           ; Transfer 16 bytes from the PROM
push   ds               ; to our local memory buffer.
pop    es
mov    di,offset e_buff

mov    dl,10h           ; NE2000 Data Port
  read_ether:
in     al,dx            ; Read from data port.
stosb                   ; Write to our address memory buffer.
loop   read_ether

mov    dl,0eh           ; 8390 Data Configuration Register.
mov    al,48h           ; Byte-wide burst-mode DMA transfers
out    dx,al            ; with an 8 byte FIFO buffer.

; Initialise Receive Buffer Ring.

mov    dl,01h           ; 8390 Page Start Register.
mov    al,46h           ; First page of RX ring.
out    dx,al       

inc    dx               ; 8390 Page Stop Register.
mov    al,80h           ; Last plus one page of RX ring.
out    dx,al       

inc    dx               ; 8390 Boundary Pointer.
mov    al,46h           ; First page of RX ring.
out    dx,al       

; Clear Interrupt Status Register.

mov    dl,07h           ; 8390 Interrupt Status Register.
mov    al,0ffh          ; Clear all pending interrupts.
out    dx,al       

; Initialise Interrupt Mask Register.

mov    dl,0fh           ; 8390 Interrupt Mask Register.
mov    al,3fh           ; Everything except DMA interrupts.
out    dx,al       

; Initialise Physical Address Registers.

mov    dl,00h           ; 8390 Command Register.
mov    al,60h           ; No DMA, PAGE 1.
out    dx,al       

inc    dx               ; 8390 Physical Address Registers.
mov    si,offset e_buff
mov    cl,6             ; Move six bytes for the address.

  address_ether:
lodsb                   ; Read the address byte from memory.
out    dx,al            ; Write the address byte to 8390.
inc    dx
loop   address_ether

; Initialise Current Page Register.

                        ; 8390 Current Page Register.
mov    al,47h           ; First plus one page of RX ring.
out    dx,al       

; Initialise Multicast Address Registers.

inc    dx               ; 8390 Multicast Address Registers.
mov    al,0ffh          ; Accept all multicast packets.
mov    cl,8             ; 64 bits = 8 bytes.

  mcast_ether:
out    dx,al            ; Write one mask byte at a time.
inc    dx
loop   mcast_ether

; Put NIC in START mode.

mov    dl,00h           ; 8390 Command Register.
mov    al,22h           ; START, No DMA, PAGE 0.
out    dx,al       

; Enable NIC for transmission and reception.

mov    dl,0dh           ; 8390 Transmit Configuration Register.
mov    al,00h           ; Normal Operation.
out    dx,al       

clc
ret

  unset_ether:

; Reset the ethernet card.

mov    dx,031fh         ; NE2000 Reset Port.
in     al,dx            ; Read to initiate reset condition.
mov    cx,1600          ; Wait for 1.6ms = 1600*1.0us
  wait_ether_1:
in     al,61h           ; Wait for all activity to cease.
loop   wait_ether_1
out    dx,al            ; Write to clear the reset condition.

clc
ret

ENDIF

;-FID 8: SCSI supported by ?-----------------------------------

IFDEF SCSI
  enable_scsi:
  disable_scsi:
pusha
stc                     ;error unless implemented
  scsi_e:
popa
ret
ENDIF

;--------------------------------------------------------------

ALIGN  16               ;use full paragraphs
RPARA  equ ($-offset start+100h)/16   ;resident lenght mod 16

;-RESIDENT CODE END--------------------------------------------

  start1:
call   init             ;init structures, check residence
call   cmdpar           ;check for cmd line switches
mov    bx,offset upsl   ;lowest prio subroutine
mov    cx,16            ;16 possible prios
mov    ax,8000h         ;start with highest
  prio_loop:
test   steuer,ax        ;this prio wished?
je     no_sub           ;no
cmp    word ptr[bx],0   ;subroutine available for this prio?
je     no_sub           ;no
pusha
call   [bx]             ;yes, do it
popa
  no_sub:
shr    ax,1             ;point to next lower prio
sub    bx,2             ;go up in subroutine list
loop   prio_loop        ;do for all prios

  quit:
mov    al,fid           ;errorlevel
test   status,NOCARD
je     quit_1           ;a card is inserted
mov    al,-1            ;errorlevel -1: no card inserted
  quit_1:
mov    ah,4ch           ;done
int    21h

;-SUBROUTINES--------------------------------------------------

;-UP INIT------------------------------------------------------
;
;sets up status bitfield

  init:
  init_plug:            ;check for inserted card
push   es 
xor    ax,ax
mov    es,ax
test   byte ptr es:[4cch],4 ;card inserted?
pop    es
jne    init_struc       ;yes
or     status,NOCARD    ;no, remember

  init_struc:           ;init structures
mov    bx,offset c_stru
mov    [bx].c_eseg,cs
mov    bx,offset t_stru
mov    [bx].t_bseg,cs
mov    bx,offset r_stru
mov    [bx].r_sseg,cs
mov    bx,offset w_stru
mov    [bx].w_bseg,cs

;the following code allows status information even if LXCIC
;is loaded resident but disabled
 
  init_resi:
call   resident         ;check for resident load
jc     init_notresi     ;not resident
  init_isresi:
call   new_val          ;get new vals
jnc    init_e           ;ok
call   addresses        ;unsupported card?
jc     init_e           ;yes
call   res2loc          ;copy resident vals to local
jmp    short init_e
  init_notresi:
call   new_val
  init_e:
ret

;-UP CMDPAR----------------------------------------------------

  cmdpar:
mov    di,81h           ;tail begin
xor    cx,cx
mov    cl,[di-1]        ;tail length
or     cx,cx
jne    cmd_loop
or     steuer,REGI_P
jmp    short cmd__      ;no tail

  cmd_loop:
mov    al,[di]          ;load next char after '/'

IFDEF BRUTE
cmp    al,'='
jne    cmd_num
mov    al,[di+1]
call   aschex
jc     cmd_hlp
shl    al,4
mov    ah,al
mov    al,[di+2]
call   aschex
jc     cmd_hlp
add    al,ah
mov    cor,al
or     steuer,CORE_P+REGI_P
add    di,3
sub    cx,3
jge    cmd_loop
  cmd_hlp:
jmp    cmd_help

  cmd_num:
cmp    al,'1'
jl     cmd_char
cmp    al,'4'
jg     cmd_char
xor    bx,bx
mov    bl,al            ;1-4
sub    bl,'1'
shl    bl,1             ;ports are words
mov    si,offset ports
mov    ax,[si+bx]
mov    port,ax
or     steuer,REGI_P+PORT_P
jmp    short cmd_ok
ENDIF

  cmd_char:
and    al,0dfh          ;make upper case
  cmd_o:
cmp    al,'O'
jne    cmd_w
or     steuer,POWO_P
jmp    short cmd_ok
  cmd__:
jmp    short cmd_check  ;jump bridge
  cmd_w:
cmp    al,'W'
jne    cmd_s
or     steuer,POWW_P
jmp    short cmd_ok
  cmd_s:
cmp    al,'S'
jne    cmd_p
or     steuer,STAT_P
jmp    short cmd_ok
  cmd_p:
cmp    al,'P'
jne    cmd_t
or     steuer,PULS_P+REGI_P
jmp    short cmd_ok
  cmd_t:
cmp    al,'T'
jne    cmd_u
or     steuer,TUPL_P
jmp    short cmd_ok
  cmd_u:
cmp    al,'U'
jne    cmd_r
or     steuer,REMO_P
jmp    short cmd_ok
  cmd_r:
cmp    al,'R'
jne    cmd_l
or     steuer,RSET_P
jmp    short cmd_ok
  cmd_l:
cmp    al,'L'
jne    cmd_d
or     steuer,RESI_P
jmp    short cmd_ok
  cmd_d:
cmp    al,'D'
jne    cmd_e
or     steuer,UNRE_P+RSET_P ;disable always includes reset!
jmp    short cmd_ok
  cmd_e:
cmp    al,'E'
jne    cmd_x
or     steuer,REGI_P
jmp    short cmd_ok
  cmd_x:
  cmd_ok:
inc    di
dec    cx
jle    cmd_check
jmp    cmd_loop

;cmd line done, check for valid input

  cmd_check:
cmp    steuer,0
je     cmd_help
mov    dx,offset logo
mov    ah,9
int    21h

  cmd_nocard:           ;check for cmd allowed with no card
test   status,NOCARD
je     cmd_resident     ;card is plugged in
mov    dx,offset noplug
test   steuer,CORE_P+PULS_P+TUPL_P+POWO_P+POWW_P
jne    cmd_pri
  cmd_resident:
test   status,ISRESI
je     cmd_notres       ;not resident
mov    dx,offset isres
test   steuer,CORE_P+PULS_P+RESI_P
jne    cmd_pri
jmp    short cmd_normal
  cmd_notres:
mov    dx,offset notres
test   steuer,REMO_P
jne    cmd_pri
  cmd_normal:
ret

  cmd_help:
mov    ah,0fh
int    10h
xor    ah,ah
int    10h
mov    dx,offset logo
mov    ah,9
int    21h
mov    dx,offset help
  cmd_pri:
mov    ah,9
int    21h
  cmd_end:
jmp    quit             ;jump to general errorlevel quit

;-UP POWO_S----------------------------------------------------

  powo_s:
mov    dx,offset powo_t
mov    ah,9
int    21h
mov    dx,offset failed
mov    al,8             ;read fcsr
call   fcsr_rw
or     o_buff,4         ;power down
mov    al,9             ;write
call   fcsr_rw
mov    al,8             ;read again
call   fcsr_rw
test   al,4
je     powo_e           ;power down not taken
mov    dx,offset ok
  powo_e:
mov    ah,9
int    21h  
ret

;-UP POWW_S----------------------------------------------------

  poww_s:
mov    al,8             ;read
call   fcsr_rw
and    o_buff,not 4
mov    al,9
call   fcsr_rw
mov    dx,offset poww_t
mov    ah,9
int    21h  
ret

;-UP PULS_S----------------------------------------------------

  puls_s:
mov    pulse,0
ret

;-UP CORE_S----------------------------------------------------

  core_s:
ret

;-UP PORT_S----------------------------------------------------

  port_s:
ret

;-UP TUPL_S----------------------------------------------------

  tupl_s:
mov    dx,offset failed
call   tupl_info
jc     tupl_pri
mov    dx,offset tuples
mov    ah,9
int    21h
mov    dx,offset txt    ;"TPL.TXT"
mov    bp,offset tuples ;take from here, lenght in cx
call   save             ;write file
jc     tupl_pri         ;file error
mov    dx,offset raw    ;"TPL.RAW"
mov    bp,offset buffer
mov    cx,N_BUFL
call   save             ;write file
jc     tupl_pri         ;file error
mov    dx,offset w_info ;"creating files..."
  tupl_pri:
mov    ah,9
int    21h
ret

;--------------------------------------------------------------

  tupl_info:
mov    bx,offset w_stru ;load offset read/write structure
mov    [bx].w_func,8
mov    [bx].w_tlen,N_BUFL
mov    [bx].w_clow,0
mov    [bx].w_boff,offset buffer
mov    ax,0B000h        ;card bios request
int    1ah              ;read 256 bytes into our buffer
jnc    tuple            ;ok
ret                     ;no card inserted

  tuple:
lea    si,buffer        ;take from here
mov    bp,si
add    bp,N_BUFL        ;to check for end of input
lea    di,tuples        ;store to here
mov    cx,78
mov    al,' '
rep    stosb            ;init product info 

  tuple_next:           ;process one tuple
cmp    si,bp
jae    tuple_end        ;end of input reached
xor    ax,ax
lodsb                   ;get tuple code
or     al,al            ;null control tuple?
je     tuple_next       ;yes, ignore
cmp    al,0FFh
je     tuple_end        ;end of tuples
cmp    al,15h           ;is it product info tuple?
jne    tuple_do         ;no

;copy product info at the beginning of the file

pusha
lodsb
xor    cx,cx
mov    cl,al
sub    cx,4
add    si,2
lea    di,tuples
rep    movsb
mov    ax,0d0ah
stosw
popa

  tuple_do:             ;process one tuple
push   si
lea    si,tup_t
mov    cx,8
rep    movsb            ;"Tuple "
pop    si

mov    bx,2
call   wan              ;hex output
mov    ax,'= '
stosw
stosb

lodsb                   ;tuple link 
cmp    al,0FFh          ;end of tuples?
je     tuple_end        ;yes
or     al,al            ;empty tuple body?
je     tuple_next       ;yes, go to next tuple

;output tuple body in hex

xor    cx,cx
mov    cl,al
mov    bx,2
  tuple_body:
lodsb
call   wan
mov    al,' '
stosb
loop   tuple_body
jmp    short tuple_next

  tuple_end:
mov    ax,0d0ah
stosw
mov    cx,di
mov    al,'$'           ;mark end of string
stosb
lea    dx,tuples
sub    cx,dx            ;file length of TPL.TXT
clc
ret

;-UP STAT_S----------------------------------------------------

  stat_s:
mov    cx,status
test   cx,NOCARD
jne    stat_resi
call   stat_info        ;manu + debug

  stat_resi:
mov    dx,offset notres
test   cx,ISRESI
je     stat_rp          ;not loaded resident
mov    dx,offset active
push   es
mov    es,resseg
test   es:status,ISDISA
pop    es
je     stat_resi1
mov    dx,offset passiv
  stat_resi1:
call   stat_pri
mov    dx,offset loadre
  stat_rp:
call   stat_pri

  stat_plug:
mov    dx,offset noplug
test   cx,NOCARD
je     stat_pow
call   stat_pri
jmp    short stat_e

  stat_pow:
mov    dx,offset poww_t
mov    al,8
call   fcsr_rw
test   al,4
jne    stat_powoff
call   stat_pri
jmp    short stat_e
  stat_powoff:
mov    dx,offset powo_t
call   stat_pri
mov    ax,0e0dh
int    10h
mov    ax,0e0ah
int    10h

  stat_e:
ret

  stat_pri:
mov    ah,9
int    21h
ret

;-UP RESI_S----------------------------------------------------

  resi_s:
mov    bx,offset w_stru ;load offset read/write structure
mov    [bx].w_tlen,1
mov    [bx].w_boff,offset O_BUFF
mov    dx,offset cbi
mov    ah,9
int    21h
mov    dx,offset reg
mov    ah,9
int    21h
mov    dx,offset failed
mov    bx,offset r_stru
mov    [bx].r_func,3    ;register
mov    ax,0B000h        ;card bios request
int    1ah
jnc    resi_ok
mov    ah,9
int    21h
ret

  resi_ok:
mov    dx,offset ok     ;successful
mov    ah,9
int    21h
mov    dx,offset loadre
mov    ah,9
int    21h

not    word ptr [start]
mov    ax,ds:[002ch]    ;environement block
mov    es,ax
mov    ah,49h           ;release
int    21h
mov    al,fid
test   status,NOCARD
je     resi_1           ;a card is inserted
mov    al,-1            ;errorlevel -1: no card inserted
  resi_1:
mov    ah,31h
mov    dx,RPARA         ;paragraphs to keep
int    21h              ;stay resident

;-UP REMO_S----------------------------------------------------

  remo_s:
mov    es,resseg
mov    dx,offset cbi
mov    ah,9
int    21h
mov    dx,offset unreg
mov    ah,9
int    21h
mov    dx,offset failed
  remo_1:
mov    bx,offset r_stru
mov    es:[bx].r_func,4 ;unregister
mov    ax,0B000h        ;card bios request
int    1ah
jc     remo_end

not    byte ptr es:[start]  ;mark as removed
mov    ah,49h
int    21h

mov    dx,offset ok

  remo_end:
mov    ah,9
int    21h
mov    dx,offset remove
mov    ah,9
int    21h
ret

;-UP RSET_S----------------------------------------------------

  rset_s:
test   status,NOCARD
jne    rset_e           ;don't do with no card plugged in
call   addresses
jc     rset_e           ;don't do for unsupported cards
mov    dx,offset ssv
mov    ah,9
int    21h
mov    dx,offset failed
mov    ax,9000h
mov    bx,1
int    1ah
jc     rset_pri
mov    si,40
call   _wait
mov    dx,offset rset_t
  rset_pri:
mov    ah,9
int    21h
  rset_e:
ret

;-UP REGI_S----------------------------------------------------

  regi_s:
push   es
mov    es,resseg
and    es:status,not ISDISA ;set socket service enabled
pop    es
;test   steuer,RESI_P
;jne    regi_e           ;don't do if resident load wish
call   new_card         ;init manu string etc
pushf                   ;remember flags
call   stat_info        ;output manu and debug info
mov    dx,offset ssv
mov    ah,9
int    21h
mov    dx,offset failed
popf                    ;get back flags from new_card
jc     regi_enab        ;unsupported card found
call   enable
jc     regi_pri
  regi_enab:
mov    dx,offset enab
  regi_pri:
mov    ah,9
int    21h
  regi_e:
ret

;-UP UNRE_S----------------------------------------------------

  unre_s:
push   es
mov    es,resseg
or     es:status,ISDISA ;set socket service disabled
pop    es

mov    dx,offset ssv
mov    ah,9
int    21h

test   status,NOCARD
jne    unre_ok          ;ok for no card plugged in
call   addresses
jc     unre_ok          ;ok for unsupported cards

mov    dx,offset failed
call   disable
jc     unre_pri
  unre_ok:
mov    dx,offset disab
  unre_pri:
mov    ah,9
int    21h
ret

;-SUB-SUBROUTINES----------------------------------------------

;-UP RESIDENT--------------------------------------------------
;out: cf=0: LXCIC is loaded resident at segment resseg
;     cf=1: LXCIC is not loaded resident, resseg=DS

  resident:
pusha
push   es
cld
not    word ptr [start] ;was changed at upload
xor    bx,bx
mov    ax,cs            ;search up to cs
  resident_loop:        ;do for every paragraph
inc    bx               ;next paragraph
mov    es,bx            ;in es
cmp    ax,bx            ;done?
je     resident_e       ;end, hence not found
mov    si,offset start  ;offset in our code to compare
mov    di,si            ;offset in resident code
mov    cx,8             ;bytes to compare
rep    cmpsb            ;compare ds:si with es:di
jne    resident_loop    ;not found in this paragraph, loop
or     status,ISRESI
  resident_e:
mov    resseg,es
not    word ptr [start] ;reset to origin 
stc                     ;cf=1
mov    ax,ds
cmp    resseg,ax        ;resseg=DS?
je     resident_ee      ;yes,hence not resident
clc                     ;else resident
  resident_ee:
pop    es
popa
ret

resseg dw 0

;-UP RES2LOC---------------------------------------------------
;copy data from resident segment to local segment

  res2loc:
push   ax
push   es
mov    es,resseg
mov    ax,es:baselo
mov    baselo,ax
mov    ax,es:port
mov    port,ax
mov    al,es:cor
mov    cor,al
mov    al,es:fcsr
mov    fcsr,al
mov    al,es:fid
mov    fid,al
mov    al,es:tpcc
mov    tpcc,al
;copy manufacturer string to local segment
push   ds
push   es
push   es
pop    ds
push   cs
pop    es
mov    di,offset t_buff
mov    si,di
mov    cx,T_BUFL
rep    movsb
pop    es
pop    ds

pop    es
pop    ax
ret

;-UP FCSR_RW---------------------------------------------------

 fcsr_rw:
mov    cx,baselo
inc    cx
mov    bx,offset w_stru
mov    [bx].w_func,al   ;fkt
mov    [bx].w_clow,cx   ;from adr 101
mov    [bx].w_chig,0
call   bios_req
mov    al,o_buff
mov    fcsr,al
ret

;-UP STAT_INFO-------------------------------------------------

  stat_info:
pusha
cmp    t_buff,' '
je     stat_infoe
mov    dx,offset t_buff+3
mov    ah,9
int    21h
cmp    cor,-1            ;new since ver 1.2
je     stat_infoe
call   debug
mov    dx,offset debug0
mov    ah,9
int    21h

  stat_infoe:
popa
ret

;-UP DEBUG-----------------------------------------------------

  debug:
mov    ax,port
mov    bx,4
mov    di,offset debug1
call   wan

xor    ah,ah
mov    al,cor
mov    bx,2
mov    di,offset debug2
call   wan

test   byte ptr tpcc,2
je     debug_1
mov    al,fcsr
mov    di,offset debug3
call   wan
  debug_1:
mov    bx,4
mov    ax,baselo
mov    di,offset debug4
call   wan

mov    al,fid
mov    bx,2
mov    di,offset debug5
call   wan
ret

;-UP SAVE------------------------------------------------------

;write cx bytes starting at bp to the file in dx

  save:
push   cx               ;save length
mov    ah,03ch          ;create or truncate to 0
xor    cx,cx            ;normal file attribute
int    21h
pop    cx               ;restore length
jc     save_error
mov    bx,ax            ;file handle has to be in bx

mov    ah,40h           ;write cx bytes
mov    dx,bp            ;take from here
int    21h
jc     save_error

mov    ah,3eh           ;close file
int    21h
jc     save_error
ret                     ;return without carry

  save_error:
lea    dx,error         ;"file error"
mov    ah,9
int    21h
stc
ret                     ;return with carry

error  db 'file error',13,10,'$' ;error string

;-UP _WAIT-----------------------------------------------------

  _wait:
push  es
xor   cx,cx             ;counter
mov   es,cx
mov   ah,2
mov   dl,'9'
mov   bp,4
  _wait1:
mov   bx,es:[046ch]     ;get tick
  _wait2:
cmp   bx,es:[046ch]     ;still same tick?
je    _wait2
dec   bp
jne   _wait3
int   21h
push  dx
mov   dl,8
int   21h
pop   dx
dec   dx
mov   bp,4

  _wait3:
inc   cx
cmp   cx,si
jne   _wait1
pop   es
clc
ret

;-UP ASCHEX----------------------------------------------------

;convert ascii al to hex al

IFDEF BRUTE
  aschex:
cmp    al,'0'
jl     asc_err
cmp    al,'9'
jle    asc_num
and    al,0dfh
cmp    al,'A'
jl     asc_err
cmp    al,'F'
jg     asc_err
sub    al,'7'
jmp    short asc_ok
  asc_num:
sub    al,'0'
  asc_ok:
clc
ret
  asc_err:
stc
ret
ENDIF

;-UP WAN-------------------------------------------------------

;store ax as [base] number with bx digits at es:di (leading 0)

  wan:
push   ax
push   bx
push   cx
xor    cx,cx
mov    cx,bx
  wan_1:
xor    dx,dx
div    base
push   dx
loop   wan_1
mov    cx,bx
  wan_2:
pop    ax
add    al,'0'
cmp    al,'9'
jna    wan_3
add    al,7
  wan_3:
stosb
loop   wan_2
pop    cx
pop    bx
pop    ax
ret

base   dw 16            ;convert to hex

;-DATA (MUST KEEP ORDER FOR CONCATENATING STRINGS)-------------

logo   db 13,10
       db 'LXCIC v2.0 (c) 99 Stefan Peichl, Heidelberg',13,10
       db '',13,10,'$'
help   db 'HP200LX PCMCIA I/O Card Installation Client',13,10
       db ' Resident or Nonresident Use ',13,10,13,10
       db 9,'Use LXCIC [/switches]',13,10,13,10
       db 9,'L   Load Resident',13,10
       db 9,'U   Unload Resident',13,10
       db 9,'O   Power Down Card',13,10
       db 9,'W   Power Up Card',13,10
       db 9,'D   Disable LXCIC',13,10
       db 9,'E   Enable LXCIC',13,10
       db 9,'P   Pulse Mode IR',13,10
       db 9,'R   Reset Card',13,10
       db 9,'S   Status Display',13,10
       db 9,'T   Tuple Display + Save',13,10
IFDEF BRUTE
       db 9,'x   Use Cards COMx(=1-4)',13,10
       db 9,'=xx Use COR=xx BASE=0100',13,10
ENDIF
       db '',13,10,'$'
cbi    db 'CardBios $'
unreg  db 'un'
reg    db 'registration $'
ssv    db 'SocketService $'
enab   db 'I/O enabled',13,10,'$'
disab  db 'I/O disabled',13,10,'$'
isres  db 'not possible if loaded resident',13,10,'$'
notres db 'not '
loadre db 'loaded resident',13,10,'$'
active db 'active $'
passiv db 'passive $'
remove db 'unloaded resident',13,10,'$'
ok     db 'successful',13,10,'$'
failed db 'failed',13,10,'$'
noplug db 'no Card inserted',13,10,'$'
rset_t db 'Card reset',13,10,'$'
powo_t db 'Card Power down $'
poww_t db 'Card powered',13,10,'$'
w_info db 13,10,'Creating files '
raw    db 'TPL.RAW',0,'and '
txt    db 'TPL.TXT',0,13,10,'$'
tup_t  db 13,10,'Tuple '
debug0 db 'ADR='
debug1 db '....  COR='
debug2 db '..  FCSR='
debug3 db 'na  BASE='
debug4 db '....  ID='
debug5 db '..',13,10,'$'

IFDEF BRUTE
ports  dw 03f8h,02f8h,03e8h,02e8h
ENDIF

upsh:
dw RESI_S 
dw STAT_S
dw POWO_S
dw TUPL_S
dw CORE_S       
dw REGI_S
dw RSET_S
dw UNRE_S
dw REMO_S
dw PULS_S
dw POWW_S
dw PORT_S
dw 0
dw 0
dw 0
upsl   dw 0

;-TEMPORARY DATA-----------------------------------------------

buffer equ $
tuples equ $ + N_BUFL

cseg   ends
       end start
