program rtf2vdf;
{$A+}
{*$R+}
{ version 1.0
  (c) Pavel Zampach, 2004
  source text for Turbo Pascal compiler
}

uses
  TrLate, RTFparse, Unicode;

const
  VDE_Under  = #$13;
  VDE_Bold   = #$02;
  VDE_Ital   = #$19;
  VDE_Super  = #$14;
  VDE_Sub    = #$16;
  VDE_Strike = #$18;
  VDE_Page   = #$0C;
  VDE_Tab    = #$09;
  VDE_SHyph  = #$1C;
  
  MAX_STACK  = 32;

  BUnder  : boolean = false;
  BBold   : boolean = false;
  BItal   : boolean = false;
  BSuper  : boolean = false;
  BSub    : boolean = false;
  BStrike : boolean = false;

var
  Stack   : array [1 .. MAX_STACK] of string [6];
  SP, FormChar, i, Code, SkipCount, SkipChar : integer;
  OFile   : text;
  Line    : string;
  LL      : byte absolute Line;
  LineLen : byte;
  Par     : string [80];
  ParT    : string [2];
  PMOut   : boolean;

{-------------------------------------------------------------------------------}

procedure prErrorHandle (msg : string); far;

begin
  writeln;
  writeln (msg);
  writeln;
{$I-}  
  close (OFile);
{$I+}
  halt (1);
end;

{-------------------------------------------------------------------------------}

procedure trimForm (var fc : integer; tc : char);

begin
  if tc = VDE_Tab then
    fc := (fc + 8) and $F8
  else
    if tc >= ' ' then inc (fc);
end;

{-------------------------------------------------------------------------------}

procedure flushLine;

begin
  while (LL > 0) and ((Line[LL] = ' ') or (Line[LL] = VDE_Tab)) do
    dec (LL);
  writeln (OFile, Line);
  Line := '';
  FormChar := 0;
end;

{-------------------------------------------------------------------------------}

procedure prTextChar (oc : char); far;

var
  q, i : integer;
  tc, LastChar   : char;

begin
  if SkipCount > 0 then begin
    dec (SkipCount);
    exit;
  end;
  tc := trChar (oc);
  if tc = #0 then exit;
  if ((tc < ' ') and PMOut) then exit;

  if LL > 0 then LastChar := Line [LL]
            else LastChar := #0;

  if tc = VDE_Under then begin
    BUnder  := not BUnder;
    if LastChar = VDE_Under then begin
      dec (LL);
      exit
    end
  end;
  if tc = VDE_Bold then begin
    BBold   := not BBold;
    if LastChar = VDE_Bold then begin
      dec (LL);
      exit
    end
  end;
  if tc = VDE_Ital then begin
    BItal   := not BItal;
    if LastChar = VDE_Ital then begin
      dec (LL);
      exit
    end
  end;
  if tc = VDE_Super then begin
    BSuper  := not BSuper;
    if LastChar = VDE_Super then begin
      dec (LL);
      exit
    end
  end;
  if tc = VDE_Sub then begin
    BSub    := not BSub;
    if LastChar = VDE_Sub then begin
      dec (LL);
      exit
    end
  end;
  if tc = VDE_Strike then begin
    BStrike := not BStrike;
    if LastChar = VDE_Strike then begin
      dec (LL);
      exit
    end
  end;

  Line := Line + tc;
  trimForm (FormChar, tc);
  if FormChar >= LineLen then begin
    q := 0;
    for i := 1 to LL do
      if Line [i] = ' ' then q := i;
    if q = 0 then
      flushLine
    else begin
      writeln (OFile, copy (Line, 1, q));
      Line := copy (Line, q + 1, 255);
      FormChar := 0;
      for i := 1 to LL do
        trimForm (FormChar, Line [i]);
    end;
  end;
end;

{-------------------------------------------------------------------------------}

procedure pairMark (c : char);

var
  q : integer;

begin
  prTextChar (c);
  q := pos (c, Stack[SP]);
  if q = 0 then
    Stack[SP] := c + Stack[SP]
  else
    delete (Stack[SP] , q, 1);
end;

{-------------------------------------------------------------------------------}

procedure closeStyles;

begin
  if BUnder  then pairMark (VDE_Under);
  if BBold   then pairMark (VDE_Bold);
  if BItal   then pairMark (VDE_Ital);
  if BSuper  then pairMark (VDE_Super);
  if BSub    then pairMark (VDE_Sub);
  if BStrike then pairMark (VDE_Strike);
end;

{-------------------------------------------------------------------------------}

procedure prSpecChar (c : char); far;

begin
  case c of
    '~' : prTextChar (' ');
    '-' : prTextChar (VDE_SHyph);
    '_' : prTextChar ('-');
    '*' : skipGroup;
  end;  
end;

{-------------------------------------------------------------------------------}

procedure prUnicode (UCode : integer);

var
  c : char;

begin
  c := trUCode (UCode);
  if c > #0 then begin
    prTextChar (c);
    SkipCount := SkipChar;
  end
  else
    if SkipChar = 0 then prTextChar ('?');
end;

{-------------------------------------------------------------------------------}

procedure prControlWord (CW, CWP : string); far;

var
  CWN : integer;

begin
  val (CWP, CWN, Code);
  if CW = 'par'    then begin flushLine; exit end;
  if CW = 'cell'   then begin prTextChar (VDE_Tab); exit end;
  if CW = 'tab'    then begin prTextChar (VDE_Tab); exit end;
  if ((CW = 'b') and (BBold xor (CWP <> '0'))) then begin pairMark (VDE_Bold); exit end;
  if CW = 'u'      then begin prUnicode (CWN); exit end;
  if CW = 'plain'  then begin closeStyles; exit end;
  if ((CW = 'i') and (BItal xor (CWP <> '0'))) then begin pairMark (VDE_Ital); exit end;
  if CW = 'row'    then begin flushLine; exit end;
  if ((CW = 'ul') and (BUnder xor (CWP <> '0'))) then begin pairMark (VDE_Under); exit end;
  if CW = 'ulnone' then begin
    if BUnder then pairMark (VDE_Under);
    exit
  end;  

  if CW = 'fonttbl'   then skipGroup;
  if CW = 'colortbl'  then skipGroup;
  if CW = 'stylesheet' then skipGroup;
  if CW = 'filetbl'   then skipGroup;
  if CW = 'footer'    then skipGroup;
  if CW = 'footerr'   then skipGroup;
  if CW = 'footerl'   then skipGroup;
  if CW = 'footerf'   then skipGroup;
  if CW = 'header'    then skipGroup;
  if CW = 'headerr'   then skipGroup;
  if CW = 'headerl'   then skipGroup;
  if CW = 'headerf'   then skipGroup;
  if CW = 'pict'      then skipGroup;
  if CW = 'info'      then skipGroup;
  if CW = 'uc'        then SkipChar := CWN;
  if CW = 'line'      then flushLine;
  if CW = 'sect'      then flushLine;
  if CW = 'bullet'    then prTextChar ('*');
  if CW = 'endash'    then prTextChar ('-');
  if CW = 'emdash'    then prTextChar ('-');
  if CW = 'enspace'   then prTextChar (' ');
  if CW = 'emspace'   then prTextChar (' ');
  if CW = 'lquote'    then prTextChar ('''');
  if CW = 'rquote'    then prTextChar ('''');
  if CW = 'ldblquote' then prTextChar ('"');
  if CW = 'rdblquote' then prTextChar ('"');
  if ((CW = 'strike') and (BStrike xor (CWP <> '0'))) then pairMark (VDE_Strike);
  if CW = 'super'     then pairMark (VDE_Super);
  if CW = 'sub'       then pairMark (VDE_Sub);
  if CW = 'up'        then pairMark (VDE_Super);
  if CW = 'dn'        then pairMark (VDE_Sub);
  if CW = 'nosupersub' then begin
    if BSuper then pairMark (VDE_Super);
    if BSub   then pairMark (VDE_Sub);
  end;
  if CW = 'page'      then begin
    prTextChar (VDE_Page);
    flushLine;
  end;
end;

{-------------------------------------------------------------------------------}

procedure prStartGroup (Level : integer); far;

begin
  SP := Level;
  if SP > MAX_STACK then 
    prErrorHandle ('Too many group level!');
  Stack [SP] := '';
end;

{-------------------------------------------------------------------------------}

procedure prEndGroup (Level : integer); far;

var
  i : integer;

begin
  for i := 1 to length (Stack [SP]) do
    textChar (Stack [SP][i]);
  SP := Level;
end;

{-------------------------------------------------------------------------------}

begin {main}
  startGroup  := prStartGroup;
  endGroup    := prEndGroup;
  controlWord := prControlWord;
  textChar    := prTextChar;
  specChar    := prSpecChar;
  errorHandle := prErrorHandle;

  if ParamCount < 2 THEN
    prErrorHandle ('USAGE: RTF2VDE InFile OutFile [-l#] [-x] [-tFilename] [-uFilename]');

  assign (OFile, paramStr (2));
{$I-}
  rewrite (OFile);
{$I+}
  if IOResult <> 0 then
    prErrorHandle (paramStr (2) + ' can''t be open!');

  FormChar  := 0;
  Line      := '';
  LineLen   := 64;
  PMOut     := false;
  SkipCount := 0;
  SkipChar  := 1;

  for i := 3 to paramCount do begin
    Par := ParamStr (i);
    ParT:= Par[1] + upCase (Par[2]);
    if ParT = '-X' then
      PMOut := true;
    if ParT = '-T' then
      loadTrTable (copy (Par, 3, 255));
    if ParT = '-U' then
      loadUniTable (copy (Par, 3, 255));
    if ParT = '-L' then begin
      val (copy (Par, 3, 255), LineLen, Code);
      if LineLen = 0 then LineLen := 64
    end;  
  end;

  parse (paramStr (1));

  if LL > 0 then flushLine;
  close (OFile);

end.