/*
 * Icon Selector
 * SELICN Version 1.00
 * Copyright (C) 1995 Hiroyuki Sekiya
 */

#include <lxapi.h>
#include <cougraph.h>
#include <string.h>

#define ENTERKEY		0x0D
#define ESCKEY			0x1B
#define PASTEKEY		0xD600
#define ALTIKEY			0x1700
#define ALTPKEY			0x1900

char far *msgAppName	= "SELICN";
char far *msgTitle		= "Select Icon File";
char far *msgOk			= "OK";
char far *msgCancel		= "Cancel";
char far *msg_FOpen		= "File to &Open";
char far *msg_Files		= "&Files";
char far *msg_Dirs		= "&Directories";
char far *msgDir		= "Directry:";

LHAPIBLOCK LHAPIData;
EVENT_NORM Event;
BOOL Done = FALSE;

char EnvPath[]			= "a:\\_dat\\selicn.env";

char FullPath[80];
char Directory[80];
char FileSpec[80];
char WildCard[]			= "*.icn";

#define FILECOUNT	128
#define FILELENGTH	13
char *FileList[FILECOUNT];
char FileSpace[FILECOUNT][FILELENGTH];

#define DIRCOUNT	64
#define DIRLENGTH	13
char *DirList[DIRCOUNT];
char DirSpace[DIRCOUNT][DIRLENGTH];


/***************************************************************************
* Misc
***************************************************************************/

/*
 * Nbv{[hւ̃̕Rs[
 */
void CopyToClipboard(const char *Data)
{
	m_lock();
	if (m_open_cb() == 0) {
		m_reset_cb("MemUtil");
		m_new_rep("TEXT");
		m_cb_write(Data, strlen(Data));
		m_fini_rep();
		m_close_cb();
	}
	m_unlock();
}

void __int__(int interruptnum);
#define geninterrupt(i) __int__(i)

/*
 * L[obt@ւ̃L[R[h
 */
void PushKey(WORD KeyCode)
{
	_CX = KeyCode;
	_AH = 0x05;
	geninterrupt(0x16);
}

void PushString(WORD *Keys, int count)
{
	while (count--) PushKey(*Keys++);
}

BOOL ReadEnvFile(const char *filename)
{
	int len;
	NBFILE fp;

	if (m_openro(&fp, filename, strlen(filename), 0, 1) != 0) {
		Directory[0] = '\0';
		return FALSE;
	}
	m_read(&fp, Directory, sizeof(Directory), &len);
	m_close(&fp);
	return TRUE;
}

BOOL WriteEnvFile(const char *filename)
{
	NBFILE fp;

	if (m_fcreat(&fp, filename, strlen(filename), 0, 1) != 0)
		return FALSE;
	m_write(&fp, Directory, sizeof(Directory));
	m_close(&fp);
	return TRUE;
}


/***************************************************************************
* Function Key
***************************************************************************/

LHFKEY CanOkFKeys[] = {
	{ (PLHRES)&msgCancel, (PLHFUNC)CMD_ESC, 9, FKEY_SENDMSG },
	{ (PLHRES)&msgOk, (PLHFUNC)CMD_DONE, 10+FKEY_LAST, FKEY_SENDMSG }
};


/***************************************************************************
* Icon
***************************************************************************/

#define ICON_WIDTH	44
#define ICON_HEIGHT	32

int far Icon(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra)
{
	NBFILE	fp;
	static char icon_buf[200];
	int		x, y;
	int		len;

	switch (Msg) {
	case DRAW:
		x = Wnd->x; y = Wnd->y;
/*
		if ((Wnd->Style & STYLE_XYRELATIVE) != 0 && Wnd->Parent != NULL) {
			x += Wnd->Parent->x;
			y += Wnd->Parent->y;
		}
		ftHŐe_CAȎ΍WɂȂ݂
*/
		if ((Data & DRAW_FRAME) != 0 && (Wnd->Style & STYLE_NOBORDER) == 0)
			Outline(x, y, ICON_WIDTH+2, ICON_HEIGHT+2);
		if (Data & DRAW_CLIENT) {
			if (m_openro(&fp, Wnd->Data, strlen(Wnd->Data), 0, 1) == 0) {
				m_read(&fp, icon_buf, sizeof(icon_buf), &len);
				m_close(&fp);
				if (((ULONG *)icon_buf)[0] == 0x00010001
				 && ((ULONG *)icon_buf)[1] == 0x0020002C) {
					G_ImagePut(x+1, y+1, icon_buf, G_FORCE);
					break;
				}
			}
			ClearRect(x+1, y+1, ICON_WIDTH, ICON_HEIGHT);
		}
		break;
	}
	return SubclassMsg(Object, Wnd, Msg, Data, Extra);
}


/***************************************************************************
* File Open Dialog
***************************************************************************/

int far FOpenDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra);
int far FListHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra);
#define FileListWnd	FOpenDlgArray[2]
#define IconWnd		FOpenDlgArray[6]

LHWINDOW FOpenDlgArray[] = {
	{ Edit, 14, 17, 18, 1,
	  (PLHRES)&msg_FOpen, (PLHDATA)FileSpec, sizeof(FileSpec),
	  STYLE_WHCHAR | EDIT_INSERT | STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, (PLHMENU)&WildCard, NO_HELP },

	{ PathText, 14, 37, 22, 1,
	  (PLHRES)&msgDir, (PLHDATA)Directory, sizeof(Directory),
	  STYLE_NOBORDER | STYLE_WHCHAR | STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

	{ (PLHCLASS)FListHandler, 14, 54, 14, 6,
	  (PLHRES)&msg_Files, (PLHDATA)&FileList, countof(FileList),
	  STYLE_WHCHAR | STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, (PLHMENU)countof(FileList), NO_HELP },

	{ DirListBox, 170, 54, 14, 6,
	  (PLHRES)&msg_Dirs, (PLHDATA)&DirList, countof(DirList),
	  STYLE_WHCHAR | STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, (PLHMENU)countof(DirList), NO_HELP },

	{ PushButton, 326, 68, 0, 20,
	  (PLHRES)&msgOk, (PLHDATA)CMD_DONE, ENTERKEY,
	  PUSHB_SENDMSG | STYLE_PUSHBUTTON | STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

	{ PushButton, 326, 104, 0, 20,
	  (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
	  PUSHB_SENDMSG | STYLE_PUSHBUTTON | STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

	{ (PLHCLASS)Icon, 345, 22, 0, 0,
	  NULL, FullPath, 0,
	  STYLE_NOFOCUS | STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW FOpenDialog = {
	(PLHCLASS)FOpenDlgHandler, 134, 24, 416, 150,
	(PLHRES)&msgTitle, (PLHDATA)FOpenDlgArray, countof(FOpenDlgArray),
	STYLE_SAVEUNDER | STYLE_PUSHB_WIDTH | FILEOPEN_NODEFAULT,
	NULL, CanOkFKeys, NO_MENU, NO_HELP
};

void GetFullPath(void)
{
	strcpy(FullPath, Directory);
	if (strlen(FullPath) != 3)			/* 3 is strlen("d:\\") */
		strcat(FullPath, "\\");

	if (GetFocus() == &FileListWnd) {
		strcat(FullPath, FileList[FileListWnd.Selection]);
	} else {
		strcat(FullPath, FileSpec);
		if (strchr(FullPath, '.') == NULL)
			strcat(FullPath, WildCard+1);
	}
}

int far FListHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra)
{
	static LastSelection = -1;
	int Result = SubclassMsg(FileListBox, Wnd, Msg, Data, Extra);

	switch (Msg) {
	case KEYSTROKE:
		if (LastSelection == Wnd->Selection) break;
		/* SETFOCUS̏ɗ */
	case SETFOCUS:
		GetFullPath();
		SendMsg(&IconWnd, DRAW, DRAW_ALL, 0);
		LastSelection = Wnd->Selection;
		break;
	case LOSEFOCUS:
	case DESTROY:
		LastSelection = -1;
		break;
	}
	return Result;
}

int far FOpenDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra)
{
	WORD KeyMacro[] = {
		F3KEY, ALTPKEY, PASTEKEY, ALTIKEY, ESCKEY, F3KEY, F10KEY
	};

	switch (Msg) {
	case COMMAND:
		switch (Data) {
		case CMD_DONE:
			GetFullPath();
			CopyToClipboard(FullPath);
			PushString(KeyMacro, countof(KeyMacro));
			Data = CMD_ESC;
			Done = TRUE;
			return TRUE;
		case CMD_ESC:
			Done = TRUE;
			break;
		}
		break;
	}
	return SubclassMsg(FileOpenDialogBox, Wnd, Msg, Data, Extra);
}

void InitFileDialog(void)
{
	UINT i;

	for (i=0; i<FILECOUNT; ++i) FileList[i] = &FileSpace[i][0];
	for (i=0; i<DIRCOUNT; ++i)  DirList[i]  = &DirSpace[i][0];
}


void main(void)
{
	m_init_app(SYSTEM_MANAGER_VERSION);
	m_reg_app_name(msgAppName);
	InitializeLHAPI(&LHAPIData);
	SetDefaultFont(FONT_NORMAL);

	EnvPath[0] = 'a';
	if (!ReadEnvFile(EnvPath)) {
		EnvPath[0] = 'c';
		ReadEnvFile(EnvPath);
	}

	InitFileDialog();
	SendMsg(&FOpenDialog, CREATE, CREATE_FOCUS, 0);

	m_keylock();

	do {
		Event.do_event = DO_EVENT;
		m_action(&Event);
		switch(Event.kind) {
		case E_KEY:
			SendFocusMsg(KEYSTROKE, Event.data, Event.scan);
			break;
		case E_TERM:
			Done = TRUE;
			break;
		}
	} while (!Done);

	WriteEnvFile(EnvPath);

	Event.do_event = DO_FINI;
	m_action(&Event);
}
