/*
 * ZOOM Version 1.10
 * Copyright(C) 1995 Hiroyuki Sekiya
 */

#include <lxapi.h>
#include <task.h>

/* key codes */
#define SHIFTUPKEY	0x0038
#define SHIFTDOWNKEY	0x0032
#define SHIFTLEFTKEY	0x0034
#define SHIFTRIGHTKEY	0x0036
#define CTRLUPKEY	0x8D00
#define CTRLDOWNKEY	0x9100
#define CTRLLEFTKEY	0x7300
#define CTRLRIGHTKEY	0x7400
#define ALTUPKEY	0x7E81
#define ALTDOWNKEY	0x7E80
#define ALTLEFTKEY	0x7E89
#define ALTRIGHTKEY	0x7E82
#define MAKECTRL	0x7E04
#define BREAKCTRL	0xFE04
#define MAKESHIFT	0x7E83
#define BREAKSHIFT	0xFE83
#define MAKEALT		0x7E08
#define BREAKALT	0xFE08
#define ESCKEY		0x001B
#define ZOOMKEY		0xD000

/* vram address and interlace offset */
#define VRAMADDR	0xB8000000L
#define INTERLACE	0x2000

/* screen size (WIDTH is bytes) */
#define WIDTH		80
#define HEIGHT		200

/* scroll steps */
#define XSTEP		4
#define YSTEP		10

/* env-file options */
#define M_XZOOM		0x0001
typedef struct sOPTIONS {
	int		x;
	int		y;
	UINT	mode;
} OPTIONS;

/* global variables */
EVENT app_event;					/* Cxg\ */
BOOL done = FALSE;					/* ItO */
BOOL save_flag = TRUE;				/* ENVt@Cɏނ? */
char far *msgAppName = "ZOOM";		/* m_reg_app_name()œo^閼O */
char env_file_name[] = "A:\\_DAT\\ZOOM.ENV";	/* ݒt@C */
BYTE image[HEIGHT][WIDTH];			/* VRAMC[W܂߂̔z */

/* External symbols */
void memcpy(void far *dst, void far *src, UINT count);
void WidePut(void far *vram, BYTE *data);
long SearchSelectBar(BYTE *image);
void ClrScr(void);
long GetXY(void);
void pushkey(UINT key);
extern UINT hotkey;

/*
 * VRAM̓eimageobt@Ɋi[
 */
void GetImage(void)
{
	BYTE far *vram = (BYTE far*)VRAMADDR;
	UINT y;

	for (y=0; y < HEIGHT; y+=2) {
		memcpy(image[y], vram, WIDTH);
		memcpy(image[y+1], vram+INTERLACE, WIDTH);
		vram += WIDTH;
	}
}

/*
 * imageobt@̓eg債ĕ`
 */
void PutZoomedImage(OPTIONS *opt)
{
	BYTE far *vram = (BYTE far*)VRAMADDR;
	UINT y;

	if (opt->mode & M_XZOOM) {
		/* cY[. ɈL΂s2x` */
		for (y=0; y < HEIGHT/2; ++y) {
			WidePut(vram, &image[opt->y+y][opt->x]);
			WidePut(vram+INTERLACE, &image[opt->y+y][opt->x]);
			vram += WIDTH;
		}
	} else {
		/* cY[. s2x` */
		for (y=0; y < HEIGHT/2; ++y) {
			memcpy(vram, image[opt->y+y], WIDTH);
			memcpy(vram+INTERLACE, image[opt->y+y], WIDTH);
			vram += WIDTH;
		}
	}
}

/*
 * (ZOOM.EXM)̃zbgL[̃R[h擾
 */
UINT MyHotKey(void)
{
	typedef struct task TCB;
	TCB far *tcb;

	tcb = (TCB far *)m_get_TCB();
	return tcb[m_current_task()].t_hotkey;
}

BOOL LoadEnv(const char *filename, OPTIONS *opt)
{
	FILE fp;
	UINT len;

	if (m_openro(&fp, filename, strlen(filename), 0, 0) != 0)
		return FALSE;
	if (m_read(&fp, opt, sizeof(*opt), &len)!=0 || len==0) {
		m_close(&fp);
		return FALSE;
	}
	m_close(&fp);
	return TRUE;
}

BOOL SaveEnv(const char *filename, OPTIONS *opt)
{
	FILE fp;

	if (m_fcreat(&fp, filename, strlen(filename), 0, 0) != 0)
		return FALSE;
	if (m_write(&fp, opt, sizeof(*opt)) != 0) {
		m_close(&fp);
		return FALSE;
	}
	m_close(&fp);
	return TRUE;
}

/*
 * Database/Phone/NTaker̃f[^J[h\ĂTRUEԂ
 */
BOOL IsDataCard(void)
{
	return image[40][31] == 0x80					/* J[h[̏c_ */
		&& image[170][31] == 0x80					/*        V        */
		&& (image[184][76]^image[185][76]) == 0xFF;	/* J[h[̉ */
}

/*
 * J[\ʒuɉčœKȈʒuɃXN[
 */
void AdjustScroll(OPTIONS *opt)
{
	union sDWORD {
		long dw;
		struct {
			int x;
			int y;
		} w;
	} pos;

	if (IsDataCard()) {
		/* f[^J[h̍œKʒuɍ킹 */
		opt->x = 37;
		opt->y = 32;
		opt->mode |= M_XZOOM;
		save_flag = FALSE;
	} else {
		if ((pos.dw = SearchSelectBar(&image[0][0])) != 0) {
			opt->x = pos.w.x;
			pos.w.y -= 5;
		} else {
			if ((pos.dw = GetXY()) != 0) {
				pos.w.x >>= 3;		/* dot -> byte */
				/* J[\Z^O */
				if (pos.w.x < WIDTH/4)
					opt->x = 0;
				else if (pos.w.x > WIDTH/4*3)
					opt->x = WIDTH/2;
				else
					opt->x = pos.w.x - WIDTH/4;
			} else
				return;
		}
		/* J[\sZ^O */
		if (pos.w.y < HEIGHT/4)
			opt->y = 0;
		else if (pos.w.y > HEIGHT/4*3)
			opt->y = HEIGHT/2;
		else
			opt->y = pos.w.y - HEIGHT/4;
	}
}

void main(void)
{
	OPTIONS opt = {20, 50, 0};

	m_init_app(SYSTEM_MANAGER_VERSION);
	m_reg_app_name(msgAppName);

	/* load environment file (a: -> c:) */
	if (!LoadEnv(env_file_name, &opt)) {
		env_file_name[0] = 'C';
		LoadEnv(env_file_name, &opt);
	}

	/* get zoom.exm's hotkey code */
	hotkey = MyHotKey();

	/* draw zoomed image */
	GetImage();
	AdjustScroll(&opt);
	PutZoomedImage(&opt);

	/* disable task switching */
	m_keylock();

	do {
		app_event.norm.do_event = DO_EVENT;
		m_action(&app_event);
	CHECK_EVENT:
		switch (app_event.norm.kind) {
		case E_TERM:
			done = TRUE;
			break;
		case E_KEY:
			switch (app_event.norm.data) {
			case UPKEY:
				if ((opt.y -= YSTEP) < 0) opt.y = 0;
				PutZoomedImage(&opt);
				save_flag = TRUE;
				break;
			case DOWNKEY:
				if ((opt.y += YSTEP) > HEIGHT/2) opt.y = HEIGHT/2;
				PutZoomedImage(&opt);
				save_flag = TRUE;
				break;
			case LEFTKEY:
				if ((opt.x -= XSTEP) < 0) opt.x = 0;
				PutZoomedImage(&opt);
				save_flag = TRUE;
				break;
			case RIGHTKEY:
				if ((opt.x += XSTEP) > WIDTH/2) opt.x = WIDTH/2;
				PutZoomedImage(&opt);
				save_flag = TRUE;
				break;
			case SHIFTUPKEY:
				if (opt.y > 0) {
					--opt.y;
					PutZoomedImage(&opt);
					save_flag = TRUE;
				}
				break;
			case SHIFTDOWNKEY:
				if (opt.y < HEIGHT/2) {
					++opt.y;
					PutZoomedImage(&opt);
					save_flag = TRUE;
				}
				break;
			case SHIFTLEFTKEY:
				if (opt.x > 0) {
					--opt.x;
					PutZoomedImage(&opt);
					save_flag = TRUE;
				}
				break;
			case SHIFTRIGHTKEY:
				if (opt.x < WIDTH/2) {
					++opt.x;
					PutZoomedImage(&opt);
					save_flag = TRUE;
				}
				break;
			case ZOOMKEY:
				opt.mode ^= M_XZOOM;
				PutZoomedImage(&opt);
				save_flag = TRUE;
				break;
			case ESCKEY:
				done = TRUE;
				break;
			case MAKECTRL:  case BREAKCTRL:
			case MAKESHIFT: case BREAKSHIFT:
			case MAKEALT:   case BREAKALT:
				break;
			default:
				if (app_event.norm.scan == 0) break;
				/* zbgL[̍ĉŃY[ԂύX */
				if (app_event.norm.data == hotkey) {
					opt.mode ^= M_XZOOM;
					if (opt.mode & M_XZOOM)
						PutZoomedImage(&opt);
					else
						done = TRUE;
					save_flag = TRUE;
					break;
				}
				/* L[^XNɓnAɎɖ߂ */
				ClrScr();
				m_keyunlock();			/* enable task switching */
				pushkey(app_event.norm.data);
				app_event.norm.do_event = DO_YIELD;
				m_action(&app_event);
				m_keylock();			/* disable task switching */
				/* ߂Ăĕ` */
				GetImage();
				AdjustScroll(&opt);
				PutZoomedImage(&opt);
				goto CHECK_EVENT;
			}
			break;
		}
	} while (!done);

	if (save_flag) SaveEnv(env_file_name, &opt);
	ClrScr();
	app_event.norm.do_event = DO_FINI;
	m_action(&app_event);
}
