/*
 * Copyright (c) 2008 Luigi Rizzo, Riccardo Panicucci, Marta Carbone,
 *      Dipartimento di Ingegneria dell'Informazione, Universita` di Pisa.
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This header file contains the global declarations required for
 * a plugin plus possible features useful for X11, SDL and scriptable
 * plugins.
 *
 * $Id: myplugin.h 214 2008-05-22 11:21:11Z luigi $
 *
 */

/*
 * Note on the plugin architecture

The browser keeps a list of supported mime types and maps them to
internal methods or plugins.  The list is updated by reading from
from some OS-dependent locations of the filesystem whenever is needed
(e.g. when the browser is started).

On FreeBSD/linux, all files with a .so extension in
~/.mozilla/plugins/  and in a system-wide location are checked,
On Windows ? XXX
The check is done by loading the .so or .dll and calling the
NP_GetMIMEDescription() function (described below) to detect supported
types.

When the user opens a page containing a media type
that invokes a plug-in, e.g.

    <object data="/tmp/a.pdf" type="application/pdf" width="600" height="200">

the browser responds with the following actions:

1. look for a plug-in with a matching MIME type, load it in memory and
   call NP_Initialize().
   This is done only when the plugin needs to be loaded in memory.
2. create new istances of the plug-in one for each page that require them.
   This is done by calling the NPP_New() (or equivalent, see below);
3. when the user leaves the page or closes the window, the plug-in
   instance is deleted by calling NPP_Destroy() (or equivalent, see below);
4. when the last instance of a plug-in is deleted, the function NP_Shutdown()
   is called and then the plug-in code is unloaded from memory.

There are at least two plugin APIs:
- "NPAPI" is a specified API based on a number of C-style calls
  that declare both plugin-supplied (NPP_*()) and browser-supplied (NPN_*())
  functions. Sometimes the available documentation uses NP_*() to refer to
  the NPP_*() functions.

- the actual API is implemented through two structures exchanged between
  the browser and the plugin at init time, and specifying the
  plugin-supplied and browser-supplied functions.
  The two tables are arguments to
    NPError NP_Initialize(NPNetscapeFuncs* nsTable, NPPluginFuncs* pluginFuncs)
  XXX maybe this is OS-specific ?

A portable plugin should provide a glue layer that implements the
NPAPI using the second scheme described above.
Three functions are always implemented even in the second API:

char *NP_GetMIMEDescription(void)
    return a string containing the type, extension list, and type description.

NPError NP_Initialize(NPNetscapeFuncs* nsTable, NPPluginFuncs* pluginFuncs);
    stores NPNetscapeFuncs in a local variable, returns
    pluginFuncs to the browser

NPError NP_Shutdown(void);
    does whatever final cleanup is needed


In this header and the associated .c file we provide the required
#includes and #defines to create a plugin with some features,
and provide glue functions to implement the NPAPI.

At compile time you should define the following macros to support
the various functionalities:
WANT_X11	to support X11
WANT_SDL	to support SDL
 */


/*
 * Tell mozilla we are using an X11 platform. This must be done before
 * including the system headers.
 */
#ifdef WANT_X11
#define MOZ_X11
#endif

/* used for asprintf */
#ifdef __linux__
#define _GNU_SOURCE
#endif

/*
 * Include the necessary system headers
 */
#include "npapi.h"	/* prototypes for the Netscape Plugin v.4 API */
#include "npupp.h"	/* adaptation from the modern API to NPapi */

/* the local copy of the Netscape Function table, initialized by
 * our implementation of NP_Initialize
 */
#ifdef NPN_MACROS
/*
 * If we implement the NPAPI as macros, then we need the code below.
 * Otherwise we implement the functions in myplugin.h
 */
extern NPNetscapeFuncs __NPN; /* Netscape Function table */

#define NPN_CreateObject	__NPN.createobject
#define NPN_Evaluate		__NPN.evaluate
#define	NPN_GetProperty		__NPN.getproperty
#define	NPN_GetValue		__NPN.getvalue
#define NPN_GetStringIdentifier	__NPN.getstringidentifier
#define	NPN_ReleaseObject	__NPN.releaseobject
#define	NPN_ReleaseVariantValue	__NPN.releasevariantvalue
#define	NPN_RetainObject	__NPN.retainobject
#define	NPN_UTF8FromIdentifier	__NPN.utf8fromidentifier
#endif
extern NPError (*my_NP_Initialize)(NPNetscapeFuncs* npn, NPPluginFuncs* npp);


/* X11 and SDL stuff */
#ifdef WANT_X11
#include <X11/Intrinsic.h>
#endif

#ifdef WANT_SDL
#include <SDL/SDL.h>
#endif

#if 0 // documentation only
/*
 * We could describe a plugin instance with a struct.
 * The struct _instance descript the plugin instance. It contains data
 * belonging to a specific instance, as an example local variables,
 * and eventually a scriptable object associated with the plugin instance.
 * This struct will be stored in a private field of NPP struct, which is 
 * passed to the plugin when the browser call the function New().
 */

struct _instance {
	/* Here we store local variables */
	
	Window mWindow; /* Window id */
	int mX, mY; /* Left high corner coordinates of the window */
	int mWidth, mHeight; /* Window dimension */
	/* Variables for display a rectangle and a string */
	Display *mDisplay; 
	Widget mXtwidget;
	
	/* Variables concerning SDL */
	SDL_Surface *screen;
	Uint32 flags;
	int color;
};
#endif
