/*
 * Misc info for webcam support in the pwcbsd driver
 *
 *  Copyright (C) 2007 Luigi Rizzo
 *
 * BSD license as is this has been rewritten.
 */

#include "pwc.h"

struct id_desc {
	int id;
	char *desc;
};

static struct id_desc sensor_list[] = {
	{ SENSOR_UNKNOWN, "Unknown sensor" },
	{ SENSOR_SAA7113, "SAA 7113" },
	{ SENSOR_INTERNAL, "Integrated sensor" },
	{ SENSOR_HV7131B, "HV7131B" },
	{ SENSOR_HDCS1020, "HDCS1020" },
	{ SENSOR_PB100_BA, "PB100 BA" },
	{ SENSOR_PB100_92, "PB100 92" },
	{ SENSOR_PAS106_80, "PAS 106-80" },
	{ SENSOR_TAS5130C, "TAS 5130C" },
	{ SENSOR_ICM105A, "ICM 105A" },
	{ SENSOR_HDCS2020, "HDC S2020" },
	{ SENSOR_PAS106, "PAS 106" },
	{ SENSOR_PB0330, "PB 0330" },
	{ SENSOR_HV7131C, "HV 7131C" },
	{ SENSOR_CS2102, "CS 2102" },
	{ SENSOR_HDCS2020b, "HDCS 2020b" },
	{ SENSOR_HV7131R, "HV 7131R" },
	{ SENSOR_OV7630, "OV 7630" },
	{ SENSOR_MI0360, "MI 0360" },
	{ SENSOR_TAS5110, "TAS 5110" },
	{ SENSOR_PAS202, "PAS 202" },
	{ SENSOR_PAC207, "PAC 207 (Pixart)" },  /* CIF sensor from Pixart */
	{ SENSOR_OV7630C, "OV 7630C" },
	{ SENSOR_HDCS1000, "HDCS 1000 (Quickcam Express)" },
	{ SENSOR_BP100, "BP100 (same as PB 100?)" },
	{ SENSOR_VV6410, "VV 6410" },
	{ SENSOR_PAS302, "PAS 302" },
	{ SENSOR_PAS207, "PAS 207, same as PAC207 ?" },
		/* various sensors used on the pwc cameras */
	{ SENSOR_PWC_HYUNDAI, "Hyundai CMOS (pwc)" },
	{ SENSOR_PWC_TDA8787, "TDA 8787 (pwc)" },
	{ SENSOR_PWC_SONY_Exas98L59, "Sony + Exas 98L59" }, 
	{ SENSOR_PWC_SONY_ADI9804, "Sony + ADI 9804" },
	{ SENSOR_PWC_SHARP_TDA8787, "Sharp + TDA 8787" },
	{ SENSOR_PWC_SHARP_Exas98L59, "Sharp + Exas 98L59" },
	{ SENSOR_PWC_SHARP_ADI9804, "Sharp + ADI 9804" },
	{ SENSOR_PWC_UPA1021, "UPA 1021" },
	{ SENSOR_PWC_VGA, "PWC VGA sensor" },
	{ SENSOR_PWC_PAL_MR, "PWC PAL sensor" },
	{ SENSOR_PWC_UNKNOWN, "PWC, unknown sensor" },
	{ -1, NULL }
};

static struct id_desc bridge_list[] = {

    {BRIDGE_SPCA505, "SPCA505"},
    {BRIDGE_SPCA506, "SPCA506"},
    {BRIDGE_SPCA501, "SPCA501"},
    {BRIDGE_SPCA508, "SPCA508"},
    {BRIDGE_SPCA504, "SPCA504"},
    {BRIDGE_SPCA500, "SPCA500"},
    {BRIDGE_SPCA504B, "SPCA504B"},
    {BRIDGE_SPCA533, "SPCA533"},
    {BRIDGE_SPCA504C, "SPCA504C"},
    {BRIDGE_SPCA561, "SPCA561"},
    {BRIDGE_SPCA536, "SPCA536"},
    {BRIDGE_SONIX, "SN9C102"},
    {BRIDGE_ZC3XX, "ZC301-2"},
    {BRIDGE_CX11646, "CX11646"},
    {BRIDGE_TV8532, "TV8532"},
    {BRIDGE_ETOMS, "ET61XX51"},
    {BRIDGE_SN9CXXX, "SN9CXXX"},
    {BRIDGE_MR97311, "MR97311"},
    {BRIDGE_PAC207, "PAC207BCA"},
    {BRIDGE_STV0602, "STV0602"},
    {BRIDGE_EM2820, "EM2710/2820"},
    {-1, NULL}
};

static struct id_desc camera_list[] = {
    {UnknownCamera, "Unknown"},
    {IntelPCCameraPro, "Intel PC Camera Pro"},
    {IntelCreateAndShare, "Intel Create and Share"},
    {GrandtecVcap, "Grandtec V.cap"},
    {ViewQuestM318B, "ViewQuest M318B"},
    {ViewQuestVQ110, "ViewQuest VQ110"},
    {KodakDVC325, "Kodak DVC-325"},
    {MustekGsmartMini2, "Mustek gSmart mini 2"},
    {MustekGsmartMini3, "Mustek gSmart mini 3"},
    {CreativePCCam300, "Creative PC-CAM 300"},
    {DLinkDSC350, "D-Link DSC-350"},
    {CreativePCCam600, "Creative PC-CAM 600"},
    {IntelPocketPCCamera, "Intel Pocket PC Camera"},
    {IntelEasyPCCamera, "Intel Easy PC Camera"},
    {ThreeComHomeConnectLite, "3Com Home Connect Lite"},
    {KodakEZ200, "Kodak EZ200"},
    {MaxellMaxPocket, "Maxell Max Pocket LEdit. 1.3 MPixels"},
    {AiptekMiniPenCam2, "Aiptek Mini PenCam  2 MPixels"},
    {AiptekPocketDVII, "Aiptek PocketDVII  1.3 MPixels"},
    {AiptekPenCamSD, "Aiptek Pencam SD  2 MPixels"},
    {AiptekMiniPenCam13, "Aiptek mini PenCam 1.3 MPixels"},
    {MustekGsmartLCD3, "Mustek Gsmart LCD 3"},
    {MustekMDC5500Z, "Mustek MDC5500Z"},
    {MegapixV4, "Megapix V4"},
    {AiptekPocketDV, "Aiptek PocketDV "},
    {HamaUSBSightcam, "Hama USB Sightcam 100"},
    {Arowana300KCMOSCamera, "Arowana 300K CMOS Camera"},
    {MystFromOriUnknownCamera, "Unknow Ori Camera"},
    {AiptekPocketDV3100, "Aiptek PocketDV3100+ "},
    {AiptekPocketCam3M, "Aiptek PocketCam  3 M "},
    {GeniusVideoCAMExpressV2, "Genius VideoCAM Express V2"},
    {Flexcam100Camera, "Flexcam 100 Camera"},
    {MustekGsmartLCD2, "Mustek Gsmart LCD 2"},
    {PureDigitalDakota, "Pure Digital Dakota"},
    {PetCam, "PetCam"},
    {BenqDC1500, "Benq DC1500"},
    {LogitechClickSmart420, "Logitech Inc. ClickSmart 420"},
    {LogitechClickSmart510, "Logitech Inc. ClickSmart 510"},
    {BenqDC1300, "Benq DC1300"},
    {HamaUSBSightcam2, "Hama USB Sightcam 100 (2)"},
    {MustekDV3000, "Mustek DV 3000"},
    {CreativePccam750, "Creative PCcam750"},
    {MaxellCompactPM3, "Maxell Compact PC PM3"},
    {BenqDC3410, "Benq DC3410"},
    {BenqDC1016, "Benq DC1016"},
    {MicroInnovationIC200, "Micro Innovation IC200"},
    {LogitechTraveler, "Logitech QuickCam Traveler"},
    {Flycam100Camera, "FlyCam Usb 100"},
    {UsbGrabberPV321c, "Usb Grabber PV321c"},
    {ADSInstantVCD, "ADS Instant VCD"},
    {Gsmartmini, "Mustek Gsmart Mini"},
    {Jenoptikjdc21lcd, "Jenoptik DC 21 LCD"},
    {LogitechClickSmart310, "Logitech ClickSmart 310"},
    {Terratec2move13, "Terratec 2 move 1.3"},
    {MustekDV4000, "Mustek DV4000 Mpeg4"},
    {AiptekDV3500, "Aiptek DV3500 Mpeg4"},
    {LogitechClickSmart820, "Logitech ClickSmart 820"},
    {Enigma13, "Digital Dream Enigma 1.3"},
    {Sonix6025, "Xcam Shanga"},
    {Epsilon13, "Digital Dream Epsilon 1.3"},
    {Nxultra, "Creative Webcam NX ULTRA"},
    {AiptekPocketCam2M, "Aiptek PocketCam 2Mega"},
    {DeMonUSBCapture, "3DeMON USB Capture"},
    {CreativeVista, "Creative Webcam Vista"},
    {PolaroidPDC2030, "Polaroid PDC2030"},
    {CreativeNotebook, "Creative Notebook PD1171"},
    {CreativeMobile, "Creative Mobile PD1090"},
    {LabtecPro, "Labtec Webcam Pro"},
    {MustekWcam300A, "Mustek Wcam300A"},
    {GeniusVideoCamV2, "Genius Videocam V2"},
    {GeniusVideoCamV3, "Genius Videocam V3"},
    {GeniusVideoCamExpressV2b, "Genius Videocam Express V2 Firmware 2"},
    {CreativeNxPro, "Creative Nx Pro"},
    {Sonix6029, "Sonix sn9c10x + Pas106 sensor"},
    {Vimicro, "Z-star Vimicro zc0301p"},
    {Digitrex2110, "ApexDigital Digitrex2110 spca533"},
    {GsmartD30, "Mustek Gsmart D30 spca533"},
    {CreativeNxPro2, "Creative NX Pro FW2"},
    {Bs888e, "Kowa Bs888e MicroCamera"},
    {Zc302, "Z-star Vimicro zc0302"},
    {CreativeNoteBook2, "Creative Notebook PD1170"},
    {AiptekSlim3200, "Aiptek Slim 3200"},
    {LabtecWebcam, "Labtec Webcam"},
    {QCExpress, "QC Express"},
    {ICM532cam, "ICM532 cam"},
    {MustekGsmart300, "Mustek Gsmart 300"},
    {CreativeLive, "Creative Live! "},
    {MercuryDigital, "Mercury Digital Pro 3.1Mp"},
    {Wcam300A, "Mustek Wcamm300A 2"},
    {CreativeVista3b, "Creative Webcam Vista 0x403b"},
    {VeoStingray1, "Veo Stingray 1"},
    {VeoStingray2, "Veo Stingray 2"},
    {TyphoonWebshotIIUSB300k, " Typhoon Webshot II"},
    {PolaroidPDC3070, " Polaroid PDC3070"},
    {QCExpressEtch2, "Logitech QuickCam Express II"},
    {QCforNotebook, "Logitech QuickCam for Notebook"},
    {QCim, "Logitech QuickCam IM"},
    {WebCam320, "Micro Innovation WebCam 320"},
    {AiptekPocketCam4M, "Aiptek Pocket Cam 4M"},
    {AiptekPocketDV5100, "Aiptek Pocket DV5100"},
    {AiptekPocketDV5300, "Aiptek Pocket DV5300"},
    {SunplusGeneric536, "Sunplus Generic spca536a"},
    {QCimA1, "Logitech QuickCam IM + sound"},
    {QCchat, "Logitech QuickCam chat"},
    {QCimB9, "Logitech QuickCam IM ???"},
    {Labtec929, "Labtec Webcam Elch2 "},
    {Etoms61x151, "QCam Sangha"},
    {Etoms61x251, "QCam xxxxxx"},
    {PalmPixDC85, "PalmPix DC85"},
    {Optimedia, "Optimedia TechnoAME"},
    {ToptroIndus, "Toptro Industrial"},
    {AgfaCl20, "Agfa ephoto CL20"},
    {LogitechQC92c, "Logitech QuickCam chat"},
    {SonixWC311P, "Sonix sn9c102P Hv7131R"},
    {Concord3045, "Concord 3045 spca536a"},
    {Mercury21, "Mercury Peripherals Inc."},
    {CreativeNX, "Creative NX"},
    {CreativeInstant1, "Creative Instant P0620"},
    {CreativeInstant2, "Creative Instant P0620D"},
    {QuickCamNB, "Logitech QuickCam for Notebooks"},
    {WCam300AN, "Mustek WCam300AN "},
    {LabtecWCPlus, "Labtec Webcam Plus"},
    {GeniusVideoCamMessenger, "VideoCam Messenger sn9c101 Ov7630"},
    {Pcam, "Mars-Semi Pc-Camera MR97311 MI0360"},
    {GeniusDsc13, "Genius Dsc 1.3 Smart spca504B-P3"},
    {MustekMDC4000, "Mustek MDC4000"},
    {LogitechQCCommunicateSTX, "Logitech QuickCam Communicate STX"},
    {Lic200, "LG LIC-200"},
    {SweexTas5110, "Sweex SIF webcam"},
    {Pccam168, "Sonix PcCam"},
    {Sn535, "Sangha 350k"},
    {Pccam, "Sonix Pccam +"},
    {Lic300, "LG Lic-300"},
    {PolaroidIon80, "Polaroid Ion 80"},
    {Zc0305b, "Generic Zc0305b"},
    {BtcPc380, "Sonix Btc PC380"},
    {LogitechNotebookDeluxe, "Logitech Notebook Deluxe"},
    {LabtecNotebook, "Labtec Webcam Notebook"},
    {JvcGcA50, "JVC GC-A50"},
    {SmileIntlCamera, "Smile International"},
    {PcCam350, "PC-Cam350"},
    {PAC207, "Pixart PAC207-BCA"},
    {QtecWb100, "Qtec Webcam 100"},
    {GeniusGe111, "Genius VideoCam Ge111"},
    {Vimicro303b, "Generic Vimicro 303b"},
    {CyberpixS550V, "Mercury Cyberpix S550V"},
    {GeniusGF112, "Genius GF112"},
    {LogitechQCim, "Logitech QCIM"},
    {AiptekSlim3000F, "Aiptek Slim3000F"},
    {CTXM730VCam, "CTX M730V built in Cam"},
    {GeniusVideoCamNB, "Genius VideoCAM NB"},
    {CreativeVistaPlus, "Creative Webcam Vista Plus"},
    {PhilipsSPC200NC, "Philips SPC200NC "},
    {PhilipsSPC700NC, "Philips SPC700NC "},
    {SpeedNVC350K, "Speed NVC 350K "},
    {Mustek330K, "Mustek Digicam 330K "},
    {PhilipsSPC600NC, "Philips SPC600NC "},
    {PhilipsSPC300NC, "Philips SPC300NC "},
    {Sonix6019, "Sonix VGA Ov7630 "},
        {LogitechQCImage, "Logitech QuickCam Image "},
        {Sunplus500c, "Sunplus CA500C "},
        {MustekMDC3500, "Mustek MDC3500"},
        {LogitechQCCool, "Logitech QuickCam Cool"},
        {QCimconnect, "Logitech QuickCam IM/Connect "},
        {QCmessenger, "Logitech QuickCam Messenger "},
        {CreativeLiveCamNotebookPro, "Creative Live!Cam Notebook Pro (VF0250)"},
        {CreativeWebCamVistaPro, "Creative WebCam Vista Pro"},
        {CreativeLiveCamVideoIM, "Creative Live Cam Video IM"},
        {AiptekDV4100M, "Aiptek DV4100M"},
        {TyphoonEasyCam1_3, "Typhoon Easy Cam 1.3 MPix"},
        {Sonix0x613b, "Surfer model sn-206"},
        {Sonix0x60fb, "Surfer model noname"},
        {Sonyc002,"Vc0321"},
        {Vimicro0321,"Vc0321"},
        {Orbicam,"Logitech Orbicam"},
        {M$VX1000,"MicroSoft VX1000"},
        {Trust610LCDPowerCamZoom, "Trust 610 LCD PowerC@m Zoom"},
        {Sonyc001,"Sony Visual Communication VGP-VCC1"},
    {DexxaWebcam, "Dexxa/Labtec cam "},
    {SilverCrest, "Silvercrest 1.3M "},
    {-1, NULL}
};

static const char *
map_key(int key, struct id_desc *p, const char *def)
{
	int i;
	for (i = 0; p[i].desc != NULL; i++)
		if (p[i].id == key)
			return p[i].desc;
	return def;
}

/*
 * Returns the description string for a given sensor or bridge index
 */
const char *
sensor_name(int sensor)
{
	return map_key(sensor, sensor_list, "Unknown sensor");
}
const char *
bridge_name(int bridge)
{
	return map_key(bridge, bridge_list, "Unknown bridge");
}

const char *
camera_name(int camera)
{
	return map_key(camera, camera_list, "Unknown camera");
}
