/***
 *** bridge.h
 *** include file for pcbridge 3.XX
 *** Largely based on FreeBSD's "netboot" sources.
 ***
 *** Original Author: Martin Renters Date: Dec/93
 ***
 *** modified: Luigi Rizzo - March 1996  for pcbridge 3.00
 ***/

#ifndef EXTERN
#define EXTERN extern
#endif

#define MAX_CARDS	5 /* cant' put more on one board! */

#include "cpufunc.h"	/*& types and asm macros */

#ifndef NULL
#define NULL	((void *)0)
#endif

EXTERN int	jmp_restart[10];

#define ETHER_ADDR_SIZE		6	/* Size of Ethernet address */
#define ETHER_HDR_SIZE		14	/* Size of ethernet header */
#define ETH_MIN_PACKET		64
#define ETH_MAX_PACKET	 1520 /* a multiple of 4. Should be 1518 perhaps */ 

EXTERN struct eth_packet {
    u_short eth_dst[3];
    u_short eth_src[3];
    u_short eth_type;
    char body[ETH_MAX_PACKET-ETHER_HDR_SIZE];
} packet;
EXTERN int packetlen;

/***
 *** incoming packets are stored in a buffer, they can go into
 *** many queues. There is a global reference count, and a link field
 *** for each queue. The freelist uses next[0] as a link field.
 *** When a packet is in the freelist, the reference count is meaningless,
 *** although it ought to be zero.
 ***/
struct pkt_buf {
    long count;		/* reference count for the buffer */
    long len;
    struct pkt_buf *next[MAX_CARDS];
    struct eth_packet pkt;
};

EXTERN struct pkt_buf *buffers, *buf_free_list;
EXTERN short n_buffers, n_free;

extern struct pkt_buf *buf_alloc();
extern int buf_free(struct pkt_buf *);

/***
 *** A fast ethernet address comparison for 32-bit machines
 *** accepts a pointer to the addresses
 ***/
static inline eth_compare(u_short *a, u_short *b)
{
    return (a[0]==b[0] && a[1]==b[1] && a[2]==b[2]) ;
};

#define IP		0x0800
#define ARP		0x0806
#define IP_UDP		17
#define IP_BROADCAST	0xffffffffUL

struct iphdr {
	char verhdrlen;
	char service;
	u_short len;
	u_short ident;
	u_short frags;
	char ttl;
	char protocol;
	u_short chksum;
	char src[4];
	char dest[4];
};

struct udphdr {
    u_short src;
    u_short dest;
    u_short len;
    u_short chksum[1];
};

char *sprintf();

/***
 ***	variable declarations for the bridge
 ***/

u_long	curr_time;

#define	BIGLOOP_CTR	0
#define	COLLSN_CTR	1
#define	RXPKT_CTR	2/* XXX 4 */			/* received pkt */
#define	RXBYTES_CTR	(RXPKT_CTR+MAX_CARDS)
#define	LOCAL_DROP_CTR	(RXBYTES_CTR+MAX_CARDS)
#define	FILTERED_CTR	(LOCAL_DROP_CTR+MAX_CARDS)
#define	RXBDG_CTR	(FILTERED_CTR+MAX_CARDS)	/* bridge only */
#define	BROADCAST_CTR	(RXBDG_CTR+MAX_CARDS)
#define	MULTICAST_CTR	(BROADCAST_CTR+MAX_CARDS)
#define	UNKNOWN_CTR	(MULTICAST_CTR+MAX_CARDS)
#define	RXALL_CTR	(UNKNOWN_CTR+MAX_CARDS)		/* forward all */
#define	TXPKT_CTR	(RXALL_CTR+MAX_CARDS)
#define	DROP_CTR	(TXPKT_CTR+MAX_CARDS)
#define	LOOP_CTR	(DROP_CTR+MAX_CARDS)
#define	NUM_COUNTERS	12

#define	TX_DIAG_SIZE	1200	/* XXX check this */
#define MAX_CTRS	(LOOP_CTR+MAX_CARDS)

EXTERN struct _ctr {
    u_long low;
    u_short high, offset;
} counters[MAX_CTRS];

EXTERN u_long shadow_counters[MAX_CTRS];

#define COUNT(i)	shadow_counters[i]++
#define COUNTN(i,n) shadow_counters[i] += n

#define	HASH_SIZE	8192
#define HASH_TABLE_BASE (struct hash_table *)0x30000

#define	HASH_FN(addr)	(( (addr)[2] ^ (addr)[1] ) & (HASH_SIZE -1))


struct hash_table {
    u_short eth[3];	/* should check alignement. */
    u_short name;
};
EXTERN struct hash_table *bdg_table;

EXTERN	int	use_filters;

EXTERN	int	curr_if;
EXTERN u_short *video; /* points to the base video */
#define VIDEO_BASE_MONO		(u_short *)0xb0000
#define VIDEO_BASE_COLOR	(u_short *)0xb8000

extern	char hex[];
#define	WRITERC(r,c,x) \
	video[(r)*80+(c)] = (x)

EXTERN	u_short	bdg_flush_ptr;

struct ed_hdr {
    u_short flags; /* see IF_... */
#if 0
    struct edr_status {             /* received packet status       */
	u_char rs_prx:1,            /* packet received intack       */
	 rs_crc:1,            /* crc error            */
	 rs_fae:1,            /* frame alignment error        */
	 rs_fo:1,             /* fifo overrun         */
	 rs_mpa:1,            /* packet received intack       */
	 rs_phy:1,            /* packet received intack       */
	 rs_dis:1,            /* packet received intack       */
	 rs_dfr:1;            /* packet received intack       */
    } ed_rcv_status;                /* received packet status       */
#endif
    u_char rcv_status;
    u_char  next_packet;            /* pointer to next packet       */
    u_short count;                  /* bytes in packet (length + 4) */
    u_char eth_dst[ETHER_ADDR_SIZE];
    u_char eth_src[ETHER_ADDR_SIZE];
    u_short eth_type;
    u_char eth_body[ETH_MAX_PACKET]; /* actually less */
};
 

struct if_vars {
    u_short	flags;		/*** pcbridge if flags		***/
#define	IF_DISABLE	0x1
#define	IF_SENDING	0x2

    u_long  eth_flags;		/*** board flags		***/
#define FLAG_PIO	0x01
#define FLAG_16BIT	0x02
#define FLAG_790	0x04

    u_char  eth_vendor;		/*** board vendor		***/
#define	VENDOR_NONE	0
#define VENDOR_WD	1
#define VENDOR_NOVELL	2
#define VENDOR_3COM	3
#define VENDOR_3C509	4
#define VENDOR_DEC	5	/* 21140 ? */
#define VENDOR_SINK	10

    u_short	eth_nic_base;
    u_short	eth_asic_base;

    u_char	eth_tx_start;
    u_char	eth_laar;
    u_char	eth_memsize;
    u_char	*eth_bmem;
    u_char	*eth_rmem;
    u_char	proto;		/*** difference between 790 and 690 ***/

    u_short	eth_node_addr[3];

    u_short	name;
    u_short	queued;		/*** queued buffers ***/
    u_char	last_stat_sent;
    u_char	tx_status;

    u_char	dest;	/* should the packet be forwarded ? */
#define	DEST_NONE	0x1F	/* no destination */
/*** or set to i to specify interface i ***/
#define	DEST_BDG	0x80	/* goes to the bridge */
#define	DEST_ALL	0x40	/* goes to all */

    u_short	rst_ctr;
    long  tx_delay;
    struct pkt_buf *tx_head, *tx_tail;
};

EXTERN struct if_vars c_if[MAX_CARDS];

struct bdgcmd {
    u_char magic[4]; /* 'L' 'R' .... */
    u_short cmd[2];
};

EXTERN struct eth_buf {
    /*** ethernet header -- 14 bytes ***/
    u_short	eth_dst[3];
    u_short	eth_src[3];
    u_short	ip_type;
    /*** IP header -- 20 bytes **/
    u_short	vers	; /* 0x45, VERS 4, IHL 5, TOS 0 */
    u_short	tot_len	; /* Total length (byte 14 to end) */
    u_short	ident;	; /* Identification (random number) */
    u_short	flags	; /* Flags=0, frag.offset=0 */
    u_short	ttl	; /* TTL(0x0f=15), Protocol (0x11=UDP) */
    u_short	chksum;	  /* IP header checksum (14 to 33incl.) */

	/*** note: should disable alignement to use u_long ***/
    u_short	srcip[2]; /* source ip addr. (0) ? */
    u_short	dstip[2]; /* dest. ip, broadcast */
	/*** UDP Header - 8 bytes - total 42 ***/
    u_short	srcport; /* source port */
    u_short	dstport; /* destination port */
    u_short	udplen;  /* UDP Length (byte 34 to end of data) */
    u_short	udp_chksum; /* Chechsum (0 if not computed) */
    /*** UDP_data ***/
    u_char	magic[16];
    u_char	if_found[8];
    u_short	if_address[32]; /** room for 8 if addresses */
    u_short	counter_base[4];
    u_short	colls_base[4];
    u_short	time_base[4];
    u_short	dummy[4];
    u_short	counters[160];
    u_short	vidram;
    u_short	bdg_flush_ptr;
    u_short	dummy2[3];
    u_short	filters[48];
    u_short	table_off;
    u_short	table[256];
} output_buffer;

struct pcbridge_data {
    char magic[16];
    char if_found[8];
    u_short if_addr[8][4];
    struct _ctr counters[MAX_CTRS];
    short video_seg;    
    char loop_counters[8];
    unsigned char filt[16*6+2];
    u_short use_filters;
    u_short filter[64][4];
};

/******** extern procedures ********/
