/*
 * compat.c -- machine dependant functions for rmdp.
 * At this time, only time-handling functions.
 * This file is part of
 *
 * rmdp -- Reliable Multicast data Distribution Protocol
 * 
 * (C) 1996-1998 Luigi Rizzo and Lorenzo Vicisano
 *     (luigi@iet.unipi.it, vicisano@cs.ucl.ac.uk)
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Luigi Rizzo,
 *      Lorenzo Vicisano and other contributors.
 * 4. Neither the name of the Authors nor the names of other contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

#include "rmdp.h"

/*
 * compute the difference between two timestamps
 */
long
diff_t(struct timeval b, struct timeval a)
{
    return (ui32)( 1000000*(b.tv_sec - a.tv_sec) +
	b.tv_usec - a.tv_usec) ;
}

/*
 * return a timestamp in microseconds as a long int.
 * XXX should check for overflows
 */
long
timestamp_u()
{
    struct timeval t;

    (void)gettimeofday(&t, NULL);
    return((ui32)(t.tv_sec*1000000+t.tv_usec));
}

/*
 * return a timestamp in milliseconds as a long int.
 * XXX should check for overflows
 */
long
timestamp_m()
{
  struct timeval t;

    (void)gettimeofday(&t, NULL);
    return((ui32)(t.tv_sec*1000+t.tv_usec/1000));
}

void
timestamp_t(struct timeval *t)
{
    (void)gettimeofday(t, NULL);
}
