/*
 * Copyright (c) 2008 Luigi Rizzo, Riccardo Panicucci, Marta Carbone,
 *      Dipartimento di Ingegneria dell'Informazione, Universita` di Pisa.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This is an example of a plugin for Mozilla.
 *
 * For full documentation see the associated myplugin.h
 *
 * $Id: myplugin.c 234 2008-05-23 13:10:03Z luigi $
 *
 */

#include "myplugin.h"

/* debugging */
#define D(x)	//	x

#define LOBYTE(i) (i & 0xff)
#define HIBYTE(i) (i >> 8)
/*
 * The first part of this file implements the glue to implement
 * the NPAPI. We keep a struct with all the function pointers passed
 * by the browser in NP_Initialize()
 */

#ifndef NPN_MACROS
static			/* can be static if functions are implemented here */
#endif
NPNetscapeFuncs __NPN; /* Netscape Function table */

#if 0 // this is only for documentation purposes
/*
 * NP_GetMIMEDescription is called by the browser when it loads
 * the shared library implementing the plugin.
 * It must return a string containing the mime type,
 * a comma-separated extension list, and a textual description of the plugin.
 * A ':' is used to separate the three fields above;
 * a ';' is used (at the end of the description) to separate multiple
 * entries, e.g. for a plugin supporting multiple mime types.
 * The ';' is parsed only in the last field.
 */
char *NP_GetMIMEDescription(void)
{
	printf("calling %s\n", __FUNCTION__);
	return "application/txt2:foo: sample plugin that does nothing;"
		"application/txt3:bar,baz:same plugin";
}
#endif

NPError (*my_NP_Initialize)(NPNetscapeFuncs* npn, NPPluginFuncs* npp);

/*
 * NP_Initialize is called the first time the plugin is loaded,
 * after NP_GetMIMEDescription.
 *
 * It received two pointers to tables of functions containing:
 *
 * - the API calls from the plug-in to the browser, filled by
 *   the browser. We must make a local copy for our use.
 * - the API calls the plugin exports to the browser.
 *   We need to fill this table during this call.
 *
 * After this declaration we could allocate the
 * memory and resources shared by all instances
 * of your plug-in.
 *
 */
NPError NP_Initialize(NPNetscapeFuncs* npn, NPPluginFuncs* npp)
{
	D(printf("calling %s\n", __FUNCTION__);)

	/* Checks arguments */
	if (npn == NULL || npp == NULL){
		printf("Error on %s arguments\n", __FUNCTION__);
		return NPERR_INVALID_FUNCTABLE_ERROR;
	}
        /* print some variables */
        D(printf("nsTable: version %d Plugin version %d.%d\n",
		npn->version, NP_VERSION_MAJOR, NP_VERSION_MINOR);
        printf("nsTable size %d\n", npn->size);
        printf("nsPlugin size %d\n", sizeof(NPPluginFuncs));)

	__NPN = *npn;	/* copy the table passed by the browser */

	/* we only implement a subset of the API.
	 * Use NewNPP_*() to create pointers to these functions.
	 * the macros are in npupp.h - XXX check how they work.
	 * Many of these functions are mandatory so we need to
	 * provide them in some way.
	 */
	npp->newp       = NewNPP_NewProc(NPP_New);
	npp->destroy    = NewNPP_DestroyProc(NPP_Destroy);
	npp->setwindow  = NewNPP_SetWindowProc(NPP_SetWindow);
	npp->getvalue   = NewNPP_GetValueProc(NPP_GetValue);
	npp->newstream     = NewNPP_NewStreamProc(NPP_NewStream);
	npp->destroystream = NewNPP_DestroyStreamProc(NPP_DestroyStream);
	npp->asfile        = NewNPP_StreamAsFileProc(NPP_StreamAsFile);
	npp->writeready    = NewNPP_WriteReadyProc(NPP_WriteReady);
	npp->write         = NewNPP_WriteProc(NPP_Write);
	npp->print         = NewNPP_PrintProc(NPP_Print);
	npp->event         = NewNPP_HandleEventProc(NPP_HandleEvent);	
	npp->urlnotify     = NewNPP_URLNotifyProc(NPP_URLNotify);
	npp->setvalue      = NewNPP_SetValueProc(NPP_SetValue);
	if (my_NP_Initialize)
		my_NP_Initialize(npn, npp);

	return NPERR_NO_ERROR;
}

/*
 * NP_Shutdown is called when the last plugin instance is deleted.
 * Free common resources and memory.
 * Remember that there is only one thread running the various
 * instances of the plugin.
 */
NPError NP_Shutdown(void)
{
	printf("calling %s\n", __FUNCTION__);
#ifdef HAVE_SDL
	SDL_Quit();
#endif
	return NPERR_NO_ERROR;
}

#if 0 // this is only for documentation purposes
/*
 * Called when a new istance is created.
 * We should really implement this in the specific code.
 * The task of this function is to make use of the arguments
 * to create and initialize a local data structure,
 * save a pointer to this data structure in instance->pdata,
 * and return.
 *
 * Arguments:
 *
 * pluginType	the mime-type requested (useful if a plugin supports
 *		multiple mime types). XXX string or constant ?
 *
 * instance	the struct describing the instance. Opaque except
 *		for the 'pdata' pointer that we can use.
 *
 * mode		NP_EMBED or NP_FULL depending on whether we are
 *		in 'embedded' or 'full screen' mode.
 *
 * argc, argn	same as argc, argv[]
 *
 * saved	it can contain data saved by a previous execution
 *		of NPP_Destroy, which the browser gives back to us.
 *		XXX not reliable, the browser might destroy them.
 */
NPError NPP_New(NPMIMEType pluginType, NPP instance,
		uint16 mode, int16 argc, char *argn[],
                char *argv[], NPSavedData *saved)
{
	
	/* Allocating space to store local data */
	struct _instance * my_instance;

	D(printf("calling %s\n", __FUNCTION__);)
	my_instance = malloc (sizeof(struct _instance));
	if (my_instance) {
		/* Initializing local plugin instance data */
		my_instance->mWindow=0;
		my_instance->mXtwidget=0;
		my_instance->screen = NULL;
		my_instance->color=0;
		my_instance->flags=0;
	}
	instance->pdata = (void*) my_instance;

	return NPERR_NO_ERROR;
}

/*
 * Called when the plugin instance is destroyed.
 * Again this must be implemented by the application, typically
 * cleanup and free the memory allocated in instance->pdata.
 * Optionally, save can be set to point to an area allocated
 * with NPN_MemAlloc(), and then the browser might try to pass
 * the info to a subsequent call to NPP_New()
 */
NPError NPP_Destroy(NPP instance, NPSavedData **save)
{
	D(printf("calling %s\n", __FUNCTION__);)
	D(printf("Destroing instance\n");)
	free(instance->pdata);
	return NPERR_NO_ERROR;
}

/*
 * Tells the plug-in when a window is created, moved, sized, or destroyed.
 * The browser calls NPP_SetWindow after creating the instance to allow
 * drawing to begin. Subsequent calls to NPP_SetWindow indicate changes in
 * size or position.
 * NPWindow: contains the coordinates of the instance's area and various
 *           platform-specific data, i.e. window Id...
 */
NPError NPP_SetWindow(NPP instance, NPWindow* window)
{
	printf("calling %s; x=%d, y=%d, w=%d, h=%d, winID=%ld", __FUNCTION__,
	       window->x,window->y,window->width,window->height,(long int)window->window);
	struct _instance * my_instance = (struct _instance *) instance->pdata;

	/* Save window position in plugin private member for future use */
	my_instance->mX = window->x;
	my_instance->mY = window->y;
	my_instance->mWidth = window->width;
	my_instance->mHeight = window->height;
	
	if (my_instance->mWindow == (Window) window->window) {
		/*
		 * Here it is NOT the first time that NPP_SetWindow is called.
		 * XXX
		 */
		printf(" Nothing to do\n");
	} else {
		printf (" First time here\n");
		/* Storing window id */
		my_instance->mWindow = (Window) window->window;
		
		/* Accessing platform specific data */
		NPSetWindowCallbackStruct *ws_info = (NPSetWindowCallbackStruct *)window->ws_info;
		my_instance->mDisplay = ws_info->display;
		/* add xt event handler */
		Widget xtwidget = XtWindowToWidget(my_instance->mDisplay, my_instance->mWindow);
		if (xtwidget && my_instance->mXtwidget != xtwidget) {
			my_instance->mXtwidget = xtwidget;
			/* Event mask: we accept a subset of possible X11 events */
			long event_mask = ExposureMask | KeyPressMask | ButtonPressMask |
					EnterWindowMask | LeaveWindowMask;
			/* Associating event mask with plugin instance window */
			XSelectInput(my_instance->mDisplay, my_instance->mWindow, event_mask);
			XtAddEventHandler(xtwidget, event_mask, False, (XtEventHandler)xt_event_handler, my_instance);
		}
		
		/* SDL initialization */
		/* Hack to get SDL to use X window returned by mozilla*/
		char SDL_windowhack[32];
		sprintf(SDL_windowhack,"SDL_WINDOWID=%ld", (Window) window->window);
		putenv(SDL_windowhack);
		
		/* TODO:
		 * It seems than we can't create more than one instance.
		 * When we create a second instance, although we use a new
		 * SDL_WINDOWID, we can't draw with SDL in the new window.
		 */
		if( SDL_Init(SDL_INIT_VIDEO) <0 )
		{
			printf("Error init SDL: %s\n", SDL_GetError());
			return 1;
		}
		printf ("From GetEnv(): SDL_WINDOWID=%s\n",getenv("SDL_WINDOWID"));
		const SDL_VideoInfo *info_hw;
		info_hw=SDL_GetVideoInfo();
		if ( info_hw->hw_available )
			my_instance->flags = SDL_HWSURFACE;
		else
			my_instance->flags = SDL_SWSURFACE;
		my_instance->flags|=SDL_DOUBLEBUF;
		if(!( my_instance->screen = SDL_SetVideoMode(my_instance->mWidth,
		      my_instance->mHeight,0,my_instance->flags) ))
		{
			printf("Problem setting screen: %s\n",
			       SDL_GetError());
			return 1;
		}

	}
	return NPERR_NO_ERROR;
}

/*
 * This function allow the browser to query the plugin for information.
 */
NPError NPP_GetValue(NPP instance, NPPVariable variable, void *value)
{;
	if (instance == NULL) {
		printf("in %s instance is null\n", __FUNCTION__);
		return NPERR_INVALID_INSTANCE_ERROR;
	}
	switch (variable) {
	default:
		break;
	}
	return NPERR_NO_ERROR;
}
#endif	// internal implementation

/*
 * Here we implement the NPAPI in terms of the functions
 * passed by the browser. We add some wrappers to print the parameters
 * of the various functions, for debugging purposes.
 */

#ifndef NPN_MACROS
// #define NPN_CreateObject        __NPN.createobject
NPObject *NPN_CreateObject(NPP instance, NPClass *aClass)
{
	NPObject *retval;
	D(fprintf(stderr, "-- %s called\n", __FUNCTION__);)
        retval = __NPN.createobject(instance, aClass);
	D(fprintf(stderr, "-- %s returns %p\n", __FUNCTION__, retval);)
	return retval;
}

//#define NPN_Evaluate            __NPN.evaluate
/* Evaluates a script in the scope of the specified NPObject */
bool NPN_Evaluate(NPP npp, NPObject* obj, NPString *script, NPVariant *result)
{
	bool retval;
	D(fprintf(stderr, "-- %s called\n", __FUNCTION__);)
        retval = __NPN.evaluate(npp, obj, script, result);
	D(fprintf(stderr, "-- %s returns %d\n", __FUNCTION__, retval);)
	return retval;
	
}

// #define NPN_GetProperty         __NPN.getproperty
/* Gets the value of a property on the specified NPObject */
bool NPN_GetProperty(NPP npp, NPObject* obj, NPIdentifier propertyName,
                     NPVariant *result)
{
	bool retval;
	D(fprintf(stderr, "-- %s called\n", __FUNCTION__);)
        retval = __NPN.getproperty(npp, obj, propertyName, result);
	D(fprintf(stderr, "-- %s returns %d\n", __FUNCTION__, retval);)
	return retval;
}

//#define NPN_GetValue            __NPN.getvalue
/* Allows the plug-in to query the browser for information */
NPError NPN_GetValue(NPP instance, NPNVariable variable, void *r_value)
{
	NPError retval;

	D(fprintf(stderr, "-- %s called\n", __FUNCTION__);)
        retval = __NPN.getvalue(instance, variable, r_value);
	D(fprintf(stderr, "-- %s returns %d\n", __FUNCTION__, retval);)
	return retval;
}

// #define NPN_GetStringIdentifier __NPN.getstringidentifier
/* Returns an opaque identifier for the string that is passed in */
NPIdentifier NPN_GetStringIdentifier(const NPUTF8 *name)
{
	NPIdentifier retval;
	D(fprintf(stderr, "-- %s called\n", __FUNCTION__);)
        retval = __NPN.getstringidentifier(name);
	D(fprintf(stderr, "-- %s returns %p\n", __FUNCTION__, retval);)
	return retval;
}

// #define NPN_ReleaseObject       __NPN.releaseobject
void NPN_ReleaseObject(NPObject *obj)
{
	D(fprintf(stderr, "-- %s called; counter is %d\n", __FUNCTION__, obj->referenceCount);)
        __NPN.releaseobject(obj);
	D(fprintf(stderr, "-- %s returns; counter is %d\n", __FUNCTION__, obj->referenceCount);)
}

// #define NPN_ReleaseVariantValue __NPN.releasevariantvalue
void NPN_ReleaseVariantValue(NPVariant *variant)
{
	D(fprintf(stderr, "-- %s called\n", __FUNCTION__);)
        __NPN.releasevariantvalue(variant);
	D(fprintf(stderr, "-- %s returns\n", __FUNCTION__);)
}

// #define NPN_RetainObject        __NPN.retainobject
NPObject *NPN_RetainObject(NPObject *o)
{
	NPObject *retval;
	fprintf(stderr, "-- %s called; counter is %d\n", __FUNCTION__, o->referenceCount);
	retval = __NPN.retainobject(o);
	fprintf(stderr, "-- %s returns; counter is %d\n", __FUNCTION__, o->referenceCount);
	return retval;
}

// #define NPN_UTF8FromIdentifier  __NPN.utf8fromidentifier
NPUTF8 *NPN_UTF8FromIdentifier(NPIdentifier val)
{
	NPUTF8 *retval;
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
        retval = __NPN.utf8fromidentifier(val);
	fprintf(stderr, "-- %s returns %p\n", __FUNCTION__, retval);
	return retval;
}

void NPN_Version(int* plugin_major, int* plugin_minor, int* netscape_major, int* netscape_minor)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	*plugin_major   = NP_VERSION_MAJOR;
	*plugin_minor   = NP_VERSION_MINOR;
	*netscape_major = HIBYTE(__NPN.version);
	*netscape_minor = LOBYTE(__NPN.version);
}

NPError NPN_GetURLNotify(NPP instance, const char *url, const char *target, void* notifyData)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	int navMinorVers = __NPN.version & 0xFF;
	NPError rv = NPERR_NO_ERROR;

	if( navMinorVers >= NPVERS_HAS_NOTIFICATION )
		rv = __NPN.geturlnotify( instance, url, target, notifyData);
	else
		rv = NPERR_INCOMPATIBLE_VERSION_ERROR;

	return rv;
}

NPError NPN_GetURL(NPP instance, const char *url, const char *target)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	NPError rv = __NPN.geturl (instance, url, target);
	return rv;
}

NPError NPN_PostURLNotify(NPP instance, const char* url, const char* window, uint32 len, const char* buf, NPBool file, void* notifyData)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	int navMinorVers = __NPN.version & 0xFF;
	NPError rv = NPERR_NO_ERROR;

	if( navMinorVers >= NPVERS_HAS_NOTIFICATION )
		rv = __NPN.posturlnotify(instance, url, window, len, buf, file, notifyData);
	else
		rv = NPERR_INCOMPATIBLE_VERSION_ERROR;

	return rv;
}

NPError NPN_PostURL(NPP instance, const char* url, const char* window, uint32 len, const char* buf, NPBool file)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	NPError rv = __NPN.posturl(instance, url, window, len, buf, file);
	return rv;
} 

NPError NPN_RequestRead(NPStream* stream, NPByteRange* rangeList)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	NPError rv = __NPN.requestread(stream, rangeList);
	return rv;
}

NPError NPN_NewStream(NPP instance, NPMIMEType type, const char* target, NPStream** stream)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	int navMinorVersion = __NPN.version & 0xFF;

	NPError rv = NPERR_NO_ERROR;

	if( navMinorVersion >= NPVERS_HAS_STREAMOUTPUT )
		rv = __NPN.newstream(instance, type, target, stream);
	else
		rv = NPERR_INCOMPATIBLE_VERSION_ERROR;

	return rv;
}

int32 NPN_Write(NPP instance, NPStream *stream, int32 len, void *buffer)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	int navMinorVersion = __NPN.version & 0xFF;
	int32 rv = 0;

	if( navMinorVersion >= NPVERS_HAS_STREAMOUTPUT )
		rv = __NPN.write(instance, stream, len, buffer);
	else
		rv = -1;

	return rv;
}

NPError NPN_DestroyStream(NPP instance, NPStream* stream, NPError reason)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	int navMinorVersion = __NPN.version & 0xFF;
	NPError rv = NPERR_NO_ERROR;

	if( navMinorVersion >= NPVERS_HAS_STREAMOUTPUT )
		rv = __NPN.destroystream(instance, stream, reason);
	else
		rv = NPERR_INCOMPATIBLE_VERSION_ERROR;

	return rv;
}

void NPN_Status(NPP instance, const char *message)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	__NPN.status(instance, message);
}

const char* NPN_UserAgent(NPP instance)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	const char * rv = NULL;
	rv = __NPN.uagent(instance);
	return rv;
}

void* NPN_MemAlloc(uint32 size)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	void * rv = NULL;
	rv = __NPN.memalloc( size);
	return rv;
}

void NPN_MemFree(void* ptr)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	__NPN.memfree(ptr);
}

uint32 NPN_MemFlush(uint32 size)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	uint32 rv = __NPN.memflush(size);
	return rv;
}

void NPN_ReloadPlugins(NPBool reloadPages)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	__NPN.reloadplugins(reloadPages);
}

NPError NPN_SetValue(NPP instance, NPPVariable variable, void *value)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	NPError rv = __NPN.setvalue(instance, variable, value);
	return rv;
}

void NPN_InvalidateRect(NPP instance, NPRect *invalidRect)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	__NPN.invalidaterect(instance, invalidRect);
}

void NPN_InvalidateRegion(NPP instance, NPRegion invalidRegion)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	__NPN.invalidateregion(instance, invalidRegion);
}

void NPN_ForceRedraw(NPP instance)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	__NPN.forceredraw(instance);
}

void NPN_SetException(NPObject* obj, const NPUTF8 *message)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	__NPN.setexception(obj, message);
}

bool NPN_HasProperty(NPP npp, NPObject* obj, NPIdentifier propertyName)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	return __NPN.hasproperty(npp, obj, propertyName);
}

bool NPN_HasMethod(NPP npp, NPObject* obj, NPIdentifier methodName)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	return __NPN.hasmethod(npp, obj, methodName);
}

bool NPN_SetProperty(NPP npp, NPObject* obj, NPIdentifier propertyName,
		     const NPVariant *value)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	return __NPN.setproperty(npp, obj, propertyName, value);
}

bool NPN_RemoveProperty(NPP npp, NPObject* obj, NPIdentifier propertyName)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	return __NPN.removeproperty(npp, obj, propertyName);
}

bool NPN_InvokeDefault(NPP npp, NPObject* obj, const NPVariant *args,
		       uint32_t argCount, NPVariant *result)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	return __NPN.invokeDefault(npp, obj, args, argCount, result);
}

bool NPN_IdentifierIsString(NPIdentifier identifier)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	return __NPN.identifierisstring(identifier);
}

int32_t NPN_IntFromIdentifier(NPIdentifier identifier)
{
	fprintf(stderr, "-- %s called\n", __FUNCTION__);
	return __NPN.intfromidentifier(identifier);
}

/*
 * Implement the NPP_ functions, at least wrappers for them
 * that we can override in our client code.
 */
#if 0
NPError NPP_NewStream(NPP instance, NPMIMEType type, NPStream* stream, NPBool seekable, uint16* stype)
{
	printf("calling %s url %s seek %d type 0x%x\n",
		__FUNCTION__, stream->url, seekable, *type);
	return NPERR_NO_ERROR;
}

int32 NPP_WriteReady (NPP instance, NPStream *stream)
{
	printf("calling %s url %s headers %s\n",
		__FUNCTION__, stream->url,
		stream->headers ? stream->headers : "NO_HDRS");
	NPN_DestroyStream(instance, stream, 0 /* reason */);
	return -1;	/* no data... */
}

int32 NPP_Write (NPP instance, NPStream *stream, int32 offset, int32 len, void *buffer)
{
	printf("calling %s\n", __FUNCTION__);
	return NPERR_NO_ERROR;
}

NPError NPP_DestroyStream (NPP instance, NPStream *stream, NPError reason)
{
	printf("calling %s\n", __FUNCTION__);
	return NPERR_NO_ERROR;
}
#endif

void NPP_StreamAsFile (NPP instance, NPStream* stream, const char* fname)
{
	printf("calling %s\n", __FUNCTION__);
}

void NPP_Print (NPP instance, NPPrint* printInfo)
{
	printf("calling %s\n", __FUNCTION__);
}

void NPP_URLNotify(NPP instance, const char* url, NPReason reason, void* notifyData)
{
	printf("calling %s\n", __FUNCTION__);
}

NPError NPP_SetValue(NPP instance, NPNVariable variable, void *value)
{
	printf("calling %s\n", __FUNCTION__);
	return NPERR_NO_ERROR;
}

int16	NPP_HandleEvent(NPP instance, void* event)
{
	printf("calling %s\n", __FUNCTION__);
	return NPERR_NO_ERROR;
}


#endif
