/*
 * Description of bridges, cameras, sensors
 *
 *  Copyright (C) 2007 Luigi Rizzo
 *
 * BSD license as is this has been rewritten.
 */

#ifndef PWC_INFO_H
#define PWC_INFO_H

enum {
        BRIDGE_UNKNOWN = 0,
        BRIDGE_SPCA505,
        BRIDGE_SPCA506,
        BRIDGE_SPCA501,
        BRIDGE_SPCA508, 
        BRIDGE_SPCA504,
        BRIDGE_SPCA500,
        BRIDGE_SPCA504B, 
        BRIDGE_SPCA533,
        BRIDGE_SPCA504C,
        BRIDGE_SPCA561,
        BRIDGE_SPCA536,
        BRIDGE_SONIX,
        BRIDGE_ZC3XX,
        BRIDGE_CX11646,
        BRIDGE_TV8532,
        BRIDGE_ETOMS,   
        BRIDGE_SN9CXXX,
        BRIDGE_MR97311,
        BRIDGE_PAC207,
        BRIDGE_STV0600,
        BRIDGE_STV0610, /* "LEGO cam" */
        BRIDGE_STV0602, /* "Dexxa Webcam" */
        BRIDGE_EM2820,  /* "Silvercrest - also 2820" */

	BRIDGE_SN9C201,	/* Trust wb5500 ? */
        BRIDGE_LAST
};
enum {
        SENSOR_UNKNOWN = 0,
        SENSOR_SAA7113,
        SENSOR_INTERNAL,
        SENSOR_HV7131B,
        SENSOR_HDCS1020,
        SENSOR_PB100_BA,
        SENSOR_PB100_92,
        SENSOR_PAS106_80,
        SENSOR_TAS5130C,	/* XXX also SENSOR_TAS5130CXX */
        SENSOR_ICM105A,
        SENSOR_HDCS2020,
        SENSOR_PAS106,
        SENSOR_PB0330,
        SENSOR_HV7131C,
        SENSOR_CS2102,
        SENSOR_HDCS2020b,
        SENSOR_HV7131R,
        SENSOR_OV7630,
        SENSOR_MI0360,
        SENSOR_TAS5110,
        SENSOR_PAS202,
        SENSOR_PAC207,  /* CIF sensor from Pixart */
        SENSOR_OV7630C,

        SENSOR_HDCS1000,        /* Quickcam express */
        SENSOR_BP100,   /* XXX same as PB100 ? */
        SENSOR_VV6410,
        SENSOR_PAS302,
        SENSOR_PAS207,
            /* various sensors used on the pwc cameras */
        SENSOR_PWC_HYUNDAI,
        SENSOR_PWC_TDA8787,
        SENSOR_PWC_SONY_Exas98L59,
        SENSOR_PWC_SONY_ADI9804,
        SENSOR_PWC_SHARP_TDA8787,
        SENSOR_PWC_SHARP_Exas98L59,
        SENSOR_PWC_SHARP_ADI9804,
        SENSOR_PWC_UPA1021,
        SENSOR_PWC_VGA,
        SENSOR_PWC_PAL_MR,
        SENSOR_PWC_UNKNOWN,

	SENSOR_TAS5130C_VF0250,
	SENSOR_MO4000,
	SENSOR_OV7660,
	SENSOR_PO3130NC,

        SENSOR_LAST
};

/* Camera type jpeg yuvy yyuv yuyv grey gbrg*/
enum dataformat{
    NONE = 0,                   //Jpeg 4.1.1 Sunplus
    JPEG,                   //Jpeg 4.1.1 Sunplus
    JPGH,                       //jpeg 4.2.2 Zstar
    JPGC,                       //jpeg 4.2.2 Conexant
    JPGS,                       //jpeg 4.2.2 Sonix
    JPGM,                       //jpeg 4.2.2 Mars-Semi
    YUVY,
    YYUV,
    YUYV,
    GREY,
    GBRG,
    SN9C,                       // Sonix compressed stream
    GBGR,
    S561,                       // Sunplus Compressed stream
    PGBRG,                      // Pixart RGGB bayer
};


/* Camera identifiers */
enum {
    UnknownCamera = 0,		// 0
    IntelPCCameraPro,
    IntelCreateAndShare,
    GrandtecVcap,
    ViewQuestM318B,
    ViewQuestVQ110,
    KodakDVC325,
    MustekGsmartMini2,
    MustekGsmartMini3,
    CreativePCCam300,
    DLinkDSC350,		// 10
    CreativePCCam600,
    IntelPocketPCCamera,
    IntelEasyPCCamera,
    ThreeComHomeConnectLite,
    KodakEZ200,
    MaxellMaxPocket,
    AiptekMiniPenCam2,
    AiptekPocketDVII,
    AiptekPenCamSD,
    AiptekMiniPenCam13,		// 20
    MustekGsmartLCD3,
    MustekMDC5500Z,
    MegapixV4,
    AiptekPocketDV,
    HamaUSBSightcam,
    Arowana300KCMOSCamera,
    MystFromOriUnknownCamera,
    AiptekPocketDV3100,
    AiptekPocketCam3M,
    GeniusVideoCAMExpressV2,	// 30
    Flexcam100Camera,
    MustekGsmartLCD2,
    PureDigitalDakota,
    PetCam,
    BenqDC1500,
    LogitechClickSmart420,
    LogitechClickSmart510,
    BenqDC1300,
    HamaUSBSightcam2,
    MustekDV3000,		// 40
    CreativePccam750,
    MaxellCompactPM3,
    BenqDC3410,
    BenqDC1016,
    MicroInnovationIC200,
    LogitechTraveler,
    Flycam100Camera,
    UsbGrabberPV321c,
    ADSInstantVCD,
    Gsmartmini,			// 50
    Jenoptikjdc21lcd,
    LogitechClickSmart310,
    Terratec2move13,
    MustekDV4000,
    AiptekDV3500,
    LogitechClickSmart820,
    Enigma13,
    Sonix6025,
    Epsilon13,
    Nxultra,			//60
    AiptekPocketCam2M,
    DeMonUSBCapture,
    CreativeVista,
    PolaroidPDC2030,
    CreativeNotebook,
    CreativeMobile,
    LabtecPro,
    MustekWcam300A,
    GeniusVideoCamV2,
    GeniusVideoCamV3,
    GeniusVideoCamExpressV2b,
    CreativeNxPro,
    Sonix6029,			//73 74 75
    Vimicro,
    Digitrex2110,
    GsmartD30,
    CreativeNxPro2,
    Bs888e,
    Zc302,
    CreativeNoteBook2,
    AiptekSlim3200,		/* 83 84 85 */
    LabtecWebcam,
    QCExpress,
    ICM532cam,
    MustekGsmart300,
    CreativeLive,		//90
    MercuryDigital,
    Wcam300A,
    CreativeVista3b,
    VeoStingray1,
    VeoStingray2,
    TyphoonWebshotIIUSB300k,	//96
    PolaroidPDC3070,
    QCExpressEtch2,
    QCforNotebook,
    QCim,			//100
    WebCam320,
    AiptekPocketCam4M,
    AiptekPocketDV5100,
    AiptekPocketDV5300,
    SunplusGeneric536,
    QCimA1,
    QCchat,
    QCimB9,
    Labtec929,			//109 110
    Etoms61x151,
    Etoms61x251,
    PalmPixDC85,
    Optimedia,
    ToptroIndus,
    AgfaCl20,
    LogitechQC92c,
    SonixWC311P,
    Concord3045,
    Mercury21,			//120
    CreativeNX,
    CreativeInstant1,
    CreativeInstant2,
    QuickCamNB,
    WCam300AN,
    LabtecWCPlus,
    GeniusVideoCamMessenger,
    Pcam,
    GeniusDsc13,
    MustekMDC4000,		//130
    LogitechQCCommunicateSTX,
    Lic200,
    SweexTas5110,
    Pccam168,
    Sn535,
    Pccam,
    Lic300,
    PolaroidIon80,
    Zc0305b,
    BtcPc380,			//140
    LogitechNotebookDeluxe,
    LabtecNotebook,
    JvcGcA50,
    SmileIntlCamera,
    PcCam350,
    PAC207,
    QtecWb100,
    GeniusGe111,
    Vimicro303b,
    CyberpixS550V,
    GeniusGF112,
    LogitechQCim,
    AiptekSlim3000F,
    CTXM730VCam,
    GeniusVideoCamNB,
    CreativeVistaPlus,
    PhilipsSPC200NC,
    PhilipsSPC700NC,
    SpeedNVC350K,
    Mustek330K,
    PhilipsSPC600NC,
    PhilipsSPC300NC,
    Sonix6019,
        LogitechQCImage,
        Sunplus500c,
        MustekMDC3500,
        LogitechQCCool,
        QCimconnect,
        QCmessenger,
        CreativeLiveCamNotebookPro,
        CreativeWebCamVistaPro,
        CreativeLiveCamVideoIM,
        AiptekDV4100M,
        TyphoonEasyCam1_3,
        Sonix0x613b,
        Sonix0x60fb,
        Sonyc002,
        Vimicro0321,
        Orbicam,
        M$VX1000,
        Trust610LCDPowerCamZoom,
        Sonyc001,

    DexxaWebcam,	/* XXX from qce-ga */
    SilverCrest,
    TrustWB5500,

    LastCamera

};

/*
 * Returns the description string for a given sensor or bridge index
 */
const char * sensor_name(int sensor);
const char * bridge_name(int bridge);
const char * camera_name(int camera);
#endif /* !PWC_INFO_H */
