/* 
 * SPCA501 chip based cameras initialization data
 *
 */
#ifndef SPCA501_INIT_H
#define SPCA501_INIT_H

/*
 * Data to initialize a SPCA501. From a capture file provided by Bill Roehl
 * With SPCA501 chip description
 */

#define CCDSP_SET		// set CCDSP parameters
#define TG_SET			// set time generator set
#undef DSPWIN_SET		// set DSP windows parameters
#undef ALTER_GAMA		// Set alternate set to YUV transform coeffs.
#define SPCA501_SNAPBIT 0x80
#define SPCA501_SNAPCTRL 0x10
/* Frame packet header offsets for the spca501 */
#define SPCA501_OFFSET_GPIO   1
#define SPCA501_OFFSET_TYPE   2
#define SPCA501_OFFSET_TURN3A 3
#define SPCA501_OFFSET_FRAMSEQ 4
#define SPCA501_OFFSET_COMPRESS 5
#define SPCA501_OFFSET_QUANT 6
#define SPCA501_OFFSET_QUANT2 7
#define SPCA501_OFFSET_DATA 8

#define SPCA501_PROP_COMP_ENABLE(d) ( (d) & 1 )
#define SPCA501_PROP_SNAP(d) ( (d) & 0x40 )
#define SPCA501_PROP_SNAP_CTRL(d) ( (d) & 0x10)
#define SPCA501_PROP_COMP_THRESH(d) ( ((d) & 0xE ) >> 1)
#define SPCA501_PROP_COMP_QUANT(d) ( ((d) & 0x70 ) >> 4)

/* SPCA501 CCDSP control */
#define SPCA501_REG_CCDSP 0x1
/* SPCA501 control/status registers */
#define SPCA501_REG_CTLRL 0x2

//registers for color correction and YUV transformation
#define SPCA501_A11 0x08
#define SPCA501_A12 0x09
#define SPCA501_A13 0x0A
#define SPCA501_A21 0x0B
#define SPCA501_A22 0x0C
#define SPCA501_A23 0x0D
#define SPCA501_A31 0x0E
#define SPCA501_A32 0x0F
#define SPCA501_A33 0x10

/* Data for video camera initialization before capturing */
static __u16 spca501_open_data[][3] = {
    /* bmRequest,value,index */

    {0x2, 0x50, 0x0},		//C/S enable soft reset
    {0x2, 0x40, 0x0},		//C/S disable soft reset
    {0x2, 0x02, 0x5},		//C/S general purpose I/O data
    {0x2, 0x03, 0x5},		//C/S general purpose I/O data

#ifdef CCDSP_SET
    {0x1, 0x38, 0x1},		// CCDSP options
    {0x1, 0x05, 0x2},		// CCDSP Optical black level for user settings
    {0x1, 0xC0, 0x3},		// CCDSP Optical black settings

    {0x1, 0x67, 0x7},
    {0x1, 0x63, 0x3f},		// CCDSP CCD gamma enable
    {0x1, 0x03, 0x56},		// Add gamma correction

    {0x1, 0xFF, 0x15},		//CCDSP High luminance for white balance
    {0x1, 0x01, 0x16},		//CCDSP Low luminance for white balance

    /* Color correction and RGB-to-YUV transformation coefficients changing */
#ifdef ALTER_GAMA
    {0x0, 0x00, 0x08},		//A11
    {0x0, 0x00, 0x09},		//A12
    {0x0, 0x90, 0x0A},		//A13
    {0x0, 0x12, 0x0B},		//A21
    {0x0, 0x00, 0x0C},		//A22
    {0x0, 0x00, 0x0D},		//A23
    {0x0, 0x00, 0x0E},		//A31
    {0x0, 0x02, 0x0F},		//A32
    {0x0, 0x00, 0x10},		//A33
#else
    {0x1, 0x31, 0x08},		//A11
    {0x1, 0x00, 0x09},		//A12
    {0x1, 0x00, 0x0A},		//A13
    {0x1, 0x00, 0x0B},		//A21
    {0x1, 0x14, 0x0C},		//A22
    {0x1, 0x00, 0x0D},		//A23
    {0x1, 0x00, 0x0E},		//A31
    {0x1, 0x00, 0x0F},		//A32
    {0x1, 0x1E, 0x10},		//A33
#endif
    {0x1, 0x00, 0x11},		// R offset
    {0x1, 0x00, 0x12},		// G offset
    {0x1, 0x00, 0x13},		// B offset
    {0x1, 0x00, 0x14},		// GB offset

#endif

#ifdef TG_SET
    /* Time generator manipulations */
    {0x0, 0xfc, 0x0},		// Set up high bits of shutter speed
    {0x0, 0x01, 0x1},		// Set up low bits of shutter speed

    {0x0, 0xe4, 0x04},		// DCLK*2 clock phase adjustment
    {0x0, 0x08, 0x05},		// ADCK phase adjustment, inv. ext. VB
    {0x0, 0x03, 0x06},		// FR phase adjustment
    {0x0, 0x01, 0x07},		// FCDS phase adjustment
    {0x0, 0x39, 0x08},		// FS phase adjustment
    {0x0, 0x88, 0x0a},		// FH1 phase and delay adjustment
    {0x0, 0x03, 0x0f},		// pixel identification
    {0x0, 0x00, 0x11},		// clock source selection (default)

    /*VERY strange manipulations with 
     * select DMCLP or OBPX to be ADCLP output (0x0C)
     * OPB always toggle or not (0x0D) but they allow
     * us to set up brightness
     */
    {0x0, 0x01, 0x0c},
    {0x0, 0xe0, 0x0d},
    /* Done */
#endif

#ifdef DSPWIN_SET
    {0x1, 0xa0, 0x01},		//Setting image processing parameters
    {0x1, 0x1c, 0x17},		//Changing Windows positions X1
    {0x1, 0xe2, 0x19},		//X2
    {0x1, 0x1c, 0x1b},		//X3
    {0x1, 0xe2, 0x1d},		//X4
    {0x1, 0x5f, 0x1f},		//X5
    {0x1, 0x32, 0x20},		//Y5
    {0x1, 0x01, 0x10},		//Changing A33
#endif

    {0x2, 0x204a, 0x07},	//Setting video compression & resolution 160x120
    {0x2, 0x94, 0x06},		//Setting video no compression
    {0, 0, 0}
};

/*
   The SPCAxxx docs from Sunplus document these values
   in tables, one table per register number.  In the data
   below, dmRequest is the register number, index is the Addr,
   and value is a combination of Bit values.  
   Bit  Value (hex)
   0    01
   1    02
   2    04
   3    08
   4    10
   5    20
   6    40
   7    80
 */

/* Data for chip initialization (set default values) */
static __u16 spca501_init_data[][3] = {
    /* Set all the values to powerup defaults */
    /* bmRequest,value,index */
    {0x0, 0xAA, 0x00},
    {0x0, 0x02, 0x01},
    {0x0, 0x01, 0x02},
    {0x0, 0x02, 0x03},
    {0x0, 0xCE, 0x04},
    {0x0, 0x00, 0x05},
    {0x0, 0x00, 0x06},
    {0x0, 0x00, 0x07},
    {0x0, 0x00, 0x08},
    {0x0, 0x00, 0x09},
    {0x0, 0x90, 0x0A},
    {0x0, 0x12, 0x0B},
    {0x0, 0x00, 0x0C},
    {0x0, 0x00, 0x0D},
    {0x0, 0x00, 0x0E},
    {0x0, 0x02, 0x0F},
    {0x0, 0x00, 0x10},
    {0x0, 0x00, 0x11},
    {0x0, 0x00, 0x12},
    {0x0, 0x00, 0x13},
    {0x0, 0x00, 0x14},
    {0x0, 0x00, 0x15},
    {0x0, 0x00, 0x16},
    {0x0, 0x00, 0x17},
    {0x0, 0x00, 0x18},
    {0x0, 0x00, 0x19},
    {0x0, 0x00, 0x1A},
    {0x0, 0x00, 0x1B},
    {0x0, 0x00, 0x1C},
    {0x0, 0x00, 0x1D},
    {0x0, 0x00, 0x1E},
    {0x0, 0x00, 0x1F},
    {0x0, 0x00, 0x20},
    {0x0, 0x00, 0x21},
    {0x0, 0x00, 0x22},
    {0x0, 0x00, 0x23},
    {0x0, 0x00, 0x24},
    {0x0, 0x00, 0x25},
    {0x0, 0x00, 0x26},
    {0x0, 0x00, 0x27},
    {0x0, 0x00, 0x28},
    {0x0, 0x00, 0x29},
    {0x0, 0x00, 0x2A},
    {0x0, 0x00, 0x2B},
    {0x0, 0x00, 0x2C},
    {0x0, 0x00, 0x2D},
    {0x0, 0x00, 0x2E},
    {0x0, 0x00, 0x2F},
    {0x0, 0x00, 0x30},
    {0x0, 0x00, 0x31},
    {0x0, 0x00, 0x32},
    {0x0, 0x00, 0x33},
    {0x0, 0x00, 0x34},
    {0x0, 0x00, 0x35},
    {0x0, 0x00, 0x36},
    {0x0, 0x00, 0x37},
    {0x0, 0x00, 0x38},
    {0x0, 0x00, 0x39},
    {0x0, 0x00, 0x3A},
    {0x0, 0x00, 0x3B},
    {0x0, 0x00, 0x3C},
    {0x0, 0x00, 0x3D},
    {0x0, 0x00, 0x3E},
    {0x0, 0x00, 0x3F},
    {0x0, 0x00, 0x40},
    {0x0, 0x00, 0x41},
    {0x0, 0x00, 0x42},
    {0x0, 0x00, 0x43},
    {0x0, 0x00, 0x44},
    {0x0, 0x00, 0x45},
    {0x0, 0x00, 0x46},
    {0x0, 0x00, 0x47},
    {0x0, 0x00, 0x48},
    {0x0, 0x00, 0x49},
    {0x0, 0x00, 0x4A},
    {0x0, 0x00, 0x4B},
    {0x0, 0x00, 0x4C},
    {0x0, 0x00, 0x4D},
    {0x0, 0x00, 0x4E},
    {0x0, 0x00, 0x4F},
    {0x0, 0x00, 0x50},
    {0x0, 0x00, 0x51},
    {0x0, 0x00, 0x52},
    {0x0, 0x00, 0x53},
    {0x0, 0x00, 0x54},
    {0x0, 0x00, 0x55},
    {0x0, 0x00, 0x56},
    {0x0, 0x00, 0x57},
    {0x0, 0x00, 0x58},
    {0x0, 0x00, 0x59},
    {0x0, 0x00, 0x5A},
    {0x0, 0x00, 0x5B},
    {0x0, 0x00, 0x5C},
    {0x0, 0x00, 0x5D},
    {0x0, 0x00, 0x5E},
    {0x0, 0x00, 0x5F},
    {0x0, 0x00, 0x60},
    {0x0, 0x00, 0x61},
    {0x0, 0x00, 0x62},
    {0x0, 0x00, 0x63},
    {0x0, 0x00, 0x64},
    {0x0, 0x00, 0x65},
    {0x0, 0x00, 0x66},
    {0x0, 0x00, 0x67},
    {0x0, 0x00, 0x68},
    {0x0, 0x00, 0x69},
    {0x0, 0x00, 0x6A},
    {0x0, 0x00, 0x6B},
    {0x0, 0x00, 0x6C},
    {0x0, 0x00, 0x6D},
    {0x0, 0x00, 0x6E},
    {0x0, 0x00, 0x6F},
    {0x0, 0x00, 0x70},
    {0x0, 0x00, 0x71},
    {0x0, 0x00, 0x72},
    {0x0, 0x00, 0x73},
    {0x0, 0x00, 0x74},
    {0x0, 0x00, 0x75},
    {0x0, 0x00, 0x76},
    {0x0, 0x00, 0x77},
    {0x0, 0x00, 0x78},
    {0x0, 0x00, 0x79},
    {0x0, 0x00, 0x7A},
    {0x0, 0x00, 0x7B},
    {0x0, 0x00, 0x7C},
    {0x0, 0x00, 0x7D},
    {0x0, 0x00, 0x7E},
    {0x0, 0x00, 0x7F},
    {0x0, 0x00, 0x80},
    {0x0, 0x00, 0x81},
    {0x0, 0x00, 0x82},
    {0x0, 0x00, 0x83},
    {0x0, 0x00, 0x84},
    {0x0, 0x00, 0x85},
    {0x0, 0x00, 0x86},
    {0x0, 0x00, 0x87},
    {0x0, 0x00, 0x88},
    {0x0, 0x00, 0x89},
    {0x0, 0x00, 0x8A},
    {0x0, 0x00, 0x8B},
    {0x0, 0x00, 0x8C},
    {0x0, 0x00, 0x8D},
    {0x0, 0x00, 0x8E},
    {0x0, 0x00, 0x8F},
    {0x0, 0x00, 0x90},
    {0x0, 0x00, 0x91},
    {0x0, 0x00, 0x92},
    {0x0, 0x00, 0x93},
    {0x0, 0x00, 0x94},
    {0x0, 0x00, 0x95},
    {0x0, 0x00, 0x96},
    {0x0, 0x00, 0x97},
    {0x0, 0x00, 0x98},
    {0x0, 0x00, 0x99},
    {0x0, 0x00, 0x9A},
    {0x0, 0x00, 0x9B},
    {0x0, 0x00, 0x9C},
    {0x0, 0x00, 0x9D},
    {0x0, 0x00, 0x9E},
    {0x0, 0x00, 0x9F},
    {0x0, 0x00, 0xA0},
    {0x0, 0x00, 0xA1},
    {0x0, 0x00, 0xA2},
    {0x0, 0x00, 0xA3},
    {0x0, 0x00, 0xA4},
    {0x0, 0x00, 0xA5},
    {0x0, 0x00, 0xA6},
    {0x0, 0x00, 0xA7},
    {0x0, 0x00, 0xA8},
    {0x0, 0x00, 0xA9},
    {0x0, 0x00, 0xAA},
    {0x0, 0x00, 0xAB},
    {0x0, 0x00, 0xAC},
    {0x0, 0x00, 0xAD},
    {0x0, 0x00, 0xAE},
    {0x0, 0x00, 0xAF},
    {0x0, 0x00, 0xB0},
    {0x0, 0x00, 0xB1},
    {0x0, 0x00, 0xB2},
    {0x0, 0x00, 0xB3},
    {0x0, 0x00, 0xB4},
    {0x0, 0x00, 0xB5},
    {0x0, 0x00, 0xB6},
    {0x0, 0x00, 0xB7},
    {0x0, 0x00, 0xB8},
    {0x0, 0x00, 0xB9},
    {0x0, 0x00, 0xBA},
    {0x0, 0x00, 0xBB},
    {0x0, 0x00, 0xBC},
    {0x0, 0x00, 0xBD},
    {0x0, 0x00, 0xBE},
    {0x0, 0x00, 0xBF},
    {0x0, 0x00, 0xC0},
    {0x0, 0x00, 0xC1},
    {0x0, 0x00, 0xC2},
    {0x0, 0x00, 0xC3},
    {0x0, 0x00, 0xC4},
    {0x0, 0x00, 0xC5},
    {0x0, 0x00, 0xC6},
    {0x0, 0x00, 0xC7},
    {0x0, 0x00, 0xC8},
    {0x0, 0x00, 0xC9},
    {0x0, 0x00, 0xCA},
    {0x0, 0x00, 0xCB},
    {0x0, 0x00, 0xCC},
    {0x1, 0xF4, 0x00},
    {0x1, 0x38, 0x01},
    {0x1, 0x40, 0x02},
    {0x1, 0x0A, 0x03},
    {0x1, 0x40, 0x04},
    {0x1, 0x40, 0x05},
    {0x1, 0x40, 0x06},
    {0x1, 0x67, 0x07},
    {0x1, 0x31, 0x08},
    {0x1, 0x00, 0x09},
    {0x1, 0x00, 0x0A},
    {0x1, 0x00, 0x0B},
    {0x1, 0x14, 0x0C},
    {0x1, 0x00, 0x0D},
    {0x1, 0x00, 0x0E},
    {0x1, 0x00, 0x0F},
    {0x1, 0x1E, 0x10},
    {0x1, 0x00, 0x11},
    {0x1, 0x00, 0x12},
    {0x1, 0x00, 0x13},
    {0x1, 0x00, 0x14},
    {0x1, 0xFF, 0x15},
    {0x1, 0x01, 0x16},
    {0x1, 0x32, 0x17},
    {0x1, 0x23, 0x18},
    {0x1, 0xCE, 0x19},
    {0x1, 0x23, 0x1A},
    {0x1, 0x32, 0x1B},
    {0x1, 0x8D, 0x1C},
    {0x1, 0xCE, 0x1D},
    {0x1, 0x8D, 0x1E},
    {0x1, 0x00, 0x1F},
    {0x1, 0x00, 0x20},
    {0x1, 0xFF, 0x3E},
    {0x1, 0x02, 0x3F},
    {0x1, 0x00, 0x40},
    {0x1, 0x00, 0x41},
    {0x1, 0x00, 0x42},
    {0x1, 0x00, 0x43},
    {0x1, 0x00, 0x44},
    {0x1, 0x00, 0x45},
    {0x1, 0x00, 0x46},
    {0x1, 0x00, 0x47},
    {0x1, 0x00, 0x48},
    {0x1, 0x00, 0x49},
    {0x1, 0x00, 0x4A},
    {0x1, 0x00, 0x4B},
    {0x1, 0x00, 0x4C},
    {0x1, 0x00, 0x4D},
    {0x1, 0x00, 0x4E},
    {0x1, 0x00, 0x4F},
    {0x1, 0x00, 0x50},
    {0x1, 0x00, 0x51},
    {0x1, 0x00, 0x52},
    {0x1, 0x00, 0x53},
    {0x1, 0x00, 0x54},
    {0x1, 0x00, 0x55},
    {0x1, 0x00, 0x56},
    {0x1, 0x00, 0x57},
    {0x1, 0x00, 0x58},
    {0x1, 0x00, 0x59},
    {0x1, 0x00, 0x5A},
    {0x2, 0x03, 0x00},
    {0x2, 0x00, 0x01},
    {0x2, 0x00, 0x05},
    {0x2, 0x00, 0x06},
    {0x2, 0x00, 0x07},
    {0x2, 0x00, 0x10},
    {0x2, 0x00, 0x11},
    /* Strange - looks like the 501 driver doesn't do anything 
     * at insert time except read the EEPROM 
     */
    {0x0, 0x0, 0x0}
};

/* Data for video camera init before capture.
 * Capture and decoding by Colin Peart.
 * This is is for the 3com HomeConnect Lite which is spca501a based.
 */
static __u16 spca501_3com_open_data[][3] = {
    /* bmRequest,value,index */
    {0x2, 0x0050, 0x0000},	//C/S Enable TG soft reset, timing mode=010
    {0x2, 0x0043, 0x0000},	//C/S Disable TG soft reset, timing mode=010
    {0x2, 0x0002, 0x0005},	//C/S GPIO
    {0x2, 0x0003, 0x0005},	//C/S GPIO

#ifdef CCDSP_SET
    {0x1, 0x0020, 0x0001},	//CCDSP Options

    {0x1, 0x0020, 0x0002},	//CCDSP Black Level
    {0x1, 0x006e, 0x0007},	//CCDSP Gamma options
    {0x1, 0x0090, 0x0015},	//CCDSP Luminance Low
    {0x1, 0x00ff, 0x0016},	//CCDSP Luminance High
    {0x1, 0x0003, 0x003F},	//CCDSP Gamma correction toggle

#ifdef ALTER_GAMMA
    {0x1, 0x0010, 0x0008},	//CCDSP YUV A11 
    {0x1, 0x0000, 0x0009},	//CCDSP YUV A12 
    {0x1, 0x0000, 0x000a},	//CCDSP YUV A13 
    {0x1, 0x0000, 0x000b},	//CCDSP YUV A21 
    {0x1, 0x0010, 0x000c},	//CCDSP YUV A22 
    {0x1, 0x0000, 0x000d},	//CCDSP YUV A23 
    {0x1, 0x0000, 0x000e},	//CCDSP YUV A31 
    {0x1, 0x0000, 0x000f},	//CCDSP YUV A32 
    {0x1, 0x0010, 0x0010},	//CCDSP YUV A33 
    {0x1, 0x0000, 0x0011},	//CCDSP R Offset
    {0x1, 0x0000, 0x0012},	//CCDSP G Offset
    {0x1, 0x0001, 0x0013},	//CCDSP B Offset
    {0x1, 0x0001, 0x0014},	//CCDSP BG Offset
    {0x1, 0x003f, 0x00C1},	//CCDSP Gamma Correction Enable
#endif
#endif

#ifdef TG_SET
    {0x0, 0x00fc, 0x0000},	//TG Shutter Speed High Bits
    {0x0, 0x0000, 0x0001},	//TG Shutter Speed Low Bits
    {0x0, 0x00e4, 0x0004},	//TG DCLK*2 Adjust
    {0x0, 0x0008, 0x0005},	//TG ADCK Adjust
    {0x0, 0x0003, 0x0006},	//TG FR Phase Adjust
    {0x0, 0x0001, 0x0007},	//TG FCDS Phase Adjust
    {0x0, 0x0039, 0x0008},	//TG FS Phase Adjust
    {0x0, 0x0088, 0x000a},	//TG MH1
    {0x0, 0x0003, 0x000f},	//TG Pixel ID

    /* Like below, unexplained toglleing */
    {0x0, 0x0080, 0x000c},
    {0x0, 0x0000, 0x000d},
    {0x0, 0x0080, 0x000c},
    {0x0, 0x0004, 0x000d},
    {0x0, 0x0000, 0x000c},
    {0x0, 0x0000, 0x000d},
    {0x0, 0x0040, 0x000c},
    {0x0, 0x0017, 0x000d},
    {0x0, 0x00c0, 0x000c},
    {0x0, 0x0000, 0x000d},
    {0x0, 0x0080, 0x000c},
    {0x0, 0x0006, 0x000d},
    {0x0, 0x0080, 0x000c},
    {0x0, 0x0004, 0x000d},
    {0x0, 0x0002, 0x0003},
#endif

#ifdef DSPWIN_SET
    {0x1, 0x001c, 0x0017},	//CCDSP W1 Start X
    {0x1, 0x00e2, 0x0019},	//CCDSP W2 Start X
    {0x1, 0x001c, 0x001b},	//CCDSP W3 Start X
    {0x1, 0x00e2, 0x001d},	//CCDSP W4 Start X
    {0x1, 0x00aa, 0x001f},	//CCDSP W5 Start X
    {0x1, 0x0070, 0x0020},	//CCDSP W5 Start Y
#endif
    {0x0, 0x0001, 0x0010},	//TG Start Clock

//{0x2, 0x006a, 0x0001},                //C/S Enable ISOSYNCH Packet Engine
    {0x2, 0x0068, 0x0001},	//C/S Diable ISOSYNCH Packet Engine
    {0x2, 0x0000, 0x0005},
    {0x2, 0x0043, 0x0000},	//C/S Set Timing Mode, Disable TG soft reset
    {0x2, 0x0043, 0x0000},	//C/S Set Timing Mode, Disable TG soft reset
    {0x2, 0x0002, 0x0005},	//C/S GPIO
    {0x2, 0x0003, 0x0005},	//C/S GPIO

    {0x2, 0x006a, 0x0001},	//C/S Enable ISOSYNCH Packet Engine
    {0, 0, 0}
};

/*
 * Data used to initialize a SPCA501C with HV7131B sensor.
 * From a capture file taken with USBSnoop v 1.5
 * I have a "SPCA501C pc camera chipset" manual by sunplus, but some
 * of the value meanings are obscure or simply "reserved".
 * to do list:
 * 1) Understand what every value means
 * 2) Understand why some values seem to appear more than once
 * 3) Write a small comment for each line of the following arrays.
 */

static __u16 spca501c_arowana_open_data[][3] = {
    /* bmRequest,value,index */
    {0x02, 0x0007, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x01, 0x0006, 0x0011},
    {0x01, 0x00ff, 0x0012},
    {0x01, 0x0014, 0x0013},
    {0x01, 0x0000, 0x0014},
    {0x01, 0x0042, 0x0051},
    {0x01, 0x0040, 0x0052},
    {0x01, 0x0051, 0x0053},
    {0x01, 0x0040, 0x0054},
    {0x01, 0x0000, 0x0055},
    {0x00, 0x0025, 0x0000},
    {0x00, 0x0026, 0x0000},
    {0x00, 0x0001, 0x0000},
    {0x00, 0x0027, 0x0000},
    {0x00, 0x008a, 0x0000},
    {0x00, 0x0000, 0x0000}
};

static __u16 spca501c_arowana_init_data[][3] = {
    /* bmRequest,value,index */
    {0x02, 0x0007, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x01, 0x0006, 0x0011},
    {0x01, 0x00ff, 0x0012},
    {0x01, 0x0014, 0x0013},
    {0x01, 0x0000, 0x0014},
    {0x01, 0x0042, 0x0051},
    {0x01, 0x0040, 0x0052},
    {0x01, 0x0051, 0x0053},
    {0x01, 0x0040, 0x0054},
    {0x01, 0x0000, 0x0055},
    {0x00, 0x0025, 0x0000},
    {0x00, 0x0026, 0x0000},
    {0x00, 0x0001, 0x0000},
    {0x00, 0x0027, 0x0000},
    {0x00, 0x008a, 0x0000},
    {0x02, 0x0000, 0x0005},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x2000, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0015, 0x0001},
    {0x05, 0x00ea, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0023, 0x0001},
    {0x05, 0x0003, 0x0000},
    {0x05, 0x0030, 0x0001},
    {0x05, 0x002b, 0x0000},
    {0x05, 0x0031, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0032, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0033, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0034, 0x0001},
    {0x05, 0x0002, 0x0000},
    {0x05, 0x0050, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0051, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0052, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0054, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x00, 0x0000, 0x0001},
    {0x00, 0x0000, 0x0002},
    {0x00, 0x000c, 0x0003},
    {0x00, 0x0000, 0x0004},
    {0x00, 0x0090, 0x0005},
    {0x00, 0x0000, 0x0006},
    {0x00, 0x0040, 0x0007},
    {0x00, 0x00c0, 0x0008},
    {0x00, 0x004a, 0x0009},
    {0x00, 0x0000, 0x000a},
    {0x00, 0x0000, 0x000b},
    {0x00, 0x0001, 0x000c},
    {0x00, 0x0001, 0x000d},
    {0x00, 0x0000, 0x000e},
    {0x00, 0x0002, 0x000f},
    {0x00, 0x0001, 0x0010},
    {0x00, 0x0000, 0x0011},
    {0x00, 0x0000, 0x0012},
    {0x00, 0x0002, 0x0020},
    {0x00, 0x0080, 0x0021},
    {0x00, 0x0001, 0x0022},
    {0x00, 0x00e0, 0x0023},
    {0x00, 0x0000, 0x0024},
    {0x00, 0x00d5, 0x0025},
    {0x00, 0x0000, 0x0026},
    {0x00, 0x000b, 0x0027},
    {0x00, 0x0000, 0x0046},
    {0x00, 0x0000, 0x0047},
    {0x00, 0x0000, 0x0048},
    {0x00, 0x0000, 0x0049},
    {0x00, 0x0008, 0x004a},
    {0xff, 0x0000, 0x00d0},
    {0xff, 0x00d8, 0x00d1},
    {0xff, 0x0000, 0x00d4},
    {0xff, 0x0000, 0x00d5},
    {0x01, 0x00a6, 0x0000},
    {0x01, 0x0028, 0x0001},
    {0x01, 0x0000, 0x0002},
    {0x01, 0x000a, 0x0003},
    {0x01, 0x0040, 0x0004},
    {0x01, 0x0066, 0x0007},
    {0x01, 0x0011, 0x0008},
    {0x01, 0x0032, 0x0009},
    {0x01, 0x00fd, 0x000a},
    {0x01, 0x0038, 0x000b},
    {0x01, 0x00d1, 0x000c},
    {0x01, 0x00f7, 0x000d},
    {0x01, 0x00ed, 0x000e},
    {0x01, 0x00d8, 0x000f},
    {0x01, 0x0038, 0x0010},
    {0x01, 0x00ff, 0x0015},
    {0x01, 0x0001, 0x0016},
    {0x01, 0x0032, 0x0017},
    {0x01, 0x0023, 0x0018},
    {0x01, 0x00ce, 0x0019},
    {0x01, 0x0023, 0x001a},
    {0x01, 0x0032, 0x001b},
    {0x01, 0x008d, 0x001c},
    {0x01, 0x00ce, 0x001d},
    {0x01, 0x008d, 0x001e},
    {0x01, 0x0000, 0x001f},
    {0x01, 0x0000, 0x0020},
    {0x01, 0x00ff, 0x003e},
    {0x01, 0x0003, 0x003f},
    {0x01, 0x0000, 0x0040},
    {0x01, 0x0035, 0x0041},
    {0x01, 0x0053, 0x0042},
    {0x01, 0x0069, 0x0043},
    {0x01, 0x007c, 0x0044},
    {0x01, 0x008c, 0x0045},
    {0x01, 0x009a, 0x0046},
    {0x01, 0x00a8, 0x0047},
    {0x01, 0x00b4, 0x0048},
    {0x01, 0x00bf, 0x0049},
    {0x01, 0x00ca, 0x004a},
    {0x01, 0x00d4, 0x004b},
    {0x01, 0x00dd, 0x004c},
    {0x01, 0x00e7, 0x004d},
    {0x01, 0x00ef, 0x004e},
    {0x01, 0x00f8, 0x004f},
    {0x01, 0x00ff, 0x0050},
    {0x01, 0x0001, 0x0056},
    {0x01, 0x0060, 0x0057},
    {0x01, 0x0040, 0x0058},
    {0x01, 0x0011, 0x0059},
    {0x01, 0x0001, 0x005a},
    {0x02, 0x0007, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x0015, 0x0006},
    {0x02, 0x100a, 0x0007},
    {0x02, 0xa048, 0x0000},
    {0x02, 0xc002, 0x0001},
    {0x02, 0x000f, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0025, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0026, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x05, 0x0027, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0001, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0020, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x00, 0x0090, 0x0005},
    {0x01, 0x00a6, 0x0000},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x2000, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0015, 0x0001},
    {0x05, 0x00ea, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0023, 0x0001},
    {0x05, 0x0003, 0x0000},
    {0x05, 0x0030, 0x0001},
    {0x05, 0x002b, 0x0000},
    {0x05, 0x0031, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0032, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0033, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0034, 0x0001},
    {0x05, 0x0002, 0x0000},
    {0x05, 0x0050, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0051, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0052, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0054, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x00, 0x0000, 0x0001},
    {0x00, 0x0000, 0x0002},
    {0x00, 0x000c, 0x0003},
    {0x00, 0x0000, 0x0004},
    {0x00, 0x0090, 0x0005},
    {0x00, 0x0000, 0x0006},
    {0x00, 0x0040, 0x0007},
    {0x00, 0x00c0, 0x0008},
    {0x00, 0x004a, 0x0009},
    {0x00, 0x0000, 0x000a},
    {0x00, 0x0000, 0x000b},
    {0x00, 0x0001, 0x000c},
    {0x00, 0x0001, 0x000d},
    {0x00, 0x0000, 0x000e},
    {0x00, 0x0002, 0x000f},
    {0x00, 0x0001, 0x0010},
    {0x00, 0x0000, 0x0011},
    {0x00, 0x0000, 0x0012},
    {0x00, 0x0002, 0x0020},
    {0x00, 0x0080, 0x0021},
    {0x00, 0x0001, 0x0022},
    {0x00, 0x00e0, 0x0023},
    {0x00, 0x0000, 0x0024},
    {0x00, 0x00d5, 0x0025},
    {0x00, 0x0000, 0x0026},
    {0x00, 0x000b, 0x0027},
    {0x00, 0x0000, 0x0046},
    {0x00, 0x0000, 0x0047},
    {0x00, 0x0000, 0x0048},
    {0x00, 0x0000, 0x0049},
    {0x00, 0x0008, 0x004a},
    {0xff, 0x0000, 0x00d0},
    {0xff, 0x00d8, 0x00d1},
    {0xff, 0x0000, 0x00d4},
    {0xff, 0x0000, 0x00d5},
    {0x01, 0x00a6, 0x0000},
    {0x01, 0x0028, 0x0001},
    {0x01, 0x0000, 0x0002},
    {0x01, 0x000a, 0x0003},
    {0x01, 0x0040, 0x0004},
    {0x01, 0x0066, 0x0007},
    {0x01, 0x0011, 0x0008},
    {0x01, 0x0032, 0x0009},
    {0x01, 0x00fd, 0x000a},
    {0x01, 0x0038, 0x000b},
    {0x01, 0x00d1, 0x000c},
    {0x01, 0x00f7, 0x000d},
    {0x01, 0x00ed, 0x000e},
    {0x01, 0x00d8, 0x000f},
    {0x01, 0x0038, 0x0010},
    {0x01, 0x00ff, 0x0015},
    {0x01, 0x0001, 0x0016},
    {0x01, 0x0032, 0x0017},
    {0x01, 0x0023, 0x0018},
    {0x01, 0x00ce, 0x0019},
    {0x01, 0x0023, 0x001a},
    {0x01, 0x0032, 0x001b},
    {0x01, 0x008d, 0x001c},
    {0x01, 0x00ce, 0x001d},
    {0x01, 0x008d, 0x001e},
    {0x01, 0x0000, 0x001f},
    {0x01, 0x0000, 0x0020},
    {0x01, 0x00ff, 0x003e},
    {0x01, 0x0003, 0x003f},
    {0x01, 0x0000, 0x0040},
    {0x01, 0x0035, 0x0041},
    {0x01, 0x0053, 0x0042},
    {0x01, 0x0069, 0x0043},
    {0x01, 0x007c, 0x0044},
    {0x01, 0x008c, 0x0045},
    {0x01, 0x009a, 0x0046},
    {0x01, 0x00a8, 0x0047},
    {0x01, 0x00b4, 0x0048},
    {0x01, 0x00bf, 0x0049},
    {0x01, 0x00ca, 0x004a},
    {0x01, 0x00d4, 0x004b},
    {0x01, 0x00dd, 0x004c},
    {0x01, 0x00e7, 0x004d},
    {0x01, 0x00ef, 0x004e},
    {0x01, 0x00f8, 0x004f},
    {0x01, 0x00ff, 0x0050},
    {0x01, 0x0001, 0x0056},
    {0x01, 0x0060, 0x0057},
    {0x01, 0x0040, 0x0058},
    {0x01, 0x0011, 0x0059},
    {0x01, 0x0001, 0x005a},
    {0x02, 0x0007, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x0015, 0x0006},
    {0x02, 0x100a, 0x0007},
    {0x02, 0xa048, 0x0000},
    {0x02, 0xc002, 0x0001},
    {0x02, 0x000f, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0025, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0026, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x05, 0x0027, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0001, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0020, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x00, 0x0090, 0x0005},
    {0x01, 0x00a6, 0x0000},
    {0x01, 0x0003, 0x003f},
    {0x01, 0x0001, 0x0056},
    {0x01, 0x0011, 0x0008},
    {0x01, 0x0032, 0x0009},
    {0x01, 0xfffd, 0x000a},
    {0x01, 0x0023, 0x000b},
    {0x01, 0xffea, 0x000c},
    {0x01, 0xfff4, 0x000d},
    {0x01, 0xfffc, 0x000e},
    {0x01, 0xffe3, 0x000f},
    {0x01, 0x001f, 0x0010},
    {0x01, 0x00a8, 0x0001},
    {0x01, 0x0067, 0x0007},
    {0x01, 0x0032, 0x0017},
    {0x01, 0x0023, 0x0018},
    {0x01, 0x00ce, 0x0019},
    {0x01, 0x0023, 0x001a},
    {0x01, 0x0032, 0x001b},
    {0x01, 0x008d, 0x001c},
    {0x01, 0x00ce, 0x001d},
    {0x01, 0x008d, 0x001e},
    {0x01, 0x00c8, 0x0015},
    {0x01, 0x0032, 0x0016},
    {0x01, 0x0000, 0x0011},
    {0x01, 0x0000, 0x0012},
    {0x01, 0x0000, 0x0013},
    {0x01, 0x000a, 0x0003},
    {0x02, 0xc002, 0x0001},
    {0x02, 0x0007, 0x0005},
    {0x02, 0xc000, 0x0001},
    {0x02, 0x0000, 0x0005},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x2000, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0015, 0x0001},
    {0x05, 0x00ea, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0023, 0x0001},
    {0x05, 0x0003, 0x0000},
    {0x05, 0x0030, 0x0001},
    {0x05, 0x002b, 0x0000},
    {0x05, 0x0031, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0032, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0033, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0034, 0x0001},
    {0x05, 0x0002, 0x0000},
    {0x05, 0x0050, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0051, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0052, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0054, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x00, 0x0000, 0x0001},
    {0x00, 0x0000, 0x0002},
    {0x00, 0x000c, 0x0003},
    {0x00, 0x0000, 0x0004},
    {0x00, 0x0090, 0x0005},
    {0x00, 0x0000, 0x0006},
    {0x00, 0x0040, 0x0007},
    {0x00, 0x00c0, 0x0008},
    {0x00, 0x004a, 0x0009},
    {0x00, 0x0000, 0x000a},
    {0x00, 0x0000, 0x000b},
    {0x00, 0x0001, 0x000c},
    {0x00, 0x0001, 0x000d},
    {0x00, 0x0000, 0x000e},
    {0x00, 0x0002, 0x000f},
    {0x00, 0x0001, 0x0010},
    {0x00, 0x0000, 0x0011},
    {0x00, 0x0000, 0x0012},
    {0x00, 0x0002, 0x0020},
    {0x00, 0x0080, 0x0021},
    {0x00, 0x0001, 0x0022},
    {0x00, 0x00e0, 0x0023},
    {0x00, 0x0000, 0x0024},
    {0x00, 0x00d5, 0x0025},
    {0x00, 0x0000, 0x0026},
    {0x00, 0x000b, 0x0027},
    {0x00, 0x0000, 0x0046},
    {0x00, 0x0000, 0x0047},
    {0x00, 0x0000, 0x0048},
    {0x00, 0x0000, 0x0049},
    {0x00, 0x0008, 0x004a},
    {0xff, 0x0000, 0x00d0},
    {0xff, 0x00d8, 0x00d1},
    {0xff, 0x0000, 0x00d4},
    {0xff, 0x0000, 0x00d5},
    {0x01, 0x00a6, 0x0000},
    {0x01, 0x0028, 0x0001},
    {0x01, 0x0000, 0x0002},
    {0x01, 0x000a, 0x0003},
    {0x01, 0x0040, 0x0004},
    {0x01, 0x0066, 0x0007},
    {0x01, 0x0011, 0x0008},
    {0x01, 0x0032, 0x0009},
    {0x01, 0x00fd, 0x000a},
    {0x01, 0x0038, 0x000b},
    {0x01, 0x00d1, 0x000c},
    {0x01, 0x00f7, 0x000d},
    {0x01, 0x00ed, 0x000e},
    {0x01, 0x00d8, 0x000f},
    {0x01, 0x0038, 0x0010},
    {0x01, 0x00ff, 0x0015},
    {0x01, 0x0001, 0x0016},
    {0x01, 0x0032, 0x0017},
    {0x01, 0x0023, 0x0018},
    {0x01, 0x00ce, 0x0019},
    {0x01, 0x0023, 0x001a},
    {0x01, 0x0032, 0x001b},
    {0x01, 0x008d, 0x001c},
    {0x01, 0x00ce, 0x001d},
    {0x01, 0x008d, 0x001e},
    {0x01, 0x0000, 0x001f},
    {0x01, 0x0000, 0x0020},
    {0x01, 0x00ff, 0x003e},
    {0x01, 0x0003, 0x003f},
    {0x01, 0x0000, 0x0040},
    {0x01, 0x0035, 0x0041},
    {0x01, 0x0053, 0x0042},
    {0x01, 0x0069, 0x0043},
    {0x01, 0x007c, 0x0044},
    {0x01, 0x008c, 0x0045},
    {0x01, 0x009a, 0x0046},
    {0x01, 0x00a8, 0x0047},
    {0x01, 0x00b4, 0x0048},
    {0x01, 0x00bf, 0x0049},
    {0x01, 0x00ca, 0x004a},
    {0x01, 0x00d4, 0x004b},
    {0x01, 0x00dd, 0x004c},
    {0x01, 0x00e7, 0x004d},
    {0x01, 0x00ef, 0x004e},
    {0x01, 0x00f8, 0x004f},
    {0x01, 0x00ff, 0x0050},
    {0x01, 0x0001, 0x0056},
    {0x01, 0x0060, 0x0057},
    {0x01, 0x0040, 0x0058},
    {0x01, 0x0011, 0x0059},
    {0x01, 0x0001, 0x005a},
    {0x02, 0x0007, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x0015, 0x0006},
    {0x02, 0x100a, 0x0007},
    {0x02, 0xa048, 0x0000},
    {0x02, 0xc002, 0x0001},
    {0x02, 0x000f, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0025, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0026, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x05, 0x0027, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0001, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0020, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x00, 0x0090, 0x0005},
    {0x01, 0x00a6, 0x0000},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x2000, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0015, 0x0001},
    {0x05, 0x00ea, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0023, 0x0001},
    {0x05, 0x0003, 0x0000},
    {0x05, 0x0030, 0x0001},
    {0x05, 0x002b, 0x0000},
    {0x05, 0x0031, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0032, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0033, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0034, 0x0001},
    {0x05, 0x0002, 0x0000},
    {0x05, 0x0050, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0051, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0052, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0054, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x00, 0x0000, 0x0001},
    {0x00, 0x0000, 0x0002},
    {0x00, 0x000c, 0x0003},
    {0x00, 0x0000, 0x0004},
    {0x00, 0x0090, 0x0005},
    {0x00, 0x0000, 0x0006},
    {0x00, 0x0040, 0x0007},
    {0x00, 0x00c0, 0x0008},
    {0x00, 0x004a, 0x0009},
    {0x00, 0x0000, 0x000a},
    {0x00, 0x0000, 0x000b},
    {0x00, 0x0001, 0x000c},
    {0x00, 0x0001, 0x000d},
    {0x00, 0x0000, 0x000e},
    {0x00, 0x0002, 0x000f},
    {0x00, 0x0001, 0x0010},
    {0x00, 0x0000, 0x0011},
    {0x00, 0x0000, 0x0012},
    {0x00, 0x0002, 0x0020},
    {0x00, 0x0080, 0x0021},
    {0x00, 0x0001, 0x0022},
    {0x00, 0x00e0, 0x0023},
    {0x00, 0x0000, 0x0024},
    {0x00, 0x00d5, 0x0025},
    {0x00, 0x0000, 0x0026},
    {0x00, 0x000b, 0x0027},
    {0x00, 0x0000, 0x0046},
    {0x00, 0x0000, 0x0047},
    {0x00, 0x0000, 0x0048},
    {0x00, 0x0000, 0x0049},
    {0x00, 0x0008, 0x004a},
    {0xff, 0x0000, 0x00d0},
    {0xff, 0x00d8, 0x00d1},
    {0xff, 0x0000, 0x00d4},
    {0xff, 0x0000, 0x00d5},
    {0x01, 0x00a6, 0x0000},
    {0x01, 0x0028, 0x0001},
    {0x01, 0x0000, 0x0002},
    {0x01, 0x000a, 0x0003},
    {0x01, 0x0040, 0x0004},
    {0x01, 0x0066, 0x0007},
    {0x01, 0x0011, 0x0008},
    {0x01, 0x0032, 0x0009},
    {0x01, 0x00fd, 0x000a},
    {0x01, 0x0038, 0x000b},
    {0x01, 0x00d1, 0x000c},
    {0x01, 0x00f7, 0x000d},
    {0x01, 0x00ed, 0x000e},
    {0x01, 0x00d8, 0x000f},
    {0x01, 0x0038, 0x0010},
    {0x01, 0x00ff, 0x0015},
    {0x01, 0x0001, 0x0016},
    {0x01, 0x0032, 0x0017},
    {0x01, 0x0023, 0x0018},
    {0x01, 0x00ce, 0x0019},
    {0x01, 0x0023, 0x001a},
    {0x01, 0x0032, 0x001b},
    {0x01, 0x008d, 0x001c},
    {0x01, 0x00ce, 0x001d},
    {0x01, 0x008d, 0x001e},
    {0x01, 0x0000, 0x001f},
    {0x01, 0x0000, 0x0020},
    {0x01, 0x00ff, 0x003e},
    {0x01, 0x0003, 0x003f},
    {0x01, 0x0000, 0x0040},
    {0x01, 0x0035, 0x0041},
    {0x01, 0x0053, 0x0042},
    {0x01, 0x0069, 0x0043},
    {0x01, 0x007c, 0x0044},
    {0x01, 0x008c, 0x0045},
    {0x01, 0x009a, 0x0046},
    {0x01, 0x00a8, 0x0047},
    {0x01, 0x00b4, 0x0048},
    {0x01, 0x00bf, 0x0049},
    {0x01, 0x00ca, 0x004a},
    {0x01, 0x00d4, 0x004b},
    {0x01, 0x00dd, 0x004c},
    {0x01, 0x00e7, 0x004d},
    {0x01, 0x00ef, 0x004e},
    {0x01, 0x00f8, 0x004f},
    {0x01, 0x00ff, 0x0050},
    {0x01, 0x0001, 0x0056},
    {0x01, 0x0060, 0x0057},
    {0x01, 0x0040, 0x0058},
    {0x01, 0x0011, 0x0059},
    {0x01, 0x0001, 0x005a},
    {0x02, 0x0007, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x0015, 0x0006},
    {0x02, 0x100a, 0x0007},
    {0x02, 0xa048, 0x0000},
    {0x02, 0xc002, 0x0001},
    {0x02, 0x000f, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0025, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0026, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x05, 0x0027, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0001, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0020, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x00, 0x0090, 0x0005},
    {0x01, 0x00a6, 0x0000},
    {0x05, 0x0026, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x05, 0x0027, 0x0001},
    {0x05, 0x000f, 0x0000},
    {0x01, 0x0003, 0x003f},
    {0x01, 0x0001, 0x0056},
    {0x01, 0x0011, 0x0008},
    {0x01, 0x0032, 0x0009},
    {0x01, 0xfffd, 0x000a},
    {0x01, 0x0023, 0x000b},
    {0x01, 0xffea, 0x000c},
    {0x01, 0xfff4, 0x000d},
    {0x01, 0xfffc, 0x000e},
    {0x01, 0xffe3, 0x000f},
    {0x01, 0x001f, 0x0010},
    {0x01, 0x00a8, 0x0001},
    {0x01, 0x0067, 0x0007},
    {0x01, 0x0042, 0x0051},
    {0x01, 0x0051, 0x0053},
    {0x01, 0x000a, 0x0003},
    {0x02, 0xc002, 0x0001},
    {0x02, 0x0007, 0x0005},
    {0x02, 0xc000, 0x0001},
    {0x02, 0x0000, 0x0005},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x2000, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0015, 0x0001},
    {0x05, 0x00ea, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0023, 0x0001},
    {0x05, 0x0003, 0x0000},
    {0x05, 0x0030, 0x0001},
    {0x05, 0x002b, 0x0000},
    {0x05, 0x0031, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0032, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0033, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0034, 0x0001},
    {0x05, 0x0002, 0x0000},
    {0x05, 0x0050, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0051, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0052, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0054, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x00, 0x0000, 0x0001},
    {0x00, 0x0000, 0x0002},
    {0x00, 0x000c, 0x0003},
    {0x00, 0x0000, 0x0004},
    {0x00, 0x0090, 0x0005},
    {0x00, 0x0000, 0x0006},
    {0x00, 0x0040, 0x0007},
    {0x00, 0x00c0, 0x0008},
    {0x00, 0x004a, 0x0009},
    {0x00, 0x0000, 0x000a},
    {0x00, 0x0000, 0x000b},
    {0x00, 0x0001, 0x000c},
    {0x00, 0x0001, 0x000d},
    {0x00, 0x0000, 0x000e},
    {0x00, 0x0002, 0x000f},
    {0x00, 0x0001, 0x0010},
    {0x00, 0x0000, 0x0011},
    {0x00, 0x0000, 0x0012},
    {0x00, 0x0002, 0x0020},
    {0x00, 0x0080, 0x0021},
    {0x00, 0x0001, 0x0022},
    {0x00, 0x00e0, 0x0023},
    {0x00, 0x0000, 0x0024},
    {0x00, 0x00d5, 0x0025},
    {0x00, 0x0000, 0x0026},
    {0x00, 0x000b, 0x0027},
    {0x00, 0x0000, 0x0046},
    {0x00, 0x0000, 0x0047},
    {0x00, 0x0000, 0x0048},
    {0x00, 0x0000, 0x0049},
    {0x00, 0x0008, 0x004a},
    {0xff, 0x0000, 0x00d0},
    {0xff, 0x00d8, 0x00d1},
    {0xff, 0x0000, 0x00d4},
    {0xff, 0x0000, 0x00d5},
    {0x01, 0x00a6, 0x0000},
    {0x01, 0x0028, 0x0001},
    {0x01, 0x0000, 0x0002},
    {0x01, 0x000a, 0x0003},
    {0x01, 0x0040, 0x0004},
    {0x01, 0x0066, 0x0007},
    {0x01, 0x0011, 0x0008},
    {0x01, 0x0032, 0x0009},
    {0x01, 0x00fd, 0x000a},
    {0x01, 0x0038, 0x000b},
    {0x01, 0x00d1, 0x000c},
    {0x01, 0x00f7, 0x000d},
    {0x01, 0x00ed, 0x000e},
    {0x01, 0x00d8, 0x000f},
    {0x01, 0x0038, 0x0010},
    {0x01, 0x00ff, 0x0015},
    {0x01, 0x0001, 0x0016},
    {0x01, 0x0032, 0x0017},
    {0x01, 0x0023, 0x0018},
    {0x01, 0x00ce, 0x0019},
    {0x01, 0x0023, 0x001a},
    {0x01, 0x0032, 0x001b},
    {0x01, 0x008d, 0x001c},
    {0x01, 0x00ce, 0x001d},
    {0x01, 0x008d, 0x001e},
    {0x01, 0x0000, 0x001f},
    {0x01, 0x0000, 0x0020},
    {0x01, 0x00ff, 0x003e},
    {0x01, 0x0003, 0x003f},
    {0x01, 0x0000, 0x0040},
    {0x01, 0x0035, 0x0041},
    {0x01, 0x0053, 0x0042},
    {0x01, 0x0069, 0x0043},
    {0x01, 0x007c, 0x0044},
    {0x01, 0x008c, 0x0045},
    {0x01, 0x009a, 0x0046},
    {0x01, 0x00a8, 0x0047},
    {0x01, 0x00b4, 0x0048},
    {0x01, 0x00bf, 0x0049},
    {0x01, 0x00ca, 0x004a},
    {0x01, 0x00d4, 0x004b},
    {0x01, 0x00dd, 0x004c},
    {0x01, 0x00e7, 0x004d},
    {0x01, 0x00ef, 0x004e},
    {0x01, 0x00f8, 0x004f},
    {0x01, 0x00ff, 0x0050},
    {0x01, 0x0001, 0x0056},
    {0x01, 0x0060, 0x0057},
    {0x01, 0x0040, 0x0058},
    {0x01, 0x0011, 0x0059},
    {0x01, 0x0001, 0x005a},
    {0x02, 0x0007, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x0015, 0x0006},
    {0x02, 0x100a, 0x0007},
    {0x02, 0xa048, 0x0000},
    {0x02, 0xc002, 0x0001},
    {0x02, 0x000f, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0025, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0026, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x05, 0x0027, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0001, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0020, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x00, 0x0090, 0x0005},
    {0x01, 0x00a6, 0x0000},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x2000, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0015, 0x0001},
    {0x05, 0x00ea, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0023, 0x0001},
    {0x05, 0x0003, 0x0000},
    {0x05, 0x0030, 0x0001},
    {0x05, 0x002b, 0x0000},
    {0x05, 0x0031, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0032, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0033, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0034, 0x0001},
    {0x05, 0x0002, 0x0000},
    {0x05, 0x0050, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0051, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0052, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0054, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x00, 0x0000, 0x0001},
    {0x00, 0x0000, 0x0002},
    {0x00, 0x000c, 0x0003},
    {0x00, 0x0000, 0x0004},
    {0x00, 0x0090, 0x0005},
    {0x00, 0x0000, 0x0006},
    {0x00, 0x0040, 0x0007},
    {0x00, 0x00c0, 0x0008},
    {0x00, 0x004a, 0x0009},
    {0x00, 0x0000, 0x000a},
    {0x00, 0x0000, 0x000b},
    {0x00, 0x0001, 0x000c},
    {0x00, 0x0001, 0x000d},
    {0x00, 0x0000, 0x000e},
    {0x00, 0x0002, 0x000f},
    {0x00, 0x0001, 0x0010},
    {0x00, 0x0000, 0x0011},
    {0x00, 0x0000, 0x0012},
    {0x00, 0x0002, 0x0020},
    {0x00, 0x0080, 0x0021},
    {0x00, 0x0001, 0x0022},
    {0x00, 0x00e0, 0x0023},
    {0x00, 0x0000, 0x0024},
    {0x00, 0x00d5, 0x0025},
    {0x00, 0x0000, 0x0026},
    {0x00, 0x000b, 0x0027},
    {0x00, 0x0000, 0x0046},
    {0x00, 0x0000, 0x0047},
    {0x00, 0x0000, 0x0048},
    {0x00, 0x0000, 0x0049},
    {0x00, 0x0008, 0x004a},
    {0xff, 0x0000, 0x00d0},
    {0xff, 0x00d8, 0x00d1},
    {0xff, 0x0000, 0x00d4},
    {0xff, 0x0000, 0x00d5},
    {0x01, 0x00a6, 0x0000},
    {0x01, 0x0028, 0x0001},
    {0x01, 0x0000, 0x0002},
    {0x01, 0x000a, 0x0003},
    {0x01, 0x0040, 0x0004},
    {0x01, 0x0066, 0x0007},
    {0x01, 0x0011, 0x0008},
    {0x01, 0x0032, 0x0009},
    {0x01, 0x00fd, 0x000a},
    {0x01, 0x0038, 0x000b},
    {0x01, 0x00d1, 0x000c},
    {0x01, 0x00f7, 0x000d},
    {0x01, 0x00ed, 0x000e},
    {0x01, 0x00d8, 0x000f},
    {0x01, 0x0038, 0x0010},
    {0x01, 0x00ff, 0x0015},
    {0x01, 0x0001, 0x0016},
    {0x01, 0x0032, 0x0017},
    {0x01, 0x0023, 0x0018},
    {0x01, 0x00ce, 0x0019},
    {0x01, 0x0023, 0x001a},
    {0x01, 0x0032, 0x001b},
    {0x01, 0x008d, 0x001c},
    {0x01, 0x00ce, 0x001d},
    {0x01, 0x008d, 0x001e},
    {0x01, 0x0000, 0x001f},
    {0x01, 0x0000, 0x0020},
    {0x01, 0x00ff, 0x003e},
    {0x01, 0x0003, 0x003f},
    {0x01, 0x0000, 0x0040},
    {0x01, 0x0035, 0x0041},
    {0x01, 0x0053, 0x0042},
    {0x01, 0x0069, 0x0043},
    {0x01, 0x007c, 0x0044},
    {0x01, 0x008c, 0x0045},
    {0x01, 0x009a, 0x0046},
    {0x01, 0x00a8, 0x0047},
    {0x01, 0x00b4, 0x0048},
    {0x01, 0x00bf, 0x0049},
    {0x01, 0x00ca, 0x004a},
    {0x01, 0x00d4, 0x004b},
    {0x01, 0x00dd, 0x004c},
    {0x01, 0x00e7, 0x004d},
    {0x01, 0x00ef, 0x004e},
    {0x01, 0x00f8, 0x004f},
    {0x01, 0x00ff, 0x0050},
    {0x01, 0x0001, 0x0056},
    {0x01, 0x0060, 0x0057},
    {0x01, 0x0040, 0x0058},
    {0x01, 0x0011, 0x0059},
    {0x01, 0x0001, 0x005a},
    {0x02, 0x0007, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x0015, 0x0006},
    {0x02, 0x100a, 0x0007},
    {0x02, 0xa048, 0x0000},
    {0x02, 0xc002, 0x0001},
    {0x02, 0x000f, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0025, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0026, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x05, 0x0027, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0001, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0020, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x00, 0x0090, 0x0005},
    {0x01, 0x00a6, 0x0000},
    {0x05, 0x0026, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x05, 0x0027, 0x0001},
    {0x05, 0x001e, 0x0000},
    {0x01, 0x0003, 0x003f},
    {0x01, 0x0001, 0x0056},
    {0x01, 0x0011, 0x0008},
    {0x01, 0x0032, 0x0009},
    {0x01, 0xfffd, 0x000a},
    {0x01, 0x0023, 0x000b},
    {0x01, 0xffea, 0x000c},
    {0x01, 0xfff4, 0x000d},
    {0x01, 0xfffc, 0x000e},
    {0x01, 0xffe3, 0x000f},
    {0x01, 0x001f, 0x0010},
    {0x01, 0x00a8, 0x0001},
    {0x01, 0x0067, 0x0007},
    {0x01, 0x0042, 0x0051},
    {0x01, 0x0051, 0x0053},
    {0x01, 0x000a, 0x0003},
    {0x02, 0xc002, 0x0001},
    {0x02, 0x0007, 0x0005},
    {0x01, 0x0042, 0x0051},
    {0x01, 0x0051, 0x0053},
    {0x05, 0x0026, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x05, 0x0027, 0x0001},
    {0x05, 0x002d, 0x0000},
    {0x01, 0x0003, 0x003f},
    {0x01, 0x0001, 0x0056},
    {0x02, 0xc000, 0x0001},
    {0x02, 0x0000, 0x0005},
    {0x00, 0x0000, 0x0000}
};

/* Unknow camera from Ori Usbid 0x0000:0x0000 */
static __u16 spca501c_mysterious_open_data[][3] = {	/* Based on snoops from Ori Cohen */
    {0x02, 0x000f, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x05, 0x0022, 0x0004},
/* DSP Registers     */
    {0x01, 0x0016, 0x0011},	//RGB offset
    {0x01, 0x0000, 0x0012},
    {0x01, 0x0006, 0x0013},
    {0x01, 0x0078, 0x0051},
    {0x01, 0x0040, 0x0052},
    {0x01, 0x0046, 0x0053},
    {0x01, 0x0040, 0x0054},
    {0x00, 0x0025, 0x0000},
//{0x00, 0x0000, 0x0000 },
/* Part 2            */
/* TG Registers      */
    {0x00, 0x0026, 0x0000},
    {0x00, 0x0001, 0x0000},
    {0x00, 0x0027, 0x0000},
    {0x00, 0x008a, 0x0000},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x2000, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0015, 0x0001},
    {0x05, 0x00ea, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0023, 0x0001},
    {0x05, 0x0003, 0x0000},
    {0x05, 0x0030, 0x0001},
    {0x05, 0x002b, 0x0000},
    {0x05, 0x0031, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0032, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0033, 0x0001},
    {0x05, 0x0023, 0x0000},
    {0x05, 0x0034, 0x0001},
    {0x05, 0x0002, 0x0000},
    {0x05, 0x0050, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0051, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0052, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0054, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0, 0, 0}
};

static __u16 spca501c_mysterious_init_data[][3] = {	/* Based on snoops from Ori Cohen */
/* Part 3 */
/* TG registers       */
//{0x00, 0x0000, 0x0000 },
    {0x00, 0x0000, 0x0001},
    {0x00, 0x0000, 0x0002},
    {0x00, 0x0006, 0x0003},
    {0x00, 0x0000, 0x0004},
    {0x00, 0x0090, 0x0005},
    {0x00, 0x0000, 0x0006},
    {0x00, 0x0040, 0x0007},
    {0x00, 0x00c0, 0x0008},
    {0x00, 0x004a, 0x0009},
    {0x00, 0x0000, 0x000a},
    {0x00, 0x0000, 0x000b},
    {0x00, 0x0001, 0x000c},
    {0x00, 0x0001, 0x000d},
    {0x00, 0x0000, 0x000e},
    {0x00, 0x0002, 0x000f},
    {0x00, 0x0001, 0x0010},
    {0x00, 0x0000, 0x0011},
    {0x00, 0x0001, 0x0012},
    {0x00, 0x0002, 0x0020},
    {0x00, 0x0080, 0x0021},	//640
    {0x00, 0x0001, 0x0022},
    {0x00, 0x00e0, 0x0023},	//480
    {0x00, 0x0000, 0x0024},	// Offset H hight
    {0x00, 0x00d3, 0x0025},	// low
    {0x00, 0x0000, 0x0026},	// Offset V
    {0x00, 0x000d, 0x0027},	// low
    {0x00, 0x0000, 0x0046},
    {0x00, 0x0000, 0x0047},
    {0x00, 0x0000, 0x0048},
    {0x00, 0x0000, 0x0049},
    {0x00, 0x0008, 0x004a},
/* DSP Registers     */
    {0x01, 0x00a6, 0x0000},
    {0x01, 0x0028, 0x0001},
    {0x01, 0x0000, 0x0002},
    {0x01, 0x000a, 0x0003},	// Level Calc bit7 ->1 Auto
    {0x01, 0x0040, 0x0004},
    {0x01, 0x0066, 0x0007},
    {0x01, 0x000f, 0x0008},	// A11 Color correction coeff
    {0x01, 0x002d, 0x0009},	// A12
    {0x01, 0x0005, 0x000a},	// A13
    {0x01, 0x0023, 0x000b},	// A21
    {0x01, 0x00e0, 0x000c},	// A22
    {0x01, 0x00fd, 0x000d},	// A23
    {0x01, 0x00f4, 0x000e},	// A31
    {0x01, 0x00e4, 0x000f},	// A32
    {0x01, 0x0028, 0x0010},	// A33
    {0x01, 0x00ff, 0x0015},	// Reserved
    {0x01, 0x0001, 0x0016},	// Reserved
    {0x01, 0x0032, 0x0017},	// Win1 Start begin
    {0x01, 0x0023, 0x0018},
    {0x01, 0x00ce, 0x0019},
    {0x01, 0x0023, 0x001a},
    {0x01, 0x0032, 0x001b},
    {0x01, 0x008d, 0x001c},
    {0x01, 0x00ce, 0x001d},
    {0x01, 0x008d, 0x001e},
    {0x01, 0x0000, 0x001f},
    {0x01, 0x0000, 0x0020},	//Win1 Start end
    {0x01, 0x00ff, 0x003e},	//Reserved begin
    {0x01, 0x0002, 0x003f},
    {0x01, 0x0000, 0x0040},
    {0x01, 0x0035, 0x0041},
    {0x01, 0x0053, 0x0042},
    {0x01, 0x0069, 0x0043},
    {0x01, 0x007c, 0x0044},
    {0x01, 0x008c, 0x0045},
    {0x01, 0x009a, 0x0046},
    {0x01, 0x00a8, 0x0047},
    {0x01, 0x00b4, 0x0048},
    {0x01, 0x00bf, 0x0049},
    {0x01, 0x00ca, 0x004a},
    {0x01, 0x00d4, 0x004b},
    {0x01, 0x00dd, 0x004c},
    {0x01, 0x00e7, 0x004d},
    {0x01, 0x00ef, 0x004e},
    {0x01, 0x00f8, 0x004f},
    {0x01, 0x00ff, 0x0050},
    {0x01, 0x0003, 0x0056},	// Reserved end
    {0x01, 0x0060, 0x0057},	//Edge Gain
    {0x01, 0x0040, 0x0058},	//
    {0x01, 0x0011, 0x0059},	//Edge Bandwidth
    {0x01, 0x0001, 0x005a},	//
    {0x02, 0x0007, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x02, 0x0007, 0x0005},
    {0x02, 0x0015, 0x0006},
    {0x02, 0x200a, 0x0007},
    {0x02, 0xa048, 0x0000},
    {0x02, 0xc000, 0x0001},
    {0x02, 0x000f, 0x0005},
    {0x02, 0xa048, 0x0000},
    {0x05, 0x0022, 0x0004},
    {0x05, 0x0025, 0x0001},
    {0x05, 0x0000, 0x0000},
/* Part 4             */
    {0x05, 0x0026, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x05, 0x0027, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0001, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x05, 0x0021, 0x0001},
    {0x05, 0x00d2, 0x0000},
    {0x05, 0x0020, 0x0001},
    {0x05, 0x0000, 0x0000},
    {0x00, 0x0090, 0x0005},
    {0x01, 0x00a6, 0x0000},
    {0x02, 0x0000, 0x0005},
    {0x05, 0x0026, 0x0001},
    {0x05, 0x0001, 0x0000},
    {0x05, 0x0027, 0x0001},
    {0x05, 0x004e, 0x0000},
/* Part 5             */
    {0x01, 0x0003, 0x003f},
    {0x01, 0x0001, 0x0056},
    {0x01, 0x000f, 0x0008},
    {0x01, 0x002d, 0x0009},
    {0x01, 0x0005, 0x000a},
    {0x01, 0x0023, 0x000b},
    {0x01, 0xffe0, 0x000c},
    {0x01, 0xfffd, 0x000d},
    {0x01, 0xfff4, 0x000e},
    {0x01, 0xffe4, 0x000f},
    {0x01, 0x0028, 0x0010},
    {0x01, 0x00a8, 0x0001},
    {0x01, 0x0066, 0x0007},
    {0x01, 0x0032, 0x0017},
    {0x01, 0x0023, 0x0018},
    {0x01, 0x00ce, 0x0019},
    {0x01, 0x0023, 0x001a},
    {0x01, 0x0032, 0x001b},
    {0x01, 0x008d, 0x001c},
    {0x01, 0x00ce, 0x001d},
    {0x01, 0x008d, 0x001e},
    {0x01, 0x00c8, 0x0015},	//c8 Poids fort Luma
    {0x01, 0x0032, 0x0016},	//32
    {0x01, 0x0016, 0x0011},	//R 00
    {0x01, 0x0016, 0x0012},	//G 00
    {0x01, 0x0016, 0x0013},	//B 00
    {0x01, 0x000a, 0x0003},
    {0x02, 0xc002, 0x0001},
    {0x02, 0x0007, 0x0005},
    {0, 0, 0}
};

/**************** Old code from spca50x *******************************/

/**********************************************************************
 * Get average luminance
 **********************************************************************/
static inline __u8 get_avg_lum(struct usb_spca50x *spca50x)
{
    __u8 luminance;		//The average luminance from camera
    switch (PWC_SC(spca50x)->pwc_info.bridge) {
    case BRIDGE_SPCA501:
	luminance = spca50x_reg_read(spca50x->dev, SPCA501_REG_CCDSP,
				     0x26, 2) >> 8;
	break;
#ifdef SPCA50X_ENABLE_EXP_BRIGHTNESS
    case BRIDGE_SPCA561:
    case BRIDGE_SPCA508:
	luminance = spca50x_reg_read(spca50x->dev, 0, 0x8621, 1);
	break;
#endif				/* SPCA50X_ENABLE_EXP_BRIGHTNESS */
    default:
	luminance = 0;
	break;
    }
    return luminance;
}

/**********************************************************************
 * Get average R-G and B-G
 **********************************************************************/
static inline __u8 get_avg_RG(struct usb_spca50x *spca50x)
{
    __u8 rg;			//The average R-G for window5
    switch (PWC_SC(spca50x)->pwc_info.bridge) {
    case BRIDGE_SPCA501:
	rg = spca50x_reg_read(spca50x->dev, SPCA501_REG_CCDSP, 0x30,
			      2) >> 8;
	break;
    default:
	rg = 0;
	break;
    }
    return rg;
}

/**********************************************************************
 * Get average B-G
 **********************************************************************/
static inline __u8 get_avg_BG(struct usb_spca50x *spca50x)
{
    __u8 bg;			//The average B-G for window5
    switch (PWC_SC(spca50x)->pwc_info.bridge) {
    case BRIDGE_SPCA501:
	bg = spca50x_reg_read(spca50x->dev, SPCA501_REG_CCDSP, 0x2f,
			      2) >> 8;
	break;
    default:
	bg = 0;
	break;
    }
    return bg;
}

/**********************************************************************
* spca50x_get_whiteness
* Function reads the "whiteness parameter" from the camera
* Actually "whiteness" is a parameter that close to brighness
* but currently ununderstanded
* Receives the pointer to the description structure
* returns the value of whiteness
**********************************************************************/
static inline __u16 spca50x_get_whiteness(struct usb_spca50x *spca50x)
{
#ifdef SPCA50X_ENABLE_EXPERIMENTAL
    __u16 whiteness = 0;	//the "whiteness" parameter
    __u16 br = 0;		//the brightness value
    int i;			// just an index variable
    __u16 mask;			//the bit mask to set bit in p.contrast
    __u8 br_table[] = { 128, 64, 32, 16, 0 };	//the brightness table

    //this parameter is known for spca501 only
    if (PWC_SC(spca50x)->pwc_info.bridge != BRIDGE_SPCA501)
	return 0;

    /* Getting "whiteness" (strange parameters in TG 0x0D */
    br = spca50x_reg_read(spca50x->dev, 0x0, 0x0d, 2);
    for (i = 0, mask = 1; br_table[i]; i++, mask <<= 1) {
	if (br & br_table[i])
	    whiteness |= mask;
    }
    whiteness <<= 4;
    return whiteness;
#else				/* SPCA50X_ENABLE_EXPERIMENTAL */
    return 0;
#endif				/* SPCA50X_ENABLE_EXPERIMENTAL */
}

/**********************************************************************
* spca50x_set_whiteness
* Function sets the "whiteness parameter" from the camera
* Actually "whiteness" is a parameter that close to brighness
* but currently ununderstanded
* Receives the pointer to the description structure 
* and whiteness value
**********************************************************************/
static inline void
spca50x_set_whiteness(struct usb_spca50x *spca50x, __u8 whiteness)
{
#ifdef SPCA50X_ENABLE_EXPERIMENTAL
    __u8 br_high = 0;		//the contrast value
    __u8 br_out = 0;		// contrast output value
    int i;			// just an index variable
    __u16 mask;			//the bit mask to set bit in contrast
    __u8 br_table[] = { 128, 64, 32, 16, 0 };	//the brightness table


    //this parameter is known for spca501 only
    if (spca50x->bridge != BRIDGE_SPCA501)
	return;

    PDEBUG(3, "Setting whiteness %d", whiteness);
    br_high = whiteness >> 4;
    for (i = 0, mask = 1; br_table[i]; i++, mask <<= 1) {
	if (br_high & mask)
	    br_out |= br_table[i];
    }
    PDEBUG(3, "Writing whiteness %d", br_out);
    spca50x_reg_write(spca50x->dev, 0x0, 0x0d, br_out);
#else				/* SPCA50X_ENABLE_EXPERIMENTAL */
    return;
#endif				/* SPCA50X_ENABLE_EXPERIMENTAL */
}

/**********************************************************************
* autobrightness
* Function tries to control brightness
* Receives the pointer to camera descriptor and 
* target average luminance
***********************************************************************/
static inline void autobrightness(struct usb_spca50x *spca50x)
{
    __u8 cur_lum = 0;		//The current luminance
    __u8 brightness = 0;
    char br_set = 0;		//If the brightness should be set
    __u8 lum = spca50x->lum_level;	//The desired luminance level
    __u8 delta = lum >> 3;	//overshooting that we shouldn't care
#ifdef SPCA50X_ENABLE_EXPERIMENTAL
    __u8 whiteness = 0;		//whiteness level
    char wh_set = 0;		//If whiteness must be set
#endif				/* SPCA50X_ENABLE_EXPERIMENTAL */

    if (in_interrupt()) {
	PDEBUG(2, "In intr");
	return;
    }
    ////
    /*
     * This algorithm may be dangerous. We MUST be sure that the 
     * !spca50x->streaming will be set to 0 BEFORE kfree(spca50x)
     */
    ////
    if (!spca50x->streaming)	//No isoc
	return;
    cur_lum = get_avg_lum(spca50x);
    brightness = spca50x->brightness >> 8;
    if (cur_lum < (lum - delta)) {
	if (brightness < 255) {
	    brightness++;
	    br_set = 1;
	}
#ifdef SPCA50X_ENABLE_EXPERIMENTAL
	else {
	    whiteness = spca50x->whiteness >> 12;
	    if (whiteness < 15) {
		whiteness++;
		wh_set = 1;
	    }
	}
#endif				/* SPCA50X_ENABLE_EXPERIMENTAL */
    }
    if (cur_lum > (lum + delta) && brightness > 0) {
	brightness--;
	br_set = 1;
    }
#ifdef SPCA50X_ENABLE_EXPERIMENTAL
    if ((spca50x->nstable == NSTABLE_MAX ||
	 spca50x->nunstable == NUNSTABLE_MAX)
	&& brightness < MIN_BRIGHTNESS) {
	whiteness = spca50x->whiteness >> 12;
	if (whiteness > 0) {
	    whiteness--;
	    wh_set = 1;
	}
    }
    if (wh_set) {
	spca50x_set_whiteness(spca50x, whiteness << 4);
	spca50x->whiteness = whiteness << 12;
	spca50x->nstable = 0;
	spca50x->nunstable = 0;
	return;			//if we have set whiteness, we needn't care about brightness
    }
#endif				/* SPCA50X_ENABLE_EXPERIMENTAL */
    if (br_set) {
	// spca50x_set_brightness (spca50x, brightness);
	spca50x->brightness = brightness << 8;
#ifdef SPCA50X_ENABLE_EXPERIMENTAL
	if (spca50x->nunstable < NUNSTABLE_MAX)
	    spca50x->nunstable++;
	spca50x->nstable = 0;
#endif				/* SPCA50X_ENABLE_EXPERIMENTAL */
    }
#ifdef SPCA50X_ENABLE_EXPERIMENTAL
    else {
	if (spca50x->nstable < NSTABLE_MAX)
	    spca50x->nstable++;
	else
	    spca50x->nunstable = 0;
    }
#endif				/* SPCA50X_ENABLE_EXPERIMENTAL */
}

#endif				/* SPCA501_INIT_H */
//eof
