/***
 *** this is a simple program to drive the lines of the PIC programmer
 *** Not very important when the programmer works, just a nice
 *** debugging tool!
 ***/
#define EXTERN
#include "prog84.h"


void doSimple(name, bit, buf)
     const char *name;
     int bit;
     char *buf;
{
    int num = atoi(buf);
    lpb_write(&lpb, bit, num?1:0);
    printf("%s O%s\n", name, num?"N":"FF");
    lpb_flush(&lpb);
}

void jig()
{
  char buf[256];
  int bits, num;

  printf("\n*** simple jig mode. enter:\n"
         "  p0 or p1  to turn power off or on\n"
         "  m0 or m1  to set MCLR low or high\n"
	 "  c0 or c1  to set the clock input\n"
	 "  d0 or d1  to set the data input\n"
	 "  r         to read the current clock & data sense lines\n"
         "  d c       to clock c bits of d, lsb first\n"
	 "  .conf     to load configuration\n"
	 "  .read     to read program memory\n"
	 "  .next     to advance address\n"
	 "  .prog n   to program current cell with n\n"
	 );

  while(fgets(buf, 256, stdin)) {
    if(!*buf) break;

    if (!strncmp(buf,".read",5)) {
	printf("read 0x%04x\n", genericRead(4));
	continue;
    }
    if (!strncmp(buf,".next",5)) {
	pipeBits(6,6);
	continue;
    }
    if (!strncmp(buf,".conf",5)) {
	genericWrite(0, 0); /* load prog. mem */
	printf("read 0x%04x\n", genericRead(4));
	continue;
    }
    if (!strncmp(buf,".prog",5)) {
	int d;
	sscanf(buf+5,"%i", &d);
	genericWrite(2, d); /* load prog. mem */
	pipeBits(8, 6);
	usleep(20000);
	continue;
    }
    if(*buf == 'p') { doSimple("power", p_power, buf+1); continue; }
    if(*buf == 'm') { doSimple("mclr",  p_mclr,  buf+1); continue; }
    if(*buf == 'c') { doSimple("clock", p_clock, buf+1); continue; }
    if(*buf == 'd') { doSimple("data",  p_data,  buf+1); continue; }
    if(*buf == 'r') {
	lpb_refresh(&lpb);
	printf("clock=%d data=%d\n", GET(clock_f), GET(data_f));
	continue;
    }

    if(sscanf(buf, "%i %d", &bits, &num) != 2) {
	printf("?\n");
	continue;
    }

    if(bits & ~((1<<num)-1)) {
	printf("extraneous bits!\n");
	continue;
    }

    printf("0x%04x (%d bits) => 0x%04x\n", bits, num, pipeBits(bits, num));
  }
}

int main()
{
    verbose = 1;
    progSetup();
    jig();
    progShutdown();
    return 0;
}
