; constants

W	equ	0
F	equ	1

ldc     macro   ; ldc constant, file -- load a constant into a reg.
        movlw   \1
        movwf   \2  
        endm
    
loop    macro   ; loop file, target
        decfsz \1, F
        goto \2
        endm 

; master

Nbit        equ   0x08        ; Total bits per frame
Npin         equ   0x08       ; numero di piedini  
tramaX    equ     B'01110000'  ; basic frame

; slave
;
;
TastoV       equ   0x0
DISPLAY1     equ   0x1
DISPLAY2     equ   0x2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Pagina 00
INDIR	equ	0x00
FSR	equ	0x04
PCL     equ     0x02
PORTB   equ     0x06 
PORTA   equ     0x05
RP0bit  equ     0x05   
RTIFbit equ     0x02
Cbit    equ     0x00
Zbit    equ     0x02
INTCON  equ     0x0B
STATUS  equ     0x03 
RTCC    equ     0x01

;;;;; Master
tramaShift  equ   0x10
tramaReale  equ   0x11
CCripbit    equ   0x12
CCbit       equ   0x13
ClrBPin     equ   0x14        ; Indica il BIT ZERO sul piedino i-esimo
SetBPin     equ   0x15        ; Indica il BIT UNO sul piedino i-esimo

;;;;; Slave

;--- page 1 registers -- set STATUS, RP0
TRISA   equ     0x05   
TRISB   equ     0x06
OPTION_REG  equ     0x01
