/* 
 * sessions.h -- header file for session handling routines (rmdpd)
 *
 * This file is part of
 *
 * rmdp -- Reliable Multicast data Distribution Protocol
 * 
 * (C) 1996-1998 Luigi Rizzo and Lorenzo Vicisano
 *     (luigi@iet.unipi.it, vicisano@cs.ucl.ac.uk)
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Luigi Rizzo,
 *      Lorenzo Vicisano and other contributors.
 * 4. Neither the name of the Authors nor the names of other contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#ifndef RMDP__SESSIONS_H
#define RMDP__SESSIONS_H

/* #include <sys/time.h> */
#include "rmdp.h"
#include <assert.h>

#define SESSION struct session
SESSION {
    SESSION *next;		/* link field */
    ui32 busy;			/* there is a pending delete */
    ui32 id;			/* session id. no need for order */

    ui32 c_id;			/* client id */
    ui32 r_id;			/* request id */

    ui32 ip;			/* transmitting ip addr. (net order) */
    ui16 port;			/* transmitting port # (net order) */
    int ch;			/* transmitting channel */
    int ttl;

    ui32 rate;			/* tx rate, actually period in usec. */
    ui32 curr_rate;		/* current tx rate */

    ui32 idx;			/* next pkt. to transmit */
    ui32 pkts_left;		/* packets left to transmit */

    void ***alldata;			/* all plain data packets */
    char *fname;
    ui32 flength;
    ui16	flags;	/* various flags, net order */
    int B;
    int k;
    int n;
    struct timeval flush_at, delete_at;
};

extern SESSION *all_sessions;

void schedule(char *path, ui32 c_id, ui32 r_id,
	ui32 *this_sched, ui32 *this_sess_id,
	ui32 *addr, ui16 *port);
int se_start(SESSION *s, int set_pkts_left);
int se_delete(SESSION *s);
int se_send(SESSION *s);
void prolong(n32 s_id);

#endif  /* RMDP__SESSIONS_H */
