/* GATES, a small LCARS 24 parody of Windowing GUIs */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "gates.h"


void GatesDisplayBmp(int x, int y, char *filespec)
{
	BITMAP *the_image;
	PALETTE the_palette;
	int width=706;
	int height=500;

	the_image=load_bitmap(filespec, the_palette);
	if (!the_image) return;
	if(DepthFound > 8) set_palette(the_palette);
	masked_blit(the_image, screen, 0, 0, x, y, the_image->w, the_image->h);
	destroy_bitmap(the_image);
}
void GatesWallpaper(char *filespec)
{
	BITMAP *the_image;
	PALETTE the_palette;
	int width=706;
	int height=500;

	the_image=load_jpeg(filespec, the_palette);
	if (!the_image) return;

	if(DepthFound > 8) set_palette(the_palette);
	if(the_image->w <= 706 && the_image->h <= 500) {
		blit(the_image, screen, 0, 0, (800-the_image->w)/2, (600-the_image->h)/2, the_image->w, the_image->h);
	} else {
/* One dimension may be too great but not the other. */
/*	 if(the_image->w < width) width=the_image->w;  */
		if(the_image->h < height) height=the_image->h;
		blit(the_image, screen, 0, 201, 47, 50, the_image->w, height);
	}
	rectfill(screen,0,0,200,570, makecol(206,235,255));

	destroy_bitmap(the_image);
}
void GatesApp(char *filespec)
{
	BITMAP *the_image;
	PALETTE the_palette;
	int width=706;
	int height=500;

	the_image=load_jpeg(filespec, the_palette);
	if (!the_image) return;

	if(DepthFound > 8) set_palette(the_palette);
	width=the_image->w;
	height=the_image->h;
	blit(the_image, screen, 0, 0, 790-width, 120, width, height);
	destroy_bitmap(the_image);
}

void GatesTaskbar()
{
	int l=633;
	int r=796;
	int t=576;
	int b=597;

	rectfill(screen,0,572,800,600,GATESGRAY);
	hline(screen,0,573,800,GATESHIGHLIGHT);
	hline(screen,0,600,800,GATESSHADOW);
/* clock section */
	hline(screen,l,t,r-1,GATESSHADOW);	 /* top	 */
	hline(screen,l,b,r,GATESHIGHLIGHT);  /* bottom */
	vline(screen,l,t+1,b,GATESSHADOW); /* left	*/
	vline(screen,r,t+2,b,GATESHIGHLIGHT);  /* right  */
	GatesDisplayBmp(l+6, t+4, "C:\\LCARS24\\LC24APPS\\GATES\\ICON7.BMP");
}
void GatesPopup(int x, int y, int w, int h, char *Str1, char *Str2)
{
	rectfill(screen,x,y,x+w-1,y+h-2,GATESGRAY);
	hline(screen,x+1,y+1,x+w-2,GATESHIGHLIGHT);  /* top highlight */
	vline(screen,x+1,y+1,y+h-2,GATESHIGHLIGHT); /* left highlight */

	vline(screen,x+w-1,y+1,y+h-2,GATESSHADOW); /* right shadow */
	vline(screen,x+w,y,y+h,BLACK); /* right shadow */
	hline(screen,x+1,y+h-1,x+w-1,GATESSHADOW);  /* bottom shadow */
	hline(screen,x,y+h,x+w,BLACK);  /* bottom bottom shadow */

	PutsArial10(screen,x+(w-StrLenArial10(Str1))/2,(y+(h/2)-8)-2, BLACK, Str1);
	PutsArial10(screen,x+(w-StrLenArial10(Str2))/2,(y+(h/2)+8)-2, BLACK, Str2);
	PutsArial10(screen,x+1+(w-StrLenArial10(Str2))/2,(y+(h/2)+8)-2, BLACK, Str2);


	hline(screen,x+4,(y+(h/2)-18)-2,x+w-4,GATESSHADOW);
	hline(screen,x+4,1+(y+(h/2)-18)-2,x+w-4,GATESHIGHLIGHT);
	hline(screen,x+4,(y+(h/2)+24)-2,x+w-4,GATESSHADOW);
	hline(screen,x+4,1+(y+(h/2)+24)-2,x+w-4,GATESHIGHLIGHT);

}
void GatesDocked(int x, int y, char *Label)
{
	int w=121;
	int h=23;

	rectfill(screen,x,y,x+w-1,y+h-2,GATESGRAY);
	hline(screen,x+1,y+1,x+w-2,GATESHIGHLIGHT);  /* top highlight */
	vline(screen,x+1,y+1,y+h-2,GATESHIGHLIGHT); /* left highlight */

	vline(screen,x+w-1,y+1,y+h-2,GATESSHADOW); /* right shadow */
	vline(screen,x+w,y,y+h,BLACK); /* right shadow */
	hline(screen,x+1,y+h-1,x+w-1,GATESSHADOW);  /* bottom shadow */
	hline(screen,x,y+h,x+w,BLACK);  /* bottom bottom shadow */

	PutsArial10(screen,x+(w-StrLenArial10(Label))/2,y+7, BLACK, Label);
}
void GatesStartButton()
{
	int x=2;
	int y=575;
	int w=59+12;
	int h=23;

	rectfill(screen,x,y,x+w-1,y+h-2,GATESGRAY);
	hline(screen,x+1,y+1,x+w-2,GATESHIGHLIGHT);  /* top highlight */
	vline(screen,x+1,y+1,y+h-2,GATESHIGHLIGHT); /* left highlight */

	vline(screen,x+w-1,y+1,y+h-2,GATESSHADOW); /* right shadow */
	vline(screen,x+w,y,y+h,BLACK); /* right shadow */
	hline(screen,x+1,y+h-1,x+w-1,GATESSHADOW);  /* bottom shadow */
	hline(screen,x,y+h,x+w,BLACK);  /* bottom bottom shadow */

	rectfill(screen,x+6,y+6,x+10,y+h-6,makecol(145,87,0));
	rectfill(screen,x+13,y+6,x+17,y+h-6,makecol(145,87,0));

	PutsArial10(screen,10+x+(w-StrLenArial10("Start"))/2,y+7, BLACK, "Start");
	PutsArial10(screen,11+x+(w-StrLenArial10("Start"))/2,y+7, BLACK, "Start");
}
void GatesMenuButton(int x, int y, char *Label)
{
	int w=59+12;
	int h=23;

	rectfill(screen,x,y,x+w-1,y+h-2,GATESGRAY);
	hline(screen,x+1,y+1,x+w-2,GATESHIGHLIGHT);  /* top highlight */
	vline(screen,x+1,y+1,y+h-2,GATESHIGHLIGHT); /* left highlight */

	vline(screen,x+w-1,y+1,y+h-2,GATESSHADOW); /* right shadow */
	vline(screen,x+w,y,y+h,BLACK); /* right shadow */
	hline(screen,x+1,y+h-1,x+w-1,GATESSHADOW);  /* bottom shadow */
	hline(screen,x,y+h,x+w,BLACK);  /* bottom bottom shadow */


	PutsArial10(screen,x+(w-StrLenArial10(Label))/2,y+7, BLACK, Label);
	PutsArial10(screen,1+x+(w-StrLenArial10(Label))/2,y+7, BLACK, Label);
}
void GatesDisplayIcon(int x, int y, char *filespec, char *label)
{
	int LabelLen;

	LabelLen=StrLenArial10(label);
	GatesDisplayBmp(x, y, filespec);
	rectfill(screen,x,y+52,x+LabelLen+10,y+55+13,BLACK);
	PutsArial10(screen,x+5,y+55, WHITE, label);
}
void GatesIcons()
{
	GatesDisplayIcon(16, 10, "C:\\LCARS24\\LC24APPS\\GATES\\SM1.BMP","My machinations");
	GatesDisplayIcon(16, 80, "C:\\LCARS24\\LC24APPS\\GATES\\SM2.BMP","Spam generator");
	GatesDisplayIcon(16, 150, "C:\\LCARS24\\LC24APPS\\GATES\\SM3.BMP","Error log");
	GatesDisplayIcon(16, 220, "C:\\LCARS24\\LC24APPS\\GATES\\SM4.BMP","Online shopping");
	GatesDisplayIcon(16, 290, "C:\\LCARS24\\LC24APPS\\GATES\\SM5.BMP","Vote rigging");
	GatesDisplayIcon(16, 360, "C:\\LCARS24\\LC24APPS\\GATES\\SM6.BMP","Missing dlls");
	GatesDisplayIcon(16, 430, "C:\\LCARS24\\LC24APPS\\GATES\\SM7.BMP","Gates downgrade");
	GatesDisplayIcon(16, 500, "C:\\LCARS24\\LC24APPS\\GATES\\SM8.BMP","Fractured files");

	GatesDisplayIcon(132, 10, "C:\\LCARS24\\LC24APPS\\GATES\\SM9.BMP","My jottings");
	GatesDisplayIcon(132, 80, "C:\\LCARS24\\LC24APPS\\GATES\\SM10.BMP","Acid Brain ver. 1.6O7b");
	GatesDisplayIcon(132, 150, "C:\\LCARS24\\LC24APPS\\GATES\\SM11.BMP","Lost files");
	GatesDisplayIcon(132, 220, "C:\\LCARS24\\LC24APPS\\GATES\\SM12.BMP","Gates Bullhorn beta");
}
void MakeGray()
{
	int x,y;
	int r,g,b,av;
	int ImageCol;

	grayscreen = create_bitmap(800,571);

	for(y=0; y <571; ++y) {
		for(x=0; x <800; ++x) {
			ImageCol = getpixel(screen,x,y);
			r=getr(ImageCol);
			g=getg(ImageCol);
			b=getb(ImageCol);
			av=(r+g+b)/3;
			putpixel(grayscreen,x,y,makecol(av,av,av));
		}
	}
}
void MakeSnow(int color)
{
	int x,y;
	int r,g,b,av;
	int ImageCol;
	int Alt=1;

	grayscreen = create_bitmap(800,571);

	for(y=0; y <571; ++y) {
		for(x=0; x <800; ++x) {
			ImageCol = getpixel(screen,x,y);
			if(Alt==1) putpixel(grayscreen,x,y,ImageCol);
				else putpixel(grayscreen,x,y,color);
		}
		Alt = !Alt;

	}
}
void GatesFreezeUp()
{
	sleep(1);
/* GatesApp("c:\\lcars24\\lc24apps\\gates\\word.jpg");
	sleep(4);
*/
	MakeGray();
	GatesPopup(450,200,200,100, "Error loading Gates event dll", "Press ESC");
	GatesDisplayBmp(458, 208, "C:\\LCARS24\\LC24APPS\\GATES\\ICON7.BMP");
	LcarsPlayWav("C:\\LCARS24\\LC24APPS\\GATES\\LC13.WAV");

loopback:
	do {
		GatesPutTime();

	} while (!kbhit());
	c=GetKey();
	switch( c )
	{
		case ESC:
			blit(grayscreen, screen, 0, 0, 0, 0, 800,571);
			GatesPopup(450,200,200,100, "Error loading Gates event dll", "Press ESC");
			GatesDisplayBmp(458, 208, "C:\\LCARS24\\LC24APPS\\GATES\\ICON7.BMP");
			GatesPopup(430,282,140,170, "System critical", "Press ENTER");
			GatesDisplayBmp(438, 290, "C:\\LCARS24\\LC24APPS\\GATES\\ICON8.BMP");
			GatesDocked(82+130+130,575, "Warning");
			GatesDocked(82+130+130,575, "Overload");
			sleep(1);
			return;
		case 350: Screenshot792("Gates8.bmp");
				goto loopback;
		case 351: Screenshot1024("Gates10.bmp");
				goto loopback;
		default:
			goto loopback;
	}

}
void GatesPopZoo()
{
			GatesPopup(450,200,200,100, "Error loading Gates event dll", "Press ESC");
			GatesDisplayBmp(458, 208, "C:\\LCARS24\\LC24APPS\\GATES\\ICON7.BMP");
			GatesPopup(430,282,140,170, "System critical", "Press ENTER");
			GatesDisplayBmp(438, 290, "C:\\LCARS24\\LC24APPS\\GATES\\ICON8.BMP");
			GatesPopup(300,250,300,150, "For $95, you may submit a bug report.", "Are you sure you want to shut down Gates?");
			PutsArial10(screen,320,290, BLACK, "Enrich Macroshaft!");
			PutsArial10(screen,321,290, BLACK, "Enrich Macroshaft!");
			GatesMenuButton(308,370, "Yes");
			GatesMenuButton(308+107,370, "No");
			GatesMenuButton(300+300-68-12,370, "Submit");

}

int GatesWindowActive()
{
	GATESGRAY=makecol(160,160,169);
	GATESHIGHLIGHT=makecol(207,207,209);
	GATESSHADOW=makecol(105,105,109);
	rectfill(screen,0,0,800,600, makecol(206,235,255));
	GatesWallpaper("C:\\LCARS24\\LC24APPS\\GATES\\SEVEN.JPG");
	LoadArial10();
	GatesTaskbar();
	GatesStartButton();
	GatesDocked(82,575, "Logjam");
	GatesDocked(82+130,575, "Error");
/*	sleep(1); */
	GatesIcons();
	GatesFreezeUp();

loopback:
	do {
		GatesPutTime();

	} while (!kbhit());
	c=GetKey();
	switch( c )
	{
		case 13:
			MakeSnow(BLACK);
			blit(grayscreen, screen, 0, 0, 0, 0, 800,571);
			GatesPopZoo();
/*			sleep(1); */
			GatesDocked(82+130+130+130,575, "Meltdown");
			MakeSnow(makecol(145,87,0));
			blit(grayscreen, screen, 0, 0, 0, 0, 800,571);
			GatesPopZoo();
			sleep(1);
			MakeSnow(makecol(116,0,0));
			blit(grayscreen, screen, 0, 0, 0, 0, 800,571);
			GatesPopZoo();
			GatesPopup(100+36,250+36,300,150, "For $95, you may submit a bug report.", "Are you sure you want to shut down Gates?");
			PutsArial10(screen,120+36,290+36, BLACK, "Enrich Macroshaft!");
			PutsArial10(screen,121+36,290+36, BLACK, "Enrich Macroshaft!");
			GatesMenuButton(108+36,370+36, "Yes");
			GatesMenuButton(108+107+36,370+36, "Maybe");
			GatesMenuButton(100+300-68-12+36,370+36, "Submit");
			sleep(2);
			rectfill(screen,0,0,800,600,makecol(0x00,0x00,0xff));
			PutsMono13(screen,260,260, WHITE, "Install Gates LXXXVI Recovery Disk No.1.");
			PutsMono13(screen,260,284, WHITE, "(Beta disk set in stores winter 2009)");
			sleep(2);
			return(0);
		case F10: return(0);
		case 350: Screenshot792("Gates.bmp");
				goto loopback;
		default:
			goto loopback;
	}
}
int GatesMode()
{
	int Result;

	min_old=70;
	Result = GatesWindowActive();
	destroy_bitmap(grayscreen);
	return(Result);
}

/* eof */

