/* Htmlproc, part 1 of the LCARS 24 Web-page renderer */

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#ifndef HTMLVIEW_H
#define HTMLVIEW_H

#define LC_PARAGRAPH 3
#define LC_DOUBLE_BREAK 4

#include "lcars24.h"
#include "lccolor.h"
#include "parts.h"
#include "getkey.h"
#include "headline.h"


char TagBuf[1024];
char TitleBuf[256];
char HeadlineStr[128];
char UrlStr[256];
int HeadX, TitleX, StyleX;
char GrabTitle;
char GrabStyle;
char LineBreak;
char ToTop;
char AcceptTab;
char ListItem;
int ImageWidth, ImageHeight;
int TextColor, LinkColor, VlinkColor, AlinkColor;
int TextHeight;
int BaseLeftMargin;
int LeftMargin;
BITMAP *workbuf;
BITMAP *backimage;
PALETTE the_palette;
char NoBackImage;
int OFFBLACK;
int HtmlNumLines;
char OlOn, UlOn;
int OrderedListNum;
int OrderedListEndingLine;
char DrawBullet;
char DrawImage;
char DrawOrderedListNum;
int TextColorHolder;
char HtmlUnderline;
int HtmlPx,HtmlPy,HtmlPd; /* for the arrow cursor */
char ReadOnly;
int BLUE;
int StrongBlue;
int HtmlLineNum;
char GlyphBuf[12];
int GlyphX;
int HtmlDisplayLine;
int HtmlGraphicY;
char HtmlTextOutput;
char stripping;
char ImageTag[1024];
char BodyTag[1024];
char TableTag[1024];
char ParseResult[100];
int linefill;
int rm;
char ItemLinebreak;
char Preformat;
char ColorStyle;
int TableColor;
int CellColor;
int LightGray;
char Headline;
int Endbuf;
int txty;
int prevtxty;
char Bold;
int WEB_GREEN, WEB_SILVER, WEB_GRAY, WEB_MAROON, WEB_RED, WEB_PURPLE;
int WEB_FUCHSIA, WEB_LIME, WEB_OLIVE, WEB_YELLOW, WEB_NAVY, WEB_BLUE;
int WEB_TEAL, WEB_AQUA;
int Cellspacing, Cellpadding, Cellnumber, Tablewidth, Cellwidth, CellRight;
int LastWidth;
char IgnoreLinebreak;
int DefaultLeftMargin;
char DisplayHtmlTags;
char ItalicsOn;

void WebScreenshot(char *filespec);
int ParseTagbuf(char *s, char *w);
int GetNamedColor(char *ColorName);
int hex2i(char *s); /* converts two-char hex string to 1-byte int value */
int ParseColorSpec(char *s);
void ProcessBodySpecs();
void ProcessTableSpecs();
void ProcessCellSpecs();
void HtmDefaultColors();


#endif


