/*	Convert.c, an embedded LCARS 24 applet to convert various units
	Intially, an excuse to make a panel Okudagram!
	Requires the accompanying roman.c, to handle Roman numerals
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "convert.h"

void Activate(int x, int y, int Color, char *Label)
{
	rectfill(screen,x+117,y,x+156,y+36,Color);
	PutsLuna(x+121,y+18,BLACK,Color,Label);
}
void Inactivate(int x, int y)
{
	rectfill(screen,x+117,y,x+156,y+36,BLACK);
}

void CellInput_Cursor(int Cell_x, int Cell_y, int CellNum, int DecimalPlace)
{
	int gx,gy;

	gx=316+6+(116*CellNum)-(Cell_x*8);
	if(DecimalPlace != 0 && Cell_x >= DecimalPlace) gx += 2;
	gy=554-(47*Cell_y)+27;
	UpArrowHead( gx, gy, MANGO);
}
void Postxy(int x, int y, char *Str)
{
	--x;
	rectfill(screen,230+(116*x),554-(47*y),338+(116*x),554-(47*y)+36+9,BLACK);
	PutsFont21(322+7+(116*x)-StrLenFont21(Str),554-(47*y)+2,MANGO,Str);
}
void OkudaFrame(int Hue)
{
/* left wrapper */
	NorthwestElbow(10+125,13,Hue);
	rectfill(screen,10,50,20,554-11-44,Hue);
	rectfill(screen,10,507,20,590,Hue);
	rectfill(screen,26,26,113,113,Hue);
	rectfill(screen,113,13,230-8,113,Hue);
	rectfill(screen,10,50,50,113,Hue);
	NorthwestCorner(21,114);

/* right wrapper */
	RightBumper36(MaxX-46,554,Hue); /* bottom-right roundoff */

	NortheastElbow(MaxX-10-125,13,Hue);
	rectfill(screen,MaxX-10,50,MaxX-20,554+18,Hue);
	rectfill(screen,MaxX-26,26,MaxX-113+8,113,Hue);
	rectfill(screen,MaxX-10,50,MaxX-50,113,Hue);
	NortheastCorner(MaxX-21,114);

/* four colored blocks at top center */
	rectfill(screen,230+116,13,230+224,113,InputColor);
	rectfill(screen,230,13,230+108,113,OutputColor);
	rectfill(screen,230+232,13,MaxX-230,113,BRICK);
	rectfill(screen,230+116+232,13,230+224+232,113,PURPLE);
	rectfill(screen,230+225+232,13,230+224+232+7,113,BLACK);
	vline(screen,230+224+232+8,13,113,MANGO); /* a patch */

/* bottom of frame */
	rectfill(screen,230,507,MaxX-230,590,Hue);
	rectfill(screen,MaxX-222,507,MaxX-10-18,590,Hue);	/********/
	rectfill(screen,MaxX-222,507,MaxX-10,554,Hue);
	rectfill(screen,230+225+232,507,230+224+232+7,590,BLACK);
	SoutheastCorner(MaxX-21,506);


/* bottom messages */

	PutsLuna(234,525,BLACK,MANGO,"MOVE POINTER: ");
	LeftArrowSymbol(44+270,525,BLACK);
	PutsLuna(44+270+18+2,525,BLACK,MANGO,"/");
	RightArrowSymbol(44+270+24+6,525,BLACK);

	PutsLuna(372+234-88,561,BLACK,MANGO,"JUMP: ");
	EnterSymbol(372+270-88,561,1,BLACK);

	PutsLuna(234,561,BLACK,MANGO,"VALUE +/- ");
	PutsLuna(289,561,BLACK,MANGO,"-: ");

	UpArrowSymbol(44+270, 561, BLACK);
	PutsLuna(44+270+18+2,561,BLACK,MANGO,"/");
	DownArrowSymbol(44+270+24+6, 561, BLACK);

	PutsLuna(230+120+232,561,BLACK,MANGO, "CLEAR: ESC");
}
void HeaderLable1(char *Str)
{
	rectfill(screen,230,113-18,230+108,113,OutputColor);
	PutsLuna(230+106-StrLenLuna(Str),113-18,BLACK,OutputColor,Str);
}
void HeaderLable2(char *Str)
{
	rectfill(screen,230+116,113-18,230+224,113,InputColor);
	PutsLuna(336+116-StrLenLuna(Str),113-18,BLACK,InputColor,Str);
}
void HeaderLable3(char *Str)
{
	rectfill(screen,230+116+116,113-18,230+224+116,113,BRICK);
	PutsLuna(336+232-StrLenLuna(Str),113-18,BLACK,BRICK,Str);
}
void HeaderLable4(char *Str)
{
	rectfill(screen,230+116+232,113-18,230+224+232,113,PURPLE);
	PutsLuna(336+348-StrLenLuna(Str),113-18,BLACK,PURPLE,Str);
}
void Erase(int y)
{
	rectfill(screen,230,554-(47*y),230+108+(116*3),554-(47*y)+36,BLACK);
}
void Erasexy(int x, int y)
{
	--x;
	rectfill(screen,230+(116*x),554-(47*y),230+108+(116*x),554-(47*y)+36,BLACK);
}
void F1Inactive()
{
	Inactivate(28, 554-(47*9));
	ButtonType2(28, 554-(47*9), PALEBLUE, LAVENDER, "HEXADECIMAL");
	F36_F(28+140-11, 554-(47*9)+1, SKYBLUE, BLACK);
	F36_1(28+140, 554+1-(47*9), SKYBLUE, BLACK);

	Erase(9);
	ButtonType1(230, 554-(47*9), OutputColor, "HEX");
	ButtonType1(230+116, 554-(47*9), InputColor, "DEC");
	ButtonType1(230+(116*2), 554-(47*9), BRICK, "WEB COLOR");
}
void F1Active()
{
	int PlaceVal = 1;
	int Cell_x = 1;
	int Cell_y = 9;
	int CellNum = 1; /* the input cell, hex or dec */
	char Dec[16] = "00";
	int HexVal = 0;
	char Hex[7] = "00";
	int DecCol;

	Activate(28, 554-(47*9), SKYBLUE, "F1");
	ButtonType2(28, 554-(47*9), PALEBLUE, SKYBLUE, "HEXADECIMAL");
	HeaderLable1("HEXADECIMAL");
	HeaderLable2("DECIMAL");
	HeaderLable3("WEB COLOR");
	HeaderLable4("");
	Erase(9);

loopback:
	itoa(HexVal,Hex,16);
	itoa(HexVal,Dec,10);

	Postxy(1,9,Hex);
	Postxy(2,9,Dec);
	if(DepthFound != 24) {
		DecCol=makecol( getb24(HexVal),getg24(HexVal),getr24(HexVal) );
	} else { 
		DecCol=makecol( getr24(HexVal),getg24(HexVal),getb24(HexVal) );
	}
	rectfill(screen,230+232,554-(47*9),MaxX-230,554-(47*9)+36,DecCol);
	CellInput_Cursor(Cell_x, Cell_y, CellNum,0);

silent:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
		switch( c )
		{
			case ESC: HexVal = 0;
					goto loopback;
			case 13: CellNum = !CellNum;
					Cell_x = 1;
					PlaceVal = 1;
					HexVal = 0;
					goto loopback;
			case LEFTARROW:
					if(CellNum == 1 && Cell_x < 8) {
						++Cell_x;
						PlaceVal = PlaceVal*10;
						goto loopback;
					}
					if(CellNum == 0 && Cell_x < 6) {
						++Cell_x;
						PlaceVal = PlaceVal*16;
						goto loopback;
					}
					goto silent;
			case RIGHTARROW:
					if(CellNum == 1 && Cell_x > 1) {
						--Cell_x;
						PlaceVal = PlaceVal/10;
						goto loopback;
					}
					if(CellNum == 0 && Cell_x > 1) {
						--Cell_x;
						PlaceVal = PlaceVal/16;
						goto loopback;
					}
					goto silent;
			case DOWNARROW:
	if(CellNum == 0 && Hex[strlen(Hex)-Cell_x] > 48) HexVal -= PlaceVal;
	if(CellNum == 1 && Dec[strlen(Dec)-Cell_x] > 48) HexVal -= PlaceVal;
					if( HexVal < 0 ) HexVal = 0;
					goto loopback;
			case UPARROW:
	if(CellNum == 0 && Hex[strlen(Hex)-Cell_x] != 102) HexVal += PlaceVal;
	if(CellNum == 1 && Dec[strlen(Dec)-Cell_x] < 57) HexVal += PlaceVal;
					if(HexVal > 0xFFFFFF) HexVal = 0xFFFFFF;
					goto loopback;
			case F1: goto loopback;
			case F2:
			case F3:
			case F4:
			case F5:
			case F6:
			case F7:
			case F8:
			case F11: return;
			case F12: return;
			case CTRL_F1: Screenshot792("Conv8.bmp");
				goto loopback;
			case CTRL_F2: Screenshot1024("Conv10.bmp");
				goto loopback;
			default: goto silent;
		}
}
void F2Inactive()
{
	Inactivate(28, 554-(47*8));
	ButtonType2(28, 554-(47*8), BRICK, MANGO, "LINEAR");
	F36_F(28+140-11, 554-(47*8)+1, BRICK, BLACK);
	F36_2(28+140, 554+1-(47*8), BRICK, BLACK);

	Erase(8);
	ButtonType1(230, 554-(47*8), OutputColor, "METERS");
	ButtonType1(230+116, 554-(47*8), InputColor, "INCHES");
	ButtonType1(230+(116*2), 554-(47*8), BRICK, "FEET");
	ButtonType1(230+(116*3), 554-(47*8), PURPLE, "MILES");
}
void F2Active()
{
	float PlaceVal = 1;
	int Cell_x = 4;
	int Cell_y = 8;
	int CellNum = 1;
	char Inch[16] = "00";
	float InchVal = 0;
	char Foot[16] = "00";
	float FootVal = 0;
	char Mile[16] = "00";
	float MileVal = 0;
	char Meter[16] = "00";
	float MeterVal = 0;

	Activate(28, 554-(47*8), SKYBLUE, "F2");
	ButtonType2(28, 554-(47*8), BRICK, SKYBLUE, "LINEAR");
	HeaderLable1("METERS");
	HeaderLable2("INCHES");
	HeaderLable3("FEET");
	HeaderLable4("MILES");

loopback:
	sprintf(Inch,"%.2f",InchVal);
	sprintf(Meter,"%.2f",MeterVal);
	sprintf(Foot,"%.2f",FootVal);
	sprintf(Mile,"%.2f",MileVal);

	Postxy(1,8,Meter);
	Postxy(2,8,Inch);
	Postxy(3,8,Foot);
	Postxy(4,8,Mile);
	CellInput_Cursor(Cell_x, Cell_y, CellNum,2);

silent:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
		switch( c )
		{
			case ESC: InchVal = 0;
					MeterVal = 0;
					FootVal = 0;
					MileVal = 0;
					goto loopback;
			case 13: ++CellNum;
					if( CellNum > 3) CellNum = 0;
					Cell_x = 4;
					PlaceVal = 1;
								 InchVal = 0;
					MeterVal = 0;
					FootVal = 0;
					MileVal = 0;
					goto loopback;
			case LEFTARROW: ++Cell_x;
					if(Cell_x ==3 ) ++Cell_x;
					PlaceVal = PlaceVal*10;
					if(CellNum == 0 && Cell_x > 8 ) {
						Cell_x = 8;
						PlaceVal = 10000;
					}
					if(CellNum == 1 && Cell_x > 9 ) {
						Cell_x = 9;
						PlaceVal = 100000;
					}
					if(CellNum == 2 && Cell_x > 8 ) {
						Cell_x = 8;
						PlaceVal = 10000;
					}
					if(CellNum == 3 && Cell_x > 5 ) {
						Cell_x = 5;
						PlaceVal = 10;
					}
					goto loopback;
			case RIGHTARROW: --Cell_x;
					if(Cell_x ==3) --Cell_x;
					PlaceVal = PlaceVal * .1;
					if( Cell_x < 1) {
						Cell_x = 1;
						PlaceVal = .01;
					}
					goto loopback;
			case DOWNARROW:
				if(CellNum == 0 && Cell_x > strlen(Meter) ) goto silent;
				if(CellNum == 1 && Cell_x > strlen(Inch) ) goto silent;
				if(CellNum == 2 && Cell_x > strlen(Foot) ) goto silent;
				if(CellNum == 3 && Cell_x > strlen(Mile) ) goto silent;
				if(CellNum == 0 && Meter[strlen(Meter)-Cell_x] != 48) {
					MeterVal -= PlaceVal;
					InchVal = MeterVal / 0.0254;
					FootVal = InchVal/12;
					MileVal = InchVal/63360;
					goto loopback;
				}
				if(CellNum == 1 && Inch[strlen(Inch)-Cell_x] != 48) {
					InchVal -= PlaceVal;
					MeterVal = InchVal * 0.0254;
					FootVal = InchVal/12;
					MileVal = InchVal/63360;
					goto loopback;
				}
				if(CellNum == 2 && Foot[strlen(Foot)-Cell_x] !=48) {
					FootVal -= PlaceVal;
					InchVal = FootVal * 12;
					MeterVal = InchVal * 0.0254;
					MileVal = InchVal/63360;
					goto loopback;
				}
				if(CellNum == 3 && Mile[strlen(Mile)-Cell_x] !=48) {
					MileVal -= PlaceVal;
					InchVal = MileVal * 63360;
					MeterVal = InchVal * 0.0254;
					FootVal = InchVal/12;
					goto loopback;
				}
				goto silent;
			case UPARROW:
				if(CellNum == 0 && Meter[strlen(Meter)-Cell_x] !=57) {
					MeterVal += PlaceVal;
					InchVal = MeterVal / 0.0254;
					FootVal = InchVal/12;
					MileVal = InchVal/63360;
					goto loopback;
				}
				if(CellNum == 1 && Inch[strlen(Inch)-Cell_x] !=57) {
					InchVal += PlaceVal;
					MeterVal = InchVal * 0.0254;
					FootVal = InchVal/12;
					MileVal = InchVal/63360;
					goto loopback;
				}
				if(CellNum == 2 && Foot[strlen(Foot)-Cell_x] !=57) {
					FootVal += PlaceVal;
					InchVal = FootVal * 12;
					MeterVal = InchVal * 0.0254;
					MileVal = InchVal/63360;
					goto loopback;
				}
				if(CellNum == 3 && Mile[strlen(Mile)-Cell_x] !=57) {
					MileVal += PlaceVal;
					InchVal = MileVal * 63360;
					MeterVal = InchVal * 0.0254;
					FootVal = InchVal/12;
					goto loopback;
				}
				goto silent;
			case F2: goto loopback;
			case F1:
			case F3:
			case F4:
			case F5:
			case F6:
			case F7:
			case F8:
			case F11: return;
			case F12: return;
			default: goto silent;
		}
}
void F3Inactive()
{
	Inactivate(28, 554-(47*7));
	ButtonType2(28, 554-(47*7), ORANGE, PALEBLUE, "TEMPERATURE");
	F36_F(28+140-11, 554-(47*7)+1, ORANGE, BLACK);
	F36_3(28+140, 554+1-(47*7), ORANGE, BLACK);

	Erase(7);
	ButtonType1(230, 554-(47*7), OutputColor, "CELSIUS");
	ButtonType1(230+116, 554-(47*7), InputColor, "FAHRENHEIT");
}
void F3Active()
{
	float PlaceVal = 1;
	int Cell_x = 4;
	int Cell_y = 7;
	int CellNum = 1;
	char Fahr[16] = "32.00";
	float FahrVal = 32;
	char Cels[16] = "0.00";
	float CelsVal = 0;

	Activate(28, 554-(47*7), SKYBLUE, "F3");
	ButtonType2(28, 554-(47*7), PURPLE, SKYBLUE, "TEMPERATURE");
	HeaderLable1("CELSIUS");
	HeaderLable2("FAHRENHEIT");
	HeaderLable3("");
	HeaderLable4("");

loopback:
	if(FahrVal < -459) {
		FahrVal = -460;
		strcpy(Fahr,"-459.67");
		strcpy(Cels,"-273.15");
	} else {
		sprintf(Fahr,"%.2f",FahrVal);
		sprintf(Cels,"%.2f",CelsVal);
	}

	Postxy(1,7,Cels);
	Postxy(2,7,Fahr);
	CellInput_Cursor(Cell_x, Cell_y, CellNum,2);

silent:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
		switch( c )
		{
			case ESC: FahrVal = 32;
					CelsVal = 0;
					goto loopback;
			case 13: CellNum = !CellNum;
					Cell_x = 4;
					PlaceVal = 1;
					FahrVal = 32;
					CelsVal = 0;
					goto loopback;
			case LEFTARROW: ++Cell_x;
					if(Cell_x ==3 ) ++Cell_x;
					PlaceVal = PlaceVal*10;
					if( Cell_x > 6 ) {
						Cell_x = 6;
						PlaceVal = 100;
					}
					goto loopback;
			case RIGHTARROW: --Cell_x;
					if(Cell_x ==3) --Cell_x;
					PlaceVal = PlaceVal * .1;
					if( Cell_x < 1) {
						Cell_x = 1;
						PlaceVal = .01;
					}
					goto loopback;
			case DOWNARROW:
				if(CellNum == 1 && Cell_x > strlen(Fahr) ) goto silent;
				if(CellNum == 0 && Cell_x > strlen(Cels) ) goto silent;
				if(CellNum == 1 /* && Fahr[strlen(Fahr)-Cell_x] != 48 */) {
					FahrVal -= PlaceVal;
					CelsVal = (FahrVal-32)/1.8;
					goto loopback;
				}
				if(CellNum == 0 /* && Cels[strlen(Cels)-Cell_x] != 48 */ ) {
					CelsVal -= PlaceVal;
					FahrVal = (CelsVal*1.8) + 32;
					goto loopback;
				}
				goto silent;
			case UPARROW:
				if(CellNum == 1 && Fahr[strlen(Fahr)-Cell_x] !=57) {
					FahrVal += PlaceVal;
					CelsVal = (FahrVal-32)/1.8;
					goto loopback;
				}
				if(CellNum == 0 && Cels[strlen(Cels)-Cell_x] !=57) {
					CelsVal += PlaceVal;
					FahrVal = (CelsVal*1.8) + 32;
					goto loopback;
				}
				goto silent;
			case F3: goto loopback;
			case F1:
			case F2:
			case F4:
			case F5:
			case F6:
			case F7:
			case F8:
			case F11: return;
			case F12: return;
			default: goto silent;
		}
}
void F4Inactive()
{
	Inactivate(28, 554-(47*6));
	ButtonType2(28, 554-(47*6), ORANGE, MANGO, "CURRENCY");
	F36_F(28+140-11, 554-(47*6)+1, SKYBLUE, BLACK);
	F36_4(28+140, 554+1-(47*6), SKYBLUE, BLACK);

	rectfill(screen,230,554-(47*6),MaxX-30,554-(47*6)+36,BLACK);
	ButtonType1(230, 554-(47*6), OutputColor, "NON-U.S.");
	ButtonType1(230+116, 554-(47*6), InputColor, "U.S. DOLLARS");
	ButtonType1(230+232, 554-(47*6), BRICK, "RATE");
}
void F4Active()
{
	float PlaceVal = 1;
	int Cell_x = 4;
	int Cell_y = 6;
	int CellNum = 2;
	char Dollar[16] = "00";
	float DollarVal = 0;
	char Foreign[16] = "00";
	float ForeignVal = 0;
	char Rate[16] = "01";
	float RateVal = 1;

	Activate(28, 554-(47*6), SKYBLUE, "F4");
	ButtonType2(28, 554-(47*6), PURPLE, SKYBLUE, "CURRENCY");
	HeaderLable1("NON-U.S.");
	HeaderLable2("U.S. DOLLARS");
	HeaderLable3("RATE");
	HeaderLable4("");

	PutsFont21(570,554-(47*6)+2,BRICK,"NON-U.S. = 1 U.S. DOLLAR");

loopback:

/* if(RateVal < 1) RateVal = 1; */
	if(DollarVal < 0) DollarVal = 0;
	ForeignVal = DollarVal * RateVal;
	sprintf(Foreign,"%.2f",ForeignVal);
	sprintf(Dollar,"%.2f",DollarVal);
	sprintf(Rate,"%.2f",RateVal);

	Postxy(1,6,Foreign);
	Postxy(2,6,Dollar);
	Postxy(3,6,Rate);
	CellInput_Cursor(Cell_x, Cell_y, CellNum,2);

silent:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
		switch( c )
		{
			case ESC: DollarVal = 0;
					ForeignVal = 0;
					RateVal = 0;
					goto loopback;
			case 13: ++CellNum;
					if( CellNum > 2) CellNum = 0;
					Cell_x = 4;
					PlaceVal = 1;
					DollarVal = 0;
					ForeignVal = 0;
					goto loopback;
			case LEFTARROW: ++Cell_x;
					if(Cell_x ==3 ) ++Cell_x;
					PlaceVal = PlaceVal*10;
					if(CellNum == 0 && Cell_x > 7 ) {
						Cell_x = 7;
						PlaceVal = 1000;
					}
					if(CellNum == 1 && Cell_x > 7 ) {
						Cell_x = 7;
						PlaceVal = 1000;
					}
					if(CellNum == 2 && Cell_x > 7 ) {
						Cell_x = 7;
						PlaceVal = 1000;
					}
					goto loopback;
			case RIGHTARROW: --Cell_x;
					if(Cell_x ==3) --Cell_x;
					PlaceVal = PlaceVal * .1;
					if( Cell_x < 1) {
						Cell_x = 1;
						PlaceVal = .01;
					}
					goto loopback;
			case DOWNARROW:
				if(CellNum == 0 && Cell_x > strlen(Foreign) ) goto silent;
				if(CellNum == 1 && Cell_x > strlen(Dollar) ) goto silent;
				if(CellNum == 2 && Cell_x > strlen(Rate) ) goto silent;
				if(CellNum == 0 && Foreign[strlen(Foreign)-Cell_x] != 48) {
					ForeignVal -= PlaceVal;
					DollarVal = ForeignVal / RateVal;
					goto loopback;
				}
				if(CellNum == 1 && Dollar[strlen(Dollar)-Cell_x] != 48) {
					DollarVal -= PlaceVal;
					ForeignVal = DollarVal * RateVal;
					goto loopback;
				}
				if(CellNum == 2 && Rate[strlen(Rate)-Cell_x] !=48) {
					RateVal -= PlaceVal;
					goto loopback;
				}
				goto silent;
			case UPARROW:
				if(CellNum == 0 && Foreign[strlen(Foreign)-Cell_x] !=57) {
					ForeignVal += PlaceVal;
					DollarVal = ForeignVal / RateVal;
					goto loopback;
				}
				if(CellNum == 1 && Dollar[strlen(Dollar)-Cell_x] !=57) {
					DollarVal += PlaceVal;
					ForeignVal = DollarVal * RateVal;
					goto loopback;
				}
				if(CellNum == 2 && Rate[strlen(Rate)-Cell_x] !=57) {
					RateVal += PlaceVal;
					goto loopback;
				}
				goto silent;
			case F4: goto loopback;
			case F1:
			case F2:
			case F3:
			case F5:
			case F6:
			case F7:
			case F8:
			case F11: return;
			case F12: return;
			default: goto silent;
		}
}
void F5Inactive()
{
	Inactivate(28, 554-(47*5));
	ButtonType2(28, 554-(47*5), ORANGE, BRICK, "FUEL ECONOMY");
	F36_F(28+140-11, 554-(47*5)+1, MANGO, BLACK);
	F36_5(28+140, 554+1-(47*5), MANGO, BLACK);

	Erase(5);
	ButtonType1(230, 554-(47*5), OutputColor, "KM/L");
	ButtonType1(230+116, 554-(47*5), InputColor, "MPG");
}
void F5Active()
{
	float PlaceVal = 1;
	int Cell_x = 4;
	int Cell_y = 5;
	int CellNum = 1;
	char Mpg[16] = "10";
	float MpgVal = 10;
	char Kpl[16] = "00";
	float KplVal = 0;

	Activate(28, 554-(47*5), SKYBLUE, "F5");
	ButtonType2(28, 554-(47*5), PURPLE, SKYBLUE, "FUEL ECONOMY");
	HeaderLable1("KM/L");
	HeaderLable2("MPG");
	HeaderLable3("");
	HeaderLable4("");

loopback:
	if(MpgVal < 0) MpgVal = 0;
	KplVal = MpgVal * .4246;
	sprintf(Mpg,"%.2f",MpgVal);
	sprintf(Kpl,"%.2f",KplVal);

	Postxy(1,5,Kpl);
	Postxy(2,5,Mpg);
	CellInput_Cursor(Cell_x, Cell_y, CellNum,2);

silent:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
		switch( c )
		{
			case ESC: MpgVal = 10;
					KplVal = 0;
					goto loopback;
			case 13: CellNum = !CellNum;
					Cell_x = 4;
					PlaceVal = 1;
					MpgVal = 10;
					KplVal = 0;
					goto loopback;
			case LEFTARROW: ++Cell_x;
					if(Cell_x ==3 ) ++Cell_x;
					PlaceVal = PlaceVal*10;
					if( Cell_x > 6 ) {
						Cell_x = 6;
						PlaceVal = 100;
					}
					goto loopback;
			case RIGHTARROW: --Cell_x;
					if(Cell_x ==3) --Cell_x;
					PlaceVal = PlaceVal * .1;
					if( Cell_x < 1) {
						Cell_x = 1;
						PlaceVal = .01;
					}
					goto loopback;
			case DOWNARROW:
				if(CellNum == 1 && Cell_x > strlen(Mpg) ) goto silent;
				if(CellNum == 0 && Cell_x > strlen(Kpl) ) goto silent;
				if(CellNum == 1 && Mpg[strlen(Mpg)-Cell_x] != 48) {
					MpgVal -= PlaceVal;
					KplVal = MpgVal * 0.4246;
					goto loopback;
				}
				if(CellNum == 0 && Kpl[strlen(Kpl)-Cell_x] != 48) {
					KplVal -= PlaceVal;
					MpgVal = KplVal / 0.4246;
					goto loopback;
				}
				goto silent;
			case UPARROW:
				if(CellNum == 1 && Mpg[strlen(Mpg)-Cell_x] !=57) {
					MpgVal += PlaceVal;
					KplVal = MpgVal * 0.4246;
					goto loopback;
				}
				if(CellNum == 0 && Kpl[strlen(Kpl)-Cell_x] !=57) {
					KplVal += PlaceVal;
					MpgVal = KplVal / 0.4246;
					goto loopback;
				}
				goto silent;
			case F5: goto loopback;
			case F1:
			case F2:
			case F3:
			case F4:
			case F6:
			case F7:
			case F8:
			case F11: return;
			case F12: return;
			default: goto silent;
		}
}
void F6Inactive()
{
	Inactivate(28, 554-(47*4));
	ButtonType2(28, 554-(47*4), PURPLE, ORANGE, "WEIGHT");
	F36_F(28+140-11, 554-(47*4)+1, SKYBLUE, BLACK);
	F36_6(28+140, 554+1-(47*4), SKYBLUE, BLACK);

	Erase(4);
	ButtonType1(230, 554-(47*4), OutputColor, "KILOGRAMS");
	ButtonType1(230+116, 554-(47*4), InputColor, "POUNDS");
	ButtonType1(230+232, 554-(47*4), BRICK, "TONS");
	ButtonType1(230+232+116, 554-(47*4), PURPLE, "METRIC TONS");
}
void F6Active()
{
	float PlaceVal = 1;
	int Cell_x = 4;
	int Cell_y = 4;
	int CellNum = 1;
	char Pound[16] = "0";
	float PoundVal = 0;
	char Kg[16] = "00";
	float KgVal = 0;
	char Ton[16] = "00";
	float TonVal = 0;
	char MetTon[16] = "00";
	float MetTonVal = 0;

	Activate(28, 554-(47*4), SKYBLUE, "F6");
	ButtonType2(28, 554-(47*4), PURPLE, SKYBLUE, "WEIGHT");
	HeaderLable1("KILOGRAMS");
	HeaderLable2("POUNDS");
	HeaderLable3("TONS");
	HeaderLable4("METRIC TONS");

loopback:
	if(PoundVal < 0) PoundVal = 0;
	KgVal = PoundVal * .4536;
	TonVal = PoundVal / 2000;
	MetTonVal = KgVal * .001;
	sprintf(Pound,"%.2f",PoundVal);
	sprintf(Kg,"%.2f",KgVal);
	sprintf(Ton,"%.2f",TonVal);
	sprintf(MetTon,"%.2f",MetTonVal);

	Postxy(1,4,Kg);
	Postxy(2,4,Pound);
	Postxy(3,4,Ton);
	Postxy(4,4,MetTon);
	CellInput_Cursor(Cell_x, Cell_y, CellNum,2);

silent:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
		switch( c )
		{
			case ESC: PoundVal = 0;
					KgVal = 0;
					TonVal = 0;
					MetTonVal = 0;
					goto loopback;
			case 13: ++CellNum;
					if( CellNum > 3) CellNum = 0;
					Cell_x = 4;
					PlaceVal = 1;
					PoundVal = 0;
					KgVal = 0;
					TonVal = 0;
					MetTonVal = 0;
					goto loopback;
			case LEFTARROW: ++Cell_x;
					if(Cell_x ==3 ) ++Cell_x;
					PlaceVal = PlaceVal*10;
					if(CellNum == 0 && Cell_x > 9 ) {
						Cell_x = 9;
						PlaceVal = 100000;
					}
					if(CellNum == 1 && Cell_x > 9 ) {
						Cell_x = 9;
						PlaceVal = 100000;
					}
					if(CellNum == 2 && Cell_x > 5 ) {
						Cell_x = 5;
						PlaceVal = 10;
					}
					if(CellNum == 3 && Cell_x > 5 ) {
						Cell_x = 5;
						PlaceVal = 10;
					}
					goto loopback;
			case RIGHTARROW: --Cell_x;
					if(Cell_x ==3) --Cell_x;
					PlaceVal = PlaceVal * .1;
					if( Cell_x < 1) {
						Cell_x = 1;
						PlaceVal = .01;
					}
					goto loopback;
			case DOWNARROW:
				if(CellNum == 0 && Cell_x > strlen(Kg) ) goto silent;
				if(CellNum == 1 && Cell_x > strlen(Pound) ) goto silent;
				if(CellNum == 2 && Cell_x > strlen(Ton) ) goto silent;
				if(CellNum == 3 && Cell_x > strlen(MetTon) ) goto silent;
				if(CellNum == 0 && Kg[strlen(Kg)-Cell_x] != 48) {
					KgVal -= PlaceVal;
					PoundVal = KgVal / .4536;
					goto loopback;
				}
				if(CellNum == 1 && Pound[strlen(Pound)-Cell_x] != 48) {
					PoundVal -= PlaceVal;
					KgVal = PoundVal * .4536;
					goto loopback;
				}
				if(CellNum == 2 && Ton[strlen(Ton)-Cell_x] !=48) {
					TonVal -= PlaceVal;
					PoundVal = TonVal * 2000;
					goto loopback;
				}
				if(CellNum == 3 && MetTon[strlen(MetTon)-Cell_x] !=48) {
					MetTonVal -= PlaceVal;
					PoundVal = MetTonVal * 2204.6;
					goto loopback;
				}
				goto silent;
			case UPARROW:
				if(CellNum == 0 && Kg[strlen(Kg)-Cell_x] !=57) {
					KgVal += PlaceVal;
					PoundVal = KgVal * 2.2046;
					goto loopback;
				}
				if(CellNum == 1 && Pound[strlen(Pound)-Cell_x] !=57) {
					PoundVal += PlaceVal;
					KgVal = PoundVal * .4536;
					goto loopback;
				}
				if(CellNum == 2 && Ton[strlen(Ton)-Cell_x] !=57) {
					TonVal += PlaceVal;
					PoundVal = TonVal * 2000;
					goto loopback;
				}
				if(CellNum == 3 && MetTon[strlen(MetTon)-Cell_x] !=57) {
					MetTonVal += PlaceVal;
					PoundVal = MetTonVal * 2204.6;
					goto loopback;
				}
				goto silent;
			case F6: goto loopback;
			case F1:
			case F2:
			case F3:
			case F4:
			case F5:
			case F7:
			case F8:
			case F11: return;
			case F12: return;
			default: goto silent;
		}
}
void F7Inactive()
{
	Inactivate(28, 554-(47*3));
	ButtonType2(28, 554-(47*3), BIGBLUE, PALEBLUE, "LAND");
	F36_F(28+140-11, 554-(47*3)+1, MANGO, BLACK);
	F36_7(28+140, 554+1-(47*3), MANGO, BLACK);

	Erase(3);
	ButtonType1(230, 554-(47*3), OutputColor, "HECTARES");
	ButtonType1(230+116, 554-(47*3), InputColor, "ACRES");
	ButtonType1(230+232, 554-(47*3), BRICK, "SQ. MILES");
}
void F7Active()
{
	float PlaceVal = 1;
	int Cell_x = 4;
	int Cell_y = 3;
	int CellNum = 1;
	char Acre[16] = "00";
	float AcreVal = 0;
	char Hectare[16] = "00";
	float HectareVal = 0;
	char Sqmile[16] = "00";
	float SqmileVal = 0;

	Activate(28, 554-(47*3), SKYBLUE, "F7");
	ButtonType2(28, 554-(47*3), PURPLE, SKYBLUE, "LAND");
	HeaderLable1("HECTARES");
	HeaderLable2("ACRES");
	HeaderLable3("SQUARE MILES");
	HeaderLable4("");

loopback:
	if(AcreVal < 0) AcreVal = 0;
	HectareVal = AcreVal * .4;
	SqmileVal = AcreVal/640;
	sprintf(Acre,"%.2f",AcreVal);
	sprintf(Hectare,"%.2f",HectareVal);
	sprintf(Sqmile,"%.2f",SqmileVal);

	Postxy(1,3,Hectare);
	Postxy(2,3,Acre);
	Postxy(3,3,Sqmile);
	CellInput_Cursor(Cell_x, Cell_y, CellNum,2);

silent:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
		switch( c )
		{
			case ESC: AcreVal = 0;
					HectareVal = 0;
					SqmileVal = 0;
					goto loopback;
			case 13: ++CellNum;
					if( CellNum > 2) CellNum = 0;
					Cell_x = 4;
					PlaceVal = 1;
					AcreVal = 0;
					HectareVal = 0;
					SqmileVal = 0;
					goto loopback;
			case LEFTARROW: ++Cell_x;
					if(Cell_x ==3 ) ++Cell_x;
					PlaceVal = PlaceVal*10;
					if(CellNum == 0 && Cell_x > 9 ) {
						Cell_x = 9;
						PlaceVal = 100000;
					}
					if(CellNum == 1 && Cell_x > 9 ) {
						Cell_x = 9;
						PlaceVal = 100000;
					}
					if(CellNum == 2 && Cell_x > 5 ) {
						Cell_x = 5;
						PlaceVal = 10;
					}
					goto loopback;
			case RIGHTARROW: --Cell_x;
					if(Cell_x ==3) --Cell_x;
					PlaceVal = PlaceVal * .1;
					if( Cell_x < 1) {
						Cell_x = 1;
						PlaceVal = .01;
					}
					goto loopback;
			case DOWNARROW:
				if(CellNum == 0 && Cell_x > strlen(Hectare) ) goto silent;
				if(CellNum == 1 && Cell_x > strlen(Acre) ) goto silent;
				if(CellNum == 2 && Cell_x > strlen(Sqmile) ) goto silent;
				if(CellNum == 0 && Hectare[strlen(Hectare)-Cell_x] != 48) {
					HectareVal -= PlaceVal;
					AcreVal = HectareVal / 0.4;
					goto loopback;
				}
				if(CellNum == 1 && Acre[strlen(Acre)-Cell_x] != 48) {
					AcreVal -= PlaceVal;
					HectareVal = AcreVal * 0.4;
					goto loopback;
				}
				if(CellNum == 2 && Sqmile[strlen(Sqmile)-Cell_x] !=48) {
					SqmileVal -= PlaceVal;
					AcreVal = SqmileVal * 640;
					goto loopback;
				}
				goto silent;
			case UPARROW:
				if(CellNum == 0 && Hectare[strlen(Hectare)-Cell_x] !=57) {
					HectareVal += PlaceVal;
					AcreVal = HectareVal / 0.4;
					goto loopback;
				}
				if(CellNum == 1 && Acre[strlen(Acre)-Cell_x] !=57) {
					AcreVal += PlaceVal;
					HectareVal = AcreVal * 0.4;
					goto loopback;
				}
				if(CellNum == 2 && Sqmile[strlen(Sqmile)-Cell_x] !=57) {
					SqmileVal += PlaceVal;
					AcreVal = SqmileVal * 640;
					goto loopback;
				}
				goto silent;
			case F7: goto loopback;
			case F1:
			case F2:
			case F3:
			case F4:
			case F5:
			case F6:
			case F8:
			case F11: return;
			case F12: return;
			default: goto silent;
		}
}
void F8Inactive()
{
	Inactivate(28, 554-(47*2));
	ButtonType2(28, 554-(47*2), MANGO, PURPLE, "CAPACITY");
	F36_F(28+140-11, 554-(47*2)+1, SKYBLUE, BLACK);
	F36_8(28+140, 554+1-(47*2), SKYBLUE, BLACK);

	Erase(2);
	ButtonType1(230, 554-(47*2), OutputColor, "LITERS");
	ButtonType1(230+116, 554-(47*2), InputColor, "QUARTS");
	ButtonType1(230+232, 554-(47*2), BRICK, "GALLONS");
}
void F8Active()
{
	float PlaceVal = 1;
	int Cell_x = 4;
	int Cell_y = 2;
	int CellNum = 1;
	char Liter[16] = "0";
	float LiterVal = 0;
	char Quart[16] = "00";
	float QuartVal = 0;
	char Gal[16] = "00";
	float GalVal = 0;

	Activate(28, 554-(47*2), SKYBLUE, "F8");
	ButtonType2(28, 554-(47*2), PURPLE, SKYBLUE, "CAPACITY");
	HeaderLable1("LITERS");
	HeaderLable2("QUARTS");
	HeaderLable3("GALLONS");
	HeaderLable4("");

loopback:
	if(QuartVal < 0) QuartVal = 0;
	LiterVal = QuartVal * 0.9462;
	GalVal = QuartVal * 0.25;
	sprintf(Quart,"%.2f",QuartVal);
	sprintf(Liter,"%.2f",LiterVal);
	sprintf(Gal,"%.2f",GalVal);

	Postxy(1,2,Liter);
	Postxy(2,2,Quart);
	Postxy(3,2,Gal);
	CellInput_Cursor(Cell_x, Cell_y, CellNum,2);

silent:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
		switch( c )
		{
			case ESC: QuartVal = 0;
					LiterVal = 0;
					GalVal = 0;
					goto loopback;
			case 13: ++CellNum;
					if( CellNum > 2) CellNum = 0;
					Cell_x = 4;
					PlaceVal = 1;
					QuartVal = 0;
					LiterVal = 0;
					GalVal = 0;
					goto loopback;
			case LEFTARROW: ++Cell_x;
					if(Cell_x ==3 ) ++Cell_x;
					PlaceVal = PlaceVal*10;
					if( Cell_x > 8 ) {
						Cell_x = 8;
						PlaceVal = 10000;
					}
					goto loopback;
			case RIGHTARROW: --Cell_x;
					if(Cell_x ==3) --Cell_x;
					PlaceVal = PlaceVal * .1;
					if( Cell_x < 1) {
						Cell_x = 1;
						PlaceVal = .01;
					}
					goto loopback;
			case DOWNARROW:
				if(CellNum == 0 && Cell_x > strlen(Liter) ) goto silent;
				if(CellNum == 1 && Cell_x > strlen(Quart) ) goto silent;
				if(CellNum == 2 && Cell_x > strlen(Gal) ) goto silent;
				if(CellNum == 0 && Liter[strlen(Liter)-Cell_x] != 48) {
					LiterVal -= PlaceVal;
					QuartVal = LiterVal / 0.9462;
					goto loopback;
				}
				if(CellNum == 1 && Quart[strlen(Quart)-Cell_x] != 48) {
					QuartVal -= PlaceVal;
					LiterVal = QuartVal * 0.9462;
					goto loopback;
				}
				if(CellNum == 2 && Gal[strlen(Gal)-Cell_x] !=48) {
					GalVal -= PlaceVal;
					QuartVal = GalVal * 4;
					goto loopback;
				}
				goto silent;
			case UPARROW:
				if(CellNum == 0 && Liter[strlen(Liter)-Cell_x] !=57) {
					LiterVal += PlaceVal;
					QuartVal = LiterVal / 0.9462;
					goto loopback;
				}
				if(CellNum == 1 && Quart[strlen(Quart)-Cell_x] !=57) {
					QuartVal += PlaceVal;
					LiterVal = QuartVal * 0.9462;
					goto loopback;
				}
				if(CellNum == 2 && Gal[strlen(Gal)-Cell_x] !=57) {
					GalVal += PlaceVal;
					QuartVal = GalVal * 4;
					goto loopback;
				}
				goto silent;
			case F8: goto loopback;
			case F1:
			case F2:
			case F3:
			case F4:
			case F5:
			case F6:
			case F7:
			case F11: return;
			case F12: return;
			default: goto silent;
		}
}
void P2F1Inactive()
{
	Inactivate(28, 554-(47*9));
	ButtonType2(28, 554-(47*9), ORANGE, BRICK, "VOLUME");
	F36_F(28+140-11, 554-(47*9)+1, SKYBLUE, BLACK);
	F36_1(28+140, 554+1-(47*9), SKYBLUE, BLACK);

	Erase(9);
	ButtonType1(230, 554-(47*9), OutputColor, "LITERS");
	ButtonType1(230+116, 554-(47*9), InputColor, "CUBIC INCHES");
}
void P2F1Active()
{
	float PlaceVal = 1;
	int Cell_x = 4;
	int Cell_y = 9;
	int CellNum = 1;
	char Lit[16] = "0.00";
	float LitVal = 0;
	char CuIn[16] = "0.00";
	float CuInVal = 0;

	Activate(28, 554-(47*9), SKYBLUE, "F1");
	ButtonType2(28, 554-(47*9), PURPLE, SKYBLUE, "VOLUME");
	HeaderLable1("LITERS");
	HeaderLable2("CUBIC INCHES");
	HeaderLable3("");
	HeaderLable4("");

loopback:
	if(LitVal < 0) LitVal = 0;
	LitVal = CuInVal*60.998;
	sprintf(Lit,"%.2f",LitVal);
	sprintf(CuIn,"%.2f",CuInVal);

	Postxy(1,9,CuIn);
	Postxy(2,9,Lit);
	CellInput_Cursor(Cell_x, Cell_y, CellNum,2);

silent:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
		switch( c )
		{
			case ESC: LitVal = 0;
					CuInVal = 0;
					goto loopback;
			case 13: CellNum = !CellNum;
					Cell_x = 4;
					PlaceVal = 1;
					LitVal = 0;
					CuInVal = 0;
					goto loopback;
			case LEFTARROW: ++Cell_x;
					if(Cell_x ==3 ) ++Cell_x;
					PlaceVal = PlaceVal*10;
					if( Cell_x > 7 ) {
						Cell_x = 7;
						PlaceVal = 1000;
					}
					goto loopback;
			case RIGHTARROW: --Cell_x;
					if(Cell_x ==3) --Cell_x;
					PlaceVal = PlaceVal * .1;
					if( Cell_x < 1) {
						Cell_x = 1;
						PlaceVal = .01;
					}
					goto loopback;
			case DOWNARROW:
				if(CellNum == 1 && Cell_x > strlen(Lit) ) goto silent;
				if(CellNum == 0 && Cell_x > strlen(CuIn) ) goto silent;
				if(CellNum == 1 && Lit[strlen(Lit)-Cell_x] != 48) {
					LitVal -= PlaceVal;
					CuInVal = LitVal / 60.998;
					goto loopback;
				}
				if(CellNum == 0 && CuIn[strlen(CuIn)-Cell_x] != 48) {
					CuInVal -= PlaceVal;
					LitVal = CuInVal * 60.998;
					goto loopback;
				}
				goto silent;
			case UPARROW:
				if(CellNum == 1 && Lit[strlen(Lit)-Cell_x] !=57) {
					LitVal += PlaceVal;
					CuInVal = LitVal / 60.998;
					goto loopback;
				}
				if(CellNum == 0 && CuIn[strlen(CuIn)-Cell_x] !=57) {
					CuInVal += PlaceVal;
					LitVal = CuInVal * 60.998;
					goto loopback;
				}
				goto silent;
			case F1: goto loopback;
			case F2:
			case F3:
			case F4:
			case F5:
			case F6:
			case F7:
			case F8:
			case F11: return;
			case F12: return;
			default: goto silent;
		}
}
void P2F2Inactive()
{
	Inactivate(28, 554-(47*8));
	ButtonType2(28, 554-(47*8), BIGBLUE, LAVENDER, "POWER");
	F36_F(28+140-11, 554-(47*8)+1, MANGO, BLACK);
	F36_2(28+140, 554+1-(47*8), MANGO, BLACK);

	Erase(8);
	ButtonType1(230, 554-(47*8), OutputColor, "KILOWATTS");
	ButtonType1(230+116, 554-(47*8), InputColor, "HORSEPOWER");
}
void P2F2Active()
{
	float PlaceVal = 1;
	int Cell_x = 4;
	int Cell_y = 8;
	int CellNum = 1;
	char Kw[16] = "0.00";
	float KwVal = 0;
	char Hp[16] = "0.00";
	float HpVal = 0;

	Activate(28, 554-(47*8), SKYBLUE, "F2");
	ButtonType2(28, 554-(47*8), PURPLE, SKYBLUE, "POWER");
	HeaderLable1("KILOWATTS");
	HeaderLable2("HORSEPOWER");
	HeaderLable3("");
	HeaderLable4("");

loopback:
	if(KwVal < 0) KwVal = 0;
	KwVal = HpVal / 0.7457;
	sprintf(Kw,"%.2f",KwVal);
	sprintf(Hp,"%.2f",HpVal);

	Postxy(1,8,Hp);
	Postxy(2,8,Kw);
	CellInput_Cursor(Cell_x, Cell_y, CellNum,2);

silent:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
		switch( c )
		{
			case ESC: KwVal = 0;
					HpVal = 0;
					goto loopback;
			case 13: CellNum = !CellNum;
					Cell_x = 4;
					PlaceVal = 1;
					KwVal = 0;
					HpVal = 0;
					goto loopback;
			case LEFTARROW: ++Cell_x;
					if(Cell_x ==3 ) ++Cell_x;
					PlaceVal = PlaceVal*10;
					if( Cell_x > 8 ) {
						Cell_x = 8;
						PlaceVal = 10000;
					}
					goto loopback;
			case RIGHTARROW: --Cell_x;
					if(Cell_x ==3) --Cell_x;
					PlaceVal = PlaceVal * .1;
					if( Cell_x < 1) {
						Cell_x = 1;
						PlaceVal = .01;
					}
					goto loopback;
			case DOWNARROW:
				if(CellNum == 1 && Cell_x > strlen(Kw) ) goto silent;
				if(CellNum == 0 && Cell_x > strlen(Hp) ) goto silent;
				if(CellNum == 1 && Kw[strlen(Kw)-Cell_x] != 48) {
					KwVal -= PlaceVal;
					HpVal = KwVal * 0.7457;
					goto loopback;
				}
				if(CellNum == 0 && Hp[strlen(Hp)-Cell_x] != 48) {
					HpVal -= PlaceVal;
					KwVal = HpVal / 0.7457;
					goto loopback;
				}
				goto silent;
			case UPARROW:
				if(CellNum == 1 && Kw[strlen(Kw)-Cell_x] !=57) {
					KwVal += PlaceVal;
					HpVal = KwVal * 0.7457;
					goto loopback;
				}
				if(CellNum == 0 && Hp[strlen(Hp)-Cell_x] !=57) {
					HpVal += PlaceVal;
					KwVal = HpVal / 0.7457;
					goto loopback;
				}
				goto silent;
			case F2: goto loopback;
			case F1:
			case F3:
			case F4:
			case F5:
			case F6:
			case F7:
			case F8:
			case F11: return;
			case F12: return;
			default: goto silent;
		}
}
void P2F3Inactive()
{
	Inactivate(28, 554-(47*7));
	ButtonType2(28, 554-(47*7), ORANGE, PURPLE, "INTERSTELLAR");
	F36_F(28+140-11, 554-(47*7)+1, ORANGE, BLACK);
	F36_3(28+140, 554+1-(47*7), ORANGE, BLACK);

	Erase(7);
	ButtonType1(230, 554-(47*7), OutputColor, "PARSECS");
	ButtonType1(230+116, 554-(47*7), InputColor, "LIGHT-YEARS");
}
void P2F3Active()
{
	float PlaceVal = 1;
	int Cell_x = 4;
	int Cell_y = 7;
	int CellNum = 1;
	char LtYr[16] = "0.00";
	float LtYrVal = 0;
	char Prsc[16] = "0.00";
	float PrscVal = 0;

	Activate(28, 554-(47*7), SKYBLUE, "F3");
	ButtonType2(28, 554-(47*7), PURPLE, SKYBLUE, "INTERSTELLAR");
	HeaderLable1("PARSECS");
	HeaderLable2("LIGHT-YEARS");
	HeaderLable3("");
	HeaderLable4("");

loopback:
	if(LtYrVal < 0) LtYrVal = 0;
	LtYrVal = PrscVal * 3.08571;
	sprintf(LtYr,"%.2f",LtYrVal);
	sprintf(Prsc,"%.2f",PrscVal);

	Postxy(1,7,Prsc);
	Postxy(2,7,LtYr);
	CellInput_Cursor(Cell_x, Cell_y, CellNum,2);

silent:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
		switch( c )
		{
			case ESC: LtYrVal = 0;
					PrscVal = 0;
					goto loopback;
			case 13: CellNum = !CellNum;
					Cell_x = 4;
					PlaceVal = 1;
					LtYrVal = 0;
					PrscVal = 0;
					goto loopback;
			case LEFTARROW: ++Cell_x;
					if(Cell_x ==3 ) ++Cell_x;
					PlaceVal = PlaceVal*10;
					if( Cell_x > 8 ) {
						Cell_x = 8;
						PlaceVal = 10000;
					}
					goto loopback;
			case RIGHTARROW: --Cell_x;
					if(Cell_x ==3) --Cell_x;
					PlaceVal = PlaceVal * .1;
					if( Cell_x < 1) {
						Cell_x = 1;
						PlaceVal = .01;
					}
					goto loopback;
			case DOWNARROW:
				if(CellNum == 1 && Cell_x > strlen(LtYr) ) goto silent;
				if(CellNum == 0 && Cell_x > strlen(Prsc) ) goto silent;
				if(CellNum == 1 && LtYr[strlen(LtYr)-Cell_x] != 48) {
					LtYrVal -= PlaceVal;
					PrscVal = LtYrVal / 3.08571;
					goto loopback;
				}
				if(CellNum == 0 && Prsc[strlen(Prsc)-Cell_x] != 48) {
					PrscVal -= PlaceVal;
					LtYrVal = PrscVal * 3.08571;
					goto loopback;
				}
				goto silent;
			case UPARROW:
				if(CellNum == 1 && LtYr[strlen(LtYr)-Cell_x] !=57) {
					LtYrVal += PlaceVal;
					PrscVal = LtYrVal / 3.08571;
					goto loopback;
				}
				if(CellNum == 0 && Prsc[strlen(Prsc)-Cell_x] !=57) {
					PrscVal += PlaceVal;
					LtYrVal = PrscVal * 3.08571;
					goto loopback;
				}
				goto silent;
			case F3: goto loopback;
			case F1:
			case F2:
			case F4:
			case F5:
			case F6:
			case F7:
			case F8:
			case F11: return;
			case F12: return;
			default: goto silent;
		}
}
void P2F4Inactive()
{
	Inactivate(28, 554-(47*6));
	rectfill(screen,185,554-(47*6),300,590-(47*6),BLACK);
	ButtonType2(28, 554-(47*6), PALEBLUE, ORANGE, "NUMERALS");
	F36_F(28+140-11, 554-(47*6)+1, NAPLES, BLACK);
	F36_4(28+140, 554+1-(47*6), NAPLES, BLACK);

	Erase(6);
	ButtonType1(230, 554-(47*6), OutputColor, "ROMAN");
	ButtonType1(230+116, 554-(47*6), InputColor, "ARABIC");
}
void P2F4Active()
{
	float PlaceVal = 1;
	int Cell_x = 1;
	int Cell_y = 6;
	int CellNum = 1;
	char Arabic[16] = "1";
	float ArabicVal = 1;
	char Roman[80] = "IIII";

	Activate(28, 554-(47*6), SKYBLUE, "F4");
	rectfill(screen,185,554-(47*6),300,590-(47*6),BLACK);
	ButtonType2Broken(28, 554-(47*6), PALEBLUE, SKYBLUE, "NUMERALS");
	HeaderLable1("ROMAN");
	HeaderLable2("ARABIC");
	HeaderLable3("");
	HeaderLable4("");

loopback:

	if(ArabicVal > 3999) ArabicVal -= 1000;
	itoa(ArabicVal,Arabic,10);
	itor(ArabicVal,Roman);

	rectfill(screen,185,554-(47*6),300,590-(47*6),BLACK);
	Postxy(1,6,Roman);
	Postxy(2,6,Arabic);
	CellInput_Cursor(Cell_x, Cell_y, CellNum,2);

silent:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
		switch( c )
		{
			case ESC: ArabicVal = 1;
					PlaceVal=1;
													 Cell_x = 1;
					goto loopback;
			case 13:	goto loopback;
			case LEFTARROW:
					if(Cell_x < 4) {
						++Cell_x;
						PlaceVal = PlaceVal*10;
						goto loopback;
					}
					goto silent;
			case RIGHTARROW:
					if(Cell_x > 1) {
						--Cell_x;
						PlaceVal = PlaceVal/10;
						goto loopback;
					}
					goto silent;
			case DOWNARROW:
					if(Arabic[strlen(Arabic)-Cell_x] > 48) ArabicVal -= PlaceVal;
					if( ArabicVal < 1 ) ArabicVal = 1;
					goto loopback;
			case UPARROW:
					if(Arabic[strlen(Arabic)-Cell_x] !=57) {
						ArabicVal += PlaceVal;
						goto loopback;
					}
					goto silent;
			case F4: 	goto loopback;
			case F1:
			case F2:
			case F3:
			case F5:
			case F6:
			case F7:
			case F8:
			case F11:	return;
			case F12:	return;
			default:	goto silent;
		}
}
void ClearWindow()
{
	rectfill(screen,28,128,MaxX-28,496,BLACK);
	rectfill(screen,28,507,226,543,BLACK);
	HeaderLable1("");
	HeaderLable2("");
	HeaderLable3("");
	HeaderLable4("");
}
int PageTwoWindowActive()
{
	ClearWindow();
	P2F1Inactive();
	P2F2Inactive();
	P2F3Inactive();
	P2F4Inactive();
	ButtonType3(28, 554-47, NAPLES, MANGO, "PREV PAGE");
	F36_F(28+140-24, 554-47+1, NAPLES, BLACK);
	F36_1(28+140-13, 554-47+1, NAPLES, BLACK);
	F36_1(28+140, 554-47+1, NAPLES, BLACK);

loopback:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
switchactive:
		switch( c )
		{
			case F1:  P2F1Active();
					P2F1Inactive();
					goto switchactive;
			case F2:  P2F2Active();
					P2F2Inactive();
					goto switchactive;
			case F3:  P2F3Active();
					P2F3Inactive();
					goto switchactive;
			case F4:  P2F4Active();
					P2F4Inactive();
					goto switchactive;
			case F5:
			case F6:
			case F7:
			case F8:  HeaderLable1("");
					HeaderLable2("");
					HeaderLable3("");
					HeaderLable4("");
					goto loopback;
			case F11:  return(1);
			case F12: return(0);
			default: goto loopback;
		}
	return(0);
}
int PageOneWindowActive()
{
	int Result;

refresh:
	F1Inactive();
	F2Inactive();
	F3Inactive();
	F4Inactive();
	F5Inactive();
	F6Inactive();
	F7Inactive();
	F8Inactive();
	ButtonType2(28, 554-47, NAPLES, MANGO, "NEXT PAGE");
	F36_F(28+140-24, 554-47+1, NAPLES, BLACK);
	F36_1(28+140-13, 554-47+1, NAPLES, BLACK);
	F36_1(28+140, 554-47+1, NAPLES, BLACK);

loopback:
	do {
		UpdateIdle();
	} while(!keypressed());
		c = GetKey();
switchactive:
		switch( c )
		{
			case F1:  F1Active();
					F1Inactive();
					goto switchactive;
			case F2:  F2Active();
					F2Inactive();
					goto switchactive;
			case F3:  F3Active();
					F3Inactive();
					goto switchactive;
			case F4:  F4Active();
					F4Inactive();
					goto switchactive;
			case F5:  F5Active();
					F5Inactive();
					goto switchactive;
			case F6:  F6Active();
					F6Inactive();
					goto switchactive;
			case F7:  F7Active();
					F7Inactive();
					goto switchactive;
			case F8:  F8Active();
					F8Inactive();
					goto switchactive;
			case F11:  Result=PageTwoWindowActive();
					if(Result == 1) {
						ClearWindow();
						goto refresh;
					}
					if(Result == 0) return(0);
			case F12: return(0);
			default: goto loopback;
		}
	return(0);
}
int ConversionMode()
{
	int Result;

	rectfill(screen,0,0,800,600,BLACK);

	MaxX=800;
	InputColor = ORANGE;
	OutputColor = PALEBLUE;
	OkudaFrame(MANGO);
	PutsLuna(230-12-StrLenLuna("UNIT CONVERSION SERVICE"),18,BLACK,MANGO,"UNIT CONVERSION SERVICE");
	PutsLuna(230-12-StrLenLuna("SELECT FUNCTION"),113-18,BLACK,MANGO,"SELECT FUNCTION");

	F1Inactive();
	F2Inactive();
	F3Inactive();
	F4Inactive();
	F5Inactive();
	F6Inactive();
	F7Inactive();
	F8Inactive();

	ButtonType2(28, 554-47, MANGO, PALEBLUE, "NEXT PAGE");
	F36_F(28+140-24, 554-47+1, BIGBLUE, BLACK);
	F36_1(28+140-13, 554-47+1, BIGBLUE, BLACK);
	F36_1(28+140, 554-47+1, BIGBLUE, BLACK);

	ButtonType3(28, 554, NAPLES, MANGO, "CLOSE");
	F36_F(28+140-24, 554+1, NAPLES, BLACK);
	F36_1(28+140-13, 554+1, NAPLES, BLACK);
	F36_2(28+140, 554+1, NAPLES, BLACK);

	++Font21[102]; /* gives the f for hex the same pitch as 0-e */
	Result = PageOneWindowActive();
	--Font21[102]; /* restore pitch of f to normal */
	return(Result);
}
/* eof */

