/* 12/20/09 */

/* Crossword server for LCARS 24
	Requires bitmapped pix and puzzle files
	Programmed 04/16/03
	Modified for FreeDOS32 08/18/03
	Bulletproofed for missing puzzle files, bmp file
	Code cleanup 10/31/03t
*/



#include "crosswrd.h"

void CwLoadPuzzleNum()
{
	PACKFILE *Fp;

	SetCurrentFile("\\LC24APPS\\CROSSWRD\\PUZZNUM.LC");
	if ( ( Fp=pack_fopen(CurrentFile, "rb" ))==NULL ) {
		return;
	} else{
		CwPuzzleNum=pack_getc(Fp);
	}
	pack_fclose( Fp );
}
void CwSavePuzzleNum()
{
	PACKFILE *Fp;

	SetCurrentFile("\\LC24APPS\\CROSSWRD\\PUZZNUM.LC");
	if ( ( Fp=pack_fopen(CurrentFile, "wb" ))==NULL ) {
		return;
	} else{
		if(CwCellsRemaining < 1) CwPuzzleNum++;
		if(CwPuzzleNum > NumOfFiles) CwPuzzleNum=0;
		pack_putc( CwPuzzleNum, Fp);
	}
	pack_fclose( Fp );
}


int CwGetRand(int d, int prev)
{
	int Result;

	srand( (unsigned int)time( NULL ) );
	Result = rand() % d;
	if( Result == prev ) ++ Result;
	if( Result > d-1 ) Result = 0;
	return(Result);
}
void CwDisplayFilename()
{
	rectfill(screen,160,1+12,548,39,LILAC);
	PutsLuna(160,20,BLACK,LILAC,MakeDisplayName(CurrentFile));
}
void CwCountCellsRemaining()
{
	int zx,zy;

	CwCellsRemaining=0;
	for( zy = 0; zy < 8; ++zy) {
		for( zx = 0; zx < 9; ++zx) {
			t=Ln[zy][zx];
			if(isupper(t)) CwCellsRemaining++;
		}
	}
}

/*
void CwSortFiles()
{
	char bag[16];
	int f;
	int r = 0;
	int done,ch;
	int z,i;

	for( z=0; z<NumOfFiles; ++z) {
		for( i=0; i<16; ++i) {
			ch=CommonFileArray[z][i];
			if( ch !=(null) ) ch=toupper(ch);
			CommonFileArray[z][i]=ch;
		}
	}
	do {
		done = TRUE;
		for (f=0; f<NumOfFiles; ++f) {
			r = strcmp(CommonFileArray[f],CommonFileArray[f+1]);
			if( r > 0 )  {
				strcpy(bag,CommonFileArray[f]);
				strcpy(CommonFileArray[f],CommonFileArray[f+1]);
				strcpy(CommonFileArray[f+1],bag);
				done = FALSE;
			}
		}
	} while ( done == FALSE );
}
*/
int CwMakeFileList()
{
	struct al_ffblk fblock;
	int Found;
	char mask[80];

	strcpy(mask, LcarsPath);
	strcat(mask, "\\LC24APPS\\CROSSWRD\\*.XWD");
	NumOfFiles = 0;
	Found = al_findfirst(mask, &fblock, FA_ARCH);
	if( Found ) {
		return(1);	 /* no puzzle files found */
	}
	while ( !Found ) {
		strcpy(CommonFileArray[NumOfFiles], fblock.name);
		Found = al_findnext( &fblock );
		++NumOfFiles;
	}
	--NumOfFiles;
	al_findclose( &fblock );
	return(0);
}

void CwDisplayPicture()
{
	int d;

	if(CwPixOK == FALSE) return;
	d = (CwImage->w)/66;
	CwBmpPos = CwGetRand(d,CwBmpPos);
	blit(CwImage, screen, CwBmpPos*66,0, UpLeftX+99,UpLeftY+99, 66,66);
}
void CwBlock(int bx, int by)
{
	int sx=UpLeftX;
	int sy=UpLeftY;

rectfill(screen,sx+(bx*33)+1,sy+(by*33)+1,sx+(bx*33)+32,sy+(by*33)+32,makecol(146,87,0));
}
void CwDrawPuzzleGrid(int Width, int Height)
{
	int z;

	for( z = 0; z <= Height; ++z) {
		line(screen,UpLeftX,UpLeftY+(z*33),UpLeftX+(Width*33),UpLeftY+(z*33),CwGridColor);
	}
	for( z = 0; z <= Width; ++z) {
		line(screen,UpLeftX+(z*33),UpLeftY,UpLeftX+(z*33),UpLeftY+(Height*33),CwGridColor);
	}
}
void CwFillPuzzGrid()
{
	PutsLuna(UpLeftX+2,UpLeftY+2, PALEBLUE, BLACK, "1");
	PutsLuna(UpLeftX+2+33,UpLeftY+2, PALEBLUE, BLACK, "2");
	PutsLuna(UpLeftX+2+66,UpLeftY+2, PALEBLUE, BLACK, "3");
	PutsLuna(UpLeftX+2+99,UpLeftY+2, PALEBLUE, BLACK, "4");

	PutsLuna(UpLeftX+2+132,UpLeftY+2, PALEBLUE, BLACK, "5");
	PutsLuna(UpLeftX+2+198,UpLeftY+2, PALEBLUE, BLACK, "6");
	PutsLuna(UpLeftX+2+231,UpLeftY+2, PALEBLUE, BLACK, "7");

	PutsLuna(UpLeftX+2,UpLeftY+2+33, PALEBLUE, BLACK, "8");
	PutsLuna(UpLeftX+2+198,UpLeftY+2+33, PALEBLUE, BLACK, "9");

	PutsLuna(UpLeftX+2+66,UpLeftY+2+66, PALEBLUE, BLACK, "10");
	PutsLuna(UpLeftX+2+165,UpLeftY+2+66, PALEBLUE, BLACK, "11");

	PutsLuna(UpLeftX+2,UpLeftY+2+99, PALEBLUE, BLACK, "12");
	PutsLuna(UpLeftX+2+33,UpLeftY+2+99, PALEBLUE, BLACK, "13");
	PutsLuna(UpLeftX+2+165,UpLeftY+2+99, PALEBLUE, BLACK, "14");

	PutsLuna(UpLeftX+2,UpLeftY+2+132, PALEBLUE, BLACK, "15");
	PutsLuna(UpLeftX+2+165,UpLeftY+2+132, PALEBLUE, BLACK, "16");

	PutsLuna(UpLeftX+2,UpLeftY+2+165, PALEBLUE, BLACK, "17");
	PutsLuna(UpLeftX+2+99,UpLeftY+2+165, PALEBLUE, BLACK, "18");
	PutsLuna(UpLeftX+2+132,UpLeftY+2+165, PALEBLUE, BLACK, "19");

	PutsLuna(UpLeftX+2,UpLeftY+2+198, PALEBLUE, BLACK, "20");
	PutsLuna(UpLeftX+2+99,UpLeftY+2+198, PALEBLUE, BLACK, "21");

	PutsLuna(UpLeftX+2+198,UpLeftY+2+198, PALEBLUE, BLACK, "22");
	PutsLuna(UpLeftX+2+231,UpLeftY+2+198, PALEBLUE, BLACK, "23");

	PutsLuna(UpLeftX+2,UpLeftY+2+231, PALEBLUE, BLACK, "24");
	PutsLuna(UpLeftX+2+99,UpLeftY+2+231, PALEBLUE, BLACK, "25");

	PutsLuna(UpLeftX,338, BRICK, BLACK, "ONLY CORRECT INPUT ACCEPTED");


	CwBlock(5,0);
	CwBlock(5,1);

	CwBlock(3,3);
	CwBlock(3,4);
	CwBlock(4,3);
	CwBlock(4,4);

	CwBlock(6,5);
	CwBlock(7,5);

	CwBlock(2,6);
	CwBlock(2,7);

	CwBlock(0,2);
	CwBlock(1,2);

}
void CwPutClues()
{
	int zy;

	PutsFont21(340,64,ORANGE,"ACROSS");
	PutsFont21(560,64,ORANGE,"DOWN");

	rectfill(screen,339,96,790,500,BLACK);
	for( zy = 0; zy < 14; ++zy) {
		PutsFont14(340,96+(zy*24), MANGO, BLACK, Ln[zy+8]);
	}
	for( zy = 0; zy < 14; ++zy) {
		PutsFont14(560,96+(zy*24), MANGO, BLACK, Ln[zy+22]);
	}
}
void CwFlush()
{
	int zx,zy;

	t=32;
	for( zy = 0; zy < 8; ++zy) {
		for( zx = 0; zx < 8; ++zx) {
			Puzzle[zy][zx] = (t);
		}
	}
}
void CwShowWIP()
{
	char OneLetter[2] ="A";
	int zx,zy;

	OneLetter[1] = 0;
	for( zy = 0; zy < 8; ++zy) {
		for( zx = 0; zx < 8; ++zx) {
			t= Ln[zy][zx];
			OneLetter[0] = (t);
			if(islower(OneLetter[0])) {
				OneLetter[0] = toupper((t));
				PutsFont21(UpLeftX+16+(zx*33),UpLeftY+6+(zy*33),ORANGE, OneLetter);
			}

		}
	}
}
void CwShowSolution(int Width, int Height)
{
	char OneLetter[2] ="A";
	int zx,zy;

	OneLetter[1] = 0;
	for( zy = 0; zy < Height; ++zy) {
		for( zx = 0; zx < Width; ++zx) {
			t= Ln[zy][zx];
			OneLetter[0] = (t);
			if(Puzzle[zy][zx] < 65) {
				OneLetter[0] = toupper((t));
				PutsFont21(UpLeftX+16+(zx*33),UpLeftY+6+(zy*33),NAPLES, OneLetter);
			}
		}
	}
	CwDisplayPicture();
}
void CwDrawAcrossCursor()
{
	int cx,cy;

	cx=UpLeftX+14+(CwX*33);
	cy=UpLeftY+28+(CwY*33);

	xor_mode(TRUE);
	rectfill(screen,cx-2, cy, cx+11, cy+2, WHITE);
	xor_mode(FALSE);
}
void CwDrawDownCursor()
{
	int cx,cy;

	cx=UpLeftX+26+(CwX*33);
	cy=UpLeftY+13+(CwY*33);

	xor_mode(TRUE);
	rectfill(screen,cx, cy-7, cx+2, cy+13, WHITE);
	xor_mode(FALSE);
}
void CwDrawCursor()
{
	if( CwDirection == 0) CwDrawAcrossCursor();
		else CwDrawDownCursor();
}
void CwCursorLeft()
{
	if(CwX == 2 && CwY == 2) return;
	--CwX;
	if(Ln[CwY][CwX] < 65) --CwX;
	if(Ln[CwY][CwX] < 65) --CwX;
	if(CwX < 0) CwX=0;
}
void CwCursorRight()
{
	if(CwX == 5 && CwY == 5) return;
	++CwX;
	if(Ln[CwY][CwX] < 65) ++CwX;
	if(Ln[CwY][CwX] < 65) ++CwX;
	if(CwX > 7) CwX=7;
}
void CwCursorUp()
{
	if(CwX == 5 && CwY == 2) return;
	--CwY;
	if(Ln[CwY][CwX] < 65) --CwY;
	if(Ln[CwY][CwX] < 65) --CwY;
	if(CwY < 0) CwY=0;
}
void CwCursorDown()
{
	if(CwX == 2 && CwY == 5) return;
	++CwY;
	if(Ln[CwY][CwX] < 65) ++CwY;
	if(Ln[CwY][CwX] < 65) ++CwY;
	if(CwY > 7) CwY=7;
}
void CwPutOneChar()
{
	char OneLetter[2] ="A";

	if( toupper(c) != Ln[CwY][CwX] ) return;
	t= Ln[CwY][CwX];
	OneLetter[0] = (t);
	PutsFont21(UpLeftX+16+(CwX*33),UpLeftY+6+(CwY*33),ORANGE, OneLetter);
	Puzzle[CwY][CwX] = (t);
	Ln[CwY][CwX] = tolower(c);
	CwCellsRemaining--;
	CwActivity++;
	if( CwDirection == 0 && Ln[CwY][CwX+1] > 32) CwCursorRight();
	if( CwDirection == 1 && Ln[CwY+1][CwX] > 32)  CwCursorDown();
}
void CwSwitch()
{
	if( CwDirection == 1) {
		ButtonType4(94, 367, BIGBLUE, "TYPE ACROSS", "ENTER", SEABLUE);
	} else {
		ButtonType4(94, 367, BIGBLUE, "TYPE DOWN", "ENTER", SEABLUE);
	}
	CwDisplayPicture();
}
int CwNewPuzzle()
{
	int Result;

	++CwPuzzleNum;
	CwActivity=0;
	CwCellsRemaining=52;
	if(CwPuzzleNum > NumOfFiles) CwPuzzleNum = 0;
	SetCurrentFile("\\LC24APPS\\CROSSWRD\\");
	strcat(CurrentFile, CommonFileArray[CwPuzzleNum]);

	CwDisplayFilename();
	Result = LoadTextFile();
	rectfill(screen,UpLeftX,UpLeftY,330,336,BLACK);
	rectfill(screen,330,UpLeftY,798,550,BLACK);

	SetCurrentFile("\\LC24APPS\\CROSSWRD\\PUZZ.WIP");
	if( exists(CurrentFile))
		remove(CurrentFile);
	return(Result);
}
void CwSaveGameInProgress()
{
	SetCurrentFile("\\LC24APPS\\CROSSWRD\\PUZZ.WIP");
	SaveTextFile();
}

int CwWindowActive(char IsWIP)
{
	if(IsWIP==TRUE) CwShowWIP();

NextPuzz:
	CwGridColor = LILAC;
	CwDrawPuzzleGrid(8,8);
	CwFillPuzzGrid();
	CwPutClues();
	CwX=0;
	CwY=0;
	CwDirection=0;
	CwFlush();
	CwSwitch();

loopback:
	CwDrawCursor();
	do {
		PePutTime(ORANGE);
	} while(!keypressed());
	c = GetKey();
	CwDrawCursor();
	switch( c )
		{
			case F12:	if(CwCellsRemaining >0 && CwActivity > 0) CwSaveGameInProgress();
					CwSavePuzzleNum();
					return(0);
			case 13: 	CwDirection = !CwDirection;
					CwSwitch();
					goto loopback;
			case F9: 	if( CwNewPuzzle() !=0) return(86);
					goto NextPuzz;
			case F10:	CwShowSolution(8,8);
					goto loopback;
			case 8:
			case LEFTARROW: CwCursorLeft();
					goto loopback;
			case 32:
			case RIGHTARROW: CwCursorRight();
					goto loopback;
			case PGUPKEY:
			case UPARROW: 	CwCursorUp();
					goto loopback;
			case PGDNKEY:
			case DOWNARROW: CwCursorDown();
					goto loopback;
			case CTRL_F1: Screenshot792("Cword8.bmp");
					goto loopback;
			case CTRL_F2: Screenshot1024("Cword10.bmp");
					goto loopback;
			default:  	CwPutOneChar();
					goto loopback;
		}
}
void CwScreen()
{
	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LILAC);
	PutsLuna(600,566, BLACK,LILAC, "CLOSE: F12");
	PutsLuna(160,566, BLACK,LILAC, "MOVE CURSOR: ARROW KEYS");

	ButtonType4(94, 414, LILAC, "NEXT PUZZLE", "F9", SEABLUE);
	ButtonType4(94, 461, BIGBLUE, "SOLUTION", "F10", SEABLUE);

	CwGridColor = LILAC;
	CwDrawPuzzleGrid(8,8);
	CwFillPuzzGrid();
	Title("CROSSWORD");

	PePutTime(ORANGE);

}
void CwInit()
{
	MaxX=799;
	MaxY=599;
	min_old=70;
	UpLeftX=41;
	UpLeftY=64;
	CwPuzzleNum=0;
	CwPixOK=TRUE;
	CwBmpPos=0;
	CwCellsRemaining=52;
	CwActivity=0;
}
int CrosswordMode()
{
	int Result;
	char IsWIP;

	IsWIP=FALSE;

	CwInit();
	CwScreen();

	if(CwMakeFileList()) {
		rest(100);
		NormalLoadError("\\LC24APPS\\CROSSWRD\\*.XWD");
		return(86);
	}
	CommonSortFiles();
	CwLoadPuzzleNum();

	SetCurrentFile("\\LC24APPS\\CROSSWRD\\PUZZ.WIP");
	if( exists(CurrentFile)) {
        	IsWIP=TRUE;
		LoadTextFile();
	}
	SetCurrentFile("\\LC24APPS\\CROSSWRD\\");
	strcat(CurrentFile, CommonFileArray[CwPuzzleNum]);
	if(IsWIP==FALSE) LoadTextFile();
	CwDisplayFilename();

	SetCurrentFile("\\LC24APPS\\CROSSWRD\\PUZZLES.BMP");
	if( ! exists(CurrentFile) ) {
		CwPixOK = FALSE;
		goto skip_bitmap;
	}

	CwImage = load_bitmap(CurrentFile, CwPalette);
	if (!CwImage) CwPixOK = FALSE;
		else set_palette(CwPalette);
skip_bitmap:
	Result = CwWindowActive(IsWIP);
	if(CwPixOK == TRUE) destroy_bitmap(CwImage);
	return(Result);
}
/* eof */

