/*	 Errmsg (error messages), to generate LCARS-style warnings
	about missing critical files
	* For anything other than a font file:
		NormalLoadError(char *Str)
	* In the case of a font file, use this one:
		FontLoadError(char *Str) (doesn't require loaded fonts)
	* If the sound card as a problem,
	  AudioError()

*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "errmsg.h"

int GetShutDownTicks()
{
	LCARSTIME now;
	int result=0;

	now=GetTimeStr();
	if (old_sec != now.Seconds) result=1;
	old_sec=now.Seconds;
	return(result);
}
void AutoShutdown(char *str, int lockout)
{
	int x,x2, Seconds;
	char SecStr[3];

	Seconds=30;
	BITMAP *bmp=create_bitmap(800,600);
	clear_bitmap(bmp);
	blit(screen, bmp, 0, 0, 0, 0, 800, 600);
	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(LILAC);
	Title("LCARS SHUTDOWN");
	x=(800-StrLenMars(3,"LCARS SHUTDOWN"))/2;
	PutsScorpio(x,100,LILAC,str);
	MarsF(x, 162, 3, RED, BLACK, "LCARS SHUTDOWN");
	PutsFont19(x,262,SEABLUE,"IN PROGRESS");
	PutsScorpio(x,292,ORANGE,"SECONDS REMAINING:");
	x2=x+StrLenMars(3,"LCARS SHUTDOWN");
	MarsF(x2-StrLenMars(2,"30"),262,2,ORANGE,BLACK,"30");
	ButtonType2(x, 353, PALEBLUE, BRICK, "QUICK EXIT");
	F36_F(x+116, 353, SEABLUE, BLACK);
	F36_1(x+127, 353, SEABLUE, BLACK);
	F36_2(x+140, 353, SEABLUE, BLACK);
	if( ! lockout) {
		ButtonType3(x, 400, LILAC, LILAC, "CANCEL");
		EscSymbol(x+117, 400, 2, ORANGE);
	}
	PanelBeep();
	x=x2-StrLenMars(2,"30");

loopback:
	do {
		if( GetShutDownTicks() ) {
			Seconds--;
			itoa(Seconds,SecStr,10);
			if(Seconds == 9) rectfill(screen,x,262,x2,318,BLACK);
			MarsF(x2-StrLenMars(2,SecStr),262,2,ORANGE,BLACK,SecStr);
			if(Seconds <= 0) exit(0);
		}
	} while(!keypressed());
	c=GetKey();
	clear_keybuf();
	switch(c)
		{
			case F12: 	allegro_exit();
					exit(0);
			case ESC: 	if( ! lockout) goto out;
			case CTRL_F1: 	Screenshot792("Shutdown.bmp");
					goto loopback;
			default: 	goto loopback;
		}

out:    blit(bmp, screen, 0, 0, 0, 0, 800, 600);
	destroy_bitmap(bmp);
}
int NormalLoadError(char *Str)
{
	BITMAP *errbmp = create_bitmap(800,600);
	clear_bitmap(errbmp);
	blit(screen, errbmp, 0, 0, 0, 0, 800, 600);
	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LILAC);
	Title("LOAD ERROR");
	MarsF(200, 180, 3, ORANGE, BLACK, "CRITICAL ERROR");
	PutsFont19(200,280,SKYBLUE,"UNABLE TO ACCESS FILE");
	PutsFont19(200,280+32,ORANGE,Strupr(Str));
	PutsFont19(200,280+64,SKYBLUE, "PLEASE INSTALL AND TRY AGAIN");
	ButtonType3(200, 280+128, LILAC, LILAC, "BACK");
	EscSymbol(200+117, 280+128, 2, ORANGE);
	PanelBeep();
loopback:
	c = GetKey();
	switch( c )
		{
		case 27: blit(errbmp, screen, 0, 0, 0, 0, 800, 600);
			destroy_bitmap(errbmp);
			return(27);
		default: goto loopback;
	}
}

int AudioError()
{
	BITMAP *errbmp = create_bitmap(800,600);
	clear_bitmap(errbmp);
	blit(screen, errbmp, 0, 0, 0, 0, 800, 600);
	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(PURPLE);
	Title("SYSTEM ERROR");
	MarsF(200, 180, 3, ORANGE, BLACK, "FUNCTION DISABLED");
	if(AudioOff==TRUE) PutsFont19(200,280,PALEBLUE,"AUDIO OUTPUT MUTED");
		else PutsFont19(200,280,RED,"UNDETERMINED ERROR");
	ButtonType3(200, 280+96, LILAC, LILAC, "BACK");
	EscSymbol(200+117, 280+96, 2, ORANGE);

loopback:
	c = GetKey();
	switch( c )
		{
		case LEFTARROW:
		case 27: blit(errbmp, screen, 0, 0, 0, 0, 800, 600);
			destroy_bitmap(errbmp);
			return(27);
		default: goto loopback;
	}
}


int FontLoadError(char *Str)
{
	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LILAC);
/*	Title("LOAD ERROR"); */
	MarsF(200, 140, 3, ORANGE, BLACK, "CRITICAL ERROR");
	MarsF(200,240, 2, SEABLUE, BLACK, "FONT FILE NOT FOUND:");
	MarsF(200,240+68, 2, SEABLUE, BLACK, get_filename(Str));
	MarsF(200,240+136, 2, MANGO, BLACK, "PRESS ESC");

/*	PutsLuna(200,280+48, SKYBLUE, BLACK, "PLEASE INSTALL AND TRY AGAIN");
	ButtonType3(200, 280+128, LILAC, LILAC, "BACK");
	EscSymbol(200+117, 280+128, 2, ORANGE);
*/
	PanelBeep();
loopback:
	c = GetKey();
	switch( c )
		{
		case 27: return(27);
		default: goto loopback;
	}
}
/* eof */


