/*	 periodic.h, embedded LCARS 24 applet
	Draws a color-coded periodic table with symbols and lets the user
	browse the names of the elements, plus a puzzle mode
	Usage:
	int PeriodicTableMode();
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#ifndef PERIODIC_H
#define PERIODIC_H


#include "allegro.h"
#include "headline.h"
#include "parts.h"
#include "getkey.h"
#include "cards.h"
#include "scrnshot.h"
#include "playwav.h"

char PeriodicMode; /* reference or puzzle */ 
typedef struct element {

	char symb[4];
	char name[14];
	int x;
	int y;
	int color;

} ELEMENT;
BITMAP *PtSprite;
BITMAP *PtBackbmp; /* for erasing a puzzle sprite as it moves */
int PuzzleMin, PuzzleSec, PuzzleSecOld; /* for the puzzle time indication */
SAMPLE *chirp; /* for a sound effect for the puzzle */
char ChirpOK; /* preloading of chrip above and install_sound() OK or not */


void Chirp();
void LoadChirp();
void CloseChirp();

int PeriodicTableMode();


#endif

