/* sfml.h, for rendering SFML (Starfleet Markup Language) pages
*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#ifndef SFML_H
#define SFML_H


#include "lcars24.h"
#include "parts.h"
#include "getkey.h"
#include "mars28.h"
#include "brack1.h"
#include "headline.h"
#include "winfont.h"
#include "errmsg.h"
#include "scrnshot.h"
#include "htmproc.h"
#include "jpgalleg.h"
#include "algif.h"
#include "gifview.h"
#include "common.h"

/*
#include "htmload.h"
#include "htmview.h"
*/
#include "text24.h"
#include "drawline.h"

#define LCARS_SPLIT_SCREEN	0
#define LCARS_POPSICLE_SCREEN	1
#define LCARS_MSD_SCREEN	2
#define LCARS_PANEL_SCREEN	3
#define LCARS_OVERLAY_SCREEN	4
#define TXT_CONTROL		0
#define HTM_CONTROL		1
#define STATIC_CONTROL		2


typedef struct diagramlabel {
	int tx;
	int ty;
	int px;
	int py;
	char Str[60];
	int Col1;
} DIAGRAMLABEL;



DIAGRAMLABEL label[42];
int LabelNum;
int NumOfLabels;
char SfmTitle[64];
int SfmTitleColor;
char SfmCaption[64];
char SfmPopsicleCaption[64];
char SfmBottomCaption[64];
int SfmCaptionColor;
int SfmHeadlineColor;
int SfmTextColor;
char SfmScreentype;
char SfmControltype;
int SfmBracketColor1;
int SfmBracketColor2;
int SfmFrameColor;
char SfmFolder[80];
char SfmIndex[80];  /* filename of file for scrolling text on an SFML page */
char SfmIndexLoaded; /* flag regarding use of SfmIndex, above */
char SfmImage[80];
char SfmFile[80];
char SfmLink[9][80];
int SfmImageX;
int SfmImageY;
int SfmScroll;
int NoEdit;
char AutocloseFlag;

char SfmButton1Label[24];
int SfmButton1Color;
char SfmButton2Label[24];
int SfmButton2Color;
char SfmButton3Label[24];
int SfmButton3Color;
char SfmButton4Label[24];
int SfmButton4Color;
char SfmWav[80];
char SfmGif[80];
int SfmDrawColor;
int SfmLineThickness;

int SfmGetNamedColor(char *ColorName);
int LcSfml(char *filespec);
int OpenSfml(char *filespec);


#endif


