/* 12/12/09 */
/*	 LCcolor.c, color routines for LCARS ACCESS 
	Sets  LCARS colors and their
	antialiasing tones, plus black.
	Alternates added for Endgame mode, named after the last Episode of
	Star Trek Voyager, where a different LCARS pallete was seen
*/

#include "lccolor.h"

void LcarsColors()
{
	BLACK =		makecol(0x00,0x00,0x00);
	WHITE =		makecol(0xCC,0xCC,0xFF);
	CARDWHITE =	makecol(0xEF,0xEF,0xEF);
	RED =		makecol(0xFF,0x33,0x00);
	DARKRED =	makecol(0x99,0x33,0x00);
	NAPLES =	makecol(0xFF,0xCC,0x99);
	BORG =		makecol(0x33,0xCC,0x99); /* same as Endgame green 2 */
	MANGO =		makecol(0xFF,0x99,0x66);
	SEABLUE =	makecol(0x66,0x99,0xCC);
	LAVENDER =	makecol(0x99,0x66,0xFF);
	DARKGRAY =	makecol(0x66,0x66,0x66); /* was 0x66,0x66,0x99*/
	BIGBLUE =	makecol(0x66,0x66,0xFF);
	KHAKI =		makecol(0xCC,0xCC,0x66);
	OLIVE =		makecol(0x99,0x99,0x33);

	if(Endgame==0) {
		TAN =		makecol(0xCC,0x99,0x66);
		ORANGE =	makecol(0xFF,0x99,0x00);
		LILAC =		makecol(0xCC,0x99,0xCC);
		SKYBLUE =	makecol(0x99,0xCC,0xFF);
		PALEBLUE =	makecol(0x99,0x99,0xFF);
		BRICK =		makecol(0xCC,0x66,0x66);
		PURPLE =	makecol(0xCC,0x66,0x99);
	} else {
		TAN =		makecol(0xff,0x00,0x66); /* Endgame rouge */
		ORANGE =	makecol(0xFF,0x99,0x33); /* Endgame orange */
		LILAC =	 	makecol(0xFF,0xCC,0xFF); /* Endgame beige */
		SKYBLUE =	makecol(0x33,0xFF,0xCC);  /* Endgame yellow */
		PALEBLUE =	makecol(0x33,0xCC,0x99); /* Endgame green 2 */
		BRICK =		makecol(0xFF,0x66,0x66); /* Endgame salmon*/
		PURPLE =	makecol(0x99,0x66,0x99);
	}
}
int FadeOut(int ForeColor)
{
	int r,g,b,r2,g2,b2;

	fc=ForeColor;
	r=getr(ForeColor);
	g=getg(ForeColor);
	b=getb(ForeColor);
	r2=r * 0.88;
	g2=g *.88;
	b2=b * 0.88;
	ac1=makecol(r2,g2,b2);
	r2=r * 0.78;
	g2=g * 0.78;
	b2=b * 0.78;
	ac2=makecol(r2,g2,b2);
	r2=r * 0.57;
	g2=g * 0.57;
	b2=b * 0.57;
	ac3=makecol(r2,g2,b2);
	r2=r * 0.41;
	g2=g * 0.41;
	b2=b * 0.41;
	ac4=makecol(r2,g2,b2);
	return(0);
}
int FadeIn(int BackColor)
{
	int r,g,b,r2,g2,b2;

	fc=BLACK;
	r=getr(BackColor);
	g=getg(BackColor);
	b=getb(BackColor);
	r2=r * 0.78;
	g2=g * 0.78;
	b2=b * 0.78;
	ac4=makecol(r2,g2,b2);
	r2=r * 0.57;
	g2=g * 0.57;
	b2=b * 0.57;
	ac3=makecol(r2,g2,b2);
	r2=r * 0.41;
	g2=g * 0.41;
	b2=b * 0.41;
	ac2=makecol(r2,g2,b2);
	ac1=BLACK;
	return(0);
}
void FontFadeUp(BITMAP *bmp,int x,int y,int Hue,int range)
{
	int r,b,g,dr,dg,db,z,limit;

	r=getr(Hue);
	g=getg(Hue);
	b=getb(Hue);
	dr = r;
	dg = g;
	db = b;

	limit = range;
	range += range * .25;		/* slows fade to produce nice slants */
	for( z=1; z <= limit; ++z ) {
		dr -= r/range;
		dg -= g/range;
		db -= b/range;
		putpixel(bmp,x,y+1-z,makecol(dr,dg,db));
	}
}
void FontFadeDown(BITMAP *bmp,int x,int y,int Hue,int range)
{
	int r,b,g,dr,dg,db,z,limit;

	r=getr(Hue);
	g=getg(Hue);
	b=getb(Hue);
	dr = r;
	dg = g;
	db = b;

	limit = range;
	range += range * .25;		/* slows fade to produce nice slants */
	for( z=1; z <= limit; ++z ) {
		dr -= r/range;
		dg -= g/range;
		db -= b/range;
		putpixel(bmp,x,y-1+z,makecol(dr,dg,db));
	}
}
