/* 12/19/09 */

/* 	periodic.c, embedded LCARS 24 applet
	Draws a color-coded periodic table with symbols and lets the user
	browse the names of the elements, plus a puzzle mode
	Usage:
	int PeriodicTableMode();
*/



#include "periodic.h"


void PutElapsedPuzzleTime()
{
	LCARSTIME now;
	char OutputStr[6]="00:00";
	int l_holder, r_holder;
	unsigned int t;

	if(PuzzleSecOld == 70) {
		PutsLuna(160,566, BLACK,LILAC, "ELAPSED TIME: ");
		PutsLuna(250,566, BLACK,LILAC, OutputStr);
		PuzzleSecOld=69;
		return;
	}

	now=GetTimeStr();

	if (PuzzleSecOld != now.Seconds) {
		PuzzleSec++;
		if(PuzzleSec > 59) {
			PuzzleSec=0;
			PuzzleMin++;
		}
		l_holder=PuzzleSec / 10;
		t=l_holder + 48;
		OutputStr[3]=(t);
		r_holder=PuzzleSec - (l_holder * 10);
		t=r_holder + 48;
		OutputStr[4]=(t);

		l_holder=PuzzleMin / 10;
		t=l_holder + 48;
		OutputStr[0]=(t);
		r_holder=PuzzleMin - (l_holder * 10);
		t=r_holder + 48;
		OutputStr[1]=(t);

		rectfill(screen, 250, 560, 280, 586, LILAC);
		PutsLuna(250,566, BLACK,LILAC, OutputStr);
	}
	PuzzleSecOld=now.Seconds;
}

ELEMENT GetElementInfo(int AtNum)
{
ELEMENT e[118] = {
{"H", "Hydrogen", 0,0,MANGO},
{"He", "Helium", 17,0,NAPLES},
{"Li", "Lithium", 0,1,MANGO},
{"Be", "Beryllium", 1,1,ORANGE},
{"B", "Boron", 12,1,BRICK},
{"C", "Carbon", 13,1,BRICK},
{"N", "Nitrogen", 14,1,BRICK},
{"O", "Oxygen", 15,1,BRICK},
{"F", "Fluorine", 16,1,BRICK},
{"Ne", "Neon", 17,1,NAPLES},
{"Na", "Sodium", 0,2,MANGO},
{"Mg", "Magnesium", 1,2,ORANGE},
{"Al", "Aluminum", 12,2,LAVENDER},
{"Si", "Silicon",  13,2,BRICK},
{"P", "Phosphorus", 14,2,BRICK},
{"S", "Sulfur", 15,2,BRICK},
{"Cl", "Chlorine", 16,2,BRICK},
{"Ar", "Argon", 17,2,NAPLES},
{"K", "Potassium", 0,3,MANGO},
{"Ca", "Calcium",  1,3,ORANGE},
{"Sc", "Scandium", 2,3,LILAC},
{"Ti", "Titanium", 3,3,LILAC},
{"V", "Vanadium",  4,3,LILAC},
{"Cr", "Chromium", 5,3,LILAC},
{"Mn", "Manganese", 6,3,LILAC},
{"Fe", "Iron", 7,3,LILAC},
{"Co", "Cobalt", 8,3,LILAC},
{"Ni", "Nickel", 9,3,LILAC},
{"Cu", "Copper", 10,3,LILAC},
{"Zn", "Zinc", 11,3,LILAC},
{"Ga", "Gallium", 12,3,LAVENDER},
{"Ge", "Germanium", 13,3,LAVENDER},
{"As", "Arsenic", 14,3,BRICK},
{"Se", "Selenium", 15,3,BRICK},
{"Br", "Bromine", 16,3,BRICK},
{"Kr", "Krypton", 17,3,NAPLES},
{"Rb", "Rubidium", 0,4,MANGO},
{"Sr", "Strontium", 1,4,ORANGE},
{"Y", "Yttrium", 2,4,LILAC},
{"Zr", "Zirconium ", 3,4,LILAC},
{"Nb", "Niobium",  4,4,LILAC},
{"Mo", "Molybdenum", 5,4,LILAC},
{"Tc", "Technetium", 6,4,LILAC},
{"Ru", "Ruthenium", 7,4,LILAC},
{"Rh", "Rhodium", 8,4,LILAC},
{"Pd", "Palladium", 9,4,LILAC},
{"Ag", "Silver", 10,4,LILAC},
{"Cd", "Cadmium", 11,4,LILAC},
{"In", "Indium",  12,4,LAVENDER},
{"Sn", "Tin", 13,4,LAVENDER},
{"Sb", "Antimony", 14,4,LAVENDER},
{"Te", "Tellurium", 15,4,BRICK},
{"I", "Iodine", 16,4,BRICK},
{"Xe", "Xenon", 17,4,NAPLES},
{"Cs", "Cesium", 0,5,MANGO},
{"Ba", "Barium", 1,5,ORANGE},
{"La", "Lanthanum", 3,8,PALEBLUE},
{"Ce", "Cerium", 4,8,PALEBLUE},
{"Pr", "Praseodymium", 5,8,PALEBLUE},
{"Nd", "Neodymium", 6,8,PALEBLUE},
{"Pm", "Promethium", 7,8,PALEBLUE},
{"Sm", "Samarium", 8,8,PALEBLUE},
{"Eu", "Europium", 9,8,PALEBLUE},
{"Gd", "Gadolinium", 10,8,PALEBLUE},
{"Tb", "Terbium", 11,8,PALEBLUE},
{"Dy", "Dysprosium", 12,8,PALEBLUE},
{"Ho", "Holmium", 13,8,PALEBLUE},
{"Er", "Erbium", 14,8,PALEBLUE},
{"Tm", "Thulium", 15,8,PALEBLUE},
{"Yb", "Ytterbium", 16,8,PALEBLUE},
{"Lu", "Lutetium", 17,8,PALEBLUE},
{"Hf", "Hafnium", 3,5,LILAC},
{"Ta", "Tantalum", 4,5,LILAC},
{"W", "Tungsten", 5,5,LILAC},
{"Re", "Rhenium", 6,5,LILAC},
{"Os", "Osmium", 7,5,LILAC},
{"Ir", "Iridium", 8,5,LILAC},
{"Pt", "Platinum", 9,5,LILAC},
{"Au", "Gold", 10,5,LILAC},
{"Hg", "Mercury", 11,5,LILAC},
{"Tl", "Thallium", 12,5,LAVENDER},
{"Pb", "Lead", 13,5,LAVENDER},
{"Bi", "Bismuth", 14,5,LAVENDER},
{"Po", "Polonium", 15,5,LAVENDER},
{"At", "Astatine", 16,5,BRICK},
{"Rn", "Radon", 17,5,NAPLES},
{"Fr", "Francium", 0,6,MANGO},
{"Ra", "Radium", 1,6,ORANGE},
{"Ac", "Actinium", 3,9,TAN},
{"Th", "Thorium",  4,9,TAN},
{"Pa", "Protactinium", 5,9,TAN},
{"U", "Uranium", 6,9,TAN},
{"Np", "Neptunium", 7,9,TAN},
{"Pu", "Plutonium", 8,9,TAN},
{"Am", "Americium", 9,9,TAN},
{"Cm", "Curium", 10,9,TAN},
{"Bk", "Berkelium", 11,9,TAN},
{"Cf", "Californium", 12,9,TAN},
{"Es", "Einsteinium", 13,9,TAN},
{"Fm", "Fermium", 14,9,TAN},
{"Md", "Mendelevium", 15,9,TAN},
{"No", "Nobelium", 16,9,TAN},
{"Lr", "Lawrencium", 17,9,TAN},
{"Rf", "Rutherfordium", 3,6,LILAC},
{"Db", "Dubnium", 4,6,LILAC},
{"Sg", "Seaborgium", 5,6,LILAC},
{"Bh", "Bohrium", 6,6,LILAC},
{"Hs", "Hassium", 7,6,LILAC},
{"Mt", "Meitnerium", 8,6,LILAC},
{"Ds", "Darmstadtium", 9,6,LILAC},
{"Uuu", "Unununium", 10,6,LILAC},
{"Uub", "Ununbium", 11,6,LILAC},
{"Uut", "Ununtrium", 12,6,LAVENDER},
{"Uuq", "Ununquadium", 13,6,LAVENDER},
{"Uup", "Ununpentium", 14,6,LAVENDER},
{"Uuh", "Ununhexium", 15,6,LAVENDER},
{"Uus", "Ununseptium", 16,6,BRICK},
{"Uuo", "Ununoctium ", 17,6,NAPLES}
};

	return e[AtNum-1];
}
void CandidateBody(int x, int y, char *Symbol, int Hue)
{
	rectfill(screen,x,y,x+28,y+42,Hue);
	PutsFont14(x+6,y+24,BLACK,Hue,Symbol);
	F36Color(Hue,BLACK);
/* upper left */
	rectfill(screen, x,y,x+1,y+1,bc);
	putpixel(screen, x+2,y,ac3);
	putpixel(screen, x+3,y,ac2);
	putpixel(screen, x,y+2,ac3);
	putpixel(screen, x,y+3,ac2);
	putpixel(screen, x+1,y+1,ac2);
/* upper right */
	rectfill(screen, x+27,y,x+28,y+1,bc);
	putpixel(screen, x+26,y,ac3);
	putpixel(screen, x+25,y,ac2);
	putpixel(screen, x+28,y+2,ac3);
	putpixel(screen, x+28,y+3,ac2);
	putpixel(screen, x+27,y+1,ac2);
/* lower left */
	rectfill(screen, x,y+42,x+1,y+42-1,bc);
	putpixel(screen, x+2,y+42,ac3);
	putpixel(screen, x+3,y+42,ac2);
	putpixel(screen, x,y+42-2,ac3);
	putpixel(screen, x,y+42-3,ac2);
	putpixel(screen, x+1,y+42-1,ac2);
/* lower right */
	rectfill(screen, x+27,y+42,x+28,y+42-1,bc);
	putpixel(screen, x+26,y+42,ac3);
	putpixel(screen, x+25,y+42,ac2);
	putpixel(screen, x+28,y+42-2,ac3);
	putpixel(screen, x+28,y+42-3,ac2);
	putpixel(screen, x+27,y+42-1,ac2);
}

void DimCandidate(int x, int y, char *Symbol)
{
	if(x==9 && y < 3) return;

	if(y < 7) {
		x = (x * 35) + 82;
		y = (y * 50) + 77;
	} else {
		x = (x * 35) + 82-16;
		y = (y * 50) + 60;
	}

	CandidateBody(x, y, Symbol, RED);
	EnterSymbol(x+20,y+8,1,SEABLUE);
}
void EraseCandidate(int x, int y)
{
	if(y < 7) {
		x = (x * 35) + 82;
		y = (y * 50) + 77;
	} else {
		x = (x * 35) + 82-16;
		y = (y * 50) + 60;
	}
	blit(PtBackbmp,screen,x,y-4,x,y-4,35,47);
}

void DrawCandidate(int x, int y, char *Symbol, char selected)
{
	if(y < 7) {
		x = (x * 35) + 82;
		y = (y * 50) + 77;
	} else {
		x = (x * 35) + 82-16;
		y = (y * 50) + 60;
	}

	if(selected==0) {   /* draw candidate in home position */
		CandidateBody(x, y, Symbol, SEABLUE);
		blit(screen,PtBackbmp,x,y,x,y,29,43);
	}
	if(selected==1) {
		draw_sprite(screen,PtSprite,x,y-4);
	}
	if(selected==2) {    /* erase */
		rectfill(screen,x,y,x+34,y+42,BLACK);
		rectfill(PtBackbmp,x,y,x+34,y+42,BLACK);
	}
	if(selected==3) {    /* make sprite */
		CandidateBody(x, y, Symbol, WHITE);
		EnterSymbol(x+20,y+8,1,BIGBLUE);
		clear_to_color(PtSprite, BLACK);
		blit(screen,PtSprite,x,y-4,0,0,35,47);
		floodfill(PtSprite,29,42,makecol(255,0,255));
	}
}

void HighlightTag(int x, int y, int Hue, int AtNum, char *Symbol)
{
	char AtNumStr[4];

	if(y < 7) {
		x = (x * 35) + 82;
		y = (y * 50) + 77;
	} else {
		x = (x * 35) + 82-16;
		y = (y * 50) + 60;
	}

	rectfill(screen,x,y,x+28,y+42,BLACK);
	itoa(AtNum, AtNumStr, 10);
	PutsFont14(x+24-StrLenLuna(AtNumStr),y+5,Hue,BLACK,AtNumStr);
	PutsFont14(x+6,y+24,Hue,BLACK,Symbol);
}

void DrawTag(int x, int y, int Hue, int AtNum, char *Symbol)
{
	char AtNumStr[4];

	if(y < 7) {
		x = (x * 35) + 82;
		y = (y * 50) + 77;
	} else {
		x = (x * 35) + 82-16;
		y = (y * 50) + 60;
	}

	if(PeriodicMode==0) {
		rectfill(screen,x,y,x+28,y+42,Hue);
		itoa(AtNum, AtNumStr, 10);
		PutsFont14(x+24-StrLenLuna(AtNumStr),y+5,BLACK,Hue,AtNumStr);
		PutsFont14(x+6,y+24,BLACK,Hue,Symbol);
		F36Color(Hue,BLACK);
/* upper left */
		rectfill(screen, x,y,x+1,y+1,bc);
		putpixel(screen, x+2,y,ac3);
		putpixel(screen, x+3,y,ac2);
		putpixel(screen, x,y+2,ac3);
		putpixel(screen, x,y+3,ac2);
		putpixel(screen, x+1,y+1,ac2);
/* upper right */
		rectfill(screen, x+27,y,x+28,y+1,bc);
		putpixel(screen, x+26,y,ac3);
		putpixel(screen, x+25,y,ac2);
		putpixel(screen, x+28,y+2,ac3);
		putpixel(screen, x+28,y+3,ac2);
		putpixel(screen, x+27,y+1,ac2);
/* lower left */
		rectfill(screen, x,y+42,x+1,y+42-1,bc);
		putpixel(screen, x+2,y+42,ac3);
		putpixel(screen, x+3,y+42,ac2);
		putpixel(screen, x,y+42-2,ac3);
		putpixel(screen, x,y+42-3,ac2);
		putpixel(screen, x+1,y+42-1,ac2);
/* lower right */
		rectfill(screen, x+27,y+42,x+28,y+42-1,bc);
		putpixel(screen, x+26,y+42,ac3);
		putpixel(screen, x+25,y+42,ac2);
		putpixel(screen, x+28,y+42-2,ac3);
		putpixel(screen, x+28,y+42-3,ac2);
		putpixel(screen, x+27,y+42-1,ac2);
	} else {
		itoa(AtNum, AtNumStr, 10);
		PutsFont21(x+24-StrLenFont21(AtNumStr),y+5,Hue,AtNumStr);
	}
}
void DrawPeriodicTable()
{
	ELEMENT e;
	int AtNum;

	for(AtNum=1; AtNum <119; AtNum++) {
		e=GetElementInfo(AtNum);
		DrawTag(e.x,e.y,e.color, AtNum,e.symb);
	}

	PutsLuna(82,77-21,MANGO,BLACK,"ALKALI METALS");
	PutsLuna(641,77-21,NAPLES,BLACK,"NOBLE GASES");

	PutsLuna(82+35,77+50-21,ORANGE,BLACK,"ALKALINE EARTH METALS");
	PutsLuna(82+(12*35),77+50-21,BRICK,BLACK,"NONMETALS");

	PutsLuna(82+(2*35),206,LILAC,BLACK,"TRANSITIONAL METALS");

	PutsLuna(82+(12*35),77+350,LAVENDER,BLACK,"OTHER METALS");

	PutsLuna(82,400+60+5,PALEBLUE,BLACK,"LANTHANIDES");
	PutsLuna(82,450+60+5,TAN,BLACK,"ACTINIDES");
}
void Chirp()
{
	if(ChirpOK==TRUE) play_sample(chirp, 255, 128, 1000, 0);
}
void LoadChirp()
{
	ChirpOK=TRUE;
	if(install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) != 0) {
		ChirpOK=FALSE;
		return;
	}
	SetCurrentFile("\\wav\\lc1.wav");
	chirp = load_sample(CurrentFile);
	if (!chirp) {
		remove_sound();
		ChirpOK=FALSE;
	}
}
void CloseChirp()
{
	destroy_sample(chirp);
	remove_sound();
}
int TableWindowActive()
{
	int AtNum = 1;
	ELEMENT e;

	rectfill(screen,210,13,750,39,LILAC);
	UpArrowSymbol(94+170,82,KHAKI);
	PutsLuna(94+170+18+2,82,KHAKI,BLACK,"/");
	DownArrowSymbol(94+170+24+6,82,KHAKI);
	PutsLuna(705-StrLenLuna("PUZZLE: F9"),20, BLACK,LILAC, "PUZZLE: F9");
	PeriodicMode=0;
	DrawPeriodicTable();
	e=GetElementInfo(AtNum);
	HighlightTag(e.x,e.y,e.color, AtNum,e.symb);
	DrawTag(7,0,e.color, AtNum,e.symb);
	rectfill(screen, 369,77+24,500,77+44,BLACK);
	PutsFont14(370,77+24,e.color,BLACK,e.name);
	Chirp();

loopback:

	e=GetElementInfo(AtNum);
	HighlightTag(e.x,e.y,e.color, AtNum,e.symb);
	DrawTag(7,0,e.color, AtNum,e.symb);
	rectfill(screen, 369,77+24,500,77+44,BLACK);
	PutsFont14(370,77+24,e.color,BLACK,e.name);

	do {
		PopPutTime(0);
	} while(!keypressed());
	c = GetKey();
	switch( c )
	{
		case F12:			return(0);
		case UPARROW:   		DrawTag(e.x,e.y,e.color, AtNum,e.symb);
					++AtNum;
					if(AtNum > 118) AtNum = 1;
					rest(2);
					goto loopback;
		case DOWNARROW: 	DrawTag(e.x,e.y,e.color, AtNum,e.symb);
					--AtNum;
					if(AtNum < 1) AtNum = 118;
					rest(2);
					goto loopback;
		case F9:			return(1);
		case CTRL_F1: 		Screenshot792("Period8.bmp");
					goto loopback;
		case CTRL_F2: 		Screenshot1024("Period10.bmp");
					goto loopback;
		default:			goto loopback;
	}
	return(0);
}
void PeekIndication()
{
	rectfill(screen,400,13,500,39,LILAC);
	PutsLuna(500-StrLenLuna("PEEK: ESC"),20, BLACK,LILAC, "PEEK: ESC");
}
void UnselectIndication()
{
	PutsLuna(400-StrLenLuna("UNSELECT: BS"),20, BLACK,LILAC, "UNSELECT: BS");
}
void EraseUnselectIndication()
{
	rectfill(screen,300,13,400,39,LILAC);
}

int Cheat(int AtNum)
{
	ELEMENT e;

	rectfill(screen,0,50,800,558,BLACK);
	e=GetElementInfo(AtNum);
	PeriodicMode=0;
	DrawTag(e.x,e.y,e.color, AtNum,e.symb);
	PeriodicMode=1;
	rectfill(screen,400,13,500,39,LILAC);
	PutsLuna(500-StrLenLuna("BACK: ESC"),20, BLACK,LILAC, "BACK: ESC");

loopback:
	do {
		PopPutTime(0);
		PutElapsedPuzzleTime();
	} while(!keypressed());
	c = GetKey();
	switch( c )
	{
		case 27:        	blit(PtBackbmp,screen,0,0,0,0,750,588);
				PeekIndication();
				return(27);
		case F9:        	return(F9);
		case F12:		return(0);
		case CTRL_F1:	Screenshot792("Period8.bmp");
				goto loopback;
		case CTRL_F2:	Screenshot1024("Period10.bmp");
				goto loopback;
		default:		goto loopback;
	}
}

int PtDrag(int AtNum, int y)
{
	ELEMENT e;
	int x, oldx, oldy, dimmed, result;

	oldx=x=9;
	oldy=y;
	dimmed=FALSE;
	e=GetElementInfo(AtNum);
	DrawCandidate(x, y, e.symb, 3);
	DrawCandidate(x, y, e.symb, 1);
	PeekIndication();
	UnselectIndication();
loopback:
	do {
		PopPutTime(0);
		PutElapsedPuzzleTime();
	} while(!keypressed());
	c = GetKey();
	switch( c )
	{
		case BS:        /* DrawCandidate(x,y,"",2); */ /* erase */
				EraseCandidate(x,y);
				EraseUnselectIndication();
				return(8);
		case 13:        e=GetElementInfo(AtNum);
				if(dimmed==TRUE) {
					DrawCandidate(x, y, e.symb, 3);
					DrawCandidate(x, y, e.symb, 1);
				}
				DimCandidate(x,y, e.symb);
				dimmed=TRUE;
				if( x != e.x) goto loopback;
				if( y != e.y) goto loopback;
				if(oldx==e.x && oldy==e.y) {
					EraseCandidate(oldx,oldy);
					PeriodicMode=0;
					DrawTag(e.x,e.y,e.color, AtNum,e.symb);
					Chirp();
					PeriodicMode=1;
					return(1);
				}
				goto loopback;
		case F12:        return(0);
		case UPARROW:	if(y==0) goto loopback;
				oldy=y;
				y--;
				EraseCandidate(oldx,oldy);
				oldy=y;
				DrawCandidate(x, y, e.symb, 1);
				rest(2);
				goto loopback;
		case DOWNARROW: if(y==9) goto loopback;
				oldy=y;
				y++;
				EraseCandidate(oldx,oldy);
				oldy=y;
				DrawCandidate(x, y, e.symb, 1);
				rest(2);
				goto loopback;
		case LEFTARROW:	if(x==0) goto loopback;
				oldx=x;
				x--;
				EraseCandidate(oldx,oldy);
				oldx=x;
				DrawCandidate(x, y, e.symb, 1);
				rest(2);
				goto loopback;
		case RIGHTARROW: if(x==17) goto loopback;
				oldx=x;
				x++;
				EraseCandidate(oldx,oldy);
				oldx=x;
				DrawCandidate(x, y, e.symb, 1);
				rest(2);
				goto loopback;
		case 27:	result=Cheat(AtNum);
				if(result==F9) return(F9);
				if(result==0) return(0);
				DrawCandidate(x, y, e.symb, 1);
				goto loopback;
		case F9:	return(F9);
		case CTRL_F1:	Screenshot792("Period8.bmp");
				goto loopback;
		case CTRL_F2:	Screenshot1024("Period10.bmp");
				goto loopback;
		default:	goto loopback;
	}
	return(0);
}
void PtPutScore(int score)
{
	char str[4];

	itoa(score, str, 10);
	rectfill(screen,251,13,276,39,LILAC);
	PutsLuna(252,20, BLACK,LILAC, str);
}

int PeriodicPuzzleMode()
{
	int x, y, z, Result, score, dealt, SelectedY;
	int PeriodicDeck[118];
	char ondeck[3];
	ELEMENT e;
	char done[3];

	rectfill(screen,210,13,750,39,LILAC);
	PutsLuna(705-StrLenLuna("SOLUTION: F9"),20, BLACK,LILAC, "SOLUTION: F9");
	PutsLuna(214,20, BLACK,LILAC, "SCORE: ");
	PtPutScore(0);
	PeekIndication();
	PeriodicMode=1;
	rectfill(screen,0,50,800,558,BLACK);
	DrawPeriodicTable();
	PtBackbmp=create_bitmap(750,588);
	blit(screen,PtBackbmp,0,0,0,0,750,588);
	x=9;
	y=score=0;
	PtSprite=create_bitmap(35,49);

	for(z=0; z<118; ++z) PeriodicDeck[z]=z+1;
	shuffle(PeriodicDeck, 118);
	ondeck[0] = PeriodicDeck[0];
	ondeck[1] = PeriodicDeck[1];
	ondeck[2] = PeriodicDeck[2];
	done[0] = 0;
	done[1] = 0;
	done[2] = 0;

	dealt = 3;

	e=GetElementInfo(ondeck[0]);
	DrawCandidate(x, 0, e.symb, 0);
	PutsFont14(385-StrLenFont14(e.name),101,SEABLUE,BLACK,e.name);
	e=GetElementInfo(ondeck[1]);
	DrawCandidate(x, 1, e.symb, 0);
	PutsFont14(385-StrLenFont14(e.name),151,SEABLUE,BLACK,e.name);
	e=GetElementInfo(ondeck[2]);
	DrawCandidate(x, 2, e.symb, 0);
	PutsFont14(385-StrLenFont14(e.name),201,SEABLUE,BLACK,e.name);
	blit(screen,PtBackbmp,0,0,0,0,750,588);
	EnterSymbol((x*35)+107+6,(y*50)+81,1,NAPLES);
	Chirp();
	PuzzleMin=PuzzleSec=0;
	PuzzleSecOld=70;

loopback:
	do {
		PopPutTime(0);
		PutElapsedPuzzleTime();
	} while(!keypressed());
	c = GetKey();
	switch( c )
	{
		case 13:	if(done[y]==1) goto loopback;
				EnterSymbol((x*35)+107+6,(y*50)+81,1,BLACK);
				DrawCandidate(x,y,"",2); /* erase */
				SelectedY=y;
				Result=PtDrag(ondeck[y], y);
				if(Result==0) {
					destroy_bitmap(PtBackbmp);
					destroy_bitmap(PtSprite);
					return(0);
				}
				if(Result==F9) {
					rectfill(screen,0,50,800,558,BLACK);
					destroy_bitmap(PtBackbmp);
					destroy_bitmap(PtSprite);
					return(1);
				}
				blit(screen,PtBackbmp,0,0,0,0,750,588);
				if(Result==8) goto unselect;
				goto more;
		case F12:       destroy_bitmap(PtBackbmp);
				destroy_bitmap(PtSprite);
				return(0);
		case UPARROW:   if(y==0) goto loopback;
				EnterSymbol((x*35)+107+6,(y*50)+81,1,BLACK);
				y--;
				EnterSymbol((x*35)+107+6,(y*50)+81,1,NAPLES);
				rest(2);
				goto loopback;
		case DOWNARROW: if(y==2) goto loopback;
				EnterSymbol((x*35)+107+6,(y*50)+81,1,BLACK);
				y++;
				EnterSymbol((x*35)+107+6,(y*50)+81,1,NAPLES);
				rest(2);
				goto loopback;
		case 27:	Result=Cheat(ondeck[y]);
				if(Result==F9) return(F9);
				if(Result==0) return(0);
				EnterSymbol((x*35)+107+6,(y*50)+81,1,NAPLES);
				goto loopback;
		case F9:	rectfill(screen,0,50,800,558,BLACK);
				destroy_bitmap(PtBackbmp);
				destroy_bitmap(PtSprite);
				return(1);
		case CTRL_F1:	Screenshot792("Period8.bmp");
				goto loopback;
		case CTRL_F2:	Screenshot1024("Period10.bmp");
				goto loopback;
		default:	goto loopback;
	}

more:
	EraseUnselectIndication();
	score++;
	PtPutScore(score);
	if(score >=118) {
		rectfill(screen,0,50,800,558,BLACK);
		PutsFont21(82+(7*35),127+21,SEABLUE,"PUZZLE COMPLETE");
		destroy_bitmap(PtBackbmp);
		destroy_bitmap(PtSprite);
		return(1);
	}
	e=GetElementInfo(ondeck[y]);
	rectfill(screen,383-StrLenFont14(e.name),(y*50)+101,387,(y*50)+120,BLACK);
	DrawCandidate(x,y,"",2); /* erase */
	EnterSymbol((x*35)+107+6,(y*50)+81,1,NAPLES);
	done[y]=1;
	if(dealt>117) goto loopback;
	ondeck[y] = PeriodicDeck[dealt];
	dealt++;
	e=GetElementInfo(ondeck[y]);
	DrawCandidate(x, y, e.symb, 0);
	PutsFont14(385-StrLenFont14(e.name),(y*50)+101,SEABLUE,BLACK,e.name);
	blit(screen,PtBackbmp,300,(y*50)+101,300,(y*50)+101,85,20);
	done[y]=0;
	goto loopback;

unselect:
	e=GetElementInfo(ondeck[y]);
	DrawCandidate(x, y, e.symb, 0);
	y=SelectedY;
	DrawCandidate(x,y,"",2); /* erase */
	e=GetElementInfo(ondeck[y]);
	DrawCandidate(x, y, e.symb, 0);
	EnterSymbol((x*35)+107+6,(y*50)+81,1,NAPLES);
	goto loopback;
}

int PeriodicTableMode()
{
	int Result;

	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LILAC);
	Title("PERIODIC TABLE");

	PutsLuna(705-StrLenLuna("CLOSE: F12"),566, BLACK,LILAC, "CLOSE: F12");
	min_old=70;
	LoadChirp();

switchback:
	Result = TableWindowActive();
	if(Result==1) Result=PeriodicPuzzleMode();
	if(Result==1) goto switchback;
	if(ChirpOK==TRUE) CloseChirp();
	return(Result);
}


