/* 12/28/09 */

/* Standby.c, variables and some functions of the main LCARS 24 module */


#include "standby.h"

void Box1a(int Color, char *Str1, char *Str2, char *Str3, char *Str4)
{
	int boxtop;

	boxtop=10;
	rectfill(screen,10,boxtop,110,boxtop+54,Color);
	PutsLuna(14,boxtop + 4, BLACK,Color, Str1);
	PutsLuna(90,boxtop + 4, BLACK,Color, Str2);
	PutsLuna(14,boxtop + 37, BLACK,Color, Str3);
	PutsLuna(90,boxtop + 37, BLACK,Color, Str4);
}
void Box2a(int Hue, char *Str)
{
	int boxtop;

	boxtop=68;
	rectfill(screen,10,boxtop,110,boxtop+54,Hue);
	PutsLuna(14,boxtop + 37, BLACK,Hue, Str);
	PutsLuna(96,boxtop + 37, BLACK,Hue, "F9");

	if(strnicmp( "ALARM", Str,5 )==0 ) {
		if(AudioOff==TRUE) PutsLuna(14,boxtop+4,BLACK,Hue, "DISABLED");
			else {
				if(AlarmType==0) PutsLuna(14,boxtop+4,BLACK,Hue, "MIDI");
				if(AlarmType==1) PutsLuna(14,boxtop+4,BLACK,Hue, "MP3");
				if(AlarmType==2) PutsLuna(14,boxtop+4,BLACK,Hue, "VOICE");
			}
	}
}
void Box1b(int Hue, char *Str)
{
	int boxtop;

	boxtop=536;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, Str);
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F1");
}
void EscBox1b(int Hue, char *Str)
{
	int boxtop;

	boxtop=536;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, Str);
	PutsLuna(90,boxtop + 4, BLACK,Hue, "F12");
}
void Box2b(int Hue)
{
	int boxtop;

	boxtop=479;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, "RESTART");
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F2");
}
void Box3b(int Hue)
{
	int boxtop;

	boxtop=422;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, "FILES");
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F3");
}
void Box4b(int Hue)
{
	int boxtop;

	boxtop=365;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, "PROGRAMS");
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F4");
}
void Box5b(int Hue)
{
	int boxtop;

	boxtop=308;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, "LCARS");
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F5");
}
void Box3bm(int Hue)
{
	int boxtop;

	boxtop=422;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(106-StrLenLuna("EXAMPLES")+2,boxtop+37, BLACK,Hue, "EXAMPLES");
}
void Box4bm(int Hue)
{
	int boxtop;

	boxtop=365;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(106-StrLenLuna("FUNCTIONS")+2,boxtop+37, BLACK,Hue, "FUNCTIONS");
}
void Box5bm(int Hue)
{
	int boxtop;

	boxtop=308;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(106-StrLenLuna("OPERATORS")+2,boxtop+37, BLACK,Hue, "OPERATORS");
}
void ElbowSignage(int Hue1, int Hue2)
{
	int boxtop;

	boxtop=130;

	PutsLuna(14,boxtop, BLACK,Hue1, "LIGHT");
	PutsLuna(89,boxtop, BLACK,Hue1, "SPC");
	PutsLuna(14,boxtop + 18, BLACK,Hue1, "PHONEBOOK");
	PutsLuna(96,boxtop + 18, BLACK,Hue1, "F8");

	boxtop=590 - (54*6) - 16;
	PutsLuna(14,boxtop + 37 -19, BLACK,Hue2, "WORLD TIME");
	PutsLuna(96,boxtop + 37 -19, BLACK,Hue2, "F7");

	PutsLuna(14,boxtop + 37, BLACK,Hue2, "MATH");
	PutsLuna(96,boxtop + 37, BLACK,Hue2, "F6");
}
void Boxes()
{
	Box1a(LILAC, "CLOSE", "F12", "HELP", "F11");
	if(SingleAlarmOnOff==0) Box2a(BracketColor2,"ALARM ON");
		else Box2a(MANGO,"ALARM OFF");
	Br1F1Box(BracketColor1, "SETTINGS", "F1");
	Br1F2Box(BracketColor1, "RESTART", "F2");
	Br1F3Box(BracketColor1, "FILES", "F3");
	Br1F4Box(BracketColor1, "PROGRAMS", "F4");
	Br1F5Box(BracketColor1, "LCARS", "F5");
	ElbowSignage(BracketColor1,BracketColor2);
}
void Screen1( int Clear)
{
	if(Clear==1) Wrapper(60,30);
	if(Clear==1) rectfill(screen,0,0,800,600, BLACK);
	Brackets1(BracketColor1,BracketColor2);
	Boxes();
	AlarmDisplay();
	min_old=70;
	day_old=32;
}
void ColorSwitch(int x, int y, int sz)
{
	if(SnoozeAlarmMin != 70) return;
	if( strcmp(SecDisplay,"57")==0 && TimeDisplay[4]==57 ) {
		TimeColor=ORANGE;
		BracketColor1=PALEBLUE;
		BracketColor2=NAPLES;
		Brackets1(BracketColor1,BracketColor2); /* for 3 seconds */
		Boxes();
		MarsF(x, y, sz, TimeColor, BLACK, TimeDisplay);
		PutDate();
		TimeColor=NAPLES;
	}
	if( strcmp(SecDisplay,"00")==0 && TimeDisplay[4]==57) {
		TimeColor=NAPLES;
		switch( ColorScheme )
			{
				case 1:	BracketColor1=PALEBLUE;
						BracketColor2=BIGBLUE;
						break;
				case 2:	BracketColor1=MANGO;
						BracketColor2=BRICK;
						break;
				default:  BracketColor1=ORANGE;
						BracketColor2=PALEBLUE;
			}
		Brackets1(BracketColor1,BracketColor2);
		Boxes();
		MarsF(x, y, sz, TimeColor, BLACK, TimeDisplay);
		PutDate();
	}
	if( strcmp(SecDisplay,"30")==0) {
		Br1F2Box(MANGO, "RESTART", "F2");
		Br1F3Box(MANGO, "FILES", "F3");
		Br1F4Box(MANGO, "PROGRAMS", "F4");
	}
	if( strcmp(SecDisplay,"33")==0) Boxes();
	if( strcmp(SecDisplay,"45")==0) {
		Br1F2Box(BRICK, "RESTART", "F2");
		Br1F3Box(BRICK, "FILES", "F3");
		Br1F4Box(BRICK, "PROGRAMS", "F4");
		Br1F5Box(MANGO, "LCARS", "F5");
	}
	if( strcmp(SecDisplay,"49")==0) {
		Br1F2Box(BIGBLUE, "RESTART", "F2");
		Br1F3Box(BIGBLUE, "FILES", "F3");
		Br1F4Box(BIGBLUE, "PROGRAMS", "F4");
		Br1F5Box(BIGBLUE, "LCARS", "F5");
	}
	if( strcmp(SecDisplay,"54")==0) Boxes();
}
void PutStarDate(int x, int y, int Color)
{ /* PutsFont21 widens a hyphen before a numeral to form a minus sign. */
	if( MidiPlaying != 0 ) return;
	if(SnoozeAlarmMin != 70) return;
	GetStarDate();
	rectfill(screen,x,y,x+152,y+21,BLACK);
	PutsFont21(x,y, Color,"STARDATE: ");
	PutsFont21(x+StrLenFont21("STARDATE: "),y, Color,"-");
	PutsFont21(x+StrLenFont21("STARDATE: ")+3,y, Color,StarDate);
}


int DosRefresh(int txty)
{
	int gy,i,z;

	if(txty==0) min_old=70;
	gy=284-36;
	for( z=0; z < 9; ++z) {
		rectfill(screen,138,gy,799,gy+36,BLACK);
	if( Ln[txty+z][0]=='>' || Ln[txty+z][0]=='!') {
		for( i=0; i< strlen(Ln[txty+z]); ++i)
			Highlight[i]=Ln[txty+z][i+1];
	PutsFont21(140,gy,ORANGE,Highlight);
		} else 	PutsFont21(140,gy,PALEBLUE,Ln[txty+z]);
		gy += 36;
	}
	return(0);
}
void DosTopOfFile(int txty)
{
	DosRefresh(txty);
}
void DosEndOfFile(int txty)
{
	rectfill(screen,120,248,799,599,BLACK);
	DosRefresh(txty);
}
int LcarsCmdCom()
{
	return(0);
}
void LineInput_DisplayInputString(int Hue)
{
	rectfill(screen,118,126,800,149+32,BLACK);
	PutsFont21(120,126,PALEBLUE,CurrentPath);
	PutsFont21(120+StrLenFont21(CurrentPath),126,Hue,KeyInStr);
}
void LineInput_Clear()
{
	cx=120-6;
	dx=1;
	memset(KeyInStr,(null),80);
	rectfill(screen,120,126,800,149+32,BLACK);
	LineInput_DisplayInputString(ORANGE);
}
void LineInput_Cursor()
{
	int q,z,i;

	i=StrLenFont21(CurrentPath);
	cx=120-6;
	for( z=0; z<dx-1; ++z) {
		q=KeyInStr[z];
		cx=cx+ Font21[q] -65;
		}
	cy=126+32;
	xor_mode(TRUE);
	rectfill(screen,cx+i+6,cy-10,cx+i+14,cy-8, WHITE);
	xor_mode(FALSE);
}
void LineInput_CursorLeft()
{
	if( dx==1 ) return;
	--dx;
}
void LineInput_CursorRight()
{
	k=strlen( KeyInStr );
	if( dx > k ) return;
		++dx;
}
void LineInput_Del()
{
	int z;

	k= strlen( KeyInStr );
	if( dx > k ) return;
	for( z=dx-1; z < k; ++z) {
		KeyInStr[z]=KeyInStr[z+1];
	}
	LineInput_DisplayInputString(ORANGE);
}
void LineInput_BS()
{
	int z;

	if( dx <= 1 ) return;
	LineInput_CursorLeft();
	k= strlen( KeyInStr );
	for( z=dx-1; z < k; ++z) {
		KeyInStr[z]=KeyInStr[z+1];
	}
	LineInput_DisplayInputString(ORANGE);
}
void LineInput_DisplayChar()
{
	int q,z;

	if( c < 32 ) return;
	q=StrLenFont21(CurrentPath)+StrLenFont21(KeyInStr);
	k= strlen( KeyInStr );
	if(k>43) return;
	if(dx < k &&  q > 700) return;

	if(dx < k+1) for(z=k; z >= dx; --z) KeyInStr[z]=KeyInStr[z-1];
	if(!(dx-1 > k+1 ) )	KeyInStr[dx-1] =( c );
/*		KeyInStr[k+1]=( null );
*/
	LineInput_DisplayInputString(ORANGE);
	LineInput_CursorRight();
}
int AllBlank()
{ /* Returns 0 if the string is nothing but blanks */
	int a;
        size_t b;

	a=0;
	b=strlen(KeyInStr);
	while( b > a) {
		if( isspace(KeyInStr[a])==0) return(1);
		++a;
	}
	 return(0);
}

/* This following function is customized for DOS service.  Other services
	that require single-line user input should be modified versions
	(different F-key response) of this yet share the
	support functions above.
*/
void DosLineInput()
{
	int Result,txty;
	txty=0;
	strcat(CurrentPath,">");
	LineInput_Clear();
	strcpy(KeyInStr,"dir *.*");
/*	DoDir(3);				  Let's not automatically invoke dir */
	DosRefresh(0);
	LineInput_Clear();

loopback:
	LineInput_Cursor();
	do {
		SolPutTime();
	} while(!keypressed());
	c=GetKey();
	LineInput_Cursor();
	switch( c )
	{
		case ESC: return;
		case F9:  LineInput_Clear();
			  strcpy(KeyInStr,DosClip);
			  LineInput_DisplayInputString(ORANGE);
			  goto loopback;
		case F10: strcpy(DosClip,KeyInStr);
			  LineInput_Clear();
			  goto loopback;
		case 13:  if( strlen(KeyInStr)==0) {
				ScoldUser();
				goto loopback;
			  }
			  if( AllBlank()==0 ) {
				LineInput_Clear();
				ScoldUser();
				goto loopback;
			  }
			  Result=LcarsCmdCom();
			  if(Result==0) goto loopback;
			  if(Result==1) {
				txty=0;
				DosRefresh(0);
				goto loopback;
			  }
			  if(Result==2) return;
			  if(Result==3) {
				txty=EndText-8;
				goto loopback;
			  }
		case BS:  LineInput_BS();
			  goto loopback;
		case 124: 		/* disallow >, |, / */
		case 62:
		case 47:  goto loopback;
		case LEFTARROW: LineInput_CursorLeft();
			  goto loopback;
		case RIGHTARROW: LineInput_CursorRight();
			  goto loopback;
		case UPARROW:
			  if(txty<1) goto loopback;
			  --txty;
			  DosRefresh(txty);
			  goto loopback;
		case DOWNARROW: if(txty>=EndText-8) goto loopback;
			  ++txty;
			  DosRefresh(txty);
			  goto loopback;
		case DELKEY: LineInput_Del();
			  goto loopback;
		case PGUPKEY: if(txty<1) goto loopback;
			  txty -=8;
			  if(txty<0) txty=0;
			  DosRefresh(txty);
			  goto loopback;
		case PGDNKEY: if(txty>=EndText-5) goto loopback;
			  txty +=8;
			  if(txty>=EndText-8) {
				txty=EndText-8;
			  }
			  DosRefresh(txty);
			  goto loopback;
		case HOMEKEY: if(txty<1) goto loopback;
			  txty=0;
			  DosTopOfFile(txty);
			  goto loopback;
		case ENDKEY: if(txty>=EndText-5) goto loopback;
			  txty=EndText-5;
			  DosEndOfFile(txty);
			  goto loopback;
		case CTRL_F1: Screenshot792("Dos8.bmp");
			goto loopback;
		case CTRL_F2: Screenshot1024("Dos10.bmp");
			goto loopback;
		default:  if( c >= 315) goto loopback;
			  LineInput_DisplayChar();
			  goto loopback;
	}
}
void MathDoHelp()
{
	char HelpPath[80];

	strcpy(HelpPath, LcarsPath);
	strcat(HelpPath,"\\SYSTEM\\MATHDOC.TXT");
	OpenHelp(HelpPath);
	min_old=70;
}

void MathLineInput()
{
	LineInput_Clear();
	PanelBeep();
loopback:
	LineInput_Cursor();
	do {
		SolPutTime();
	} while(!keypressed());
	c=GetKey();
	LineInput_Cursor();
	switch( c )
	{
		case F9: 	LineInput_Clear();
				strcpy(KeyInStr,MathClip);
				LineInput_DisplayInputString(ORANGE);
				goto loopback;
		case F10: 	strcpy(MathClip,KeyInStr);
				LineInput_Clear();
				goto loopback;
		case F11: 	MathDoHelp();
				goto loopback;
		case F12: 	return;
		case 13: 	if( strlen(KeyInStr)==0) {
					ScoldUser();
					goto loopback;
				 }
				if( AllBlank()==0 ) {
					LineInput_Clear();
					ScoldUser();
					goto loopback;
				}
				memset(MathInput[1],(null),80);
				strcpy(MathInput[1],KeyInStr);
				LcMath();
				rectfill(screen,140,281,799,281+32,BLACK);
				PutsFont21(140,281,PALEBLUE,MathOutput);
				goto loopback;
		case BS:	LineInput_BS();
				goto loopback;
		case LEFTARROW: LineInput_CursorLeft();
				goto loopback;
		case RIGHTARROW: LineInput_CursorRight();
				goto loopback;
		case DOWNARROW: goto loopback;
		case DELKEY: 	LineInput_Del();
				goto loopback;
		case PGUPKEY:
		case PGDNKEY:
		case UPARROW: 	goto loopback;
		case CTRL_F1: Screenshot792("Math8.bmp");
				goto loopback;
		case CTRL_F2: Screenshot1024("Math10.bmp");
				goto loopback;
		default:  if( c >= 315) goto loopback;
				LineInput_DisplayChar();
				goto loopback;
	}
}
void GlowMode()
{
	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(LILAC);
	Title("GLOW MODE");
	PutsLuna(200,20, BLACK,LILAC, "OFF: PRESS ANY KEY");
	rectfill(screen,0,50,800,550, makecol(255,255,255));

	min_old=70;
	do {
		PopPutTime(1);
	} while(!keypressed());
	GetKey();
}
int FindOS()
{
	if(os_type==OSTYPE_UNKNOWN) DosDetected=TRUE;
	if(os_type==OSTYPE_OPENDOS) DosDetected=TRUE;
	return(0);
}
void FindGifFiles()
{
	struct al_ffblk fblock;
	int Found, z;
	unsigned short t;
	char mask[128];

	for(z = 0; z < 100; ++z) memset(GifList[z], (null), 32);
	t=13;
	GifList[0][0]=(t);
	EndGifList=0;
	memset(mask, 0, 128);
	strcpy(mask, LcarsPath);
	strcat(mask, "\\SYSTEM\\GIF\\*.GIF");
	Found = al_findfirst(mask, &fblock, FA_ALL);
	while ( !Found ) {
		strcpy(GifList[EndGifList], fblock.name);
		++EndGifList;
		if(EndGifList > 98) break;
		Found = al_findnext( &fblock );
	}
	al_findclose( &fblock );
}
int RegisterDateSetting(int NewMonth, int NewDay, int NewYear)
{
	time_t xt;
	struct tm *pt;
	int year, month, day;

	time(&xt);
	pt=localtime(&xt);
	year=pt->tm_year+1900;
	month=pt->tm_mon+1;
	day=pt->tm_mday;
	DeltaYr=NewYear-year;
	DeltaMo=NewMonth-month;
	DeltaDa=NewDay-day;

	return(0);
}
void RegisterTimeSetting(int NewHr, int NewMin)
{
	time_t xt;
	struct tm *pt;
	int Minutes,Hours,Seconds;

	if (SettingType==1) {
		time(&xt);
		pt=localtime(&xt);
		Minutes=pt->tm_min;
		Hours=pt->tm_hour;
		Seconds=pt->tm_sec;
		DeltaMn=NewMin-Minutes;
		DeltaHr=NewHr-Hours;
		DeltaSc=Seconds; /* different, to force zero */
		DeltaMn--; /* because of how seconds are handeled */
	}
	if (SettingType==2) {
		AlarmHour=NewHr;
		AlarmMin=NewMin;
		SingleAlarmOnOff=1;
		BuildAlarmString();
		AlarmDisplay();
		Box2a(MANGO,"ALARM OFF");
		memcpy(SecWhenAlarmSet,SecDisplay,2);
	}
}
void ForcedTimeDisplay(int x, int y, int sz)
{
	min_old=70;
	PutTime(x,y,sz);
}
void DateSettingDisplay(int NewMonth, int NewDay)
{
	int l_holder;
	int r_holder;

	l_holder=NewMonth / 10;
	t=l_holder + 48;
	if(l_holder==0) t=32;
	DateSetting[0]=(t);

	r_holder=NewMonth - (l_holder * 10);
	t=r_holder + 48;
	DateSetting[1]=(t);

	l_holder=NewDay / 10;
	t=l_holder + 48;
	DateSetting[3]=(t);

	r_holder=NewDay - (l_holder * 10);
	t=r_holder + 48;
	DateSetting[4]=(t);

/*	rectfill(screen,140-18,320-14,320+8,420+14,BLACK); */
	MarsF(140-18, 330-14, 4, NAPLES, BLACK, DateSetting);
}
void SettingDisplay(int NewHr, int NewMin)
{
	int hours;
	int l_holder;
	int r_holder;

	hours=NewHr;

	if(MilitaryTime !=0) goto bypass;
	if(NewHr > 11 ) PutSettingPM(323,374);
	if(NewHr < 12 ) PutSettingAM(322,374);

	if(hours > 12) hours -= 12;
	if(hours==0) hours=12;

bypass:
	l_holder=hours / 10;
	t=l_holder + 48;
	if(l_holder==0) t=32;
	TimeSetting[0]=(t);

	r_holder=hours - (l_holder * 10);
	t=r_holder + 48;
	TimeSetting[1]=(t);

	l_holder=NewMin / 10;
	t=l_holder + 48;
	TimeSetting[3]=(t);

	r_holder=NewMin - (l_holder * 10);
	t=r_holder + 48;
	TimeSetting[4]=(t);

	MarsF(132, 316, 4, NAPLES, BLACK, TimeSetting);
}
void DisplaySnoozeSetting()
{
	char SnoozeStr[3];

	itoa( SnoozeVal, SnoozeStr, 10);
	if(SnoozeVal==0) strcpy(SnoozeStr," 0");
	if(SnoozeVal==6) strcpy(SnoozeStr," 6");
	MarsF(444+82,445+48,2,MANGO,BLACK, SnoozeStr);
}
void TimeSettingMode()
{
	int NewHr;
	int NewMin;
	int z;

	NewHr=Hours;
	NewMin=Minutes;

	rectfill(screen,112,250,650,599,BLACK);
	SettingDisplay(NewHr,NewMin);
	if( SettingType==1) PopUp1(120,255,LILAC,"SET TIME");
	if( SettingType==2) PopUp1(120,255,LILAC,"SET ALARM");
	SettingGuide(1,120,255,LILAC);

	for( z=0; z < 6; ++z)
		  {
				 t=TimeDisplay[z];
				 TimeSetting[z]=(t);
	}
	ForcedTimeDisplay(456,280,4); /* So it won't wait for a new minute */

	if( SettingType==2) {

		/* flange, with one hole */
		rectfill(screen, 444,445,444+72,570,BIGBLUE);
		rectfill(screen,486, 540, 510, 564, BLACK);

		PutsFont21(444+82, 445, ORANGE, "SNOOZE");
		DisplaySnoozeSetting();
		PutsFont21(578, 528, MANGO, "MINUTES");
		PutsLuna(444+82, 570-13,ORANGE,BLACK, "PG UP/DN");
	}

loopback:
	do {
		PutTime(456,280,4); /* Same x position and size as above */
	} while (!keypressed());

	c=GetKey();
	switch( c )
	{
		case F1:
		case F2:
		case F3:
		case F4:
		case F5:
		case 27:        Box1b(BracketColor1, "SETTINGS");
				rectfill(screen,112,250,650,599,BLACK);
				ForcedTimeDisplay(164,264,10);
				clear_keybuf(); 
				return;
		case DOWNARROW:
				--NewHr;
				if(NewHr < 0) NewHr=23;
				SettingDisplay(NewHr,NewMin);
				clear_keybuf(); 
				goto loopback;
		case UPARROW:
				++NewHr;
				if(NewHr==24) NewHr=0;
				SettingDisplay(NewHr,NewMin);
				clear_keybuf(); 
				goto loopback;
		case LEFTARROW:
				--NewMin;
				if(NewMin < 0) NewMin=59;
				SettingDisplay(NewHr,NewMin);
				clear_keybuf();
				goto loopback;
		case RIGHTARROW:
				++NewMin;
				if(NewMin==60) NewMin=0;
				SettingDisplay(NewHr,NewMin);
				goto loopback;
				clear_keybuf();
		case PGDNKEY: 	if(SnoozeVal==0) goto loopback;
				if( SettingType==2) {
					SnoozeVal-=6;
					DisplaySnoozeSetting();
				}
				clear_keybuf();
				goto loopback;
		case PGUPKEY: if(SnoozeVal==18) goto loopback;
				if( SettingType==2) {
					SnoozeVal+=6;
					DisplaySnoozeSetting();
				}
				clear_keybuf();
				goto loopback;
		case 13:
				RegisterTimeSetting(NewHr,NewMin);
				Box1b(BracketColor1, "SETTINGS");
				rectfill(screen,112,250,650,599,BLACK);
				min_old=70; /* Don't wait */
				PutTime(164,264,10);
				SaveAlarm();
				clear_keybuf();
				return;
		case CTRL_F1: 	Screenshot792("Time8.bmp");
				goto loopback;
		case CTRL_F2: 	Screenshot1024("Time10.bmp");
				goto loopback;
		default:
				clear_keybuf();
				goto loopback;
	}
}
void DateSettingMode()
{
	int NewMonth, NewDay, NewYear, WhichCalendar, z;
	int MaxDay=31;

	NewMonth=DateMonth;
	NewDay=DateDay;
	NewYear=DateYear;

	rectfill(screen,112,250,650,599,BLACK);
	DateSettingDisplay(NewMonth,NewDay);
	PopUp1(120,255,LILAC,"SET DATE");
	SettingGuide(2,120,255,LILAC);

	for( z=0; z < 6; ++z)
		  {
		  t=DateDisplay[z];
		  DateSetting[z]=(t);
	}
	ForcedTimeDisplay(456,280,4); /* So it won't wait for a new minute */
	if( NewYear < 1990 ) NewYear=1990;
	itoa( NewYear, YearDisplay, 10);
	MarsF(342,344,2,MANGO,BLACK, YearDisplay);
	PutsLuna(342, 416,ORANGE,BLACK, "PG UP/DN");

loopback:
	do {
		PutTime(456,280,4); /* Same x position and size as above */
	} while (!keypressed());

	c=GetKey();
	switch( c )
	{
		case F1:
		case F2:
		case F3:
		case F4:
		case F5:
		case 27: 	Box1b(BracketColor1, "SETTINGS");
				rectfill(screen,112,250,650,599,BLACK);
				ForcedTimeDisplay(164,264,10);
				return;
		case DOWNARROW:
				--NewMonth;
				if(NewMonth < 1) NewMonth=12;
				WhichCalendar=GetWhichCalendar(NewYear);
				MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
				if(NewDay > MaxDay) NewDay=MaxDay;
				DateSettingDisplay(NewMonth,NewDay);
				goto loopback;
		case UPARROW:
				++NewMonth;
				if(NewMonth > 12 ) NewMonth=1;
				WhichCalendar=GetWhichCalendar(NewYear);
				MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
				if(NewDay > MaxDay) NewDay=MaxDay;
				DateSettingDisplay(NewMonth,NewDay);
				goto loopback;
		case LEFTARROW:
				--NewDay;
				WhichCalendar=GetWhichCalendar(NewYear);
				MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
				if(NewDay < 1) NewDay=MaxDay;
				DateSettingDisplay(NewMonth,NewDay);
				goto loopback;
		case RIGHTARROW:
				++NewDay;
				WhichCalendar=GetWhichCalendar(NewYear);
				MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
				if(NewDay > MaxDay) NewDay=1;
				DateSettingDisplay(NewMonth,NewDay);
				goto loopback;
		case 13: 	WhichCalendar=GetWhichCalendar(NewYear);
				MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
				if(NewDay > MaxDay) NewDay=MaxDay;
				RegisterDateSetting(NewMonth,NewDay,NewYear);
				Box1b(BracketColor1, "SETTINGS");
				rectfill(screen,112,250,650,599,BLACK);
				min_old=70; /* Don't wait */
				day_old=32;
				NextMonthCalender(1);
				PutTime(164,264,10);
				PanelBeep();
				return;
		case PGDNKEY: --NewYear;
				if( NewYear < 1990 ) NewYear=1990;
				if( NewYear > 2030 ) NewYear=2030;
				itoa( NewYear, YearDisplay, 10);
				rectfill(screen,340,344,423,404,BLACK);
				MarsF(342,344,2,MANGO,BLACK, YearDisplay);
				WhichCalendar=GetWhichCalendar(NewYear);
				MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
				if(NewDay > MaxDay) {
					NewDay=MaxDay;
					DateSettingDisplay(NewMonth,NewDay);
				}
				goto loopback;
		case PGUPKEY: ++NewYear;
				if( NewYear < 1990 ) NewYear=1990;
				if( NewYear > 2030 ) NewYear=2030;
				itoa( NewYear, YearDisplay, 10);
				rectfill(screen,340,344,423,404,BLACK);
				MarsF(342,344,2,MANGO,BLACK, YearDisplay);
				WhichCalendar=GetWhichCalendar(NewYear);
				MaxDay=GetLengthOfMonth(WhichCalendar, NewMonth);
				if(NewDay > MaxDay) {
					NewDay=MaxDay;
					DateSettingDisplay(NewMonth,NewDay);
				}
				goto loopback;
		default:        ScoldUser();
			 	goto loopback;
	}
}
void SettingsMode()
{
	Box1b(NAPLES,"SETTINGS");
	rectfill(screen,112,250,650,599,BLACK);
	ForcedTimeDisplay(375,275,6); /* So it won't wait for a new minute */
	SettingSelect();

loopback:
	do {
		PutTime(375,275,6); /* Same x position and size as above */
	} while (!keypressed());

	c=GetKey();
	switch( c )
	{
		case 27:
		case F2:
		case F3:
		case F4:
		case F5:	Box1b(BracketColor1, "SETTINGS");
				rectfill(screen,112,250,650,599,BLACK);
				ForcedTimeDisplay(164,264,10);
				PanelBeep();
				return;
		case 49:  /*      SettingType=1; */
		/*		TimeSettingMode(); */
		/*		PanelBeep(); */
		/*		return; */
				ScoldUser();
				goto loopback;
		case 50: 	/* DateSettingMode(); */
			/*	PanelBeep(); */
			/*	return; */
				ScoldUser();
				goto loopback;
		case 51:        if(BlasterOK==FALSE || AudioOff==TRUE) {
					AudioError();
					goto loopback;
				}
				SettingType=2;
				TimeSettingMode();
				PanelBeep();
				return;
		case 52: 	OptionSettingMode();
				PanelBeep();
				return;
		case CTRL_F1: 	Screenshot792("Sttngs8.bmp");
				PanelBeep();
				goto loopback;
		case CTRL_F2: 	Screenshot1024("Sttngs10.bmp");
				PanelBeep();
				goto loopback;
		default: 	ScoldUser();
			 	goto loopback;
	}
}
void SetLcarsPath()
{
/*	chdir(LcarsPath); */
}
void Recover()
{
	set_color_depth(DepthFound);
	if(ScreenSize==1024) set_gfx_mode(GFX_AUTODETECT, 1024, 768, 0, 0);
		else set_gfx_mode(GFX_AUTODETECT, 800, 600, 0, 0);
	Screen1(1);
	old_sec=70;
	min_old=70;
	day_old=32;
	AlarmDisplay();
	SetLcarsPath();
}
void FindCurrentBracketColors()
{
	switch( ColorScheme )
	{
		case 1:	BracketColor1=PALEBLUE;
				BracketColor2=BIGBLUE;
				break;
		case 2:	BracketColor1=MANGO;
				BracketColor2=BRICK;
				break;
		default:  BracketColor1=ORANGE;
				BracketColor2=PALEBLUE;
	}
}
int WarmRecover()
{
	SetLcarsPath();
	FindCurrentBracketColors();
	Screen1(1);
	old_sec=70;
	min_old=70;
	day_old=32;
	AlarmDisplay();
	return(0);
}
void SpecsMode()
{
	SetCurrentFile("\\DATA\\LC24W.TXT");
	OpenTxt(CurrentFile);
	BeepSet=TRUE;
}
void ChangeFolder(char PathAndFilename[80])
{ /* parses out an application's pathname and changes to that path
	to it can access its support files */

	char PathnameOnly[80];
	char Command[80];
	int Place, a;

	fix_filename_slashes(PathAndFilename);
	a=1;
	for(;;) {  /* find the last backslash */
		if( PathAndFilename[a]==92 ) Place=a;
		if( PathAndFilename[a]==0 ) break;
		++a;
	}
	strcpy(PathnameOnly,PathAndFilename);
	PathnameOnly[Place]=(null);
	strcpy(Command, "CD ");
	strcat(Command, PathnameOnly);
	system( Command );
}
void DoLaunch()
{
	system("launch");
}
void LaunchDisplay(char *ProgramName,char *ProgramPath)
{
	int a,b,c;

	a=StrLenMars(3,ProgramName);
	b=StrLenFont21(ProgramPath);
	if(a>b) c=a;
		else c=b;
	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(LILAC);
	MarsF(400-(c*.5), 248, 3, ORANGE, BLACK, ProgramName);
	PutsFont21(400-(c*.5),354,LAVENDER,ProgramPath);
}
void FilesMode()
{
	Files24Mode();
	WarmRecover();
}
void MakeLauncherBat() {
	char Arg1[5]; /* This allows LCARS 24 to get out of the way
			  completely when launching a resource-hungry DOS
			  program then restart fresh when that program is
			  closed, skipping the LCARS 24 startup fanfare */

	strcpy(Ln[0],"echo off");

	strcpy(Ln[1],"cd ");
	strcat(Ln[1],ProgramPath[PWy]);
	strcpy(Ln[2],get_filename(ProgramPath[PWy]));
	Ln[1][strlen(Ln[1])-strlen(Ln[2])-1]=(null); /* trim cd command */
	Ln[2][strlen(Ln[2])-4]=(null); /* trim execution command */

	strcpy(Ln[3],"cd ");
	strcat(Ln[3],LcarsPath);
	strcpy(Ln[4],LcarsExeName);
	strcat(Ln[4]," ");
	itoa(ScreenSize,Arg1,10); /* display size previously specified by the user */
	strcat(Ln[4],Arg1);
	strcat(Ln[4]," ");
	strcat(Ln[4],"skip"); /* skip intro */
	strcpy(Ln[5],"echo off");
	strcpy(Ln[6],"");
	EndText=6;
	strcpy(CurrentFile, "LAUNCH.BAT");
	SaveTextFile();
}

/*
int AppsMode()
{
}
*/

int DataMode()
{
	int Result;

repeat:
	PickMode=2;

	Result=LibraryWindowActive();
	if( Result==0 ) {
		WarmRecover();
		return(0);
	}
	if( Result==1 ) {
		strcpy(NewName, Ln[FileNum]);
		SetCurrentFile("\\DATA\\");
		strcat(CurrentFile, NewName);
		if( strnicmp("BMP", get_extension(NewName),3 )==0 ) {
			Viewscreen(CurrentFile);
			goto repeat;
		}
		if( strnicmp("JPG", get_extension(NewName),3 )==0 ) {
			Viewscreen(CurrentFile);
			goto repeat;
		}
		if( strnicmp("GIF", get_extension(NewName),3 )==0 ) {
			Viewscreen(CurrentFile);
			goto repeat;
		}
		if( strnicmp("TXT", get_extension(NewName),3 )==0 ) {
			LcReader(CurrentFile);
			goto repeat;
		}
		if( strnicmp("HTM", get_extension(NewName),3 )==0 ) {
			LcHtml(CurrentFile);
			goto repeat;
		}
		if( strnicmp("SFM", get_extension(NewName),3 )==0 ) {
			LcSfml(CurrentFile);
			goto repeat;
		}
		if( strnicmp("MSD", get_extension(NewName),3 )==0 ) {
			LcSfml(CurrentFile);
			goto repeat;
		}
	} else {
		WarmRecover();
		return(0);
	}
	return(0);
}
int StopBreak()
{
	WarmRecover();
	return(1);
}
void Intro()
{
	char Report[5];
	int pos;
	int GifNum;
	char filespec[80];
	char CmdStr[80];


	strcpy(filespec, LcarsPath);
	strcat(filespec, "\\SYSTEM\\GIF\\");

	if(EndGifList !=0) {
		srand( (unsigned int)time( NULL ) );
		GifNum=rand() % EndGifList;
		strcat(filespec,GifList[GifNum]);
	}

	install_timer();
	Brackets1(BracketColor1, BracketColor2);
	Boxes();
	if(ScreenSize==1024) Wrapper(60,30);
	LoadScorpioFont();
	LoadFont21();
	LoadMono13();
	MarsF(546, 10, 3, ORANGE, BLACK, "LCARS 24");
	ButtonType1(562,153,PALEBLUE,"SYSTEM INIT");
	PutsLuna(546,110,LAVENDER,BLACK,"V. 4.0.6 WINDOWS BUILD");
	itoa( DepthFound, Report, 10);
	pos=586+StrLenLuna("V. 4.0.6 WINDOWS BUILD");
	PutsLuna(pos,110, LILAC, BLACK, Report);
	PutsLuna(pos+StrLenLuna(Report),110, LILAC, BLACK, "-BIT COLOR");

	LoadFont19();
	LoadArial10();
	PutStarDate(180,68,MANGO);
	PanelBeep();
	rest(150);

	QuickGifView(filespec); 
/*
	strcpy(View360Path, LcarsPath);
	strcat(View360Path, "\\lc24apps\\view360\\");
	View360Init();
*/
	PutsFont21(180,518,BIGBLUE,"www.startrek.com");

	rest(1600);


	rectfill(screen,140,250,790,600, BLACK);
	if( BlasterOK==TRUE) {
		MarsF(270, 280-30, 4, PURPLE, BLACK, "GOING TO");
		MarsF(180, 414-30, 4, PURPLE, BLACK, "STANDBY MODE");
	} else {
		MarsF(250, 280-30, 4, PURPLE, BLACK, "SOUND CARD");
		MarsF(180, 414-30, 4, PURPLE, BLACK, "NOT RESPONDING");
	}

	rectfill(screen,559,144,671,190,BLACK);
	rest(200);
	ButtonType1(562,153,PALEBLUE,"SYSTEM INIT");

	FindOS();
/*
	if(DosDetected) PutsFont21(180,100, PALEBLUE, "DOS DETECTED");
		else {
			PutsFont21(180,100, ORANGE, "WINDOWS DETECTED");
			PutsFont21(180,132, ORANGE, "SHUTTING DOWN LCARS SOUND SYSTEM");
		}
*/

	SetCurrentFile("\\APPSLIST.TXT");
	if(exists(CurrentFile)) LoadAppList();
		else NoAppList=TRUE;
	SetCurrentFile("\\SYSTEM\\DOS-VER.TXT");
	if(! (exists(CurrentFile)) ) {
		strcpy(CmdStr,"ver>");
		strcat(CmdStr, CurrentFile);
		system(CmdStr);
	}
	LoadTextFile();
	strcpy(DosVerStr,Ln[1]);

	rectfill(screen,498+61,144,610+61,190,BLACK);
	LoadMapFonts();
	ButtonType1(562,153,PURPLE,"SYSTEM INIT");
	if(BlasterOK==TRUE) PanelBeep();
		else rest(350);
	rectfill(screen,498+61,144,610+61,190,BLACK);
	if(BlasterOK==TRUE) PanelBeep();
		else rest(200);
	ButtonType1(562,153,NAPLES,"ONLINE");
	ButtonType1(682,153,ORANGE,"ENABLED");
	strcpy(filespec, LcarsPath);
	strcat(filespec, "\\VOICE\\STANDING.WAV");
	LcarsPlayWav(filespec);
	rest(900);
	rectfill(screen,112,10,799,190,BLACK);
	rectfill(screen,112,250,790,590,BLACK);
	remove_timer();
}
int MathMode()
{
	min_old=70;
	BeepSet=TRUE;
	strcpy(CurrentPath,"");
	rectfill(screen,0,0,800,600, BLACK);
	Brackets1(BracketColor1,BracketColor2);
	Box1a(ORANGE, "CLEAR", "F10", "", "");
	Box2a(PALEBLUE, "RESTORE PREV");
	EscBox1b(LILAC, "CLOSE");
	Br1F2Box(PALEBLUE, "HELP", "F11");
	Box3bm(ORANGE);
	Box4bm(MANGO);
	Box5bm(BRICK);
	MarsF(780-(StrLenScorpio("MATH SERVICE")*2),10,2, ORANGE,BLACK,"MATH SERVICE");
	PutsLuna(780-(StrLenScorpio("MATH SERVICE")*2),110-28,PURPLE,BLACK,"EDITABLE INPUT LINE");
	rectfill(screen,14,130,109,130+14,BracketColor1);
	PutsLuna(106-StrLenLuna("INPUT EXPRESSION")+2, 130, BLACK,BracketColor1, "INPUT EXPRESSION");
	rectfill(screen,14,287-19,109,287+14,BracketColor2);
	PutsLuna(106-StrLenLuna("ANSWER"),287, BLACK,BracketColor2, "ANSWER");

	PutsFont21(140,338,BRICK,"+ (add)	- (subtract)	 * (multiply)	/ (divide)	^ or ** (exponent)");
	PutsFont21(140,395,MANGO,"acos, asin, atan, cos, sin, tan, exp, ln, log, sqrt, abs, cosh, sinh, tanh");

	PutsFont21(140,452,ORANGE,"2 + 2 ");
	EnterSymbol(140+StrLenFont21("2 + 2 "),452,1,MANGO);
	PutsFont21(250,452,ORANGE,"74/(1.83^2) ");
	EnterSymbol(250+StrLenFont21("74/(1.83^2) "),452,1,MANGO);
	PutsFont21(450,452,ORANGE,"atan(7) + 2*pi + sqrt(59) ");
	EnterSymbol(450+StrLenFont21("atan(7) + 2*pi + sqrt(59) "),452,1,MANGO);

	PutsFont21(300,509,BIGBLUE,"(pi or PI = 3.14159265358979323836)");
	MathLineInput();
	return(0);
}
void LcarsInit()
{
	BlasterOK=TRUE; /* was 10, set to TRUE/FALSE after test */
	MuteBeeps=FALSE;
	BeepSet=FALSE;

	m=1.25;	/* magnification factor from VGA for brackets */
	uy=200;	/* brackets: upper edge of divider */
	ly=217;	/* brackets: lower edge of divider */

	strcpy(CurrentTrack,"song");
	strcpy(TimeDisplay,"12:34");
	strcpy(DateDisplay,"01/01");
	strcpy(SecDisplay,"00");
	strcpy(SecWhenAlarmSet,"00"); /* to seed random music selection for alarm */
	strcpy(TimeSetting,"12:34");
	strcpy(DateSetting,"10/29");
	strcpy(YearDisplay,"2473");

	old_sec=70;
	min_old=70;
	day_old=32;
	SettingType=0;
	AlarmHour=5;
	AlarmMin=55;
	SingleAlarmOnOff=0;
	MidiPlaying=0;
	strcpy(AlarmString,"12:00 A.M.");
	DriveChange=0;
	DirectoryChange=0;
	CurrentDrive=2;
	strcpy(StarDate,"-300000.0");
	null=0;
	AlarmType=0;
	ColorScheme=0;
	AudioOff=FALSE; /* temporary if TRUE (for bad versions of DJGPP) */
	SnoozeVal=12;
	SnoozeAlarmMin=70;
	Endgame=0;
	MilitaryTime=0;
	DeltaHr=DeltaMn=DeltaSc=DeltaDa=DeltaMo=DeltaYr=0; /* fake time/date setting offsets */
	IdleTime=0;
	IdleLimit=270;
}


