/* 12/19/09 */

/*	 STARSHIP, an LCARS 24 applet to display, zoom, scroll
	a large jpeg chart of Starfleet vessels
*/

#include "starship.h"


void StpRefresh()
{
	blit(StpImage,StpBuf,StpOffsetX,StpOffsetY,0,0,718,500);

	if(StpZoom>1) stretch_blit(StpBuf,screen,0,0,718/2,500/2,41,50,718,500);
		else blit(StpBuf,screen,0,0,41,50,718,500);
}
int StpLoadJpegFile(char *filespec)
{
	rectfill(screen,0,50,800,550,BLACK);
	rectfill(screen,216,13,590,39,LILAC);
	PutsLuna(240,20, BLACK,LILAC, MakeDisplayName(CurrentFile));
	if(StarshipChart==1) PutsLuna(500,20, BLACK,LILAC, "NEXT: F10");
		else PutsLuna(500,20, BLACK,LILAC, "PREV: F10");
	MarsF(400-((StrLenMars(3,"LOADING CHART"))*.5), 244, 3, SKYBLUE, BLACK, "LOADING CHART");
	if (StpImage) destroy_bitmap(StpImage);
	StpImage = load_jpg(filespec, NULL);
	if (!StpImage) {
		NormalLoadError(filespec);
		return;
	}
	StpBuf = create_bitmap(718,500);
	set_palette(StpPalette);
	return(0);
}
void StarshipScreen()
{
	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LILAC);
	Title("STARFLEET VESSELS");
	PutsLuna(178,566, BLACK,LILAC, "SCROLL:");
	LeftArrowSymbol(228,566,BLACK);
	RightArrowSymbol(228+30,566,BLACK);
	UpArrowSymbol(228+60,566,BLACK);
	DownArrowSymbol(228+90,566,BLACK);
	PutsLuna(448,566, BLACK,LILAC, "ZOOM: F2");
	PutsLuna(679,566, BLACK,LILAC, "CLOSE: F12");
}
void StpScrollLeft(int Amount)
{
	if(StpOffsetX == 0) return;
	StpOffsetX -= Amount;
	if(StpOffsetX <= 0) StpOffsetX = 0;
	StpRefresh();
}
void StpScrollRight(int Amount)
{
	StpOffsetX += Amount;
	if(StpOffsetX >= StpImage->w-718/StpZoom) StpOffsetX = StpImage->w-718/StpZoom;
	StpRefresh();
}
void StpScrollUp(int Amount)
{
	if(StpOffsetY == 0) return;
	StpOffsetY -= Amount;
	if(StpOffsetY <= 0) StpOffsetY = 0;
	StpRefresh();
}
void StpScrollDown(int Amount)
{
	StpOffsetY += Amount;
	if(StpOffsetY >= StpImage->h-500/StpZoom) StpOffsetY = StpImage->h-500/StpZoom;
	StpRefresh();
}
int StarshipWindow()
{
	PopPutTime(1);
	StpRefresh();

loopback:

	do {
		PopPutTime(1);
	} while(!keypressed());

	c = GetKey();
	switch( c )
	{
		case F2: if(StpZoom==1) {
				StpZoom=2;
				StpOffsetX += 180;
				StpOffsetY += 125;
			} else {
				StpZoom=1;
				StpOffsetX -= 180;
				StpOffsetY -= 125;
			}
			if(StpOffsetX<0) StpOffsetX=0;
			if(StpOffsetY<0) StpOffsetY=0;
			if(StpOffsetX >= StpImage->w-718/StpZoom) StpOffsetX = StpImage->w-718/StpZoom;
			if(StpOffsetY >= StpImage->h-500/StpZoom) StpOffsetY = StpImage->h-500/StpZoom;
			StpRefresh();
			PanelBeep();
			goto loopback;
		case F10:
			if(StarshipChart==1) {
				SetCurrentFile("\\LC24APPS\\STARSHIP\\SHIPS2.JPG");
				StarshipChart=2;
				StpZoom=1;
				StpOffsetX = 0;
				StpOffsetY = 0;
				if(StpLoadJpegFile(CurrentFile)==0) {
					StpRefresh();
					PanelBeep();
				} else {
					NormalLoadError(CurrentFile);
					return(86);
				}
			} else {
				SetCurrentFile("\\LC24APPS\\STARSHIP\\SHIPS1.JPG");
				StarshipChart=1;
				StpZoom=1;
				StpOffsetX = 0;
				StpOffsetY = 0;
				if(StpLoadJpegFile(CurrentFile)==0) {
					StpRefresh();
					PanelBeep();
				} else {
					NormalLoadError(CurrentFile);
					return(86);
				}
			}
			goto loopback;
		case LEFTARROW: StpScrollLeft(64/StpZoom);
			goto loopback;
		case RIGHTARROW: StpScrollRight(64/StpZoom);
			goto loopback;
		case UPARROW: StpScrollUp(64/StpZoom);
			goto loopback;
		case DOWNARROW: StpScrollDown(64/StpZoom);
			goto loopback;
		case PGUPKEY:	StpScrollUp(256/StpZoom);
			goto loopback;
		case PGDNKEY:	StpScrollDown(256/StpZoom);
			goto loopback;
		case HOMEKEY:	StpScrollLeft(256/StpZoom);
			goto loopback;
		case ENDKEY:	 StpScrollRight(256/StpZoom);
			goto loopback;
		case F12: return(0);
		default: goto loopback;
	} while(1);
}
void StarshipInit()
{
	StpZoom=1;
	StpOffsetX = 0;
	StpOffsetY = 0;
	min_old=70;
	SetCurrentFile("\\LC24APPS\\STARSHIP\\SHIPS1.JPG");
	StarshipChart=1;
}
int StarshipMode()
{
	int Result;

	StarshipInit();
	StarshipScreen();
	if(StpLoadJpegFile(CurrentFile) !=0) {
		NormalLoadError(CurrentFile);
		return(86);
	}
	PanelBeep();
	Result=StarshipWindow();
	destroy_bitmap(StpImage);
	destroy_bitmap(StpBuf);
	return(0);
}


