/* 12/19/09 */
/* Timezone.c */


#include "timezone.h"


void LoadTimeZoneSetting()
{
	PACKFILE *Fp;

	SetCurrentFile("\\SYSTEM\\TIMEZONE.LC");
	if ( ( Fp=pack_fopen(CurrentFile, "rb" ))==NULL ) {
		TzLocal=16;  /* 16 = Japan */
		return;
	} else{
		TzLocal=pack_getc(Fp);
		TzLocal=pack_getc(Fp);
	}
	pack_fclose( Fp );
}
void SaveTimeZoneSetting()
{
	PACKFILE *Fp;

	SetCurrentFile("\\SYSTEM\\TIMEZONE.LC");
	if ( ( Fp=pack_fopen(CurrentFile, "wb" ))==NULL ) {
		return;
	} else{
		pack_putc( TzLocal, Fp);
		pack_putc( TzLocal, Fp);
	}
	pack_fclose( Fp );
}

void TzDay(int x, int y, int Color, int current, int tabnum)
{
	time_t tx;
	struct tm *pt;
	int daynum;
	static char DayDisplay [7][12]={
		"SUNDAY",
		"MONDAY",
		"TUESDAY",
		"WEDNESDAY",
		"THURSDAY",
		"FRIDAY",
		"SATURDAY"
	};

	time(&tx);
	pt=localtime(&tx);
	daynum=pt->tm_wday;

	if(tabnum > TzLocal) ++daynum;
	if(daynum > 6) daynum=0;

	if(current==0) {
		--daynum;
		if(daynum < 0) daynum=6;
		x -= StrLenLuna(DayDisplay[daynum]);
		x -= 7;
	}

	PutsLuna(x+4,y, Color, BLACK, DayDisplay[daynum]);
}

void TzRawTime()
{
	time_t x;
	struct tm *pt;
	int sec;

	time(&x);
	pt=localtime(&x);
	TzMin=pt->tm_min;
	TzHr=pt->tm_hour;
	TzMinOld=TzMin;

	sec=pt->tm_sec;
	if (old_sec != sec ) CheckIdle();
	old_sec=sec;
}

void TzEraseCursor(int TzLocal)
{
	int x,y;

	y=58;
	if(TzLocal > 7) x=119+(TzLocal*30);
	if(TzLocal < 7) x=98+(TzLocal*30);
	rectfill(screen,x+6-28,y,x+10+28, y+42+12,BLACK);
}
int TzFindColor(int tabnum)
{
	switch( tabnum )
		{
		case -1: return(BIGBLUE);
		case 0: return(PURPLE);
		case 1: return(MANGO);
		case 2: return(PALEBLUE);
		case 3: return(BIGBLUE);
		case 4: return(PURPLE);
		case 5: return(MANGO);
		case 6: return(PALEBLUE);

		case 8: return(MANGO);
		case 9: return(PALEBLUE);
		case 10: return(BIGBLUE);
		case 11: return(PURPLE);
		case 12: return(MANGO);
		case 13: return(PALEBLUE);
		case 14: return(PURPLE);
		case 15: return(MANGO);
		case 16: return(PALEBLUE);
		case 17: return(BIGBLUE);
		case 18: return(PURPLE);
		case 19: return(MANGO);
		default: return(MANGO);
	}
}
void TzCursor(int TzLocal)
{
	int x,y,a,a2,b,Hue;

	Hue=TzFindColor(TzLocal);

	y=58;
	if(TzLocal > 7) x=119+(TzLocal*30);
	if(TzLocal < 7) x=98+(TzLocal*30);
	a = x+7;
	a2 = a+2;

	rectfill(screen,x+6-28,y,x+10+28, y+42+12,BLACK);
	rectfill(screen,x+6-28,y,x+10+28, y+42,Hue);
	PutsLuna(x+31-35,y+5,BLACK,Hue,  "YOUR");
	PutsLuna(x+20-37,y+24,BLACK,Hue,"TIME ZONE");

	y+=35;
	putpixel(screen, x+8,y+16,Hue);
	b = y+15;
	while(a >=x ) {
		hline(screen,a,b,a2,Hue);
		--a;
		++a2;
		--b;
	}
}

int TzLoadMap(char *filespec)
{
	BITMAP *the_image;
	PALETTE the_palette;
	int x,y;

	MarsF(400-((StrLenMars(3,"LOADING MAP"))*.5), 244, 3, PURPLE, BLACK, "LOADING MAP");
	the_image=load_bitmap(filespec, the_palette);
	if (!the_image) return(86);

	if(DepthFound > 8) set_palette(the_palette);
	rectfill(screen,0,50,800,550, BLACK); /* erase "LOADING MAP" */

	x=63;
	y=201;
	blit(the_image, screen, 0, 0, x, y, the_image->w, the_image->h);
	destroy_bitmap(the_image);
	return(0);
}
int TimeZoneScreen()
{
	int Result;

	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(LILAC);
	Title("WORLD TIME");
	PutsLuna(178,566, BLACK,LILAC, "SET YOUR TIME ZONE:");
	LeftArrowSymbol(298,566,BLACK);
	RightArrowSymbol(298+30,566,BLACK);
	PutsLuna(600+6,575-9, BLACK,LILAC, "INFO: F11");
	PutsLuna(676,575-9, BLACK,LILAC, "CLOSE: F12");

	
	if(Endgame==0) SetCurrentFile("\\LC24APPS\\TIMEZONE\\TZ.BMP");
		else SetCurrentFile("\\LC24APPS\\TIMEZONE\\TZ-EG.BMP");
	Result=TzLoadMap(CurrentFile);
	if(Result !=0) return(86);

	PutsLuna(47,418, NAPLES,BLACK,"MARQUESAS IS.");
	PutsLuna(47,418+19, NAPLES,BLACK,"PITCAIRN IS.");
	PutsLuna(47,418+(19*2), NAPLES,BLACK,"NEWFOUNDLAND");

	PutsLuna(300,418, NAPLES,BLACK,"NEPAL");
	PutsLuna(300,418+19, NAPLES,BLACK,"IRAN");
	PutsLuna(300,418+(19*2), NAPLES,BLACK,"AFGHANISTAN");
	PutsLuna(300,418+(19*3), NAPLES,BLACK,"INDIA/SRI LANKA");

	PutsLuna(560,418, NAPLES,BLACK,"BURMA/KEELING IS.");
	PutsLuna(560,418+19, NAPLES,BLACK,"CENTRAL AUSTRALIA");
	PutsLuna(560,418+(19*2), NAPLES,BLACK,"LORD HOWE IS.");
	PutsLuna(560,418+(19*3), NAPLES,BLACK,"NORFOLK IS.");

/* PutsBlock11(screen,42,134,ORANGE,"STANDARD"); */
	PutsBlock11(screen,42,487,ORANGE,"DAYLIGHT SAVINGS");
	PutsBlock11(screen,47,487+15,ORANGE,"Spring to Autumn:");
	PutsBlock11(screen,47,487+30,ORANGE,"Autumn to Spring:");
	PutsBlock11(screen,47,487+45,ORANGE,"Never:");

	PutsBlock11(screen,150,502,PURPLE,"North, Egypt, Jordan, Syria, Israel, Iraq, Iran, Lebanon, Kyrgyzstan 1 hour ahead, Russia 2 hours ahead");
	PutsBlock11(screen,150,517,PURPLE,"Chile, Paraguay, Namibia, Australia, New Zealand, Russia, Jordan 1 hour ahead");
	PutsBlock11(screen,150,532,PURPLE,"Tropics, Japan, China, Mongolia, Arizona, Saskatchewan, Equatorial Brazil");

	PutsBlock11(screen,245,293,PURPLE,"New York");
	PutsBlock11(screen,148-StrLenB11("San Francisco"),293,MANGO,"San Francisco");
	PutsBlock11(screen,100,325,BIGBLUE,"Hawaii");

	PutsBlock11(screen,354-StrLenB11("London"),275,MANGO,"London");
	PutsBlock11(screen,386-StrLenB11("Oslo"),248,PALEBLUE,"Oslo");
	PutsBlock11(screen,226-StrLenB11("Lima"),354,PURPLE,"Lima");
	PutsBlock11(screen,240-StrLenB11("Santiago"),378,MANGO,"Santiago");
	PutsBlock11(screen,299,376,PALEBLUE,"Rio de Janeiro");
	PutsBlock11(screen,637,303,PALEBLUE,"Tokyo");
	PutsBlock11(screen,659,382,BIGBLUE,"Sydney");
	PutsBlock11(screen,410,394,BIGBLUE,"Cape Town");
	PutsBlock11(screen,555,288,BLACK,"Beijing");
	PutsBlock11(screen,607,324,MANGO,"Manila");
	PutsBlock11(screen,257,319,MANGO,"Caracas");
	PutsBlock11(screen,583-StrLenB11("Perth"),385,MANGO,"Perth");
	PutsBlock11(screen,562-StrLenB11("Jakarta"),354,PURPLE,"Jakarta");
	return(0);
}
void TzDrawWestTag(int x, int y, int Hue, int Hour, char *MinStr)
{
	char HourStr[4];
	char AmPmStr[3]="AM";
	int AmPmX=6;
	int tabnum=x;

	x = (x * 30) + 93;
	y = 130-14;

	if(Hour < 0) Hour +=24;
	if(Hour >= 24) Hour -=24;
	if(Hour==0) {
		TzDay(x, y+66, Hue, 1, tabnum);
		if(tabnum > -1) TzDay(x, y+66, TzFindColor(tabnum-1), 0, tabnum);
	}
/* special cases of displaying days of the week because of unused zones */

/*
	if(tabnum==1 && Hour==1 ) {
		TzDay(x, y+66, Hue, 1, tabnum);
		TzDay(x, y+66, TzFindColor(tabnum-1), 0, tabnum);
	}
*/

	if(tabnum==-1 && (Hour==0 || Hour==1) ) {
		TzDay(x, y+66, Hue, 1, tabnum);
	}

	if(Hour >= 12) {
		Hour -=12;
		strcpy(AmPmStr,"PM");
		AmPmX=8;
	}
	if(Hour==0) Hour=12;

	rectfill(screen,x+2,y,x+26,y+61,Hue);
/* rectfill(screen,x,y,x+28,y+61,Hue); */
	itoa(Hour, HourStr, 10);
	PutsLuna(x+21-(6*strlen(HourStr)),y+5,BLACK,Hue,HourStr);
	PutsLuna(x+21-(6*strlen(MinStr)),y+24,BLACK,Hue,MinStr);
	if(strlen(MinStr)==1) PutsLuna(x+9,y+24,BLACK,Hue,"0");
	PutsLuna(x+AmPmX,y+24+19,BLACK,Hue,AmPmStr);
}
void TzDrawEastTag(int x, int y, int Hue, int Hour, char *MinStr)
{
	char HourStr[4];
	char AmPmStr[3]="AM";
	int AmPmX=6;
	int tabnum=x;

	x = (x * 30) + 114;
	y = 130-14;

	if(Hour < 0) Hour +=24;
	if(Hour >= 24) Hour -=24;
	if(Hour==0) {
		TzDay(x, y+66, Hue, 1, tabnum);
		if(tabnum==8) TzDay(x, y+66, PALEBLUE, 0, tabnum);
			else TzDay(x, y+66, TzFindColor(tabnum-1), 0, tabnum);
	}

/* special cases of displaying days of the week because of unused zones */
	if(tabnum==8 && (Hour==1 || Hour==2)) {
		TzDay(x, y+66, Hue, 1, tabnum);
		if(tabnum==8) TzDay(x, y+66, PALEBLUE, 0, tabnum);
			else TzDay(x, y+66, TzFindColor(tabnum-1), 0, tabnum);
	}
	if(tabnum==14 && Hour==1) {
		TzDay(x, y+66, Hue, 1, tabnum);
		if(tabnum==8) TzDay(x, y+66, PALEBLUE, 0, tabnum);
			else TzDay(x, y+66, TzFindColor(tabnum-1), 0, tabnum);
	}


	if(Hour >= 12) {
		Hour -=12;
		strcpy(AmPmStr,"PM");
		AmPmX=8;
	}
	if(Hour==0) Hour=12;

	rectfill(screen,x+2,y,x+26,y+61,Hue);
	itoa(Hour, HourStr, 10);
	PutsLuna(x+21-(6*strlen(HourStr)),y+5,BLACK,Hue,HourStr);
	PutsLuna(x+21-(6*strlen(MinStr)),y+24,BLACK,Hue,MinStr);
	if(strlen(MinStr)==1) PutsLuna(x+9,y+24,BLACK,Hue,"0");
	PutsLuna(x+AmPmX,y+24+19,BLACK,Hue,AmPmStr);
}
void TzDrawLowerClock(int x, int y, int Hour, char *MinStr)
{
	char HourStr[4];
	char AmPmStr[3]="AM";
	char OutputStr[9];
	int AmPmX=6;

	if(x==1) x=177;
	if(x==2) x=430;
	if(x==3) x=690;

	y = 430-14+(y*19);

	if(Hour < 0) Hour +=24;
	if(Hour >= 24) Hour -=24;
	if(Hour >= 12) {
		Hour -=12;
		strcpy(AmPmStr,"PM");
		AmPmX=8;
	}
	if(Hour==0) Hour=12;

	rectfill(screen,x,y,x+52,y+14,BLACK);
	itoa(Hour, HourStr, 10);

	strcpy(OutputStr," ");
	if(strlen(HourStr)==1) strcat(OutputStr,HourStr);
		else strcpy(OutputStr,HourStr);
	strcat(OutputStr,":");
	if(strlen(MinStr)==2) strcat(OutputStr,MinStr);
		else {
			strcat(OutputStr,"0");
						strcat(OutputStr,MinStr);

		}
	strcat(OutputStr," ");
	strcat(OutputStr,AmPmStr);

	PutsLuna(x,y,NAPLES,BLACK,OutputStr);
}
void TzDrawInMapClock(int x, int y, int Hour, char *MinStr, int Color)
{
	char HourStr[4];
	char AmPmStr[3]="AM";
	char OutputStr[9];
	int AmPmX=6;


	if(Hour < 0) Hour +=24;
	if(Hour >= 24) Hour -=24;
	if(Hour >= 12) {
		Hour -=12;
		strcpy(AmPmStr,"PM");
		AmPmX=8;
	}
	if(Hour==0) Hour=12;

	rectfill(screen,x,y,x+52,y+14,BLACK);
	itoa(Hour, HourStr, 10);

/*
	strcpy(OutputStr," ");
	if(strlen(HourStr)==1) strcat(OutputStr,HourStr);
		else
*/
	strcpy(OutputStr,HourStr);
	strcat(OutputStr,":");
	if(strlen(MinStr)==2) strcat(OutputStr,MinStr);
		else {
			strcat(OutputStr,"0");
						strcat(OutputStr,MinStr);

		}
	strcat(OutputStr," ");
	strcat(OutputStr,AmPmStr);

	PutsBlock11(screen,x,y,Color,OutputStr);
}
void TzShowTags(int TzLocal)
{
	char MinStr[3];
	int UCT, hr, min;

	rectfill(screen,0,196-14,800,210-14,BLACK);	  /* erase day names */
/* rectfill(screen,0,391,800,405,BLACK); */ /* erase lower names */

	TzRawTime();
	itoa(TzMin,MinStr,10);

	switch( TzLocal )
		{
		case -1: {UCT=TzHr+10; break;}
		case 0: {UCT=TzHr+9; break;}
		case 1: {UCT=TzHr+8; break;}
		case 2: {UCT=TzHr+7; break;}
		case 3: {UCT=TzHr+6; break;}
		case 4: {UCT=TzHr+5; break;}
		case 5: {UCT=TzHr+4; break;}
		case 6: {UCT=TzHr+3; break;}

		case 8: {UCT=TzHr; break;}
		case 9: {UCT=TzHr-1; break;}
		case 10: {UCT=TzHr-2; break;}
		case 11: {UCT=TzHr-3; break;}
		case 12: {UCT=TzHr-4; break;}
		case 13: {UCT=TzHr-5; break;}
		case 14: {UCT=TzHr-7; break;}
		case 15: {UCT=TzHr-8; break;}
		case 16: {UCT=TzHr-9; break;}
		case 17: {UCT=TzHr-10; break;}
		case 18: {UCT=TzHr-11; break;}
		case 19: {UCT=TzHr-12; break;}
		default: {UCT=TzHr; break;}
	}


	TzDrawWestTag(-1,0,BIGBLUE,UCT-10,MinStr);
	TzDrawWestTag(0,0,PURPLE,UCT-9,MinStr);
	TzDrawWestTag(1,0,MANGO,UCT-8,MinStr);
	TzDrawWestTag(2,0,PALEBLUE,UCT-7,MinStr);
	TzDrawWestTag(3,0,BIGBLUE,UCT-6,MinStr);
	TzDrawWestTag(4,0,PURPLE,UCT-5,MinStr);
	TzDrawWestTag(5,0,MANGO,UCT-4,MinStr);
	TzDrawWestTag(6,0,PALEBLUE,UCT-3,MinStr);

	TzDrawEastTag(8,0,MANGO,UCT,MinStr);
	TzDrawEastTag(9,0,PALEBLUE,UCT+1,MinStr);
	TzDrawEastTag(10,0,BIGBLUE,UCT+2,MinStr);
	TzDrawEastTag(11,0,PURPLE,UCT+3,MinStr);
	TzDrawEastTag(12,0,MANGO,UCT+4,MinStr);

	TzDrawEastTag(13,0,PALEBLUE,UCT+5,MinStr);
	TzDrawEastTag(14,0,PURPLE,UCT+7,MinStr);
	TzDrawEastTag(15,0,MANGO,UCT+8,MinStr);  /* China */

	TzDrawEastTag(16,0,PALEBLUE,UCT+9,MinStr);
	TzDrawEastTag(17,0,BIGBLUE,UCT+10,MinStr);
	TzDrawEastTag(18,0,PURPLE,UCT+11,MinStr);
	TzDrawEastTag(19,0,MANGO,UCT+12,MinStr);

/* Norfolk Island */
	hr=UCT+11;
	min=TzMin+30;
	if(min >= 60) {
		min -=60;
		hr += 1;
	}
	itoa(min,MinStr,10);
	TzDrawLowerClock(3,3,hr,MinStr);

/* Lord Howe Islands */
	hr=UCT+10;
	min=TzMin+30;
	if(min >= 60) {
		min -=60;
		hr += 1;
	}
	itoa(min,MinStr,10);
	TzDrawLowerClock(3,2,hr,MinStr);

/* central Australia */
	hr=UCT+9;
	min=TzMin+30;
	if(min >= 60) {
		min -=60;
		hr += 1;
	}
	itoa(min,MinStr,10);
	TzDrawLowerClock(3,1,hr,MinStr);

/* Burma */
	hr=UCT+6;
	min=TzMin+30;
	if(min >= 60) {
		min -=60;
		hr += 1;
	}
	itoa(min,MinStr,10);
	TzDrawLowerClock(3,0,hr,MinStr);

/* India */
	hr=UCT+5;
	min=TzMin+30;
	if(min >= 60) {
		min -=60;
		hr += 1;
	}
	itoa(min,MinStr,10);
	TzDrawLowerClock(2,3,hr,MinStr);

/* Afghanistan */
	hr=UCT+4;
	min=TzMin+30;
	if(min >= 60) {
		min -=60;
		hr += 1;
	}
	itoa(min,MinStr,10);
	TzDrawLowerClock(2,2,hr,MinStr);

/* Iran */
	hr=UCT+3;
	min=TzMin+30;
	if(min >= 60) {
		min -=60;
		hr += 1;
	}
	itoa(min,MinStr,10);
	TzDrawLowerClock(2,1,hr,MinStr);

/* Nepal */
	hr=UCT+5;
	min=TzMin+45;
	if(min >= 60) {
		min -=60;
		hr += 1;
	}
	itoa(min,MinStr,10);
	TzDrawLowerClock(2,0,hr,MinStr);

/* Newfoundland */
	hr=UCT-4;
	min=TzMin+30;
	if(min >= 60) {
		min -=60;
		hr += 1;
	}
	itoa(min,MinStr,10);
	TzDrawLowerClock(1,2,hr,MinStr);

/* Pitcairn */
	hr=UCT-9;
	min=TzMin+30;
	if(min >= 60) {
		min -=60;
		hr += 1;
	}
	itoa(min,MinStr,10);
	TzDrawLowerClock(1,1,hr,MinStr);

/* Marquesas Islands */
	hr=UCT-10;
	min=TzMin+30;
	if(min >= 60) {
		min -=60;
		hr += 1;
	}
	itoa(min,MinStr,10);
	TzDrawLowerClock(1,0,hr,MinStr);

/* Special case: Hawaii, outer Aleutian Islands */
	hr=UCT-10;
	min=TzMin;
	if(min >= 60) {
		min -=60;
		hr += 1;
	}
	itoa(min,MinStr,10);
	TzDrawInMapClock(715,280,hr,MinStr,BIGBLUE);
}
void TzDoHelp()
{
	char HelpPath[80];

	strcpy(HelpPath, LcarsPath);
	strcat(HelpPath,"\\LC24APPS\\TIMEZONE\\TIMEZONE.TXT");
	OpenHelp(HelpPath);
	min_old=70;
}

int TimeZoneWindow()
{
	int LocalMinutes;

	LocalMinutes=PopPutTime(1);
	LoadTimeZoneSetting();
	TzShowTags(TzLocal);
	PanelBeep();
loopback:

	TzCursor(TzLocal);

	do {
		LocalMinutes=PopPutTime(1);
		if(TzMin != LocalMinutes) TzShowTags(TzLocal);

	} while(!keypressed());
	c = GetKey();
	switch( c )
		{
		case LEFTARROW: if(TzLocal < 0) goto loopback;
			TzEraseCursor(TzLocal);
			--TzLocal;
			if(TzLocal==7) --TzLocal;
			TzShowTags(TzLocal);
			TzSettingAction=1;
			goto loopback;
		case RIGHTARROW: if(TzLocal > 18) goto loopback;
			TzEraseCursor(TzLocal);
			++TzLocal;
			if(TzLocal==7) ++TzLocal;
			TzShowTags(TzLocal);
			TzSettingAction=1;
			goto loopback;
		case UPARROW:
			goto loopback;
		case DOWNARROW:
			goto loopback;
		case PGUPKEY:
		case PGDNKEY:
		case HOMEKEY:
		case ENDKEY:
			goto loopback;
		case F11: TzDoHelp();
			min_old=70;
			TzMinOld=70;
			goto loopback;
		case CTRL_F1: Screenshot792("timezone.bmp");
			goto loopback;
		case F12: return(0);
		default: goto loopback;
	}
}
void TimeZoneInit()
{
	min_old=70;
	TzMinOld=70;
	TzMin=70;
}
int TimeZoneMode()
{
	int Result;

	TimeZoneInit();
	if(TimeZoneScreen()) {
		NormalLoadError(CurrentFile);
		return(86);
	}
	TzSettingAction=0;
	Result=TimeZoneWindow();
	if(TzSettingAction !=0) SaveTimeZoneSetting();
	return(Result);
}

/* eof */


