/* 12/19/09 */

/* 	View360.H, a small embedded LCARS 24 program to allow the
	user to view an object and spin it around 360 degrees
*/

#include "view360.h"


void View360LabelTopView()
{
	PutsFont21(200,500,PALEBLUE,"DORSAL VIEW");

	SchematicLabel(200, 260, 518, 403, "WARP-CORE MODULE", BIGBLUE,TAN);
	SchematicLabel(200, 280, 378, 325, "PHASER BANKS", BRICK,TAN);
	SchematicLabel(200, 300, 334, 397, "TRACTOR EMITTERS", PURPLE,TAN);
	SchematicLabel(200, 320, 271, 421, "HELM", MANGO,TAN);
}
void View360LabelSideView()
{
	PutsFont21(150,280,PALEBLUE,"LATERAL VIEW");

	SchematicLabel(150, 340, 408-50, 416, "HULL-SEPARATION FLANGE", MANGO, TAN);
	SchematicLabel(150, 360, 375-50, 411, "LATERAL SENSOR STRIP", PURPLE,TAN);
	SchematicLabel(150, 380, 331-50, 431, "MAIN HATCH", MANGO,TAN);

	SchematicLabel(150, 490, 356-50, 450, "DEFLECTOR EMITTERS", PURPLE,TAN);
	SchematicLabel(150, 510, 393-50, 450, "PHASER BANKS", BRICK,TAN);
	SchematicLabel(150, 530, 416-50, 469, "BUSSARD COLLECTOR", ORANGE,TAN);

	SchematicLabel(520, 490, 490-50, 448, "PHASER BANKS", BRICK,TAN);
	SchematicLabel(520, 510, 474-50, 486, "STANDARD WARP NACELLE", BIGBLUE,TAN);
	SchematicLabel(520, 530, 457-50, 476, "BUSSARD RAMSCOOP", ORANGE,TAN);

	SchematicLabel(300, 300, 546-50, 419, "IMPULSE-ENGINE COWLING", MANGO,TAN);
	SchematicLabel(300, 320, 522-50, 360, "WARP-CORE MODULE", BIGBLUE,TAN);

	SchematicLabel(650, 300, 571-50, 329, "ATTACHED POD", MANGO,TAN);
	SchematicLabel(650, 320, 603-50, 427, "FLUSH VENTS", BIGBLUE,TAN);
	SchematicLabel(650, 340, 623-50, 372, "MANEUVERING THRUSTERS", BIGBLUE,TAN);
}
void View360LabelRearView()
{
	PutsFont21(200,500,PALEBLUE,"AFT VIEW");

	SchematicLabel(200, 280, 551, 336, "MISSION-SPECIFIC POD ATTACHED", MANGO,TAN);
	SchematicLabel(200, 300, 525, 365, "WARP-CORE MODULE", BIGBLUE,TAN);
	SchematicLabel(200, 320, 507, 369, "MANEUVERING THRUSTERS", BIGBLUE,TAN);
	SchematicLabel(200, 340, 497, 422, "LIVING QUARTERS", MANGO,TAN);

	SchematicLabel(200, 400, 433, 437, "IMPLUSE DRIVE", BIGBLUE,TAN);
	SchematicLabel(200, 420, 386, 450, "STANDARD WARP NACELLE", BIGBLUE,TAN);

	SchematicLabel(650, 380, 557, 444, "PHASER BANKS", BRICK,TAN);
}
void View360LabelFrontView()
{
	PutsFont21(200,500,PALEBLUE,"FORE VIEW");

	SchematicLabel(200, 280, 548, 331, "MISSION-SPECIFIC POD ATTACHED", MANGO,TAN);
	SchematicLabel(200, 300, 518, 359, "WARP-CORE MODULE", BIGBLUE,TAN);
	SchematicLabel(200, 320, 506, 425, "FLIGHT DECK", MANGO,TAN);

	SchematicLabel(200, 360, 482, 468, "MICROTORPEDO TUBES", BRICK,TAN);
	SchematicLabel(200, 380, 451, 444, "PHASER BANKS", BRICK,TAN);
	SchematicLabel(200, 400, 433, 435, "IMPLUSE DRIVE", BIGBLUE,TAN);
	SchematicLabel(200, 420, 386, 448, "STANDARD WARP NACELLE", BIGBLUE,TAN);
}

void View360SortFiles()
{
	char bag[80];
	int f;
	int r=0;
	char done,ch;
	int z,i;

	for( z=0; z<NumOfFiles; ++z) {
		for( i=0; i<80; ++i) {
				ch=View360FileArray[z][i];
				if( ch !=(null) ) ch=toupper(ch);
				View360FileArray[z][i]=ch;
		}
	}
	do {
		done=TRUE;
		for (f=0; f<NumOfFiles; ++f) {
			r=stricmp(View360FileArray[f],View360FileArray[f+1]);
			if( r > 0 )	 {
				strcpy(bag,View360FileArray[f]);
				strcpy(View360FileArray[f],View360FileArray[f+1]);
				strcpy(View360FileArray[f+1],bag);
				done=FALSE;
			}
		}
	} while ( done==FALSE );
}
void View360FilterFiles(char *mask)
{
	struct al_ffblk fblock;
	int Found;

	NumOfFiles=0;
	Found=al_findfirst(mask, &fblock, FA_ARCH);
	while ( !Found ) {
		NumOfFiles++;
		strcpy(View360FileArray[NumOfFiles], fblock.name);
		Found=al_findnext( &fblock );
	}
	al_findclose( &fblock );
}


int View360OneJpeg(char *filespec)
{
	BITMAP *the_image;

	the_image=load_jpg(filespec, NULL);
	if (!the_image) return(86);
	blit(the_image, screen, 0, 0, 200, 270, the_image->w, the_image->h);
	destroy_bitmap(the_image);
	return(0);
}
void View360SpecsDanube()
{
	PutsLuna(140,10,MANGO,BLACK, "TYPE:");
	PutsLuna(240,10,PALEBLUE,BLACK, "GP INTERSTELLAR CRAFT (RUNABOUT)");
	PutsLuna(140,34,MANGO,BLACK, "COMMISSIONED:");
	PutsLuna(240,34,PALEBLUE,BLACK, "2365, UTOPIA PLANITIA, STARFLEET");
	PutsLuna(140,58,MANGO,BLACK, "DIMENSIONS:");
	PutsLuna(240,58,PALEBLUE,BLACK, "W: 13.7 M, H: 5.4 M, L: 23.1 M");
	PutsLuna(140,82,MANGO,BLACK, "MASS:");
	PutsLuna(240,82,PALEBLUE,BLACK, "158.7 M.T.");
	PutsLuna(140,106,MANGO,BLACK, "CRUISING SPEED:");
	PutsLuna(240,106,PALEBLUE,BLACK, "WARP 4");
	PutsLuna(140,130,MANGO,BLACK, "CREW:");
	PutsLuna(240,130,PALEBLUE,BLACK, "1-4");
	PutsLuna(140,154,MANGO,BLACK, "PHASERS:");
	PutsLuna(240,154,PALEBLUE,BLACK, "6 TYPE IV");
	PutsLuna(140,178,MANGO,BLACK, "TORPEDOES:");
	PutsLuna(240,178,PALEBLUE,BLACK, "24 MICRO (2 TUBES)");
}
void View360Box1a(int Hue)
{
	int boxtop;

	boxtop = 10;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
	PutsLuna(14,boxtop+35, BLACK, Hue, "CLOSE");
	PutsLuna(107-StrLenLuna("F12"),boxtop+35, BLACK, Hue, "F12");
}
void View360Box2a(int Hue)
{
	int boxtop;

	boxtop = 68;
	rectfill(screen,10,boxtop,110,boxtop+54, Hue);
	PutsLuna(107-StrLenLuna("SPECS"),boxtop+35, BLACK, Hue, "SPECS");
}
void View360Box1b(int Hue, char *Str)
{
	int boxtop;

	boxtop=590 - 54;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, Str);
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F1");
}
void View360Box2b(int Hue, char *Str)
{
	int boxtop;

	boxtop=590 - (54*2) - 3;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, Str);
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F2");
}
void View360Box3b(int Hue, char *Str)
{
	int boxtop;

	boxtop=590 - (54*3) - 6;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, Str);
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F3");
}
void View360Box4b(int Hue, char *Str)
{
	int boxtop;

	boxtop=590 - (54*4) - 9;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, Str);
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F4");
}
void View360Box5b(int Hue, char *Str)
{
	int boxtop;

	boxtop=590 - (54*5) - 12;
	rectfill(screen,10,boxtop,110,boxtop+53,Hue);
	PutsLuna(14,boxtop + 4, BLACK,Hue, Str);
	PutsLuna(96,boxtop + 4, BLACK,Hue, "F5");
}

void View360Prompt(int Col1, int Col2, int Level, char *Message)
{
	ButtonType3(597, Level, Col1, Col2, Message);
	LeftArrowSymbol(597+118, Level+8, NAPLES);
	RightArrowSymbol(597+118+18, Level+14, NAPLES);
}
void View360Screen()
{
	m=1.25;	/* magnification factor from VGA for brackets */
	uy=200;	/* brackets: upper edge of divider */
	ly=217;	/* brackets: lower edge of divider */

/*	Wrapper(60,30); */

	rectfill(screen,0,0,800,600, BLACK);
	Brackets1(BIGBLUE, PALEBLUE);
	View360Box1a(LILAC);
	View360Box2a(PALEBLUE);
	View360Box5b(MANGO, "VIEW 360");
	View360Box4b(BIGBLUE, "TOP");
	View360Box3b(BIGBLUE, "SIDE");
	View360Box2b(BIGBLUE, "FRONT");
	View360Box1b(BIGBLUE, "REAR");

	MarsF(773-(StrLenMars(2,"DANUBE CLASS")),10,2, ORANGE,BLACK,"DANUBE CLASS");
	PutsLuna(773-(StrLenMars(2,"DANUBE CLASS")),110-28,PURPLE,BLACK,"DESIGN: RICK STERNBACH & JIM MARTIN");
	PutsLuna(773-(StrLenMars(2,"DANUBE CLASS")),110-28+24,PURPLE,BLACK,"CGI: THOMAS SLANITZ, SCHEMATICS: STARTREK4U.COM");
	ButtonType1(500+62,153,MANGO,"IMAGE");
	ButtonType1(620+62,153,BIGBLUE,"SCHEMATIC");

/*
	PutsLuna(107-StrLenLuna("EXTERIOR VIEW"),286, BLACK, PALEBLUE, "EXTERIOR VIEW");

	PutsLuna(107-StrLenLuna("EXTERIOR VIEW"),312, BLACK, BIGBLUE, "EXTERIOR VIEW");
*/

	View360SpecsDanube();
}
void View360ShowOneFrame()
{
	char filespec[80];

	strcpy(filespec, JpegPath);
	strcat(filespec, View360FileArray[FrameNum+1]);
	View360OneJpeg(filespec);

	rest(41);
}
void View360Pirouette()
{
	int z;

	FrameNum=0;
	for(z=2; z<=NumOfFiles; ++z) {
		FrameNum++;
		View360ShowOneFrame();
	}
	FrameNum=1;
	View360ShowOneFrame();
}

int View360LoadSchematic(int x, int y, char *filespec)
{
	BITMAP *the_image;
	PALETTE the_palette;

	the_image=load_bitmap(filespec, the_palette);
	if (!the_image) return(86);
	if(DepthFound > 8) set_palette(the_palette);
	blit(the_image, screen, 0, 0, x, y, the_image->w, the_image->h);
	destroy_bitmap(the_image);
	return(0);
}

int View360WindowActive()
{

loopback:

silent:
	do {
		UpdateIdle();
	} while(!keypressed());
	c = GetKey();
	switch( c )
		{
			case F12: return(0);
			case 13:  		goto loopback;
			case LEFTARROW:	  if(View360Function !=5 ) goto loopback;
							FrameNum++;
							if(FrameNum > NumOfFrames-1) FrameNum=0;
							View360ShowOneFrame();
							goto silent;
			case RIGHTARROW:	 if(View360Function !=5 ) goto loopback;
							FrameNum--;
							if(FrameNum < 0) FrameNum=NumOfFrames-1;
							View360ShowOneFrame();
							goto silent;
			case DOWNARROW: 	goto loopback;
			case UPARROW: 		goto loopback;
			case F1:			if(View360Function==1) goto loopback;
							strcpy(SchematicPath,View360Path);
							strcat(SchematicPath,"\\data\\");
							strcat(SchematicPath,"rear.bmp");
							rectfill(screen,140,250,790,600, BLACK);
							View360LoadSchematic(203+176,325,SchematicPath);
							View360LabelRearView();
							View360Function=1;
							goto loopback;
			case F2:			if(View360Function==2) goto loopback;
							strcpy(SchematicPath,View360Path);
							strcat(SchematicPath,"\\data\\");
							strcat(SchematicPath,"front.bmp");
							rectfill(screen,140,250,790,600, BLACK);
							View360LoadSchematic(203+176,325,SchematicPath);
							View360LabelFrontView();
							View360Function=2;
							goto loopback;
			case F3:			if(View360Function==3) goto loopback;
							strcpy(SchematicPath,View360Path);
							strcat(SchematicPath,"\\data\\");
							strcat(SchematicPath,"side.bmp");
							rectfill(screen,140,250,790,600, BLACK);
							View360LoadSchematic(203-50,330,SchematicPath);
							View360LabelSideView();
							View360Function=3;
							goto loopback;
			case F4:			if(View360Function==4) goto loopback;
							strcpy(SchematicPath,View360Path);
							strcat(SchematicPath,"\\data\\");
							strcat(SchematicPath,"top.bmp");
							rectfill(screen,140,250,790,600, BLACK);
							View360LoadSchematic(203,253,SchematicPath);
							View360LabelTopView();
							View360Function=4;
							goto loopback;
			case F5:			if(View360Function==5) goto loopback;
							rectfill(screen,140,250,790,600, BLACK);
							View360Pirouette();
							View360Prompt(BRICK, MANGO, 498, "ROTATE");
							View360Function=5;
							goto loopback;
			case CTRL_F1: 		Screenshot792("View360.bmp");
							goto loopback;
			default: 			goto loopback;
		}
}
int View360Init()
{
	char filespec[80];
	int z;
	char mask[80];

	NumOfFrames=12;
	FrameWidth=500;
	FrameHeight=200;
	View360Function=5;

/* How many image files? */
	FrameNum=0;
	NumOfFiles=0;
	strcpy(mask,View360Path);
	strcat(mask,"\\danube\\*.jpg");
	View360FilterFiles(mask);
	View360SortFiles();
	NumOfFrames=NumOfFiles;

	strcpy(JpegPath,View360Path);
	strcat(JpegPath,"\\danube\\");

/* load and show the first frame */
	strcpy(filespec, JpegPath);
	strcat(filespec, View360FileArray[1]);
	View360ShowOneFrame();
/*	PutsLuna(140,524,BORG,BLACK, filespec); */

/* What the heck? Show the rest, and do one spin. */

	for(z=2; z<=NumOfFiles; ++z) {
		FrameNum++;
		View360ShowOneFrame();
	}

	FrameNum=1;
	View360ShowOneFrame();

	return(0);
}

int View360Mode()
{
	int Result;

	install_timer(); 
	strcpy(View360Path, LcarsPath);
	strcat(View360Path, "\\lc24apps\\view360\\");
	View360Screen();
	View360Init();
	View360Prompt(BRICK, MANGO, 498, "ROTATE");
	Result = View360WindowActive();
	remove_timer(); 
	return(Result);
}

