/* LcReader.c, to display large .txt files
	Usage: OpenTxt(char *filespec) to take a snapshot of the screen
	then restore it when the reader closes, or
	or LcReader(char *filespec) to call the reader directly
*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "lcars24.h"
#include "lcreader.h"

void ReaderRefresh(int txty)
{
	int gy, i, z;

	gy=60;
	for( z = 0; z < 17; z++) {
		rectfill(screen,46,gy,752,gy+32,BLACK);
		if(txty+z < EndText) {
			if( Ln[txty+z][0] == 33 ) {
				for( i=0; i< strlen(Ln[txty+z]); ++i)
				Highlight[i]=Ln[txty+z][i+1];
				PutsFont21(47,gy,ReaderHeadColor,strupr(Highlight));
			} else PutsFont19(47,gy,ReaderTextColor,Ln[txty+z]);
		}
		gy += 29;
	}
}
void ReaderTopOfFile(int txty)
{
	ReaderRefresh(txty);
}
void ReaderEndOfFile(txty)
{
	rectfill(screen,46,60,752,558,BLACK);
	ReaderRefresh(txty);
}
int ChangeReaderTextColor()
{
	if(ReaderTextColor==MANGO) {
		ReaderTextColor=PALEBLUE;
		ReaderHeadColor=ORANGE;
		return;
	}
	if(ReaderTextColor==PALEBLUE) {
		ReaderTextColor=PURPLE;
		ReaderHeadColor=MANGO;
		return;
	}
	if(ReaderTextColor==PURPLE) {
		ReaderTextColor=MANGO;
		ReaderHeadColor=PALEBLUE;
		return;
	}
}
int ReaderControl(char *filespec, int txty )
{
	SecondsCounter=0;

loopback:
	do {
		if(AutorunTimer()==TRUE) return(32);
		PePutTime(BIGBLUE);
	} while(!kbhit());

	c = GetKey();
	switch( c )
	{
		case LEFTARROW:
		case UPARROW:
			if(txty<1) goto loopback;
			--txty;
			ReaderRefresh(txty);
			goto loopback;
		case RIGHTARROW:
		case DOWNARROW: if(txty>=EndText-8) goto loopback;
			++txty;
			ReaderRefresh(txty);
			goto loopback;
		case HOMEKEY: if(txty<1) goto loopback;
			txty=0;
			ReaderTopOfFile(txty);
			goto loopback;
		case ENDKEY: if(txty>=EndText-14) goto loopback;
			txty=EndText-14;
			if(EndText < 17) txty=0;
			ReaderEndOfFile(txty);
			goto loopback;
		case PGUPKEY:
			if(txty<1) goto loopback;
			txty -=12;
			if(txty<0) txty = 0;
			ReaderRefresh(txty);
			goto loopback;
		case PGDNKEY: if(txty>=EndText-8) goto loopback;
			txty +=12;
			if(txty>=EndText-8) {
				txty=EndText-8;
			}
			ReaderRefresh(txty);
			goto loopback;
		case F6: ChangeReaderTextColor();
			ReaderRefresh(txty);
			goto loopback;
		case 27: SaveBookmark(filespec, txty);
			return(27);
		case 32: if(SlideshowActive==FALSE) goto loopback;
			return(32);
		case BS: if(SlideshowActive==FALSE) goto loopback;
			return(BS);
		case F12: if(SlideshowActive==FALSE) goto loopback;
			return(F12);
		case 350: Screenshot792("reader.bmp");
			goto loopback;
		default: goto loopback;
	}
}
int LcReader(char *filespec)
{
	int capX, Result, bookmark;

	rectfill(screen,0,0,800,600, BLACK);
	PopsicleSticks(LILAC);
	capX=ColorTitle(ustrupr("LCARS"),BIGBLUE);
	PutsLuna(capX,20,BLACK,LILAC,MakeDisplayName(filespec));
	min_old=70;
	PePutTime(BIGBLUE);
	UpArrowSymbol(148,566,BLACK);
	DownArrowSymbol(173,566,BLACK);
	PutsLuna(679,566, BLACK,LILAC, "CLOSE: ESC");
	PutsLuna(525,566, BLACK,LILAC, "COLORS: F6");

	ReaderHeadColor=PALEBLUE;
	ReaderTextColor=MANGO;
	bookmark=LoadBookmark(filespec);
	strcpy( CurrentFile, filespec);

	if(LoadTextFile() == 0) {
		ReaderRefresh(bookmark);
	} else {
		NormalLoadError(filespec);
		return(86);
	}
	Result=ReaderControl(filespec,bookmark);

	return(Result);
}

int OpenTxt(char *filespec)
{  /* saves the screen then restores it when LcReader closes */
	BITMAP *bmp = create_bitmap(800,600);

	int Result;

	clear_bitmap(bmp);
	blit(screen, bmp, 0, 0, 0, 0, 800, 600);
	Result=LcReader(filespec);
	rectfill(screen,0,0,800,600, BLACK);
	blit(bmp, screen, 0, 0, 0, 0, 800, 600);
	destroy_bitmap(bmp);
	min_old=70;
	return(Result);
}

