/* 	Parts.h, contains various graphics elements for LCARS 24
	PopPutTime() is for use with PopsicleSticks().
	(PopMinOld must but initialized in the calling program.
	Otherwise, the time won't be displayed until the next
	minute.)
*/
/* 	Wrapper() provides an imitation of the silvery curved
	stick-on brackets seen on Voyager's large computer
	screens.  The real purpose is to fill the rightmost
	and bottommost screen area with something when an
	800 x 600 version is runnning on a machine with a
	1024 x 768 screen.  The 800 x 600 version must set the
	graphics mode to a 1024 x 768 mode, since machines like
	the Thinkpad make a mess if you use a lower resolution.
	This wrapper exists when running on an 800 x 600 display,
	but the user doesn't see it, and it performs no actual
	function.
*/
/* 	Digits36, just some nice 10 x 36 digits (not scalable)
	So far, only 0-9, and F and O for inline button labels
	1-9, F1-F12, and "OFF," hard-coded to be called directly
	Usage example:
	int F36_1(int x,int y,int ForeColor,int BackColor)
	ForeColor must be a standard LCARS color, with BackColor
	as BLACK (could be vice versa, but isn't LCARS canon).
*/

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#ifndef PARTS_H
#define PARTS_H


#include <time.h>
#include "lccolor.h"
#include "grset.h" /* for ScreenSize */
#include "stardate.h"
#include "cropcirc.h"
#include "headline.h"
#include "winfont.h"
#include "standby.h"

typedef struct {

	char CivilianTimeStr[6];
	char AmPmStr[5];
	char MilitaryTimeStr[6];
	char SecondsStr[3];
	int Hours;
	int Minutes;
	int Seconds;

} LCARSTIME;


LCARSTIME GetTimeStr();
int AutorunTimer();
int PopPutTime(int stardate_yn);
void T24PutTime();
void PePutTime(int color);
void SolPutTime();
void GatesPutTime();
int PutTime(int x, int y, int sz);
void NorthwestCorner(int x,int y);
void SouthwestCorner(int x,int y);
void NortheastCorner(int x,int y);
void SoutheastCorner(int x,int y);
void LeftBumper36(int x,int y,int Hue);
void RightBumper36(int x,int y,int Hue);
void LeftBumper26(int x,int y,int Hue);
void RightBumper26(int x,int y,int Hue);
void PopsicleSticks(int Hue);
void Flange(int x, int Hue);
void FlangeHole(int FlangeX, int HolePos);
void MarkFlangeHole(int FlangeX, int HolePos, int Color, char *key);
void ButtonType1(int x, int y, int Hue, char *Label);
void Notchbox(int x, int y, int Hue, char *Label);
void ButtonRR(int x, int y, int Hue, char *Label);
void ButtonRS(int x, int y, int Hue, char *Label);
void ButtonSR(int x,int y, int Hue, char *Label);
void ButtonSFS(int x, int y, int Hue, char *Label);
void ButtonRFS(int x, int y, int Hue, char *Label);
void ButtonSFR(int x, int y, int Hue, char *Label);
void ButtonType2(int x,int y,int Hue1, int Hue2, char *Label);
void OfflineType2(int x,int y,int Hue, char *Label);
void ButtonType2Broken(int x,int y,int Hue1, int Hue2, char *Label);
void ButtonType3(int x,int y,int Hue1, int Hue2, char *Label);
void ButtonType3Short(int x,int y,int Hue1, int Hue2, char *Label);
void ButtonType4(int x,int y, int Hue, char *Label, char *key, int keycolor);
void OfflineType4Mini(int x,int y, int Hue, char *Label);
void BrokenType4(int x,int y, int Hue);
void OfflineType4(int x,int y, int Hue, char *Label);
void OfflineType5(int x,int y,int Hue, char *Label);
void OfflineType6(int x,int y, char *key, int keycolor);
void ButtonType5(int x,int y, int Hue, char *Label, char *key, int keycolor);
void ButtonType6(int x,int y, int Hue, char *Label, char *key, int keycolor);
void ButtonType7(int x,int y, int Hue, char *Label, char *key, int keycolor);
void EnterSymbol(int x, int y, int sz, int Fc);
void EscSymbol(int x, int y, int sz, int Fc);
void SpaceBarSymbol(int x, int y, int sz, int Fc);
void UpArrowHead(int x, int y, int Hue);
void UpArrowSymbol(int x, int y, int Hue);
void DownArrowSymbol(int x, int y, int Hue);
void LeftArrowSymbol(int x, int y, int Hue);
void RightArrowSymbol(int x, int y, int Hue);
void NorthwestArrowSymbol(int x, int y, int Hue);
void Wrapper(int radx, int rady);

/* routines for 36-point digits and the letter F for buttons */
void F36Color(int ForeColor,int BackColor);
void F36_FineFadeUp(int x, int y, int Hue, int range);
void F36_FineFadeDown(int x, int y, int Hue, int range);
void F36_FadeUp3(int x,int y);
void F36_FadeDown3(int x,int y);
void F36_1(int x,int y,int ForeColor,int BackColor);
void F36_2(int x,int y,int ForeColor,int BackColor);
void F36_3(int x,int y,int ForeColor,int BackColor);
void F36_4(int x,int y,int ForeColor,int BackColor);
void F36_5(int x,int y,int ForeColor,int BackColor);
void F36_6(int x,int y,int ForeColor,int BackColor);
void F36_7(int x,int y,int ForeColor,int BackColor);
void F36_8(int x,int y,int ForeColor,int BackColor);
void F36_9(int x,int y,int ForeColor,int BackColor);
void F36_0(int x,int y,int ForeColor,int BackColor);
void F36_O(int x,int y,int ForeColor,int BackColor);
void F36_F(int x,int y,int ForeColor,int BackColor);
void NortheastPipebend(int ex,int ey, int color);
void NorthwestPipebend(int ex,int ey, int color);
void SoutheastPipebend(int ex,int ey, int color);
void SouthwestPipebend(int ex,int ey, int color);
void Dot(int x, int y, int color);
void SchematicLabel(int tx,int ty,int px,int py,char *Str,int Col1,int Col2);
void Pipe(int x1, int y1, int x2, int y2, int Hue);
void SetCurrentFile(char *filespec);
char *MakeDisplayName(AL_CONST char *path);

#endif

