/* Planets, LCARS 24 orbital sim of six planets */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "planets.h"


void PlanetsDrawSun()
{
	circlefill(PlanetsBuf,400,300,10,makecol(117,58,58));
	circlefill(PlanetsBuf,400,300,9,makecol(159,79,79));
	circlefill(PlanetsBuf,400,300,8,ORANGE);
	circlefill(PlanetsBuf,400,300,7,NAPLES);
	circlefill(PlanetsBuf,400,300,5,WHITE);
}
void PlanetsDrawMercury(float Angle)
{
	char Dia = 1;
	int x, y;
	int Distance = 20;

	Angle=(Angle*365.256)/87.969;

	Angle += 3.9172;

	x = Distance * cos (Angle);
	y = Distance * sin (Angle);
	y = y/Tilt;
	if( y >=0 ) {
	} else if(x<-9 || x>6) circlefill(PlanetsBuf,  MercuryOldX + 400, MercuryOldY + 300, Dia, BLACK);

	if( y >=0 ) circlefill(PlanetsBuf,  x + 400, y + 300, Dia, WHITE);
	else	  putpixel(PlanetsBuf,  x + 400, y + 300, WHITE);
	MercuryOldX = x;
	MercuryOldY = y;
}
void PlanetsDrawVenus(float Angle)
{
	char Dia = 2;
	int x, y;
	int Distance = 31;

	Angle=(Angle*365.256)/244.7;
	Angle += 4.8; /* 4 */
	x = Distance * cos (Angle);
	y = Distance * sin (Angle);
	y = y/Tilt;
	Dia = 1 + y/5;
	circlefill(PlanetsBuf,  x + 400, y + 300, Dia, makecol(0x44,0x33,0x00));
	circlefill(PlanetsBuf,  x + 400, y + 300, Dia/2, makecol(146,87,0));
	putpixel(PlanetsBuf,  x + 400, y + 300, NAPLES);

	VenusOldX = x;
	VenusOldY = y;
}
void PlanetsDrawEarth(float Angle)
{
	char Dia = 4;
	int x, y;
	int Distance = 41;

	Angle += 1.1;
	x = Distance * cos (Angle);
	y = Distance * sin (Angle);
	y = y/Tilt;
	Dia = 2 + y/7;
	circlefill(PlanetsBuf,  x + 400, y + 300, Dia, makecol(87,87,154));
	circlefill(PlanetsBuf,  x + 400, y + 300, Dia/2, PALEBLUE);

	EarthOldX = x;
	EarthOldY = y;
}
void PlanetsDrawMars(float Angle)
{
	char Dia = 2;
	int x, y;
	int Distance = 57;

	Angle=(Angle*365.256)/686.98;

	Angle += .8;
	x = Distance * cos (Angle);
	y = Distance * sin (Angle);
	y = y/Tilt;

	Dia = 2.5 + y/20;

	circlefill(PlanetsBuf,  x + 400, y + 300, Dia, makecol(117,58,58));
	circlefill(PlanetsBuf,  x + 400, y + 300, Dia/2, BRICK);
	putpixel(PlanetsBuf,  x + 400, y + 300, WHITE);
	MarsOldX = x;
	MarsOldY = y;
}
void PlanetsDrawSaturn(float Angle)
{
	char Rad = 22;
	int x, y;
	int Distance = 310;
	int dx,dy,dw,dh;

	Angle=(Angle*365.256)/4332.6;

	Angle += 4.5;  /* 4.0 */
	x = Distance * cos (Angle);
	y = Distance * sin (Angle);
	y = y/2;
	Rad = 44 + y/2;

	if(Rad < 3) Rad=4;
	dw=Rad;
	dh=Rad*0.738;
	dx=SaturnOldX+400-(dw/2);
	dy=SaturnOldY+300-(dh/2);

	stretch_blit(SaturnBmp,PlanetsBuf,0,0,SaturnBmp->w,SaturnBmp->h,dx,dy,dw,dh);

	SaturnOldX = x;
	SaturnOldY = y;
}
void PlanetsDrawJupiter(float Angle)
{
	char Rad = 22;
	int x, y;
	int Distance = 160;
	int dx,dy,dw,dh;

	Angle=(Angle*365.256)/4332.6;

	Angle += 3.6;  /* 4.0 */
	x = Distance * cos (Angle);
	y = Distance * sin (Angle);
	y = y/Tilt;
	Rad = 22 + y/2;

	if(Rad < 2) Rad=2;
	dw=Rad;
	dh=Rad;
	dx=JupiterOldX+400-(dw/2);
	dy=JupiterOldY+300-(dh/2);

	stretch_blit(JupiterBmp,PlanetsBuf,0,0,JupiterBmp->w,JupiterBmp->h,dx,dy,dw,dh);

	JupiterOldX = x;
	JupiterOldY = y;
}
void PlanetsRefresh(float Angle)
{
	clear_bitmap(PlanetsBuf);
	PlanetsDrawMercury(Angle);
	PlanetsDrawVenus(Angle);
	PlanetsDrawEarth(Angle);
	PlanetsDrawMars(Angle);
	PlanetsDrawSaturn(Angle);
	PlanetsDrawJupiter(Angle);
	PlanetsDrawSun();
	rest(10);
	blit(PlanetsBuf,screen,47,50,47,50,706,500);
}
int PlanetsWindowActive()
{
	int x=50;
	int y=50;
	int length = 50;
	float Angle_stepsize = 0.0172*4;
	float Angle = 2;
	int Days = 0;
	char DaysStr[16];
	char TiltStr[16];

	Angle = 0 - (DateAdvance * Angle_stepsize);
loopback:
	PlanetsRefresh(Angle);

	itoa(Days, DaysStr, 10);
	strcat( DaysStr, " DAYS");
	rectfill(screen,400-24,13,550,39,LILAC);
	if( Days >=0) {
		PutsLuna(400-24,20,BLACK,LILAC,"+");
		PutsLuna(408-24,20,BLACK,LILAC,DaysStr);
	} else PutsLuna(400-24,20,BLACK,LILAC,DaysStr);

	do {
		Angle -= Angle_stepsize;
		Days += 4;
		if(!kbhit()) goto loopback;
	} while(!kbhit());
		c = GetKey();
		switch( c )
		{
			case 13: Angle = DateAdvance * Angle_stepsize;
				Days = 0;
				goto loopback;
			case F12: return(0);
		case LEFTARROW: Angle += Angle_stepsize*5; /* one day more than the automatic four */
				Days-=5;
				goto loopback;
		case RIGHTARROW: Angle -= Angle_stepsize;
				++Days;
				goto loopback;
		case DOWNARROW: Angle += 0.516; /* 30 days */
				Days -= 30;
				goto loopback;
		case UPARROW:  Angle -= 0.516;
				Days += 30;
				goto loopback;
		case PGDNKEY:	Angle += 6.283;
				Days -= 365.256;
				goto loopback;
		case PGUPKEY:	Angle -= 6.283;
				Days += 365.256;
				goto loopback;
			case 350: Screenshot792("Planet8.bmp");
				PanelBeep();
				goto loopback;
			case 351: Screenshot1024("Planet10.bmp");
				PanelBeep();
				goto loopback;
			default: goto loopback;
		}
}
int GetJulian(int M, int D, int Y)
{
	int JD;

	JD = (1461*(Y+4800+(M-14)/12))/4+(367*(M-2-12*((M-14)/12)))/12
-(3*((Y+4900+(M-14)/12)/100))/4+D-32075;

	return JD;
}
void PlanetsInitAngles()
{
	struct date today;
	int M, D, Y, JD;
	char DateStr[16];
	char Partial[6];

	getdate( &today);
	M = today.da_mon;
	D = today.da_day;
	Y = today.da_year;
	JD = GetJulian(M,D,Y);

	DateAdvance = JD - 2452831;

	itoa(M, DateStr, 10);
	strcat(DateStr, "/");
	itoa(D, Partial, 10);
	strcat(DateStr, Partial);
	strcat(DateStr, "/");
	itoa(Y, Partial, 10);
	strcat(DateStr, Partial);

	PutsLuna(300,20,BLACK,LILAC,DateStr);
}
int PlanetsMode()
{
	int Result;

	Tilt = 2.6;
	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LILAC);
	Title("EPHEMERIS 001");
	PutsLuna(650,566, BLACK,LILAC, "CLOSE: F12");

	PutsLuna(134-50,566,BLACK,LILAC,"ONE DAY -/+: ");
	LeftArrowSymbol(44+170-50,566,BLACK);
	PutsLuna(44+170+18+2-50,566,BLACK,LILAC,"/");
	RightArrowSymbol(44+170-50+24+6,566,BLACK);

	PutsLuna(100+134,566,BLACK,LILAC,"30 DAYS -/+: ");
	DownArrowSymbol(100+44+170,566,BLACK);
	PutsLuna(100+44+170+18+2,566,BLACK,LILAC,"/");
	UpArrowSymbol(100+44+170+24+6,566,BLACK);
	PutsLuna(250+134,566,BLACK,LILAC,"365.256 DAYS -/+: PGDN/PGUP");

	PlanetsInitAngles();
	PlanetsBuf=create_bitmap(800,800);
	JupiterBmp=load_bitmap("C:\\LCARS24\\LC24APPS\\PLANETS\\JUPITER.BMP", the_palette);
	if (!JupiterBmp) {
		destroy_bitmap(PlanetsBuf);
		rest(1000);
		NormalLoadError("C:\\LCARS24\\LC24APPS\\PLANETS\\JUPITER.BMP, SATURN.BMP");
		return(86);
	}
	SaturnBmp=load_bitmap("C:\\LCARS24\\LC24APPS\\PLANETS\\SATURN.BMP", the_palette);
	if (!SaturnBmp) {
		destroy_bitmap(PlanetsBuf);
		rest(1000);
		NormalLoadError("C:\\LCARS24\\LC24APPS\\PLANETS\\JUPITER.BMP, SATURN.BMP");
		return(86);
	}
	Result=PlanetsWindowActive();
	destroy_bitmap(PlanetsBuf);
	destroy_bitmap(JupiterBmp);
	destroy_bitmap(SaturnBmp);
	return(Result);
}
/* eof */

