/* playwav.c, for LCARS 24 voice output and beeps */
/* requries getkey.c and allegro */
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */

#include "lcars24.h"
#include "playwav.h"

int LcarsPlayWav(char *filespec)
{
	SAMPLE *the_sample;
	int pan = 128;
	int pitch = 1000;
	int progress, tracker;
	int Result, voice_num;

	if(AudioOff==TRUE) return(0);
	Result=0;
	if(BlasterOK==FALSE) return(0);
	i_love_bill=TRUE;
	if(install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) != 0) {
/*		BlasterOK=FALSE; */
		return(0);
	}
	set_volume_per_voice(0);
	set_volume(255,255);
	the_sample = load_sample(filespec);
	if (!the_sample) {
		remove_sound();
		Result=0;
		goto done;
	}
	voice_num=play_sample(the_sample, 255, pan, pitch, 0);
	if(voice_num < 0) {
/*		BlasterOK=FALSE;  		##	*/
		destroy_sample(the_sample);
		remove_sound();
		return(0);
	}
	progress=0;
	tracker=0;

	do {
		progress = voice_get_position(voice_num);
		if( progress < 0 ) goto done;
/*		if(BlasterOK==10 && tracker > 60000 && progress==0 ) { */
/* Forced muting disabled. It just bails if there is trouble. */
		if(tracker > 60000 && progress==0 ) {
		/*	BlasterOK=FALSE; */
			Result=0;
			goto done;
		}
		tracker++;
	} while(!kbhit());
	c = GetKey();
	switch( c )
		{
	 default: 	destroy_sample(the_sample);
			remove_sound();
			if(BlasterOK==10) BlasterOK=TRUE;
			return(c);
		}
done:
	destroy_sample(the_sample);
	remove_sound();
	if(BlasterOK==10) BlasterOK=TRUE;
	return(0);
}
int ScoldUser()
{ /* Majel's voice to complain if the user does something wrong */
	int WavNum, Result;
	char filespec[80] ="C:\\LCARS24\\VOICE\\";

	if(AudioOff==TRUE) return(0);
	if(EndVoiceList==0) return(0);
	WavNum=rand() % EndVoiceList;
	strcat(filespec,VoiceList[WavNum]);

	Result=LcarsPlayWav(filespec);
	return(Result);
}
int PanelBeep()
{ /* Panal beeps when entering a new screen */
	int WavNum, Result;

	if(MuteBeeps==TRUE) return(0);
	if(AudioOff==TRUE) return(0);
	char filespec[80] ="C:\\LCARS24\\WAV\\";

	if(EndBeepList==0) return(0);
	WavNum=rand() % EndBeepList;
	strcat(filespec,BeepList[WavNum]);

	Result=LcarsPlayWav(filespec);
	BeepSet=FALSE;
	return(Result);
}
void FindVoiceFiles()
{
	struct ffblk fblock;
	int Found, z;
	unsigned short t;
	char mask[80];

	for(z = 0; z < 16; ++z) memset(VoiceList[z], (null), 80);
	t=13;
	VoiceList[0][0]=(t);
	EndVoiceList=0;
	strcpy(mask, "C:\\LCARS24\\VOICE\\*.WAV");
	Found = findfirst(mask, &fblock, 0);
	while ( !Found ) {
		strcpy(VoiceList[EndVoiceList], fblock.ff_name);
		++EndVoiceList;
		if(EndVoiceList > 30) break;
		Found = findnext( &fblock );
	}
}
void FindBeepFiles()
{
	struct ffblk fblock;
	int Found, z;
	unsigned short t;
	char mask[80];

	for(z = 0; z < 16; ++z) memset(BeepList[z], (null), 80);
	t=13;
	BeepList[0][0]=(t);
	EndBeepList=0;
	strcpy(mask, "C:\\LCARS24\\WAV\\*.WAV");
	Found = findfirst(mask, &fblock, 0);
	while ( !Found ) {
		strcpy(BeepList[EndBeepList], fblock.ff_name);
		++EndBeepList;
		if(EndBeepList > 30) break;
		Found = findnext( &fblock );
	}
}
int CheckBeep()
{
	int Result=0;

	if(BeepSet==TRUE) Result=PanelBeep();
	BeepSet=FALSE;
	return(Result);
}


